/*---------------------------------------------------------------------------*
  Project:  Wireless PassBy Library - include
  File:     wpbpokemon.h

  2005 Ambrella
 *---------------------------------------------------------------------------*/
#ifndef WPBPOKEMON_H_
#define WPBPOKEMON_H_

#ifdef __cplusplus
extern "C" {
#endif

/*===========================================================================*/

#include <nitro/types.h>
#include <nitro/wm.h>

/*---------------------------------------------------------------------------*
    \̒`
 *---------------------------------------------------------------------------*/

// Q[ԋʏ
typedef struct WPBPokemonInfo {
	u32 version;        // |PDS\tgƂĂIDԍ
	u32 tryTime;        // 񂷂Ⴄ܂łɂ (b) (s -1)
	u32 tryCount;       // ݂܂ł̂Ⴂs (s -1)
	u32 successCount;   // ݂܂ł̂Ⴂ (s -1)
	u32 totalTime;      // ݂܂ł̑Ⴂs (b) (s -1)
	u16 gameName[128];  // Q[ (UTF-16LE)
	u8  image[32*32/2]; // ACRf[^
	u8  pltt[16*2];     // ACRpbg
	u8  macAddress[WM_SIZE_BSSID]; // macAddress
	u8  present;        // v[g
	u8  favoriteColor;  // Cɓ̐F ( 0 ` 15 )
	u16 sex_birth;      // ʁAaAN
	u16 nickName[ 10 ]; // jbNl[ (UTF16)
	u16 nickNameLength; // jbNl[( 0 ` 10 )
	u16 comment[ 39 ];  // Rg (UTF16)
	u16 commentLength;  // Rg( 0 ` 39 )
} WPBPokemonInfo;

/*---------------------------------------------------------------------------*
    ֐`
 *---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*
  Name:         WPB_ToPresentID

  Description:  Q[̃ACe̔ԍ 0`255  present IDɕϊB

  Arguments:    totalItems  - Q[̃ACȇ
                salt        - Q[ɂČŗĹAȂׂ̃Q[ƏdȂl ( 1 - 255 )
                itemNo      - Q[̃ACeԍ ( 0 - totalItems )

  Returns:      present IDB
 *---------------------------------------------------------------------------*/
u8 WPB_ToPresentID(u8 totalItems, u8 salt, u8 itemNo);

/*---------------------------------------------------------------------------*
  Name:         WPB_FromPresentID

  Description:  0`255  present ID Q[̃ACe̔ԍɕϊB

  Arguments:    totalItems  - Q[̃ACȇ
                salt        - Q[ɂČŗĹAȂׂ̃Q[ƏdȂl ( 1 - 255 )
                presentID   - present ID ( 0 - 255 )

  Returns:      Q[̃ACeԍ ( 0 - totalItems )
 *---------------------------------------------------------------------------*/
u8 WPB_FromPresentID(u8 totalItems, u8 salt, u8 presentID);

#ifdef  __cplusplus
}       /* extern "C" */
#endif

#endif /* WPBPOKEMON_H_ */

/*---------------------------------------------------------------------------*
  End of file
 *---------------------------------------------------------------------------*/
