//==============================================================================
/**
 * @file	contest.h
 * @brief	ReXg̃wb_
 * @author	matsuda
 * @date	2005.11.16()
 */
//==============================================================================
#ifndef __CONTEST_H__
#define __CONTEST_H__

#include "battle/battle_common.h"
#include "system/buflen.h"
#include "field/field_common.h"
#include "poketool/poke_tool.h"
#include "system/wordset.h"
#include "savedata/mystatus.h"
#include "contest/actin_ex.h"

#include "contest/contest_def.h"


//--------------------------------------------------------------
//	fobO`
//--------------------------------------------------------------
///쐬҂
#define WAIT_FIX		(0)		///<1:쐬ALB@0:܂쐬ĂȂ̂Ŗ

#define DEBUG_SIO_WAIT	(0)		///<1:ʐMpɋŃEFCg


//==============================================================================
//	萔`
//==============================================================================
///ReXgo[W
#define CONTEST_VERSION			(100)

///ReXgVXeMobt@TCY
///(e̎Mobt@ł͂ȂReXgVXe̎Mobt@ł邱Ƃɒ!)
#define CC_RECIEVE_BUF_MAX		(256)

///ReXg̃bZ[WEFCg()	check
#define CONTEST_MESSAGE_WAIT	3//(1)
///ReXg̋ʂŎgp郁bZ[WĨEBhE܂ł̃EFCg() check
#define CONTEST_MESSAGE_END_WAIT	(20)

//--------------------------------------------------------------
//	쒆̕
//--------------------------------------------------------------
enum{
	CON_CLASS_VISUAL,		///<rWA
	CON_CLASS_DANCE,		///<_X
	CON_CLASS_ACTIN,		///<Z
	CON_CLASS_RESULT,		///<ʔ\
};

//--------------------------------------------------------------
//	q[v
//--------------------------------------------------------------
///ReXgS̃VXeŎgpq[vTCY
#define CONTEST_ALLOC_SIZE		(0x1800)
///Z͕Ŏgpq[vTCY
#define ACTIN_ALLOC_SIZE		(0x70000)
///rWAŎgpq[vTCY
#define VISUAL_ALLOC_SIZE		(0x70000)
///_XŎgpq[vTCY
#define DANCE_ALLOC_SIZE		(0x70000)
///ʔ\Ŏgpq[vTCY
#define CONRES_ALLOC_SIZE		(0x70000)

///ReXg̍őQl
#define BREEDER_MAX				(4)
///ReXg̒ʐMőQl
///BREEDER_MAXƂ̈Ⴂ̓u[_[NoŊǗĂ̂BREEDER_MAXgpA
///lbgIDŊǗĂ̂CC_NETID_MAXgpĂ܂B
///2005.12.18() ݂ u[_[NolbgID ɂȂĂ̂Ōɂ͋CɂȂđvł
#define CC_NETID_MAX			(4)

///QXgR̍őQ
#define GUEST_JUDGE_MAX			(1)
///ʂ̐R̍őQ
#define NORMAL_JUDGE_MAX		(2)
///R̍őQ
#define JUDGE_MAX				(GUEST_JUDGE_MAX + NORMAL_JUDGE_MAX)

//--------------------------------------------------------------
//	o^C~O
//--------------------------------------------------------------
enum{
	HOF_BOTH,			///<
	HOF_BEFORE,			///<aOɓo
	HOF_AFTER,			///<aɓo

	//폜\̒`
	PALACE_BOTH = 0,			///<
	PALACE_BEFORE,			///<aOɓo
	PALACE_AFTER,			///<aɓo
};


//==============================================================================
//	\̒`
//==============================================================================
///ReXgZf[^
typedef struct{
	u8 ap_no;		///<As[No
	u8 contype;		///<ReXgZ^Cv(CONTYPE_STYLE)
	
	u16 dummy;
}CONWAZA_DATA;

///As[Zʃf[^
typedef struct{
	u16 setumei_u_id;	///<ZĩbZ[WID
	u16 setumei_d_id;	///<ZĩbZ[WID
	s8 ap_point;		///<As[|Cg(}CiX͖̎WQl)
	
	u16 kouka_msgid_a;	///<ZʃbZ[WIDFA
	u8 kouka_msgtag_a;	///<ZʃbZ[WID:Ã^O
	u16 kouka_msgid_b;	///<ZʃbZ[WIDFB
	u8 kouka_msgtag_b;	///<ZʃbZ[WID:B̃^O
	u16 kouka_msgid_c;	///<ZʃbZ[WIDFC
	u8 kouka_msgtag_c;	///<ZʃbZ[WID:C̃^O
	u16 kouka_msgid_d;	///<ZʃbZ[WIDFD
	u8 kouka_msgtag_d;	///<ZʃbZ[WID:D̃^O
}APWAZA_DATA;


///u[_[f[^
typedef struct{
	u32	personal_rnd;					//
	u32 id_no;							//|PID
	u32 ai;								///<AIrbg
	
	u16 obj_code;						///<tB[hOBJR[h
	u16 trainer_type;					///<g[i[^Cv
	
	u16 monsno;							///<|Pԍ(JNO)
	
	u16	waza[WAZA_TEMOTI_MAX];			///<莝Zԍ
	
	u16 nickname_id;					///<jbNl[bZ[WID
	u16 name_id;						///<u[_[bZ[WID
	
	u8 style;							//悳
	u8 beautiful;						//
	u8 cute;							//킢
	u8 clever;							//
	u8 strong;							//܂
	u8 fur;								//щ
	
	u8 rank:3;							///<Q\N
	u8 part_style:1;					///<iD悳ReXgQ\
	u8 part_beautiful:1;				///<ReXgQ\
	u8 part_cute:1;						///<ReXgQ\
	u8 part_clever:1;					///<ReXgQ\
	u8 part_strong:1;					///<痂ReXgQ\
	
	u8 appear:2;						///<o^C~O
	u8 sex:2;							///<
	u8 		:4;
	
	u8 version;							///<u[_[f[^쐬ROM̃o[W
}BREEDER_DATA;


///Rf[^
typedef struct{
	u16 name_id;					///<OID
	u16 obj_code;					///<tB[hOBJR[h
	
	u16 condition_style:2;			///<]RfBV(iD悳)
	u16 condition_beautiful:2;		///<]RfBV()
	u16 condition_cute:2;			///<]RfBV()
	u16 condition_clever:2;			///<]RfBV()
	u16 condition_strong:2;			///<]RfBV(痂)
	u16 rank:2;						///<Q\N
	u16 guest:1;					///<QXgtO(TRUE=QXg)
	u16 	:3;
}JUDGE_DATA;

//--------------------------------------------------------------
/**
 * @brief   ReXg:Q[isp[^
 *
 * ReXgisׂ̃p[^Ă܂B
 * ʐM̓T[o[q@̓f[^󂯎鎖ɂȂ܂B
 */
//--------------------------------------------------------------
typedef struct{
	POKEMON_PARAM *pp[BREEDER_MAX];	///<oꂷu[_[̃|Pf[^
	BREEDER_DATA bd[BREEDER_MAX];	///<u[_[f[^
	JUDGE_DATA jd[JUDGE_MAX];		///<Rf[^
	STRBUF *breeder_name_str[BREEDER_MAX];	///<u[_[(vC[)
	u8 player_sex[BREEDER_MAX];		///<u[_[̐
	
	u8 server_no;					///<T[o[̃u[_[ԍ
	u8 server_version;				///<T[o[̃ReXgo[W
	u8 special_judge_no;			///<RoRNo
	
	//-- 牺͎Ŏ擾\ȃf[^B͒ʐMŖႤf[^ --//
	u8 type;						///<CONTYPE_???
	u8 rank;						///<CONRANK_???
	u8 mode;						///<CONMODE_???
	u8 my_breeder_no;				///<̃u[_[ԍ
	u8 my_net_id;					///<netID
	u8 my_version;					///<̃ReXgo[W
	u8 cpu_num;						///<CPU̐
	u8 player_num;					///<vC[̐
}CONTEST_GAME_PARAM;

//--------------------------------------------------------------
/**
 * @brief   ReXgVXe[N
 *
 * ReXgŜ̐isǗׂ̃[NłB
 * e}VɌʂɍ쐬܂B
 */
//--------------------------------------------------------------
typedef struct{
	CONTEST_GAME_PARAM c_game;		///<ReXgFQ[isp[^
	POKEPARTY *poke_party;			///<莝|P̍\
	void *class_proc;				///<݂̊̕Ǘ[Nւ̃|C^
	u8 class_flag;					///<ݎs̕(CON_CLASS_???)
	u8 sio_flag;					///<TRUEFʐM
	
	u8 seq;
	int work;
	int wait;
	TCB_PTR sio_tcb;
	
	//ʐM̑Mobt@
	u8 recieve_buf[CC_NETID_MAX][CC_RECIEVE_BUF_MAX];	///<Mobt@
	u8 recieve_count;				///<Mf[^󂯎lJEg
	u8 huge_buf[1024];				///<f[^Mpobt@
}CONTEST_SYSTEM;



//==============================================================================
//	O֐錾
//==============================================================================
extern void ContestActin_FieldConnectStart(FIELDSYS_WORK *fsys);
extern void ContestVisual_FieldConnectStart(FIELDSYS_WORK *fsys);
extern void ContestDance_FieldConnectStart(FIELDSYS_WORK *fsys);
extern void ContestResult_FieldConnectStart(FIELDSYS_WORK *fsys);
extern u16 contest_rand(CONTEST_SYSTEM *consys);
extern CONTEST_SYSTEM * Contest_SystemCreate(int contest_type, int contest_rank, int contest_mode, 
	POKEMON_PARAM *my_pp, const STRBUF *player_name_str, const MYSTATUS *my_status);
extern void Contest_SystemExit(CONTEST_SYSTEM *consys);
extern void ConScr_JudgeNameGet(CONTEST_SYSTEM *consys, int judge_no, 
	WORDSET *wordset, u32 buf_id);
extern void ConScr_BreederNameGet(CONTEST_SYSTEM *consys, int breeder_no, 
	WORDSET *wordset, u32 buf_id);
extern void ConScr_NickNameGet(CONTEST_SYSTEM *consys, int breeder_no, 
	WORDSET *wordset, u32 buf_id);
extern void ConScr_RankNameGet(CONTEST_SYSTEM *consys, WORDSET *wordset, u32 buf_id);
extern void ConScr_TypeNameGet(CONTEST_SYSTEM *consys, WORDSET *wordset, u32 buf_id);
extern void ConScr_VictoryBreederNameGet(CONTEST_SYSTEM *consys, WORDSET *wordset, u32 buf_id);
extern u32 ConScr_VictoryItemNoGet(CONTEST_SYSTEM *consys);
extern BOOL Contest_SioParamInitSet(CONTEST_SYSTEM *consys);
extern BOOL Contest_SioFastDataEndCheck(CONTEST_SYSTEM *consys);
extern void EventCmd_ContestProc(GMEVENT_CONTROL * event, CONTEST_SYSTEM *consys);


#endif	//__CONTEST_H__

