//============================================================================================
/**
 * @file	poketch_data.h
 * @bfief	|Pb`f[^ANZXpwb_
 * @author	taya GAME FREAK inc.
 * @date	2005.10.27
 */
//============================================================================================
#ifndef _POKETCH_DATA_H_
#define _POKETCH_DATA_H_

#include "system/savedata_def.h"	//SAVEDATAQƂ̂

#include "poketch_app_no.h"


//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	|Pb`f[^^`
 */
//----------------------------------------------------------
typedef struct _POKETCH_DATA POKETCH_DATA;


//----------------------------------------------------------
/**
 * @brief	|Pb`ʃJ[^Cv
 */
//----------------------------------------------------------
enum {
	POKETCH_COLOR_TYPE0,
	POKETCH_COLOR_TYPE1,
	POKETCH_COLOR_TYPE2,
	POKETCH_COLOR_TYPE3,
	POKETCH_COLOR_TYPE4,
	POKETCH_COLOR_TYPE5,
	POKETCH_COLOR_TYPE6,
	POKETCH_COLOR_TYPE7,

	POKETCH_COLOR_TYPE_MAX,
};




//============================================================================================
//============================================================================================
//----------------------------------------------------------
//	Z[uf[^VXeˑ֐
//----------------------------------------------------------
extern int PoketchData_GetWorkSize(void);
extern POKETCH_DATA * PoketchData_AllocWork(u32 heapID);

//----------------------------------------------------------
//	POKETCH_DATÂ߂̊֐
//----------------------------------------------------------
extern void PoketchData_Init(POKETCH_DATA* poketch_data);
extern void PoketchData_SetPoketchGetFlag( POKETCH_DATA* poketch_data );
extern BOOL PoketchData_GetPoketchGetFlag( POKETCH_DATA* poketch_data );
extern int PoketchData_GetApplicationCount(const POKETCH_DATA * poketch_data);
extern int PoketchData_GetRestApplicationSpace( POKETCH_DATA* poketch_data );
extern BOOL PoketchData_AddApplication(POKETCH_DATA * poketch_data, int app_id);
extern int PoketchData_GetNowApplicationPos(const POKETCH_DATA* poketch_data);
extern int PoketchData_GetNowApplication(const POKETCH_DATA* poketch_data);
extern int PoketchData_SetApplicationPosNext( POKETCH_DATA* poketch_data );
extern int PoketchData_SetApplicationPosPrev( POKETCH_DATA* poketch_data );
extern void PoketchData_SetApplicationPos( POKETCH_DATA* poketch_data, int pos );
extern BOOL PoketchData_CheckApplicationRegisterd( POKETCH_DATA* poketch_data, int app_id );
extern u32  PoketchData_GetColorType( const POKETCH_DATA* poketch_data );
extern void PoketchData_SetColorType( POKETCH_DATA* poketch_data, u32 color_type );
extern u32  PoketchData_GetPedometer( const POKETCH_DATA* poketch_data );
extern void PoketchData_SetPedometer( POKETCH_DATA* poketch_data, u32 count );


extern BOOL PoketchData_GetAlarmSwitchFlag( const POKETCH_DATA* poketch_data );
extern void PoketchData_GetAlarmTime( const POKETCH_DATA* poketch_data, u32* hour, u32* min );
extern void PoketchData_SetAlarm( POKETCH_DATA* poketch_data, BOOL switch_flag, u32 hour, u32 min );


//----------------------------------------------------------
//	Z[uf[^擾̂߂̊֐
//----------------------------------------------------------
extern POKETCH_DATA * SaveData_GetPoketchData(SAVEDATA * sv);

//----------------------------------------------------------
//	fobOp
//----------------------------------------------------------
#ifdef PM_DEBUG
extern void PoketchData_AddAllApplication( POKETCH_DATA* poketch_data );
#endif


#endif //_POKETCH_DATA_H_
