//==============================================================================
/**
 *
 *@file		assert.h
 *@brief	AT[g
 *@author	taya
 *@data		2005.08.08
 *
 */
//==============================================================================
#ifndef _ASSERT_H_
#define _ASSERT_H_

/// Debug ROM łĂAT[g𖳌ɂ͂̃tOItB
#define GF_ASSERT_ENABLE



#ifdef GF_ASSERT_ENABLE	// AT[gL

	#ifdef PM_DEBUG		//  Debug ROM ł

		extern void GF_AssertProc(const char* filename, unsigned int line_no, const char* exp);
		extern void GF_AssertMsgProc( const char* filename, unsigned int lineno, const char* fmt, ... );
		#define GF_ASSERT(exp) (exp)? ((void)0) : GF_AssertProc(__FILE__, __LINE__, #exp);
		#define GF_ASSERT_MSG(exp, ...) (exp)? ((void)0) : GF_AssertMsgProc(__FILE__, __LINE__, __VA_ARGS__ );
//		#define GF_ASSERT_MSG(exp, msg) (exp)? ((void)0) : GF_AssertProc(__FILE__, __LINE__, msg);
		#define GF_ASSERT_RETURN(exp, ret) (exp)? ((void)0) : GF_AssertProc(__FILE__, __LINE__, #exp);

		// AT[g}NLɂ܂
		#define ASSERT_MACRO_ENABLED	
	#endif
#endif


// AT[g}NLɂȂP[X
#ifndef ASSERT_MACRO_ENABLED
	#define GF_ASSERT(exp)	/* */
	#define GF_ASSERT_MSG(exp,msg)	/* */
	#define GF_ASSERT_RETURN(exp, ret) \
                if(!(exp)){ \
                  return ret; \
                }
#else
#undef  ASSERT_MACRO_ENABLED
#endif


#endif
