//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		blact.h
 *	@brief		r{[hAN^[
 *	@author		tomoya takahashi
 *	@data		2005.10.05
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#ifndef __BLACT_H__
#define __BLACT_H__


#include <nnsys.h>
#include "vram_transfer_anm.h"
#include "tcb.h"
#include "res_manager.h"

#undef GLOBAL
#ifdef	__BLACT_H_GLOBAL
#define	GLOBAL	/* */
#else
#define	GLOBAL	extern
#endif

//-----------------------------------------------------------------------------
/**
 *					萔錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	AN^[wb_[f[^p
//=====================================
#define		BLACT_ANIME_TABLE_MAX (10)		// Aj[VItZbgő


//-------------------------------------
//	r{[hAN^[\̂̏
//
//	̃r{[hAN^[
//	ǂȓĂ邩
//
//	BLACT_GetState()֐Ŏ擾ł܂
//=====================================
enum
{
	BLACT_MOVE_NONE,			// f[^Ȃ
	BLACT_MOVE_INIT,			// 
	BLACT_MOVE_VRAM,			// Vram]ғ
	BLACT_MOVE_NORM,			// 풓Ajғ
};

//-------------------------------------
//	
//	Aj[VR}h
//
//	BLACT_ANIME_TBL\
//	Aj[Ve[ũAj[V^Cvł
//	
//=====================================
enum{
	BLACT_ANIM_LOOP,		// [vĐ	
	BLACT_ANIM_END,			// PĐ
	BLACT_ANIM_CMD_MAX
};

//-------------------------------------
//	
//	Aj[VԖ߂l
//	
//	BLACT_AnmFrameChg֐̖߂l
//=====================================
enum{
	BLACT_ANISTA_LOOP,	// Đ
	BLACT_ANISTA_END,	// ĐI
};

//-------------------------------------
//	
//	Vram]Ajw莚Vramkeyɓl
//	
//
//	BLACT_HEADER\̂texKey tex4x4Key plttkey
//	Ɏw肷萔
//=====================================
#define BLACT_TEXKEY_VRAMANM	(NNS_GFD_ALLOC_ERROR_TEXKEY)
#define BLACT_PLTTKEY_VRAMANM	(NNS_GFD_ALLOC_ERROR_PLTTKEY)

//-----------------------------------------------------------------------------
/**
 *					\̐錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	Aj[Ve[u\
//	
//=====================================
typedef struct {
	int start;		// Jnt[
	int end;		// It[
	int cmd;		// R}h
} BLACT_ANIME_TBL;


//-------------------------------------
//
//	r{[hwb_[f[^
//	
//=====================================	
typedef struct{
	void*  ImdRes;						//r{[hf\[X
	const NNSG3dResTex*  ItxRes;		//Aj[Vp^[eNX`[\[X
//	int  flag;							//\̃tO
	const BLACT_ANIME_TBL* anm;			// Aj[Ve[u
	TEXANM_DATATBL texanm;				// eNX`Aj[Vf[^e[u

	// 풓AĵƂ͉Ƀ|C^
	// Vram]̎
	//		BLACT_TEXKEY_VRAMANM	ieNX`L[pj
	//		BLACT_PLTTKEY_VRAMANM	ipbgL[pj
	//	w肷
	NNSGfdTexKey	texKey;		// gpeNX`L[
	NNSGfdTexKey	tex4x4Key;	// gpeNX`L[
	NNSGfdPlttKey	plttKey;	// gppbgL[
}BLACT_HEADER;

//-------------------------------------
//
//	r{[hAN^[[N|C^
//	B
//
//=====================================
typedef struct BLACT_WORK_tag* BLACT_WORK_PTR;
typedef const struct BLACT_WORK_tag* CONST_BLACT_WORK_PTR;

//-------------------------------------
//
//	r{[hAN^[Zbg|C^
//	B
//
//=====================================
typedef struct _BLACT_SET* BLACT_SET_PTR;
typedef const struct _BLACT_SET* CONST_BLACT_SET_PTR;

//-------------------------------------
//	r{[hAN^[
//		\
//=====================================
typedef struct{
	int	WorkNum;				// \̐
	int heap;					// gpq[v
}BLACT_SETDATA;

//-------------------------------------
//	r{[hAN^[
//		Abhf[^\
//=====================================
typedef struct{
	BLACT_SET_PTR	blact_s;		// r{[hAN^[Zbg
	const BLACT_HEADER* pHeader;	// r{[hAN^[wb_[
	VecFx32		matrix;				// W
	VecFx32		scale;				// gl
}BLACT_ADD;


//----------------------------------------------------------------------------
/**
 *					vg^Cv錾
 */
//-----------------------------------------------------------------------------
//=============================================================================
//
//		r{[hAN^[VXe֐S
//		
//		r{[hAN^[̃VXe𑀍삷֐
//=============================================================================
//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[VXȅ
 *
 *	@param	ContNum			Ǘr{[hAN^[Zbg
 *	@param	heap			gpq[v
 *
 *	@return none
 *
 * r{[hAN^[gpOɂPxs
 * 
 */
//-----------------------------------------------------------------------------
GLOBAL void BLACT_InitSys( int ContNum, int heap );

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[VXe̔j
 *
 *	@param	none
 *
 *	@return none
 *
 * r{[hAN^[gpɂPxKv
 * 
 */
//-----------------------------------------------------------------------------
GLOBAL void BLACT_DestSys( void );

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[VXe̕`
 *
 *	@param	none
 *
 *	@return none
 *
 * o^Ăr{[hAN^[Zbg`悵܂B
 *
 * `悵ȂƂ
 *		BLACT_SET\̂DrawFlag 0ɂ
 * 
 */
//-----------------------------------------------------------------------------
GLOBAL void BLACT_DrawSys( void );

//=============================================================================
//
//		r{[hAN^[Zbg֐S
//		
//=============================================================================
//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[Zbgݒ
 *
 *	@param	pSetData		AN^[Zbg	
 *
 *	@retval	BLACT_SET_PTR	AN^[Zbg|C^
 *	@retval	NULL			o^s
 *
 * 
 */
//-----------------------------------------------------------------------------
GLOBAL BLACT_SET_PTR BLACT_InitSet( const BLACT_SETDATA* pSetData );

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[Zbgj
 *
 *	@param	bl_set			AN^[Zbg|C^
 *
 *	@retval	TRUE			
 *	@retval	FALSE			s
 *
 * 
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL BLACT_DestSet( BLACT_SET_PTR bl_set );

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[Zbg`tOݒ
 *
 *	@param	bl_set			AN^[Zbg|C^
 *	@param	flag			ݒ肷tOl	0:` 1:`
 *
 *	@retval	TRUE			
 *	@retval	FALSE			s
 *
 * 
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL BLACT_DrawFlagSet( BLACT_SET_PTR bl_set, u8 flag );

//----------------------------------------------------------------------------
/**
 *
 *@brief	r{[hAN^[Zbg̕`tO擾
 *
 *@param	bl_set		AN^[Zbg|C^	
 *
 *@return	u8			1:`		0:`
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL u8 BLACT_DrawFlagGet( CONST_BLACT_SET_PTR bl_set );

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[Zbg̑Sr{[hj
 *
 *	@param	bl_set			AN^[Zbg|C^
 *
 *	@retval	TRUE			
 *	@retval	FALSE			s
 *
 * 
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL BLACT_DeleteWorkAllSet( BLACT_SET_PTR bl_set );

//=============================================================================
//
//		r{[hAN^[[N֐
//		
//		r{[hAN^[̌X𑀍삷֐
//=============================================================================
//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[̒ǉ
 *
 *	@param	add		r{[hAN^[o^f[^
 *
 *	@retval BLACT_WORK_PTR	o^[Ñ|C^
 *	@retval	NULL			s
 *	
 *	풓AĵƂ
 *		A`悪Jn܂B
 *		
 *	Vram]AĵƂ
 *		łBLACT_DATACHGzɃf[^ݒ肷邾ŁA
 *		ۂɓA`悪Jn̂BLACT_AfterDrawSys()֐
 *		Ă񂾌ɂȂ܂B
 */
//-----------------------------------------------------------------------------
GLOBAL BLACT_WORK_PTR BLACT_Add( const BLACT_ADD* add );

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	Aj[VZbgς
 *
 *							
 *	@param	act			`FW铮z
 *	@param	header		`FWAj[Vwb_[
 *
 *	@return none
 *
 *	풓AĵƂ
 *		A`悪Jn܂B
 *		
 *	Vram]AĵƂ
 *		łBLACT_DATACHGzɃf[^ݒ肷邾ŁA
 *		ۂɓA`悪Jn̂BLACT_AfterDrawSys()֐
 *		Ă񂾌ɂȂ܂B
 */
//-----------------------------------------------------------------------------
GLOBAL void BLACT_AnmSetChg( BLACT_WORK_PTR act, const BLACT_HEADER* header );

//----------------------------------------------------------------------------
/**
 *
 * 
 *	@brief	풓Ajp@r{[hAN^[wb_[f[^쐬x֐
 *
 *	@param	p_header		r{[hAN^[wb_[f[^i[
 *	@param	p_imd			r{[hf\[X
 *	@param	cp_itx			Aj[VeNX`\[X
 *	@param	cp_anm			Aj[Ve[u
 *	@param	cp_texanm		eNX`Aj[Vf[^e[u
 *	@param	texkey			eNX`L[
 *	@param	tex4x4key		4x4keNX`L[
 *	@param	plttkey			pbgL[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void BLACT_MakeHeaderNormalAnm( BLACT_HEADER* p_header, void* p_imd, const NNSG3dResTex* cp_itx, const BLACT_ANIME_TBL* cp_anm, const TEXANM_DATATBL* cp_texanm, NNSGfdTexKey texkey, NNSGfdTexKey tex4x4key, NNSGfdPlttKey plttkey  );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Vram]Ajp@r{[hAN^[wb_[f[^쐬x֐
 *
 *	@param	p_header		r{[hAN^[wb_[f[^i[
 *	@param	p_imd			r{[hf\[X
 *	@param	cp_itx			Aj[VeNX`\[X
 *	@param	cp_anm			Aj[Ve[u
 *	@param	cp_texanm		eNX`Aj[Vf[^e[u
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void BLACT_MakeHeaderVramAnm( BLACT_HEADER* p_header, void* p_imd, const NNSG3dResTex* cp_itx, const BLACT_ANIME_TBL* cp_anm, const TEXANM_DATATBL* cp_texanm );

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[̍폜
 *
 *	@param	del		jr{[hAN^[\
 *
 *	@retval	TRUE	(BOOL^F폜ɐ)
 *	@retval	FALSE	s
 *
 *	r{[hAN^[̃Xe[^X
 *		BLACT_MOVE_INIT
 *	̎͏̂ߔjo܂B
 *
 *	̃Xe[^XɂVram]Aj[hœo^ȂA
 *	BLACT_AfterDrawSys()֐sƃXe[^X
 *		BLACT_MOVE_VRAM
 *	ɂȂ܂B̃Xe[^XɂȂjł܂B
 *
 * BLACT_GetState()֐ŃXe[^X͎擾ł܂B
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL BLACT_Delete( BLACT_WORK_PTR del );

//----------------------------------------------------------------------------
/**
 *	@brief	r{[hAN^[[Ñ|C^擾
 *
 *	@param	set			r{[hAN^[Zbg
 *	@param	num			r{[hAN^[[NCfbNX
 *
 *	@retval BLACT_WORK_PTR	r{[hAN^[[N
 *	@retval	NULL		̃CfbNX̃[N͖
 *
 */
//-----------------------------------------------------------------------------
GLOBAL	BLACT_WORK_PTR BLACT_WorkGet( CONST_BLACT_SET_PTR set, int num );

//-----------------------------------------------------------------------------
/**
 *	@brief	BLACT_WORK\̌^f[^@NA
 *
 *	@param	pDat	BLACT_WORK\̌^f[^ւ̃|C^
 *	@return none
 */
//-----------------------------------------------------------------------------
GLOBAL void BLACT_WorkClear( BLACT_WORK_PTR pDat );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Wݒ
 *
 *	@param	act		ݒ肷AN^[
 *	@param	mat		ݒ肷W
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void BLACT_MatrixSet( BLACT_WORK_PTR act, const VecFx32* mat );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	W擾
 *
 *	@param	act		擾AN^[
 * 
 *	@return	const VecFx32*	W
 *
 */
//-----------------------------------------------------------------------------
GLOBAL const VecFx32* BLACT_MatrixGet( CONST_BLACT_WORK_PTR act );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	glݒ肷
 *
 *	@param	act		ݒ肷AN^[
 *	@param	sca		ݒ肷gl
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void BLACT_ScaleSet( BLACT_WORK_PTR act, const VecFx32* sca );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	gl擾
 *
 *	@param	act		擾AN^[
 *
 *	@return	const VecFx32*	gl
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL const VecFx32* BLACT_ScaleGet( CONST_BLACT_WORK_PTR act );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`tOݒ肷
 *
 *	@param	act		ݒ肷AN^[
 *	@param	flag	`tO	1:`	0:`
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void BLACT_ObjDrawFlagSet( BLACT_WORK_PTR act, u8 flag );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`tO擾
 *
 *	@param	act		擾AN^[
 *
 *	@return	u8		1:`	0:`
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL u8 BLACT_ObjDrawFlagGet( CONST_BLACT_WORK_PTR act );


//-----------------------------------------------------------------------------
/**
 *
 *	@brief	Aj[VItZbgύX
 *
 *	@param	act		`FW铮z
 *	@param	num		ZbgAj[VItZbgio[
 *
 *	@return	none
 *
 * ۂɊGς̂̓Aj[Vt[ύXƂłB
 * 
 * Aj[VItZbgύX̏uԂɊGς֐
 *						BLACT_AnmOffsChgRef() 
 */
//-----------------------------------------------------------------------------
GLOBAL void BLACT_AnmOffsChg( BLACT_WORK_PTR act, int num );

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	Aj[VItZbgύXƓɕύXʂɔf
 *
 *	@param	act		`FW铮z
 *	@param	num		ZbgAj[VItZbgio[
 *
 *	@return	none
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void BLACT_AnmOffsChgRef( BLACT_WORK_PTR act, int num );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Aj[VItZbg擾
 *
 *	@param	act		擾AN^[
 *
 *	@return	int		Aj[VItZbg
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int BLACT_AnmOffsGet( CONST_BLACT_WORK_PTR act );

//----------------------------------------------------------------------------
/**
 *	@brief	Aj[Vt[𓮂
 *						ۂɃAj[V[vĐƂɎgp
 *
 *	@param	act		Aj[V铮z
 *	@param	num		Aj[VXs[h
 *
 *	@retval	BLACT_ANISTA_LOOP	Đ
 *	@retval	BLACT_ANISTA_END	ĐI
 */
//-----------------------------------------------------------------------------
GLOBAL int BLACT_AnmFrameChg( BLACT_WORK_PTR act, fx32 num );

//----------------------------------------------------------------------------
/**
 *	@brief	Aj[Vt[ݒ
 *
 *	@param	act		Aj[V铮z
 *	@param	num		ݒ肷t[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
GLOBAL void BLACT_AnmFrameSet( BLACT_WORK_PTR act, fx32 num );

//----------------------------------------------------------------------------
/**
 *	@brief	Aj[Vt[擾
 *
 *	@param	act		Aj[V铮z
 *
 *	@return	fx32	Aj[Vt[
 */
//-----------------------------------------------------------------------------
GLOBAL fx32 BLACT_AnmFrameGet( CONST_BLACT_WORK_PTR act );

//----------------------------------------------------------------------------
/**
 *	@brief	ItZbgJnt[̃Aj[Vt[Zbg
 *
 *	@param	act		Aj[V铮z
 *	@param	num		Aj[VXs[h
 *
 *	@return	none
 *
 *	Aj[VItZbg̊Jnt[+num̃t[Zbg܂B
 *	AjȂ獶Aj̊Jnt[+num̃t[Zbg܂B 
 */
//-----------------------------------------------------------------------------
GLOBAL void BLACT_AnmFrameSetOffs( BLACT_WORK_PTR act, fx32 num );

//----------------------------------------------------------------------------
/**
 *	@brief	ItZbgJnt[̃Aj[Vt[擾
 *
 *	@param	act		Aj[V铮z
 *
 *	@return	fx32	Aj[Vt[
 *
 *	t[ - ݂̃Aj[VItZbgJnt[̒lԂ܂
 * 
 */
//-----------------------------------------------------------------------------
GLOBAL fx32 BLACT_AnmFrameGetOffs( CONST_BLACT_WORK_PTR act );

//----------------------------------------------------------------------------
/**
 *	@brief	ID̃r{[hf\[X擾
 *
 *	@param	pDat		f\[X擾r{[hAN^[[N
 *
 *	@return NNSG3dResMdl* f\[X
 *
 *	ŐṼf\[X擾܂B
 *		EAj[VZbg̕ύXsƂ͕ύX̃f\[X擾܂B
 *	
 */
//-----------------------------------------------------------------------------
GLOBAL NNSG3dResMdl* BLACT_MdlResGet( CONST_BLACT_WORK_PTR pDat );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	݃r{[hAN^[[N͂ǂȓsĂ邩擾
 *
 *	@param	act		r{[hAN^[[N
 *
 *	@retval	BLACT_MOVE_NONE			삵ĂȂ
 *	@retval BLACT_MOVE_INIT			
 *	@retval	BLACT_MOVE_VRAM			Vram]ғ
 *	@retval	BLACT_MOVE_NORM			풓Ajғ
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int BLACT_GetState( CONST_BLACT_WORK_PTR act );


//-----------------------------------------------------------------------------
/**
*	eVramKeyANZX֐łB
*		VramKey𑀍삷΁AFςAeNX`ςo܂B
*
*		VramKey̎擾͏풓AjAVram]Ajgp邱Ƃo܂B
*
*		VramKey̐ݒ͏풓Ajłgpł܂B
*		܂ݒ肵VramKeỷȂǂ͊OŊǗĂB
*
*		풓AjŐFς鎞ɈԂ悢Ǝv@
*			1:NNS_GfdAllocPlttVram()֐NNSGfdPlttKey擾
*			2:NNSGfdPlttKeỹAhXɃpbgf[^]
*				pbgf[^͎ŗpӂĂB
*				]gflib/vram_transfer_manager.h ̃VXegĂB
*			3:PVuNʂKvipbg]j
*			4:BLACT_SetPlttKey()֐ŃpbgL[ݒ
*			*:Fς̂߂ƂNNS_GfdFreePlttVram()֐
*			  NNSGfdPlttKeÿ̗jĂB
*
*		Vram]AjŐFς鎞ɈԂ悢Ǝv@
*			BLACT_GetPlttKeyŎ擾VramKey
*			AhXɃOtBbNf[^]@łB
*			At[𓮂āAOtBbNf[^̕ύXN
*			OtBbNf[^r{[hAN^[㏑Ă܂܂B
*
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	eNX`L[̎擾
 *
 *	@param	act r{[hAN^[[N
 *
 *	@retval	eNX`L[
 *	@retval	BLACT_TEXKEY_VRAMANM	r{[hAN^[
 *
 *	풓AĵƂ̒ӓ_
 *		VramAhXɃeNX`f[^]΁AGς܂A
 *		VramAhXĂIuWFNg̊GSĕςĂ܂܂B
 *
 *	Vram]Aj̎̒ӓ_
 *		VramAhXɃeNX`f[^]΁AGς܂A
 *		Aj[V̍XVNƃr{[hAN^[eNX`
 *		XVĂ܂̂ŁÅGɖ߂Ă܂܂B
 *
 */
//-----------------------------------------------------------------------------
GLOBAL NNSGfdTexKey BLACT_GetTexKey( CONST_BLACT_WORK_PTR act );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgL[̎擾
 *
 *	@param	act r{[hAN^[[N
 *
 *	@retval	pbgL[
 *	@retval	BLACT_PLTTKEY_VRAMANM	r{[hAN^[
 *
 *	풓AĵƂ̒ӓ_
 *		VramAhXɃpbgf[^]΁AFς܂A
 *		VramAhXĂIuWFNg̐FSĕςĂ܂܂B
 *
 *	Vram]Aj̎̒ӓ_
 *		VramAhXɃpbgf[^]΁AFς܂A
 *		pbgAjt[Aj[VɂƂ́A
 *		r{[hAN^[pbgύX܂B
 *		XVĂ܂ƁA̐Fɖ߂Ă܂܂B
 *
 */
//-----------------------------------------------------------------------------
GLOBAL NNSGfdPlttKey BLACT_GetPlttKey( CONST_BLACT_WORK_PTR act );

//----------------------------------------------------------------------------
/**
 * 풓Aj[Vp
 *
 *	@brief	eNX`L[ݒ肷
 *
 *	@param	act		r{[hAN^[[N
 *	@param	texkey	ݒ肷eNX`L[
 *
 *	@retval	TRUE	ݒ萬
 *	@retval	FALSE	ݒ莸s	iVram]Ajł͎gp邱ƂoȂłj
 *
 *	ɂOtBbNf[^ύX邱Ƃo܂B
 *	ÃOtBbNf[^ƃeNX`̍\iTCYj
 *	łȂƂƂGł܂B
 *
 *	ݒ肵texKeỷ͊OŊǗĂB
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL BLACT_SetTexKey( BLACT_WORK_PTR act, const NNSGfdTexKey* texKey );

//----------------------------------------------------------------------------
/**
 * 풓Aj[Vp
 *
 *	@brief	pbgL[ݒ肷
 *
 *	@param	act		r{[hAN^[[N
 *	@param	plttkey	ݒ肷pbgL[
 *
 *	@retval	TRUE	ݒ萬
 *	@retval	FALSE	ݒ莸s	iVram]ł͎gp邱ƂoȂłj
 *
 *	ɂpbgύX邱Ƃo܂B
 *	Ãpbgf[^ƃpbg̍\iTCYj
 *	łȂƂƂGł܂B
 *
 *	ݒ肵plttKeỷ͊OŊǗĂB
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL BLACT_SetPlttKey( BLACT_WORK_PTR act, const NNSGfdPlttKey* plttKey );

//----------------------------------------------------------------------------
/**
 *	@brief	r{[hAN^[̃JO`FbN
 *
 *	@param	act		AN^[
 *
 *	@return	u32
 */
//-----------------------------------------------------------------------------
GLOBAL u32 BLACT_CullingCheck( BLACT_WORK_PTR act );

#undef	GLOBAL
#endif		// __BLACT_H__
