//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		clact.h
 *@brief	ZAN^[
 *@author	tomoya takahashi
 *@data		2005.05.19
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#ifndef _CLACT_H__
#define	_CLACT_H__

#include <nnsys.h>

#undef	GLOBAL
#ifdef	_CLACT_H_GLOBAL
#define	GLOBAL	/* */
#else
#define	GLOBAL	extern
#endif

//-----------------------------------------------------------------------------
/**
 *					萔錾
 */
//-----------------------------------------------------------------------------

//--------------------------------------------------------------
//	OAM^Cv
//--------------------------------------------------------------
#define OAMTYPE_8x8				(0)						// OAMAN^[wb_ OAM^ 8x8
#define OAMTYPE_16x16			(1)						// 16x16
#define OAMTYPE_32x32			(2)						// 32x32
#define OAMTYPE_64x64			(3)						// 64x64
#define OAMTYPE_16x8			(4)						// 16x8
#define OAMTYPE_32x8			(5)						// 32x8
#define OAMTYPE_32x16			(6)						// 32x16
#define OAMTYPE_64x32			(7)						// 64x32
#define OAMTYPE_8x16			(8)						// 8x16
#define OAMTYPE_8x32			(9)						// 8x32
#define OAMTYPE_16x32			(10)					// 16x32
#define OAMTYPE_32x64			(11)					// 32x64

//--------------------------------------------------------------
//	OAM BGvCIeB
//--------------------------------------------------------------
#define OAMBGPRI_0				(0)
#define OAMBGPRI_1				(1)
#define OAMBGPRI_2				(2)
#define OAMBGPRI_3				(3)

//--------------------------------------------------------------
//	OAM pbgNo
//--------------------------------------------------------------
#define OAMPALNO_0				(0)
#define OAMPALNO_1				(1)
#define OAMPALNO_2				(2)
#define OAMPALNO_3				(3)
#define OAMPALNO_4				(4)
#define OAMPALNO_5				(5)
#define OAMPALNO_6				(6)
#define OAMPALNO_7				(7)
#define OAMPALNO_8				(8)
#define OAMPALNO_9				(9)
#define OAMPALNO_10				(10)
#define OAMPALNO_11				(11)
#define OAMPALNO_12				(12)
#define OAMPALNO_13				(13)
#define OAMPALNO_14				(14)
#define OAMPALNO_15				(15)

//--------------------------------------------------------------
//	OAMgkp[^ԍ
//--------------------------------------------------------------
#define OAMAFFNO_0				(0)
#define OAMAFFNO_1				(1)
#define OAMAFFNO_2				(2)
#define OAMAFFNO_3				(3)
#define OAMAFFNO_4				(4)
#define OAMAFFNO_5				(5)
#define OAMAFFNO_6				(6)
#define OAMAFFNO_7				(7)
#define OAMAFFNO_8				(8)
#define OAMAFFNO_9				(9)
#define OAMAFFNO_10				(10)
#define OAMAFFNO_11				(11)
#define OAMAFFNO_12				(12)
#define OAMAFFNO_13				(13)
#define OAMAFFNO_14				(14)
#define OAMAFFNO_15				(15)
#define OAMAFFNO_16				(16)
#define OAMAFFNO_17				(17)
#define OAMAFFNO_18				(18)
#define OAMAFFNO_19				(19)
#define OAMAFFNO_20				(20)
#define OAMAFFNO_21				(21)
#define OAMAFFNO_22				(22)
#define OAMAFFNO_23				(23)
#define OAMAFFNO_24				(24)
#define OAMAFFNO_25				(25)
#define OAMAFFNO_26				(26)
#define OAMAFFNO_27				(27)
#define OAMAFFNO_28				(28)
#define OAMAFFNO_29				(29)
#define OAMAFFNO_30				(30)
#define OAMAFFNO_31				(31)

//--------------------------------------------------------------
//	OBJLTCY 16F
//--------------------------------------------------------------
#define OBJ_CHAR_SIZE			(32)					// OBJ 1LTCY 32byte
#define OBJSIZE_8x8				(OBJ_CHAR_SIZE*1)		// 8x8LTCY
#define OBJSIZE_16x16			(OBJ_CHAR_SIZE*4)		// 16x16
#define OBJSIZE_32x32			(OBJ_CHAR_SIZE*16)		// 32x32
#define OBJSIZE_64x64			(OBJ_CHAR_SIZE*64)		// 64x64
#define OBJSIZE_16x8			(OBJ_CHAR_SIZE*2)		// 16x8
#define OBJSIZE_32x8			(OBJ_CHAR_SIZE*4)		// 32x8
#define OBJSIZE_32x16			(OBJ_CHAR_SIZE*8)		// 32x16
#define OBJSIZE_64x32			(OBJ_CHAR_SIZE*32)		// 64x32
#define OBJSIZE_8x16			(OBJ_CHAR_SIZE*2)		// 8x16
#define OBJSIZE_8x32			(OBJ_CHAR_SIZE*4)		// 8x32
#define OBJSIZE_16x32			(OBJ_CHAR_SIZE*8)		// 16x32
#define OBJSIZE_32x64			(OBJ_CHAR_SIZE*32)		// 32x64

//--------------------------------------------------------------
//	OBJLTCY 256F
//--------------------------------------------------------------
#define OBJ_CHAR_SIZE256		(64)					// OBJ 1LTCY 64byte
#define OBJSIZE256_8x8			(OBJ_CHAR_SIZE256*1)	// OBJ8x8LTCY
#define OBJSIZE256_16x16		(OBJ_CHAR_SIZE256*4)	// 16x16
#define OBJSIZE256_32x32		(OBJ_CHAR_SIZE256*16)	// 32x32
#define OBJSIZE256_64x64		(OBJ_CHAR_SIZE256*64)	// 64x64
#define OBJSIZE256_16x8			(OBJ_CHAR_SIZE256*2)	// 16x8
#define OBJSIZE256_32x8			(OBJ_CHAR_SIZE256*4)	// 32x8
#define OBJSIZE256_32x16		(OBJ_CHAR_SIZE256*8)	// 32x16
#define OBJSIZE256_64x32		(OBJ_CHAR_SIZE256*32)	// 64x32
#define OBJSIZE256_8x16			(OBJ_CHAR_SIZE256*2)	// 8x16
#define OBJSIZE256_8x32			(OBJ_CHAR_SIZE256*4)	// 8x32
#define OBJSIZE256_16x32		(OBJ_CHAR_SIZE256*8)	// 16x32
#define OBJSIZE256_32x64		(OBJ_CHAR_SIZE256*32)	// 32x64

//--------------------------------------------------------------
//	OBJL
//--------------------------------------------------------------
#define OBJNO_8x8				(1)						// 8x8OBJL1
#define	OBJNO_16x16				(4)						// 16x16
#define	OBJNO_32x32				(16)					// 32x32
#define	OBJNO_64x64				(64)					// 64x64
#define	OBJNO_16x8				(2)						// 16x8
#define	OBJNO_32x8				(4)						// 32x8
#define	OBJNO_32x16				(8)						// 32x16
#define	OBJNO_64x32				(32)					// 64x32
#define	OBJNO_8x16				(2)						// 8x16
#define	OBJNO_8x32				(4)						// 8x32
#define	OBJNO_16x32				(8)						// 16x32
#define	OBJNO_32x64				(32)					// 32x64




//-------------------------------------
/// `
//	X̃[Nɐݒ肷`tO
//	ftH̓_[`
enum{
	CLACT_DRAW_NONE,		// `悵Ȃ
	CLACT_DRAW_RENDERER,	// _[`
};

//-------------------------------------
//	
//	AtBA{pAtBAAtBȂ
//	tO
//	
//=====================================
enum{
	CLACT_AFFINE_NONE,		// AtBϊȂ
	CLACT_AFFINE_NORMAL,	// AtBϊ
	CLACT_AFFINE_DOUBLE,	// {pAtBϊ
};

//-------------------------------------
//	
//	ւ̃tbv
//	
//=====================================
enum{
	CLACT_FLIP_NONE,		// tbvȂ
	CLACT_FLIP_H,			// tbv
	CLACT_FLIP_V,			// tbv
	CLACT_FLIP_HV,			// tbv
};

//-----------------------------------------------------------------------------
/**
 *					\̐錾
 */
//-----------------------------------------------------------------------------
typedef struct _CLACT_SET*		CLACT_SET_PTR;			// ZAN^[Zbg|C^
typedef const struct _CLACT_SET* CONST_CLACT_SET_PTR;	// RXg^

typedef struct CLACT_WORK_tag*	CLACT_WORK_PTR;			// ZAN^[Zbg|C^
typedef const struct CLACT_WORK_tag* CONST_CLACT_WORK_PTR;	// ZAN^[Zbg|C^



//-------------------------------------
//
//	ZAN^[Zbg쐬֐
//						\
//
//=====================================
typedef struct{
	int		WorkNum;		// ZAN^[\̔z

	// OAM}l[W|C^
//	NNSG2dOamManagerInstance* pMainMan;
//	NNSG2dOamManagerInstance* pSubMan;

	// _[|C^
	// _[`sƂ́A
	// 쐬Ăo^ĂB
	NNSG2dRendererInstance*		pRender;			// `p Renderer
	
	int	heap;				// gpq[v
}CLACT_SETDATA;

//-------------------------------------
///	wb_[f[^	
typedef struct _CLACT_HEADER{
	const NNSG2dImageProxy*				pImageProxy;	// LN^/eNX`vLV
	const NNSG2dCharacterData*			pCharData;		// LN^f[^		iVram]̂ݕKvj
	const NNSG2dImagePaletteProxy*		pPaletteProxy;	// pbgvLV
	NNSG2dCellDataBank*					pCellBank;		// Zf[^
    const NNSG2dCellAnimBankData*       pAnimBank;		// ZAj[V		iƂNULLj
	const NNSG2dMultiCellDataBank*      pMCBank;		// }`Zf[^			iƂNULLj
    const NNSG2dMultiCellAnimBankData*  pMCABank;		// }`ZAj[V	iƂNULLj
	
	int  flag;				//]AjmFp̃tO
	u8	 priority;			// BGʂƂ̗Dx

}CLACT_HEADER;

typedef struct _CLACT_HEADER*	CLACT_HEADER_PTR;		// ZAN^[wb_[|C^

//-------------------------------------
//
//	ZAN^[o^\
//
//=====================================
typedef struct{
	CLACT_SET_PTR	ClActSet;	// ZAN^[Zbg
	const CLACT_HEADER*	ClActHeader;// wb_[f[^
	VecFx32				mat;		// W		
	VecFx32				sca;		// gl
	u16					rot;		// ]		(0`65535)
	u32					pri;		// D揇
	int					DrawArea;	// `
		// mainɓo^FNNS_G2D_VRAM_TYPE_2DMAIN
		// subɓo^ FNNS_G2D_VRAM_TYPE_2DSUB

	int					heap;		// gpq[v
}CLACT_ADD;

//-------------------------------------
//
//	ZAN^[Vvo^\
//
//=====================================
typedef struct{
	CLACT_SET_PTR	ClActSet;	// ZAN^[Zbg
	const CLACT_HEADER*	ClActHeader;// wb_[f[^
	VecFx32				mat;		// W
	u32					pri;		// D揇
	int					DrawArea;	// `
		// mainɓo^FNNS_G2D_VRAM_TYPE_2DMAIN
		// subɓo^ FNNS_G2D_VRAM_TYPE_2DSUB
	

	int					heap;		// gpq[v
}CLACT_ADD_SIMPLE;

//----------------------------------------------------------------------------
/**
 *					vg^Cv錾
 */
//-----------------------------------------------------------------------------
//=============================================================================
//
//		AN^[Zbg֐
//
//=============================================================================
//-----------------------------------------------------------------------------
/**
 *@brief			ZAN^[Zbg̏
 *
 *@param	pSetData		ZAN^[Zbg쐬f[^
 *
 *@retval	CLACT_SET_PTR			쐬ZAN^[Zbg̃|C^
 *@retval	NULL					s
 *
 * ZAN^[Zbg쐬
 *
 */
 //----------------------------------------------------------------------------
GLOBAL CLACT_SET_PTR CLACT_InitSet( const CLACT_SETDATA* pSetData );

//-----------------------------------------------------------------------------
/**
 *@brief			ZAN^[Zbg̔j
 *
 *@param	ClActSet			jZAN^[Zbg|C^
 *
 *@retval	TRUE	
 *@retval	FALSE	s	(ClActSetNULL)
 *
 * ZAN^[Zbgj
 *		sĂAN^[IuWFĉ
 *
 */
 //----------------------------------------------------------------------------
GLOBAL BOOL CLACT_DestSet( CLACT_SET_PTR ClActSet );

//-----------------------------------------------------------------------------
/**
 *@brief			ZAN^[Zbg̕`tOݒ
 *
 *@param	ClActSet			jZAN^[Zbg|C^
 *@param	flag				0:`	1:`
 *
 *@retval	TRUE	
 *@retval	FALSE	s	(ClActSetNULL)
 *
 *	o^ĂZSĂ`/`悷邩ݒ
 *
 */
 //----------------------------------------------------------------------------
GLOBAL BOOL CLACT_DrawFlagSet( CLACT_SET_PTR ClActSet, u8 flag );

//-----------------------------------------------------------------------------
/**
 *@brief				`悷
 *
 *@param	pClAct		ZAN^[Zbg
 *
 *@return	none
 */
 //----------------------------------------------------------------------------
GLOBAL void CLACT_Draw( CONST_CLACT_SET_PTR pClAct );

//----------------------------------------------------------------------------
/**
 *
 *@brief	o^Ă郌_[擾
 *
 *@param	pClAct			ZAN^[
 *
 *@retval	NNSG2dRendererInstance*		OAM}l[W
 *@retval	NULL						ݒ肳ĂȂ
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL NNSG2dRendererInstance* CLACT_RenderGet( CONST_CLACT_SET_PTR pClAct);

//----------------------------------------------------------------------------
/**
 *
 *@brief	_[ݒ
 *
 *@param	pClAct		ZAN^[
 *@param	pRender		_[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_RenderSet( CLACT_SET_PTR pClAct, NNSG2dRendererInstance* pRender);


//-----------------------------------------------------------------------------
/**
 *@brief			SAN^[j
 *
 *@param	ClActSet		ZAN^[ZbgCfbNX
 *
 *@retval	TRUE	
 *@retval	FALSE	s	(ClActSetIdxNULL)
 */
 //----------------------------------------------------------------------------
GLOBAL BOOL CLACT_DelAllSet( CLACT_SET_PTR ClActSet );


//=============================================================================
//
//		ZAN^[[N֐
//
//=============================================================================
//-----------------------------------------------------------------------------
/**
 *@brief		ZAN^[f[^
 *						
 *
 *@param	pWork		(0 Clear)f[^
 *
 *@return	none
 *
 */
 //----------------------------------------------------------------------------
GLOBAL void CLACT_WorkClear( CLACT_WORK_PTR pWork );

//-----------------------------------------------------------------------------
/**
 *@brief		ZAN^[[N̎擾
 *						
 *
 *@param	ClActSetIdx		ZAN^[ZbgCfbNX
 *@param	ClActIdx		ZAN^[[NCfbNX
 *
 *@retval	CLACT_WORK_PTR	
 *@retval	NULL			s
 *
 */
//----------------------------------------------------------------------------
GLOBAL CLACT_WORK_PTR CLACT_GetWork(CONST_CLACT_SET_PTR ClActSet, s16 ClActIdx);

//-----------------------------------------------------------------------------
/**
 *@brief			ǉ
 *
 *@param	add		o^f[^
 *
 *@retval	CLACT_WORK_PTR		o^AN^[|C^
 *@retval	NULL				s
 */
// ----------------------------------------------------------------------------
GLOBAL CLACT_WORK_PTR CLACT_Add(const CLACT_ADD* add);

//-----------------------------------------------------------------------------
/**
 *@brief			Vvǉ
 *
 *@param	add		o^f[^
 *
 *@retval	CLACT_WORK_PTR		o^AN^[|C^
 *@retval	NULL				s
 */
// ----------------------------------------------------------------------------
GLOBAL CLACT_WORK_PTR CLACT_AddSimple(const CLACT_ADD_SIMPLE* add);

//-----------------------------------------------------------------------------
/**
 *@brief			폜
 *
 *@param	del		폜AN^[[N
 *
 *@return	none
 * 
 */
// ----------------------------------------------------------------------------
GLOBAL void CLACT_Delete(CLACT_WORK_PTR del);

//----------------------------------------------------------------------------
/**
 *
 *@brief	Wݒ
 *
 *@param	act			AN^[
 *@param	Matrix		W
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_SetMatrix(CLACT_WORK_PTR act, const VecFx32* Matrix);

//----------------------------------------------------------------------------
/**
 *
 *	@brief	AtBϊWݒ
 *
 *	@param	act			AN^[
 *	@param	Matrix		AtBϊ𔽉fItZbgW
 *
 *	@return	none
 *
 * AN^[ɐݒ肳ĂW + AtBϊW
 * ̈ʒuŉ]gks܂B
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_SetAffineMatrix(CLACT_WORK_PTR act, const VecFx32* Matrix);

//----------------------------------------------------------------------------
/**
 *
 *@brief	glݒ
 *
 *@param	act		AN^[
 *@param	Scale	gl
 *
 *@return	none
 *
 * ݒ肵ĂAtBtO
 *	CLACT_AFFINE_NORMALCLACT_AFFINE_DOUBLEłȂƔf܂B
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_SetScale(CLACT_WORK_PTR act, const VecFx32* Scale);

//----------------------------------------------------------------------------
/**
 *
 *@brief	glݒ肵AAtBtOݒ肷
 *
 *@param	act		AN^[
 *@param	Scale	gl
 *@param	affine	AtBtO
 *
 *@return	none
 *
 *affinetO
 *	enum{
 *		CLACT_AFFINE_NONE,		// AtBϊȂ
 *		CLACT_AFFINE_NORMAL,	// AtBϊ
 *		CLACT_AFFINE_DOUBLE,	// {pAtBϊ
 *	};
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_SetScaleAffine(CLACT_WORK_PTR act, const VecFx32* Scale, int affine);

//----------------------------------------------------------------------------
/**
 *
 *@brief	]pݒ
 *
 *@param	act			AN^[
 *@param	Rotation	]p		(0`65535)
 *
 *@return	none
 *
 * ݒ肵ĂAtBtO
 *	CLACT_AFFINE_NORMALCLACT_AFFINE_DOUBLEłȂƔf܂B
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_SetRotation(CLACT_WORK_PTR act, u16 Rotation);

//----------------------------------------------------------------------------
/**
 *
 *@brief	]pݒ肵ăAtBtOݒ
 *
 *@param	act			AN^[
 *@param	Rotation	]p		(0`65535)
 *@param	affine		AtBtO
 *
 *@return	none
 *
 *affinetO
 *	enum{
 *		CLACT_AFFINE_NONE,		// AtBϊȂ
 *		CLACT_AFFINE_NORMAL,	// AtBϊ
 *		CLACT_AFFINE_DOUBLE,	// {pAtBϊ
 *	};
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_SetRotationAffine(CLACT_WORK_PTR act, u16 Rotation, int affine);

//----------------------------------------------------------------------------
/**
 *
 *@brief	`tOݒ
 *
 *@param	act		AN^[
 *@param	flag	`tO	0:`	1:_[`
 *
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_SetDrawFlag(CLACT_WORK_PTR act, int flag);

//----------------------------------------------------------------------------
/**
 *
 *@brief	I[gAjtOݒ
 *
 *@param	act		AN^[
 *@param	flag	I[gAjtO	0:Aj	1:I[gAj
 *
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_SetAnmFlag(CLACT_WORK_PTR act, int flag);

//----------------------------------------------------------------------------
/**
 *
 *@brief	I[gAj[Vt[ݒ
 *
 *@param	act		AN^[
 *@param	frame	PVNɐi߂t[
 *
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_SetAnmFrame(CLACT_WORK_PTR act, fx32 frame);

//----------------------------------------------------------------------------
/**
 *
 *	@brief	AtBϊp[^
 *
 *	@param	act		AN^[
 *	@param	param	AtBϊp[^
 *
 *	@return	none
 *
 * param
 *	enum{
 *		CLACT_AFFINE_NONE,		// AtBϊȂ
 *		CLACT_AFFINE_NORMAL,	// AtBϊ
 *		CLACT_AFFINE_DOUBLE,	// {pAtBϊ
 *	};
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_SetAffineParam( CLACT_WORK_PTR act, int param );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	tbv̐ݒ
 *
 *	@param	act		AN^[
 *	@param	flag	tbvtO 
 *
 *	@return	none
 *
 * flag
 *	enum{
 * 		CLACT_FLIP_NONE,		// tbvȂ
 * 		CLACT_FLIP_H,			// tbv
 *		CLACT_FLIP_V,			// tbv
 *		CLACT_FLIP_HV,			// tbv
 *	};
 *
 *	"AtBϊtOCLACT_AFFINE_NONEɂ܂"
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_SetFlip( CLACT_WORK_PTR act, int flag );

//----------------------------------------------------------------------------
/**
 *
 *@brief	W擾
 *
 *@param	act		AN^[
 *
 *@return	VecFx32	W
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL const VecFx32* CLACT_GetMatrix(CONST_CLACT_WORK_PTR act);

//----------------------------------------------------------------------------
/**
 *
 *@brief	AtBϊW擾
 *
 *@param	act		AN^[
 *
 *@return	VecFx32	W
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL const VecFx32* CLACT_GetAffineMatrix(CONST_CLACT_WORK_PTR act);

//----------------------------------------------------------------------------
/**
 *
 *@brief	gl擾
 *
 *@param	act		AN^[
 *
 *@return	VecFx32	gl
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL const VecFx32* CLACT_GetScale(CONST_CLACT_WORK_PTR act);

//----------------------------------------------------------------------------
/**
 *
 *@brief	]px擾
 *
 *@param	act		AN^[
 *
 *@return	u16		]px	(0`65535)
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL u16 CLACT_GetRotation(CONST_CLACT_WORK_PTR act);

//----------------------------------------------------------------------------
/**
 *
 *@brief	`tO擾
 *
 *@param	act	AN^[
 *
 *@return	int		0:`	1:`
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int CLACT_GetDrawFlag(CONST_CLACT_WORK_PTR act);

//----------------------------------------------------------------------------
/**
 *
 *@brief	I[gAjtO擾
 *
 *@param	act	AN^[
 *
 *@return	int		0:Aj	1:I[gAj[V
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int CLACT_GetAnmFlag(CONST_CLACT_WORK_PTR act);

//----------------------------------------------------------------------------
/**
 *
 *@brief	I[gAj[Vt[擾
 *
 *@param	act	AN^[
 *
 *@return	fx32		PVNɐi߂t[
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL fx32 CLACT_GetAnmFrame(CONST_CLACT_WORK_PTR act);

//----------------------------------------------------------------------------
/**
 *
 *	@brief	AtBp[^	擾
 *
 *	@param	act		AN^[
 *
 *	@return	int		AtBp[^
 *
 * ret
 *	enum{
 *		CLACT_AFFINE_NONE,		// AtBϊȂ
 *		CLACT_AFFINE_NORMAL,	// AtBϊ
 *		CLACT_AFFINE_DOUBLE,	// {pAtBϊ
 *	};
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int CLACT_GetAffineParam( CONST_CLACT_WORK_PTR act );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	tbvݒ擾
 *
 *	@param	act		AN^[
 *
 *	@return	int		tbvݒ
 *
 * ret
 *	enum{
 * 		CLACT_FLIP_NONE,		// tbvȂ
 * 		CLACT_FLIP_H,			// tbv
 *		CLACT_FLIP_V,			// tbv
 *		CLACT_FLIP_HV,			// tbv
 *	};
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int CLACT_GetFlip( CONST_CLACT_WORK_PTR act );

//-----------------------------------------------------------------------------
/*
 * ɃAj[VV[PXύX܂B
 * 
 *@brief	Aj[ṼV[PX`FW
 *
 *@param	actCellFZAN^[
 *@param	numFV[PXio[
 *
 *@return	none
 *
 *	V[PXio[łV[PXύXst[OAj
 *	͂߂܂B
 * 
 */
 //----------------------------------------------------------------------------
GLOBAL void CLACT_AnmChg( CLACT_WORK_PTR actCell, u32 num );

//-----------------------------------------------------------------------------
/*
 * Aj[VV[PXύX܂B
 * 
 *@brief	Aj[ṼV[PX`FW
 *
 *@param	actCellFZAN^[
 *@param	numFV[PXio[
 *
 *@return	none
 *
 * Aj[VV[PXƂ͉s܂B
 *
 */
 //----------------------------------------------------------------------------
GLOBAL void CLACT_AnmChgCheck( CLACT_WORK_PTR actCell, u32 num );

//----------------------------------------------------------------------------
/**
 *
 *@brief	݂̃Aj[VV[PX擾
 *
 *@param	actCell		AN^[
 *
 *@return			Aj[VV[PXio[
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL u32 CLACT_AnmGet( CONST_CLACT_WORK_PTR actCell );

//-----------------------------------------------------------------------------
/**	
 *@brief	Aj[V
 *
 *@param	actCellF\
 *@param	numFt[i߂l
 *
 *@return	none
 */
 //----------------------------------------------------------------------------
GLOBAL void CLACT_AnmFrameChg( CLACT_WORK_PTR actCell, fx32 num );

//-----------------------------------------------------------------------------
/**	
 *@brief	Aj[Vt[Zbg
 *
 *@param	actCellF\
 *@param	numFZbgAj[Vt[
 *
 *@return	none
 */
//----------------------------------------------------------------------------
GLOBAL void CLACT_AnmFrameSet( CLACT_WORK_PTR actCell, u16 num );

//-----------------------------------------------------------------------------
/**	
 *@brief				Aj[Vt[擾
 *
 *@param	actCellF\
 *
 *@return	̃t[
 */
//----------------------------------------------------------------------------
GLOBAL u16 CLACT_AnmFrameGet( CONST_CLACT_WORK_PTR actCell);


//-----------------------------------------------------------------------------
/**
 *@brief	BGʂƂ̗DxύX
 *
 *@param	actCellF\
 *@param	PriorityFDx
 *
 *@return	none
 */
 //----------------------------------------------------------------------------
GLOBAL void CLACT_BGPriorityChg( CLACT_WORK_PTR actCell, u8 Priority );

//----------------------------------------------------------------------------
/**
 *
 *@brief	BGʂƂ̕`Dx擾
 *
 *@param	actCell		AN^[
 *
 *@return	u8			Dx
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL u8 CLACT_BGPriorityGet( CONST_CLACT_WORK_PTR actCell);

//-----------------------------------------------------------------------------
/**
 * OAM̃pbgio[悤ɂȂ܂B
 *
 *@brief				pbgio[ύX
 *
 *@param	actCell			\
 *@param	pltt_num		ύXpbgio[
 * 
 *@return	none
 *
 * pbgio[ݒƃpbgItZbgݒ͓܂B
 *@@pbgio[ݒ肷ƃItZbg̒l͔fȂȂ܂B
 *	@ItZbglݒ肵Ƃ̓pbgio[fȂȂ܂B
 * 
 */
 //----------------------------------------------------------------------------
GLOBAL void CLACT_PaletteNoChg( CLACT_WORK_PTR actCell, u32 pltt_num );

//-----------------------------------------------------------------------------
/**
 * CLACT_PaletteNoChǧʂɃpbg]擪io[Z܂B
 *
 *@brief				pbgio[ύX
 *
 *@param	actCell			\
 *@param	pltt_num		ύXpbgio[
 * 
 *@return	none
 *
 * pbgio[ݒƃpbgItZbgݒ͓܂B
 *@@pbgio[ݒ肷ƃItZbg̒l͔fȂȂ܂B
 *	@ItZbglݒ肵Ƃ̓pbgio[fȂȂ܂B
 * 
 */
 //----------------------------------------------------------------------------
GLOBAL void CLACT_PaletteNoChgAddTransPlttNo( CLACT_WORK_PTR actCell, u32 pltt_num );

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgio[擾
 *
 *@param	actCell		AN^[
 *
 *@return	u32		̃pbgio[
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL u32 CLACT_PaletteNoGet( CONST_CLACT_WORK_PTR actCell );

//-----------------------------------------------------------------------------
/**
 * OAMAgr[gɐݒ肳Ăpbgio[ɉZ܂B
 *	 AOAMAgr[g̃J[pbgNoQŃItZbgɂQ
 *	 ݒ肷ƁAS̃J[pbgQƂ悤ɂȂ܂
 * 
 *@brief	pbgItZbgݒ
 *
 *@param	actCell		\
 *@param	pltt_num	pbgItZbgio[
 * 
 *@return	none
 *
 * pbgio[ݒƃpbgItZbgݒ͓܂B
 *@@pbgio[ݒ肷ƃItZbg̒l͔fȂȂ܂B
 *	@ItZbglݒ肵Ƃ̓pbgio[fȂȂ܂B
 * 
 */
 //----------------------------------------------------------------------------
GLOBAL void CLACT_PaletteOffsetChg( CLACT_WORK_PTR actCell, u32 pltt_num );

//----------------------------------------------------------------------------
/**
 * CLACT_PaletteOffsetChg֐̌ʂɃpbg̓]擪pbgio[Z܂B
 *
 *@brief	pbgItZbgݒ
 *
 *	@param	act		AN^[
 *
 *	@return	pbgio[
 *
 *
 * pbgio[ݒƃpbgItZbgݒ͓܂B
 *@@pbgio[ݒ肷ƃItZbg̒l͔fȂȂ܂B
 *	@ItZbglݒ肵Ƃ̓pbgio[fȂȂ܂B
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_PaletteOffsetChgAddTransPlttNo( CLACT_WORK_PTR act, u32 pltt_num );

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgItZbgl擾
 *
 *@param	actCell		AN^[
 *
 *@return	u32		̃pbgItZbgl
 *
 */
//-----------------------------------------------------------------------------
GLOBAL u32 CLACT_PaletteOffsetGet( CONST_CLACT_WORK_PTR actCell );

//-----------------------------------------------------------------------------
/**
 *@brief	`D揇ʂݒ
 *
 *@param	actCell		\
 *@param	Priority	D揇
 *				
 * 
 *@return	none
 */
 //----------------------------------------------------------------------------
GLOBAL void CLACT_DrawPriorityChg( CLACT_WORK_PTR actCell, u32 Priority );

//----------------------------------------------------------------------------
/**
 *
 *@brief	`D揇ʂ擾
 *
 *@param	actCell		AN^[
 *
 *@return	u32			`D揇
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL u32 CLACT_DrawPriorityGet( CONST_CLACT_WORK_PTR actCell );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	vNVf[^ݒ
 *
 *	@param	act			AN^[
 *	@param	pImageProxy	ݒ肷C[WvNV
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_ImageProxySet( CLACT_WORK_PTR act, const NNSG2dImageProxy* pImageProxy );

//----------------------------------------------------------------------------
//
/**
 *
 *	@brief	vNVf[^擾
 *
 *	@param	act			AN^[
 *
 *	@return	AN^[ĂC[WvNV
 */
//-----------------------------------------------------------------------------
GLOBAL NNSG2dImageProxy * CLACT_ImageProxyGet( CLACT_WORK_PTR act );


//--------------------------------------------------------------
/**
 * @brief	vNVf[^ݒ
 *
 * @param	act	
 * @param	PaletteProxy	
 *
 * @retval	GLOBAL void	
 *
 */
//--------------------------------------------------------------
GLOBAL void CLACT_PaletteProxySet( CLACT_WORK_PTR act, const NNSG2dImagePaletteProxy*  PaletteProxy);

//--------------------------------------------------------------
/**
 * @brief	vNVf[^擾
 *
 * @param	act	
 *
 * @retval	AN^[ĂvNV
 *
 */
//--------------------------------------------------------------
GLOBAL NNSG2dImagePaletteProxy * CLACT_PaletteProxyGet( CLACT_WORK_PTR act );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	UCNݒ
 *
 *	@param	act		AN^[[N
 *	@param	flag	tO	TRUEUCNON	FALSEUCNOFF
 *
 *	@return	none
 *
 * UCNOFF̎łAjgLN^ŃUCNONɂOAM
 * UCNĕ`悳܂B
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_MosaicSet( CLACT_WORK_PTR act, BOOL flag );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	UCNݒԂ擾
 *
 *	@param	act		AN^[[N
 *
 *	@retval	TRUE	UCNON
 *	@retval	FALSE	UCNOFF	ijgLN^Őݒ肵ĂƂ͔fj
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL CLACT_MosaicGet( CONST_CLACT_WORK_PTR act );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VRAM^Cv擾
 *
 *	@param	act		AN^[[N
 *
 *	@retval	VRAM^Cv
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL NNS_G2D_VRAM_TYPE CLACT_VramTypeGet( CONST_CLACT_WORK_PTR act );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	AN^[Aj[V`FbN
 *
 *	@param	act		AN^[[N
 *
 *	@retval	TRUE	Aj[V
 *	@retval	FALSE	Xgbv
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL CLACT_AnmActiveCheck( CLACT_WORK_PTR act );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	IuWF[hݒ
 *
 *	@param	act			AN^[[N
 *	@param	objmode		IuWF[h 
 *
 *	@return	none
 *
 *	IuWF[hGX_OAM_MODE_NORMALɂNitroCharacterŐݒ肵
 *	IuWF[hŕ`悳܂B
 *	
	GX_OAM_MODE_NORMAL		m[}OBJ 
	GX_OAM_MODE_XLU			OBJ 
	GX_OAM_MODE_OBJWND		OBJEBhE 
	GX_OAM_MODE_BITMAPOBJ	rbg}bvOBJ 
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_ObjModeSet( CLACT_WORK_PTR act, GXOamMode objmode );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	IuWF[h擾
 *
 *	@param	act		AN^[[N
 *
 *	@retval	GX_OAM_MODE_NORMAL		m[}OBJ 
 *	@retval	GX_OAM_MODE_XLU			OBJ 
 *	@retval	GX_OAM_MODE_OBJWND		OBJEBhE 
 *	@retval	GX_OAM_MODE_BITMAPOBJ	rbg}bvOBJ 
 *
 *	IuWF[hGX_OAM_MODE_NORMAL̎NitroCharacterŐݒ肵
 *	IuWF[hŕ`悳܂B
 *
 */
//-----------------------------------------------------------------------------
GLOBAL GXOamMode CLACT_ObjModeGet( CONST_CLACT_WORK_PTR act );

//----------------------------------------------------------------------------
/**
 *					O[oϐ錾
 */
//-----------------------------------------------------------------------------

#undef	GLOBAL
#endif

