//==============================================================================
/**
 *
 *@file		heapsys.h
 *@brief	q[v̈Ǘ
 *@author	taya
 *@data		2005.08.25
 *
 */
//==============================================================================
#ifndef __HEAPSYS_H__
#define __HEAPSYS_H__

#include <nnsys.h>

//==============================================================
/**
 *	{q[v쐬p[^\
 */
//==============================================================
typedef struct {
	u32        size;		///< q[vTCY
	OSArenaId  arenaID;		///< 쐬A[iID
}HEAP_INIT_HEADER;



//------------------------------------------------------------------
/**
 * q[vVXeivONɂPxĂ΂j
 *
 * @param   header			{q[v\̂ւ̃|C^
 * @param   baseHeapMax		{q[v
 * @param   heapMax			{q[vE[U[q[vv
 *
 * @retval  extern void		
 */
//------------------------------------------------------------------
extern void sys_InitMemory(const HEAP_INIT_HEADER* header, u32 baseHeapMax, u32 totalHeapMax);


//------------------------------------------------------------------
/**
 * q[v쐬
 *
 * @param   parentHeapID		̈mۗpq[vhciɗLłKvj
 * @param   childHeapID			VKɍ쐬q[vhc
 * @param   size				q[vTCY
 *
 * @retval	BOOL				TRUEō쐬^FALSEŎs
 */
//------------------------------------------------------------------
extern BOOL sys_CreateHeap( u32 parentHeapID, u32 childHeapID, u32 size );


//------------------------------------------------------------------
/**
 * q[vj
 *
 * @param   heapID		q[vID
 *
 */
//------------------------------------------------------------------
extern void sys_DeleteHeap( u32 heapID );


//------------------------------------------------------------------
/*
 * 	m
 *
 *	sys_AllocMemory ̓q[v̐擪󂫗̈Tă蓖ĂB
 *	sys_AllocMemoryLo ̓q[v̌󂫗̈Tă蓖ĂB
 *
 *	VRAM]ÕOtBbNf[^ꎞIǂݍݗ̈ȂǁAɉ̈
 *	sys_AllocMemoryLo ŊmۂΗ̈̒fЉNÂ炭Ȃ͂B
 */
//------------------------------------------------------------------

#ifndef PM_DEBUG
extern void* sys_AllocMemory( u32 heap, u32 size );
extern void* sys_AllocMemoryLo( u32 heap, u32 size );
#else


// fobOrhɂ̓}NŃbvČĂяo\[XnĂ

extern void* sys_AllocMemoryDebug( u32 heap, u32 size, const char* filename, u32 line_num );
extern void* sys_AllocMemoryLoDebug( u32 heap, u32 size, const char* filename, u32 line_num );
#define sys_AllocMemory(h,s)	sys_AllocMemoryDebug((h),(s),__FILE__,__LINE__);
#define sys_AllocMemoryLo(h,s)	sys_AllocMemoryLoDebug((h),(s),__FILE__,__LINE__);

#endif


//------------------------------------------------------------------
/*
 * 	
 *
 *  mێu32wb_ɕۑ邽߁Aɂ͕svB
 *  ʏ sys_FreeMemoryEz gΖȂB
 *
 *  sys_FreeMemory ́̕Aꉞ̂܂܂̃C^[tF[XŎcĂ
 *
 */
//------------------------------------------------------------------
extern void sys_FreeMemoryEz( void* memory );
extern void sys_FreeMemory( u32 heap, void* memory );


//------------------------------------------------------------------
/*
 * 	q[v擾
 */
//------------------------------------------------------------------
extern u32 sys_GetHeapFreeSize( u32 heap );
extern u32 sys_GetHeapAllocatedSize( u32 heap );

//------------------------------------------------------------------
/*
 * 	AP[^[쐬iNitroSystem Cun֐vꍇj
 */
//------------------------------------------------------------------
extern void sys_InitAllocator( NNSFndAllocator* pAllocator, u32 heap, int alignment);


//------------------------------------------------------------------
/**
 * mۂubÑTCYkB
 *
 * @param   memBlock		ubN|C^
 * @param   newSize			k̃TCYioCgPʁj
 *
 *
 * ḱAubŇ烁邱ƂōsB
 * ꂽ̓VXeɕԊ҂AVȃAP[g̈ƂĎgpłB
 *
 * Ⴆ΁ywb_{́ẑ悤Ȍ`̃OtBbNoCiq`lɓǂݍ݁A
 * ̕VRAMɓ]Awb_݂̂cƂP[XȂǂŎgp邱Ƃ
 * z肵ĂBgp͐TdɁB
 *
 */
//------------------------------------------------------------------
extern void sys_CutMemoryBlockSize( void* memBlock, u32 newSize );


//------------------------------------------------------------------
/*
 * 	q[v擾ifobÔݗLj
 */
//------------------------------------------------------------------
#ifdef PM_DEBUG
extern BOOL sys_CheckHeapSafe( u32 heap );
extern void sys_PrintHeapFreeSize( u32 heapID );
extern u64 sys_GetHeapState( u32 heapID );
extern void sys_PrintHeapConflict( u32 heap, u32 assertionMemSize ); 
extern u32 sys_GetMemoryBlockSize( const void* memBlock );
#endif


//------------------------------------------------------------------
/*
 * 	ȒP[N`FbN
 *
 *  ֐𒼐ڌĂԂ̂ł͂ȂA}NgiiŃRpCɖ邽߁j
 *
 *  g
 *  vÔ鎞_ HeapStatePush ĂԁiSq[v̏󋵂X^bNɐς܂jB
 *  q[v̏󋵂̎_ƈv͂AƂ^C~OŁA
 *  HeapStatePop ĂсiSq[v̏󋵂X^bN|bvjA
 *  HeapStateCheck gāAq[v̌݃󋵂|bvꂽlƔrB
 *
 *  lvȂ΁Ãq[vŎgĂS󋵂fobKɏo͂B
 *
 */
//------------------------------------------------------------------
#define HeapStatePush()		/* */
#define HeapStatePop()		/* */
#define HeapStateCheck(h)	/* */




#endif	// __HEAPSYS_H__
