//============================================================================================
/**
 * @file	sleep.h
 * @brief	X[v[hݒ
 * @author	Hiroyuki Nakamura
 * @date	2005.02.28
 */
//============================================================================================
#ifndef SLEEP_H
#define SLEEP_H
#undef GLOBAL
#ifdef SLEEP_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	V{`
//============================================================================================
// X[vtO
enum {
	GF_SLEEP_MODE = 0,		// 
	GF_SLEEP_HOLD			// s
};

// R[obNݒ
enum {
	GF_SLEEP_CB_BEFORE = 0,		// ڍs / 擪
	GF_SLEEP_CB_AFTER			// A / 
};

// X[vVXef[^
typedef struct {
	PMSleepCallbackInfo	b_info;		// ڍs̃R[obN
	PMSleepCallbackInfo	a_info;		// ÃR[obN

	PMWakeUpTrigger	trigger;		// X[vԂ̕Av
	PMLogic			logic;			// L[݂ŕAꍇ̃L[̑gݍ킹_
	u16				keyPattern;		// L[݂ŕAꍇ̃L[

	u16				heap:15;		// q[vID
	u16				hold:1;			// X[vtO
}GF_SLEEP_SYS;


//============================================================================================
//	O[oϐ
//============================================================================================


//============================================================================================
//	vg^Cv錾
//============================================================================================

//============================================================================================
//	ݒ
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * X[vf[^̈mہA
 *
 * @param	heap	q[vID
 *
 * @return	X[vf[^̈
 */
//--------------------------------------------------------------------------------------------
GLOBAL GF_SLEEP_SYS * GF_SleepSystemInit( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * VXe
 *
 * @param	dat		X[vf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_SleepSystemDelete( GF_SLEEP_SYS * dat );

//--------------------------------------------------------------------------------------------
/**
 * X[ṽgK[ݒ
 *
 * @param	dat		X[vf[^
 * @param	trg		X[vԂ̕Av
 * @param	logic	L[݂ŕAꍇ̃L[̑gݍ킹_
 * @param	pat		L[݂ŕAꍇ̃L[
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_SleepTriggerSet(
				GF_SLEEP_SYS * dat, PMWakeUpTrigger trg, PMLogic logic, u16 pat );

//--------------------------------------------------------------------------------------------
/**
 * X[vf[^ݒ
 *
 * @param	dat		X[vf[^
 *
 * @return	none
 *
 * @li	dat->hold : GF_SLEEP_MODE = X[v
 * @li	X[vsɂɂGF_SleepModeSet(GF_SLEEP_HOLD)ĂԂ
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_SleepSystemSetAll( GF_SLEEP_SYS * dat );

//--------------------------------------------------------------------------------------------
/**
 * ؂ւ
 *
 * @param	dat		X[vf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_GoSleepMode( GF_SLEEP_SYS * dat );

//--------------------------------------------------------------------------------------------
/**
 * ؂ւ
 *
 * @param	dat		X[vf[^
 * @param	flg		GF_SLEEP_MODE = , GF_SLEEP_HOLD = s
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_SleepModeSet( GF_SLEEP_SYS * dat, u8 flg );


//============================================================================================
//	R[obN
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * R[obNZbg
 *
 * @param	dat		X[vf[^
 * @param	info	R[obN
 * @param	type	ǉ^Cv ( GF_SLEEP_CB_BEFORE = ڍs, GF_SLEEP_CB_AFTER = A )
 * @param	mode	ǉ[h ( GF_SLEEP_CB_BEFORE = 擪, GF_SLEEP_CB_AFTER =  )
 *
 * @return	none
 *
 * @li	ł͕o^͏o܂
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_SleepCallBackAdd(
				GF_SLEEP_SYS * dat, PMSleepCallbackInfo * info, u8 type, u8 mode );

//--------------------------------------------------------------------------------------------
/**
 * R[obN폜
 *
 * @param	dat		X[vf[^
 * @param	id		폜^Cv ( GF_SLEEP_CB_BEFORE = ڍs, GF_SLEEP_CB_AFTER = A )
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_SleepCallBackDel( GF_SLEEP_SYS * dat, u8 id );


//============================================================================================
//	{̂̊JŃX[v
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * {̂̊JŃX[v^XNZbg
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_SleepCoverCloseAdd( GF_SLEEP_SYS * dat );


#undef	GLOBAL
#endif	/* SLEEP_H */
