
#ifndef __SYSTEM_H__
#define __SYSTEM_H__

///#define DEBUG_PRINT	//fobO\ꍇ́ARg͂
#include <nitro.h>
#include <nnsys.h>

#include "gflib\heapsys.h"
#include "gflib\tcb.h"
#include "system\heapdefine.h"
#include "system\tcbman.h"


/*---------------------------------------------------------------------------*
  File:     system.h
 *---------------------------------------------------------------------------*/
#undef GLOBAL
#ifdef __SYSTEM_H_GLOBAL__
#define GLOBAL /*	*/
#else
#define GLOBAL extern
#endif



#define XtOffset(p_type,field)     ((unsigned int)&(((p_type )NULL)->field))
#define	NELEMS(array)	( sizeof(array) / sizeof(array[0]) )
#define	ALIGN4 __attribute__((aligned(4)))
#define ROUND_UP(value, alignment) \
    (((u32)(value) + (alignment-1)) & ~(alignment-1))
#define ROUND_DOWN(value, alignment) \
    ((u32)(value) & ~(alignment-1))


#ifdef PM_DEBUG
#define TPRINTF(fmt, ...) \
	OS_TPrintf("%s:%d: " fmt, __FILE__, __LINE__, __VA_ARGS__)
#else
#define TPRINTF(fmt, ...) \
	((void)0)
#endif


/*
 * @brief	荞݊֐p|C^^
 */
typedef void (*INTR_FUNC)(void *);

typedef void (*pFunc)(void);	// ֐|C^^
typedef int (*appFunc)(int command, void* set_up, void* rep);	// Av֐|C^^
enum {
	APP_ON = 0,
	APP_BUSY = 1,
	APP_END = -1,
};
enum {
	APP_INIT_REQ = 0,
	APP_ON_REQ = 1,
	APP_PAUSE_REQ = 2,
	APP_END_REQ = -1,
};

enum {
	DISP_3D_TO_MAIN = 0,
	DISP_3D_TO_SUB = 1,
};

//------------------- ` -----------------------------------------
typedef	struct {
//	pFunc	pMainProc;		// CʃvZXĂяo֐|C^
//	pFunc	pReturnProc;	// 菈ɕÅ֐|C^
//	appFunc pSubProc;		// AvP[VĂяo֐|C^

	INTR_FUNC pVBlank;		// uuNݓĂяo֐|C^
	void * pVBlankWork;		// uuNݓĂяo֐p[Nւ̃|C^
	INTR_FUNC pHBlank;		// guNݓĂяo֐|C^
	void * pHBlankWork;		// guNݓĂяo֐p[Nւ̃|C^
	pFunc pVCount;			// uJEgݓĂяo֐|C^
	pFunc pSio;				// rhnݓĂяo֐|C^

	TCBSYS*  mainTCBSys;	// C[vpTCB(30fps)
	TCBSYS*  vintrTCBSys;	// Vblank荞ݗpTCB
	TCBSYS*  vwaitTCBSys;	// VBlankQI30fpspTCB
	TCBSYS*  printTCBSys;	// o͏p,VBlank҂OɉғTCB

	u32* main_timer;			// ^C}[(\tg)pJE^|C^
	u32 vsync_counter;			// uuNpJE^
	u32 vsync_flame_counter;	// t[pJE^

	int cont;				// L[
	int trg;				// L[gK
	int game_cont;			// L[(Q[ݒɂϊ)
	int game_trg;			// L[gK(Q[ݒɂϊ)
	int repeat;				// L[s[g
	int repeatWait;			// L[s[gJE^

	u16		tp_x;			// ^b`plXW
	u16		tp_y;			// ^b`plYW
	u16		tp_trg;			// ^b`plڐGgK
	u16		tp_cont;		// ^b`plڐG
	u8		tp_auto_samp;	// ^b`plI[gTvOtO(0:TvOĂȂ@1:TvO)


//	u8 mainSys_sequence;	// V[PXp[N
	u8 disp3DSW;			// Rc\fBXvCXCb`
	u8 dummy[3];

}SystemArea;


//==================================================================
//	O[oϐ
//==================================================================
GLOBAL SystemArea sys;						// VXe\[X

//==================================================================
//	֐
//==================================================================
GLOBAL void sys_InitSystem(void);
GLOBAL void sys_InitVRAM(void);
GLOBAL void sys_InitKeyRead(void);

//==================================================================
//	ftHg荞݊֐
//==================================================================

// HBlankݒ
extern void sys_HBlankIntrStop( void );
extern BOOL sys_HBlankIntrSet( INTR_FUNC func, void * work );

//==================================================================
//	[eBeB[֐
//==================================================================


//VuNĂяo֐̓o^
GLOBAL void sys_VBlankFuncChange(INTR_FUNC func, void * work);

//	t@C[h֐
GLOBAL void* sys_LoadFile( int mode, const char *path);
GLOBAL void * sys_LoadFileEx( int mode, const char * path, u32 * siz );
GLOBAL void* sys_LoadGraphFile(const char *path, const u8 inMode);
GLOBAL void sys_LoadFileNoMem(const char *path,void **mem);
/*---------------------------------------------------------------------------*
  Name:         sys_LoadFileDiv

  Description:  ʏt@C̓ǂݍݕ 
  
  Arguments:    mode	wq[v̈`
				path	t@Cւ̃pX
				memory	t@CǂݍݐAhXi[|C^
				offset	ǂݍ݃ItZbgi[|C^
				divsiz	ǂݍݕTCY
Returns:		0:pA1=I
 *---------------------------------------------------------------------------*/
GLOBAL int sys_LoadFileDiv( int mode, const char * path, void** memory, u32* offset, u16 divsiz );

/*---------------------------------------------------------------------------*
  Name:         sys_LoadFileDivNoMem

  Description:  ʏt@C̓ǂݍݕ(mۂȂ)
  
  Arguments:    path	t@Cւ̃pX
				memory	t@CǂݍݐAhXi[|C^
				offset	ǂݍ݃ItZbgi[|C^
				divsiz	ǂݍݕTCY
Returns:		0:pA1=I
 *---------------------------------------------------------------------------*/
GLOBAL int sys_LoadFileDivNoMem( const char * path, void** memory, u32* offset, u16 divsiz );
#if 0
/*---------------------------------------------------------------------------*
  @brief	OtBbNpt@C\[X̉

  @param	addr	(void*)郊\[XAhX
  @param	free	TRUEȂ΁ALbVo^Ă郊\[Xł
					FALSȄꍇALbVo^ĂΉȂ
  @retval	0		
  @retval	1		LbV
  @retval	2		LbVo^Ă̂Ŕ
  @retval	0xFF	p[^s
 *---------------------------------------------------------------------------*/
GLOBAL s8 sys_FreeGraphFile(void* addr,u8 free);
#endif
	//	L[擾֐
GLOBAL void sys_MainKeyRead(void);

// L[s[g̑xƃEFCgZbg
GLOBAL void sys_KeyRepeatSpeedSet( int speed, int wait );

/**
 * @brief	t@Ct@CLbVp̃nbVl擾
 * @param   path	t@C
 * @retval  u32		
 */
GLOBAL u32 CreateFileHash(const char *path);

//==============================================================================
/**
 * ɃLbVƂđ݂Ă邢邩
 * @param   hash	t@C擾nbVl
 * @retval  int		0`:z̗vf	-1:Ȃ
 */
//==============================================================================
GLOBAL int SearchFileCache(u32 hash);

//==============================================================================
/**
 * Vǂݍ񂾃t@CLbVƂēo^
 *
 * @param   memory		Vmۂ̃AhX
 * @param   hash		t@C擾nbVl
 *
 * @retval  int			o^ԍ
 */
//==============================================================================
GLOBAL int SetBlankCache(void* memory, u32 hash);

//==============================================================================
/**
 * LbV̑SEnbṼNA
 * @param   none		
 * @retval  none		
 */
//==============================================================================
GLOBAL void ClearFileCache(void);

//==============================================================================
/**
 * @brief	nbVzNULL
 */
//==============================================================================
GLOBAL void InitFileCache(void);

//==============================================================================
/**
 * @brief	̃nbVNA(L[w)
 *
 * @param   hash	t@C擾nbVl
 *
 * @retval  int		0`:폜vfIndex	-1:폜Ȃ
 */
//==============================================================================
GLOBAL int ClearFileCacheKey(u32 hash);

//==============================================================================
/**
 * @brief	̃nbVNA(AhXw)
 *
 * @param   addr	\[X̃AhX
 *
 * @retval  int		0`:폜vfIndex	-1:폜Ȃ
 */
//==============================================================================
GLOBAL int ClearFileCacheAddr(void* addr);

#undef GLOBAL


#endif
