//*****************************************************************************
/**
 *
 *@file		touchpanel.h
 *@brief	^b`plf[^
 *@author	tomoya takahashi
 *@data		2005.03.16
 */
//*****************************************************************************

#ifndef __TOUCHPANEL_H__
#define	__TOUCHPANEL_H__

#undef	GLOBAL
#ifdef	__TOUCHPANEL_H_GLOBAL__
#define	GLOBAL	/* */
#else
#define	GLOBAL	extern
#endif

//-----------------------------------------------------------------------------
/**
 *					萔錾
 */
//-----------------------------------------------------------------------------
#define		RECT_HIT_END	(0xff)			// IR[h
#define		RECT_HIT_NONE	(0xffffffff)	// e[uȂ

#define		TP_HIT_END		(0xff)			// e[uȂ
#define		TP_USE_CIRCLE	(0xfe)			// ~`ƂĎg
#define		TP_HIT_NONE		(0xffffffff)	// e[uȂiRECT_HIT_NONE͂j

//-----------------------------------------------------------------------------
/**
 *					\̐錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	`f[^\
//=====================================
typedef union{
	struct {
		u8	top;	// i͓R[hj
		u8	bottom;	// 
		u8	left;	// 
		u8	right;	// E
	}rect;

	struct {
		u8	code;	// TP_USE_CIRCLE w
		u8	x;
		u8	y;
		u8	r;
	}circle;

}RECT_HIT_TBL, TP_HIT_TBL;

/*
 * gp
 *
 * RECT_HIT_TBL rect_data[] ={
 *		{0,64,0,128},				// zvfD揇:0>1>2>3>4>.....ł
 *		{128,191,0,64},
 *		{32,94,129,200},
 *		{0,191,0,255},
 *      {TP_USE_CIRCLE, 100, 80, 16 },	// ~`ƂĎgB
 *		{TP_HIT_END,0,0,0},		// If[^
 * };
 * 
 */


//----------------------------------------------------------------------------
/**
 *					vg^Cv錾
 */
//----------------------------------------------------------------------------
GLOBAL int GF_TP_RectHitCont( const RECT_HIT_TBL* pRectTbl );
GLOBAL int GF_TP_RectHitTrg( const RECT_HIT_TBL *pRectTbl );
GLOBAL int GF_TP_HitCont( const TP_HIT_TBL *tbl );
GLOBAL int GF_TP_HitTrg( const TP_HIT_TBL *tbl );
GLOBAL BOOL GF_TP_SingleHitCont( const TP_HIT_TBL *tbl );
GLOBAL BOOL GF_TP_SingleHitTrg( const TP_HIT_TBL *tbl );
GLOBAL BOOL GF_TP_GetCont( void );
GLOBAL BOOL GF_TP_GetTrg( void );
GLOBAL int GF_TP_RectHitContSelf( const RECT_HIT_TBL* pRectTbl, u32 x, u32 y );
GLOBAL int GF_TP_HitSelf( const TP_HIT_TBL *tbl, u32 x, u32 y );
GLOBAL BOOL GF_TP_SingleHitSelf( const TP_HIT_TBL *tbl, u32 x, u32 y );
GLOBAL BOOL GF_TP_GetPointCont( u32* x, u32* y );
GLOBAL BOOL GF_TP_GetPointTrg( u32* x, u32* y );


#undef	GLOBAL
#endif

