//=============================================================================
/**
 * @file	myitem.h
 * @brief	莝ACepwb_
 * @author	tamada
 * @author	hiroyuki nakamura
 * @date	2005.10.13
 */
//=============================================================================
#ifndef	__MYITEM_H__
#define	__MYITEM_H__

#include "system/savedata_def.h"
#include "application/bag_def.h"

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	莝ACe^`
 */
//----------------------------------------------------------
typedef struct _MYITEM MYITEM;

//============================================================================================
//============================================================================================
//----------------------------------------------------------
//	Z[uf[^VXeˑ֐
//----------------------------------------------------------
extern int MyItem_GetWorkSize(void);
extern MYITEM * MyItem_AllocWork(int heapID);
extern void MyItem_Copy(const MYITEM * from, MYITEM * to);

//----------------------------------------------------------
//	MYITEM̂߂̊֐
//----------------------------------------------------------
extern void MyItem_Init(MYITEM * item);
extern BOOL MyItem_AddCheck( MYITEM * myitem, u16 item_no, u16 num, u32 heap );
extern BOOL MyItem_AddItem(MYITEM * myitem, u16 item_no, u16 num, u32 heap);
extern BOOL MyItem_SubItem( MYITEM * myitem, u16 item_no, u16 num, u32 heap );
extern BOOL MyItem_SubItemDirect( MINEITEM * myitem, u32 max, u16 item_no, u16 num, u32 heap );
extern BOOL MyItem_CheckItem( MYITEM * myitem, u16 item_no, u16 num, u32 heap );
extern u16 MyItem_GetItemNum( MYITEM * myitem, u16 item_no, u32 heap );
extern void MyItem_SortSpace( MINEITEM * item, const u32 max );
extern void MyItem_SortNumber( MINEITEM * item, const u32 max );
extern BOOL MyItem_CheckItemPocket( MYITEM * myitem, u32 pocket );
extern MINEITEM * MyItem_PosItemGet( MYITEM * myitem, u16 pocket, u16 pos );
extern void MyItem_BattlePocketItemMake( MYITEM * myitem, MINEITEM * make[], u32 heap );


//----------------------------------------------------------
//	obO쐬֐
//----------------------------------------------------------
extern void * MyItem_MakeBagData( MYITEM * myitem, const u8 * list, u32 heap );

//----------------------------------------------------------
//	Z[uf[^擾̂߂̊֐
//----------------------------------------------------------
extern MYITEM * SaveData_GetMyItem(SAVEDATA * sv);


//	fobOpKɎ莝ACe֐
extern void Debug_MyItem_MakeBag(MYITEM * myitem, int heapID);
#endif	/* __MYITEM_H__ */
