//============================================================================================
/**
 * @file	nuts.h
 * @bfief	؂̎f[^
 * @author	Hiroyuki Nakamura
 * @date	06.01.27
 */
//============================================================================================
#ifndef NUTS_H
#define NUTS_H
#undef GLOBAL
#ifdef NUTS_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


#include "itemsym.h"


//============================================================================================
//	萔`
//============================================================================================
typedef struct _NUTS_DATA	NUTSDATA;				// ؂̎f[^

#define	NUTS_START_ITEMNUM	( ITEM_KURABONOMI )		// ACeԍ̍ŏ̖؂̎

// p[^擾`
enum {
	NUTS_PRM_SIZE = 0,			// 傫
	NUTS_PRM_HARDNESS,			// 
	NUTS_PRM_MAGNIFICATION,		// ̔{
	NUTS_PRM_SPEED,				// x
	NUTS_PRM_ABSORPTION,		// ̋z
	NUTS_PRM_KARAI,				// h
	NUTS_PRM_SIBUI,				// a
	NUTS_PRM_AMAI,				// Â
	NUTS_PRM_NIGAI,				// ꂳ
	NUTS_PRM_SUPPAI,			// _ς
	NUTS_PRM_UMAI,				// |
};


//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ؂̎f[^[h
 *
 * @param	id		؂̎ԍ
 * @param	heap	q[vID
 *
 * @return	؂̎f[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL NUTSDATA * Nuts_DataLoad( u32 id, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * ؂̎f[^[hiACeԍj
 *
 * @param	item	ACeԍ
 * @param	heap	q[vID
 *
 * @return	؂̎f[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL NUTSDATA * Nuts_DataLoadItem( u32 item, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * ؂̎p[^擾
 *
 * @param	dat		؂̎f[^
 * @param	prm		擾p[^ID
 *
 * @return	擾p[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 Nuts_ParamGet( NUTSDATA * dat, u32 prm );

//--------------------------------------------------------------------------------------------
/**
 * ؂̎擾
 *
 * @param   buf			i[
 * @param	id			؂̎ԍ
 * @param   heap		q[vIDie|ƂĎgpj
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void NutsNameGet( STRBUF * buf, u16 id, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * ؂̎擾ïmہj
 *
 * @param	id			؂̎ԍ
 * @param   heap		q[vIDie|ƂĎgpj
 *
 * @return	擾؂̎̃obt@
 *
 * @li	͊e
 */
//--------------------------------------------------------------------------------------------
GLOBAL STRBUF * NutsNameGetAlloc( u16 id, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * ؂̎擾iACeԍj
 *
 * @param   buf			i[
 * @param	item		ACeԍ
 * @param   heap		q[vIDie|ƂĎgpj
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void NutsNameGet_Item( STRBUF * buf, u16 item, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * ؂̎擾iACeԍjïmہj
 *
 * @param	item		ACeԍ
 * @param   heap		q[vIDie|ƂĎgpj
 *
 * @return	擾؂̎̃obt@
 *
 * @li	͊e
 */
//--------------------------------------------------------------------------------------------
GLOBAL STRBUF * NutsNameGetAlloc_Item( u16 item, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * 擾
 *
 * @param   buf			i[
 * @param	id			؂̎ԍ
 * @param	heap		q[vIDie|ƂĎgpj
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void NutsInfoGet( STRBUF * buf, u16 id, u16 heap );

//--------------------------------------------------------------------------------------------
/**
 * 擾ïmہj
 *
 * @param	id			؂̎ԍ
 * @param	heap		q[vIDie|ƂĎgpj
 *
 * @return	擾؂̎̃obt@
 *
 * @li	͊e
 */
//--------------------------------------------------------------------------------------------
GLOBAL STRBUF * NutsInfoGetAlloc( u16 id, u16 heap );

//--------------------------------------------------------------------------------------------
/**
 * 擾iACeԍj
 *
 * @param   buf			i[
 * @param	item		ACeԍ
 * @param	heap		q[vIDie|ƂĎgpj
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void NutsInfoGet_Item( STRBUF * buf, u16 item, u16 heap );

//--------------------------------------------------------------------------------------------
/**
 * 擾iACeԍjïmہj
 *
 * @param	item		ACeԍ
 * @param	heap		q[vIDie|ƂĎgpj
 *
 * @return	擾؂̎̃obt@
 *
 * @li	͊e
 */
//--------------------------------------------------------------------------------------------
GLOBAL STRBUF * NutsInfoGetAlloc_Item( u16 item, u16 heap );

#undef GLOBAL
#endif	/* NUTS_H */
