//============================================================================================
/**
 * @file	pokeparty.h
 * @brief	|Pp[eB
 * @author	tamada	GAME FREAK Inc.
 * @date	2005.10.13
 *
 * |Pp[eB[Ƃ͎ΐ푊̎莝ȂǁÃ|PЂƂ܂Ƃ
 * ꍇɎgpB
 * 莝Ƀ|PA邢͎莝OAʒuւȂǂ̑
 * POKEPARTYΏۂƂčsB
 */
//============================================================================================

#ifndef	__POKEPARTY_H__
#define	__POKEPARTY_H__

#include "system/savedata_def.h"	//SAVEDATAQƂ̂
#include "poketool/poke_tool.h"

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @param	|Pp[eB^`
 */
//----------------------------------------------------------
typedef struct _POKEPARTY POKEPARTY;

//============================================================================================
//============================================================================================
//----------------------------------------------------------
//	Z[uf[^VXeˑ֐
//----------------------------------------------------------
extern int PokeParty_GetWorkSize(void);
extern POKEPARTY * PokeParty_AllocPartyWork(u32 heapID);
extern void PokeParty_InitWork(POKEPARTY * party);

//----------------------------------------------------------
//	POKEPARTŶ߂̊֐
//----------------------------------------------------------
extern void PokeParty_Init(POKEPARTY * party, int max);
extern POKEMON_PARAM * PokeParty_GetMemberPointer(const POKEPARTY * party, int pos);
extern BOOL PokeParty_Add(POKEPARTY * party, POKEMON_PARAM * poke);
extern BOOL PokeParty_Delete(POKEPARTY * party, int pos);
BOOL PokeParty_ExchangePosition(POKEPARTY * party, int pos1, int pos2);
extern void PokeParty_Copy(const POKEPARTY * src, POKEPARTY * dst);
extern int PokeParty_GetPokeCount(const POKEPARTY* party);
extern void PokeParty_SetMemberData( POKEPARTY* party, int pos, POKEMON_PARAM* pp );

extern void Debug_PokeParty_MakeParty(POKEPARTY * party);
//----------------------------------------------------------
//	Z[uf[^擾̂߂̊֐
//----------------------------------------------------------
extern POKEPARTY * SaveData_GetTemotiPokemon(SAVEDATA * sv);

#endif	/* __POKEPARTY_H__ */

