//============================================================================================
/**
 * @file	config.h
 * @brief	ݒf[^ANZXpwb_
 * @author	tamada GAME FREAK inc.
 * @date	2006.01.26
 */
//============================================================================================
#ifndef __CONFIG_H__
#define __CONFIG_H__

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	ݒf[^^`
 */
//----------------------------------------------------------
typedef struct _CONFIG CONFIG;

//----------------------------------------------------------
/**
 */
//----------------------------------------------------------
typedef enum {
	MSGSPEED_SLOW = 0,		///<bZ[W\uv
	MSGSPEED_NORMAL,		///<bZ[W\uӂv
	MSGSPEED_FAST,			///<bZ[W\u͂₢v
	MSGSPEED_MAX,			///<
}MSGSPEED;

//----------------------------------------------------------
//----------------------------------------------------------
typedef enum {
	WAZAEFF_MODE_ON = 0,		///<퓬Aju݂v
	WAZAEFF_MODE_OFF,			///<퓬Aju݂Ȃv
	WAZAEFF_MODE_MAX,			///<
}WAZAEFF_MODE;

//----------------------------------------------------------
//----------------------------------------------------------
typedef enum {
	BATTLERULE_IREKAE = 0,
	BATTLERULE_KACHINUKI,
	BATTLERULE_MAX,
}BATTLERULE;

//----------------------------------------------------------
//----------------------------------------------------------
typedef enum {
	SOUNDMODE_STEREO = 0,	///<TEho=uXeIv
	SOUNDMODE_MONO,			///<TEho=umv
//	SOUNDMODE_HEADPHONE,	///<TEho=uwbhzv06.02.14p~ iwasawa
	SOUNDMODE_MAX,			///<
}SOUNDMODE;

//----------------------------------------------------------
//----------------------------------------------------------
typedef enum {
	INPUTMODE_NORMAL = 0,	///<{^ݒ聁um[}v
	INPUTMODE_L_A,			///<{^ݒ聁uk`v
	INPUTMODE_MAX,			///<
}INPUTMODE;

//----------------------------------------------------------
//----------------------------------------------------------
typedef enum{
	WINTYPE_01,
	WINTYPE_02,
	WINTYPE_03,
	WINTYPE_04,
	WINTYPE_05,
	WINTYPE_06,
	WINTYPE_07,
	WINTYPE_08,
	WINTYPE_09,
	WINTYPE_10,
	WINTYPE_MAX,
}WINTYPE;

//============================================================================================
//============================================================================================
//----------------------------------------------------------
//	Z[uf[^VXeˑ֐
//----------------------------------------------------------
extern int CONFIG_GetWorkSize(void);
extern CONFIG * CONFIG_AllocWork(u32 heapID);
extern void CONFIG_Copy(const CONFIG * from, CONFIG * to);

//----------------------------------------------------------
//	CONFIĜ߂̊֐
//----------------------------------------------------------
extern void CONFIG_Init(CONFIG * cfg);


//	͂Ȃ̂͂₳
extern MSGSPEED CONFIG_GetMsgSpeed(const CONFIG * cfg);
extern void CONFIG_SetMsgSpeed(CONFIG * cfg, MSGSPEED speed);
//	Ƃ@Aj
extern WAZAEFF_MODE CONFIG_GetWazaEffectMode(const CONFIG * cfg);
extern void CONFIG_SetWazaEffectMode(CONFIG * cfg, WAZAEFF_MODE mode);

//	́@[
extern BATTLERULE CONFIG_GetBattleRule(const CONFIG * cfg);
extern void CONFIG_SetBattleRule(CONFIG * cfg, BATTLERULE rule);

//	TEh
extern SOUNDMODE CONFIG_GetSoundMode(const CONFIG * cfg);
extern void CONFIG_SetSoundMode(CONFIG * cfg, SOUNDMODE snd_mode);

//	{^[h
extern INPUTMODE CONFIG_GetInputMode(const CONFIG * cfg);
extern void CONFIG_SetInputMode(CONFIG * cfg, INPUTMODE mode);

//	EBhE^Cv
extern WINTYPE CONFIG_GetWindowType(const CONFIG * cfg);
extern void CONFIG_SetWindowType(CONFIG * cfg, WINTYPE type);

//----------------------------------------------------------
//	Z[uf[^擾̂߂̊֐
//----------------------------------------------------------
extern CONFIG * SaveData_GetConfig(SAVEDATA * sv);

//----------------------------------------------------------
//	fobOpf[^̂߂̊֐
//----------------------------------------------------------
//extern void Debug_Config_Make(CONFIG * cfg, const STRCODE * name, int sex);

#endif //__CONFIG_H__
