/**
 *	@file	mail_util.h
 *	@brief	[f[^QƗpsS^`[eBeB֐`
 *	@author	MiyukiIwasawa
 *	@date	06.02.09
 */

#ifndef __H_MAIL_UTIL_H__
#define __H_MAIL_UTIL_H__

///萔`
#include "savedata/mail_def.h"

#include "savedata/savedata_def.h"
#include "system/pm_str.h"
#include "system/pms_data.h"

//------------------------------------------------------------
/**
 * @brief	[Z[uf[^ubNǗ\ւ̕sS^|C^
 *
 * g͌Ȃǃ|C^oRŎQƂ͂ł
 */
//------------------------------------------------------------
typedef struct _MAIL_BLOCK MAIL_BLOCK;

//------------------------------------------------------------
/**
 * @brief	[f[^Ǘ\ւ̕sS^|C^
 *
 * g͌Ȃǃ|C^oRŎQƂ͂ł
 */
//------------------------------------------------------------
typedef struct _MAIL_DATA MAIL_DATA;

/**
 *	@brief	󂢂Ă郁[f[^ID擾
 *
 *	@param	id ǉ[ubNID
 *
 *	@return	int	f[^ǉłꍇ͎QID
 *				ǉłȂꍇ̓}CiXlԂ
 */
extern int MAIL_SearchNullID(MAIL_BLOCK* block,MAILBLOCK_ID id);

/**
 *	@brief	[f[^폜
 *
 *	@param	blockID	ubNID
 *	@param	dataID	f[^ID
 */
extern void MAIL_DelMailData(MAIL_BLOCK* block,MAILBLOCK_ID blockID,int dataID);

/**
 *	@brief	[f[^Z[uubNɒǉ
 *
 *	nMAIL_DATA\̌^f[^̒gZ[uf[^ɔf̂
 *	@ȃf[^Ȃ悤ɒӁI
 */
extern void MAIL_AddMailFormWork(MAIL_BLOCK* block,
		MAILBLOCK_ID blockID,int dataID,MAIL_DATA* src);


//=============================================================
/**
 *	[Z[uf[^ubNANZXn֐
 */
//=============================================================
//
/**
 *	@brief	Z[uf[^ubNւ̃|C^擾
 */
extern MAIL_BLOCK* SaveData_GetMailBlock(SAVEDATA* sv);

/**
 *	@brief	[Z[uf[^ubNTCY擾
 *
 *	[f[^ʂ̃TCYł͂Ȃ̂ŒӁI
 */
extern int MAIL_GetBlockWorkSize(void);

/**
 *	@brief	[Z[uf[^ubN
 */
extern void MAIL_Init(MAIL_BLOCK* dat);

/**
 *	@brief	󂢂Ă郁[f[^ID擾
 *
 *	@param	id ǉ[ubNID
 *
 *	@return	int	f[^ǉłꍇ͎QID
 *				ǉłȂꍇ̓}CiXlԂ
 */
extern int MAIL_SearchNullID(MAIL_BLOCK* block,MAILBLOCK_ID id);

/**
 *	@brief	[f[^폜
 *
 *	@param	blockID	ubNID
 *	@param	dataID	f[^ID
 */
extern void MAIL_DelMailData(MAIL_BLOCK* block,MAILBLOCK_ID blockID,int dataID);

/**
 *	@brief	[f[^Z[uubNɒǉ
 *
 *	nMAIL_DATA\̌^f[^̒gZ[uf[^ɔf̂
 *	@ȃf[^Ȃ悤ɒӁI
 */
extern void MAIL_AddMailFormWork(MAIL_BLOCK* block,MAILBLOCK_ID blockID,int dataID,MAIL_DATA* src);

/**
 *	@brief	wubNɗLf[^邩Ԃ
 */
extern int MAIL_GetEnableDataNum(MAIL_BLOCK* block,MAILBLOCK_ID blockID);

/**
 *	@brief	[f[^̃Rs[擾
 *
 *	Ńmۂ̂ŁAĂяoӔCė̈J邱
 */
extern MAIL_DATA* MAIL_AllocMailData(MAIL_BLOCK* block,MAILBLOCK_ID blockID,int dataID,int heapID);

/**
 *	@brief	[f[^̃Rs[擾
 *
 *	炩ߊmۂMAIL_DATA^ɃZ[uf[^Rs[Ď擾
 */
extern void MAIL_GetMailData(MAIL_BLOCK* block,MAILBLOCK_ID blockID,int dataID,MAIL_DATA* dest);


//=============================================================
/**
 *	[f[^ANZXn֐
 */
//=============================================================
/**
 *	@brief	[f[^TCY擾
 *
 *	[f[^ʂ̃TCY
 */
extern int MailData_GetDataWorkSize(void);

/**
 *	@brief	[f[^NA(f[^Zbg)
 */
extern void MailData_Clear(MAIL_DATA* dat);

/**
 *	@brief	[f[^LǂԂ
 *	@retval	FALSE	
 *	@retval	TRUE	L
 */
extern BOOL MailData_IsEnable(MAIL_DATA* dat);

/**
 *	@brief	[f[^̃[N擾ĕԂ
 *
 *	ĂяoӔCĉ邱
 *	
 */
extern MAIL_DATA* MailData_CreateWork(int heapID);

/**
 *	@brief	[f[^̍\̃Rs[
 */
extern void MailData_Copy(MAIL_DATA* src,MAIL_DATA* dest);

/**
 *	@brief	fUCNo,|P̃|WVAZ[uf[^w肵
 *			[f[^VK쐬Ԃɏ
 *	@param	dat	f[^쐬MAIL_DATA\̌^ւ̃|C^
 *	@param	design_no	[̃C[WNo
 *	@param	pos		[|P̎莝̃|WV
 *	@param	save	Z[uf[^ւ̃|C^
 */
extern void MailData_CreateFromSaveData(MAIL_DATA* dat,u8 design_no,u8 pos,SAVEDATA* save);

/**
 *	@brief	[f[^@g[i[IDANZX
 */
extern u32	MailData_GetWriterID(const MAIL_DATA* dat);
extern void MailData_SetWriterID(MAIL_DATA* dat,u32 id);

/**
 *	@brief	[f[^@C^[ANZX
 */
extern STRCODE* MailData_GetWriterName(MAIL_DATA* dat);
extern void MailData_SetWriterName(MAIL_DATA* dat,STRCODE* name);

/**
 *	@brief	[f[^@C^[̐ʃANZX
 */
extern u8	MailData_GetWriteSex(const MAIL_DATA* dat);
extern void MailData_SetWriteSex(MAIL_DATA* dat,const u8 sex);

/**
 *	@brief	[f[^@fUCNoANZX
 */
extern u8	MailData_GetDesignNo(const MAIL_DATA* dat);
extern void MailData_SetDesignNo(MAIL_DATA* dat,const u8 design);

/**
 *	@brief	[f[^@R[hANZX
 */
extern u8	MailData_GetCountryCode(const MAIL_DATA* dat);
extern void MailData_SetCountryCode(MAIL_DATA* dat,const u8 code);

/**
 *	@brief	[f[^@JZbgo[WANZX
 */
extern u8	MailData_GetCasetteVersion(const MAIL_DATA* dat);
extern void MailData_SetCasetteVersion(MAIL_DATA* dat,const u8 version);

/**
 *	@brief	[f[^@[ACRp[^̎擾(CfbNXw)
 *
 *	@param	mode	MAIL_ICONPRM_CGX:cgxNo̎擾
 *					MAIL_ICONPRM_PLT:pltNo̎擾
 *					MAIL_ICONPRM_ALL:u16^(MAIL_ICON^փLXg)őo̒lԂ
 *
 *	ACRCgxIDƃX^[No͓ł͂܂BӁI
 */
extern u16	MailData_GetIconParamByIndex(const MAIL_DATA* dat,u8 index,u8 mode);
extern void MailData_SetIconParamByIndex(MAIL_DATA* dat,u16 id,u8 index,u8 mode);

/**
 *	@brief	[f[^@[ACRf[^̎擾(CfbNXw)
 *
 *	@param	index	f[^擾JnCfbNXNo(index<MAILDAT_ICONMAX)
 *	@param	pi		f[^i[ꏊւ̃|C^
 *	@param	num		f[^擾
 *	
 *	ACRNoƃX^[No͓ł͂܂BӁI
 *	CfbNXsꍇANULLACRf[^i[ĕԂ܂
 */
extern void MailData_GetIconArray(MAIL_DATA* dat,u8 index,MAIL_ICON* pi,u8 num);


/**
 *	@brief	[f[^@ȈՕ擾(CfbNXw)
 */
extern PMS_DATA*	MailData_GetMsgByIndex(MAIL_DATA* dat,u8 index);
extern void MailData_SetMsgByIndex(MAIL_DATA* dat,PMS_DATA* pms,u8 index);

/**
 *	@brief	[f[^@ȈՕ擾(CfbNXw)
 *
 *	@param	dat	MAIL_DATA*
 *	@param	index	ȈՕCfbNX
 *	@param	buf		擾|C^̊i[ꏊ
 *
 *	@retval	FALSE	̎擾Ɏs(܂͊ȈՕLȃf[^ł͂Ȃ)
 *	
 *	@li	bufɑ΂ēŃmۂĂ̂ŁAĂяoIɉ邱
 *	@li	FALSEԂꍇAbufNULLNA
 */
extern BOOL MailData_GetMsgStrByIndex(const MAIL_DATA* dat,u8 index,STRBUF* buf,int heapID);

#endif	//__H_MAIL_UTIL_H__


