//============================================================================================
/**
 * @file	zukanwork.h
 * @brief	ԃf[^ANZXpwb_
 * @author	tamada GAME FREAK inc.
 * @date	2005.12.15
 */
//============================================================================================
#ifndef __ZUKANWORK_H__
#define __ZUKANWORK_H__

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

#include "poketool/poke_tool.h"

//============================================================================================
//============================================================================================
enum{
	ZUKAN_WORK_RANDOM_PACHI = 0,		// pb`[

	// |Pʎ擾p
	ZUKAN_WORK_SEX_FIRST = 0,
	ZUKAN_WORK_SEX_SECOND,

	// ZukanWork_GetPokeSexFlagn֐̃G[R[h
	ZUKAN_WORK_GET_SEX_ERR	= 0xffffffff,	
};

//----------------------------------------------------------
//----------------------------------------------------------
typedef struct _ZUKAN_WORK ZUKAN_WORK;

//----------------------------------------------------------
//	Z[uf[^VXeˑ֐
//----------------------------------------------------------
extern int ZukanWork_GetWorkSize(void);
extern ZUKAN_WORK * ZukanWork_AllocWork(u32 heapID);


//----------------------------------------------------------
//----------------------------------------------------------
extern void ZukanWork_Init(ZUKAN_WORK * zw);
extern u16 ZukanWork_GetPokeGetCount(const ZUKAN_WORK * zw);
extern u16 ZukanWork_GetPokeSeeCount(const ZUKAN_WORK * zw);

extern BOOL ZukanWork_GetPokeGetFlag(const ZUKAN_WORK * zw, u16 monsno);
extern BOOL ZukanWork_GetPokeSeeFlag(const ZUKAN_WORK * zw, u16 monsno);
extern u32 ZukanWork_GetPokeSexFlag(const ZUKAN_WORK * zw, u16 monsno, int first_second );
extern u32 ZukanWork_GetPokeAnoonForm(const ZUKAN_WORK * zw, int count);
extern u32 ZukanWork_GetPokeAnoonSeeNum(const ZUKAN_WORK * zw);
extern u32 ZukanWork_GetPokeUmiushiArea(const ZUKAN_WORK * zw, int count);
extern u32 ZukanWork_GetPokeUmiushiSeeNum(const ZUKAN_WORK * zw);
extern u32 ZukanWork_GetPokeMinomushiArea(const ZUKAN_WORK * zw, int count);
extern u32 ZukanWork_GetPokeMinomushiSeeNum(const ZUKAN_WORK * zw);
extern u32 ZukanWork_GetPokeRandomFlag(const ZUKAN_WORK * zw, u8 random_poke);

extern void ZukanWork_SetPokeSee(ZUKAN_WORK * zw, POKEMON_PARAM * pp);
extern void ZukanWork_SetPokeGet(ZUKAN_WORK * zw, POKEMON_PARAM * pp);

extern BOOL ZukanWork_GetZukanGetFlag(const ZUKAN_WORK * zw);
extern void ZukanWork_SetZukanGetFlag(ZUKAN_WORK * zw);

extern BOOL ZukanWork_GetZenkokuZukanFlag(const ZUKAN_WORK * zw);
extern void ZukanWork_SetZenkokuZukanFlag(ZUKAN_WORK * zw);

extern BOOL ZukanWork_GetGraphicVersionUpFlag(const ZUKAN_WORK * zw);
extern void ZukanWork_SetGraphicVersionUpFlag(ZUKAN_WORK * zw);

extern BOOL ZukanWork_GetTextVersionUpFlag(const ZUKAN_WORK * zw, u16 monsno, u32 country_code);

extern void ZukanWork_Copy(const ZUKAN_WORK * from, ZUKAN_WORK * to);

//----------------------------------------------------------
//	Z[uf[^擾̂߂̊֐
//----------------------------------------------------------
extern ZUKAN_WORK * SaveData_GetZukanWork(SAVEDATA * sv);


//----------------------------------------------------------
//	fobOp
//----------------------------------------------------------
extern void Debug_ZukanWork_Make(ZUKAN_WORK * zw, int option);

#endif	// __ZUKANWORK_H__
