
//============================================================================================
/**
 * @file	arc_tool.h
 * @bfief	A[JCopc[vO
 * @author	HisashiSogabe
 * @date	05.05.30
 */
//============================================================================================

#ifndef	__ARC_TOOL_H_
#define	__ARC_TOOL_H_

#include	"system/arc_tool.dat"

//============================================================================================
//		萔`
//============================================================================================

#define	OFS_NO_SET		(0)		///<ArchiveDataLoadOfs,ArchiveDataLoadOfspOFSlȂ̒萔
#define	SIZE_NO_SET		(0)		///<ArchiveDataLoadOfs,ArchiveDataLoadOfspSIZElȂ̒萔

extern	void	ArchiveDataLoad(void *data,int file_kind,int index);
extern	void	*ArchiveDataLoadMalloc(int file_kind,int index,int heap_id);
extern	void	*ArchiveDataLoadMallocLo(int file_kind,int index,int heap_id);
extern	void	ArchiveDataLoadOfs(void *data,int file_kind,int index,int ofs,int size);
extern	void	*ArchiveDataLoadMallocOfs(int file_kind,int index,int heap_id,int ofs,int size);
extern	void	*ArchiveDataLoadMallocOfsLo(int file_kind,int index,int heap_id,int ofs,int size);
extern	u16		ArchiveDataFileCntGet(int file_kind,int index);
extern	u32		ArchiveDataSizeGet(int file_kind,int index);





/*====================================================================================*/
/*
  A[JCuf[^nh

    P̃A[JCut@C牽xf[^擾sAt@C
  I[vEN[Y񐔂炷Ƃŏׂy邽߂̎dg݁B
*/
/*====================================================================================*/


//--------------------------------------------------
/**
 * A[JCuf[^nh\̂̐錾
 */
//--------------------------------------------------
typedef struct _ARCHANDLE  ARCHANDLE;

//------------------------------------------------------------------
/**
 * A[JCuf[^nhI[v
 * iŃt@CI[v܂j
 *
 * @param   arcId		A[JCuf[^CfbNX
 * @param   heapId		Ǘpq[vhc
 *
 * @retval  ARCHANDLE	I[vꂽnh̃|C^isȂNULLj
 */
//------------------------------------------------------------------
extern ARCHANDLE* ArchiveDataHandleOpen( u32 arcId, u32 heapId );

//------------------------------------------------------------------
/**
 * A[JCuf[^nhN[Y
 * iŃt@CN[Y܂j
 *
 * @param   handle			nh|C^
 *
 */
//------------------------------------------------------------------
extern void ArchiveDataHandleClose( ARCHANDLE* handle );


//------------------------------------------------------------------
/**
 * A[JCuf[^nhgăf[^擾
 *
 * @param   handle		nh|C^
 * @param   datId		A[JCũf[^CfbNX
 * @param   buffer		f[^ǂݍݐobt@
 *
 */
//------------------------------------------------------------------
extern void ArchiveDataLoadByHandle( ARCHANDLE* handle, u32 datId, void* buffer );

//------------------------------------------------------------------
/**
 * A[JCuf[^nhgăf[^擾iǂݍ݊JnItZbgTCYwj
 *
 * @param   handle		nh|C^
 * @param   datId		A[JCũf[^CfbNX
 * @param   ofs			ǂݍ݊JnItZbg
 * @param   size		ǂݍ݃TCY
 * @param   buffer		f[^ǂݍݐobt@
 *
 */
//------------------------------------------------------------------
extern void ArchiveDataLoadOfsByHandle( ARCHANDLE* handle, u32 datId, u32 ofs, u32 size, void* buffer );

//------------------------------------------------------------------
/**
 * A[JCuf[^nhgăf[^擾iŃAP[gɁj
 *
 * @param   handle			nh|C^
 * @param   datID			A[JCũf[^CfbNX
 * @param   heapID			AP[gp̃q[vhc
 *
 * @retval  u32				f[^TCYioCgj
 */
//------------------------------------------------------------------
extern void* ArchiveDataLoadAllocByHandle( ARCHANDLE* handle, u32 datID, u32 heapID );

//------------------------------------------------------------------
/**
 * A[JCuf[^nhgăC[Wf[^ItZbg擾
 *
 * @param   handle		nh|C^
 * @param   datId		A[JCũf[^CfbNX
 * @param   offset		ItZbgǂݍݐobt@
 *
 */
//------------------------------------------------------------------
extern void ArchiveDataLoadImgofsByHandle( ARCHANDLE* handle, u32 datId, u32* offset );

//------------------------------------------------------------------
/**
 * A[JCuf[^nhgăf[^擾it@Cnh̑ǂݍ݁j
 *
 * @param   handle		nh|C^
 * @param   size		ǂݍ݃TCY
 * @param   buffer		f[^ǂݍݐobt@
 *
 */
//------------------------------------------------------------------
extern	void ArchiveDataLoadByHandleContinue( ARCHANDLE* handle, u32 size, void* buffer );

//------------------------------------------------------------------
/**
 * A[JCuf[^nhăt@CV[N
 *
 * @param   handle		nh|C^
 * @param   size
 *
 */
//------------------------------------------------------------------
void ArchiveDataSeekByHandle( ARCHANDLE* handle, u32 size );
#endif	__ARC_TOOL_H_
