//============================================================================================
/**
 * @file	arc_util.h
 * @bfief	A[JCuf[^֗Ɏg߂̃[eBeB֐Q
 * @author	taya
 * @date	05.08.30
 */
//============================================================================================
#ifndef __ARC_UTIL_H__
#define __ARC_UTIL_H__

#include "gflib\bg_system.h"
#include "system\arc_tool.h"


//------------------------------------------------------------------
/**
 *  Lf[^}bsO^Cv
 */
//------------------------------------------------------------------
typedef enum {
	ALLOC_TOP = 0,			///< q[v̐擪
	ALLOC_BOTTOM = 1,		///< q[v̏I[
}ALLOC_TYPE;

//------------------------------------------------------------------
/**
 *  pbg]^Cvw
 */
//------------------------------------------------------------------
typedef enum {
	PALTYPE_MAIN_BG,			// CBG
	PALTYPE_MAIN_OBJ,			// COBJ
	PALTYPE_MAIN_BG_EX,			// CgBG
	PALTYPE_MAIN_OBJ_EX,		// CgOBJ
	PALTYPE_SUB_BG,				// TuBG
	PALTYPE_SUB_OBJ,			// TuOBJ
	PALTYPE_SUB_BG_EX,			// TugBG
	PALTYPE_SUB_OBJ_EX,			// TugOBJ
}PALTYPE;

//------------------------------------------------------------------
/**
 *  OBJLf[^]^Cvw
 */
//------------------------------------------------------------------
typedef enum {
	OBJTYPE_MAIN,
	OBJTYPE_SUB,
}OBJTYPE;

//------------------------------------------------------------------
/**
 *  Lf[^}bsO^Cv
 */
//------------------------------------------------------------------
typedef enum {
	CHAR_MAP_1D,		// 1D 
	CHAR_MAP_2D,		// 2D
}CHAR_MAPPING_TYPE;


//------------------------------------------------------------------
/**
 * BGް VRAM ]
 *
 * @param   arcFile			A[JCut@CCfbNX
 * @param   arcIndex		A[JCuf[^CfbNX
 * @param   bgl				BGLް
 * @param   frm				]ڰ
 * @param   offs			]̾āiגPʁj
 * @param	transSize		]黲ށi޲ĒP ==0őS]j
 * @param   compressedFlag	kĂްH
 * @param   heapID			ްǂݍ݁E؂ƂĎg˰ID
 *
 * @return  ]f[^TCYioCgj
 */
//------------------------------------------------------------------
extern u32 ArcUtil_BgCharSet(u32 arcFile, u32 dataIdx, GF_BGL_INI* bgl, u32 frm, u32 offs, u32 transSize, BOOL compressedFlag, u32 heapID);


//------------------------------------------------------------------
/**
 * OBJ ް  VRAM ]
 *
 * @param   fileIdx				A[JCut@CCfbNX
 * @param   dataIdx				A[JCuf[^CfbNX
 * @param   objType				OBJ
 * @param   offs				̾āi޲ĒPʁj
 * @param   transSize			]ށi޲ĒP : 0 őS]j
 * @param   compressedFlag		kꂽްH
 * @param   heapID				ǂݍ݁E؂ƂĎg˰ID
 *
 * @return  ]f[^TCYioCgj
 */
//------------------------------------------------------------------
extern u32 ArcUtil_ObjCharSet( u32 fileIdx, u32 dataIdx, OBJTYPE objType, u32 offs, u32 transSize, BOOL compressedFlag, u32 heapID );


//--------------------------------------------------------------------------------------------
/**
 * ذް VRAM ]
 *  BGL ذޯ̧ pӂĂ΁Aذޯ̧ ւ̓]s
 *
 * @param   arcFile			A[JCut@CCfbNX
 * @param   arcIndex		A[JCuf[^CfbNX
 * @param   bgl				BGLް
 * @param   frm				]ڰ
 * @param   offs			]̾āiגPʁj
 * @param	transSize		]黲ށi޲ĒP ==0őS]j
 * @param   compressedFlag	kĂްH
 * @param   heapID			ްǂݍ݁E؂ƂĎg˰ID
 *
 */
//--------------------------------------------------------------------------------------------
extern void ArcUtil_ScrnSet(u32 arcFile, u32 dataIdx, GF_BGL_INI* bgl, u32 frm, u32 offs, u32 transSize, BOOL compressedFlag, u32 heapID);


//------------------------------------------------------------------
/**
 * گް  VRAM ]
 *
 * @param   arcFile		A[JCut@CCfbNX
 * @param   dataIdx		A[JCuf[^CfbNX
 * @param   palType		گē]
 * @param   offs		گē]̾
 * @param   transSize	گē]ށi0 őS]j
 * @param   heapID		ްǂݍ؂ƂĎg˰ID
 *
 */
//------------------------------------------------------------------
extern void ArcUtil_PalSet( u32 arcFile, u32 dataIdx, PALTYPE palType, u32 offs, u32 transSize, u32 heapID );

//------------------------------------------------------------------
/**
 * گް  VRAM ] NITRO System گ۷ 쐬
 *i3D, OBJ pɂ̂ݑΉBBG ɂ͎g܂j
 *
 * @param   fileIdx		̧ٲޯ
 * @param   dataIdx		ްޯ
 * @param   type		]
 * @param   offs		]̾
 * @param   heapID		˰ID
 * @param   proxy		쐬۷̱ڽ
 *
 *	[ type ]
 *		NNS_G2D_VRAM_TYPE_3DMAIN = 0,
 *		NNS_G2D_VRAM_TYPE_2DMAIN = 1,
 *		NNS_G2D_VRAM_TYPE_2DSUB  = 2,
 *
 */
//------------------------------------------------------------------
extern void ArcUtil_PalSysLoad( u32 fileIdx, u32 dataIdx, NNS_G2D_VRAM_TYPE type, u32 offs, u32 heapID, NNSG2dImagePaletteProxy* proxy );

//------------------------------------------------------------------
/**
 * ް  VRAM ] NITRO System Ұ۷ 쐬
 *i3D, OBJ pɂ̂ݑΉBBG ɂ͎g܂j
 *
 *
 * @param   fileIdx			̧ٲޯ
 * @param   dataIdx			ްޯ
 * @param   compressedFlag	kĂ邩
 * @param   mapType			ϯݸ
 * @param   transSize		]ށi0ȂS]j
 * @param   vramType		]
 * @param   offs			]̾
 * @param   heapID			؂Ɏg˰ID
 * @param   proxy			쐬۷̱ڽ
 *
 *
 *	[ mapType ]
 *		MAP_TYPE_1D = 0,
 *		MAP_TYPE_2D = 1,
 *
 *	 VRAM]^͕ʊ֐ ArcUtil_TranCharSysLoad g
 *
 *	[ vramType ]
 *		NNS_G2D_VRAM_TYPE_3DMAIN = 0,
 *		NNS_G2D_VRAM_TYPE_2DMAIN = 1,
 *		NNS_G2D_VRAM_TYPE_2DSUB  = 2,
 *
 */
//------------------------------------------------------------------
extern void ArcUtil_CharSysLoad( u32 fileIdx, u32 dataIdx, BOOL compressedFlag, CHAR_MAPPING_TYPE mapType,
	u32 transSize, NNS_G2D_VRAM_TYPE vramType, u32 offs, u32 heapID, NNSG2dImageProxy* proxy );


//------------------------------------------------------------------
/**
 * ް  VRAM ] NITRO System Ұ۷ 쐬
 *i3D, OBJ pɂ̂ݑΉBBG ɂ͎g܂j
 *
 * ްϯݸӰޒlA݂ڼ޽ݒɍ킹ď܂
 *
 * @param   fileIdx			̧ٲޯ
 * @param   dataIdx			ްޯ
 * @param   compressedFlag	kĂ邩
 * @param   mapType			ϯݸ
 * @param   transSize		]TCYBOȂS]B
 * @param   vramType		]
 * @param   offs			]̾
 * @param   heapID			؂Ɏg˰ID
 * @param   proxy			쐬۷ڽ
 *
 *
 *	[ mapType ]
 *		CHAR_MAP_1D = 0,
 *		CHAR_MAP_2D = 1,
 *
 *	 VRAM]^͕ʊ֐ ArcUtil_TranCharSysLoad g
 *
 *	[ vramType ]
 *		NNS_G2D_VRAM_TYPE_3DMAIN = 0,
 *		NNS_G2D_VRAM_TYPE_2DMAIN = 1,
 *		NNS_G2D_VRAM_TYPE_2DSUB  = 2,
 *
 */
//------------------------------------------------------------------
extern void ArcUtil_CharSysLoadSyncroMappingMode( u32 fileIdx, u32 dataIdx, BOOL compressedFlag, CHAR_MAPPING_TYPE mapType, u32 transSize,
	NNS_G2D_VRAM_TYPE vramType, u32 offs, u32 heapID, NNSG2dImageProxy* proxy );

//------------------------------------------------------------------
/**
 * ް  VRAM ] NITRO System Ұ۷ 쐬BVRAM]^̉摜fޗpB
 *
 *  ̊֐gĂAVRAMɉ摜͓]܂
 *    ̊֐۰ން͉܂B߂lconst void*ǗāA
 *    svɂȂsĂB
 *
 * @param   fileIdx			̧ٲޯ
 * @param   dataIdx			ްޯ
 * @param   compressedFlag	kĂ邩
 * @param   vramType		]
 * @param   offs			]̾
 * @param   heapID			؂Ɏg˰ID
 * @param   proxy			쐬۷̱ڽ
 * @param   charData		ްڽێ߲̱ڽ
 *
 * @retval  const void*		۰ން̱ڽ
 *
 *	[ vramType ]
 *		NNS_G2D_VRAM_TYPE_3DMAIN = 0,
 *		NNS_G2D_VRAM_TYPE_2DMAIN = 1,
 *		NNS_G2D_VRAM_TYPE_2DSUB  = 2,
 *
 */
//------------------------------------------------------------------
extern const void* ArcUtil_TransTypeCharSysLoad( u32 fileIdx, u32 dataIdx, BOOL compressedFlag, 
	NNS_G2D_VRAM_TYPE vramType, u32 offs, u32 heapID, NNSG2dImageProxy* proxy, NNSG2dCharacterData** charData );


//------------------------------------------------------------------
/**
 * ް ۰ނ Unpack 邾łB͊eŁB
 *
 * @param   fileIdx				̧ٲޯ
 * @param   dataIdx				ްޯ
 * @param   compressedFlag		kĂ邩
 * @param   charData			ްڽێ߲̱ڽ
 * @param   heapID				˰ID
 *
 * @retval  void*		۰ން̐擪߲
 */
//------------------------------------------------------------------
extern void* ArcUtil_CharDataGet( u32 fileIdx, u32 dataIdx, BOOL compressedFlag, NNSG2dCharacterData** charData, u32 heapID );

//--------------------------------------------------------------------------------------------
/**
 * ذް ۰ނ Unpack 邾łB͊eŁB
 *
 * @param   fileIdx			̧ٲޯ
 * @param   arcIndex		ްޯ
 * @param   compressedFlag	kĂްH
 * @param   scrnData		ذްڽێ߲̱ڽ
 * @param   heapID			ްǂݍ݁E؂ƂĎg˰ID
 *
 * @retval  void*		۰ން̐擪߲
 */
//--------------------------------------------------------------------------------------------
extern void* ArcUtil_ScrnDataGet(u32 fileIdx, u32 dataIdx, BOOL compressedFlag, NNSG2dScreenData** scrnData, u32 heapID);

//------------------------------------------------------------------
/**
 * گް۰ނ Unpack 邾łB͊eŁB
 *
 * @param   fileIdx			̧ٲޯ
 * @param   arcIndex		ްޯ
 * @param   palData			گްڽێ߲̱ڽ
 * @param   heapID			˰ID
 *
 * @retval  void*		۰ން̐擪߲
 */
//------------------------------------------------------------------
extern void* ArcUtil_PalDataGet( u32 fileIdx, u32 dataIdx, NNSG2dPaletteData** palData, u32 heapID );

//--------------------------------------------------------------------------------------------
/**
 * ݸް ۰ނ Unpack 邾łB͊eŁB
 *
 * @param   fileIdx			̧ٲޯ
 * @param   arcIndex		ްޯ
 * @param   compressedFlag	kĂްH
 * @param   cellBank		ݸްڽێ߲̱ڽ
 * @param   heapID			˰ID
 *
 * @retval  void*		۰ން̐擪߲
 */
//--------------------------------------------------------------------------------------------
extern void* ArcUtil_CellBankDataGet(u32 fileIdx, u32 dataIdx, BOOL compressedFlag, NNSG2dCellDataBank** cellBank, u32 heapID );

//--------------------------------------------------------------------------------------------
/**
 * ݸް ۰ނ Unpack 邾łB͊eŁB
 *
 * @param   fileIdx			̧ٲޯ
 * @param   arcIndex		ްޯ
 * @param   compressedFlag	kĂްH
 * @param   anmBank			ݸްڽێ߲̱ڽ
 * @param   heapID			˰ID
 *
 * @retval  void*		۰ން̐擪߲
 */
//--------------------------------------------------------------------------------------------
extern void* ArcUtil_AnimBankDataGet(u32 fileIdx, u32 dataIdx, BOOL compressedFlag, NNSG2dAnimBankData** anmBank, u32 heapID);


//------------------------------------------------------------------
/**
 * LZkA[JCuĂf[^ǂݏoA𓀂ĕԂ
 *
 * @param   fileIdx		A[JCut@CCfbNX
 * @param   dataIdx		A[JCuf[^CfbNX
 * @param   heapID		ǂݏoE𓀂Ɏgq[vhc
 *
 * @retval  void*		𓀌̃f[^ۑAhX
 */
//------------------------------------------------------------------
extern void* ArcUtil_UnCompress(u32 fileIdx, u32 dataIdx, u32 heapID);


//------------------------------------------------------------------
/**
 * A[JCuf[^̓ǂݏo
 *
 * @param   fileIdx			A[JCut@CCfbNX
 * @param   dataIdx			A[JCuf[^CfbNX
 * @param   compressedFlag	kĂ邩H
 * @param   heapID			mۂɎgq[vhc
 * @param   allocType		q[v̂ǂ̈ʒu烁mۂ邩
 *
 * [allocType]
 *		ALLOC_TOP		q[v擪m
 *		ALLOC_BOTTOM	q[vm
 *
 * @retval  void*			ǂݏö|C^
 */
//------------------------------------------------------------------
extern void* ArcUtil_Load(u32 fileIdx, u32 dataIdx, BOOL compressedFlag, u32 heapID, ALLOC_TYPE allocType);

//------------------------------------------------------------------
/**
 * A[JCuf[^̓ǂݏof[^TCY擾ikĂ𓀌̃TCY擾j
 *
 * @param   fileIdx			A[JCut@CCfbNX
 * @param   dataIdx			A[JCuf[^CfbNX
 * @param   compressedFlag	kĂ邩H
 * @param   heapID			mۂɎgq[vhc
 * @param   allocType		q[v̂ǂ̈ʒu烁mۂ邩
 * @param   pSize			f[^̃oCgTCY󂯎ϐ̃|C^
 *
 * [allocType]
 *		ALLOC_TOP		q[v擪m
 *		ALLOC_BOTTOM	q[vm
 *
 * @retval  void*			ǂݏö|C^
 */
//------------------------------------------------------------------
extern void* ArcUtil_LoadEx(u32 fileIdx, u32 dataIdx, BOOL compressedFlag, u32 heapID, ALLOC_TYPE allocType, u32* pSize);



#endif
