//============================================================================================
/**
 * @file	bmp_menu.h
 * @brief	BMPj[
 * @author	Hiroyuki Nakamura
 * @date	2004.11.10
 */
//============================================================================================
#ifndef BMP_MENU_H
#define BMP_MENU_H

#include "bmp_menu_list.h"


#undef GLOBAL
#ifdef BMP_MENU_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	V{`
//============================================================================================
#define	BMPMENU_NULL	( 0xffffffff )
#define	BMPMENU_CANCEL	( 0xfffffffe )
#define	BMPMENU_DUMMY	( 0xfffffffd )


typedef struct {
	const BMPMENU_DATA * menu;
	GF_BGL_BMPWIN * win;
	u8	font;
	u8	x_max;			// ڍő吔iKPȏj
	u8	y_max;			// cڍő吔iKPȏj
	u8	line_spc:4;		// Ԋux
	u8	c_disp_f:2;		// J[\\tO
	u8	loop_f:2;		// LOOPtO ( 0=OFF, 1=ON )
}BMPMENU_HEADER;


typedef struct _BMPMENU_WORK	BMPMENU_WORK;



//============================================================================================
//	O[oϐ
//============================================================================================


//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * BMPj[o^iXN[]Ȃj
 *
 * @param	dat			wb_f[^
 * @param	px			ڕ\XW
 * @param	py			ڕ\YW
 * @param	pos			J[\ʒu
 * @aram	mode		擾[h
 * @param	cancel		LZ{^
 *
 * @return	BMPj[[N
 *
 * @li	BMPXg[Nsys_AllocMemoryŊm
 */
//--------------------------------------------------------------------------------------------
GLOBAL BMPMENU_WORK * BmpMenuAdd_NoTrans(
						const BMPMENU_HEADER * dat,
						u8 px, u8 py, u8 pos, u8 mode, u32 cancel );

//--------------------------------------------------------------------------------------------
/**
 * BMPj[o^iLZ{^wj
 *
 * @param	dat			wb_f[^
 * @param	px			ڕ\XW
 * @param	py			ڕ\YW
 * @param	pos			J[\ʒu
 * @aram	mode		擾[h
 * @param	cancel		LZ{^
 *
 * @return	BMPj[[N
 *
 * @li	BMPXg[Nsys_AllocMemoryŊm
 */
//--------------------------------------------------------------------------------------------
GLOBAL BMPMENU_WORK * BmpMenuAddEx(
						const BMPMENU_HEADER * dat,
						u8 px, u8 py, u8 pos, u8 mode, u32 cancel );

//--------------------------------------------------------------------------------------------
/**
 * BMPj[o^iȈՔŁj
 *
 * @param	dat			wb_f[^
 * @param	pos			J[\ʒu
 * @aram	mode		擾[h
 *
 * @return	BMPj[[N
 *
 * @li	BMPXg[Nsys_AllocMemoryŊm
 * @li	B{^LZ
 */
//--------------------------------------------------------------------------------------------
GLOBAL BMPMENU_WORK * BmpMenuAdd( const BMPMENU_HEADER * dat, u8 pos, u8 mode );

//--------------------------------------------------------------------------------------------
/**
 * BMPj[j
 *
 * @param	mw		BMPj[[N
 * @param	backup	J[\ʒuۑꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BmpMenuExit( BMPMENU_WORK * mw, u8 * backup );

//--------------------------------------------------------------------------------------------
/**
 * j[֐
 *
 * @param	mw		BMPj[[N
 *
 * @return	쌋
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 BmpMenuMain( BMPMENU_WORK * mw );

//--------------------------------------------------------------------------------------------
/**
 * j[֐i\L[SEwłj
 *
 * @param	mw		BMPj[[N
 * @param	key_se	\L[SE
 *
 * @return	쌋
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 BmpMenuMain_SE( BMPMENU_WORK * mw, u16 key_se );

//--------------------------------------------------------------------------------------------
/**
 * J[\ʒu擾
 *
 * @param	mw		BMPj[[N
 *
 * @return	J[\ʒu
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 BmpMenuCursorPosGet( BMPMENU_WORK * mw );

//============================================================================================
//	͂E
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ͂EEBhEZbg
 *
 * @param	ini		BGLf[^
 * @param	data	EBhEf[^
 * @param	cgx		EBhELʒu
 * @param	pal		EBhEpbgԍ
 * @param	heap	q[vID
 *
 * @return	BMPj[[N
 *
 * @li	BMPEBhEBMPj[[NAllocŎ擾Ă
 */
//--------------------------------------------------------------------------------------------
GLOBAL BMPMENU_WORK * BmpYesNoSelectInit(
						GF_BGL_INI * ini, const BMPWIN_DAT * data, u16 cgx, u8 pal, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * ͂EIEBhE̐
 *
 * @param	ini		BGLf[^
 * @param	heap	q[vID
 *
 * @retval	"BMPMENU_NULL	IĂȂ"
 * @retval	"0				͂I"
 * @retval	"BMPMENU_CANCEL	orLZ"
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 BmpYesNoSelectMain( BMPMENU_WORK * mw, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * ͂EEBhE폜
 *
 * @param	ini		BGLf[^
 * @param	heap	q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BmpYesNoWinDel( BMPMENU_WORK * mw, u32 heap );



//------------------------------------------------------------------
/**
 * EBhEɃJ[\摜`悷
 *
 * @param   win		
 * @param   x		
 * @param   y		
 *
 */
//------------------------------------------------------------------
GLOBAL void BmpWin_DrawCursorImage(GF_BGL_BMPWIN* win, u32 x, u32 y);







#undef	GLOBAL
#endif	/* BMP_MENU_H */
