//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		clact_util.h
 *@brief	ZAN^[̓o^ȒPɍsVXe
 *@author	tomoya takahashi
 *@data		2005.09.02
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#ifndef __CLACT_UTIL_H__
#define __CLACT_UTIL_H__

#include "nnsys.h"
#include "clact.h"
#include "include/system/clact_util_res.h"
#include "include/system/clact_util_vram.h"

#undef GLOBAL
#ifdef	__CLACT_UTIL_H_GLOBAL
#define	GLOBAL	/* */
#else
#define	GLOBAL	extern
#endif

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define	CLACT_U_HEADER_DATA_NONE	(0xffffffff)	// Ƀ}`Z̗Lɂ悤

//-------------------------------------
//	oCif[^R[h
//=====================================
// "n"}`ZA}`ZAjKvȂƂɐݒ
#define CLACT_U_HEADER_MAKE_NONE_CODE	(CLACT_U_HEADER_DATA_NONE)	
// "e"oCif[^̏IR[h
#define CLACT_U_HEADER_MAKE_END_CODE	(0xfffffffe)


// ȒPAN^[Zbgo^p
// TuʂɃZoƂ́A"SUB_SURFACE_Y"̍W
// Zo^ĂB
#define	MAIN_SURFACE_X	(0)					// CT[tF[XW
#define MAIN_SURFACE_Y	(0)					// CT[tF[XW
#define SUB_SURFACE_X	(0)					// TuT[tF[XW
#define SUB_SURFACE_Y	(192 << FX32_SHIFT)	// TuT[tF[XW
#define SURFACE_WIDTH	(255 << FX32_SHIFT)	// T[tF[XTCY
#define	SURFACE_HEIGHT	(192 << FX32_SHIFT)	// T[tF[XTCY
#define MAIN_SURFACE_Y_INTEGER	(0)
#define SUB_SURFACE_Y_INTEGER	(192)


//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	ZAN^[wb_[e[u
//	
//=====================================
typedef struct _CLACT_HEADER_TBL{
	CLACT_HEADER_PTR tbl;		// wb_[
	int	tbl_num;			// wb_[e[u
} CLACT_HEADER_TBL;

//-------------------------------------
//	
//	ZAN^[wb_[e[u	
//	
//=====================================
typedef struct _CLACT_HEADER_TBL* CLACT_HEADER_TBL_PTR;


//-------------------------------------
//	
//	ZAN^[[eBeB
//	ZAN^[wb_[쐬oCif[^
//	i[\
//	
//=====================================
typedef struct {
	u32	char_id;				// LN^ID
	u32 pltt_id;				// pbgID
	u32 cell_id;				// ZID
	u32 cellanime_id;			// ZAjID
	u32 multicell_id;			// }`ZID
	u32 multicellanime_id;		// }`ZAjID
	u32 vram_trans;				// Vram]tO
	u32 bg_priority;			// BGʂƂ̗D揇
} CLACT_U_HEADER_MAKE_BINDATA;


///////////////////////////////////////////////////////////////////////////////
//
//
//	ȒPZAN^[Zbgp\
//
//
///////////////////////////////////////////////////////////////////////////////
//-------------------------------------
//	
//	ȒPZAN^[Zbgp_f[^
//	
//=====================================
typedef struct{
	NNSG2dRendererInstance	 Rend;		// _
	NNSG2dRenderSurface		surface[2];	// T[tF[X
} CLACT_U_EASYRENDER_DATA;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAN^[wb_[쐬	iṔj
 *
 *@param	tbl					wb_[f[^i[
 *@param	charID				LN^f[^ID
 *@param	plttID				pbgf[^ID
 *@param	cellID				Zf[^ID
 *@param	cellAnmID			ZAj[VID	"ƂCLACT_U_HEADER_DATA_NONE"
 *@param	MultiID				}`ZID		"ƂCLACT_U_HEADER_DATA_NONE"
 *@param	MultiAnmID			}`ZAjID	"ƂCLACT_U_HEADER_DATA_NONE"
 *@param	vram_trans			Vram]tO
 *@param	priority			BGƂ̗D揇
 *@param	charResMan			LN^f[^i[Ă郊\[X}l[W
 *@param	plttResMan			pbgf[^i[Ă郊\[X}l[W
 *@param	cellResMan			Zf[^i[Ă郊\[X}l[W
 *@param	cellAnmResMan		ZAjf[^i[Ă郊\[X}l[W	"ƂNULL"
 *@param	multiCellResMan		}`Zf[^i[Ă郊\[X}l[W	"ƂNULL"
 *@param	multiCellAnmResMan	}`ZAjf[^i[Ă郊\[X}l[W	"ƂNULL"

 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_U_MakeHeader(CLACT_HEADER_PTR tbl, int charID, int plttID, int cellID,
		int cellAnmID, int MultiID, int MultiAnmID, int vram_trans, int priority,
		CLACT_U_RES_MANAGER_PTR charResMan,
		CLACT_U_RES_MANAGER_PTR plttResMan,
		CLACT_U_RES_MANAGER_PTR cellResMan,
		CLACT_U_RES_MANAGER_PTR cellAnmResMan,
		CLACT_U_RES_MANAGER_PTR multiCellResMan,
		CLACT_U_RES_MANAGER_PTR multiCellAnmResMan);

//----------------------------------------------------------------------------
/**
 *
 *@brief	wb_[̃OɁAwb_[̃f[^Ŋmۂj
 *
 *@param	tbl		g̃f[^jwb_[
 *
 *@return	none
 *
 * Vram]pɊmۂVram̈j
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_U_DeleteInHeaderVramTransferArea(CLACT_HEADER_PTR tbl);

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAN^[wb_[e[uǂݍ	ij
 *
 *@param	path				pX
 *@param	heap				q[v
 *@param	charResMan			LN^f[^i[Ă郊\[X}l[W
 *@param	plttResMan			pbgf[^i[Ă郊\[X}l[W
 *@param	cellResMan			Zf[^i[Ă郊\[X}l[W
 *@param	cellAnmResMan		ZAjf[^i[Ă郊\[X}l[W
 *@param	multiCellResMan		}`Zf[^i[Ă郊\[X}l[W
 *@param	multiCellAnmResMan	}`ZAjf[^i[Ă郊\[X}l[W
 *
 *@return	CLACT_HEADER_TBL_PTR	wb_[̃e[ui[\̂̃|C^
 *									ANZX֐ŌX̃wb_[擾邱Ƃo܂B
 *
 * wb_[			"iۂ͉ɂȂĂj"
 *	LN^ID,		i\[X}l[W[Ɗ֘AtꂽIDj
 *	pbgID,
 *	ZID,
 *	ZAjID,
 *	}`ZID,		i}`ZA}`ZAjƂ'n'j
 *	}`ZAjID,
 *	Vram]AjmFtO,
 *	BGʂƂ̗Dxisj
 *	̃e[u
 *	0,1,0,2,n,n,0,0			jĕׂ
 *	1,2,3,2,0,0,1,2
 *	IR[h
 *	e,e,e,e,e,e,e,e			̃f[^oĂI
 *
 */
//-----------------------------------------------------------------------------
GLOBAL CLACT_HEADER_TBL_PTR CLACT_U_LoadHeaderTbl(const char* path, int heap,
		CLACT_U_RES_MANAGER_PTR charResMan,
		CLACT_U_RES_MANAGER_PTR plttResMan,
		CLACT_U_RES_MANAGER_PTR cellResMan,
		CLACT_U_RES_MANAGER_PTR cellAnmResMan,
		CLACT_U_RES_MANAGER_PTR multiCellResMan,
		CLACT_U_RES_MANAGER_PTR multiCellAnmResMan);

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAN^[wb_[e[uoCif[^쐬	ij
 *
 *@param	bindata				oCif[^
 *@param	p_header_tbl		wb_[e[u
 *@param	heap				q[v
 *@param	charResMan			LN^f[^i[Ă郊\[X}l[W
 *@param	plttResMan			pbgf[^i[Ă郊\[X}l[W
 *@param	cellResMan			Zf[^i[Ă郊\[X}l[W
 *@param	cellAnmResMan		ZAjf[^i[Ă郊\[X}l[W
 *@param	multiCellResMan		}`Zf[^i[Ă郊\[X}l[W
 *@param	multiCellAnmResMan	}`ZAjf[^i[Ă郊\[X}l[W
 *
 *@return	CLACT_HEADER_TBL_PTR	wb_[̃e[ui[\̂̃|C^
 *									ANZX֐ŌX̃wb_[擾邱Ƃo܂B
 *
 * oCif[^		ef[^2byte̔zuƂȂĂ܂B
 *	LN^ID,		i\[X}l[W[Ɗ֘AtꂽIDj
 *	pbgID,
 *	ZID,
 *	ZAjID,
 *	}`ZID,		i}`ZA}`ZAjƂ'CLACT_U_HEADER_MAKE_NONE_CODE'j
 *	}`ZAjID,
 *	Vram]AjmFtO,
 *	BGʂƂ̗Dx
 *	̃e[u
 *	0x0000,0x0001,0x0000,0x0002,CLACT_U_HEADER_MAKE_NONE_CODE, CLACT_U_HEADER_MAKE_NONE_CODE, 0,0			<-P̃f[^
 *	0x0001,0x0002,0x0003,0x0002,0x0000,0x0000,0x0001,0x0002
 *	IR[h
 *	CLACT_U_HEADER_MAKE_END_CODE, CLACT_U_HEADER_MAKE_END_CODE, CLACT_U_HEADER_MAKE_END_CODE, CLACT_U_HEADER_MAKE_END_CODE, CLACT_U_HEADER_MAKE_END_CODE, CLACT_U_HEADER_MAKE_END_CODE, CLACT_U_HEADER_MAKE_END_CODE, CLACT_U_HEADER_MAKE_END_CODE			̃f[^oĂI	
 *
 */
//-----------------------------------------------------------------------------
GLOBAL CLACT_HEADER_TBL_PTR CLACT_U_MakeHeaderBinary(
		const CLACT_U_HEADER_MAKE_BINDATA* bindata,
		int heap,
		CLACT_U_RES_MANAGER_PTR charResMan,
		CLACT_U_RES_MANAGER_PTR plttResMan,
		CLACT_U_RES_MANAGER_PTR cellResMan,
		CLACT_U_RES_MANAGER_PTR cellAnmResMan,
		CLACT_U_RES_MANAGER_PTR multiCellResMan,
		CLACT_U_RES_MANAGER_PTR multiCellAnmResMan);

//----------------------------------------------------------------------------
/**
 *
 *@brief	wb_[e[uj
 *
 *@param	data	wb_[e[u
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_U_CLACT_HeaderTblDelete(CLACT_HEADER_TBL_PTR data);


///////////////////////////////////////////////////////////////////////////////
//
//	ȒPZAN^[Zbg֐
//
//
///////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAN^[Zbg̊ȒP
 *
 *@param	work_num	ZAN^[ɐݒ肷őAN^[
 *@param	data		ZAN^[ȒPݒɎgp郌_[f[^
 *						(Ԃ̃|C^)
 *@param	heap		mۂɎgpq[v
 *
 *@return	CLACT_SET_PTR	쐬ꂽZAN^[Zbg
 *
 * e
 * _̏AT[tF[X̐ݒȂǂs
 *		CT[tF[XW	(0,0)
 *		TuT[tF[XW	(0,192*FX32_ONE)
 *		T[tF[XTCY		(256*FX32_ONE,192*FX32_ONE)
 * ZAN^[Zbg쐬
 * ZAN^[Zbgɏ_ݒ
 *
 * j͕ʂ̃ZAN^[̔j֐ővłB
 *
 */
//-----------------------------------------------------------------------------
GLOBAL CLACT_SET_PTR CLACT_U_SetEasyInit( int work_num, CLACT_U_EASYRENDER_DATA* data, int heap );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	_[	Cʂ̃T[tF[Xʒuݒ
 *
 *	@param	data	ȒPZAN^[Zbgp_f[^
 *	@param	x		CʃT[tF[XW
 *	@param	y		CʃT[tF[XW
 *
 *	@return	none
 *
 *		T[tF[X̃TCY͖(256*FX32_ONE,192*FX32_ONE)
 *		ɂȂ܂B
 *
 *	T[tF[XTCYς֐KvɂȂƂ
 *	takahashi tomoya ܂ł낵肢܂B
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_U_SetMainSurfaceMatrix( CLACT_U_EASYRENDER_DATA* data, fx32 x, fx32 y );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	_[	Tuʂ̃T[tF[Xʒuݒ
 *
 *	@param	data	ȒPZAN^[Zbgp_f[^
 *	@param	x		TuʃT[tF[XW
 *	@param	y		TuʃT[tF[XW
 *
 *	@return	none
 *
 *		T[tF[X̃TCY͖(256*FX32_ONE,192*FX32_ONE)
 *		ɂȂ܂B
 *
 *	T[tF[XTCYς֐KvɂȂƂ
 *	takahashi tomoya ܂ł낵肢܂B
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CLACT_U_SetSubSurfaceMatrix( CLACT_U_EASYRENDER_DATA* data, fx32 x, fx32 y );


#undef	GLOBAL
#endif		// __CLACT_UTIL_H__
