//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		fontoam.h
 *	@brief		OAMgp`VXe
 *	@author		tomoya takahashi
 *	@data		2005.10.20
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#ifndef __FONTOAM_H__
#define __FONTOAM_H__

#include <nnsys.h>
#include "clact.h"

#undef GLOBAL
#ifdef	__FONTOAM_H_GLOBAL
#define	GLOBAL	/* */
#else
#define	GLOBAL	extern
#endif
//-----------------------------------------------------------------------------
/**
 *
 * OAMtHgVXe
 *
 * {IȎgp@
 *
 * PFVXe[Ni{j쐬
 *		FONTOAM_SYS_PTR FONTOAM_SysInit( int workNum, int heap );
 *
 * QF\trbg}bvf[^쐬
 *
 * RFOAMtHg쐬
 *		FOTNOAM_OBJ_PTR	FONTOAM_Init( const FONTOAM_INIT* fontoam_init );
 *
 * SFOAMtHg𓮂
 *		FONTOAM_SetMat();ȂǃZAN^[ɂ鑀֐̉]AgkȊO͗pӂĂ܂B
 *
 * TFOAMtHg̔j
 *		FONTOAM_Delete( FONTOAM_OBJ_PTR fontoam );
 *
 * UFOAMtHgVXe[N̔j
 *		FONTOAM_SysDelete( FONTOAM_SYS_PTR fntoam_sys );
 *
 *
 */
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	1OAMtHgf[^
//	
//=====================================
typedef struct _FONTOAM_OBJ*		FONTOAM_OBJ_PTR;
typedef const struct _FONTOAM_OBJ*	CONST_FONTOAM_OBJ_PTR;

//-------------------------------------
//	
//	VXef[^
//	
//=====================================
typedef struct _FONTOAM_SYSTEM*			FONTOAM_SYS_PTR;
typedef const struct _FONTOAM_SYSTEM*	CONST_FONTOAM_SYS_PTR;


//-------------------------------------
//	
//	tHgf[^o^\
//	
//=====================================
typedef struct {
	CONST_FONTOAM_SYS_PTR	fontoam_sys;// tHgVXef[^
	const GF_BGL_BMPWIN* bmp;			// \trbg}bvf[^
	CLACT_SET_PTR		clact_set;		// ZAN^[Zbg
	const NNSG2dImagePaletteProxy* pltt;// ZQƐpbgvNV
	CONST_CLACT_WORK_PTR	parent;		// ẽAN^[		ȂƂNULL	i{^Ȃǁj
	int					char_ofs;		// LN^f[^]ItZbg
	int					x;				// o^W		eAN^[Ƃ͐ẽItZbgW	(dotP)
	int					y;				// o^W		eAN^[Ƃ͐ẽItZbgW	(dotP)
	int					bg_pri;			// bgD揇
	int					soft_pri;		// \tgD揇
	int					draw_area;		// \
	/*
		NNS_G2D_VRAM_TYPE_2DMAIN    QcOtBbNXGW`p
		NNS_G2D_VRAM_TYPE_2DSUB     QcOtBbNXGWap*/
	int					heap;			// gpq[v	
} FONTOAM_INIT;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMtHgVXe̍쐬
 *
 *	@param	workNum		Ǘ镶
 *	@param	heap		gpq[v
 *
 *	@return	FONTOAM_SYS_PTR		쐬OAMtHgVXef[^
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL FONTOAM_SYS_PTR FONTOAM_SysInit( int workNum, int heap );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMtHgVXe̔j
 *
 *	@param	fntoam_sys	OAMtHgVXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void FONTOAM_SysDelete( FONTOAM_SYS_PTR fntoam_sys );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMtHg쐬
 *
 *	@param	fontoam_init	OAMtHg쐬f[^
 *
 *	@return	FONTOAM_OBJ_PTR	OAMtHgf[^
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL FONTOAM_OBJ_PTR FONTOAM_Init( const FONTOAM_INIT* fontoam_init );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMtHgj
 *
 *	@param	fontoam 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void FONTOAM_Delete( FONTOAM_OBJ_PTR fontoam );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	rbg}bvEBhEOAMtHgVXeŕ\邽߂ɕKvȃLN^f[^TCY擾
 *
 *	@param	bmp		rbg}bvf[^
 *	@param	draw_area	`GA
 *	@param	heap	gpq[v
 *
 *	@return	\邽߂ɕKvȃLN^TCY
	
	draw_area
		NNS_G2D_VRAM_TYPE_2DMAIN    QcOtBbNXGW`p
		NNS_G2D_VRAM_TYPE_2DSUB     QcOtBbNXGWap
 *	
 *	char_managergpĂƂ́ÃTCY
 *	Vram̈mۂĂKv邽ߍ쐬
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int FONTOAM_NeedCharSize( const GF_BGL_BMPWIN* bmp, int draw_area,  int heap );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMtHgWݒ
 *
 *	@param	fontoam		OAMtHg
 *	@param	x			W		eAN^[Ƃ̓ItZbgW
 *	@param	y			W		eAN^[Ƃ̓ItZbgW
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void FONTOAM_SetMat( FONTOAM_OBJ_PTR fontoam, int x, int y );

//----------------------------------------------------------------------------
/**
 * eZAN^[ݒ肵ĂȂꍇ͎gpĂӖ܂B
 *	
 *	@brief	eAN^[̍WʒuɈʒu킹
 *
 *	@param	fontoam 
 *
 *	@return
 *
 * eZAN^[̈ʒuύXƂɌĂłB
 *	@eɍ킹ĕ܂
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void FONTOAM_ReflectParentMat( FONTOAM_OBJ_PTR fontoam );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMtHgW擾
 *
 *	@param	fontoam		OAMtHg
 *	@param	x			W		eAN^[Ƃ̓ItZbgW
 *	@param	y			W		eAN^[Ƃ̓ItZbgW
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void FONTOAM_GetMat( CONST_FONTOAM_OBJ_PTR fontoam, int* x, int* y );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\/\ݒ
 *
 *	@param	fontoam		OAMtHgIuWF
 *	@param	flag		\/\tO
 *
 *	@return	none
 *
 * flag
 *	TRUE	\
 *	FALSE	\
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void FONTOAM_SetDrawFlag( FONTOAM_OBJ_PTR fontoam, BOOL flag );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\/\擾
 *
 *	@param	fontoam		OAMtHgIuWF
 *
 *	@retval	TRUE	\
 *	@retval	FALSE	\
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL FONTOAM_GetDrawFlag( CONST_FONTOAM_OBJ_PTR fontoam );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGʂƂ̗D揇ʂݒ
 *
 *	@param	fontoam	OAMtHgf[^
 *	@param	pri		BGƂ̗D揇
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void FONTOAM_SetBGPriority( FONTOAM_OBJ_PTR fontoam, u8 pri );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGʂƂ̕`D揇ʂ擾
 *
 *	@param	fontoam		OAMtHgIuWF
 *
 *	@return	BGʂƂ̗D揇
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int FONTOAM_GetBGPriority( CONST_FONTOAM_OBJ_PTR fontoam );

//-----------------------------------------------------------------------------
/**
 *	@brief	`D揇ʂݒ
 *
 *	@param	fontoam		OAMtHgf[^
 *	@param	pri			\D揇
 *				
 * 
 *	@return	none
 */
 //----------------------------------------------------------------------------
GLOBAL void FONTOAM_SetDrawPriority( FONTOAM_OBJ_PTR fontoam, u32 pri );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`D揇ʂ擾
 *
 *	@param	fontoam		OAMtHgIuWF
 *
 *	@return	u32			`D揇
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL u32 FONTOAM_GetDrawPriority( CONST_FONTOAM_OBJ_PTR fontoam );

//-----------------------------------------------------------------------------
/**
 * OAM̃pbgio[悤ɂȂ܂B
 *
 *	@brief				pbgio[ύX
 *
 *	@param	fontoam		OAMtHgIuWF
 *	@param	pltt_no		ݒpbgio[
 * 
 *	@return	none
 *
 * pbgio[ݒƃpbgItZbgݒ͓܂B
 *@@pbgio[ݒ肷ƃItZbg̒l͔fȂȂ܂B
 *	@ItZbglݒ肵Ƃ̓pbgio[fȂȂ܂B
 * 
 */
 //----------------------------------------------------------------------------
GLOBAL void FONTOAM_SetPaletteNo( FONTOAM_OBJ_PTR fontoam, u32 pltt_no );
GLOBAL void FONTOAM_SetPaletteNoAddTransPlttNo( FONTOAM_OBJ_PTR fontoam, u32 pltt_no );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgio[擾
 *
 *	@param	fontoam		OAMtHgIuWF
 *
 *	@return	u32			̃pbgio[
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL u32 FONTOAM_GetPaletteNo( CONST_FONTOAM_OBJ_PTR fontoam );

//-----------------------------------------------------------------------------
/**
 * OAMAgr[gɐݒ肳Ăpbgio[ɉZ܂B
 *	 AOAMAgr[g̃J[pbgNoQŃItZbgɂQ
 *	 ݒ肷ƁAS̃J[pbgQƂ悤ɂȂ܂
 * 
 *	@brief	pbgItZbgݒ
 *
 *	@param	fontoam		OAMtHgIuWF
 *	@param	pltt_ofs	pbgItZbg
 * 
 *	@return	none
 *
 * pbgio[ݒƃpbgItZbgݒ͓܂B
 *@@pbgio[ݒ肷ƃItZbg̒l͔fȂȂ܂B
 *	@ItZbglݒ肵Ƃ̓pbgio[fȂȂ܂B
 * 
 */
 //----------------------------------------------------------------------------
GLOBAL void FONTOAM_SetPaletteOffset( FONTOAM_OBJ_PTR fontoam, u32 pltt_ofs );
GLOBAL void FONTOAM_SetPaletteOffsetAddTransPlttNo( FONTOAM_OBJ_PTR fontoam, u32 pltt_ofs );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgItZbgl擾
 *
 *	@param	fontoam	OAMtHgIuWF
 *
 *	@return	u32		̃pbgItZbgl
 *
 */
//-----------------------------------------------------------------------------
GLOBAL u32 FONTOAM_GetPaletteOffset( CONST_FONTOAM_OBJ_PTR fontoam );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	UCNݒ
 *
 *	@param	fontoam	OAMtHgIuWF
 *	@param	flag	tO	TRUEUCNON	FALSEUCNOFF
 *
 *	@return	none
 *
 * UCNOFF̎łAjgLN^ŃUCNONɂOAM
 * UCNĕ`悳܂B
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void FONTOAM_SetMosaic( FONTOAM_OBJ_PTR fontoam, BOOL flag );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	UCNݒԂ擾
 *
 *	@param	fontoam	OAMtHgIuWF
 *
 *	@retval	TRUE	UCNON
 *	@retval	FALSE	UCNOFF	ijgLN^Őݒ肵ĂƂ͔fj
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL FONTOAM_GetMosaic( CONST_FONTOAM_OBJ_PTR fontoam );

//----------------------------------------------------------------------------
/**
 *	@brief	IuWFNg[h̐ݒ
 *
 *	@param	fontoam		tHgOAM
 *	@param	objmode		IuWF[h
 *
 *	@return	none
 *
	GX_OAM_MODE_NORMAL		m[}OBJ 
	GX_OAM_MODE_XLU			OBJ 
	GX_OAM_MODE_OBJWND		OBJEBhE 
	GX_OAM_MODE_BITMAPOBJ	rbg}bvOBJ 
 */
//-----------------------------------------------------------------------------
GLOBAL void FONTOAM_ObjModeSet( FONTOAM_OBJ_PTR fontoam, GXOamMode objmode );

//----------------------------------------------------------------------------
/**
 *	@brief	IuWF[h̎擾
 *
 *	@param	fontoam		FONTOAM
 *	@param	objmode		IuWF[h
 *
 *	@retval	GX_OAM_MODE_NORMAL		m[}OBJ 
 *	@retval	GX_OAM_MODE_XLU			OBJ 
 *	@retval	GX_OAM_MODE_OBJWND		OBJEBhE 
 *	@retval	GX_OAM_MODE_BITMAPOBJ	rbg}bvOBJ 
 */
//-----------------------------------------------------------------------------
GXOamMode FONTOAM_ObjModeGet( CONST_FONTOAM_OBJ_PTR fontoam, GXOamMode objmode );




//-----------------------------------------------------------------------------
/**
 *		FONTOAM	ׂo[W
 */
//-----------------------------------------------------------------------------
typedef struct _FONTOAM_OAM_DATA_SET* FONTOAM_OAM_DATA_PTR;
typedef const struct _FONTOAM_OAM_DATA_SET* CONST_FONTOAM_OAM_DATA_PTR;

//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAMf[^쐬
 *
 *	@param	bmp		f[^쐬rbg}bv
 *	@param	heap	q[v
 *
 *	@return	f[^
 */
//-----------------------------------------------------------------------------
GLOBAL FONTOAM_OAM_DATA_PTR FONTOAM_OAMDATA_Make( const GF_BGL_BMPWIN* bmp, int heap );
//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAMf[^̔j
 *
 *	@param	oamdata	tHgOAMf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
GLOBAL void FONTOAM_OAMDATA_Free( FONTOAM_OAM_DATA_PTR oamdata );
//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAMf[^]ɕKvLN^TCY擾
 *
 *	@param	oamdata		tHgOAMf[^
 *	@param	draw_area	`GA
 *
 *	@return	KvLN^TCY
 */
//-----------------------------------------------------------------------------
GLOBAL int FONTOAM_OAMDATA_NeedCharSize( CONST_FONTOAM_OAM_DATA_PTR oamdata, int draw_area );

//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAMf[^gpătHgOAM̍쐬
 *
 *	@param	fontoam_init		ӂOAM 쐬f[^
 *	@param	oamdata				OAMf[^
 *
 *	@return	쐬ꂽtHgOAM
 */
//-----------------------------------------------------------------------------
GLOBAL FONTOAM_OBJ_PTR FONTOAM_OAMDATA_Init( const FONTOAM_INIT* fontoam_init, CONST_FONTOAM_OAM_DATA_PTR oamdata );
//----------------------------------------------------------------------------
/**
 *	@brief	OAMtHgj
 *
 *	@param	fontoam 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
GLOBAL void FONTOAM_OAMDATA_Delete( FONTOAM_OBJ_PTR fontoam );

//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAM̃rbg}bvf[^ύX
 *
 *	@param	fontoam		ύXFONTOAM
 *	@param	oamdata		OAMf[^
 *	@param	bmp			rbg}bv 
 *	@param	heap		q[v
 *
 *	@return	none
 *
 *	ӓ_
 *		rbg}bv̑傫Kv܂B
 */
//-----------------------------------------------------------------------------
GLOBAL void FONTOAM_OAMDATA_ResetBmp( FONTOAM_OBJ_PTR fontoam, CONST_FONTOAM_OAM_DATA_PTR oamdata, const GF_BGL_BMPWIN* bmp, int heap );


//-----------------------------------------------------------------------------
/**
 *		FONTOAMƂ͖֌WłAėpIɎgpł֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	BMP̃LN^f[^OAM̃TCYŐ؂
 *
 *	@param	bmp				rbg}bvf[^
 *	@param	oam_csx			OAM̉TCY	iLN^Pʁj
 *	@param	oam_csy			OAM̏cTCY	iLN^Pʁj
 *	@param	bmp_cmx			rbg}bv؂荶゘W	iLN^Pʁj
 *	@param	bmp_cmy			rbg}bv؂荶゙W	iLN^Pʁj
 *	@param	char_buff		o͐LN^obt@ (oam_csx * oam_csy)*32byte@TCYȏ̗̈
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void FONTOAM_BmpCutOamSize( const GF_BGL_BMPWIN* cp_bmp, int oam_csx, int oam_csy, int bmp_cmx, int bmp_cmy, char* char_buff );



#undef	GLOBAL
#endif		// __FONTOAM_H__

