//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		laster.h
 *	@brief		X^[VXe
 *	@author		tomoya takahashi
 *	@data		2005.12.01
 *
 * LABEL	LABEL_LASTER_SYS		X^[VXe
 * LABEL	LABEL_LASTER_RAP_FUNC	X^[VXegpėp֐S
 * 
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#ifndef __LASTER_H__
#define __LASTER_H__

#undef GLOBAL
#ifdef	__LASTER_H_GLOBAL
#define	GLOBAL	/* */
#else
#define	GLOBAL	extern
#endif

//-----------------------------------------------------------------------------
/**
 *
 * X^[VXe		[ LABEL_LASTER_SYS ]
 *	X^[VXe\
 *		ݗpobt@AQƗpobt@̂Q֐Őݒ肵܂B
 *		Pݗpobt@̎A͎QƗpobt@ɂȂ܂B
 *
 *		݂IA݃obt@QƗpɎQƗpݗp
 *		XCb`܂Bi_uobt@j
 *
 *		֐Őݒ肵Q̃obt@͂ǂ炪AݗpQƗp
 *		gp郆[U[́A킩܂B
 *		obt@gpƂ͕K֐gpĔz̐擪|C^
 *		擾ĂB
 *
 *		擾֐
 *			void* LASTER_GetWriteBuff( CONST_LASTER_SYS_PTR cp_laster );
 *			const void* LASTER_GetReadBuff( CONST_LASTER_SYS_PTR cp_laster );
 *			
 */
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-------------------------------------
//	
//	XCb`tO
//	
//=====================================
enum{
	LASTER_SWITCH_OFF,	// obt@XCb`
	LASTER_SWITCH_ON,	// obt@XCb`L
};

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	X^[VXe\
//	
//=====================================
typedef struct _LASTER_SYS * LASTER_SYS_PTR;
typedef const struct _LASTER_SYS * CONST_LASTER_SYS_PTR;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[VXe
 *
 *	@param	heap	gpq[v
 *	@param	p_buff1	obt@P
 *	@param	p_buff2	obt@Q
 *
 *	@return	쐬X^[VXe
 *
 */
//-----------------------------------------------------------------------------
GLOBAL LASTER_SYS_PTR LASTER_Init( int heap, void* p_buff1, void* p_buff2 );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[VXej
 *
 *	@param	lster	j郉X^[VXe
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void LASTER_Delete( LASTER_SYS_PTR p_laster );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ݗpX^[obt@擾
 *
 *	@param	cp_laster	X^[XXe
 *
 *	@return	ݗpX^[obt@
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void* LASTER_GetWriteBuff( CONST_LASTER_SYS_PTR cp_laster );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	QƗpX^[obt@擾
 *
 *	@param	cp_laster	X^[VXe
 *
 *	@return	QƗpX^[obt@
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL const void* LASTER_GetReadBuff( CONST_LASTER_SYS_PTR cp_laster );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	obt@XCb`tOݒ肵܂B
 *
 *	@param	p_laster	X^[VXe
 *	@param	switch_flag	XCb`tO
 *
 *	@return	none
 *
 * switch_flag	
 *	LASTER_SWITCH_ON,	// obt@XCb`L
 *	LASTER_SWITCH_OFF	// obt@XCb`
 * 
 *	LASTERE_Init֐Ă񂾏ԂŃobt@XCb`͗LɂȂĂ܂B
 */
//-----------------------------------------------------------------------------
GLOBAL void LASTER_SwitchFlagSet( LASTER_SYS_PTR p_laster, u8 switch_flag );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[@VuN֐
 *
 *	@param	p_laster	X^[VXe
 *
 *	@return	none
 *
 * obt@XCb`tOL̂Ƃ
 *		ݗpobt@QƗp
 *		QƗpobt@ݗpɕύX܂B
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void LASTER_VBlank( LASTER_SYS_PTR p_laster );



//-----------------------------------------------------------------------------
/**
 * 
 *		X^[VXegpėp֐S	[ LABEL_LASTER_RAP_FUNC ]
 *		
 */
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *
 *		X^[HuNDMA]֐
 * 
 */
//-----------------------------------------------------------------------------
// ʐMOtBbNf[^]
// ȂƂNȂ̎KvłA
// ̂Ƃ0ɂĂ܂B
#define LASTER_USE_DMA	(0)		// gpDMAio[
enum{
	LASTER_DMA_TYPE16,
	LASTER_DMA_TYPE32
};

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[ŎgpDMA~
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void LASTER_DmaStop( void );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	HuNDMA]p[^ݒ
 *
 *	@param	p_src		]
 *	@param	p_dest		]
 *	@param	szbyte		]TCY	iP̓]œ]TCYj
 *	@param	dma_type
 *
 *	@return	none
 *
 *	LASTER_DMA_TYPE16,	16bitP
 *	LASTER_DMA_TYPE32	32bitP
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void LASTER_DmaSet( const void* p_src, void* p_dest, int szbyte, int dma_type );


//-----------------------------------------------------------------------------
/**
 *		X^[XN[
 *			DMA]gp
*/
//-----------------------------------------------------------------------------
#define LASTER_SCROLL_BUFF_SIZE	(192)	// obt@TCY

// BGʒ萔
// XN[WX^@WAhX
enum{
	LASTER_SCROLL_MBG0 = REG_BG0HOFS_ADDR,
	LASTER_SCROLL_MBG1 = REG_BG1HOFS_ADDR,
	LASTER_SCROLL_MBG2 = REG_BG2HOFS_ADDR,
	LASTER_SCROLL_MBG3 = REG_BG3HOFS_ADDR,
	LASTER_SCROLL_SBG0 = REG_DB_BG0HOFS_ADDR,
	LASTER_SCROLL_SBG1 = REG_DB_BG1HOFS_ADDR,
	LASTER_SCROLL_SBG2 = REG_DB_BG2HOFS_ADDR,
	LASTER_SCROLL_SBG3 = REG_DB_BG3HOFS_ADDR
};
typedef struct _LASTER_SCROLL* LASTER_SCROLL_PTR;
typedef const struct _LASTER_SCROLL* CONST_LASTER_SCROLL_PTR;

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[XN[IuWF
 *
 *	@param	heap	q[v
 *
 *	@return	쐬X^[XN[IuWF
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL LASTER_SCROLL_PTR LASTER_ScrollInit( int heap );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[XN[Jn
 *
 *	@param	start		X^[XN[JnW
 *	@param	end			X^[XN[IW
 *	@param	add_r		sinJ[ue[u쐬̊px𑫂Ăl(0`65535)
 *	@param	r_w			sinJ[u̔a
 *	@param	scr_sp		X^[XN[Xs[h	*100l	}CiXL
 *	@param	bg_no		X^[BG̔ԍ
 *	@param	init_num	[Nl
 *	@param	tsk_pri		^XND揇
 *
 *	@return	none
 *
 * start <= XN[͈ <= end
 * 
 * bg_no
 * 		LASTER_SCROLL_MBG0,		// C
 *		LASTER_SCROLL_MBG1,
 *		LASTER_SCROLL_MBG2,
 *		LASTER_SCROLL_MBG3,
 *		LASTER_SCROLL_SBG0,		// Tu
 *		LASTER_SCROLL_SBG1,
 *		LASTER_SCROLL_SBG2,
 *		LASTER_SCROLL_SBG3
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void LASTER_ScrollStart( LASTER_SCROLL_PTR p_lstscr, u8 start, u8 end, u16 add_r, fx32 r_w, s16 scr_sp, u32 bg_no, u32 init_num, u32 tsk_pri );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[XN[I
 *
 *	@param	p_lstscr	I郉X^[XN[[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void LASTER_ScrollEnd( LASTER_SCROLL_PTR p_lstscr );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[XN[j
 *
 *	@param	p_lstscr	X^[XN[[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void LASTER_ScrollDelete( LASTER_SCROLL_PTR p_lstscr );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	obt@擾
 *
 *	@param	p_lstscr	X^[XN[[N
 *
 *	@return	obt@|C^
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void* LASTER_GetScrollWriteBuff( LASTER_SCROLL_PTR p_lstscr );
GLOBAL const void* LASTER_GetScrollReadBuff( LASTER_SCROLL_PTR p_lstscr );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[XN[VuN֐		
 *
 *	@param	p_lstscr	X^[XN[[N
 *
 *	@return	none
 *
 * obt@XCb`
 *		̏30t[œĂƂ2ڂ
 *		VBlankԂŌĂłB
 *
 *	HblankDma]ݒ
 *		̏VBlankԂ邽тɌĂłB
 *
 */
//-----------------------------------------------------------------------------
// obt@XCb`
GLOBAL void LASTER_ScrollVBuffSwitch( LASTER_SCROLL_PTR p_lstscr );

// HblankDma]ݒ
GLOBAL void LASTER_ScrollVDma( LASTER_SCROLL_PTR p_lstscr );

//-----------------------------------------------------------------------------
/**
 *	̂
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	TCJ[ue[u쐬
 *
 *	@param	sinTbl	i[z
 *	@param	num		zvf	s16 buff[ 10 ]; Ȃ10w
 *	@param	add_r	Pɉ]pωl
 *	@param	r_w		a
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void LASTER_ScrollMakeSinTbl( s16* sinTbl, u32 num, u16 add_r, fx32 r_w );


#undef	GLOBAL
#endif		// __LASTER_H__

