//============================================================================================
/**
 * @file	pms_data.h
 * @bfief	ȈՕ́iȈՉbf[^ƒ^gݍ킹́j
 * @author	taya
 * @date	05.12.27
 */
//============================================================================================
#ifndef __PMS_DATA_H__
#define __PMS_DATA_H__

#include "gflib\strbuf.h"

//------------------------------------------------------
/**
 *  ֘A萔
 */
//------------------------------------------------------
#define  PMS_WORD_MAX		(2)			///< Ɋ܂܂P̍ő吔
#define  PMS_WORD_NULL		(0xffff)	///< PƂĖȒl

//------------------------------------------------------
/**
 *  ̓^Cv
 */
//------------------------------------------------------
enum  PMS_TYPE {
	PMS_TYPE_BATTLE_READY,	///< ΐJnO
	PMS_TYPE_BATTLE_WON,	///< ΐ폟Ƃ
	PMS_TYPE_BATTLE_LOST,	///< ΐ핉
	PMS_TYPE_MAIL,			///< [
	PMS_TYPE_UNION,			///< jI


	PMS_TYPE_MAX,
};

//------------------------------------------------------
/**
 *  P^`
 */
//------------------------------------------------------
typedef	u16		PMS_WORD;


//------------------------------------------------------
/**
 *  ͌^`
 *
 *  \̓eJĂ܂A
 *  ɃoQƂ菑肵Ă͂܂B
 *  Kvȏ̓C^[tFCX֐ʂĂ̂ݍsĂB
 *
 *iJĂ̂́A̍\̂܂ލ\́i[j
 * Z[uf[^pɒ`Ȃ΂ȂȂ߂łj
 *
 */
//------------------------------------------------------
typedef struct {
	u16				sentence_type;			///< ̓^Cv
	u16				sentence_id;			///< ^CvID
	PMS_WORD		word[PMS_WORD_MAX];		///< PID
}PMS_DATA;


//------------------------------------------------------------------
/**
 * ԏ
 *
 * @param   pms				͌^̈ւ̃|C^
 * @param   sentence_type	̓^Cv
 *
 * ł̓̕^Cv́A͉ʑJڌ̃ftHglƂĎQƂB
 *   ͉ʂł̕ҏWAقȂ镶̓^CvɂȂĂ邱Ƃ͂蓾B
 *
 */
//------------------------------------------------------------------
extern void PMSDAT_Init( PMS_DATA* pms, u32 sentence_type );


//------------------------------------------------------------------
/**
 * ͌^當𐶐B͂̂̕܂STR_Printɉ񂵂ĕ\ł
 *
 * @param   pms			͌^ւ̃|C^
 * @param   heapID		obt@pq[vID
 *
 * @retval  STRBUF*		ꂽ܂ރobt@
 */
//------------------------------------------------------------------
extern STRBUF* PMSDAT_ToString( const PMS_DATA* pms, u32 heapID );

//------------------------------------------------------------------
/**
 * ͌^A^OWJO̕擾B̂܂ܕ\͕sB
 * ĝ́A炭ȈՉb͉ʂ̂݁B
 *
 * @param   pms		
 * @param   heapID		
 *
 * @retval  STRBUF*		
 */
//------------------------------------------------------------------
extern STRBUF*  PMSDAT_GetSourceString( const PMS_DATA* pms, u32 heapID );

//------------------------------------------------------------------
/**
 * Lȕ͓eɂȂĂ邩`FbN
 *
 * @param   pms		͌^ւ̃|C^
 *
 * @retval  BOOL	TRUEŗL
 */
//------------------------------------------------------------------
extern BOOL PMSDAT_IsEnabled( const PMS_DATA* pms );

//------------------------------------------------------------------
/**
 * ݒ肳Ă镶̓^Cv擾
 *
 * @param   pms		͌^ւ̃|C^
 *
 * @retval  u32		̓^Cvienum PMS_TYPEj
 */
//------------------------------------------------------------------
extern u32  PMSDAT_GetSentenceType( const PMS_DATA* pms );

//------------------------------------------------------------------
/**
 * ݒ肳Ă镶̓CfbNXԂ
 *
 * @param   pms		͌^ւ̃|C^
 *
 * @retval  u32		̓CfbNXî܂܂ł͎gȂnYB͉ʗpBj
 */
//------------------------------------------------------------------
extern u32 PMSDAT_GetSentenceID( const PMS_DATA* pms );

//------------------------------------------------------------------
/**
 * ݒ肳ĂPio[擾
 *
 * @param   pms		͌^ւ̃|C^
 * @param   pos		Ԗڂ̒PꂩH
 *
 * @retval  PMS_WORD	ȈՉbPio[
 */
//------------------------------------------------------------------
extern PMS_WORD  PMSDAT_GetWordNumber( const PMS_DATA* pms, int pos );

//------------------------------------------------------------------
/**
 * er
 *
 * @param   pms1		
 * @param   pms2		
 *
 * @retval  BOOL		vĂTRUEԂ
 */
//------------------------------------------------------------------
extern BOOL PMSDAT_Compare( const PMS_DATA* pms1, const PMS_DATA* pms2 );

//------------------------------------------------------------------
/**
 * ̓f[^̃Rs[
 *
 * @param   src		Rs[|C^
 * @param   dst		Rs[|C^
 *
 */
//------------------------------------------------------------------
extern void PMSDAT_Copy( PMS_DATA* dst, const PMS_DATA* src  );


//------------------------------------------------------------------
/**
 * ̓^CvÃ^CvɊ܂܂镶̓p^[̍ő吔Ԃ
 *
 * @param   sentence_type		
 *
 * @retval  u32		
 */
//------------------------------------------------------------------
extern u32  PMSDAT_GetSentenceIdMax( u32 sentence_type );

//------------------------------------------------------------------
/**
 * ̓^CvAp^[Zbg
 *
 * @param   pms		
 * @param   sentence_type		
 * @param   sentence_id		
 *
 */
//------------------------------------------------------------------
extern void PMSDAT_SetSentence( PMS_DATA* pms, u32 sentence_type, u32 sentence_id );

//------------------------------------------------------------------
/**
 * 
 *
 * @param   pms		
 * @param   pos		
 * @param   word		
 *
 */
//------------------------------------------------------------------
extern void PMSDAT_SetWord( PMS_DATA* pms, u32 pos, PMS_WORD word );


#ifdef PM_DEBUG
//------------------------------------------------------------------
/**
 * eXgpɓKȓeZbg
 *
 * @param   pms		
 */
//------------------------------------------------------------------
extern void PMSDAT_SetDebug( PMS_DATA* pms );		// Œ
extern void PMSDAT_SetDebugRandom( PMS_DATA* pms );	// _

#endif

#endif
