
//============================================================================================
/**
 * @file	softsprite.h
 * @bfief	\tgEGAXvCggp\vO
 * @author	HisashiSogabe
 * @date	05.06.08
 */
//============================================================================================

#ifndef __SOFTSPRITE_H_
#define __SOFTSPRITE_H_

#define	SOFT_SPRITE_MAX			(4)		//o^łő吔
#define SOFT_SPRITE_SIZE_X		(80)	//ǂݍރ\tgEGAXvCgXTCY
#define SOFT_SPRITE_SIZE_Y		(80)	//ǂݍރ\tgEGAXvCgYTCY

#define SOFT_SPRITE_SRC_X		(160)	//ǂݍރ\tgEGAXvCgXTCY
#define SOFT_SPRITE_SRC_Y		(80)	//ǂݍރ\tgEGAXvCgYTCY

#define SOFT_SPRITE_SRC_Y_OFS	(0x50)	//ǂݍރ\tgEGAXvCgYItZbg
#define SOFT_SPRITE_DEST_Y_OFS	(0x80)	//ރ\tgEGAXvCgYItZbg

#define SOFT_SPRITE_DEST_CHR_OFS	(0x2800)	//ރ\tgEGAXvCgYItZbg

#define SOFT_SPRITE_DEST_OFS	(0x50)		//ރ\tgEGAXvCgYItZbg
#define SOFT_SPRITE_DEST_OFS2	(0x2800)	//ރ\tgEGAXvCgYItZbg

///<VISIBLE_MODE ON/OFFtO
#define	VISIBLE_ON	(1)
#define	VISIBLE_OFF	(0)

///<SoftSpriteParaCalcpp[^萔`
enum{
	SS_PARA_POS_X=0,		// XW
	SS_PARA_POS_Y,			// YW
	SS_PARA_POS_Z,			// ZW
	SS_PARA_POS_OX,			// XWItZbg
	SS_PARA_POS_OY,			// YWItZbg
	SS_PARA_POS_OZ,			// ZWItZbg
	SS_PARA_VANISH,			// ojbVtOi0:\@1:\j
	SS_PARA_ROT_X,			// X]px
	SS_PARA_ROT_Y,			// Y]px
	SS_PARA_ROT_Z,			// Z]px
	SS_PARA_ROT_CX,			// ]SXWItZbg
	SS_PARA_ROT_CY,			// ]SYWItZbg
	SS_PARA_AFF_X,			// Xgk
	SS_PARA_AFF_Y,			// Ygk
	SS_PARA_VISIBLE,		// rWu[htOi0:OFF@1:ONj
	SS_PARA_OFS_POS_X,		// eNX`͈͍XW
	SS_PARA_OFS_POS_Y,		// eNX`͈͍YW
	SS_PARA_OFS_SIZE_X,		// eNX`͈XTCY
	SS_PARA_OFS_SIZE_Y,		// eNX`͈YTCY
	SS_PARA_ALPHA,			// Alphal
	SS_PARA_PAL_FADE,		// pbgtF[htO
	SS_PARA_PAL_RGB,		// pbgtF[h RGBl
	SS_PARA_PAL_START_EVY,	// pbgtF[h START_EVYl
	SS_PARA_PAL_END_EVY,	// pbgtF[h END_EVYl
	SS_PARA_PAL_WAIT,		// pbgtF[h WAITl
	SS_PARA_H_FLIP,			// E]tO
	SS_PARA_V_FLIP,			// ㉺]tO
	SS_PARA_DRAW_STOP,		// `Xgbv

	SS_PARA_END
};

///<\p}l[W\
typedef struct soft_sprite_manager SOFT_SPRITE_MANAGER;

///<\p\
typedef struct soft_sprite SOFT_SPRITE;

///<Aj[Ve[u\
typedef struct soft_sprite_anime SOFT_SPRITE_ANIME;

///<A[JCo\
typedef struct
{
	u16	arc_no;			///<LN^̃A[JCoio[
	u16	index_chr;		///<ǂݍރLN^A[JCoINDEX
	u16	index_pal;		///<ǂݍރpbgA[JCoINDEX
}SOFT_SPRITE_ARC;

///<\tgEGAXvCgp[^\
typedef struct
{
	s16	pos_x;				///<\XW
	s16	pos_y;				///<\YW

	int	pos_z;				///<\ZW

	s16	pos_ox;				///<\XWItZbg
	s16	pos_oy;				///<\YWItZbg

	int	pos_oz;				///<\ZWItZbg

	u16	aff_x;				///<Xgkl
	u16	aff_y;				///<Ygkl

	u16	rot_x;				///<X]px
	u16	rot_y;				///<y]px
	u16	rot_z;				///<z]px
	u16	seq_no;

	s16	rot_cx;				///<]SXWItZbg
	s16	rot_cy;				///<]SYWItZbg

	u8	ofs_pos_x;			///<eNX`͈͎w荶XW
	u8	ofs_pos_y;			///<eNX`͈͎w荶YW
	u8	ofs_size_x;			///<eNX`͈͎wXTCY
	u8	ofs_size_y;			///<eNX`͈͎wYTCY

	u8	pal_start_evy;		///<pbgtF[h START_EVYl
	u8	pal_end_evy;		///<pbgtF[h END_EVYl
	u8	pal_wait;			///<pbgtF[h waitl
	u8	pal_wait_tmp;		///<pbgtF[h wait_tmpl

	u32	pal_rgb;			///<pbgtF[h RGBl

	u32	vanish_flag		:1;	///<ojbVtO
	u32	visible_flag	:1;	///<[htOiꂪONɂȂaff_*̎w肪ɂȂ܂j
	u32	alpha			:5;	///<Alphal
	u32	diff_amb_flag	:1;	///<Diffuse Ambient Flag
	u32	spec_emi_flag	:1;	///<Specular Emission Flag
	u32	h_flip			:1;	///<]
	u32	v_flip			:1;	///<]
	u32	draw_stop		:1;	///<`Xgbv
	u32	pal_fade		:1;	///<pbgtF[h[h
	u32					:19;
}SOFT_SPRITE_PARAM;

typedef void (SOFT_SPRITE_MOVE_FUNC)(SOFT_SPRITE *ss,SOFT_SPRITE_PARAM *ssp);

///<extern錾
extern	void		*SoftSpriteInit(int heap_id);
extern	void		SoftSpriteMain(SOFT_SPRITE_MANAGER *ssm_p);
extern	void		SoftSpriteEnd(SOFT_SPRITE_MANAGER *ssm_p);
extern	void		SoftSpriteAnimeSet(SOFT_SPRITE *ss,int anm_no);
extern	SOFT_SPRITE	*SoftSpriteAdd(SOFT_SPRITE_MANAGER *ssm_p,
								   SOFT_SPRITE_ARC *ssa,
								   int pos_x,int pos_y,int pos_z,
								   int poly_id,
								   SOFT_SPRITE_ANIME *anm_tbl,
								   SOFT_SPRITE_MOVE_FUNC *move);
extern	void	SoftSpriteDel(SOFT_SPRITE *ss);

extern	void	SoftSpriteParaSet(SOFT_SPRITE *ss,int para,int data);
extern	int		SoftSpriteParaGet(SOFT_SPRITE *ss,int para);
extern	void	SoftSpriteParaCalc(SOFT_SPRITE *ss,int para,int data);
extern	void	SoftSpriteVisibleSet(SOFT_SPRITE *ss,int ofs_x,int ofs_y,int size_x,int size_y);
extern	void	SoftSpritePalFadeSet(SOFT_SPRITE *ss,int start_evy,int end_evy,int wait,int rgb);
extern	void	SoftSpritePalFadeSetAll(SOFT_SPRITE_MANAGER *ssm_p,int start_evy,int end_evy,int wait,int rgb);
extern	void	SoftSpritePalFadeOff(SOFT_SPRITE *ss);
extern	BOOL	SoftSpritePalFadeExist(SOFT_SPRITE *ss);
extern	void	SoftSpriteOYCalc(SOFT_SPRITE *ss,int height);

extern	void	SoftSpriteRecover(SOFT_SPRITE_MANAGER *ssm_p);
extern	void	SoftSpriteTextureTransParamSet(SOFT_SPRITE_MANAGER *ssm_p,u32 ofs,u32 size);
extern	void	SoftSpritePaletteTransParamSet(SOFT_SPRITE_MANAGER *ssm_p,u32 ofs,u32 size);
extern	SOFT_SPRITE_ARC	*SoftSpriteArcPointerGet(SOFT_SPRITE_MANAGER *ssm_p,int num);
extern	void	SoftSpriteTextureTrans(SOFT_SPRITE_MANAGER *ssm_p);

#endif __SOFTSPRITE_H_
