//============================================================================================
/**
 * @file	window.h
 * @brief	EBhE\
 * @author	Hiroyuki Nakamura
 * @date	2005.10.13
 */
//============================================================================================
#ifndef WINDOW_H
#define WINDOW_H
#undef GLOBAL
#ifdef WINDOW_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


#define BOARD_TYPE_TOWN	(0)	// ^E}bv
#define	BOARD_TYPE_ROAD	(1)	// W
#define	BOARD_TYPE_POST	(2)	// \D
#define	BOARD_TYPE_INFO	(3)	// f

//AZuincludeĂꍇ́A̐錾𖳎ł悤ifndefň͂ł
#ifndef	__ASM_NO_DEF_


//============================================================================================
//	萔`
//============================================================================================
#define	MENU_WIN_CGX_SIZ	( 9 )		// j[EBhẼL
#define	TALK_WIN_CGX_SIZ	( 18+12 )		// bEBhẼL
#define	BOARD_WIN_CGX_SIZ	( 18+12 )		// ŔEBhẼL
#define	BOARD_MAP_CGX_SIZ	( 24 )		// Ŕ̃}bṽL
// ŔAŔ̑SL
#define	BOARD_DATA_CGX_SIZ	( BOARD_WIN_CGX_SIZ + BOARD_MAP_CGX_SIZ )

enum {
	WINDOW_TRANS_ON = 0,
	WINDOW_TRANS_OFF
};

// j[EBhẼ^Cv
enum {
	MENU_TYPE_SYSTEM = 0,	// IEBhEiVXeEBhEj
	MENU_TYPE_FIELD,		// tB[hj[
};




//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * j[EBhẼOtBbNZbg
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[
 * @param	cgx			L]ʒu
 * @param	pal			pbgԍ
 * @param	win_num		EBhEԍ
 * @param	heap		q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void MenuWinGraphicSet(
				GF_BGL_INI * ini, u8 frmnum, u16 cgx, u8 pal, u8 win_num, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * j[EBhE`
 *
 * @param	win			BMPEBhEf[^
 * @param	trans_sw	]XCb`
 * @param	win_cgx		EBhELʒu
 * @param	pal			pbg
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BmpMenuWinWrite( GF_BGL_BMPWIN * win, u8 trans_sw, u16 win_cgx, u8 pal );

//--------------------------------------------------------------------------------------------
/**
 *	j[EBhENA
 *
 * @param	win			BMPEBhEf[^
 * @param	trans_sw	]XCb`
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BmpMenuWinClear( GF_BGL_BMPWIN * win, u8 trans_sw );

//--------------------------------------------------------------------------------------------
/**
 *	bEChEL̃A[JCuCfbNX擾
 *
 * @param	id		EBhEID
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 TalkWinCgxArcGet( u32 id );

//--------------------------------------------------------------------------------------------
/**
 *	bEChEpbg̃A[JCuCfbNX擾
 *
 * @param	id		EBhEID
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 TalkWinPalArcGet( u32 id );

//--------------------------------------------------------------------------------------------
/**
 *	bEChEZbg
 *
 * @param	ini			BGLf[^
 * @param	frm			BGt[io[(bg_sys)
 * @param	cgx			LZbgʒu
 * @param	pal			gppbg
 * @param	win_num		EBhEԍ
 * @param	heap		q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void TalkWinGraphicSet(
				GF_BGL_INI * ini, u8 frmnum, u16 cgx, u8 pal, u8 win_num, u32 heap );

GLOBAL void TalkWinGraphicNullSet(
				GF_BGL_INI * ini, u8 frmnum, u16 cgx, u8 col, u8 win_num, u32 heap );


//--------------------------------------------------------------------------------------------
/**
 * bEBhEXN[f[^ABitmapWindowɊ֘Atꂽ
 * BGt[̃XN[obt@ɃZbg
 *
 * @param   win			[in]BitmapWindow
 * @param   charno		cgxf[^ZbgĂ擪Lio
 * @param   palno		XN[쐬Ɏgppbgio
 *
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BmpTalkWinScreenSet( GF_BGL_BMPWIN * win, u32 charno, u32 palno );


//--------------------------------------------------------------------------------------------
/**
 * bEBhE`
 *
 * @param	win			BMPEBhEf[^
 * @param	trans_sw	]XCb`
 * @param	win_cgx		EBhELʒu
 * @param	pal			pbg
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BmpTalkWinWrite( GF_BGL_BMPWIN * win, u8 trans_sw, u16 win_cgx, u8 pal );

//--------------------------------------------------------------------------------------------
/**
 *	bEBhENA
 *
 * @param	win			BMPEBhEf[^
 * @param	trans_sw	]XCb`
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BmpTalkWinClear( GF_BGL_BMPWIN * win, u8 trans_sw );



//--------------------------------------------------------------------------------------------
/**
 * ҋ@ACR\^XNǉ
 *
 * @param	win		bEBhEBMP
 * @param	cgxpos	bEBhE̓]ʒu
 *
 * @return	ҋ@ACR̃[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * TimeWaitIconAdd( GF_BGL_BMPWIN * win, u32 cgxpos );

//--------------------------------------------------------------------------------------------
/**
 * ҋ@ACR\^XN폜NGXg
 *
 * @param	work	ҋ@ACR̃[N
 *
 * @return	none
 *
 *	work폜܂
 */
//--------------------------------------------------------------------------------------------
GLOBAL void TimeWaitIconDel( void * work );




//--------------------------------------------------------------------------------------------
/**
 * ŔEChEZbg
 *
 * @param	ini			BGLf[^
 * @param	frm			BGt[io[(bg_sys)
 * @param	cgx			LZbgʒu
 * @param	pal			gppbg
 * @param	type		Ŕ^Cv
 * @param	map			}bvԍi^E}bvAWj
 * @param	heap		q[vID
 *
 * @return	none
 *
 *	type = *_POST, *_INFO ̏ꍇ́Amap = 0 ŗǂ
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BoardWinGraphicSet(
				GF_BGL_INI * ini, u8 frmnum, u16 cgx, u8 pal, u8 type, u16 map, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * ŔEBhE`
 *
 * @param	win			BMPEBhEf[^
 * @param	trans_sw	]XCb`
 * @param	win_cgx		EBhELʒu
 * @param	pal			pbg
 * @param	type		Ŕ^Cv
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BmpBoardWinWrite( GF_BGL_BMPWIN * win, u8 trans_sw, u16 win_cgx, u8 pal, u8 type );

//--------------------------------------------------------------------------------------------
/**
 *	ŔEBhENA
 *
 * @param	win			BMPEBhEf[^
 * @param	type		Ŕ^Cv
 * @param	trans_sw	]XCb`
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BmpBoardWinClear( GF_BGL_BMPWIN * win, u8 type, u8 trans_sw );



#endif	__ASM_NO_DEF_

#undef GLOBAL
#endif	// WINDOW_H
