//============================================================================================
/**
 * @file	app_tool.c
 * @bfief	c[֘A
 * @author	Hiroyuki Nakamura
 * @date	05.09.28
 *
 *	Kɒǉĉ
 */
//============================================================================================
#include "common.h"

#include "system/clact_util.h"
#include "system/render_oam.h"
#include "system/brightness.h"
#include "system/wipe.h"

#define	APP_TOOL_H_GLOBAL
#include "application/app_tool.h"


//============================================================================================
//	萔`
//============================================================================================
#define	BRIGHT_SYNC			( COMM_BRIGHTNESS_SYNC )	// PxύXSync
#define	BRIGHT_IN_END		( 0 )						// PxύXIliÁj
#define	BRIGHT_IN_START		( -16 )						// PxύXJnliÁj
#define	BRIGHT_OUT_END		( -16 )						// PxύXIliÁj
#define	BRIGHT_OUT_START	( 0 )						// PxύXJnliÁj

#define	WIPE_SYNC			( COMM_BRIGHTNESS_SYNC )	// PxύXSync


//==============================================================================
//	f[^
//==============================================================================
///OAM^Cṽf[^TCYe[u
ALIGN4 static const u16 OamTypeSizeTbl[] = {
	OBJSIZE_8x8,		//OAMTYPE_8x8	
	OBJSIZE_16x16,		//OAMTYPE_16x16
	OBJSIZE_32x32,		//OAMTYPE_32x32
	OBJSIZE_64x64,		//OAMTYPE_64x64
	OBJSIZE_16x8,		//OAMTYPE_16x8
	OBJSIZE_32x8,		//OAMTYPE_32x8
	OBJSIZE_32x16,		//OAMTYPE_32x16
	OBJSIZE_64x32,		//OAMTYPE_64x32
	OBJSIZE_8x16,		//OAMTYPE_8x16
	OBJSIZE_8x32,		//OAMTYPE_8x32
	OBJSIZE_16x32,		//OAMTYPE_16x32
	OBJSIZE_32x64,		//OAMTYPE_32x64
};



//--------------------------------------------------------------
/**
 * @brief   OAM^CvOAM̃f[^TCY擾
 * @param   oam_type		OAM^Cv
 * @retval  f[^TCY(ByteP)
 */
//--------------------------------------------------------------
int APP_OamTypeToSize(int oam_type)
{
	oam_type -= OAMTYPE_8x8;	//OAMTYPE_8x80Ŏn܂ĂȂꍇlĈꉞ
	return OamTypeSizeTbl[oam_type];
}

//--------------------------------------------------------------
/**
 * @brief   obt@ɏĂ郁bZ[WOAMŏo߁A1̕тɒu
 *
 * @param   src_buf			bZ[WBMPɂĊɏĂobt@ւ̃|C^
 * @param   dest_buf		1ɕѕςʂރobt@ւ̃|C^
 * @param   oam_list[]		bZ[W\̂ɎgpOAMXg
 * @param   list_num		OAMXg̐(NELEMS(oam_list))
 *
 * src_bufGF_MSG_PrintCGXOnlyŏꂽƑz肵Ă܂B
 *
 * src_bufoam_list̊֌W͂҂܂TCŸ悪Ă̂Ƒz肵Ă܂B
 * (OAM̌Aobt@̃TCY)
 *
 * bZ[W̏c2LA1sbZ[WƂĂ邱ƂOɂĂ܂B
 */
//--------------------------------------------------------------
void APP_MsgOamSlideBuf(void *src_buf, void *dest_buf, const u8 oam_list[], int list_num)
{
	int loop;
	u32 src_ofs, dest_ofs;
	u8 *dest, *src_high, *src_low;
	int size;
	
	dest = dest_buf;
	src_high = src_buf;	//bZ[Wi
	src_low = src_buf;	//bZ[Wi
	for(loop = 0; loop < list_num; loop++){
		src_low += APP_OamTypeToSize(oam_list[loop]) / 2;
	}
	
	src_ofs = 0;
	dest_ofs = 0;
	for(loop = 0; loop < list_num; loop++){
		size = APP_OamTypeToSize(oam_list[loop]);
		MI_CpuCopy8(&src_high[src_ofs], &dest[dest_ofs], size / 2);
		dest_ofs += size / 2;
		MI_CpuCopy8(&src_low[src_ofs], &dest[dest_ofs], size / 2);
		src_ofs += size / 2;
		dest_ofs += size / 2;
	}
}




//--------------------------------------------------------------------------------------------
/**
 * ݒl̃Q[Whbg擾
 *
 * @param	prm_now		ݒl
 * @param	prm_max		ől
 * @param	dot_max		őhbg
 *
 * @return	hbg
 */
//--------------------------------------------------------------------------------------------
u8 GetNumDotto( u32 prm_now, u32 prm_max, u8 dot_max )
{
	u8 put_dot;
	
	put_dot = prm_now * dot_max / prm_max;
	if( put_dot == 0 && prm_now > 0 ){	// ޯČvZł0łۂ̒l1ȏȂ1ޯĂɂ
		put_dot = 1;
	}
	return put_dot;
}

//--------------------------------------------------------------
/**
 * @brief   \hbgƍőhbgHPQ[W̐F擾
 *
 * @param   put_dot		\hbg
 * @param   max_dot		őhbg
 *
 * @retval  Q[WJ[
 */
//--------------------------------------------------------------
u8 GetGaugeDottoColor(u32 put_dot, u32 max_dot)
{
	put_dot <<= 8;		//Zgpׁ̈Ax܂Ō悤ɌŒ菬
	max_dot <<= 8;
	
	if( put_dot > (max_dot/2) ){
		return HP_DOTTO_GREEN;		// 
	}else if( put_dot > (max_dot/5) ){
		return HP_DOTTO_YELLOW;		// 
	}else if( put_dot > 0 ){
		return HP_DOTTO_RED;		// 
	}
	return HP_DOTTO_NULL;			// HP=0
}

//--------------------------------------------------------------------------------------------
/**
 * HPQ[W̃J[擾
 *
 * @param	hp			݂HP
 * @param	mhp			őHP
 * @param	max_dot		őhbg
 *
 * @return	Q[WJ[
 */
//--------------------------------------------------------------------------------------------
u8 GetHPGaugeDottoColor( u16 hp, u16 mhp, u32 max_dot )
{
	u32 put_dot;
	
	if( hp == mhp ){ return HP_DOTTO_MAX; }
	
	put_dot = GetNumDotto( hp, mhp, max_dot );

	return GetGaugeDottoColor(put_dot, max_dot);
}



//--------------------------------------------------------------------------------------------
/**
 * PxύXNGXg
 *
 * @param	req		NGXgID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void APP_BrightnessReq( u8 req )
{
	if( req == APP_BRIGHT_IN ){
		ChangeBrightnessRequest(
			BRIGHT_SYNC, BRIGHT_IN_END, BRIGHT_IN_START, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );


	}else{
		ChangeBrightnessRequest(
			BRIGHT_SYNC, BRIGHT_OUT_END, BRIGHT_OUT_START, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * CvVXeɂtF[hNGXg
 *
 * @param	req			NGXgID
 * @param	heap		q[vID
 * @param	end_flg		ItO
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void APP_WipeStart( u8 req, u32 heap, BOOL * end_flg )
{
	if( req == APP_WIPE_IN ){
		WIPE_Start(
			WIPE_PATTERN_WMS, WIPE_TYPE_FADEIN,
			WIPE_TYPE_FADEIN, WIPE_FADE_BLACK, WIPE_SYNC, 1, heap, end_flg );
	}else{
		WIPE_Start(
			WIPE_PATTERN_WMS, WIPE_TYPE_FADEOUT,
			WIPE_TYPE_FADEOUT, WIPE_FADE_BLACK, WIPE_SYNC, 1, heap, end_flg );
	}
}


//--------------------------------------------------------------------------------------------
/**
 * ύX
 *
 * @param	num		
 * @param	max		ől
 *
 * @retval	"TRUE = ύX"
 * @retval	"FALSE = ύXĂȂ"
 */
//--------------------------------------------------------------------------------------------
u8 NumSelectCheck( s16 * num, u16 max )
{
	s16	tmp;

	tmp = *num;

	if( sys.repeat & PAD_KEY_UP ){
		*num += 1;
		if( *num > max ){ *num = 1; }
		if( *num == tmp ){ return FALSE; }
		return TRUE;
	}
	if( sys.repeat & PAD_KEY_DOWN ){
		*num -= 1;
		if( *num <= 0 ){ *num = max; }
		if( *num == tmp ){ return FALSE; }
		return TRUE;
	}
	if( sys.repeat & PAD_KEY_LEFT ){
		*num -= 10;
		if( *num <= 0 ){ *num = 1; }
		if( *num == tmp ){ return FALSE; }
		return TRUE;
	}
	if( sys.repeat & PAD_KEY_RIGHT ){
		*num += 10;
		if( *num > max ){ *num = max; }
		if( *num == tmp ){ return FALSE; }
		return TRUE;
	}

	return FALSE;
}


///06.03.11 add iwasawa
///////////////////////////////////////////////////////////////////////

/**
 *	@brief	A[JCunhEt@CidxɁA
 *			wt[̃f[^VRAM֓]
 *
 *	@param	bgl		ς݂BGLf[^
 *	@param	heapID	e|쐬Ɏgq[vnh
 *	@param	handel	I[vς݂̃A[JCut@Cnh
 *	@param	arcID	A[JCut@CID
 *	@param	dataID	A[JCuf[^ID
 *	@param	frame	f[^]GF_BGL_FRAME_***w
 *	@param	mode	0:L,1:XN[,2:pbg
 *	@param	size	]TCYw(0w肵ꍇAt@CTCY)
 *	@param	ofs		]ItZbgw
 */
void APP_ArcFileVramLoad(GF_BGL_INI* bgl,int heapID,
		ARCHANDLE* handle,int arcID,int fileID,int frame,int mode,u16 trans_siz,u16 ofs)
{
	u32	size;
	void* pSrc;
	NNSG2dCharacterData* pChar;
	NNSG2dScreenData* pScrn;	
	NNSG2dPaletteData*	pPal;
	
	size = ArchiveDataSizeGet(arcID,fileID);
	pSrc = sys_AllocMemoryLo(heapID,size);
	ArchiveDataLoadByHandle(handle,fileID,(void*)pSrc);

	switch(mode){
	case 0:	//LN^
		NNS_G2dGetUnpackedCharacterData(pSrc,&pChar); 
		if(trans_siz == 0){
			trans_siz = pChar->szByte;
		}
		OS_Printf("GF_BGL_CharSet size = %08x\n",trans_siz);
		GF_BGL_LoadCharacter(bgl,frame,
				pChar->pRawData,trans_siz,ofs);
		break;
	case 1:
		NNS_G2dGetUnpackedScreenData(pSrc,&pScrn);
		if(trans_siz == 0){
			trans_siz = pScrn->szByte;
		}

		if(GF_BGL_ScreenAdrsGet( bgl,frame) != NULL){
			GF_BGL_ScreenBufSet( bgl, frame, pScrn->rawData, trans_siz );
		}
		OS_Printf("GF_BGL_ScrnSet size = %08x\n",trans_siz);
		GF_BGL_LoadScreen( bgl, frame, pScrn->rawData, trans_siz, ofs );
		break;
	case 2:
		NNS_G2dGetUnpackedPaletteData(pSrc,&pPal);
		if(trans_siz == 0){
			trans_siz = pPal->szByte;
		}
		OS_Printf("GF_BGL_PalSet size = %08x\n",trans_siz);
		GF_BGL_PaletteSet(frame,pPal->pRawData,trans_siz,ofs);
	}
	sys_FreeMemoryEz(pSrc);
}

/**
 *	@brief	I[vς݂̃A[JCut@Cnhn
 *			A[JCũXN[f[^UnpackĎ擾
 *
 *	@param	handel	I[vς݂̃A[JCut@Cnh
 *	@param	arcID	A[JCut@CID
 *	@param	dataID	A[JCuf[^ID
 *	@param	heapID	mۂq[vnh
 *
 *	@return void*	mۂf[^̈̐擪|C^
 *	
 *	Unpack邾Ȃ̂ŁA͎ł邱ƁI
 */
void* APP_ArcScrFileUnpack(ARCHANDLE* handle,
	int arcID,int fileID,NNSG2dScreenData** pDat,int heapID)
{
	int size;
	void* pBuf;
	
	size = ArchiveDataSizeGet(arcID,fileID);
	pBuf = sys_AllocMemory(heapID,size);
	ArchiveDataLoadByHandle(handle,fileID,pBuf);
	NNS_G2dGetUnpackedScreenData(pBuf,pDat);

	return pBuf;
}

