//============================================================================================
/**
 * @file	bag.c	
 * @bfief	obOʏ
 * @author	Hiroyuki Nakamura
 * @date	05.07.14
 */
//============================================================================================
#include "common.h"
#include "system/gamedata.h"
#include "system/procsys.h"
#include "system/fontproc.h"
#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "system/window.h"
#include "system/pm_str.h"
#include "system/lib_pack.h"
#include "system/snd_tool.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/clact_util.h"
#include "system/clact_tool.h"
#include "system/render_oam.h"
#include "system/brightness.h"
#include "system/buflen.h"
#include "system/msgdata.h"
#include "system/wordset.h"
#include "system/numfont.h"
#include "system/mystatus.h"
#include "gflib/touchpanel.h"
#include "itemtool/item.h"
#include "itemtool/myitem.h"
#include "itemtool/itemicon.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_bag.h"
#include "msgdata/msg_common_scr.h"
#include "application/app_tool.h"

#define	BAG_H_GLOBAL
#include "application/bag.h"
#include "bag_sys.h"
#include "bag_obj.h"
#include "bag_bmp.h"
#include "bag_snd_def.h"
#include "bag_gra.naix"


//============================================================================================
//	萔`
//============================================================================================
enum {
	SEQ_IN = 0,
	SEQ_MAIN,
	SEQ_PAGE,
	SEQ_IREKAE,
	SEQ_MENU,
	SEQ_YESNO,
	SEQ_NUM,

	SEQ_ITEM_SUB_MAIN,		// j[uĂvI
	SEQ_ITEM_SUB_YN_INIT,	// j[uĂv͂E
	SEQ_ITEM_SUB_YN_SEL,	// j[uĂv͂E
	SEQ_ITEM_SUB_CMP,		// j[uĂv
	SEQ_ITEM_SUB_RET,		// j[uĂvbZ[WI҂{^҂ -> C

	SEQ_ITEM_ERR_WAIT,	// ACegps

	SEQ_ITEMSET_MAIN,	// |PXguvACeI
	SEQ_ITEMSET_ERR,	// |PXguvs

	SEQ_SALE_MAIN,		// uv[hACeI
	SEQ_SALE_NUM_INIT,	// uv[hI
	SEQ_SALE_NUM_SEL,	// uv[hI
	SEQ_SALE_YN_INIT,	// uv͂E
	SEQ_SALE_YN_SEL,	// uv͂E
	SEQ_SALE_CMP,		// uv
	SEQ_SALE_RET,		// uvbZ[WI҂{^҂ -> C

	SEQ_KINOMISEL_MAIN,	// ؂̎֘AI

	SEQ_OUT,
};

#define	WIPE_COUNT_M	( 192 )		// ʂ̃EBhEGtFNgJE^̍ől
#define	WIPE_COUNT_S	( 384 )		// ʂ̃EBhEGtFNgJE^̍ől
#define	WIPE_SPEED		( 16 )		// EBhEGtFNgXs[h
#define	VCOUNT_MAX		( 262 )		// VJE^ől
// EBhẼ}XN
#define	WIPE_MASK		(	GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG1 | \
							GX_WND_PLANEMASK_BG2 | GX_WND_PLANEMASK_BG3 | \
							GX_WND_PLANEMASK_OBJ )

// ACeXgI
enum {
	LIST_SEL_NONE = 0,	// I
	LIST_SEL_ITEM,		// ACeI
	LIST_SEL_CHANGE,	// ւ
	LIST_SEL_CANCEL		// LZ
};


// {^f[^
typedef struct {
	const u8 * write_tbl;			// {^ʒuiLPʁj
	const RECT_HIT_TBL * rect_tbl;	// ^b`ple[u
}SUB_BUTTON_POS;

// {^AjpTCB[N
typedef struct {
	BAG_WORK * bag_wk;	// obOʂ̃[N
	u8	seq;			// V[PX
	u8	cnt;			// JE^
	u8	button;			// {^ԍ
}BUTTON_ANM_WORK;

// {^Ajp[N
typedef struct {
	u8	seq;			// V[PX
	u8	cnt;			// JE^
	u8	button;			// {^ԍ
}BUTTON_ANM_WK;

#define	BAG_TMPMSG_SIZ	( 256 )		// bZ[WWJꏊ̕


//============================================================================================
//	vg^Cv錾
//============================================================================================
static PROC_RESULT BagProc_Init( PROC * proc, int * seq );
static PROC_RESULT BagProc_Main( PROC * proc, int * seq );
static PROC_RESULT BagProc_End( PROC * proc, int * seq );

static void BagVBlank(void * work);
static void BagVramBankSet(void);
static void BagBgSet( GF_BGL_INI * ini );
static void BagBgExit( GF_BGL_INI * ini );
static void BagBgGraphicSet( BAG_WORK * wk );
static void BagWindowSet(void);
static u8 ItemListControl( BAG_WORK * wk );
static u8 PocketControl( BAG_WORK * wk );
static int MenuControl( BAG_WORK * wk );
static void BagInWipeEff(void * work);
static void ItemListDataMake( BAG_WORK * wk );
static void ItemListSet( BAG_WORK * wk, u16 scr, u16 pos );
static void CB_ItemListMove( BMPLIST_WORK * work, u32 param, u8 mode );
static void CB_ItemListWrite( BMPLIST_WORK * work, u32 param, u8 y );
static void ItemListExit( BAG_WORK * wk );
static void ItemInfoPrint( u16 id, s8 wait );
static void CellActorTest(void);
static void WipeEffOff(void);
static void BagCellActorInit( BAG_WORK * wk );
static void BagActSet( BAG_WORK * wk );
static void PocketDataInit( BAG_WORK * wk );
static u8 PocketCursorObjPXGet( BAG_WORK * wk, u8 poke );
static void PocketIconXmake( BAG_WORK * wk );
static int SubPokeButtonCheck( BAG_WORK * wk );
static void PokeArrowMove( BAG_WORK * wk );
static void SubPokeButtonBgChg( BAG_WORK * wk, u8 num, u8 anm );
static u8 PocketButtonControl( BAG_WORK * wk );
static int SubPokeButtonEndCheck( BAG_WORK * wk );
static void ItemMenuExit( BAG_WORK * wk );
static u8 PocketChangeReset( BAG_WORK * wk );
static u8 PocketCursorMove( BAG_WORK * wk );
static void SubPokeButtonBgChg( BAG_WORK * wk, u8 num, u8 anm );
static void SubPokeButtonBgInit( BAG_WORK * wk );
static u8 ItemChangeChack( BAG_WORK * wk );
static void ItemChangeInit( BAG_WORK * wk );
static u8 ItemChangeMain( BAG_WORK * wk );
static void ItemChangeComp( BAG_WORK * wk );
static void ItemChangeEnd( BAG_WORK * wk );
static void ItemChgCursorChg( BAG_WORK * wk );
static void ItemIconChange( BAG_WORK * wk, u16 item );
static void PocketChangeInitKey( BAG_WORK * wk );
static void PocketChangeInitTp( BAG_WORK * wk );
static void PocketChangeInit( BAG_WORK * wk );
static u8 PocketChange( BAG_WORK * wk );
static u8 PocketChangeReset( BAG_WORK * wk );
static u8 ButtonAnmTask( BAG_WORK * wk );
static u8 PocketCursorMove( BAG_WORK * wk );
static void MsgManCreate( BAG_WORK * wk );
static void PocketNameScreenPut( BAG_WORK * wk );
static void ItemMenuMake( BAG_WORK * wk );
static void ItemListStrAlloc( BAG_WORK * wk );
static void ItemListStrFree( BAG_WORK * wk );
static int Bag_MenuUse( BAG_WORK * wk );
static int MainSeqFunc( BAG_WORK * wk );
static int SaleMainSeq( BAG_WORK * wk );
static int SaleRetSeq( BAG_WORK * wk );
static int SaleNumInitSeq( BAG_WORK * wk );
static int SaleNumSelSeq( BAG_WORK * wk );
static int SaleYesNoInitSeq( BAG_WORK * wk );
static int SaleYesNoSelectSeq( BAG_WORK * wk );
static int SaleCmpSeq( BAG_WORK * wk );
static int ItemErrWaitSeq( BAG_WORK * wk );
static int Bag_MenuTag( BAG_WORK * wk );
static int Bag_MenuSub( BAG_WORK * wk );
static int Bag_MenuSubMain( BAG_WORK * wk );
static int Bag_MenuSubYesNoInitSeq( BAG_WORK * wk );
static int Bag_MenuSubYesNoSelectSeq( BAG_WORK * wk );
static int Bag_MenuSubCmpSeq( BAG_WORK * wk );
static int Bag_MenuSubRetSeq( BAG_WORK * wk );
static int Bag_MenuSet( BAG_WORK * wk );
static int PokeItemSet_MainSeq( BAG_WORK * wk );
static int PokeItemSet_ErrorSeq( BAG_WORK * wk );
static int KinomiSel_MainSeq( BAG_WORK * wk );


//============================================================================================
//	O[oϐ
//============================================================================================
static u32	WipeCount = 0;		// EBhEGtFNgpJE^ ( HBLANK )

// vZX`f[^
const PROC_DATA BagProcData = {
	BagProc_Init,
	BagProc_Main,
	BagProc_End,
	NO_OVERLAY_ID,
};

// ACeXgf[^iBMPXgj
static const BMPLIST_HEADER BagItemList = {
	NULL, CB_ItemListMove, CB_ItemListWrite, NULL,
	0, 9, 0,
	0, 0,			// X, J[\X
	0,				// \Y
	FBMP_COL_BLACK, FBMP_COL_NULL, FBMP_COL_BLK_SDW,
	0, 16,						// Ԋux
	BMPLIST_NO_SKIP, FONT_SYSTEM, 1,
	NULL,
};



// 8{^̈ʒue[u
static const u8 PokeButtonPos8[] = {
	1, 4,	2, 10,	5, 15,	10, 18,	17, 18,	22, 15,	25, 10,	26, 4,
};

// 8{^̃^b`ple[u
static const RECT_HIT_TBL PokeButtonRect8[] =
{
	{ 4*8,	9*8-1,	1*8,  6*8-1 },
	{ 10*8,	15*8-1,	2*8,  7*8-1 },
	{ 15*8,	20*8-1,	5*8,  10*8-1 },
	{ 18*8,	23*8-1,	10*8, 15*8-1 },
	{ 18*8,	23*8-1,	17*8, 22*8-1 },
	{ 15*8,	20*8-1, 22*8, 27*8-1 },
	{ 10*8,	15*8-1, 25*8, 30*8-1 },
	{ 4*8,	9*8-1,	26*8, 31*8-1 },
	{ RECT_HIT_END, 0, 0, 0 }
};

// 4{^̈ʒue[u
static const u8 PokeButtonPos4[] = {
	1, 4,	5, 15,	22, 15,	26, 4,
};

// 4{^̃^b`ple[u
static const RECT_HIT_TBL PokeButtonRect4[] =
{
	{ 4*8,	9*8-1,	1*8,  6*8-1 },
	{ 15*8,	20*8-1,	5*8,  10*8-1 },
	{ 15*8,	20*8-1, 22*8, 27*8-1 },
	{ 4*8,	9*8-1,	26*8, 31*8-1 },
	{ RECT_HIT_END, 0, 0, 0 }
};

// 1{^̈ʒue[u
static const u8 PokeButtonPos1[] = {
	17, 18,
};

// 1{^̃^b`ple[u
static const RECT_HIT_TBL PokeButtonRect1[] =
{
	{ 18*8,	23*8-1,	17*8, 22*8-1 },
	{ RECT_HIT_END, 0, 0, 0 }
};

// {^f[^
static const SUB_BUTTON_POS PokeButtonPos[] =
{
	{ NULL, NULL },							// 0
	{ PokeButtonPos1, PokeButtonRect1 },	// 1
	{ NULL, NULL },							// 2
	{ NULL, NULL },							// 3
	{ PokeButtonPos4, PokeButtonRect4 },	// 4
	{ NULL, NULL },							// 5
	{ NULL, NULL },							// 6
	{ NULL, NULL },							// 7
	{ PokeButtonPos8, PokeButtonRect8 }		// 8
};



static const u8 PocketMax[] = {
	BAG_EVENT_ITEM_MAX,		// ؂ȕ|Pbgő吔
	BAG_NORMAL_ITEM_MAX,	// |Pbgő吔
	BAG_NUTS_ITEM_MAX,		// ؂̎|Pbgő吔
	BAG_DRUG_ITEM_MAX,		// |Pbgő吔
	BAG_BALL_ITEM_MAX,		// X^[{[|Pbgő吔
	BAG_BATTLE_ITEM_MAX,	// 퓬pACe|Pbgő吔
	BAG_SEAL_ITEM_MAX,		// V[|Pbgő吔
	BAG_WAZA_ITEM_MAX,		// Z}V|Pbgő吔
};


// j[p[^e[u
static const u32 MenuParamTbl[] = {
	(u32)Bag_MenuUse,	// msg_bag_001	
	(u32)Bag_MenuUse,	// msg_bag_007	
	(u32)Bag_MenuUse,	// msg_bag_017	݂
	(u32)Bag_MenuSub,	// msg_bag_002	Ă
	BMPMENU_CANCEL,	// msg_bag_003	Ƃ낭
	BMPMENU_CANCEL,	// msg_bag_019	
	(u32)Bag_MenuSet,	// msg_bag_004	
	(u32)Bag_MenuTag,	// msg_bag_005	^O݂
	BMPMENU_CANCEL,	// msg_bag_009	߂
};



//============================================================================================
//	f[^ݒ
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * obOʂ̃f[^̈m
 *
 * @param	mode	擾[h
 *
 * @return	mۂ̈̃AhX
 */
//--------------------------------------------------------------------------------------------
BAG_DATA * BagSystemDataAlloc( u8 mode )
{
	BAG_DATA * wk = (BAG_DATA *)sys_AllocMemory( mode, sizeof(BAG_DATA) );
	memset( wk, 0, sizeof(BAG_DATA) );
	return wk;
}

u32 BagSystemDataSizeGet(void)
{
	return sizeof(BAG_DATA);
}


//--------------------------------------------------------------------------------------------
/**
 * obOʂ̏f[^쐬
 *
 * @param	dat		f[^ݒꏊ
 * @param	page	y[W
 * @param	mode	obOʂ̖
 * @param	mysy	MYSTATUS
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BagSystemDataSet( BAG_DATA * dat, u8 page, u8 mode, void * myst )
{
	dat->p_now = page;
	dat->mode  = mode;
	dat->ret_item = 0;
	dat->myst = myst;
}

//--------------------------------------------------------------------------------------------
/**
 * |Pbgf[^쐬
 *
 * @param	dat		obOʂ̃f[^
 * @param	item	QƂACef[^
 * @param	type	|Pbg^Cv
 * @param	poke	|Pbgԍ
 * @param	cur		J[\ʒu
 * @param	scr		XN[JE^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BagPocketDataMake( BAG_DATA * dat, MINEITEM * item, u8 type, u8 poke, u16 cur, u16 scr )
{
	if( cur == 0 ){ cur = 1; }			// ԏ̓xȂ̂ŕ␳

	dat->p_data[poke].item = item;		// QƂACef[^
	dat->p_data[poke].cur  = cur;		// J[\ʒu
	dat->p_data[poke].scr  = scr;		// XN[JE^
//	dat->p_data[poke].pos  = cur + scr;	// ݒl ( cur + scr )
	dat->p_data[poke].type = type;		// |Pbg^Cv
}

//--------------------------------------------------------------------------------------------
/**
 * ]ԃtOZbg
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BagCycleFlagSet( BAG_DATA * dat )
{
	dat->cycle_flg = 1;
}

//--------------------------------------------------------------------------------------------
/**
 * nړ`FbNtOZbg
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BagUnderCheckFlagSet( BAG_DATA * dat )
{
	dat->under_flg = 1;
}

//--------------------------------------------------------------------------------------------
/**
 * f[^擾F݂̃|Pbgԍ
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	݂̃|Pbgԍ
 */
//--------------------------------------------------------------------------------------------
u8 BagSysNowPocketNumGet( BAG_DATA * dat )
{
	return dat->p_now;
}

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FobOʂ̖
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	obOʂ̖
 */
//--------------------------------------------------------------------------------------------
u8 BagSysModeGet( BAG_DATA * dat )
{
	return dat->mode;
}

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FobOŎ擾ACe
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	obOŎ擾ACe
 */
//--------------------------------------------------------------------------------------------
u16 BagSysReturnItemGet( BAG_DATA * dat )
{
	return dat->ret_item;
}

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FobO̖߂l
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	obO̖߂l
 */
//--------------------------------------------------------------------------------------------
u16 BagSysReturnModeGet( BAG_DATA * dat )
{
	return dat->ret_mode;
}

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FJ[\ʒuAXN[JE^
 *
 * @param	dat		obOʂ̃f[^
 * @param	poke	|Pbgԍ
 * @param	cur		J[\ʒu
 * @param	scr		XN[JE^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BagCursorPosGet( BAG_DATA * dat, u8 poke, u16 * cur, u16 * scr )
{
	if( cur != NULL ){
		*cur = dat->p_data[poke].cur;
	}
	if( scr != NULL ){
		*scr = dat->p_data[poke].scr;
	}
}


//============================================================================================
//	vZX֐
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * vZX֐F
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT BagProc_Init( PROC * proc, int * seq )
{
	BAG_WORK * wk;

	sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
	sys_HBlankIntrStop();				// HBlank~

	GF_Disp_GX_VisibleControlInit();
	GF_Disp_GXS_VisibleControlInit();
	GX_SetVisiblePlane( 0 );
	GXS_SetVisiblePlane( 0 );

	WipeCount = 0;			// EBhEGtFNgJE^

	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_BAG, 0x20000 );

	wk = PROC_AllocWork( proc, sizeof(BAG_WORK), HEAPID_BAG );
	memset( wk, 0, sizeof(BAG_WORK) );
	wk->dat = PROC_GetParentWork( proc );
	wk->bgl = GF_BGL_BglIniAlloc( HEAPID_BAG );

	wk->sex  = MyStatus_GetMySex( wk->dat->myst );
	wk->gold = MyStatus_GetGold( wk->dat->myst );

	APP_WipeStart( APP_WIPE_IN, HEAPID_BAG, &wk->wipe_flg );

	MsgManCreate( wk );
	ItemListStrAlloc( wk );

	sys_KeyRepeatSpeedSet( 4, 8 );

	PocketDataInit( wk );				// |Pbgݒ
	PocketIconXmake( wk );				// ACR̍W擾

	BagVramBankSet();					// VRAMݒ
	BagBgSet( wk->bgl );				// BGݒ
	BagBgGraphicSet( wk );				// BGOtBbNZbg

	SubPokeButtonBgInit( wk );

	InitTPSystem();						// ^b`plVXe
	InitTPNoBuff(4);

	BagCellActorInit( wk );				// ZAN^[
	BagActSet( wk );

	BagBmpWinSet( wk );					// BMPEBhEݒ

	Bag_PocketNameMake( wk );			// |Pbg擾
	Bag_PocketNameScreenPut( wk );		// |PbgXN[ɔf
	Bag_PocketNamePut( wk );			// |Pbg\
	Bag_PocketIconPutAll( wk );			// |PbgACR\

	Bag_MenuStrGet( wk );				// j[ڎ擾
	Bag_NumStrGet( wk );				// \擾

	ItemListDataMake( wk );				// ACeXg쐬

	// ACeXgݒ
	ItemListSet(
		wk, wk->dat->p_data[wk->dat->p_now].scr, wk->dat->p_data[wk->dat->p_now].cur );

	BagWindowSet();						// EBhEݒ

	sys_HBlankIntrSet( BagInWipeEff, NULL );	// HBlankZbg
	sys_VBlankFuncChange( BagVBlank, NULL );	// VBlankZbg

	Snd_DataSetByScene( SND_SCENE_SUB_BAG, 0, 0 );	// TEhf[^[h(obO)(BGMp)

	return PROC_RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * vZX֐FC
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT BagProc_Main( PROC * proc, int * seq )
{
	BAG_WORK * wk  = PROC_GetWork( proc );

	switch( *seq ){
	case SEQ_IN:
		if( wk->wipe_flg == TRUE && WipeCount > WIPE_COUNT_S ){
			WipeEffOff();
			if( wk->dat->mode == BAG_MODE_ITEMSALE ){
				*seq = SEQ_SALE_MAIN;
			}else if( wk->dat->mode == BAG_MODE_ITEMSET ){
				*seq = SEQ_ITEMSET_MAIN;
			}else if( wk->dat->mode == BAG_MODE_KINOMI ){
				*seq = SEQ_KINOMISEL_MAIN;
			}else{
				*seq = SEQ_MAIN;
			}
		}
		break;

	case SEQ_MAIN:
		*seq = MainSeqFunc( wk );
		break;

	case SEQ_PAGE:
		PokeArrowMove( wk );
		if( PocketChange( wk ) == TRUE ){
			if( wk->dat->mode == BAG_MODE_ITEMSALE ){
				*seq = SEQ_SALE_MAIN;
			}else if( wk->dat->mode == BAG_MODE_ITEMSET ){
				*seq = SEQ_ITEMSET_MAIN;
			}else if( wk->dat->mode == BAG_MODE_KINOMI ){
				*seq = SEQ_KINOMISEL_MAIN;
			}else{
				*seq = SEQ_MAIN;
			}
		}
		break;

	case SEQ_IREKAE:
		if( ItemChangeMain( wk ) == TRUE ){
			*seq = SEQ_MAIN;
		}
		break;

	case SEQ_MENU:
		*seq = MenuControl( wk );
		break;

	case SEQ_YESNO:
		break;
	case SEQ_NUM:
		break;

	case SEQ_ITEM_SUB_MAIN:		// j[uĂvI
		*seq = Bag_MenuSubMain( wk );
		break;
	case SEQ_ITEM_SUB_YN_INIT:	// j[uĂv͂E
		*seq = Bag_MenuSubYesNoInitSeq( wk );
		break;
	case SEQ_ITEM_SUB_YN_SEL:	// j[uĂv͂E
		*seq = Bag_MenuSubYesNoSelectSeq( wk );
		break;
	case SEQ_ITEM_SUB_CMP:		// j[uĂv
		*seq = Bag_MenuSubCmpSeq( wk );
		break;
	case SEQ_ITEM_SUB_RET:		// j[uĂvbZ[WI҂{^҂ -> C
		*seq = Bag_MenuSubRetSeq( wk );
		break;

	case SEQ_ITEM_ERR_WAIT:
		*seq = ItemErrWaitSeq( wk );
		break;

	case SEQ_ITEMSET_MAIN:
		*seq = PokeItemSet_MainSeq( wk );
		break;
	case SEQ_ITEMSET_ERR:
		*seq = PokeItemSet_ErrorSeq( wk );
		break;

	case SEQ_SALE_MAIN:		// uv[hACeI
		*seq = SaleMainSeq( wk );
		break;
	case SEQ_SALE_NUM_INIT:	// uv[hI
		*seq = SaleNumInitSeq( wk );
		break;
	case SEQ_SALE_NUM_SEL:	// uv[hI
		*seq = SaleNumSelSeq( wk );
		break;
	case SEQ_SALE_YN_INIT:	// uv͂E
		*seq = SaleYesNoInitSeq( wk );
		break;
	case SEQ_SALE_YN_SEL:	// uv͂E
		*seq = SaleYesNoSelectSeq( wk );
		break;
	case SEQ_SALE_CMP:		// uv
		*seq = SaleCmpSeq( wk );
		break;
	case SEQ_SALE_RET:		// uvbZ[WI҂{^҂ -> C
		*seq = SaleRetSeq( wk );
		break;

	case SEQ_KINOMISEL_MAIN:	// ؂̎֘AI
		*seq = KinomiSel_MainSeq( wk );
		break;

	case SEQ_OUT:
		if( wk->wipe_flg == TRUE ){
			return PROC_RES_FINISH;
		}
		break;
	}

	CATS_Draw( wk->crp );

	return PROC_RES_CONTINUE;
}

//--------------------------------------------------------------------------------------------
/**
 * vZX֐FI
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT BagProc_End( PROC * proc, int * seq )
{
	BAG_WORK * wk  = PROC_GetWork( proc );

	CATS_ResourceDestructor( wk->csp, wk->crp );
	CATS_FreeMemory( wk->csp );

	ItemListExit( wk );				// ACeXg폜
	BagBmpWinExit( wk->win );		// BMPEBhEJ
	BagBgExit( wk->bgl );			// BGL폜
	StopTP();						// ^b`plI
	DellVramTransferManager();

	Bag_MenuStrRelease( wk );
	Bag_PocketNameRelease( wk );
	Bag_NumStrRelease( wk );

	ItemListStrFree( wk );

	STRBUF_Delete( wk->expb );

	MSGMAN_Delete( wk->item_man );
	MSGMAN_Delete( wk->msg_man );
	NUMFONT_Delete( wk->num_font );
	WORDSET_Delete( wk->wset );

	PROC_FreeWork( proc );				// [NJ

	sys_VBlankFuncChange( NULL, NULL );		// VBlankZbg

	sys_DeleteHeap( HEAPID_BAG );

	return PROC_RES_FINISH;
}


//============================================================================================
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * VBlank֐
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BagVBlank( void * work )
{
	// ZAN^[
	DoVramTransferManager();	// Vram]}l[W[s
//	REND_OAMTrans();			// _LOAM}l[WVram]

	CATS_RenderOamTrans();

	
	OS_SetIrqCheckFlag( OS_IE_V_BLANK );
}

//--------------------------------------------------------------------------------------------
/**
 * VRAMݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BagVramBankSet(void)
{
	GF_BGL_DISPVRAM tbl = {
		GX_VRAM_BG_128_A,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg

		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg

		GX_VRAM_OBJ_128_B,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg

		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg

		GX_VRAM_TEX_NONE,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_NONE			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &tbl );

//	GX_SetOBJVRamModeChar( GX_OBJVRAMMODE_CHAR_2D );	// 2D mapping mode
}

//--------------------------------------------------------------------------------------------
/**
 * BGݒ
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BagBgSet( GF_BGL_INI * ini )
{
	{	// BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	{	// MENU & INFO (BMP)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_M );
	}

	{	// FRAME (CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}

	{	// ITEM LIST (BMP)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME2_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME2_M );
	}

	{	// LIST BACK (CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME3_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}

	{	// BUTTON (CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_S );
	}

	{	// BAG GRAPHIC (CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}

	GF_BGL_ClearCharSet( GF_BGL_FRAME0_M, 32, 0, HEAPID_BAG );
	GF_BGL_ClearCharSet( GF_BGL_FRAME0_S, 32, 0, HEAPID_BAG );
}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BagBgExit( GF_BGL_INI * ini )
{
	GF_Disp_GX_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_BG2 |
		GX_PLANEMASK_BG3 | GX_PLANEMASK_OBJ, VISIBLE_OFF );
	GF_Disp_GXS_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_OBJ, VISIBLE_OFF );

	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME3_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_M );

	sys_FreeMemory( HEAPID_BAG, ini );
}

//--------------------------------------------------------------------------------------------
/**
 * OtBbNf[^Zbg
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BagBgGraphicSet( BAG_WORK * wk )
{
	ArcUtil_BgCharSet(
		ARC_BAG_GRA, NARC_bag_gra_bag_bg_NCGR, wk->bgl, GF_BGL_FRAME1_M, 0, 0, 0, HEAPID_BAG );
	ArcUtil_ScrnSet(
		ARC_BAG_GRA, NARC_bag_gra_bag_bg1_NSCR, wk->bgl, GF_BGL_FRAME1_M, 0, 0, 0, HEAPID_BAG );
	ArcUtil_ScrnSet(
		ARC_BAG_GRA, NARC_bag_gra_bag_bg0_NSCR, wk->bgl, GF_BGL_FRAME3_M, 0, 0, 0, HEAPID_BAG );
	ArcUtil_PalSet(
		ARC_BAG_GRA, NARC_bag_gra_bag_bg_NCLR, PALTYPE_MAIN_BG, 0, 0, HEAPID_BAG );

	// ACRpbg
	ArcUtil_PalSet(
		ARC_BAG_GRA, NARC_bag_gra_bag_pocketlist_NCLR, PALTYPE_MAIN_BG, 16*13*2, 32, HEAPID_BAG );

	SystemFontPaletteLoad( PALTYPE_MAIN_BG, SYS_FONT_PAL * 32, HEAPID_BAG );
	TalkFontPaletteLoad( PALTYPE_MAIN_BG, TALK_FONT_PAL * 32, HEAPID_BAG );

	// j[EBhEZbg
	MenuWinGraphicSet( wk->bgl, GF_BGL_FRAME0_M, MENU_WIN_CGX_NUM, MENU_WIN_PAL, 0, HEAPID_BAG );
	// bEBhEZbg
	TalkWinGraphicSet( wk->bgl, GF_BGL_FRAME0_M, TALK_WIN_CGX_NUM, TALKWIN_PAL, 0, HEAPID_BAG );

	ArcUtil_BgCharSet(
		ARC_BAG_GRA, NARC_bag_gra_bag_bg_s_NCGR, wk->bgl, GF_BGL_FRAME1_S, 0, 0, 0, HEAPID_BAG );
	ArcUtil_PalSet(
		ARC_BAG_GRA, NARC_bag_gra_bag_bg_s_NCLR, PALTYPE_SUB_BG, 0, 0, HEAPID_BAG );
	if( wk->sex == 0 ){
		ArcUtil_ScrnSet(
			ARC_BAG_GRA, NARC_bag_gra_bag_bg_s0_NSCR,
			wk->bgl, GF_BGL_FRAME1_S, 0, 0, 0, HEAPID_BAG );
	}else{
		ArcUtil_ScrnSet(
			ARC_BAG_GRA, NARC_bag_gra_bag_bg_s2_NSCR,
			wk->bgl, GF_BGL_FRAME1_S, 0, 0, 0, HEAPID_BAG );
	}


	// {^
	ArcUtil_BgCharSet(
		ARC_BAG_GRA,NARC_bag_gra_bag_button2_NCGR,wk->bgl,GF_BGL_FRAME0_S,0,0,0,HEAPID_BAG );
	ArcUtil_PalSet(
		ARC_BAG_GRA, NARC_bag_gra_bag_button_NCLR, PALTYPE_SUB_BG, 16*1*2, 32, HEAPID_BAG );
}

//--------------------------------------------------------------------------------------------
/**
 * bZ[W֘A쐬
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void MsgManCreate( BAG_WORK * wk )
{
	// bZ[W}l[W쐬
	wk->msg_man = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_bag_dat, HEAPID_BAG );
	// 8x8tHg쐬
	wk->num_font = NUMFONT_Create( FBMP_COL_BLACK, FBMP_COL_BLK_SDW, FBMP_COL_NULL, HEAPID_BAG );

	wk->wset = WORDSET_Create( HEAPID_BAG );

	wk->item_man = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_itemname_dat, HEAPID_BAG );

	// bZ[WWJpobt@
	wk->expb = STRBUF_Create( BAG_TMPMSG_SIZ, HEAPID_BAG );
}

//--------------------------------------------------------------------------------------------
/**
 * EBhEݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BagWindowSet(void)
{
	GX_SetVisibleWnd( GX_WNDMASK_W0 );
	G2_SetWnd0InsidePlane( GX_WND_PLANEMASK_NONE, 1 );
	G2_SetWndOutsidePlane( GX_WND_PLANEMASK_NONE, 1 );
	G2_SetWnd0Position( 0, 255, 0, 192 );

	GXS_SetVisibleWnd( GX_WNDMASK_W0 );
	G2S_SetWnd0InsidePlane( GX_WND_PLANEMASK_NONE, 1 );
	G2S_SetWndOutsidePlane( GX_WND_PLANEMASK_NONE, 1 );
	G2S_SetWnd0Position( 0, 255, 0, 192 );
}

//--------------------------------------------------------------------------------------------
/**
 * EBhEGtFNg
 *
 * @param	none
 *
 * @return	none
 *
 * @li	HBlank̏
 */
//--------------------------------------------------------------------------------------------
static void BagInWipeEff(void * work)
{
	s32	v_cnt = GX_GetVCount();

	if( WipeCount < WIPE_COUNT_M ){
		G2_SetWnd0Position( 0, WipeCount, 0, 192 );
		if( v_cnt < WipeCount ){
			G2_SetWndOutsidePlane( WIPE_MASK, 1 );
		}else{
			G2_SetWndOutsidePlane( GX_WND_PLANEMASK_NONE, 1 );
		}
	}else if( WipeCount <= WIPE_COUNT_S ){
		u32	w_cnt = WipeCount - WIPE_COUNT_M;

		G2S_SetWnd0Position( 0, w_cnt, 0, 192 );
		if( v_cnt <= w_cnt ){
			G2S_SetWndOutsidePlane( WIPE_MASK, 1 );
		}else{
			G2S_SetWndOutsidePlane( GX_WND_PLANEMASK_NONE, 1 );
		}
	}

	if( v_cnt == VCOUNT_MAX && WipeCount <= WIPE_COUNT_S ){
		G2_SetWndOutsidePlane( WIPE_MASK, 1 );
		if( WipeCount > WIPE_COUNT_M ){
			G2S_SetWndOutsidePlane( WIPE_MASK, 1 );
		}
		WipeCount += WIPE_SPEED;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * EBhEGtFNgI
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void WipeEffOff(void)
{
	WipeCount = 0;
	sys_HBlankIntrStop();				//HBlank荞ݒ~
	GX_SetVisibleWnd( GX_WNDMASK_NONE );
	GXS_SetVisibleWnd( GX_WNDMASK_NONE );
}





//--------------------------------------------------------------------------------------------
/**
 * |Pbg擾
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void PocketDataInit( BAG_WORK * wk )
{
	u8	i;

	wk->p_max = 0;
	for( i=0; i<BAG_POKE_MAX; i++ ){
		if( wk->dat->p_data[i].item != 0 ){
			wk->p_max++;
		}
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ݂̃|Pbg̎wʒũACe擾
 *
 * @param	wk		obOʂ̃[N
 * @param	pos		ʒu
 * @param	id		擾ID
 *
 * @return	wʒũACe
 *
 * @li	id = POS_GET_ID : ACeԍ
 * @li	id = POS_GET_NUM : 
 */
//--------------------------------------------------------------------------------------------
u16 Bag_PosItemGet( BAG_WORK * wk, u16 pos, u16 id )
{
	POCKET_DATA * pocket = &wk->dat->p_data[wk->dat->p_now];

	if( id == POS_GET_ID ){
		return pocket->item[pos].id;
	}
	return pocket->item[pos].no;
}

//--------------------------------------------------------------------------------------------
/**
 * ACeXgf[^쐬
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BAG_GetItemName( MSGDATA_MANAGER * man, STRBUF * buf, u16 item, u32 heap_id )
{
	MSGMAN_GetString( man, item, buf );
}



static void ItemListDataMake( BAG_WORK * wk )
{
	POCKET_DATA * pocket;
	u32	i, j;
	
	pocket = &wk->dat->p_data[wk->dat->p_now];

	wk->ld = BMP_MENULIST_Create( PocketMax[wk->dat->p_now]+3, HEAPID_BAG );

	BMP_MENULIST_AddArchiveString( wk->ld, wk->msg_man, msg_bag_033, BMPLIST_RABEL );
	for( i=0; i<PocketMax[wk->dat->p_now]; i++ ){
		if( pocket->item[i].id == 0 || pocket->item[i].no == 0 ){
			break;
		}
//		GetItemName( wk->itemname[i], pocket->item[i].id, HEAPID_BAG );
		BAG_GetItemName( wk->item_man, wk->itemname[i], pocket->item[i].id, HEAPID_BAG );
		BMP_MENULIST_AddString( wk->ld, wk->itemname[i], i );
	}
	BMP_MENULIST_AddArchiveString( wk->ld, wk->msg_man, msg_bag_041, BMPLIST_CANCEL );
	BMP_MENULIST_AddArchiveString( wk->ld, wk->msg_man, msg_bag_033, BMPLIST_RABEL );
	pocket->max = i+3;
}

static void ItemListStrAlloc( BAG_WORK * wk )
{
	u32	i;

	for( i=0; i<BAG_LARGE_POKE_MAX; i++ ){
		wk->itemname[i] = STRBUF_Create( BUFLEN_ITEM_NAME, HEAPID_BAG );
	}
}

static void ItemListStrFree( BAG_WORK * wk )
{
	u32	i;

	for( i=0; i<BAG_LARGE_POKE_MAX; i++ ){
		STRBUF_Delete( wk->itemname[i] );
	}
}


//--------------------------------------------------------------------------------------------
/**
 * ACeXgZbg
 *
 * @param	wk		obOʂ̃[N
 * @param	scr		XN[ʒu
 * @param	pos		J[\ʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void ItemListSet( BAG_WORK * wk, u16 scr, u16 pos )
{
	BMPLIST_HEADER	list_h;

	list_h = BagItemList;
	list_h.list  = wk->ld;
	list_h.win   = &wk->win[WIN_LIST];
	list_h.count = wk->dat->p_data[wk->dat->p_now].max;
	list_h.work  = (void *)wk;
	wk->lw = BmpListSet( &list_h, scr, pos, HEAPID_BAG );

	GF_BGL_BmpWinOn( &wk->win[WIN_LIST] );
}

//--------------------------------------------------------------------------------------------
/**
 * ACeXgR[obN֐iJ[\ړƁj
 *
 * @param	work	BMPXgŐݒ肵[N
 * @param	param	BMPXg̃p[^
 * @param	mode	 = 1
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void CB_ItemListMove( BMPLIST_WORK * work, u32 param, u8 mode )
{
	BAG_WORK * wk = (BAG_WORK *)BmpListParamGet( work, BMPLIST_ID_WORK );

	if( mode != 1 ){
		Snd_SePlay( BAG_SE_LIST_MOVE );
	}

	if( wk->irekae_flg == 1 ){ return; }
	
	GF_BGL_BmpWinDataFill( &wk->win[WIN_INFO], 0 );

	if( param != BMPLIST_CANCEL ){
		POCKET_DATA * pocket;

		pocket = &wk->dat->p_data[wk->dat->p_now];

		Bag_ItemInfoPut( wk, pocket->item[param].id );

		BagItemIconChange( wk, pocket->item[param].id );

	}else{
		BagItemIconChange( wk, ITEM_RETURN_ID );
	}

	if( wk->info_put == 0 ){
		GF_BGL_BmpWinOn( &wk->win[WIN_INFO] );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ACeXgR[obN֐i\Ɓj
 *
 * @param	work	BMPXgŐݒ肵[N
 * @param	index	BMPXggpĂEBhECfbNX
 * @param	param	BMPXg̃p[^
 * @param	y		YW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void CB_ItemListWrite( BMPLIST_WORK * work, u32 param, u8 y )
{
	BAG_WORK * wk = (BAG_WORK *)BmpListParamGet( work, BMPLIST_ID_WORK );

	if( wk->irekae_flg == 1 && wk->irekae_param == param ){
		BmpListTmpColorChange( work, FBMP_COL_BLUE, FBMP_COL_NULL, FBMP_COL_BLU_SDW );
	}else{
		BmpListTmpColorChange( work, FBMP_COL_BLACK, FBMP_COL_NULL, FBMP_COL_BLK_SDW );
	}

	if( param != BMPLIST_RABEL && param != BMPLIST_CANCEL ){
		POCKET_DATA * pocket = &wk->dat->p_data[wk->dat->p_now];

		if( wk->irekae_flg == 1 && wk->irekae_param == param ){
			Bag_ItemListNumPut( wk, pocket->item[param].no, y, BAGCOL_N_BLUE );
		}else{
			Bag_ItemListNumPut( wk, pocket->item[param].no, y, BAGCOL_N_BLACK );
		}
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ACeXgj
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void ItemListExit( BAG_WORK * wk )
{
	BmpListExit(
		wk->lw, &wk->dat->p_data[wk->dat->p_now].scr, &wk->dat->p_data[wk->dat->p_now].cur );
	BMP_MENULIST_Delete( wk->ld );
	wk->lw = NULL;
}


//--------------------------------------------------------------------------------------------
/**
 * CRg[
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	V[PX
 */
//--------------------------------------------------------------------------------------------
static int MainSeqFunc( BAG_WORK * wk )
{
	PokeArrowMove( wk );

	// |PbgIi\L[j
	if( PocketControl( wk ) == TRUE ){
		return SEQ_PAGE;
	}

	// |PbgIiTuʃ{^j
	if( PocketButtonControl( wk ) == TRUE ){
		return SEQ_PAGE;
	}

	// ACeI
	{
		u8	ret = ItemListControl( wk );

		if( ret == LIST_SEL_ITEM ){			// Iꂽ
			ItemMenuMake( wk );
			return SEQ_MENU;
		}else if( ret == LIST_SEL_CHANGE ){	// ւ
			ItemChangeInit( wk );
			return SEQ_IREKAE;
		}else if( ret == LIST_SEL_CANCEL ){	// LZ
			return SEQ_OUT;
		}
	}
	return SEQ_MAIN;
}


//--------------------------------------------------------------------------------------------
/**
 * ACeXgRg[
 *
 * @param	wk		obOʂ̃[N
 *
 * @retval	"LIST_SEL_NONE = IĂȂ"
 * @retval	"LIST_SEL_ITEM = ACeIꂽ"
 * @retval	"LIST_SEL_CANCEL = LZ"
 */
//--------------------------------------------------------------------------------------------
static u8 ItemListControl( BAG_WORK * wk )
{
	POCKET_DATA * pocket;
	u32	ret;
	u16	scr, cur;

	pocket = &wk->dat->p_data[wk->dat->p_now];

	BmpListPosGet( wk->lw, &pocket->scr, &pocket->cur );

	if( sys.trg & PAD_BUTTON_SELECT ){
		if( ItemChangeChack( wk ) == TRUE ){
			Snd_SePlay( BAG_SE_ITEM_SELECT );
			return LIST_SEL_CHANGE;
		}
	}

	ret = BmpListMain( wk->lw );
	BmpListPosGet( wk->lw, &scr, &cur );

	if( pocket->cur != cur ){
		CATS_ObjectPosSet(
			wk->act_work[ACT_LIST_SEL_CURSOR], CURSOR_ACT_PX, CURSOR_ACT_PY + (cur-1) * 16 );
	}
	pocket->scr = scr;
	pocket->cur = cur;

	switch( ret ){
	case BMPLIST_NULL:
		break;
	case BMPLIST_CANCEL:
		Snd_SePlay( BAG_SE_ITEM_SELECT );
		wk->dat->ret_item = 0;				// IACe
		wk->dat->ret_mode = BAG_RET_CANCEL;	// I[h
		APP_WipeStart( APP_WIPE_OUT, HEAPID_BAG, &wk->wipe_flg );
		return LIST_SEL_CANCEL;
	default:
		Snd_SePlay( BAG_SE_ITEM_CANCEL );
		wk->dat->ret_item = (u16)pocket->item[ret].id;	// IACe
		wk->sel_max   = (u16)pocket->item[ret].no;		// 
		return LIST_SEL_ITEM;
	}

	return LIST_SEL_NONE;
}


//--------------------------------------------------------------------------------------------
/**
 * ݂̃|PbgID擾
 *
 * @param	wk		obOʂ̃[N
 * @param	pos		J[\ʒu
 *
 * @return	|PbgID
 */
//--------------------------------------------------------------------------------------------
u8 Bag_PocketGet( BAG_WORK * wk, u8 pos )
{
	return wk->dat->p_data[pos].type;
}

//--------------------------------------------------------------------------------------------
/**
 * |PbgJ[\ړ̂߂̃f[^쐬
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 *
 * @li	wk->p_icon_gx = ԍ̃|PbgACRXW
 * @li	wk->p_icon_sx = |PbgACRm̊Ԋu
 */
//--------------------------------------------------------------------------------------------
static void PocketIconXmake( BAG_WORK * wk )
{
	wk->p_icon_gx =
		P_ICON_DEF_PX + ( P_ICON_DEF_SX - ( P_ICON_SIZ_X * wk->p_max ) ) / ( wk->p_max + 1 );
	wk->p_icon_sx = P_ICON_SIZ_X + wk->p_icon_gx - P_ICON_DEF_PX;
}



//--------------------------------------------------------------------------------------------
/**
 * |PbgRg[
 *
 * @param	wk		obOʂ̃[N
 *
 * @retval	"TRUE = L[͂"
 * @retval	"FALSE = L[͂Ȃ"
 */
//--------------------------------------------------------------------------------------------
static u8 PocketControl( BAG_WORK * wk )
{
	if( sys.repeat & PAD_KEY_LEFT ){
		Snd_SePlay( BAG_SE_POCKET_MOVE );
		if( wk->dat->p_now != 0 ){
			wk->page_work.next = wk->dat->p_now - 1;
			wk->p_next = wk->dat->p_now - 1;
		}else{
			wk->page_work.next = wk->p_max - 1;
			wk->p_next = wk->p_max - 1;
		}
		BagPocketCursorMoveInit( wk );

		wk->page_work.move = 0;
		PocketChangeInitKey( wk );
		GF_BGL_LoadScreenReq( wk->bgl, GF_BGL_FRAME0_S );
		return TRUE;
	}
	if( sys.repeat & PAD_KEY_RIGHT ){
		Snd_SePlay( BAG_SE_POCKET_MOVE );
		if( wk->dat->p_now+1 < wk->p_max ){
			wk->page_work.next = wk->dat->p_now + 1;
			wk->p_next = wk->dat->p_now + 1;
		}else{
			wk->page_work.next = 0;
			wk->p_next = 0;
		}
		BagPocketCursorMoveInit( wk );

		wk->page_work.move = 1;
		PocketChangeInitKey( wk );
		GF_BGL_LoadScreenReq( wk->bgl, GF_BGL_FRAME0_S );
		return TRUE;
	}

	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * |Pbg؂ւʏ
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void PocketChangeInitKey( BAG_WORK * wk )
{
	PocketChangeInit( wk );
	wk->page_work.tp_seq  = 3;
	wk->page_work.tp_mode = 0;
}

static void PocketChangeInitTp( BAG_WORK * wk )
{
	if( wk->page_work.move != 2 ){
		PocketChangeInit( wk );
	}else{
		wk->page_work.cur_seq = 2;
	}
	wk->page_work.tp_seq  = 0;
	wk->page_work.tp_mode = 1;
}

static void PocketChangeInit( BAG_WORK * wk )
{
	PAGE_CHG_WORK * pwk = &wk->page_work;

	pwk->cur_seq = 0;
	pwk->cur_cnt = 0;
	pwk->tp_cnt  = 0;
	pwk->tp_chg  = 0;
	pwk->tp_push = 0;

	ItemListExit( wk );
	GF_BGL_BmpWinDataFill( &wk->win[WIN_LIST], 0 );
	GF_BGL_BmpWinDataFill( &wk->win[WIN_INFO], 0 );
	GF_BGL_BmpWinOn( &wk->win[WIN_LIST] );
	GF_BGL_BmpWinOn( &wk->win[WIN_INFO] );
	CLACT_SetDrawFlag( wk->act_work[ ACT_LIST_SEL_CURSOR ], ACT_OFF );
	CLACT_SetDrawFlag( wk->act_work[ ACT_ITEMICON ], ACT_OFF );

	Bag_PocketIconPut( wk, wk->dat->p_now, 0 );

	SubPokeButtonBgChg( wk, wk->dat->p_now, 0 );
}

//--------------------------------------------------------------------------------------------
/**
 * |Pbg؂ւ
 *
 * @param	wk		obOʂ̃[N
 *
 * @retval	"TRUE = ؂ւI"
 * @retval	"FALSE = ؂ւ"
 */
//--------------------------------------------------------------------------------------------
static u8 PocketChange( BAG_WORK * wk )
{
	PAGE_CHG_WORK * pwk;
	int	tp_ret;
	u8	cur_ret;
	u8	anm_ret;

	pwk = &wk->page_work;

	// ^b`plɐGĂ邩
	if( GF_TP_GetCont() == FALSE ){	// GĂȂ
		pwk->tp_push = 1;
	}

	// ^b`ʒůmF
	tp_ret = SubPokeButtonEndCheck( wk );
	if( tp_ret == RECT_HIT_NONE || tp_ret != pwk->next ){
		pwk->tp_chg = 1;
	}

	// \L[`FbN
	if( PocketChangeReset( wk ) == FALSE ){
		// ^b`pl`FbN
		if( pwk->tp_push == 1 && tp_ret != RECT_HIT_NONE ){

			wk->dat->p_now = pwk->next;

			if( pwk->next > (u8)tp_ret ){
				pwk->move    = 0;
				pwk->cur_seq = 0;
				SubPokeButtonBgChg( wk, pwk->next, 0 );
				Bag_PocketIconPut( wk, pwk->next, 0 );
			}else if( pwk->next < (u8)tp_ret ){
				pwk->move    = 1;
				pwk->cur_seq = 0;
				SubPokeButtonBgChg( wk, pwk->next, 0 );
				Bag_PocketIconPut( wk, pwk->next, 0 );
			}else{
				pwk->move= 2;
			}

			pwk->next = (u8)tp_ret;
			pwk->tp_chg  = 0;
			pwk->tp_push = 0;
			pwk->tp_seq  = 0;

			wk->p_next = (u8)tp_ret;
			BagPocketCursorMoveInit( wk );
		}
	}

	// GtFNg
	cur_ret = PocketCursorMove( wk );
	anm_ret = ButtonAnmTask( wk );

	BagPocketCursorMoveMain( wk );

	if( cur_ret == TRUE && anm_ret == TRUE && pwk->tp_chg == 1 &&
		BagPocketCursorMoveCheck( wk ) == TRUE ){

		if( pwk->tp_mode == 1 ){
			SubPokeButtonBgChg( wk, pwk->next, 1 );
			GF_BGL_LoadScreenReq( wk->bgl, GF_BGL_FRAME0_S );
		}
		CLACT_SetDrawFlag( wk->act_work[ ACT_ITEMICON ], ACT_ON );
		return TRUE;
	}

	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * |PbgĐ؂ւ`FbN
 *
 * @param	wk		obOʂ̃[N
 *
 * @retval	"TRUE = Đ؂ւ"
 * @retval	"FALSE = ȂɂȂ"
 */
//--------------------------------------------------------------------------------------------
static u8 PocketChangeReset( BAG_WORK * wk )
{
	PAGE_CHG_WORK * pwk = &wk->page_work;

	if( sys.trg & PAD_KEY_LEFT ){
		Snd_SePlay( BAG_SE_POCKET_MOVE );
		CLACT_AnmChg( wk->act_work[ACT_BAG], wk->dat->p_data[pwk->next].type );
		SubPokeButtonBgChg( wk, pwk->next, 0 );
		GF_BGL_LoadScreenReq( wk->bgl, GF_BGL_FRAME0_S );

		wk->dat->p_now = pwk->next;

		if( pwk->next != 0 ){
			pwk->next = pwk->next - 1;
			wk->p_next = wk->p_next - 1;
		}else{
			pwk->next = wk->p_max - 1;
			wk->p_next = wk->p_max - 1;
		}

		pwk->cur_seq = 0;
		pwk->move    = 0;

		pwk->tp_push = 1;
		pwk->tp_chg  = 1;
		pwk->tp_mode = 0;

		if( pwk->tp_seq != 3 ){ pwk->tp_seq = 4; }


		BagPocketCursorMoveInit( wk );

		return TRUE;
	}
	if( sys.trg & PAD_KEY_RIGHT ){
		Snd_SePlay( BAG_SE_POCKET_MOVE );
		CLACT_AnmChg( wk->act_work[ACT_BAG], wk->dat->p_data[pwk->next].type );
		SubPokeButtonBgChg( wk, pwk->next, 0 );
		GF_BGL_LoadScreenReq( wk->bgl, GF_BGL_FRAME0_S );

		wk->dat->p_now = pwk->next;

		if( pwk->next+1 < wk->p_max ){
			pwk->next = pwk->next + 1;
			wk->p_next = wk->p_next + 1;
		}else{
			pwk->next = 0;
			wk->p_next = 0;
		}

		pwk->cur_seq = 0;
		pwk->move    = 1;

		pwk->tp_push = 1;
		pwk->tp_chg  = 1;
		pwk->tp_mode = 0;

		if( pwk->tp_seq != 3 ){ pwk->tp_seq = 4; }

		BagPocketCursorMoveInit( wk );

		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * |PbgJ[\ړ
 *
 * @param	wk		obOʂ̃[N
 *
 * @retval	"TRUE = ړ"
 * @retval	"FALSE = ړ"
 */
//--------------------------------------------------------------------------------------------
static u8 PocketCursorMove( BAG_WORK * wk )
{
	PAGE_CHG_WORK * pwk = &wk->page_work;

	switch( pwk->cur_seq ){
	case 0:		// 
		pwk->cur_cnt = 0;
//		PocketMvTblMake( wk );
		pwk->cur_seq++;
		break;

	case 1:		// ړ
		if( pwk->cur_cnt < 8 ){
/*
			VecFx32 vec;
			fx32	p;
		
			vec = *(CLACT_GetMatrix( wk->act_work[ACT_POKE_CURSOR] ));
//			p   = PocketCursorObjPXGet( wk, pwk->next ) * FX32_ONE;
			p = 0;

			if( p < vec.x ){
				vec.x -= wk->p_mv_tbl[pwk->cur_cnt];
			}else{
				vec.x += wk->p_mv_tbl[pwk->cur_cnt];
			}

			CLACT_SetMatrix( wk->act_work[ACT_POKE_CURSOR], &vec );
*/
			pwk->cur_cnt++;
			Bag_PocketNamePut( wk );
		}else{
			wk->dat->p_now = pwk->next;

			CLACT_AnmChg( wk->act_work[ACT_BAG], wk->dat->p_data[wk->dat->p_now].type );
/*
			CATS_ObjectPosSet(
				wk->act_work[ACT_POKE_CURSOR],
				PocketCursorObjPXGet( wk, wk->dat->p_now ), 97 );
*/
			Bag_PocketIconPut( wk, wk->dat->p_now, 1 );

			if( wk->lw != NULL ){
				BmpListExit( wk->lw, NULL, NULL );
				BMP_MENULIST_Delete( wk->ld );
			}
			ItemListDataMake( wk );
			ItemListSet(
				wk, wk->dat->p_data[wk->dat->p_now].scr, wk->dat->p_data[wk->dat->p_now].cur );
			CATS_ObjectPosSet(
				wk->act_work[ACT_LIST_SEL_CURSOR],
				CURSOR_ACT_PX, CURSOR_ACT_PY + (wk->dat->p_data[wk->dat->p_now].cur-1) * 16 );
			CLACT_SetDrawFlag( wk->act_work[ ACT_LIST_SEL_CURSOR ], ACT_ON );

			pwk->cur_seq++;
			return TRUE;
		}
		break;

	case 2:		// I
		return TRUE;
	}

	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * {^Rg[
 *
 * @param	wk		obOʂ̃[N
 *
 * @retval	"TRUE = ꂽ"
 * @retval	"FALSE = ĂȂ"
 */
//--------------------------------------------------------------------------------------------
static u8 PocketButtonControl( BAG_WORK * wk )
{
	int	ret = SubPokeButtonCheck( wk );

	if( ret == RECT_HIT_NONE ){ return FALSE; }

	if( wk->dat->p_now == (u8)ret ){
		wk->page_work.move = 2;
	}else if( wk->dat->p_now > (u8)ret ){
		wk->page_work.move = 0;
	}else{
		wk->page_work.move = 1;
	}

	wk->page_work.next = (u8)ret;

	wk->p_next = (u8)ret;
	BagPocketCursorMoveInit( wk );

	PocketChangeInitTp( wk );

	return TRUE;
}

//--------------------------------------------------------------------------------------------
/**
 * ^b`pl̃{^
 *
 * @param	wk		obOʂ̃[N
 *
 * @retval	"RECT_HIT_NONE = ĂȂ"
 * @retval	"RECT_HIT_NONE != {^ԍ"
 */
//--------------------------------------------------------------------------------------------
static int SubPokeButtonCheck( BAG_WORK * wk )
{
	int	ret = GF_TP_RectHitTrg( PokeButtonPos[ wk->p_max ].rect_tbl );

	if( ret != RECT_HIT_NONE ){
		u16	pat = 0xfffe;

		if( GF_BGL_DotCheck( wk->bgl, GF_BGL_FRAME0_S, sys.tp_x, sys.tp_y, &pat ) == FALSE ){
			return RECT_HIT_NONE;
		}
	}
	return ret;
}

//--------------------------------------------------------------------------------------------
/**
 * ^b`pl̃{^
 *
 * @param	wk		obOʂ̃[N
 *
 * @retval	"RECT_HIT_NONE = "
 * @retval	"RECT_HIT_NONE != Ă"
 */
//--------------------------------------------------------------------------------------------
static int SubPokeButtonEndCheck( BAG_WORK * wk )
{
	int	ret = GF_TP_RectHitCont( PokeButtonPos[ wk->p_max ].rect_tbl );

	if( ret != RECT_HIT_NONE ){
		u16	pat = 0xfffe;

		if( GF_BGL_DotCheck( wk->bgl, GF_BGL_FRAME0_S, sys.tp_x, sys.tp_y, &pat ) == FALSE ){
			return RECT_HIT_NONE;
		}
	}
	return ret;
}


//--------------------------------------------------------------------------------------------
/**
 * {^Aj
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static u8 ButtonAnmTask( BAG_WORK * wk )
{
	PAGE_CHG_WORK * pwk = &wk->page_work;

	switch( pwk->tp_seq ){
	case 0:
		CLACT_SetDrawFlag( wk->act_work[ ACT_BUTTON_ANM ], ACT_OFF );
		pwk->tp_cnt  = 0;
		pwk->tp_mode = 1;
		pwk->tp_button = pwk->next;
		pwk->tp_seq++;
		break;
	case 1:
		if( pwk->tp_cnt != 3 ){ break; }

		Snd_SePlay( BAG_SE_SUB_BUTTON );
		// {^ւ܂
		SubPokeButtonBgChg( wk, pwk->tp_button, 2 );
		GF_BGL_LoadScreenReq( wk->bgl, GF_BGL_FRAME0_S );
		// GtFNgZAN^[p
		CATS_ObjectPosSet(
			wk->act_work[ ACT_BUTTON_ANM ],
			PokeButtonPos[wk->p_max].write_tbl[pwk->tp_button*2] * 8 + 20,
			PokeButtonPos[wk->p_max].write_tbl[pwk->tp_button*2+1] * 8 + 20 );
		CLACT_SetDrawFlag( wk->act_work[ ACT_BUTTON_ANM ], ACT_ON );
		CLACT_AnmFrameSet( wk->act_work[ ACT_BUTTON_ANM ], 0 );
		pwk->tp_seq++;
		break;
	case 2:
		if( pwk->tp_cnt != 7 ){ break; }

		CLACT_SetDrawFlag( wk->act_work[ ACT_BUTTON_ANM ], ACT_OFF );
		CLACT_AnmFrameSet( wk->act_work[ ACT_BUTTON_ANM ], 0 );
		pwk->tp_seq++;
		return TRUE;

	case 3:
		return TRUE;

	case 4:
		CLACT_SetDrawFlag( wk->act_work[ ACT_BUTTON_ANM ], ACT_OFF );
		CLACT_AnmFrameSet( wk->act_work[ ACT_BUTTON_ANM ], 0 );
		pwk->tp_seq = 3;
		return TRUE;
	}

	if( pwk->tp_cnt >= 4 && pwk->tp_cnt < 7 ){
		CLACT_AnmFrameChg( wk->act_work[ ACT_BUTTON_ANM ], FX32_ONE );
	}

	pwk->tp_cnt++;

	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * {^BG
 *
 * @param	wk		obOʂ̃[N
 * @param	num		{^ԍ
 * @param	anm		Ajԍ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void SubPokeButtonBgChg( BAG_WORK * wk, u8 num, u8 anm )
{
	u16 * buf;
	const u8 * pos;
	u16	start;
	u8	type;
	u8	i, j;
	
	buf   = (u16 *)GF_BGL_ScreenAdrsGet( wk->bgl, GF_BGL_FRAME0_S );
	pos   = &PokeButtonPos[wk->p_max].write_tbl[num*2];
	type  = wk->dat->p_data[num].type;
	start = (type/2)*BUTTON_CGX_YNEXT + (type&1)*BUTTON_CGX_XNEXT
				+ BUTTON_CGX_START + anm*BUTTON_CGX_SIZE;

	for( i=0; i<BUTTON_CGX_SIZE; i++ ){
		for( j=0; j<BUTTON_CGX_SIZE; j++ ){
			buf[ (i+pos[1])*32 + j+pos[0] ] = start+i*BUTTON_CGX_WIDE+j + (BUTTON_PAL_NUM<<12);
		}
	}
}

static void SubPokeButtonBgInit( BAG_WORK * wk )
{
	u8	i;

	for( i=0; i<wk->p_max; i++ ){
		SubPokeButtonBgChg( wk, i, 0 );
	}
	GF_BGL_LoadScreenReq( wk->bgl, GF_BGL_FRAME0_S );
}


//--------------------------------------------------------------------------------------------
/**
 * |Pbg؂ւ󓮍
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void PokeArrowMove( BAG_WORK * wk )
{
	if( wk->arrow_cnt == 0 ){
		VecFx32 vec;

		switch( wk->arrow_mv ){
		case 0:
		case 1:
			vec = *(CLACT_GetMatrix( wk->act_work[ACT_POKE_ARROW_LEFT] ));
			vec.x -= FX32_ONE; 
			CLACT_SetMatrix( wk->act_work[ACT_POKE_ARROW_LEFT], &vec );
			vec = *(CLACT_GetMatrix( wk->act_work[ACT_POKE_ARROW_RIGHT] ));
			vec.x += FX32_ONE; 
			CLACT_SetMatrix( wk->act_work[ACT_POKE_ARROW_RIGHT], &vec );
			break;
		case 2:
		case 3:
			vec = *(CLACT_GetMatrix( wk->act_work[ACT_POKE_ARROW_LEFT] ));
			vec.x += FX32_ONE; 
			CLACT_SetMatrix( wk->act_work[ACT_POKE_ARROW_LEFT], &vec );
			vec = *(CLACT_GetMatrix( wk->act_work[ACT_POKE_ARROW_RIGHT] ));
			vec.x -= FX32_ONE; 
			CLACT_SetMatrix( wk->act_work[ACT_POKE_ARROW_RIGHT], &vec );
			break;
		}

		wk->arrow_mv = ( wk->arrow_mv + 1 ) & 3;
	}

	wk->arrow_cnt = ( wk->arrow_cnt + 1 ) & 3;
}


//============================================================================================
//============================================================================================
//	ւ
//============================================================================================
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ւ\`FbN
 *
 * @param	wk		obOʂ̃[N
 *
 * @retval	"TRUE = \"
 * @retval	"FALSE = "s"
 */
//--------------------------------------------------------------------------------------------
static u8 ItemChangeChack( BAG_WORK * wk )
{
	POCKET_DATA * pocket = &wk->dat->p_data[wk->dat->p_now];

	if( BmpListPosParamGet( wk->lw, pocket->scr+pocket->cur ) == BMPLIST_CANCEL ){
		return FALSE;
	}


	if( pocket->type == BAG_POKE_NUTS || pocket->type == BAG_POKE_WAZA ){
		return FALSE;
	}

	return TRUE;
}

//--------------------------------------------------------------------------------------------
/**
 * ւݒ
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */	
//--------------------------------------------------------------------------------------------
static void ItemChangeInit( BAG_WORK * wk )
{
	POCKET_DATA * pocket = &wk->dat->p_data[wk->dat->p_now];

	wk->irekae_flg   = 1;
	wk->irekae_pos   = pocket->scr + pocket->cur;
	wk->irekae_param = BmpListPosParamGet( wk->lw, wk->irekae_pos );

	Bag_ItemChgInfoMsgSet( wk );

	BmpListRewrite( wk->lw );

	ItemChgCursorChg( wk );
}

//--------------------------------------------------------------------------------------------
/**
 * ւI
 *
 * @param	wk		obOʂ̃[N
 *
 * @retval	"TRUE = I"
 * @retval	"FALSE = I"
 */	
//--------------------------------------------------------------------------------------------
static u8 ItemChangeMain( BAG_WORK * wk )
{
	POCKET_DATA * pocket;
	u32	ret;
	u16	scr, cur;

	pocket = &wk->dat->p_data[wk->dat->p_now];

	BmpListPosGet( wk->lw, &pocket->scr, &pocket->cur );

	if( sys.trg & PAD_BUTTON_SELECT ){
		Snd_SePlay( BAG_SE_ITEM_SELECT );
		ItemChangeComp( wk );
		return TRUE;
	}

	ret = BmpListMain( wk->lw );
	BmpListPosGet( wk->lw, &scr, &cur );

	if( pocket->cur != cur ){
		CATS_ObjectPosSet(
			wk->act_work[ACT_LIST_SEL_CHANGE], CURSOR_ACT_PX, CURSOR_ACT_PY+(cur-1)*16-8 );
	}
	pocket->scr = scr;
	pocket->cur = cur;

	switch( ret ){
	case BMPLIST_NULL:
		break;
	case BMPLIST_CANCEL:
		Snd_SePlay( BAG_SE_ITEM_SELECT );
		if( sys.trg & PAD_BUTTON_DECIDE ){
			ItemChangeComp( wk );
		}else{
			ItemChangeEnd( wk );
		}
		return TRUE;
	default:
		Snd_SePlay( BAG_SE_ITEM_SELECT );
		ItemChangeComp( wk );
		return LIST_SEL_ITEM;
	}

	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * ւE
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */	
//--------------------------------------------------------------------------------------------
static void ItemChangeComp( BAG_WORK * wk )
{
	POCKET_DATA * pocket = &wk->dat->p_data[wk->dat->p_now];
	u16	pos = pocket->scr + pocket->cur;

	if( !( wk->irekae_pos == pos || wk->irekae_pos == (pos-1) ) ){
		ItemPutIn( pocket->item, wk->irekae_pos-1, pos-1 );
		BMP_MENULIST_Delete( wk->ld );
		ItemListDataMake( wk );
	}

	ItemChangeEnd( wk );
}

//--------------------------------------------------------------------------------------------
/**
 * ւELZ
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */	
//--------------------------------------------------------------------------------------------
static void ItemChangeEnd( BAG_WORK * wk )
{
	POCKET_DATA * pocket = &wk->dat->p_data[wk->dat->p_now];

	BmpListExit( wk->lw, &pocket->scr, &pocket->cur );
	wk->lw = NULL;

	if( wk->irekae_pos < (pocket->scr+pocket->cur) ){
		pocket->cur -= 1;
	}

	wk->irekae_flg   = 0;
	wk->irekae_pos   = 0;
	wk->irekae_param = 0;

	ItemListSet( wk, pocket->scr, pocket->cur );
	ItemChgCursorChg( wk );
}

//--------------------------------------------------------------------------------------------
/**
 * J[\؂ւ
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void ItemChgCursorChg( BAG_WORK * wk )
{
	POCKET_DATA * pocket = &wk->dat->p_data[wk->dat->p_now];

	if( wk->irekae_flg == 0 ){
		CATS_ObjectPosSet(
			wk->act_work[ACT_LIST_SEL_CURSOR],
			CURSOR_ACT_PX, CURSOR_ACT_PY + (pocket->cur-1) * 16 );

		CLACT_SetDrawFlag( wk->act_work[ ACT_LIST_SEL_CURSOR ], ACT_ON );
		CLACT_SetDrawFlag( wk->act_work[ ACT_LIST_SEL_CHANGE ], ACT_OFF );
		CLACT_SetDrawFlag( wk->act_work[ ACT_POKE_ARROW_LEFT ], ACT_ON );
		CLACT_SetDrawFlag( wk->act_work[ ACT_POKE_ARROW_RIGHT ], ACT_ON );
	}else{
		CATS_ObjectPosSet(
			wk->act_work[ACT_LIST_SEL_CHANGE],
			CURSOR_ACT_PX, CURSOR_ACT_PY + (pocket->cur-1) * 16 - 8 );

		CLACT_SetDrawFlag( wk->act_work[ ACT_LIST_SEL_CURSOR ], ACT_OFF );
		CLACT_SetDrawFlag( wk->act_work[ ACT_LIST_SEL_CHANGE ], ACT_ON );
		CLACT_SetDrawFlag( wk->act_work[ ACT_POKE_ARROW_LEFT ], ACT_OFF );
		CLACT_SetDrawFlag( wk->act_work[ ACT_POKE_ARROW_RIGHT ], ACT_OFF );
	}
}


//============================================================================================
//============================================================================================
//	j[
//============================================================================================
//============================================================================================

static void ItemMenuMake( BAG_WORK * wk )
{
	void * itemdata;
	u32	max;
	u8	pocket;
	u8	tbl[BAG_MENU_MAX];

	itemdata = GetItemArcData( wk->dat->ret_item, ITEM_GET_DATA, HEAPID_BAG );
	max      = 0;
	pocket   = Bag_PocketGet( wk, wk->dat->p_now );

	// tB[h
	if( wk->dat->mode == BAG_MODE_FIELD ){
		// ^O݂
		if( pocket == BAG_POKE_NUTS ){
			tbl[max] = BAG_MENU_TAGUWOMIRU;
			max++;
		}
		// 
		// 
		// ݂
		if( ItemBufParamGet( itemdata, ITEM_PRM_FIELD ) != 0 ){
			if( wk->dat->ret_item == ITEM_ZITENSYA && wk->dat->cycle_flg == 1 ){
				tbl[max] = BAG_MENU_ORIRU;
			}else{
				tbl[max] = BAG_MENU_TSUKAU;
			}
			max++;
		}
		// 
		// Ă
		if( ItemBufParamGet( itemdata, ITEM_PRM_EVENT ) == 0 ){
			tbl[max] = BAG_MENU_MOTASERU;
			max++;
			tbl[max] = BAG_MENU_SUTERU;
			max++;
		}
		// Ƃ낭
		// 
		if( ItemBufParamGet( itemdata, ITEM_PRM_CNV ) != 0 ){
			tbl[max] = BAG_MENU_TOUROKU;
			max++;
		}
	// 퓬
	}else if( wk->dat->mode == BAG_MODE_BATTLE ){
		if( ItemBufParamGet( itemdata, ITEM_PRM_BATTLE ) != 0 ){
			tbl[max] = BAG_MENU_TSUKAU;
			max++;
		}
	}
	// ߂
	tbl[max] = BAG_MENU_YAMERU;
	max++;

	Bag_ItemMenuSet( wk, tbl, max );

	sys_FreeMemoryEz( itemdata );
}


//--------------------------------------------------------------------------------------------
/**
 * j[Rg[
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	ڍs郁CV[PX
 */
//--------------------------------------------------------------------------------------------
static int MenuControl( BAG_WORK * wk )
{
	u32	ret = BmpMenuMain( wk->mw );

	switch( ret ){
	case BMPMENU_NULL:
		break;

	case BMPMENU_CANCEL:
		Bag_ItemMenuExit( wk );
		return SEQ_MAIN;

	default:
		{
			pBagFunc	func = (pBagFunc)ret;
			return func( wk );
		}
	}

	return SEQ_MENU;
}





const u32 Bag_MenuParamGet( u32 menu_num )
{
	return MenuParamTbl[menu_num];
}

//============================================================================================
//	j[F
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * j[F
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	ڍs郁CV[PX
 */
//--------------------------------------------------------------------------------------------
static int Bag_MenuUse( BAG_WORK * wk )
{
	Bag_ItemMenuExit( wk );

	if( wk->dat->ret_item == ITEM_TANKENSETTO ){
		if( wk->dat->under_flg != 0 ){
			MSGDATA_MANAGER * man;
			STRBUF * str;
			man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_common_scr_dat, HEAPID_BAG );
			str = MSGMAN_AllocString( man, msg_item_ng_01 );
			WORDSET_RegisterPlayerName( wk->wset, 0, wk->dat->myst );
			WORDSET_ExpandStr( wk->wset, wk->expb, str );
			STRBUF_Delete( str );
			MSGMAN_Delete( man );
			GF_BGL_BmpWinDataFill( &wk->win[WIN_TALK], 15 );
			BmpTalkWinWrite( &wk->win[WIN_TALK], WINDOW_TRANS_ON, TALK_WIN_CGX_NUM, TALKWIN_PAL );
			wk->midx = Bag_TalkMsgPrint( wk );
			return SEQ_ITEM_ERR_WAIT;
		}
	}
	APP_WipeStart( APP_WIPE_OUT, HEAPID_BAG, &wk->wipe_flg );
	wk->dat->ret_mode = BAG_RET_USE;	// I[h
	return SEQ_OUT;
}



static int ItemErrWaitSeq( BAG_WORK * wk )
{
	if( GF_MSG_PrintEndCheck( wk->midx ) == 0 ){
		if( sys.trg & (PAD_BUTTON_A|PAD_BUTTON_B) ){
			BmpTalkWinClear( &wk->win[WIN_TALK], WINDOW_TRANS_ON );
			GF_BGL_BmpWinOn( &wk->win[WIN_INFO] );
			return SEQ_MAIN;
		}
	}
	return SEQ_ITEM_ERR_WAIT;
}


//============================================================================================
//	j[F^O݂
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * j[F^O݂
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	ڍs郁CV[PX
 */
//--------------------------------------------------------------------------------------------
static int Bag_MenuTag( BAG_WORK * wk )
{
	Bag_ItemMenuExit( wk );

	APP_WipeStart( APP_WIPE_OUT, HEAPID_BAG, &wk->wipe_flg );
	wk->dat->ret_mode = BAG_RET_TAG;	// I[h
	return SEQ_OUT;
}


//============================================================================================
//	j[FĂ
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ̂Ă鏉
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	ڍs郁CV[PX
 */
//--------------------------------------------------------------------------------------------
static int Bag_MenuSub( BAG_WORK * wk )
{
	Bag_ItemMenuExitSub( wk );

	wk->sel_num = 1;
	Bag_DelNumSelWinSet( wk );
	return SEQ_ITEM_SUB_MAIN;
}

//--------------------------------------------------------------------------------------------
/**
 * ̂ĂI
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	ڍs郁CV[PX
 */
//--------------------------------------------------------------------------------------------
static int Bag_MenuSubMain( BAG_WORK * wk )
{
	if( NumSelectCheck( &wk->sel_num, wk->sel_max ) == TRUE ){
		Bag_SubNumPut( wk );
		return SEQ_ITEM_SUB_MAIN;
	}

	if( sys.trg & PAD_BUTTON_DECIDE ){
		Bag_SubTalkWinSet( wk );
		return SEQ_ITEM_SUB_YN_INIT;
	}

	if( sys.trg & PAD_BUTTON_CANCEL ){
		Bag_DelNumSelWinExit( wk );
		return SEQ_MAIN;
	}

	return SEQ_ITEM_SUB_MAIN;
}

//--------------------------------------------------------------------------------------------
/**
 * uĂv͂E
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	ڍs郁CV[PX
 */
//--------------------------------------------------------------------------------------------
static int Bag_MenuSubYesNoInitSeq( BAG_WORK * wk )
{
	if( GF_MSG_PrintEndCheck( wk->midx ) == 0 ){
		Bag_YesNoSelInit( wk );
		return SEQ_ITEM_SUB_YN_SEL;
	}
	return SEQ_ITEM_SUB_YN_INIT;
}

//--------------------------------------------------------------------------------------------
/**
 * uĂv͂E
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	ڍs郁CV[PX
 */
//--------------------------------------------------------------------------------------------
static int Bag_MenuSubYesNoSelectSeq( BAG_WORK * wk )
{
	switch( BmpYesNoSelectMain( wk->mw, HEAPID_BAG ) ){
	case 0:
		{
			STRBUF * str = MSGMAN_AllocString( wk->msg_man, msg_bag_055 );
			WORDSET_RegisterItemName( wk->wset, 0, wk->dat->ret_item );
			WORDSET_RegisterNumber(
				wk->wset, 1, wk->sel_num, 3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
			WORDSET_ExpandStr( wk->wset, wk->expb, str );
			STRBUF_Delete( str );
		}
		GF_BGL_BmpWinDataFill( &wk->win[WIN_TALK], 15 );
		wk->midx = Bag_TalkMsgPrint( wk );
		return SEQ_ITEM_SUB_CMP;

	case BMPMENU_CANCEL:
		BmpTalkWinClear( &wk->win[WIN_TALK], WINDOW_TRANS_ON );
		GF_BGL_BmpWinOn( &wk->win[WIN_INFO] );
		return SEQ_MAIN;
	}
	return SEQ_ITEM_SUB_YN_SEL;
}

//--------------------------------------------------------------------------------------------
/**
 * uĂv
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	ڍs郁CV[PX
 */
//--------------------------------------------------------------------------------------------
static int Bag_MenuSubCmpSeq( BAG_WORK * wk )
{
	if( GF_MSG_PrintEndCheck( wk->midx ) != 0 ){
		return SEQ_ITEM_SUB_CMP;
	}

	MyItem_SubItemDirect(
		wk->dat->p_data[wk->dat->p_now].item,
		wk->dat->p_data[ wk->dat->p_now ].max,
		wk->dat->ret_item, wk->sel_num, HEAPID_BAG );
	MyItem_SortSpace(
		wk->dat->p_data[wk->dat->p_now].item, wk->dat->p_data[ wk->dat->p_now ].max );

	wk->info_put = 1;

	BmpListExit( wk->lw, NULL, NULL );
	BMP_MENULIST_Delete( wk->ld );
	ItemListDataMake( wk );
	ItemListSet(
		wk, wk->dat->p_data[wk->dat->p_now].scr, wk->dat->p_data[wk->dat->p_now].cur );
	GF_BGL_BmpWinOn( &wk->win[WIN_TALK] );

	return SEQ_ITEM_SUB_RET;
}

//--------------------------------------------------------------------------------------------
/**
 * uĂvbZ[WI҂{^҂ -> C
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	ڍs郁CV[PX
 */
//--------------------------------------------------------------------------------------------
static int Bag_MenuSubRetSeq( BAG_WORK * wk )
{
	if( GF_MSG_PrintEndCheck( wk->midx ) == 0 ){
		if( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ){
			wk->info_put = 0;
			BmpTalkWinClear( &wk->win[WIN_TALK], WINDOW_TRANS_ON );
			GF_BGL_BmpWinOn( &wk->win[WIN_INFO] );
			return SEQ_MAIN;
		}
	}
	return SEQ_ITEM_SUB_RET;
}


//============================================================================================
//	j[F
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * j[F
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	ڍs郁CV[PX
 */
//--------------------------------------------------------------------------------------------
static int Bag_MenuSet( BAG_WORK * wk )
{
	Bag_ItemMenuExit( wk );

	APP_WipeStart( APP_WIPE_OUT, HEAPID_BAG, &wk->wipe_flg );
	wk->dat->ret_mode = BAG_RET_ITEMSET;	// I[h
	return SEQ_OUT;
}



//============================================================================================
//	|PXguv
//============================================================================================

static int PokeItemSet_MainSeq( BAG_WORK * wk )
{
	PokeArrowMove( wk );

	// |PbgIi\L[j
	if( PocketControl( wk ) == TRUE ){
		return SEQ_PAGE;
	}

	// |PbgIiTuʃ{^j
	if( PocketButtonControl( wk ) == TRUE ){
		return SEQ_PAGE;
	}

	// ACeI
	{
		u8	ret = ItemListControl( wk );

		if( ret == LIST_SEL_ITEM ){			// Iꂽ
			if( ItemParamGet( wk->dat->ret_item, ITEM_PRM_EVENT, HEAPID_BAG ) != 0 ){
				STRBUF * str;

				GF_BGL_BmpWinDataFill( &wk->win[WIN_TALK], 15 );
				BmpTalkWinWrite(
					&wk->win[WIN_TALK], WINDOW_TRANS_ON, TALK_WIN_CGX_NUM, TALKWIN_PAL );
				WORDSET_RegisterItemName( wk->wset, 0, wk->dat->ret_item );
				str = MSGMAN_AllocString( wk->msg_man, msg_bag_046 );
				WORDSET_ExpandStr( wk->wset, wk->expb, str );
				STRBUF_Delete( str );
				wk->midx = Bag_TalkMsgPrint( wk );
				return SEQ_ITEMSET_ERR;
			}
			wk->dat->ret_mode = BAG_RET_POKEITEMSET;
			APP_WipeStart( APP_WIPE_OUT, HEAPID_BAG, &wk->wipe_flg );
			return SEQ_OUT;
		}else if( ret == LIST_SEL_CANCEL ){	// LZ
			wk->dat->ret_mode = BAG_RET_POKEITEMSET;
			return SEQ_OUT;
		}
	}
	return SEQ_ITEMSET_MAIN;
}

static int PokeItemSet_ErrorSeq( BAG_WORK * wk )
{
	if( GF_MSG_PrintEndCheck( wk->midx ) == 0 ){
		if( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ){
			BmpTalkWinClear( &wk->win[WIN_TALK], WINDOW_TRANS_ON );
			GF_BGL_BmpWinOn( &wk->win[WIN_INFO] );
			return SEQ_ITEMSET_MAIN;
		}
	}
	return SEQ_ITEMSET_ERR;
}


//============================================================================================
//	
//============================================================================================
// uv[hACeI
static int SaleMainSeq( BAG_WORK * wk )
{
	PokeArrowMove( wk );

	// |PbgIi\L[j
	if( PocketControl( wk ) == TRUE ){
		return SEQ_PAGE;
	}

	// |PbgIiTuʃ{^j
	if( PocketButtonControl( wk ) == TRUE ){
		return SEQ_PAGE;
	}

	// ACeI
	{
		u8	ret = ItemListControl( wk );

		if( ret == LIST_SEL_ITEM ){			// Iꂽ
			STRBUF * str;

			Bag_GoldWinPut( wk, 0 );

			GF_BGL_BmpWinDataFill( &wk->win[WIN_TALK], 15 );
			BmpTalkWinWrite( &wk->win[WIN_TALK], WINDOW_TRANS_ON, TALK_WIN_CGX_NUM, TALKWIN_PAL );
			WORDSET_RegisterItemName( wk->wset, 0, wk->dat->ret_item );
			if( ItemParamGet( wk->dat->ret_item, ITEM_PRM_EVENT, HEAPID_BAG ) != 0 ){
				str = MSGMAN_AllocString( wk->msg_man, mes_shop_093 );
				WORDSET_ExpandStr( wk->wset, wk->expb, str );
				STRBUF_Delete( str );
				wk->midx = Bag_TalkMsgPrint( wk );
				return SEQ_SALE_RET;
			}
			str = MSGMAN_AllocString( wk->msg_man, mes_shop_094 );
			WORDSET_ExpandStr( wk->wset, wk->expb, str );
			STRBUF_Delete( str );
			wk->midx = Bag_TalkMsgPrint( wk );
			return SEQ_SALE_NUM_INIT;
		}else if( ret == LIST_SEL_CANCEL ){	// LZ
			return SEQ_OUT;
		}
	}
	return SEQ_SALE_MAIN;
}

// uv[hI
static int SaleNumInitSeq( BAG_WORK * wk )
{
	if( GF_MSG_PrintEndCheck( wk->midx ) == 0 ){
		wk->sel_num   = 1;
		wk->sel_price = ItemParamGet( wk->dat->ret_item, ITEM_PRM_PRICE, HEAPID_BAG );
		if( wk->sel_max > 99 ){ wk->sel_max = 99; }
		Bag_SaleNumWinPut( wk, 0 );
		return SEQ_SALE_NUM_SEL;
	}
	return SEQ_SALE_NUM_INIT;
}

// uv[hI
static int SaleNumSelSeq( BAG_WORK * wk )
{
	if( NumSelectCheck( &wk->sel_num, wk->sel_max ) == TRUE ){
		Bag_SaleNumWinPut( wk, 1 );
		return SEQ_SALE_NUM_SEL;
	}

	if( sys.trg & PAD_BUTTON_DECIDE ){
		STRBUF * str;
		BmpMenuWinClear( &wk->win[WIN_SALE_NUM], WINDOW_TRANS_OFF );
		GF_BGL_BmpWinDataFill( &wk->win[WIN_TALK], 15 );
		str = MSGMAN_AllocString( wk->msg_man, mes_shop_095 );
		WORDSET_RegisterNumber(
			wk->wset, 0, wk->sel_num*wk->sel_price, 6,
			NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
		WORDSET_ExpandStr( wk->wset, wk->expb, str );
		STRBUF_Delete( str );
		wk->midx = Bag_TalkMsgPrint( wk );
		return SEQ_SALE_YN_INIT;
	}
	if( sys.trg & PAD_BUTTON_CANCEL ){
		wk->sel_price = 0;
		BmpMenuWinClear( &wk->win[WIN_GOLD], WINDOW_TRANS_OFF );
		BmpMenuWinClear( &wk->win[WIN_SALE_NUM], WINDOW_TRANS_OFF );
		BmpTalkWinClear( &wk->win[WIN_TALK], WINDOW_TRANS_ON );
		GF_BGL_BmpWinOn( &wk->win[WIN_INFO] );
		return SEQ_SALE_MAIN;
	}
	return SEQ_SALE_NUM_SEL;
}

// uv͂E
static int SaleYesNoInitSeq( BAG_WORK * wk )
{
	if( GF_MSG_PrintEndCheck( wk->midx ) == 0 ){
		Bag_YesNoSelInit( wk );
		return SEQ_SALE_YN_SEL;
	}
	return SEQ_SALE_YN_INIT;
}

// uv͂E
static int SaleYesNoSelectSeq( BAG_WORK * wk )
{
	switch( BmpYesNoSelectMain( wk->mw, HEAPID_BAG ) ){
	case 0:
		{
			STRBUF * str = MSGMAN_AllocString( wk->msg_man, mes_shop_096 );
			WORDSET_RegisterItemName( wk->wset, 0, wk->dat->ret_item );
			WORDSET_RegisterNumber(
				wk->wset, 1, wk->sel_num*wk->sel_price, 6,
				NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
			WORDSET_ExpandStr( wk->wset, wk->expb, str );
			STRBUF_Delete( str );
		}
		GF_BGL_BmpWinDataFill( &wk->win[WIN_TALK], 15 );
		wk->midx = Bag_TalkMsgPrint( wk );
		return SEQ_SALE_CMP;

	case BMPMENU_CANCEL:
		wk->sel_price = 0;
		BmpMenuWinClear( &wk->win[WIN_GOLD], WINDOW_TRANS_OFF );
		BmpTalkWinClear( &wk->win[WIN_TALK], WINDOW_TRANS_ON );
		GF_BGL_BmpWinOn( &wk->win[WIN_INFO] );
		return SEQ_SALE_MAIN;
	}
	return SEQ_SALE_YN_SEL;
}

// uv
static int SaleCmpSeq( BAG_WORK * wk )
{
	if( GF_MSG_PrintEndCheck( wk->midx ) != 0 ){
		return SEQ_SALE_CMP;
	}
	wk->gold = Mystatus_AddGold( wk->dat->myst, wk->sel_num*wk->sel_price );
	Bag_GoldWinPut( wk, 1 );
	MyItem_SubItemDirect(
		wk->dat->p_data[wk->dat->p_now].item,
		wk->dat->p_data[ wk->dat->p_now ].max,
		wk->dat->ret_item, wk->sel_num, HEAPID_BAG );

	MyItem_SortSpace(
		wk->dat->p_data[wk->dat->p_now].item, wk->dat->p_data[ wk->dat->p_now ].max );

	wk->info_put = 1;

	BmpListExit( wk->lw, NULL, NULL );
	BMP_MENULIST_Delete( wk->ld );
	ItemListDataMake( wk );
	ItemListSet(
		wk, wk->dat->p_data[wk->dat->p_now].scr, wk->dat->p_data[wk->dat->p_now].cur );
	GF_BGL_BmpWinOn( &wk->win[WIN_TALK] );

	return SEQ_SALE_RET;
}

// uvbZ[WI҂{^҂ -> C
static int SaleRetSeq( BAG_WORK * wk )
{
	if( GF_MSG_PrintEndCheck( wk->midx ) == 0 ){
		if( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ){
			wk->info_put  = 0;
			wk->sel_price = 0;
			BmpMenuWinClear( &wk->win[WIN_GOLD], WINDOW_TRANS_OFF );
			BmpTalkWinClear( &wk->win[WIN_TALK], WINDOW_TRANS_ON );
			GF_BGL_BmpWinOn( &wk->win[WIN_INFO] );
			return SEQ_SALE_MAIN;
		}
	}
	return SEQ_SALE_RET;
}


//============================================================================================
//	؂̎֘A
//============================================================================================

static int KinomiSel_MainSeq( BAG_WORK * wk )
{
	PokeArrowMove( wk );

	// |PbgIi\L[j
	if( PocketControl( wk ) == TRUE ){
		return SEQ_PAGE;
	}

	// |PbgIiTuʃ{^j
	if( PocketButtonControl( wk ) == TRUE ){
		return SEQ_PAGE;
	}

	// ACeI
	{
		u8	ret = ItemListControl( wk );

		if( ret == LIST_SEL_ITEM ){			// Iꂽ
			wk->dat->ret_mode = BAG_RET_USE;
			APP_WipeStart( APP_WIPE_OUT, HEAPID_BAG, &wk->wipe_flg );
			return SEQ_OUT;
		}else if( ret == LIST_SEL_CANCEL ){	// LZ
			wk->dat->ret_mode = BAG_RET_CANCEL;
			return SEQ_OUT;
		}
	}
	return SEQ_KINOMISEL_MAIN;
}
