//============================================================================================
/**
 * @file	bag_obj.c	
 * @bfief	obOOBJ
 * @author	Hiroyuki Nakamura
 * @date	05.10.31
 */
//============================================================================================
#include "common.h"
#include "system/gamedata.h"
#include "system/procsys.h"
#include "system/fontproc.h"
#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "system/window.h"
#include "system/pm_str.h"
#include "system/lib_pack.h"
#include "system/snd_tool.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/clact_util.h"
#include "system/clact_tool.h"
#include "system/render_oam.h"
#include "system/brightness.h"
#include "system/buflen.h"
#include "system/msgdata.h"
#include "system/wordset.h"
#include "system/numfont.h"
#include "gflib/touchpanel.h"
#include "itemtool/item.h"
#include "itemtool/itemicon.h"

#define	BAG_OBJ_H_GLOBAL
#include "application/bag.h"
#include "bag_sys.h"
#include "bag_obj.h"
#include "bag_gra.naix"



enum {
	PCMV_SEQ_WAIT = 0,
	PCMV_SEQ_MOVE,
};

#define	BMP_P_ICON_PX	( 0 )
#define	BMP_P_ICON_PY	( 11 )
#define	BMP_P_ICON_SX	( 12 )
#define	BMP_P_ICON_SY	( 2 )



static void PocketMvTblMake( BAG_WORK * wk );
static u8 PocketCursorObjPXGet( BAG_WORK * wk, u8 poke );
static void PocketCursorMove( BAG_WORK * wk );





static const TCATS_OBJECT_ADD_PARAM	ActAddParam[] =
{
	{	// obO
		0,
		48, 50, 0,
		0, 1, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// |PbgJ[\
		1,
		13, 97, 0,
		0, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// |Pbg
		4,
		2, 96, 0,
		1, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// |PbgE
		4,
		98, 96, 0,
		0, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ACeIJ[\
		2,
		CURSOR_ACT_PX, CURSOR_ACT_PY, 0,
		0, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ACeւJ[\
		3,
		177, 14, 0,
		0, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// {^GtFNg
		5,
		0, 0, 0,
		0, 0, 0, NNS_G2D_VRAM_TYPE_2DSUB,
		0, 0, 0, 0
	},
	{	// ACeACR
		6,
		22,172, 0,
		0, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
};





//--------------------------------------------------------------------------------------------
/**
 * ZAN^[
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BagCellActorInit( BAG_WORK * wk )
{
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );		// MAIN DISP OBJ ON
	GF_Disp_GXS_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );		// SUB DISP OBJ ON

	initVramTransferManagerHeap( 32, HEAPID_BAG );

	wk->csp = CATS_AllocMemory( HEAPID_BAG );
	wk->crp = CATS_ResourceCreate( wk->csp );

	{
		TCATS_OAM_INIT	coi = {
			0, 128,
			0, 32,
			0, 128,
			0, 32,
		};
		TCATS_CHAR_MANAGER_MAKE ccmm = {
			BAG_ACT_MAX,
			1024,
			1024,
			GX_OBJVRAMMODE_CHAR_1D_32K,
			GX_OBJVRAMMODE_CHAR_1D_32K
		};
		CATS_SystemInit( wk->csp, &coi, &ccmm, 32 );
		CATS_ClactSetInit( wk->csp, wk->crp, BAG_ACT_MAX );
	}

	{
		TCATS_RESOURCE_FILE_LIST list = {
			"data/bag_chr.resdat",	// LN^
			"data/bag_pal.resdat",	// pbg
			"data/bag_cell.resdat",	// Z
			"data/bag_canm.resdat",	// ZAj
			NULL,					// }`Z
			NULL,					// }`ZAj
			"data/bag_h.cldat"		// wb_[
		};
		CATS_ResourceLoadBinary( wk->csp, wk->crp, &list );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * obOʂ̃ZAN^[Zbg
 *
 * @param	act_work	ZAN^[[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BagActSet( BAG_WORK * wk )
{
	if( wk->sex == 1 ){
		CATS_ChangeResourceCharArc(
			wk->csp, wk->crp, ARC_BAG_GRA, NARC_bag_gra_bag_02_NCGR, 0, 0 );
		CATS_ChangeResourcePlttArc(
			wk->csp, wk->crp, ARC_BAG_GRA, NARC_bag_gra_bag_02_NCLR, 0, 0 );
	}

	wk->act_work[ ACT_BAG ] =
		CATS_ObjectAdd( wk->csp, wk->crp, &ActAddParam[ACT_BAG] );
	wk->act_work[ ACT_POKE_CURSOR ] =
		CATS_ObjectAdd( wk->csp, wk->crp, &ActAddParam[ACT_POKE_CURSOR] );
	wk->act_work[ ACT_POKE_ARROW_LEFT ] =
		CATS_ObjectAdd( wk->csp, wk->crp, &ActAddParam[ACT_POKE_ARROW_LEFT] );
	wk->act_work[ ACT_POKE_ARROW_RIGHT ] =
		CATS_ObjectAdd( wk->csp, wk->crp, &ActAddParam[ACT_POKE_ARROW_RIGHT] );
	wk->act_work[ ACT_LIST_SEL_CURSOR ] =
		CATS_ObjectAdd( wk->csp, wk->crp, &ActAddParam[ACT_LIST_SEL_CURSOR] );
	wk->act_work[ ACT_LIST_SEL_CHANGE ] =
		CATS_ObjectAdd( wk->csp, wk->crp, &ActAddParam[ACT_LIST_SEL_CHANGE] );
	wk->act_work[ ACT_BUTTON_ANM ] =
		CATS_ObjectAdd( wk->csp, wk->crp, &ActAddParam[ACT_BUTTON_ANM] );
	wk->act_work[ ACT_ITEMICON ] =
		CATS_ObjectAdd( wk->csp, wk->crp, &ActAddParam[ACT_ITEMICON] );

	CLACT_SetDrawFlag( wk->act_work[ ACT_LIST_SEL_CHANGE ], ACT_OFF );
	CLACT_SetDrawFlag( wk->act_work[ ACT_BUTTON_ANM ], ACT_OFF );

	CATS_ObjectPosSet(
		wk->act_work[ACT_POKE_CURSOR], PocketCursorObjPXGet( wk, 0 ), 97 );
}

//--------------------------------------------------------------------------------------------
/**
 * ACeACRύX
 *
 * @param	wk		obOʂ̃[N
 * @param	item	ACeԍ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BagItemIconChange( BAG_WORK * wk, u16 item )
{
	CATS_ChangeResourceCharArc(
		wk->csp, wk->crp,
		ARC_ITEMICON, GetItemIndex( item, ITEM_GET_ICON_CGX ), 0, 6 );
	CATS_ChangeResourcePlttArc(
		wk->csp, wk->crp,
		ARC_ITEMICON, GetItemIndex( item, ITEM_GET_ICON_PAL ), 0, 3 );
}







//============================================================================================
//	|PbgJ[\
//============================================================================================
u8 BagPocketCursorMoveCheck( BAG_WORK * wk )
{
	if( wk->pcmv.req == PCMV_SEQ_WAIT ){
		return TRUE;
	}
	return FALSE;
}

void BagPocketCursorMoveInit( BAG_WORK * wk )
{
	wk->pcmv.cnt  = 0;
//	wk->pcmv.next = next;
	wk->pcmv.req  = PCMV_SEQ_MOVE;
	PocketMvTblMake( wk );
}

void BagPocketCursorMoveMain( BAG_WORK * wk )
{
	switch( wk->pcmv.req ){
	case PCMV_SEQ_WAIT:
		break;
	case PCMV_SEQ_MOVE:
		PocketCursorMove( wk );
		break;
	}
}

static void PocketCursorMove( BAG_WORK * wk )
{
	VecFx32 vec;
		
	vec = *(CLACT_GetMatrix( wk->act_work[ACT_POKE_CURSOR] ));

	if( wk->pcmv.mv == 0 ){
		vec.x -= wk->pcmv.tbl[wk->pcmv.cnt];
	}else{
		vec.x += wk->pcmv.tbl[wk->pcmv.cnt];
	}
	CLACT_SetMatrix( wk->act_work[ACT_POKE_CURSOR], &vec );

	wk->pcmv.cnt++;
	if( wk->pcmv.cnt == 8 ){
		vec.x = PocketCursorObjPXGet( wk, wk->p_next ) * FX32_ONE;
		CLACT_SetMatrix( wk->act_work[ACT_POKE_CURSOR], &vec );
		wk->pcmv.req = PCMV_SEQ_WAIT;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * |PbgJ[\OBJXW
 *
 * @param	wk		obOʂ̃[N
 * @param	poke	|Pbgԍ
 *
 * @return	J[\OBJXW
 *
 * @li	|PbgԍJ[\ʒu擾
 */
//--------------------------------------------------------------------------------------------
static u8 PocketCursorObjPXGet( BAG_WORK * wk, u8 poke )
{
	return BMP_P_ICON_PX * 8 + wk->p_icon_gx + wk->p_icon_sx * poke + P_ICON_DEF_PX;
}

//--------------------------------------------------------------------------------------------
/**
 * |PbgJ[\ړe[u쐬
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 *
 *	8syncňړ
 *		0sync =  0%, 1sync = 40%, 2sync = 25%, 3sync = 15%,
 *		4sync = 10%, 5sync =  7%, 6sync =  3%, 7sync =  0%
 */
//--------------------------------------------------------------------------------------------
static void PocketMvTblMake( BAG_WORK * wk )
{
	VecFx32	vec;
	fx32	p;

	vec = *(CLACT_GetMatrix( wk->act_work[ACT_POKE_CURSOR] ));
	p   = PocketCursorObjPXGet( wk, wk->p_next ) * FX32_ONE;

	if( p < vec.x ){
		p = ( vec.x - p ) / 100;
		wk->pcmv.mv = 0;
	}else{
		p = ( p - vec.x ) / 100;
		wk->pcmv.mv = 1;
	}

	wk->pcmv.tbl[0] = 0;
	wk->pcmv.tbl[1] = p * 40;
	wk->pcmv.tbl[2] = p * 25;
	wk->pcmv.tbl[3] = p * 15;
	wk->pcmv.tbl[4] = p * 10;
	wk->pcmv.tbl[5] = p *  7;
	wk->pcmv.tbl[6] = p *  3;
	wk->pcmv.tbl[7] = 0;
}
