//============================================================================================
/**
 * @file	box.c
 * @brief	{bNXʁ@C
 * @author	taya
 * @date	2005.09.05
 */
//============================================================================================
#include "common.h"
#include "gflib\button_man.h"
#include "system\procsys.h"
#include "system\wordset.h"
#include "system\savedata.h"
#include "application\namein.h"
#include "application\p_status.h"
#include "application\bag.h"
#include "itemtool\myitem.h"
#include "application\box.h"
#include "poketool\poke_tool.h"
#include "poketool\boxdata.h"
#include "poketool\pokeparty.h"

#include "system\msgdata.h"
#include "msgdata\msg.naix"
#include "msgdata\msg_boxmenu.h"
#include "msgdata\msg_chr.h"

#include  "box_common.h"
#include  "boxmenu.h"
#include  "box_reel.h"

//==============================================================
// 萔
//==============================================================
enum {
	HEAPSIZE_SYS = 0x4000,
	HEAPSIZE_VIEW = 0x30000,

	SELECT_TRAY_CANCEL = -1,
};

enum {
	BUTTONID_LEFT,
	BUTTONID_RIGHT,

	BUTTONID_NONE,
};

enum {
	AREASELECT_RESULT_NONE,		///< ͈͑I𒆃J[\FȂɂȂ
	AREASELECT_RESULT_UPDATE,	///< ͈͑I𒆃J[\FʒuXV
	AREASELECT_RESULT_OVER,		///< ͈͑I𒆃J[\FړłȂւ̃L[
	AREASELECT_RESULT_SCROLL_LEFT,		///< ͈͑I𒆃J[\FgCXN[
	AREASELECT_RESULT_SCROLL_RIGHT,		///< ͈͑I𒆃J[\FgCEXN[
};


/// Tuʑ𔲂L[
#define SUBLCD_CTRL_ESCAPE_KEYMASK	(PAD_PLUS_KEY_MASK|PAD_BUTTON_A|PAD_BUTTON_B)

static const TP_HIT_TBL ButtonHitTbl[] = {
	{ TP_USE_CIRCLE,   0, 184, 40 },
	{ TP_USE_CIRCLE, 255, 184, 40 },
	{ TP_HIT_END,0,0,0},
};

static const TP_HIT_TBL IconHitTbl[] = {
	{ TP_USE_CIRCLE, 256 -104, 168, 16 },
	{ TP_USE_CIRCLE, 256 - 93, 134, 16 },
	{ TP_USE_CIRCLE, 256 - 72, 104, 16 },
	{ TP_USE_CIRCLE, 256 - 40,  84, 16 },
	{ TP_USE_CIRCLE, 256 - 16,  52, 16 },
	{ TP_USE_CIRCLE, 256 - 16,  16, 16 },
	{ TP_HIT_END,0,0,0},
};


//==============================================================
// Sub Work
//==============================================================
typedef struct {
	u32  seq;			///< V[PXio[
	u8   continue_flag;	///< EBhE͊JԂŃL[瑱tO
	s8   trayNumber;	///< \w聕Iʊi[
	u16  msgID;			///< Iɕ\郁bZ[WID
}SELECT_TRAY_WORK;

//==============================================================
// Main Work
//==============================================================
typedef struct _BOXAPP_WORK{
	BOXAPP_VPARAM		vpara;
	BOXAPP_VIEW_WORK*	vwk;
	SAVEDATA*			saveData;
	BOX_DATA*			boxData;
	POKEPARTY*			partyData;
	NAMEIN_PARAM*		nameinParam;
	PSTATUS_DATA		statusParam;

	BUTTON_MAN*			bmn;
	BUTTON_MAN*         icon_bmn;
	u32					btn_id;
	u32					touch_icon_id;

	MSGDATA_MANAGER*	msgman_box;
	MSGDATA_MANAGER*	msgman_poke;
	MSGDATA_MANAGER*	msgman_poke_character;
	MSGDATA_MANAGER*	msgman_speabi;
	WORDSET*			wordset;
	POKEMON_PARAM*		partyPokeWork;

	PROC_RESULT (*mainSeqFunc)( struct _BOXAPP_WORK* );
	PROC_RESULT (*prevSeqFunc)( struct _BOXAPP_WORK* );
	void (*subSeqFunc)( struct _BOXAPP_WORK*, u32* seq );

	u32			seq;
	u32			subseq;
	s32			work;

	SELECT_TRAY_WORK		selectTrayWork;
	u32						azukeruTrayNumber;

	BOX_REEL_CTRL			reel;
	int						reel_pos;
	u32						reel_timer;
	BOOL					reel_move_flag;

	PROC*		subProc;
	void*		subProcWork;

	u32 itemno;
}BOXAPP_WORK;

typedef  PROC_RESULT (*seqFunc)( BOXAPP_WORK* );
typedef  void (*SubSeqFunc)( BOXAPP_WORK*, u32* );

//==============================================================
// Prototype
//==============================================================
static void MainSeqChange( BOXAPP_WORK* wk, seqFunc nextSeqFunc );
static void SubSeqSet( BOXAPP_WORK* wk, SubSeqFunc subseq );
static void SubSeqEnd( BOXAPP_WORK* wk );
static seqFunc CheckNextMainSeq( BOXAPP_WORK* wk );
static PROC_RESULT BoxMainSeq_Open( BOXAPP_WORK* wk );
static PROC_RESULT BoxMainSeq_Tray( BOXAPP_WORK* wk );
static PROC_RESULT BoxMainSeq_Party( BOXAPP_WORK* wk );
static PROC_RESULT BoxMainSeq_TrayTab( BOXAPP_WORK* wk );
static PROC_RESULT BoxMainSeq_ExitButton( BOXAPP_WORK* wk );
static PROC_RESULT BoxMainSeq_PartyButton( BOXAPP_WORK* wk );
static void SetPokemonStatusScheneParam( BOXAPP_WORK* wk );
static PROC_RESULT BoxMainSeq_OP_BExit( BOXAPP_WORK* wk );
static PROC_RESULT BoxMainSeq_OP_Exit( BOXAPP_WORK* wk );
static PROC_RESULT BoxMainSeq_Close( BOXAPP_WORK* wk );
static void SubSeq_Menu_Pokemon( BOXAPP_WORK* wk, u32* seq );
static void SubSeq_Menu_Tray( BOXAPP_WORK* wk, u32* seq );
static void SubSeq_Menu_Jump( BOXAPP_WORK* wk, u32* seq );
static void SubSeq_Menu_WallPaper( BOXAPP_WORK* wk, u32* seq );
static void SubSeq_Menu_Marking( BOXAPP_WORK* wk, u32* seq );
static void SubSeq_AreaSelect( BOXAPP_WORK* wk, u32* seq );
static BOOL Check_AreaSelectPokePut( const BOXAPP_VPARAM* vpara );
static void SubSeq_OP_Tukamu( BOXAPP_WORK* wk, u32* seq );
static void SubSeq_OP_Tureteiku( BOXAPP_WORK* wk, u32* seq );
static void SubSeq_OP_Azukeru( BOXAPP_WORK* wk, u32* seq );
static void SubSeq_OP_Nigasu( BOXAPP_WORK* wk, u32* seq );
static void SubSeq_Connect_InputTrayName( BOXAPP_WORK* wk, u32* seq );
static void SubSeq_Connect_PokemonStatus( BOXAPP_WORK* wk, u32* seq );
static void SubSeq_Connect_Bag( BOXAPP_WORK* wk, u32 *seq );
static void SubSeq_Restore_Item( BOXAPP_WORK* wk, u32* seq );
static void SelectTrayCtrl_Init( BOXAPP_WORK* wk, u32 init_tray_num, u32 msg_id );
static void SelectTrayCtrl_Continue( BOXAPP_WORK* wk );
static BOOL SelectTrayCtrl_Main( BOXAPP_WORK* wk );
static int calc_reelmove_vector( int* next, int now, u32 max );
static void SubSeq_TrayMode( BOXAPP_WORK* wk,  u32* seq );
static void SubSeq_LimitMode( BOXAPP_WORK* wk,  u32* seq );
static BOOL CheckLimitModeIconTouch( BOXAPP_WORK* wk );
static void IconBmnCallBack( u32 btnID, u32 event, void* wk_adrs );
static void InitWork( BOXAPP_WORK* wk, BOX_PROC_PARAM* proc_param );
static void DeleteWork( BOXAPP_WORK* wk );
static void InitWork_system( BOXAPP_SYSTEM* system, int mode );
static void InitWork_cursor( BOXAPP_WORK* wk );
static void InitWork_catchpoke( BOXAPP_CATCH_POKE* catchPoke );
static void DeleteWork_catchpoke( BOXAPP_CATCH_POKE* catchPoke );
static void InitWork_tray( BOX_DATA* box, BOXAPP_TRAY* tray );
static void DeleteWork_tray( BOXAPP_TRAY* tray );
static void InitWork_statusPoke( BOXAPP_STATUS_POKE* statusPoke );
static void DeleteWork_statusPoke( BOXAPP_STATUS_POKE* statusPoke );
static void InitWork_SubLCD( BOXAPP_SUBLCD* sub );
static void SetTrayStatus( const BOX_DATA* box, BOXAPP_TRAY* tray );
static void TrayCurrentWallPaperUpdate( BOXAPP_VPARAM* vpara, BOX_DATA* box );
static BOOL CursorMoveCheck( u32 keyflag, BOXAPP_WORK* wk );
static BOOL CursorPosMove( BOXAPP_VPARAM* vpara, int x, int y );
static int CursorMoveCheck_AreaSelect( u32 keyflag, BOXAPP_WORK* wk );
static int CursorPosMove_AreaSelect( BOXAPP_VPARAM* vpara, int x, int y );
static void CursorPosSetForPartyBoxButtonOpen( BOXAPP_WORK* wk );
static void CursorPosSetForPartyBoxButtonClose( BOXAPP_WORK* wk );
static void CursorPointPokeUpdate( BOXAPP_WORK* wk );
static BOOL CheckButtonPush( BOXAPP_WORK* wk );
static void BmnCallBack( u32 btnID, u32 event, void* wk_adrs );
static void VParaSet_MessageID( BOXAPP_VPARAM* vpara, u32 msgID );
static void VParaSet_CursorTrayPos( BOXAPP_VPARAM* vpara, u32 x, u32 y );
static void VParaSet_PokeCatch( BOXAPP_WORK* wk, BOXAPP_VPARAM* vpara );
static void VParaSet_AreaSelectPokeCatch( BOXAPP_WORK* wk, BOXAPP_VPARAM* vpara );
static void VParaSet_StartAreaSelect( BOXAPP_WORK* wk, BOXAPP_VPARAM* vpara );
static void VParaSet_UpdateAreaSelect( BOXAPP_WORK* wk, BOXAPP_VPARAM* vpara );
static void VParaSet_PokePut( BOXAPP_WORK* wk, BOXAPP_VPARAM* vpara );
static void VParaSet_AreaSelectPokePut( BOXAPP_WORK* wk, BOXAPP_VPARAM* vpara );
static void VParaSet_PokeChange( BOXAPP_WORK* wk, BOXAPP_VPARAM* vpara);
static BOOL VParaSet_CatchPokeAzuke( BOXAPP_WORK* wk, u32 trayNum );
static BOOL VParaSet_PointPokeAzuke( BOXAPP_WORK* wk, u32 trayNum );
static void VParaSet_CatchPokeNigasu( BOXAPP_WORK* wk );
static void VParaSet_PointPokeNigasu( BOXAPP_WORK* wk );
static void VParaSet_StatusPoke( BOXAPP_VPARAM* vpara, POKEMON_PASO_PARAM* ppp, BOXAPP_WORK* wk );
static void VParaSet_StatusPokeData( BOXAPP_VPARAM* vpara, POKEMON_PASO_PARAM* ppp );
static void VParaSet_StatusPokeMark( BOXAPP_VPARAM* vpara );
static void VParaSet_StatusPokeItemNumber( BOXAPP_VPARAM* vpara, u16 itemno, BOXAPP_WORK* wk );
static void VParaSet_CurrentTrayInc( BOXAPP_VPARAM* vpara );
static void VParaSet_CurrentTrayDec( BOXAPP_VPARAM* vpara );
static void VParaSet_CurrentTrayNumberSet( BOXAPP_VPARAM* vpara, u32 number );
static void VParaSet_JumpWin( BOXAPP_VPARAM* vpara, u32 center_trayno );
static void VParaSet_SubLCDStae( BOXAPP_VPARAM* vpara, u32 state );
static void VParaSet_SubLCDPos( BOXAPP_VPARAM* vpara, u32 pos );
static void VParaSet_SubLCDLimitPos( BOXAPP_VPARAM* vpara, u32 pos );
static void VParaSet_SubLCDMove( BOXAPP_VPARAM* vpara, int move );
static void VParaSet_LimitModeBitFlag( BOXAPP_VPARAM* vpara, u32 iconID );
static void VParaSet_ExpertModeChange( BOXAPP_VPARAM* vpara );


//------------------------------------------------------------------
/**
 * {bNXAvPROCFInit
 *
 * @param   proc			
 * @param   seq				
 *
 * @retval  PROC_RESULT		
 */
//------------------------------------------------------------------
PROC_RESULT BoxProc_Init( PROC * proc, int * seq )
{
	BOXAPP_WORK* wk;

	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_BOX_SYSTEM, HEAPSIZE_SYS );
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_BOX_VIEW, HEAPSIZE_VIEW );

	wk = PROC_AllocWork( proc, sizeof(BOXAPP_WORK), HEAPID_BOX_SYSTEM );

	if( wk != NULL )
	{
		InitWork( wk, PROC_GetParentWork(proc) );
		BoxAppView_Init( &(wk->vwk), &wk->vpara, wk );

		wk->mainSeqFunc = BoxMainSeq_Open;
		wk->prevSeqFunc = BoxMainSeq_Open;
		wk->subSeqFunc = NULL;
		wk->seq = 0;
	}

	return PROC_RES_FINISH;
}
//------------------------------------------------------------------
/**
 * {bNXAvPROCFMain
 *
 * @param   proc			
 * @param   seq				
 *
 * @retval  PROC_RESULT		
 */
//------------------------------------------------------------------
PROC_RESULT BoxProc_Main( PROC* proc, int* seq )
{
	typedef PROC_RESULT (*BoxMainSeq)( BOXAPP_WORK* );

	BOXAPP_WORK* wk = PROC_GetWork(proc);

	if( wk->subSeqFunc != NULL )
	{
		wk->subSeqFunc( wk, &(wk->subseq) );
		return PROC_RES_CONTINUE;
	}
	else
	{
		if( wk->mainSeqFunc != NULL )
		{
			if( sys.trg & PAD_BUTTON_SELECT )
			{
				if( (BoxAppView_WaitCommandAll(wk->vwk) == TRUE)
				){
					VParaSet_ExpertModeChange( &wk->vpara );
					BoxAppView_SetCommand( wk->vwk, CMD_CHANGE_EXPERTMODE );
					return PROC_RES_CONTINUE;
				}
			}
			return wk->mainSeqFunc( wk );
		}
	}

	GF_ASSERT(0);
	return PROC_RES_FINISH;
}
//------------------------------------------------------------------
/**
 * {bNXAvPROCFEnd
 *
 * @param   proc			
 * @param   seq				
 *
 * @retval  PROC_RESULT		
 */
//------------------------------------------------------------------
PROC_RESULT BoxProc_End( PROC* proc, int* seq )
{
	BOXAPP_WORK* wk = PROC_GetWork( proc );

	BoxAppView_End( wk->vwk );
	DeleteWork( wk );

	sys_DeleteHeap(  HEAPID_BOX_SYSTEM );
	sys_DeleteHeap(  HEAPID_BOX_VIEW );

	return PROC_RES_FINISH;
}


//------------------------------------------------------------------
/**
 * CV[PXύX
 *
 * @param   wk		
 * @param   nextSeqFunc
 *
 */
//------------------------------------------------------------------
static void MainSeqChange( BOXAPP_WORK* wk, seqFunc nextSeqFunc )
{
	wk->prevSeqFunc = wk->mainSeqFunc;
	wk->mainSeqFunc = nextSeqFunc;
	wk->seq = 0;
}
//------------------------------------------------------------------
/**
 * TuV[PX֓؂ւ
 *
 * @param   wk			[N|C^
 * @param   subSeqFunc	TuV[PX֐|C^
 *
 */
//------------------------------------------------------------------
static void SubSeqSet( BOXAPP_WORK* wk, SubSeqFunc subseq )
{
	wk->subSeqFunc = subseq;
	wk->subseq = 0;
}
//------------------------------------------------------------------
/**
 * TuV[PXI
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void SubSeqEnd( BOXAPP_WORK* wk )
{
	wk->subSeqFunc = NULL;
}
//------------------------------------------------------------------
/**
 * ݂̃J[\ʒuΉCV[PX֐AhXԂ
 *
 * @param   wk		
 *
 * @retval  seqFunc		
 */
//------------------------------------------------------------------
static seqFunc CheckNextMainSeq( BOXAPP_WORK* wk )
{
	switch( BoxAppVPara_GetCursorArea( &(wk->vpara) ) ){
	case CURSOR_AREA_TRAY:
	default:
		return BoxMainSeq_Tray;

	case CURSOR_AREA_PARTY:
		return BoxMainSeq_Party;

	case CURSOR_AREA_TRAY_TAB:
		return BoxMainSeq_TrayTab;

	case CURSOR_AREA_EXIT_BUTTON:
		return BoxMainSeq_ExitButton;

	case CURSOR_AREA_PARTY_BUTTON:
		return BoxMainSeq_PartyButton;
	}
}


//------------------------------------------------------------------
/**
 * CV[PXFʃC
 *
 * @param   wk		
 *
 * @retval  PROC_RESULT		
 */
//------------------------------------------------------------------
static PROC_RESULT BoxMainSeq_Open( BOXAPP_WORK* wk )
{
	switch( wk->seq ) {
	case 0:
		BoxAppView_SetCommand( wk->vwk, CMD_INIT );
		wk->seq++;
		break;
	case 1:
		if(BoxAppView_WaitCommand( wk->vwk, CMD_INIT))
		{
			BoxAppView_SetCommand( wk->vwk, CMD_NORMAL_IN );
			wk->seq++;
		}
		break;
	case 2:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_NORMAL_IN ) )
		{
			MainSeqChange( wk, BoxMainSeq_Tray);
		}
		break;
	}
	return PROC_RES_CONTINUE;
}
//------------------------------------------------------------------
/**
 * CV[PXFgC
 *
 * @param   wk		
 *
 * @retval  PROC_RESULT		
 */
//------------------------------------------------------------------
static PROC_RESULT BoxMainSeq_Tray( BOXAPP_WORK* wk )
{
	switch( wk->seq ) {
	case 0:
		if( sys.trg & PAD_BUTTON_A ){
			if( BoxAppVPara_GetCursorStatusEnableFlag( &wk->vpara ) )
			{
//				MainSeqChange( wk, BoxMainSeq_Menu_Poke );
				SubSeqSet( wk, SubSeq_Menu_Pokemon );
				break;
			}
		}
		if( sys.trg & PAD_BUTTON_B ){
			MainSeqChange( wk, BoxMainSeq_OP_BExit );
			break;
		}
		if( CursorMoveCheck( sys.cont, wk ) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_CURSOR_MOVE );
			if( BoxAppVPara_GetCursorCatchPokeFlag( &wk->vpara ) == CURSOR_CATCH_NONE )
			{
				BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );
			}
			wk->seq++;
			break;
		}
		if( CheckButtonPush( wk ) )
		{
			if( wk->btn_id == BUTTONID_LEFT ){
				SubSeqSet( wk, SubSeq_TrayMode );
			}else if( wk->btn_id == BUTTONID_RIGHT ){
				SubSeqSet( wk, SubSeq_LimitMode );
			}
		}
		break;

	case 1:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_CURSOR_MOVE ) ){
			MainSeqChange( wk, CheckNextMainSeq( wk ) );
		}
		break;

	case 50:
		if( BoxAppView_WaitCommandAll( wk->vwk ) )
		{
			return PROC_RES_FINISH;
		}
		break;
	}
	return PROC_RES_CONTINUE;
}
//------------------------------------------------------------------
/**
 * CV[PXFĂgC
 *
 * @param   wk		[N|C^
 *
 * @retval  PROC_RESULT		
 */
//------------------------------------------------------------------
static PROC_RESULT BoxMainSeq_Party( BOXAPP_WORK* wk )
{
	enum {
		SEQ_KEYWAIT,
		SEQ_CURSORMOVE_WAIT,
		SEQ_TRAYCLOSE_WAIT,
		SEQ_TRAYCLOSE_CURSOR_WAIT,
	};

	switch( wk->seq ){
	case SEQ_KEYWAIT:
		if( sys.trg & PAD_BUTTON_A )
		{
			// {^̏
			if( BoxAppVPara_GetCursorPartyPos( &wk->vpara ) == CURSOR_PARTYTRAY_CLOSEBUTTON_POS )
			{
				if( BoxAppVPara_GetBoxMode( &wk->vpara ) == BOX_MODE_AZUKERU )
				{
					MainSeqChange( wk, BoxMainSeq_OP_Exit );
				}
				else
				{
					BoxAppView_SetCommand( wk->vwk, CMD_PARTYTRAY_CLOSE );
					wk->seq = SEQ_TRAYCLOSE_WAIT;
				}
				break;
			}
			// ȊȌꏊ
			if( BoxAppVPara_GetCursorStatusEnableFlag( &wk->vpara ) )
			{
//				MainSeqChange( wk, BoxMainSeq_Menu_Poke );
				SubSeqSet( wk, SubSeq_Menu_Pokemon );
				break;
			}
			break;
		}
		if( sys.trg & (PAD_BUTTON_B | PAD_KEY_RIGHT) )
		{
			if( BoxAppVPara_GetBoxMode( &wk->vpara ) == BOX_MODE_AZUKERU )
			{
				MainSeqChange( wk, BoxMainSeq_OP_BExit );
			}
			else
			{
				BoxAppView_SetCommand( wk->vwk, CMD_PARTYTRAY_CLOSE );
				wk->seq = SEQ_TRAYCLOSE_WAIT;
			}
			break;
		}
		if( CursorMoveCheck( sys.cont, wk ) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_CURSOR_MOVE );
			if( BoxAppVPara_GetCursorCatchPokeFlag( &wk->vpara ) == CURSOR_CATCH_NONE )
			{
				BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );
			}
			wk->seq = SEQ_CURSORMOVE_WAIT;
			break;
		}
		if( CheckButtonPush( wk ) )
		{
			if( wk->btn_id == BUTTONID_LEFT ){
				SubSeqSet( wk, SubSeq_TrayMode );
			}else if( wk->btn_id == BUTTONID_RIGHT ){
				SubSeqSet( wk, SubSeq_LimitMode );
			}
		}
		break;

	// J[\ړ҂
	case SEQ_CURSORMOVE_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_CURSOR_MOVE ) )
		{
			wk->seq = SEQ_KEYWAIT;
		}
		break;

	// gC҂
	case SEQ_TRAYCLOSE_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_PARTYTRAY_CLOSE ) )
		{
			CursorPosSetForPartyBoxButtonClose( wk );
			BoxAppView_SetCommand( wk->vwk, CMD_CURSOR_MOVE );
			if( BoxAppVPara_GetCursorCatchPokeFlag( &wk->vpara ) == CURSOR_CATCH_NONE )
			{
				BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );
			}
			wk->seq = SEQ_TRAYCLOSE_CURSOR_WAIT;
		}
		break;

	case SEQ_TRAYCLOSE_CURSOR_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_CURSOR_MOVE ) )
		{
			MainSeqChange( wk, CheckNextMainSeq( wk ) );
		}
		break;
	}

	return PROC_RES_CONTINUE;
}
//------------------------------------------------------------------
/**
 * CV[PXFgC^u
 *
 * @param   wk		[N|C^
 *
 * @retval  PROC_RESULT		
 */
//------------------------------------------------------------------
static PROC_RESULT BoxMainSeq_TrayTab( BOXAPP_WORK* wk )
{
	enum {
		SEQ_KEYWAIT,
		SEQ_TRAYCHANGE_WAIT,
		SEQ_CURSORMOVE_WAIT,
	};

	switch( wk->seq ){
	case SEQ_KEYWAIT:
		if( sys.cont & PAD_KEY_LEFT ){
			VParaSet_CurrentTrayDec( &wk->vpara );
			BOXDAT_SetCureentTrayNumber( wk->boxData, BoxAppVPara_GetTrayBoxNumber(&wk->vpara) );
			BoxAppView_SetCommand( wk->vwk, CMD_TRAY_CHANGE );
			wk->seq = SEQ_TRAYCHANGE_WAIT;
			break;
		}
		if( sys.cont & PAD_KEY_RIGHT ){
			VParaSet_CurrentTrayInc( &(wk->vpara) );
			BOXDAT_SetCureentTrayNumber( wk->boxData, BoxAppVPara_GetTrayBoxNumber(&wk->vpara) );
			BoxAppView_SetCommand( wk->vwk, CMD_TRAY_CHANGE );
			wk->seq = SEQ_TRAYCHANGE_WAIT;
			break;
		}
		if( sys.trg & PAD_BUTTON_A ){
			SubSeqSet( wk, SubSeq_Menu_Tray );
			break;
		}
		if( sys.trg & PAD_BUTTON_B ){
			MainSeqChange( wk, BoxMainSeq_OP_BExit );
			break;
		}
		if( CursorMoveCheck( sys.cont, wk ) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_CURSOR_MOVE );
			if( BoxAppVPara_GetCursorCatchPokeFlag( &wk->vpara ) == CURSOR_CATCH_NONE )
			{
				BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );
			}
			wk->seq = SEQ_CURSORMOVE_WAIT;
			break;
		}
		if( CheckButtonPush( wk ) )
		{
			if( wk->btn_id == BUTTONID_LEFT ){
				SubSeqSet( wk, SubSeq_TrayMode );
			}else if( wk->btn_id == BUTTONID_RIGHT ){
				SubSeqSet( wk, SubSeq_LimitMode );
			}
			break;
		}
		break;

	case SEQ_TRAYCHANGE_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_TRAY_CHANGE ) ){
			wk->seq = SEQ_KEYWAIT;
		}
		break;

	case SEQ_CURSORMOVE_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_CURSOR_MOVE ) ){
			MainSeqChange( wk, CheckNextMainSeq( wk ) );
		}
		break;
	}
	return PROC_RES_CONTINUE;
}
//------------------------------------------------------------------
/**
 * CV[PXFwƂx{^
 *
 * @param   wk		[N|C^
 *
 * @retval  PROC_RESULT		
 */
//------------------------------------------------------------------
static PROC_RESULT BoxMainSeq_ExitButton( BOXAPP_WORK* wk )
{
	enum {
		SEQ_KEYWAIT,
		SEQ_TRAYCHANGE_WAIT,
		SEQ_CURSORMOVE_WAIT,
	};

	switch( wk->seq ){
	case SEQ_KEYWAIT:
		if( sys.trg & PAD_BUTTON_A ){
			MainSeqChange( wk, BoxMainSeq_OP_Exit );
			break;
		}
		if( sys.trg & PAD_BUTTON_B ){
			MainSeqChange( wk, BoxMainSeq_OP_BExit );
			break;
		}
		if( CursorMoveCheck( sys.cont, wk ) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_CURSOR_MOVE );
			if( BoxAppVPara_GetCursorCatchPokeFlag( &wk->vpara ) == CURSOR_CATCH_NONE )
			{
				BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );
			}
			wk->seq = SEQ_CURSORMOVE_WAIT;
			break;
		}
		if( CheckButtonPush( wk ) )
		{
			if( wk->btn_id == BUTTONID_LEFT ){
				SubSeqSet( wk, SubSeq_TrayMode );
			}else if( wk->btn_id == BUTTONID_RIGHT ){
				SubSeqSet( wk, SubSeq_LimitMode );
			}
		}
		break;

	case SEQ_TRAYCHANGE_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_TRAY_CHANGE ) ){
			wk->seq = SEQ_KEYWAIT;
		}
		break;

	case SEQ_CURSORMOVE_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_CURSOR_MOVE ) ){
			MainSeqChange( wk, CheckNextMainSeq( wk ) );
		}
		break;
	}
	return PROC_RES_CONTINUE;
}
//------------------------------------------------------------------
/**
 * CV[PXFwĂ|Px{^
 *
 * @param   wk		[N|C^
 *
 * @retval  PROC_RESULT		
 */
//------------------------------------------------------------------
static PROC_RESULT BoxMainSeq_PartyButton( BOXAPP_WORK* wk )
{
	enum {
		SEQ_KEYWAIT,
		SEQ_BUTTONACTION_WAIT,
		SEQ_PARTYTRAY_OPEN_WAIT,
		SEQ_TRAYCHANGE_WAIT,
		SEQ_CURSORMOVE_WAIT,
		SEQ_WARN_MESSAGE_WAIT,
	};

	switch( wk->seq ){
	case SEQ_KEYWAIT:
		if( sys.trg & PAD_BUTTON_A )
		{
			if( BoxAppVPara_GetBoxMode(&wk->vpara) != BOX_MODE_TURETEIKU )
			{
				BoxAppView_SetCommand( wk->vwk, CMD_BUTTON_PUSH_ACTION );
				wk->seq = SEQ_BUTTONACTION_WAIT;
			}
			else
			{
				VParaSet_MessageID( &wk->vpara, msg_boxmes_01_19 );
				BoxAppView_SetCommand( wk->vwk, CMD_MSG_DISP );
				wk->seq = SEQ_WARN_MESSAGE_WAIT;

			}
			break;
		}
		if( sys.trg & PAD_BUTTON_B ){
			MainSeqChange( wk, BoxMainSeq_OP_BExit );
			break;
		}
		if( CursorMoveCheck( sys.cont, wk ) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_CURSOR_MOVE );
			if( BoxAppVPara_GetCursorCatchPokeFlag( &wk->vpara ) == CURSOR_CATCH_NONE )
			{
				BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );
			}
			wk->seq = SEQ_CURSORMOVE_WAIT;
			break;
		}
		if( CheckButtonPush( wk ) )
		{
			if( wk->btn_id == BUTTONID_LEFT ){
				SubSeqSet( wk, SubSeq_TrayMode );
			}else if( wk->btn_id == BUTTONID_RIGHT ){
				SubSeqSet( wk, SubSeq_LimitMode );
			}
		}
		break;

	case SEQ_BUTTONACTION_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_BUTTON_PUSH_ACTION ) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_PARTYTRAY_OPEN );
			wk->seq = SEQ_PARTYTRAY_OPEN_WAIT;
		}
		break;

	case SEQ_PARTYTRAY_OPEN_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_PARTYTRAY_OPEN ) )
		{
			CursorPosSetForPartyBoxButtonOpen( wk );
			BoxAppView_SetCommand( wk->vwk, CMD_CURSOR_MOVE );
			if( BoxAppVPara_GetCursorCatchPokeFlag( &wk->vpara ) == CURSOR_CATCH_NONE )
			{
				BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );
			}
			wk->seq = SEQ_CURSORMOVE_WAIT;
		}
		break;

	case SEQ_TRAYCHANGE_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_TRAY_CHANGE ) ){
			wk->seq = SEQ_KEYWAIT;
		}
		break;

	case SEQ_CURSORMOVE_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_CURSOR_MOVE ) ){
			MainSeqChange( wk, CheckNextMainSeq( wk ) );
		}
		break;

	case SEQ_WARN_MESSAGE_WAIT:
		if( sys.trg & (PAD_BUTTON_A|PAD_BUTTON_B))
		{
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			wk->seq = SEQ_KEYWAIT;
		}
		break;
	}
	return PROC_RES_CONTINUE;
}
//------------------------------------------------------------------
/**
 * |PXe[^Xʗpp[^Zbg
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void SetPokemonStatusScheneParam( BOXAPP_WORK* wk )
{
	/*
		typedef struct {
			void * ppd;		// |Pf[^
			u8	ppt;		// p[^^Cv
			u8	mode;		// [h
			u8	max;		// ő吔
			u8	pos;		// Ԗڂ̃f[^
			u8	ret_sel;
			u8	ret_mode;
			u8	dmy[3];
		}PSTATUS_DATA;
	*/
	u8	page_tbl[] = {
			PST_PAGE_INFO,			// u|P傤قv
			PST_PAGE_MEMO,			// ug[i[v
			PST_PAGE_PARAM,			// u|P̂傭v
			PST_PAGE_CONDITION,		// uRfBVv
			PST_PAGE_B_SKILL,		// u킴v
			PST_PAGE_C_SKILL,		// uReXg킴v
			PST_PAGE_RET,			// uǂv
			PST_PAGE_MAX
	};

	if( BoxAppVPara_GetCursorCatchPokeFlag( &wk->vpara ) == CURSOR_CATCH_SINGLE )
	{
		wk->statusParam.ppd = wk->vpara.catchPoke.ppp;
		wk->statusParam.ppt = PST_PP_TYPE_POKEPASO;
		wk->statusParam.max = 1;
		wk->statusParam.pos = 0;
		wk->statusParam.mode = 0;
	}
	else if( BoxAppVPara_GetCursorArea( &wk->vpara ) == CURSOR_AREA_TRAY )
	{
		wk->statusParam.ppd = BOXDAT_GetPokeDataAddress(wk->boxData, BOXDAT_GetCureentTrayNumber(wk->boxData), 0);
		wk->statusParam.ppt = PST_PP_TYPE_POKEPASO;
		wk->statusParam.max = BOX_MAX_POS;
		wk->statusParam.pos = BoxAppVPara_GetCursorTrayPos( &wk->vpara );
		wk->statusParam.mode = 0;
	}
	else
	{
		wk->statusParam.ppd = wk->partyData;
		wk->statusParam.ppt = PST_PP_TYPE_POKEPARTY;
		wk->statusParam.max = TEMOTI_POKEMAX;
		wk->statusParam.pos = BoxAppVPara_GetCursorPartyPos( &wk->vpara );
		wk->statusParam.mode = 0;
	}
	PokeStatus_PageSet( &(wk->statusParam), page_tbl );
}
//------------------------------------------------------------------
/**
 * CV[PXFa{^Ŕ悤Ƃ
 *
 * @param   wk		[N|C^
 *
 * @retval  PROC_RESULT		
 */
//------------------------------------------------------------------
static PROC_RESULT BoxMainSeq_OP_BExit( BOXAPP_WORK* wk )
{
	enum {
		SEQ_CATCH_CHECK,
		SEQ_TRAYCHANGE_WAIT,
		SEQ_WARN_VIEWWAIT,
		SEQ_WARN_KEYWAIT,
		SEQ_CLEAR_VIEWWAIT,
		SEQ_MENUWAIT,
		SEQ_MENU_VIEWWAIT,
	};

	switch( wk->seq ){
	case SEQ_CATCH_CHECK:
		if( BoxAppVPara_GetCursorCatchPokeFlag( &(wk->vpara) ) != CURSOR_CATCH_NONE )
		{
			VParaSet_MessageID( &wk->vpara, msg_boxmes_01_18 );
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_DISP );
			wk->seq = SEQ_WARN_VIEWWAIT;
			break;
		}
		else
		{
			Snd_SePlay( SOUND_DISP_MENU );
			VParaSet_MessageID( &wk->vpara, msg_boxmes_01_13 );
			BoxMenu_SetYesNoMenu( &(wk->vpara), 1 );
			BoxAppView_SetCommand( wk->vwk, CMD_MENU_DISP );
			wk->seq = SEQ_MENUWAIT;
		}
		break;

	case SEQ_MENUWAIT:
		switch( BoxMenu_Ctrl( &(wk->vpara) ) ){
		case BOXMENU_CTRL_MOVE:
			BoxAppView_SetCommand( wk->vwk, CMD_MENUCURSOR_UPDATE );
			break;
		case BOXMENU_CTRL_CANCEL:
		case BOXMENU_NO:
			MainSeqChange( wk, BoxMainSeq_Close );
			break;

		case BOXMENU_YES:
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			wk->seq = SEQ_CLEAR_VIEWWAIT;
			break;
		}
		break;


	case SEQ_WARN_VIEWWAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_MENU_DISP ) == FALSE)
		{
			break;
		}
		wk->seq = SEQ_WARN_KEYWAIT;
		/* fallthru */
	case SEQ_WARN_KEYWAIT:
		if( sys.trg & (PAD_BUTTON_A|PAD_BUTTON_B) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			wk->seq = SEQ_CLEAR_VIEWWAIT;
		}
		break;
	case SEQ_CLEAR_VIEWWAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_MSG_CLEAR ) )
		{
			MainSeqChange( wk, wk->prevSeqFunc );
		}
		break;
	}
	return PROC_RES_CONTINUE;
}
//------------------------------------------------------------------
/**
 * CV[PXFƂ{^Ŕ悤Ƃ
 *
 * @param   wk		[N|C^
 *
 * @retval  PROC_RESULT		
 */
//------------------------------------------------------------------
static PROC_RESULT BoxMainSeq_OP_Exit( BOXAPP_WORK* wk )
{
	enum {
		SEQ_CATCH_CHECK,
		SEQ_BUTTONACTION_WAIT,
		SEQ_MENUWAIT,
		SEQ_MENU_VIEWWAIT,
		SEQ_WARN_VIEWWAIT,
		SEQ_WARN_KEYWAIT,
		SEQ_CLEAR_VIEWWAIT,
	};

	switch( wk->seq ){
	case SEQ_CATCH_CHECK:
		if( BoxAppVPara_GetCursorCatchPokeFlag( &(wk->vpara) ) != CURSOR_CATCH_NONE )
		{
			VParaSet_MessageID( &wk->vpara, msg_boxmes_01_18 );
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_DISP );
			wk->seq = SEQ_WARN_VIEWWAIT;
			break;
		}
		else
		{
			BoxAppView_SetCommand( wk->vwk, CMD_BUTTON_PUSH_ACTION );
			wk->seq = SEQ_BUTTONACTION_WAIT;
		}
		break;

	case SEQ_BUTTONACTION_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_BUTTON_PUSH_ACTION ) )
		{
			Snd_SePlay( SOUND_DISP_MENU );
			// {bNXI܂H bZ[W\
			VParaSet_MessageID( &wk->vpara, msg_boxmes_01_12 );
			BoxMenu_SetYesNoMenu( &(wk->vpara), 1 );
			BoxAppView_SetCommand( wk->vwk, CMD_MENU_DISP );
			wk->seq = SEQ_MENUWAIT;
		}
		break;

	case SEQ_MENUWAIT:
		switch( BoxMenu_Ctrl( &(wk->vpara) ) ){
		case BOXMENU_CTRL_MOVE:
			BoxAppView_SetCommand( wk->vwk, CMD_MENUCURSOR_UPDATE );
			break;

		case BOXMENU_CTRL_CANCEL:
		case BOXMENU_NO:
			Snd_SePlay( SOUND_CANCEL );
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			wk->seq = SEQ_CLEAR_VIEWWAIT;
			break;

		case BOXMENU_YES:
			MainSeqChange( wk, BoxMainSeq_Close );
			break;
		}
		break;


	case SEQ_WARN_VIEWWAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_MENU_DISP ) == FALSE)
		{
			break;
		}
		wk->seq = SEQ_WARN_KEYWAIT;
		/* fallthru */
	case SEQ_WARN_KEYWAIT:
		if( sys.trg & (PAD_BUTTON_A|PAD_BUTTON_B) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			wk->seq = SEQ_CLEAR_VIEWWAIT;
		}
		break;
	case SEQ_CLEAR_VIEWWAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_MSG_CLEAR ) )
		{
			MainSeqChange( wk, wk->prevSeqFunc );
		}
		break;
	}
	return PROC_RES_CONTINUE;
}
//------------------------------------------------------------------
/**
 * CV[PXF{bNX鉉o
 *
 * @param   wk		
 *
 * @retval  PROC_RESULT		
 */
//------------------------------------------------------------------
static PROC_RESULT BoxMainSeq_Close( BOXAPP_WORK* wk )
{
	switch( wk->seq ){
	case 0:
		BoxAppView_SetCommand( wk->vwk, CMD_BOXCLOSE );
		wk->seq++;
		break;
	case 1:
		if( BoxAppView_WaitCommandAll( wk->vwk ) )
		{
			return PROC_RES_FINISH;
		}
	}
	return PROC_RES_CONTINUE;
}
//======================================================================================================
// TuV[PXQ
//======================================================================================================

//------------------------------------------------------------------
/**
 * TuV[PXF|Pj[
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void SubSeq_Menu_Pokemon( BOXAPP_WORK* wk, u32* seq )
{
	enum {
		SEQ_INIT,
		SEQ_INIT_WAIT,
		SEQ_MENU_CTRL,
		SEQ_DECIDE_MENU,
		SEQ_CANCEL_WAIT,
		SEQ_CMD_WAIT,
		SEQ_CMD_WAIT_LASTICON_CLOSEUP,
		SEQ_LASTPOKE_WARN,
	};

	switch( (*seq) ){
	case SEQ_INIT:
		WORDSET_RegisterPokeNickName( wk->wordset, 0, BoxAppVPara_GetStatusPokePara( &wk->vpara ) );
		VParaSet_MessageID( &wk->vpara, msg_boxmes_01_01 );
		BoxMenu_SetPokeMenu( &wk->vpara );
		if( BoxAppVPara_GetExpertModeFlag( &wk->vpara ) )
		{
			wk->work = BoxMenu_GetFirstMenuID( &wk->vpara );
			(*seq) = SEQ_DECIDE_MENU;
		}
		else
		{
			Snd_SePlay( SOUND_DISP_MENU );
			BoxAppView_SetCommand( wk->vwk, CMD_MENU_DISP );
			(*seq) = SEQ_INIT_WAIT;
		}
		break;
	case SEQ_INIT_WAIT:
		if(BoxAppView_WaitCommand( wk->vwk, CMD_MENU_DISP ) == FALSE){
			break;
		}
		(*seq) = SEQ_MENU_CTRL;
		/* fallthru */
	case SEQ_MENU_CTRL:
		wk->work = BoxMenu_Ctrl( &(wk->vpara) );
		switch( wk->work ){
		case BOXMENU_CTRL_LOOP:
			break;
		case BOXMENU_CTRL_MOVE:
			BoxAppView_SetCommand( wk->vwk, CMD_MENUCURSOR_UPDATE );
			break;
		case BOXMENU_CTRL_CANCEL:
		case BOXMENU_POKEMENU_QUIT:
			Snd_SePlay( SOUND_CANCEL );
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			(*seq) = SEQ_CANCEL_WAIT;
			break;

		default:
			Snd_SePlay( SOUND_DECIDE );
			(*seq) = SEQ_DECIDE_MENU;
			break;
		}
		break;

	case SEQ_DECIDE_MENU:
		switch( wk->work ){
		case BOXMENU_POKE_TUKAMU:
			if(	(BoxAppVPara_GetCursorArea(&wk->vpara) == CURSOR_AREA_TRAY)
			&&	(BoxAppVPara_GetExpertModeFlag(&wk->vpara) == TRUE )
			){
				SubSeqSet( wk, SubSeq_AreaSelect );
			}
			else
			{
				BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
				SubSeqSet( wk, SubSeq_OP_Tukamu );
			}
			break;

		case BOXMENU_POKE_OKU:
			VParaSet_PokePut( wk, &wk->vpara );
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			BoxAppView_SetCommand( wk->vwk, CMD_POKE_PUT );

			if(	(BoxAppVPara_GetCursorArea(&wk->vpara) == CURSOR_AREA_PARTY) )
			{
				u32 cpos, pcnt;

				cpos = BoxAppVPara_GetCursorPartyPos(&wk->vpara);
				pcnt = PokeParty_GetPokeCount(wk->partyData);

				if( cpos != (pcnt-1))
				{
					// 莝gCŃACR𐳋K̈ʒuɂȂꍇA
					// CMD_POKE_PUT ɐKʒu܂ŉ^ԁXe[^XXVKv
					(*seq) = SEQ_CMD_WAIT_LASTICON_CLOSEUP;
					CursorPointPokeUpdate( wk );
					break;
				}
			}
			(*seq) = SEQ_CMD_WAIT;
			break;

		case BOXMENU_POKE_IREKAERU:
			VParaSet_PokeChange( wk, &wk->vpara );
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			BoxAppView_SetCommand( wk->vwk, CMD_POKE_CHANGE );
			BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );
			(*seq) = SEQ_CMD_WAIT;
			break;

		case BOXMENU_POKE_TURETEIKU:
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			SubSeqSet( wk, SubSeq_OP_Tureteiku );
			break;

		case BOXMENU_POKE_AZUKERU:
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			SubSeqSet( wk, SubSeq_OP_Azukeru );
			break;

		case BOXMENU_POKE_MARKING:
			SubSeqSet( wk, SubSeq_Menu_Marking );
			break;

		case BOXMENU_POKE_NIGASU:
			SubSeqSet( wk, SubSeq_OP_Nigasu );
			break;

		case BOXMENU_POKE_YOUSU:
			SubSeqSet( wk, SubSeq_Connect_PokemonStatus );
			break;

		case BOXMENU_POKE_MOTIMONO:
			{
				if( BoxAppVPara_GetStatusPokeItemNumber( &wk->vpara ) == ITEM_DUMMY_ID )
				{
					SubSeqSet( wk, SubSeq_Connect_Bag );
				}
				else
				{
					SubSeqSet( wk, SubSeq_Restore_Item );
				}
			}
			break;
		}
		break;

	case SEQ_CANCEL_WAIT:
		if(BoxAppView_WaitCommand( wk->vwk, CMD_MSG_CLEAR ) )
		{
			SubSeqEnd(wk);
		}
		break;

	case SEQ_CMD_WAIT:
		if(BoxAppView_WaitCommandAll( wk->vwk ))
		{
			SubSeqEnd(wk);
		}
		break;

	case SEQ_CMD_WAIT_LASTICON_CLOSEUP:
		if(BoxAppView_WaitCommandAll( wk->vwk ))
		{
			CursorPointPokeUpdate( wk );
			BoxAppView_SetCommand( wk->vwk, CMD_PARTYLASTICON_CLOSEUP );
			BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );
			(*seq) = SEQ_CMD_WAIT;
		}
		break;
	}
}
//------------------------------------------------------------------
/**
 * TuV[PXFgCj[
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void SubSeq_Menu_Tray( BOXAPP_WORK* wk, u32* seq )
{
	enum {
		SEQ_INIT,
		SEQ_INIT_WAIT,
		SEQ_MENU_CTRL,
		SEQ_DECIDE_MENU,
		SEQ_CANCEL_WAIT,
		SEQ_CMD_WAIT,
		SEQ_CMD_WAIT_UPDATE,
		SEQ_GOTO_WALLPAPER_MENU,
	};

	switch( (*seq) ){
	case SEQ_INIT:
		VParaSet_MessageID( &wk->vpara, msg_boxmes_01_08 );
		BoxMenu_SetTrayMenu( &wk->vpara );
		if( BoxAppVPara_GetExpertModeFlag( &wk->vpara ) )
		{
			wk->work = BoxMenu_GetFirstMenuID( &wk->vpara );
			(*seq) = SEQ_DECIDE_MENU;
		}
		else
		{
			Snd_SePlay( SOUND_DISP_MENU );
			BoxAppView_SetCommand( wk->vwk, CMD_MENU_DISP );
			(*seq) = SEQ_INIT_WAIT;
		}
		break;
	case SEQ_INIT_WAIT:
		if(BoxAppView_WaitCommand( wk->vwk, CMD_MENU_DISP ) == FALSE){
			break;
		}
		(*seq) = SEQ_MENU_CTRL;
		/* fallthru */
	case SEQ_MENU_CTRL:
		wk->work = BoxMenu_Ctrl( &(wk->vpara) );
		switch( wk->work ){
		case BOXMENU_CTRL_LOOP:
			break;
		case BOXMENU_CTRL_MOVE:
			BoxAppView_SetCommand( wk->vwk, CMD_MENUCURSOR_UPDATE );
			break;
		case BOXMENU_CTRL_CANCEL:
		case BOXMENU_TRAYMENU_QUIT:
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			(*seq) = SEQ_CANCEL_WAIT;
			break;
		default:
			(*seq) = SEQ_DECIDE_MENU;
			break;
		}
		break;

	case SEQ_DECIDE_MENU:
		switch(wk->work){
		case BOXMENU_TRAY_JUMP:
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			SubSeqSet( wk, SubSeq_Menu_Jump );
			break;

		case BOXMENU_TRAY_WALLPAPER:
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			(*seq) = SEQ_GOTO_WALLPAPER_MENU;
			break;

		case BOXMENU_TRAY_NAME:
			SubSeqSet( wk, SubSeq_Connect_InputTrayName );
			break;
		}
		break;


	case SEQ_CANCEL_WAIT:
		if(BoxAppView_WaitCommand( wk->vwk, CMD_MSG_CLEAR ) )
		{
			SubSeqEnd( wk );
		}
		break;

	case SEQ_GOTO_WALLPAPER_MENU:
		if(BoxAppView_WaitCommand( wk->vwk, CMD_MSG_CLEAR ) )
		{
			SubSeqSet( wk, SubSeq_Menu_WallPaper );
		}
		break;

	}
}
//------------------------------------------------------------------
/**
 * TuV[PXF{bNX؂ւ
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void SubSeq_Menu_Jump( BOXAPP_WORK* wk, u32* seq )
{
	enum {
		SEQ_INIT,
		SEQ_SUBSEQ_RET,
		SEQ_RETURN,
	};

	switch( (*seq) ){
	case SEQ_INIT:
		SelectTrayCtrl_Init( wk, BoxAppVPara_GetTrayBoxNumber( &wk->vpara ), msg_boxmes_01_09 );
		(*seq) = SEQ_SUBSEQ_RET;
		break;

	case SEQ_SUBSEQ_RET:
		if( SelectTrayCtrl_Main(wk) == FALSE )
		{
			break;
		}
		// {bNXI񂾂LZƓ
		if( (wk->selectTrayWork.trayNumber == SELECT_TRAY_CANCEL)
		||	(wk->selectTrayWork.trayNumber == BoxAppVPara_GetTrayBoxNumber( &wk->vpara ))
		){
			(*seq) = SEQ_RETURN;
		}
		else
		{
			VParaSet_CurrentTrayNumberSet( &wk->vpara, wk->selectTrayWork.trayNumber );
			BOXDAT_SetCureentTrayNumber( wk->boxData, wk->selectTrayWork.trayNumber );
			BoxAppView_SetCommand( wk->vwk, CMD_TRAY_CHANGE );
			(*seq) = SEQ_RETURN;
		}
		BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
		BoxAppView_SetCommand( wk->vwk, CMD_JUMPWIN_CLEAR );
		break;

	case SEQ_RETURN:
		if( BoxAppView_WaitCommandAll( wk->vwk ) )
		{
			SubSeqEnd( wk );
		}
		break;
	}
}
//------------------------------------------------------------------
/**
 * TuV[PXFǎj[
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void SubSeq_Menu_WallPaper( BOXAPP_WORK* wk, u32* seq )
{
	enum {
		SEQ_INIT,
		SEQ_CATEGORY_INIT,
		SEQ_CATEGORY_DISPWAIT,
		SEQ_CATEGORY_MENUCTRL,
		SEQ_TYPE_DISPWAIT,
		SEQ_TYPE_MENUCTRL,
		SEQ_WPCHANGE_START,
		SEQ_VIEWWAIT_PREV,
		SEQ_VIEWWAIT_RETURN,
	};
	switch( (*seq) ){
	case SEQ_INIT:
		wk->work = BOXMENU_WP_CATEGORY1;
		(*seq) = SEQ_CATEGORY_INIT;
		/* fallthru */
	case SEQ_CATEGORY_INIT:
		VParaSet_MessageID( &wk->vpara, msg_boxmes_01_10 );
		BoxMenu_SetWallPaperCategoryMenu( &wk->vpara, wk->work );
		BoxAppView_SetCommand( wk->vwk, CMD_MENU_DISP );
		(*seq) = SEQ_CATEGORY_DISPWAIT;
		break;
	case SEQ_CATEGORY_DISPWAIT:
		if(BoxAppView_WaitCommand( wk->vwk, CMD_MENU_DISP ) == FALSE){
			break;
		}
		(*seq) = SEQ_CATEGORY_MENUCTRL;
		/* fallthru */
	case SEQ_CATEGORY_MENUCTRL:
		switch( BoxMenu_Ctrl(&(wk->vpara)) ){
		case BOXMENU_CTRL_LOOP:
			break;
		case BOXMENU_CTRL_MOVE:
			BoxAppView_SetCommand( wk->vwk, CMD_MENUCURSOR_UPDATE );
			break;
		case BOXMENU_CTRL_CANCEL:
		case BOXMENU_TRAYMENU_QUIT:
		default:
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			(*seq) = SEQ_VIEWWAIT_RETURN;
			break;
		case BOXMENU_WP_CATEGORY1:
		case BOXMENU_WP_CATEGORY2:
		case BOXMENU_WP_CATEGORY3:
		case BOXMENU_WP_CATEGORY4:
			// IꂽJeSoĂ
			wk->work = BoxMenu_GetSelectMenuID( &wk->vpara );
			VParaSet_MessageID( &wk->vpara, msg_boxmes_01_11 );
			BoxMenu_SetWallPaperTypeMenu( &wk->vpara, wk->work );
			BoxAppView_SetCommand( wk->vwk, CMD_MENU_DISP );
			(*seq) = SEQ_TYPE_DISPWAIT;
			break;
		}
		break;

	case SEQ_TYPE_DISPWAIT:
		if(BoxAppView_WaitCommand( wk->vwk, CMD_MENU_DISP ) == FALSE){
			break;
		}
		(*seq) = SEQ_TYPE_MENUCTRL;
		/* fallthru */
	case SEQ_TYPE_MENUCTRL:
		switch( BoxMenu_Ctrl(&(wk->vpara)) ){
		case BOXMENU_CTRL_LOOP:
			break;
		case BOXMENU_CTRL_MOVE:
			BoxAppView_SetCommand( wk->vwk, CMD_MENUCURSOR_UPDATE );
			break;
		case BOXMENU_CTRL_CANCEL:
		case BOXMENU_TRAYMENU_QUIT:
			(*seq) = SEQ_CATEGORY_INIT;
			break;
		default:
			wk->work = BoxMenu_GetSelectMenuID( &wk->vpara );
			if( wk->work >= BOXMENU_WP_NAME1_1 && wk->work <= BOXMENU_WP_NAME4_4 )
			{
				BOXDAT_SetWallPaperNumber( wk->boxData, BOXDAT_TRAYNUM_CURRENT, ( wk->work - BOXMENU_WP_NAME1_1 ) );
				TrayCurrentWallPaperUpdate( &wk->vpara, wk->boxData );
				BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
				(*seq) = SEQ_WPCHANGE_START;
			}
			else
			{
				GF_ASSERT(0);
				(*seq) = SEQ_CATEGORY_INIT;
			}
		}
		break;

	case SEQ_WPCHANGE_START:
		BoxAppView_SetCommand( wk->vwk, CMD_WALLPAPER_CHANGE );
		(*seq) = SEQ_VIEWWAIT_RETURN;
		break;

	case SEQ_VIEWWAIT_PREV:
		if(BoxAppView_WaitCommandAll( wk->vwk ))
		{
			(*seq) = SEQ_CATEGORY_INIT;
		}
		break;

	case SEQ_VIEWWAIT_RETURN:
		if(BoxAppView_WaitCommandAll( wk->vwk ))
		{
			SubSeqEnd(wk);
		}
		break;
	}
}
//------------------------------------------------------------------
/**
 * TuV[PXF}[LOj[
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void SubSeq_Menu_Marking( BOXAPP_WORK* wk, u32* seq )
{
	enum {
		SEQ_INIT,
		SEQ_MENUCTRL,
		SEQ_RET,
	};

	switch( (*seq) ){
	case SEQ_INIT:
		BoxMenu_SetMarkingMenu( &wk->vpara );
		VParaSet_MessageID( &wk->vpara, msg_boxmes_01_02 );
		BoxAppView_SetCommand( wk->vwk, CMD_MENU_DISP );
		(*seq) = SEQ_MENUCTRL;
		break;

	case SEQ_MENUCTRL:
		if( BoxAppView_WaitCommandAll( wk->vwk ) == FALSE ){
			break;
		}else{
			u32 ctrl_result = BoxMenu_Ctrl(&(wk->vpara));
			switch( ctrl_result ){
			case BOXMENU_CTRL_LOOP:
				break;
			case BOXMENU_CTRL_MOVE:
				BoxAppView_SetCommand( wk->vwk, CMD_MENUCURSOR_UPDATE );
				break;

			case BOXMENU_CTRL_CANCEL:
			case BOXMENU_MARKING_CANCEL:
				BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
				(*seq) = SEQ_RET;
				break;

			case BOXMENU_MARKING_DECIDE:
				VParaSet_StatusPokeMark( &wk->vpara );
				BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
				BoxAppView_SetCommand( wk->vwk, CMD_STATUS_MARK_UPDATE );
				BoxAppView_SetCommand( wk->vwk, CMD_ICON_LIMITMODE_UPDATE );
				(*seq) = SEQ_RET;
				break;

			default:
				if( ctrl_result >= BOXMENU_MARK1 && ctrl_result <= BOXMENU_MARK6 )
				{
					ctrl_result -= BOXMENU_MARK1;
					BoxMenu_ReverseMarkingState( &wk->vpara, ctrl_result );
					BoxAppView_SetCommand( wk->vwk, CMD_MENUMARK_UPDATE );
				}
				break;
			}
		}
		break;

	case SEQ_RET:
		if( BoxAppView_WaitCommandAll( wk->vwk ) )
		{
			SubSeqEnd(wk);
		}
		break;
	}
}
//------------------------------------------------------------------
/**
 * TuV[PXFACR͈̔͑I
 *
 * @param   wk				[N|C^
 *
 */
//------------------------------------------------------------------
static void SubSeq_AreaSelect( BOXAPP_WORK* wk, u32* seq )
{
	enum {
		SEQ_INIT,
		SEQ_AREASELECT,
		SEQ_POSSELECT,
		SEQ_CURSORMOVE_AREASELECT,
		SEQ_POKEPUT_WAIT,
	};

	switch(*seq){
	case SEQ_INIT:
		if( sys.cont & PAD_BUTTON_A )
		{
			VParaSet_StartAreaSelect( wk, &wk->vpara );
			BoxAppView_SetCommand( wk->vwk, CMD_START_AREASELECT );
			*seq = SEQ_AREASELECT;
		}
		else
		{
			SubSeqSet( wk, SubSeq_OP_Tukamu );
		}
		break;

	case SEQ_AREASELECT:
		if( sys.cont & PAD_BUTTON_A )
		{
			switch( CursorMoveCheck_AreaSelect( sys.cont, wk ) ){
			case AREASELECT_RESULT_OVER:
				// [[[Ńuu[炷]]]
				break;

			case AREASELECT_RESULT_UPDATE:
				VParaSet_UpdateAreaSelect( wk, &wk->vpara );
				BoxAppView_SetCommand( wk->vwk, CMD_UPDATE_AREASELECT );
				BoxAppView_SetCommand( wk->vwk, CMD_CURSOR_MOVE );
				BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );
				*seq = SEQ_CURSORMOVE_AREASELECT;
				break;
			}
		}
		else
		{
			if( BoxAppVPara_CheckAreaSelectSinglePoke(&wk->vpara) )
			{
				BoxAppView_SetCommand( wk->vwk, CMD_END_AREASELECT );
				SubSeqSet( wk, SubSeq_OP_Tukamu );
			}
			else
			{
				VParaSet_AreaSelectPokeCatch( wk, &wk->vpara );
				BoxAppView_SetCommand( wk->vwk, CMD_CATCH_AREASELECT_POKE );
				*seq = SEQ_POSSELECT;
			}
		}
		break;


	case SEQ_POSSELECT:
		if( BoxAppView_WaitCommandAll( wk->vwk ) == FALSE )
		{
			break;
		}
		switch( CursorMoveCheck_AreaSelect( sys.cont, wk ) ){
		case AREASELECT_RESULT_OVER:
			// [[[Ńuu[炷]]]
			break;

		case AREASELECT_RESULT_UPDATE:
			BoxAppView_SetCommand( wk->vwk, CMD_CURSOR_MOVE );
			if( (BoxAppVPara_GetCursorCatchPokeFlag(&wk->vpara) & CUROSR_CATCH_STATUS_HOLD_MASK) == 0 )
			{
				BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );
			}
			break;

		case AREASELECT_RESULT_SCROLL_LEFT:
			VParaSet_CurrentTrayDec( &wk->vpara );
			BOXDAT_SetCureentTrayNumber( wk->boxData, BoxAppVPara_GetTrayBoxNumber(&wk->vpara) );
			BoxAppView_SetCommand( wk->vwk, CMD_TRAY_CHANGE );
			break;

		case AREASELECT_RESULT_SCROLL_RIGHT:
			VParaSet_CurrentTrayInc( &(wk->vpara) );
			BOXDAT_SetCureentTrayNumber( wk->boxData, BoxAppVPara_GetTrayBoxNumber(&wk->vpara) );
			BoxAppView_SetCommand( wk->vwk, CMD_TRAY_CHANGE );
			break;

		case AREASELECT_RESULT_NONE:
			if(sys.trg & PAD_BUTTON_A )
			{
				if(Check_AreaSelectPokePut(&wk->vpara))
				{
					VParaSet_AreaSelectPokePut( wk, &wk->vpara );
					BoxAppView_SetCommand( wk->vwk, CMD_POKE_PUT );
					*seq = SEQ_POKEPUT_WAIT;
				}
			}
			break;
		}
		break;

	case SEQ_CURSORMOVE_AREASELECT:
		if( BoxAppView_WaitCommandAll( wk->vwk ) )
		{
			*seq = SEQ_AREASELECT;
		}
		break;

	case SEQ_POKEPUT_WAIT:
		if( BoxAppView_WaitCommandAll( wk->vwk ) )
		{
			SubSeqEnd(wk);
		}
		break;

	}
}
//------------------------------------------------------------------
/**
 * ͈͑I𒆂̃|P݈ʒuɒu邩`FbN
 *
 * @param   vpara		
 *
 * @retval  BOOL		TRUEŒu
 */
//------------------------------------------------------------------
static BOOL Check_AreaSelectPokePut( const BOXAPP_VPARAM* vpara )
{
	POKEMON_PASO_PARAM* ppp;
	int i, catch_top_pos, put_top_pos, check_pos;
	const BOXAPP_CURSOR* cursor = &vpara->cursor;
	const BOXAPP_CATCH_POKE* catchPoke = &vpara->catchPoke;

	put_top_pos = BoxAppVPara_GetAreaSelectCursorTopPos(vpara);
	catch_top_pos = catchPoke->areaTopPos;

	for(i=0; i<catchPoke->areaPokeCount; i++)
	{
		check_pos = put_top_pos + (catchPoke->areaPokePos[i]-catch_top_pos);

		ppp = BOXDAT_GetPokeDataAddress( vpara->boxData, BOXDAT_TRAYNUM_CURRENT, check_pos );
		if( PokePasoParaGet( ppp, ID_PARA_poke_exist, NULL ) )
		{
			return FALSE;
		}
	}

	return TRUE;
}


//------------------------------------------------------------------
/**
 * TuV[PXFޓs
 *
 * @param   wk				[N|C^
 *
 */
//------------------------------------------------------------------
static void SubSeq_OP_Tukamu( BOXAPP_WORK* wk, u32* seq )
{
	enum {
		SEQ_INIT,
		SEQ_CMD_WAIT_CLOSEUP,
		SEQ_LASTPOKE_WARN,
		SEQ_CMD_WAIT,
	};

	switch( *seq ){
	case SEQ_INIT:
		if( BoxAppVPara_GetCursorArea( &wk->vpara ) == CURSOR_AREA_PARTY )
		{
			if( PokeParty_GetPokeCount( wk->partyData ) != 1 )
			{
				VParaSet_PokeCatch( wk, &wk->vpara );
				BoxAppView_SetCommand( wk->vwk, CMD_POKE_CATCH );
				(*seq) = SEQ_CMD_WAIT_CLOSEUP;
			}
			// cPCł͂߂Ȃ
			else
			{
				VParaSet_MessageID( &wk->vpara, msg_boxmes_01_07 );
				BoxAppView_SetCommand( wk->vwk, CMD_MSG_DISP );
				(*seq) = SEQ_LASTPOKE_WARN;
			}
		}
		else
		{
			VParaSet_PokeCatch( wk, &wk->vpara );
			BoxAppView_SetCommand( wk->vwk, CMD_POKE_CATCH );
			(*seq) = SEQ_CMD_WAIT;
		}
		break;


	case SEQ_CMD_WAIT_CLOSEUP:
		if(BoxAppView_WaitCommandAll( wk->vwk ))
		{
			CursorPointPokeUpdate( wk );
			BoxAppView_SetCommand( wk->vwk, CMD_PARTYICON_CLOSEUP );
			(*seq) = SEQ_CMD_WAIT;
		}
		break;

	case SEQ_LASTPOKE_WARN:
		if( sys.trg & (PAD_BUTTON_A|PAD_BUTTON_B) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			(*seq) = SEQ_CMD_WAIT;
		}
		break;

	case SEQ_CMD_WAIT:
		if(BoxAppView_WaitCommandAll( wk->vwk ))
		{
			SubSeqEnd(wk);
		}
		break;
	}
}
//------------------------------------------------------------------
/**
 * TuV[PXFĂs
 *
 * @param   wk				[N|C^
 *
 */
//------------------------------------------------------------------
static void SubSeq_OP_Tureteiku( BOXAPP_WORK* wk, u32* seq )
{
	enum {
		SEQ_PARTY_COUNT_CHECK,
		SEQ_ICONCATCH_WAIT,
		SEQ_PARTYTRAY_OPEN_WAIT,
		SEQ_CURSOR_GO_WAIT,
		SEQ_ICONPUT_WAIT,
		SEQ_PARTYTRAY_CLOSE_WAIT,
		SEQ_CURSOR_RET_WAIT,
		SEQ_WARNMSG_KEYWAIT,
		SEQ_RETURN,
	};

	switch( (*seq) ){
	case SEQ_PARTY_COUNT_CHECK:
		if( PokeParty_GetPokeCount( wk->partyData ) != TEMOTI_POKEMAX )
		{
			if( BoxAppVPara_GetCursorCatchPokeFlag( &wk->vpara ) == CURSOR_CATCH_SINGLE )
			{
				BoxAppView_SetCommand( wk->vwk, CMD_PARTYTRAY_OPEN );
				(*seq) = SEQ_PARTYTRAY_OPEN_WAIT;
			}
			else
			{
				VParaSet_PokeCatch( wk, &wk->vpara );
				BoxAppView_SetCommand( wk->vwk, CMD_POKE_CATCH );
				(*seq) = SEQ_ICONCATCH_WAIT;
			}
		}
		else
		{
			VParaSet_MessageID( &wk->vpara, msg_boxmes_01_06 );
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_DISP );
			(*seq) = SEQ_WARNMSG_KEYWAIT;
		}
		break;

	case SEQ_ICONCATCH_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_POKE_CATCH ) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_PARTYTRAY_OPEN );
			(*seq) = SEQ_PARTYTRAY_OPEN_WAIT;
		}
		break;

	case SEQ_PARTYTRAY_OPEN_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_PARTYTRAY_OPEN ) )
		{
			CursorPosSetForPartyBoxButtonOpen( wk );
			BoxAppView_SetCommand( wk->vwk, CMD_CURSOR_MOVE );
			(*seq) = SEQ_CURSOR_GO_WAIT;
		}
		break;

	case SEQ_CURSOR_GO_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_CURSOR_MOVE ) )
		{
			VParaSet_PokePut( wk, &wk->vpara );
			BoxAppView_SetCommand( wk->vwk, CMD_POKE_PUT );
			(*seq) = SEQ_ICONPUT_WAIT;
		}
		break;

	case SEQ_ICONPUT_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_POKE_PUT ) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_PARTYTRAY_CLOSE );
			(*seq) = SEQ_PARTYTRAY_CLOSE_WAIT;
		}
		break;

	case SEQ_PARTYTRAY_CLOSE_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_PARTYTRAY_CLOSE ) )
		{
			CursorPosSetForPartyBoxButtonClose( wk );
			BoxAppView_SetCommand( wk->vwk, CMD_CURSOR_MOVE );
			BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );
			(*seq) = SEQ_RETURN;
		}
		break;

	case SEQ_WARNMSG_KEYWAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_MSG_DISP ) == FALSE)
		{
			break;
		}
		if( sys.trg & (PAD_BUTTON_A|PAD_BUTTON_B) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			(*seq) = SEQ_RETURN;
		}
		break;

	case SEQ_RETURN:
		if( BoxAppView_WaitCommandAll( wk->vwk ) )
		{
			SubSeqEnd(wk);
		}
		break;
	}
}

//------------------------------------------------------------------
/**
 * TuV[PXF铮s
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void SubSeq_OP_Azukeru( BOXAPP_WORK* wk, u32* seq )
{
	enum {
		SEQ_INIT,
		SEQ_SUBSEQ_RET,
		SEQ_MSG_BOXFULL_KEYWAIT,
		SEQ_MSG_LASTPOKE_KEYWAIT,
		SEQ_AZUKERU_CATCHPOKE,
		SEQ_AZUKERU_POINTPOKE,
		SEQ_RET,
	};

	switch( (*seq) ){
	case SEQ_INIT:
	// 莝Ō̂P̂͗aȂ
		if(	(BoxAppVPara_GetCursorCatchPokeFlag( &wk->vpara ) == CURSOR_CATCH_NONE )
		&&	(PokeParty_GetPokeCount( wk->partyData ) == 1 )
		){
			VParaSet_MessageID( &wk->vpara, msg_boxmes_01_07 );
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_DISP );
			(*seq) = SEQ_MSG_LASTPOKE_KEYWAIT;
		}
		else
		{
			SelectTrayCtrl_Init( wk, wk->vpara.azukeruTrayNumber, msg_boxmes_01_20 );
			(*seq) = SEQ_SUBSEQ_RET;
		}
		break;

	case SEQ_SUBSEQ_RET:
		if( SelectTrayCtrl_Main(wk) == FALSE )
		{
			break;
		}

		if( wk->selectTrayWork.trayNumber == SELECT_TRAY_CANCEL )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			BoxAppView_SetCommand( wk->vwk, CMD_JUMPWIN_CLEAR );
			(*seq) = SEQ_RET;
			break;
		}

		wk->vpara.azukeruTrayNumber = wk->selectTrayWork.trayNumber;

		// ł|Pa
		if( BoxAppVPara_GetCursorCatchPokeFlag( &wk->vpara ) == CURSOR_CATCH_SINGLE )
		{
			if( VParaSet_CatchPokeAzuke( wk, wk->selectTrayWork.trayNumber ) )
			{
				BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
				BoxAppView_SetCommand( wk->vwk, CMD_JUMPWIN_CLEAR );
				(*seq) = SEQ_AZUKERU_CATCHPOKE;
				break;
			}
		}
		// wĂ|Pa
		else
		{
			if( VParaSet_PointPokeAzuke( wk, wk->selectTrayWork.trayNumber ) )
			{
				BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
				BoxAppView_SetCommand( wk->vwk, CMD_JUMPWIN_CLEAR );
				(*seq) = SEQ_AZUKERU_POINTPOKE;
				break;
			}
		}
	// {bNXςŗaȂRRɂ
		VParaSet_MessageID( &wk->vpara, msg_boxmes_01_14 );
		BoxAppView_SetCommand( wk->vwk, CMD_MSG_DISP );
		(*seq) = SEQ_MSG_BOXFULL_KEYWAIT;
		break;

	case SEQ_MSG_BOXFULL_KEYWAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_MSG_DISP ) == FALSE ){
			break;
		}
		if( sys.trg & (PAD_BUTTON_A|PAD_BUTTON_B) )
		{
			SelectTrayCtrl_Continue( wk );
			(*seq) = SEQ_SUBSEQ_RET;
		}
		break;

	case SEQ_MSG_LASTPOKE_KEYWAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_MSG_DISP ) == FALSE )
		{
			break;
		}
		if( sys.trg & (PAD_BUTTON_A|PAD_BUTTON_B) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			(*seq) = SEQ_RET;
		}
		break;

	case SEQ_AZUKERU_CATCHPOKE:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_JUMPWIN_CLEAR ) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_AZUKERU_CATCHPOKE );
			BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );
			(*seq) = SEQ_RET;
		}
		break;

	case SEQ_AZUKERU_POINTPOKE:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_JUMPWIN_CLEAR ) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_AZUKERU_POINTPOKE );
			BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );
			(*seq) = SEQ_RET;
		}
		break;

	case SEQ_RET:
		if( BoxAppView_WaitCommandAll( wk->vwk ) )
		{
			SubSeqEnd( wk );
		}
		break;
	}
}
//------------------------------------------------------------------
/**
 * TuV[PXFɂs
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void SubSeq_OP_Nigasu( BOXAPP_WORK* wk, u32* seq )
{
	enum {
		SEQ_INIT,
		SEQ_MENU_CTRL,
		SEQ_NIGASU,
		SEQ_MSG1,
		SEQ_MSG2,
		SEQ_MSG_KEYWAIT,
		SEQ_NIGASU_END,
		SEQ_MSG_LASTPOKE_KEYWAIT,
		SEQ_RET,
	};

	enum {
		CATCHPOKE,
		TRAYPOKE,
		PARTYPOKE,
	};

	switch( (*seq) ){
	case SEQ_INIT:
	// 莝Ō̂P͓̂Ȃ
		if(	(BoxAppVPara_GetCursorCatchPokeFlag( &wk->vpara ) == CURSOR_CATCH_NONE)
		&&	(PokeParty_GetPokeCount( wk->partyData ) == 1 )
		){
			VParaSet_MessageID( &wk->vpara, msg_boxmes_01_07 );
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_DISP );
			(*seq) = SEQ_MSG_LASTPOKE_KEYWAIT;
		}
		else
		{
			VParaSet_MessageID( &wk->vpara, msg_boxmes_01_03 );
			BoxMenu_SetYesNoMenu( &(wk->vpara), 1 );
			BoxAppView_SetCommand( wk->vwk, CMD_MENU_DISP );
			(*seq) = SEQ_MENU_CTRL;
		}
		break;

	case SEQ_MENU_CTRL:
		if( BoxAppView_WaitCommandAll( wk->vwk ) == FALSE )
		{
			break;
		}
		switch( BoxMenu_Ctrl( &(wk->vpara) ) ){
		case BOXMENU_CTRL_MOVE:
			BoxAppView_SetCommand( wk->vwk, CMD_MENUCURSOR_UPDATE );
			break;
		case BOXMENU_CTRL_CANCEL:
		case BOXMENU_NO:
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			(*seq) = SEQ_RET;
			break;

		case BOXMENU_YES:
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			(*seq) = SEQ_NIGASU;
			break;
		}
		break;

	case SEQ_NIGASU:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_MSG_CLEAR ) )
		{
			// Pobt@Ƀ|PZbgĂ
			WORDSET_RegisterPokeNickName( wk->wordset, 0, BoxAppVPara_GetStatusPokePara( &wk->vpara ) );


			// ł|P̏ꍇ
			if( BoxAppVPara_GetCursorCatchPokeFlag( &wk->vpara ) == CURSOR_CATCH_SINGLE )
			{
				VParaSet_CatchPokeNigasu( wk );
				BoxAppView_SetCommand( wk->vwk, CMD_NIGASU_CATCHPOKE );

				/*
					p[^XV͒͂łtOŎʂłȂȂ̂
					ǂ̃|P𓦂[NɕۑĂ
				*/
				wk->work = CATCHPOKE;
			}
			// wĂ|P̏ꍇ
			else
			{
				VParaSet_PointPokeNigasu( wk );

				if( BoxAppVPara_GetCursorArea( &wk->vpara ) == CURSOR_AREA_TRAY )
				{
					BoxAppView_SetCommand( wk->vwk, CMD_NIGASU_TRAYPOKE );
					wk->work = TRAYPOKE;
				}
				else
				{
					BoxAppView_SetCommand( wk->vwk, CMD_NIGASU_PARTYPOKE );
					wk->work = PARTYPOKE;
				}
			}
			(*seq) = SEQ_MSG1;
		}
		break;

	case SEQ_MSG1:
		if( BoxAppView_WaitCommandAll( wk->vwk ) )
		{
			VParaSet_MessageID( &wk->vpara, msg_boxmes_01_04 );
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_DISP );
			(*seq) = SEQ_MSG2;
		}
		break;

	case SEQ_MSG2:
		if( BoxAppView_WaitCommandAll( wk->vwk ) == FALSE )
		{
			break;
		}
		if( sys.trg & (PAD_BUTTON_A | PAD_BUTTON_B ) )
		{
			VParaSet_MessageID( &wk->vpara, msg_boxmes_01_05 );
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_DISP );
			(*seq) = SEQ_MSG_KEYWAIT;
		}
		break;

	case SEQ_MSG_KEYWAIT:
		if( BoxAppView_WaitCommandAll( wk->vwk ) == FALSE )
		{
			break;
		}
		if( sys.trg & (PAD_BUTTON_A | PAD_BUTTON_B ) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			(*seq) = SEQ_NIGASU_END;
		}
		break;

	case SEQ_NIGASU_END:
		if( BoxAppView_WaitCommandAll( wk->vwk ) )
		{
			if( wk->work == PARTYPOKE )
			{
				BoxAppView_SetCommand( wk->vwk, CMD_PARTYICON_CLOSEUP );
			}
			BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );
			(*seq) = SEQ_RET;
		}
		break;

	case SEQ_MSG_LASTPOKE_KEYWAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_MSG_DISP ) == FALSE )
		{
			break;
		}
		if( sys.trg & (PAD_BUTTON_A|PAD_BUTTON_B) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			(*seq) = SEQ_RET;
		}
		break;


	case SEQ_RET:
		if( BoxAppView_WaitCommandAll( wk->vwk ) )
		{
			SubSeqEnd( wk );
		}
		break;
	}
}
//------------------------------------------------------------------
/**
 * TuV[PXF{bNX̖O͉ʂֈڍs`A
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void SubSeq_Connect_InputTrayName( BOXAPP_WORK* wk, u32* seq )
{
	switch( (*seq) ){
	case 0:
		BoxAppView_SetCommand( wk->vwk, CMD_FADEOUT );
		(*seq)++;
		break;
	case 1:
		if( BoxAppView_WaitCommand(wk->vwk, CMD_FADEOUT) )
		{
			BoxAppView_End( wk->vwk );
			sys_DeleteHeap( HEAPID_BOX_VIEW );

			BOXDAT_GetBoxName( wk->boxData, BOXDAT_GetCureentTrayNumber(wk->boxData), wk->nameinParam->strbuf );
			wk->subProc = PROC_Create( &NameInProcData, wk->nameinParam, HEAPID_BOX_SYSTEM );
			(*seq)++;
		}
		break;
	case 2:
		if( ProcMain( wk->subProc ) )
		{
			u32 current = BOXDAT_GetCureentTrayNumber( wk->boxData );

			PROC_Delete( wk->subProc );


			// {bNXf[^XV`p[^XVʍ\z̏
			sys_CreateHeap( HEAPID_BASE_APP, HEAPID_BOX_VIEW, HEAPSIZE_VIEW );
			BOXDAT_SetBoxName( wk->boxData, current, wk->nameinParam->strbuf );
			SetTrayStatus( wk->boxData, &wk->vpara.tray );
			BoxAppView_Init( &(wk->vwk), &wk->vpara, wk );
			BoxAppView_SetCommand( wk->vwk, CMD_INIT );
			(*seq)++;
		}
		break;
	case 3:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_INIT ) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_FADEIN );
			(*seq)++;
		}
		break;
	case 4:
		if( BoxAppView_WaitCommandAll( wk->vwk ) )
		{
			SubSeqEnd(wk);
		}
		break;
	
	}
}
//------------------------------------------------------------------
/**
 * TuV[PXF|PXe[^Xʂֈڍs`A
 *
 * @param   wk		[N|C^
 */
//------------------------------------------------------------------
static void SubSeq_Connect_PokemonStatus( BOXAPP_WORK* wk, u32* seq )
{
	switch( (*seq) ){
	case 0:
		BoxAppView_SetCommand( wk->vwk, CMD_FADEOUT );
		(*seq)++;
		break;
	case 1:
		if( BoxAppView_WaitCommand(wk->vwk, CMD_FADEOUT) )
		{
			BoxAppView_End( wk->vwk );
			sys_DeleteHeap( HEAPID_BOX_VIEW );
			SetPokemonStatusScheneParam( wk );
			wk->subProc = PROC_Create( &PokeStatusProcData, &(wk->statusParam), HEAPID_BOX_SYSTEM );
			(*seq)++;
		}
		break;
	case 2:
		if( ProcMain( wk->subProc ) )
		{
			u32 current = BOXDAT_GetCureentTrayNumber( wk->boxData );

			PROC_Delete( wk->subProc );

			// {bNXf[^XV`p[^XVʍ\z̏
			sys_CreateHeap( HEAPID_BASE_APP, HEAPID_BOX_VIEW, HEAPSIZE_VIEW );
			BoxAppView_Init( &(wk->vwk), &wk->vpara, wk );
			BoxAppView_SetCommand( wk->vwk, CMD_INIT );
			(*seq)++;
		}
		break;
	case 3:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_INIT ) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_FADEIN );
			(*seq)++;
		}
		break;
	case 4:
		if( BoxAppView_WaitCommandAll(wk->vwk) )
		{
			SubSeqEnd(wk);
		}
		break;
	
	}
}

//------------------------------------------------------------------
/**
 * TuV[PXFobOʂֈڍs`A
 *
 * @param   wk		[N|C^
 * @param   seq		V[PX
 *
 */
//------------------------------------------------------------------
static void SubSeq_Connect_Bag( BOXAPP_WORK* wk, u32 *seq )
{
	static const u8  bag_enable_pockets[] = {
		BAG_POKE_EVENT, BAG_POKE_NORMAL, BAG_POKE_NUTS, BAG_POKE_DRUG,
		BAG_POKE_BALL, BAG_POKE_BATTLE, BAG_POKE_SEAL, BAG_POKE_WAZA, 0xff
	};
	static u32  select_itemno;


	switch( (*seq) ){
	case 0:
		BoxAppView_SetCommand( wk->vwk, CMD_FADEOUT );
		(*seq)++;
		break;
	case 1:
		if( BoxAppView_WaitCommand(wk->vwk, CMD_FADEOUT) )
		{
			MYITEM*  myItem;

			BoxAppView_End( wk->vwk );
			sys_DeleteHeap( HEAPID_BOX_VIEW );

			myItem = SaveData_GetMyItem( wk->saveData );
			wk->subProcWork = MyItem_MakeBagData( myItem, bag_enable_pockets, HEAPID_BOX_SYSTEM );
			BagSystemDataSet( wk->subProcWork, BAG_POKE_NORMAL, BAG_MODE_ITEMSET, SaveData_GetMyStatus(wk->saveData) );

			wk->subProc = PROC_Create( &BagProcData, wk->subProcWork, HEAPID_BOX_SYSTEM );
			(*seq)++;
		}
		break;
	case 2:
		if( ProcMain( wk->subProc ) )
		{
			select_itemno = BagSysReturnItemGet( (BAG_DATA*)(wk->subProcWork) );

			PROC_Delete( wk->subProc );
			sys_FreeMemoryEz( wk->subProcWork );

			if( select_itemno != ITEM_DUMMY_ID )
			{
				VParaSet_StatusPokeItemNumber( &wk->vpara, select_itemno, wk );
			}

			// {bNXf[^XV`p[^XVʍ\z̏
			sys_CreateHeap( HEAPID_BASE_APP, HEAPID_BOX_VIEW, HEAPSIZE_VIEW );
			BoxAppView_Init( &(wk->vwk), &wk->vpara, wk );
			BoxAppView_SetCommand( wk->vwk, CMD_INIT );
			(*seq)++;
		}
		break;
	case 3:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_INIT ) )
		{
			BoxAppView_SetCommand( wk->vwk, CMD_FADEIN );
			(*seq)++;
		}
		break;
	case 4:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_FADEIN ) )
		{
			if( select_itemno == ITEM_DUMMY_ID )
			{
				SubSeqEnd( wk );
			}
			else
			{
				WORDSET_RegisterItemName( wk->wordset, 0, select_itemno );
				VParaSet_MessageID( &wk->vpara, msg_boxmes_01_17 );
				BoxAppView_SetCommand( wk->vwk, CMD_MSG_DISP );
				(*seq)++;
			}
		}
		break;
	case 5:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_MSG_DISP ) )
		{
			if( sys.trg & (PAD_BUTTON_A|PAD_BUTTON_B) )
			{
				Snd_SePlay( SOUND_DECIDE );
				BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
				(*seq)++;
			}
		}
		break;
	case 6:
		if( BoxAppView_WaitCommandAll(wk->vwk) )
		{
			SubSeqEnd(wk);
		}
		break;
	}
}

//------------------------------------------------------------------
/**
 * TuV[PXF|P̃ACeobOɖ߂
 *
 * @param   wk		[N|C^
 * @param   seq		V[PX
 *
 */
//------------------------------------------------------------------
static void SubSeq_Restore_Item( BOXAPP_WORK* wk, u32* seq )
{
	enum {
		SEQ_INIT,
		SEQ_CTRL_MENU,
		SEQ_RESTORE,
		SEQ_WAIT_STATUS_UPDATE,
		SEQ_WAIT_KEY,
		SEQ_RET,
	};

	static u32 itemno;

	switch( *seq ){
	case SEQ_INIT:
		itemno = BoxAppVPara_GetStatusPokeItemNumber( &wk->vpara );
		if( ItemMailCheck(itemno) )
		{
			VParaSet_MessageID( &wk->vpara, msg_boxmes_01_25 );
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_DISP );
			(*seq) = SEQ_WAIT_KEY;
		}
		else
		{
			WORDSET_RegisterItemName( wk->wordset, 0, itemno );
			BoxMenu_SetYesNoMenu( &(wk->vpara), 0 );
			VParaSet_MessageID( &wk->vpara, msg_boxmes_01_24 );
			BoxAppView_SetCommand( wk->vwk, CMD_MENU_DISP );
			(*seq) = SEQ_CTRL_MENU;
		}
		break;

	case SEQ_CTRL_MENU:
		if( BoxAppView_WaitCommandAll( wk->vwk ) == FALSE )
		{
			break;
		}
		switch( BoxMenu_Ctrl( &(wk->vpara) ) ){
		case BOXMENU_CTRL_MOVE:
			BoxAppView_SetCommand( wk->vwk, CMD_MENUCURSOR_UPDATE );
			break;
		case BOXMENU_CTRL_CANCEL:
		case BOXMENU_NO:
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			(*seq) = SEQ_RET;
			break;

		case BOXMENU_YES:
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
			(*seq) = SEQ_RESTORE;
			break;
		}
		break;

	case SEQ_RESTORE:
		if( MyItem_AddItem( SaveData_GetMyItem(wk->saveData), itemno, 1, HEAPID_BOX_SYSTEM ) )
		{
			VParaSet_StatusPokeItemNumber( &wk->vpara, ITEM_DUMMY_ID, wk );
			BoxAppView_SetCommand( wk->vwk, CMD_STATUS_UPDATE );

			*seq = SEQ_WAIT_STATUS_UPDATE;
		}
		else
		{
			VParaSet_MessageID( &wk->vpara, msg_boxmes_01_14 );
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_DISP );

			*seq = SEQ_WAIT_KEY;
		}
		break;

	case SEQ_WAIT_STATUS_UPDATE:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_STATUS_UPDATE ) )
		{
			VParaSet_MessageID( &wk->vpara, msg_boxmes_01_16 );
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_DISP );
			*seq = SEQ_WAIT_KEY;
		}
		break;

	case SEQ_WAIT_KEY:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_MSG_DISP ) )
		{
			if( sys.trg & (PAD_BUTTON_A|PAD_BUTTON_B) )
			{
				Snd_SePlay( SOUND_DECIDE );
				BoxAppView_SetCommand( wk->vwk, CMD_MSG_CLEAR );
				(*seq) = SEQ_RET;
			}
		}
		break;

	case SEQ_RET:
		if( BoxAppView_WaitCommandAll( wk->vwk ) )
		{
			SubSeqEnd( wk );
		}
		break;
	}
}

//======================================================================================================
// gCIRg[֘A
//======================================================================================================

//------------------------------------------------------------------
/**
 * gCIRg[
 *
 * @param   wk					[N|C^
 * @param   init_tray_num		\gCio[
 * @param   msg_id				Iɕ\郁bZ[WID
 *
 */
//------------------------------------------------------------------
static void SelectTrayCtrl_Init( BOXAPP_WORK* wk, u32 init_tray_num, u32 msg_id )
{
	wk->selectTrayWork.seq = 0;
	wk->selectTrayWork.trayNumber = init_tray_num;
	wk->selectTrayWork.msgID = msg_id;
	wk->selectTrayWork.continue_flag = FALSE;
}

static void SelectTrayCtrl_Continue( BOXAPP_WORK* wk )
{
	wk->selectTrayWork.seq = 0;
	wk->selectTrayWork.continue_flag = TRUE;
}

//------------------------------------------------------------------
/**
 * gCIC
 *
 * @param   wk		[N|C^
 * @param   seq		֐V[PXioƂėpłϐ̃AhX
 *
 * JnAwk->selectBox ɓio[\{bNXƂB
 * IAIꂽ{bNXio[𓯂 wk->selectBox ɓB
 * aLZꂽ́A萔 SELECT_TRAY_CANCEL B
 */
//------------------------------------------------------------------
static BOOL SelectTrayCtrl_Main( BOXAPP_WORK* wk )
{
	enum {
		SEQ_JUMPWIN_DISP,
		SEQ_MSG_DISP,
		SEQ_MSG_DISP_WAIT,
		SEQ_KEYWAIT,
		SEQ_TRAYCHANGE_RETURN,
		SEQ_RETURN,
	};

	SELECT_TRAY_WORK*  subwk = &(wk->selectTrayWork);

	switch( subwk->seq ){
	case SEQ_JUMPWIN_DISP:
		if( subwk->continue_flag == TRUE )
		{
			subwk->seq = SEQ_MSG_DISP;
			break;
		}

		// 蓾ȂnYꉞ
		if( subwk->trayNumber == SELECT_TRAY_CANCEL ){
			subwk->trayNumber = 0;
		}
		VParaSet_JumpWin( &wk->vpara, subwk->trayNumber );
		BoxAppView_SetCommand( wk->vwk, CMD_JUMPWIN_DISP );
		subwk->seq = SEQ_MSG_DISP;
		break;

	case SEQ_MSG_DISP:
		if( BoxAppView_WaitCommand(wk->vwk, CMD_JUMPWIN_DISP) )
		{
			VParaSet_MessageID( &wk->vpara, subwk->msgID );
			BoxAppView_SetCommand( wk->vwk, CMD_MSG_DISP );
			subwk->seq = SEQ_MSG_DISP_WAIT;
		}
		break;

	case SEQ_MSG_DISP_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_MSG_DISP ) == FALSE )
		{
			break;
		}
		subwk->seq = SEQ_KEYWAIT;

		/* fallthru */

	case SEQ_KEYWAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_JUMPWIN_UPDATE ) == FALSE )
		{
			break;
		}

		if( sys.trg & PAD_KEY_LEFT ){
			subwk->trayNumber--;
			if( subwk->trayNumber < 0 )
			{
				subwk->trayNumber = BOX_MAX_TRAY-1;
			}
			VParaSet_JumpWin( &wk->vpara, subwk->trayNumber );
			BoxAppView_SetCommand( wk->vwk, CMD_JUMPWIN_UPDATE );
			break;
		}
		if( sys.trg & PAD_KEY_RIGHT ){
			if( ++(subwk->trayNumber) >= BOX_MAX_TRAY )
			{
				subwk->trayNumber = 0;
			}
			VParaSet_JumpWin( &wk->vpara, subwk->trayNumber );
			BoxAppView_SetCommand( wk->vwk, CMD_JUMPWIN_UPDATE );
			break;
		}

		if( sys.trg & PAD_BUTTON_A )
		{
			Snd_SePlay( SOUND_DECIDE );
			return TRUE;
		}

		if( sys.trg & PAD_BUTTON_B )
		{
			Snd_SePlay( SOUND_CANCEL );
			subwk->trayNumber = SELECT_TRAY_CANCEL;
			return TRUE;
		}
		break;
	}
	return FALSE;
}

//======================================================================================================
// Tuʑ֘A
//======================================================================================================

static int calc_reelmove_vector( int* next, int now, u32 max )
{
	int diff_fwd, diff_back;

	diff_fwd = (*next) - now;
	if( diff_fwd < 0 ){ diff_fwd += max; }

	diff_back = now - (*next);
	if( diff_back < 0 ){ diff_back += max; }

	if( diff_fwd <= diff_back )
	{
		return diff_fwd;
	}
	else
	{
		return -diff_back;
	}
}



//------------------------------------------------------------------
/**
 * TuLCDł̃gCI[h
 *
 * @param   wk		
 * @param   seq		
 *
 */
//------------------------------------------------------------------
static void SubSeq_TrayMode( BOXAPP_WORK* wk,  u32* seq )
{
	enum {
		SEQ_INIT,
		SEQ_TP_CTRL,
		SEQ_MOVEICON_WAIT,
		SEQ_SCROLL_WAIT,
		SEQ_END,
	};

	switch( *seq ){
	case SEQ_INIT:
		Snd_SePlay( SOUND_SUB_BUTTON );
		VParaSet_SubLCDStae( &wk->vpara, SUBLCD_STATE_TRAY );
		VParaSet_SubLCDPos( &(wk->vpara), BoxAppVPara_GetTrayBoxNumber(&wk->vpara) );
		BoxAppView_SetCommand( wk->vwk, CMD_SUBLCD_MODECHANGE );
		BoxApp_ReelCtrlInit( &(wk->reel), 0, 192, 56, 88 );
		wk->reel_move_flag = FALSE;
		(*seq) = SEQ_TP_CTRL;
		break;

	case SEQ_TP_CTRL:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_SUBLCD_MODECHANGE ) == FALSE){ break; }

		if( CheckButtonPush( wk ) )
		{
			if( wk->btn_id == BUTTONID_RIGHT )
			{
				SubSeqSet( wk, SubSeq_LimitMode );
				break;
			}
		}

		if( sys.trg & SUBLCD_CTRL_ESCAPE_KEYMASK )
		{
			Snd_SePlay( SOUND_DECIDE );
			VParaSet_SubLCDStae( &(wk->vpara), SUBLCD_STATE_NORMAL );
			VParaSet_SubLCDPos( &(wk->vpara), BoxAppVPara_GetTrayBoxNumber(&wk->vpara) );
			BoxAppView_SetCommand( wk->vwk, CMD_SUBLCD_MODECHANGE );
			(*seq) = SEQ_END;
			break;
		}

		if( wk->reel_move_flag )
		{
			if( ++(wk->reel_timer) > 20 )
			{
				u32 pos = BoxAppVPara_GetSubLCDPos( &wk->vpara );
				VParaSet_CurrentTrayNumberSet( &wk->vpara, pos );
				BOXDAT_SetCureentTrayNumber( wk->boxData, pos );
				BoxAppView_SetCommand( wk->vwk, CMD_TRAY_CHANGE );
				wk->reel_move_flag = FALSE;
				(*seq) = SEQ_SCROLL_WAIT;
				break;
			}
		}


		switch(BoxApp_ReelCtrlMain(&wk->reel)){
		case REEL_RESULT_START:
			wk->reel_pos = BoxAppVPara_GetTrayBoxNumber( &wk->vpara );
			wk->reel_move_flag = FALSE;
			break;
		case REEL_RESULT_MOVE:
			{
				int slide, move, pos, nowpos;

				slide = BoxApp_ReelCtrlGetMoveValue( &wk->reel );
				pos = wk->reel_pos;

				pos += slide;
				if( pos < 0 ){
					pos += BOX_MAX_TRAY;
				}else if( pos >= BOX_MAX_TRAY ){
					pos -= BOX_MAX_TRAY;
				}

				move = calc_reelmove_vector( &pos, BoxAppVPara_GetSubLCDPos(&(wk->vpara)), BOX_MAX_TRAY );
				if( move )
				{
					Snd_SePlay( SOUND_SUB_MOVE_ICON );
					VParaSet_SubLCDPos( &(wk->vpara), pos );
					VParaSet_SubLCDMove( &(wk->vpara), move );
					BoxApp_ReelCtrlNotifyMoveStart( &wk->reel );
					BoxAppView_SetCommand( wk->vwk, CMD_SUBLCD_MOVEICON );
					(*seq) = SEQ_MOVEICON_WAIT;
				}
			}
			break;

		default:
			if( wk->reel_move_flag == FALSE )
			{
				if( BoxAppVPara_GetTrayBoxNumber(&wk->vpara) != BoxAppVPara_GetSubLCDPos( &wk->vpara ) )
				{
					wk->reel_move_flag = TRUE;
					wk->reel_timer = 0;
				}
			}
			break;
		}
		break;

	case SEQ_MOVEICON_WAIT:
		BoxApp_ReelCtrlMain(&wk->reel);
		if( BoxAppView_WaitCommand( wk->vwk, CMD_SUBLCD_MOVEICON ) )
		{
			BoxApp_ReelCtrlReset( &wk->reel );
			(*seq) = SEQ_TP_CTRL;
		}
		break;

	case SEQ_SCROLL_WAIT:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_TRAY_CHANGE ) )
		{
			(*seq) = SEQ_TP_CTRL;
		}
		break;

	case SEQ_END:
		if( BoxAppView_WaitCommandAll( wk->vwk ) )
		{
			SubSeqEnd( wk );
		}
		break;
	}

}

//------------------------------------------------------------------
/**
 * TuLCDł̍i荞݃[h
 *
 * @param   wk		
 * @param   seq		
 *
 */
//------------------------------------------------------------------
static void SubSeq_LimitMode( BOXAPP_WORK* wk,  u32* seq )
{
	enum {
		SEQ_INIT,
		SEQ_TP_CTRL,
		SEQ_MOVEICON_WAIT,
		SEQ_END,
	};

	switch( *seq ){
	case SEQ_INIT:
		Snd_SePlay( SOUND_SUB_BUTTON );
		VParaSet_SubLCDStae( &wk->vpara, SUBLCD_STATE_MARK );
		VParaSet_SubLCDLimitPos( &(wk->vpara), 0 );
		BoxAppView_SetCommand( wk->vwk, CMD_SUBLCD_MODECHANGE );
		BoxApp_ReelCtrlInit( &(wk->reel), 255, 192, 56, 88 );
		(*seq) = SEQ_TP_CTRL;
		break;

	case SEQ_TP_CTRL:
		if( BoxAppView_WaitCommand( wk->vwk, CMD_SUBLCD_MODECHANGE ) == FALSE){ break; }

		if( CheckButtonPush( wk ) )
		{
			if( wk->btn_id == BUTTONID_LEFT )
			{
				SubSeqSet( wk, SubSeq_TrayMode);
				break;
			}
		}

		if( sys.trg & SUBLCD_CTRL_ESCAPE_KEYMASK )
		{
			Snd_SePlay( SOUND_DECIDE );
			VParaSet_SubLCDStae( &wk->vpara, SUBLCD_STATE_NORMAL );
			BoxAppView_SetCommand( wk->vwk, CMD_SUBLCD_MODECHANGE );
			(*seq) = SEQ_END;
		}

		if( CheckLimitModeIconTouch( wk ) )
		{
			Snd_SePlay( SOUND_DECIDE );
			BoxAppView_SetCommand( wk->vwk, CMD_SUBLCD_MARKICON_UPDATE );
			BoxAppView_SetCommand( wk->vwk, CMD_ICON_LIMITMODE_UPDATE );
			break;
		}

		switch(BoxApp_ReelCtrlMain(&wk->reel)){
		case REEL_RESULT_START:
			wk->reel_pos = BoxAppVPara_GetSubLCDLimitPos(&(wk->vpara));
			wk->reel_move_flag = FALSE;
			break;
		case REEL_RESULT_MOVE:
			{
				int slide, move, pos;

				slide = BoxApp_ReelCtrlGetMoveValue( &wk->reel );
				pos = wk->reel_pos;

				pos += slide;
				if( pos < 0 ){
					pos += LIMITMODE_ICON_MAX;
				}else if( pos >= LIMITMODE_ICON_MAX ){
					pos -= LIMITMODE_ICON_MAX;
				}

				move = calc_reelmove_vector( &pos, BoxAppVPara_GetSubLCDLimitPos(&(wk->vpara)), LIMITMODE_ICON_MAX );
//				OS_TPrintf("defpos=%d, slide=%d, nowpos=%d, nextpos=%d, move=%d\n", wk->reel_pos, slide, BoxAppVPara_GetSubLCDPos(&(wk->vpara)), pos, move);
				if( move )
				{
					Snd_SePlay( SOUND_SUB_MOVE_ICON );
					VParaSet_SubLCDLimitPos( &(wk->vpara), pos );
					VParaSet_SubLCDMove( &(wk->vpara), move );
					BoxApp_ReelCtrlNotifyMoveStart( &wk->reel );
					BoxAppView_SetCommand( wk->vwk, CMD_SUBLCD_MOVEICON );
					(*seq) = SEQ_MOVEICON_WAIT;
				}
			}
			break;

		default:
			if( wk->reel_move_flag == FALSE )
			{
				if( BoxAppVPara_GetTrayBoxNumber(&wk->vpara) != BoxAppVPara_GetSubLCDPos( &wk->vpara ) )
				{
					wk->reel_move_flag = TRUE;
					wk->reel_timer = 0;
				}
			}
			break;
		}
		break;

	case SEQ_MOVEICON_WAIT:
		BoxApp_ReelCtrlMain(&wk->reel);
		if( BoxAppView_WaitCommand( wk->vwk, CMD_SUBLCD_MOVEICON ) )
		{
			BoxApp_ReelCtrlReset( &wk->reel );
			(*seq) = SEQ_TP_CTRL;
		}
		break;

	case SEQ_END:
		if( BoxAppView_WaitCommandAll( wk->vwk ) )
		{
			SubSeqEnd( wk );
		}
		break;
	}
}

//------------------------------------------------------------------
/**
 * i荞݃[h̃ACR^b`ꂽ`FbN
 *
 * @param   wk			[N|C^
 *
 * @retval  BOOL		TRUEŃ^b`ꂽ
 */
//------------------------------------------------------------------
static BOOL CheckLimitModeIconTouch( BOXAPP_WORK* wk )
{
	wk->touch_icon_id = LIMITMODE_ICON_MAX;

	BMN_Main( wk->icon_bmn );

	if( wk->touch_icon_id != LIMITMODE_ICON_MAX )
	{
		return TRUE;
	}

	return FALSE;
}
static void IconBmnCallBack( u32 btnID, u32 event, void* wk_adrs )
{
	BOXAPP_WORK* wk = (BOXAPP_WORK*)wk_adrs;

	if( wk->touch_icon_id == LIMITMODE_ICON_MAX )
	{
		if( event == BMN_EVENT_TOUCH )
		{
			u32 iconID = BoxAppVPara_GetSubLCDLimitPos( &wk->vpara ) + btnID;
			if( iconID >= LIMITMODE_ICON_MAX )
			{
				iconID -= LIMITMODE_ICON_MAX;
			}

			VParaSet_LimitModeBitFlag( &wk->vpara, iconID );
			
			wk->touch_icon_id = btnID;
		}
	}

}

//==============================================================================================================
//==============================================================================================================


//------------------------------------------------------------------
/**
 * [N\zFC
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void InitWork( BOXAPP_WORK* wk, BOX_PROC_PARAM* proc_param )
{
	wk->boxData = SaveData_GetBoxData( proc_param->savedata );
	wk->saveData = proc_param->savedata;
	wk->partyData = SaveData_GetTemotiPokemon( proc_param->savedata );

	wk->msgman_box = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_boxmes_dat, HEAPID_BOX_SYSTEM );
	wk->msgman_poke = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_monsname_dat, HEAPID_BOX_SYSTEM );
	wk->msgman_poke_character = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_chr_dat, HEAPID_BOX_SYSTEM );
	wk->msgman_speabi = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_tokusei_dat, HEAPID_BOX_SYSTEM );
	wk->wordset = WORDSET_Create(HEAPID_BOX_SYSTEM);
	wk->partyPokeWork = sys_AllocMemory( HEAPID_BOX_SYSTEM, PokemonParam_GetWorkSize() );
	GF_ASSERT(wk->wordset);

	wk->nameinParam = NameIn_ParamAllocMake( HEAPID_BOX_SYSTEM, NAMEIN_BOX, 0, BOX_TRAYNAME_MAXLEN );
	wk->bmn = BMN_Create( ButtonHitTbl, NELEMS(ButtonHitTbl), BmnCallBack, wk, HEAPID_BOX_SYSTEM );
	wk->icon_bmn = BMN_Create( IconHitTbl, NELEMS(IconHitTbl), IconBmnCallBack, wk, HEAPID_BOX_SYSTEM );

	wk->vpara.boxData = wk->boxData;
	wk->vpara.partyData = wk->partyData;

	wk->vpara.azukeruTrayNumber = 0;

	InitWork_system( &(wk->vpara.system), proc_param->mode );
	InitWork_statusPoke( &(wk->vpara.statusPoke) );
	InitWork_tray( wk->boxData, &(wk->vpara.tray) );

	InitWork_cursor( wk );
	InitWork_catchpoke( &(wk->vpara.catchPoke) );
	InitWork_SubLCD( &(wk->vpara.subLCD) );

}

//------------------------------------------------------------------
/**
 * [Nj
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void DeleteWork( BOXAPP_WORK* wk )
{
	BMN_Delete( wk->icon_bmn );
	BMN_Delete( wk->bmn );

	if(wk->partyPokeWork)
	{
		sys_FreeMemoryEz(wk->partyPokeWork);
	}
	WORDSET_Delete( wk->wordset );
	MSGMAN_Delete( wk->msgman_box );
	MSGMAN_Delete( wk->msgman_poke );
	MSGMAN_Delete( wk->msgman_poke_character );
	MSGMAN_Delete( wk->msgman_speabi );

	NameIn_ParamDelete( wk->nameinParam );

	DeleteWork_statusPoke( &(wk->vpara.statusPoke) );
	DeleteWork_catchpoke( &(wk->vpara.catchPoke) );
	DeleteWork_tray( &(wk->vpara.tray) );

	sys_FreeMemoryEz( wk );

}

//------------------------------------------------------------------
/**
 * [NFVXef[^
 *
 * @param   system		
 *
 */
//------------------------------------------------------------------
static void InitWork_system( BOXAPP_SYSTEM* system, int mode )
{
	system->boxMode = mode;				// {bNX샂[hiEĂEEǂj
	system->expertModeFlag = FALSE;		// Ăl[htO
	system->limitModeBitFlag = 0;		// i荞݃[hrbgtO
}
//------------------------------------------------------------------
/**
 * [NFJ[\f[^
 *
 * @param   system		
 * @param   cursor		
 *
 */
//------------------------------------------------------------------
static void InitWork_cursor( BOXAPP_WORK* wk )
{
	BOXAPP_VPARAM* vpara = &(wk->vpara);
	BOXAPP_CURSOR* cursor = &(vpara->cursor);

	VParaSet_CursorTrayPos( vpara, 0, 0 );

	cursor->partytray_pos = 0;
	cursor->partytray_prev_pos = 0;
	cursor->partytray_prev_area = CURSOR_AREA_PARTY;

	if( vpara->system.boxMode != BOX_MODE_AZUKERU ){
		cursor->area = CURSOR_AREA_TRAY;
	}else{
		cursor->area = CURSOR_AREA_PARTY;
	}
	

	cursor->poke_catch_flag = CURSOR_CATCH_NONE;

	CursorPointPokeUpdate( wk );
}
//------------------------------------------------------------------
/**
 * [NFړ|Pf[^
 *
 * @param   catchPoke		
 */
//------------------------------------------------------------------
static void InitWork_catchpoke( BOXAPP_CATCH_POKE* catchPoke )
{
	catchPoke->ppp = sys_AllocMemory( HEAPID_BOX_SYSTEM, BOX_MAX_POS * PokemonPasoParamSizeGet() );
	catchPoke->areaPokeCount = 0;
}
//------------------------------------------------------------------
/**
 * [N폜Fړ|Pf[^
 *
 * @param   catchPoke		
 *
 */
//------------------------------------------------------------------
static void DeleteWork_catchpoke( BOXAPP_CATCH_POKE* catchPoke )
{
	sys_FreeMemoryEz( catchPoke->ppp );
}


//------------------------------------------------------------------
/**
 * [NFgCf[^
 *
 * @param   box		
 * @param   tray		
 */
//------------------------------------------------------------------
static void InitWork_tray( BOX_DATA* box, BOXAPP_TRAY* tray )
{
	tray->number = BOXDAT_GetCureentTrayNumber( box );
	tray->name = STRBUF_Create(BOX_TRAYNAME_BUFSIZE, HEAPID_BOX_SYSTEM);
	SetTrayStatus( box, tray );
}
//------------------------------------------------------------------
/**
 * [N폜FgCf[^
 *
 * @param   tray		
 *
 */
//------------------------------------------------------------------
static void DeleteWork_tray( BOXAPP_TRAY* tray )
{
	STRBUF_Delete( tray->name );
}



//------------------------------------------------------------------
/**
 * [NFXe[^X\|Pp[N
 *
 * @param   statusPoke		
 *
 */
//------------------------------------------------------------------
static void InitWork_statusPoke( BOXAPP_STATUS_POKE* statusPoke )
{
	statusPoke->nickname = STRBUF_Create( BUFLEN_POKEMON_NAME, HEAPID_BOX_SYSTEM );
	statusPoke->monsname = STRBUF_Create( BUFLEN_POKEMON_NAME, HEAPID_BOX_SYSTEM );
	statusPoke->itemname = STRBUF_Create( BUFLEN_ITEM_NAME, HEAPID_BOX_SYSTEM );
	statusPoke->character = STRBUF_Create( BUFLEN_POKEMON_CHARACTER_NAME, HEAPID_BOX_SYSTEM );
	statusPoke->ability = STRBUF_Create( BUFLEN_POKEMON_ABILITY_NAME, HEAPID_BOX_SYSTEM );
}
//------------------------------------------------------------------
/**
 * [N폜FXe[^X\|Pp[N
 *
 * @param   statusPoke		
 *
 */
//------------------------------------------------------------------
static void DeleteWork_statusPoke( BOXAPP_STATUS_POKE* statusPoke )
{
	STRBUF_Delete(statusPoke->nickname);
	STRBUF_Delete(statusPoke->monsname);
	STRBUF_Delete(statusPoke->itemname);
	STRBUF_Delete(statusPoke->character);
	STRBUF_Delete(statusPoke->ability);
}




//------------------------------------------------------------------
/**
 * [NFTuLCD
 *
 * @param   sub		
 *
 */
//------------------------------------------------------------------
static void InitWork_SubLCD( BOXAPP_SUBLCD* sub )
{
	sub->state = SUBLCD_STATE_NORMAL;
	sub->pos = 0;
	sub->limit_pos = 0;
	sub->move = 0;
}
//------------------------------------------------------------------
/**
 * gC֘A`p[^XV
 *
 * @param   box		
 * @param   tray		
 *
 */
//------------------------------------------------------------------
static void SetTrayStatus( const BOX_DATA* box, BOXAPP_TRAY* tray )
{
	tray->wallPaper = BOXDAT_GetWallPaperNumber( box, tray->number );
	BOXDAT_GetBoxName( box, tray->number, tray->name );
}
//------------------------------------------------------------------
/**
 * Jg̕ǎio[XV
 *
 * @param   vpara		
 * @param   box			
 *
 */
//------------------------------------------------------------------
static void TrayCurrentWallPaperUpdate( BOXAPP_VPARAM* vpara, BOX_DATA* box )
{
	BOXAPP_TRAY*  tray = &(vpara->tray);
	tray->wallPaper = BOXDAT_GetWallPaperNumber( box, tray->number );
}



//------------------------------------------------------------------
/**
 * J[\ړ`FbN
 *
 * @param   wk		
 *
 * @retval  BOOL		TRUEňړ
 */
//------------------------------------------------------------------
static BOOL CursorMoveCheck( u32 keyflag, BOXAPP_WORK* wk )
{
	BOOL ret = FALSE;

	do{
		if( keyflag & PAD_KEY_LEFT )
		{
			ret = CursorPosMove( &(wk->vpara), -1,  0 );
			break;
		}

		if( keyflag & PAD_KEY_RIGHT )
		{
			ret = CursorPosMove( &(wk->vpara),  1,  0 );
			break;
		}

		if( keyflag & PAD_KEY_UP )
		{
			ret =  CursorPosMove( &(wk->vpara),  0, -1 );
			break;
		}

		if( keyflag & PAD_KEY_DOWN )
		{
			ret = CursorPosMove( &(wk->vpara),  0,  1 );
			break;
		}

	}while(0);

	if( ret == TRUE )
	{
		CursorPointPokeUpdate( wk );
	}

	return ret;
}

//------------------------------------------------------------------
/**
 * J[\ړf[^
 *
 * @param   vpara		
 * @param   x		wړ
 * @param   y		xړ
 *
 * @retval  BOOL		TRUEňړ
 */
//------------------------------------------------------------------
static BOOL CursorPosMove( BOXAPP_VPARAM* vpara, int x, int y )
{
	#define DecideButtonArea(x)	(((x) == (BOX_MAX_COLUMN-1))? CURSOR_AREA_EXIT_BUTTON : CURSOR_AREA_PARTY_BUTTON);

	BOXAPP_CURSOR* cursor = &vpara->cursor;

	switch( cursor->area ){
	case CURSOR_AREA_TRAY:
		if( x != 0)
		{
			int  xpos = cursor->tray_xpos += x;

			if( xpos < 0 )
			{
				xpos = BOX_MAX_COLUMN - 1;
			}
			else if( xpos >= BOX_MAX_COLUMN )
			{
				xpos = 0;
			}
			VParaSet_CursorTrayPos( vpara, xpos, cursor->tray_ypos );

			return TRUE;
		}
		if( y != 0)
		{
			int ypos = cursor->tray_ypos + y;
			if( ypos < 0 )
			{
				ypos = 0;
				cursor->area = CURSOR_AREA_TRAY_TAB;
			}
			else if( ypos > TRAY_YPOS_MAX )
			{
				ypos = TRAY_YPOS_MAX;
				cursor->area = DecideButtonArea( cursor->tray_xpos );
			}
			VParaSet_CursorTrayPos( vpara, cursor->tray_xpos, ypos );
			return TRUE;
		}
		break;

	case CURSOR_AREA_TRAY_TAB:
		if( y > 0 )
		{
			cursor->area = CURSOR_AREA_TRAY;
			VParaSet_CursorTrayPos( vpara, cursor->tray_xpos, 0 );
			return TRUE;
		}
		if( y < 0 )
		{
			cursor->area = DecideButtonArea( cursor->tray_xpos );
			return TRUE;
		}
		break;

	case CURSOR_AREA_EXIT_BUTTON:
		if( y < 0 )
		{
			cursor->area = CURSOR_AREA_TRAY;
			VParaSet_CursorTrayPos( vpara, cursor->tray_xpos, TRAY_YPOS_MAX );
			return TRUE;
		}
		if( y > 0 )
		{
			cursor->area = CURSOR_AREA_TRAY_TAB;
			return TRUE;
		}
		if( x != 0)
		{
			cursor->area = CURSOR_AREA_PARTY_BUTTON;
			return TRUE;
		}
		break;

	case CURSOR_AREA_PARTY_BUTTON:
		if( y < 0 )
		{
			cursor->area = CURSOR_AREA_TRAY;
			VParaSet_CursorTrayPos( vpara, cursor->tray_xpos, TRAY_YPOS_MAX );
			return TRUE;
		}
		if( y > 0 )
		{
			cursor->area = CURSOR_AREA_TRAY_TAB;
			return TRUE;
		}
		if( x != 0)
		{
			cursor->area = CURSOR_AREA_EXIT_BUTTON;
			return TRUE;
		}
		break;

	case CURSOR_AREA_PARTY:
		{
			u32  before_pos = cursor->partytray_pos;

			if( y < 0 )
			{
				if(--(cursor->partytray_pos) < 0 )
				{
					cursor->partytray_pos = CURSOR_PARTYTRAY_CLOSEBUTTON_POS;
				}
			}
			if( y > 0 )
			{
				if(++(cursor->partytray_pos) > CURSOR_PARTYTRAY_CLOSEBUTTON_POS )
				{
					cursor->partytray_pos = 0;
				}
			}
			if( before_pos != cursor->partytray_pos )
			{
				cursor->partytray_prev_pos = before_pos;
				return TRUE;
			}
			break;
		}
		break;
	}
	return FALSE;

	#undef DecideButtonArea
}
//------------------------------------------------------------------
/**
 * ͈͑ĨJ[\ړ`FbN
 *
 * @param   wk		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int CursorMoveCheck_AreaSelect( u32 keyflag, BOXAPP_WORK* wk )
{
	int ret = AREASELECT_RESULT_NONE;

	do{
		if( keyflag & PAD_KEY_LEFT )
		{
			ret = CursorPosMove_AreaSelect( &(wk->vpara), -1,  0 );
			break;
		}

		if( keyflag & PAD_KEY_RIGHT )
		{
			ret = CursorPosMove_AreaSelect( &(wk->vpara),  1,  0 );
			break;
		}

		if( keyflag & PAD_KEY_UP )
		{
			ret =  CursorPosMove_AreaSelect( &(wk->vpara),  0, -1 );
			break;
		}

		if( keyflag & PAD_KEY_DOWN )
		{
			ret = CursorPosMove_AreaSelect( &(wk->vpara),  0,  1 );
			break;
		}

	}while(0);

	if( ret == AREASELECT_RESULT_UPDATE )
	{
		CursorPointPokeUpdate( wk );
	}

	return ret;
}
//------------------------------------------------------------------
/**
 * ͈͑I𒆂̃J[\ړf[^
 *
 * @param   vpara		
 * @param   x		wړ
 * @param   y		xړ
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int CursorPosMove_AreaSelect( BOXAPP_VPARAM* vpara, int x, int y )
{
	BOXAPP_CURSOR* cursor = &vpara->cursor;
	const BOXAPP_CATCH_POKE* catchPoke = &vpara->catchPoke;

	if( cursor->area == CURSOR_AREA_TRAY )
	{
		if( x != 0 )
		{
			int  xpos = cursor->tray_xpos + x;

			if( BoxAppVPara_GetCursorCatchPokeFlag(vpara) & CURSOR_CATCH_AREA_MASK )
			{
				int l_border, r_border;

				l_border = r_border = xpos;
				if(catchPoke->areaEndX > catchPoke->areaStartX){
					l_border -= (catchPoke->areaEndX - catchPoke->areaStartX);
				}else{
					r_border += (catchPoke->areaStartX - catchPoke->areaEndX);
				}

				if( l_border < 0 )
				{
					return AREASELECT_RESULT_SCROLL_LEFT;
				}
				if( r_border >= BOX_MAX_COLUMN )
				{
					return AREASELECT_RESULT_SCROLL_RIGHT;
				}
			}
			else
			{
				if( (xpos < 0) || (xpos >= BOX_MAX_COLUMN) )
				{
					return AREASELECT_RESULT_OVER;
				}
			}

			VParaSet_CursorTrayPos( vpara, xpos, cursor->tray_ypos );
			return AREASELECT_RESULT_UPDATE;
		}

		if( y != 0)
		{
			int ypos;

			ypos = cursor->tray_ypos + y;

			if( BoxAppVPara_GetCursorCatchPokeFlag(vpara) & CURSOR_CATCH_AREA_MASK )
			{
				int t_border, b_border;

				t_border = b_border = ypos;
				if(catchPoke->areaEndY > catchPoke->areaStartY){
					t_border -= (catchPoke->areaEndY - catchPoke->areaStartY);
				}else{
					b_border += (catchPoke->areaStartY - catchPoke->areaEndY);
				}

				if((t_border < 0)||(b_border >= BOX_MAX_RAW))
				{
					return AREASELECT_RESULT_OVER;
				}
			}
			else
			{
				if( (ypos < 0) || (ypos >= BOX_MAX_RAW ) )
				{
					return AREASELECT_RESULT_OVER;
				}
			}

			VParaSet_CursorTrayPos( vpara, cursor->tray_xpos, ypos );
			return AREASELECT_RESULT_UPDATE;
		}
	}

	GF_ASSERT(0);
	return AREASELECT_RESULT_NONE;
}

//------------------------------------------------------------------
/**
 * 莝|P{^̈ړp[^Zbg
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void CursorPosSetForPartyBoxButtonOpen( BOXAPP_WORK* wk )
{
	BOXAPP_VPARAM* vpara = &wk->vpara;
	BOXAPP_CURSOR* cursor = &vpara->cursor;
	u32 cnt;

	// |PłȂ󂫃Xy[X
	if( BoxAppVPara_GetCursorCatchPokeFlag( vpara ) == CURSOR_CATCH_SINGLE )
	{
		cursor->partytray_pos = PokeParty_GetPokeCount( wk->partyData );

		// 󂫂΍Ō
		if( cursor->partytray_pos >= TEMOTI_POKEMAX )
		{
			cursor->partytray_pos = TEMOTI_POKEMAX - 1;
		}
	}
	// łȂȂ擪
	else
	{
		cursor->partytray_pos = 0;
	}

	cursor->partytray_prev_area = cursor->area;
	cursor->partytray_prev_pos = 0;

	cursor->area = CURSOR_AREA_PARTY;

	CursorPointPokeUpdate( wk );
}
//------------------------------------------------------------------
/**
 * 莝|PgC甲鎞̈ړp[^Zbg
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void CursorPosSetForPartyBoxButtonClose( BOXAPP_WORK* wk )
{
	BOXAPP_CURSOR* cursor = &(wk->vpara.cursor);
	cursor->area = cursor->partytray_prev_area;
	CursorPointPokeUpdate( wk );
}

//------------------------------------------------------------------
/**
 * J[\݈ʒuŃXe[^XXV
 *
 * @param   vpara		
 *
 */
//------------------------------------------------------------------
static void CursorPointPokeUpdate( BOXAPP_WORK* wk )
{
	BOXAPP_VPARAM* vpara = &wk->vpara;
	BOXAPP_STATUS_POKE* stpoke = &vpara->statusPoke;
	BOXAPP_CURSOR* cursor = &vpara->cursor;
	u32 monsno;

	cursor->poke_point_flag = FALSE;

	switch( cursor->area ){
	case CURSOR_AREA_TRAY:
		cursor->point_poke = BOXDAT_GetPokeDataAddress( vpara->boxData, 
											BOXDAT_TRAYNUM_CURRENT, cursor->tray_pos );
		break;

	case CURSOR_AREA_PARTY:
		if( cursor->partytray_pos < PokeParty_GetPokeCount( wk->partyData ) )
		{
			cursor->point_poke = PokeParty_GetMemberPointer( wk->partyData, cursor->partytray_pos );
		}
		else
		{
			cursor->point_poke = NULL;
		}
		break;

	case CURSOR_AREA_TRAY_TAB:
	case CURSOR_AREA_EXIT_BUTTON:
	case CURSOR_AREA_PARTY_BUTTON:
	default:
		cursor->point_poke = NULL;
		break;
	}



	if( cursor->point_poke )
	{
		if( PokePasoParaGet( cursor->point_poke, ID_PARA_poke_exist, NULL ) )
		{
			cursor->poke_point_flag = TRUE;
			if( !(BoxAppVPara_GetCursorCatchPokeFlag(vpara) & CUROSR_CATCH_STATUS_HOLD_MASK) )
			{
				VParaSet_StatusPoke( vpara, cursor->point_poke, wk );
			}
		}
	}

}
/*============================================================================================*/
/*  ^b`pl`FbN                                                                  */
/*============================================================================================*/

//------------------------------------------------------------------
/**
 * {^ꂽ`FbN
 *
 * @param   wk		[N|C^
 *
 * @retval  u32		ꂽ{^IDiĂȂ BUTTONID_NONE j
 */
//------------------------------------------------------------------
static BOOL CheckButtonPush( BOXAPP_WORK* wk )
{
	wk->btn_id = BUTTONID_NONE;

	BMN_Main( wk->bmn );

	return  ( wk->btn_id != BUTTONID_NONE );
}

//------------------------------------------------------------------
/**
 * {^Ǘ}l[W̃R[obN
 *
 * @param   btnID		{^ID
 * @param   event		{^Cxg
 * @param   wk_adrs		[NAhX
 *
 */
//------------------------------------------------------------------
static void BmnCallBack( u32 btnID, u32 event, void* wk_adrs )
{
	BOXAPP_WORK* wk = (BOXAPP_WORK*)wk_adrs;

	if( ( event == BMN_EVENT_TOUCH )
	&&	( wk->btn_id == BUTTONID_NONE) 
	){
		wk->btn_id = btnID;
	}
}

/*====================================================================================*/
/*  `p[^Zbg                                                          */
/*====================================================================================*/
static void VParaSet_MessageID( BOXAPP_VPARAM* vpara, u32 msgID )
{
	vpara->message_id = msgID;
}

//------------------------------------------------------------------
/**
 * gCJ[\ʒuZbg
 *
 * @param   vpara		
 * @param   x		
 * @param   y		
 *
 */
//------------------------------------------------------------------
static void VParaSet_CursorTrayPos( BOXAPP_VPARAM* vpara, u32 x, u32 y )
{
	BOXAPP_CURSOR* cursor = &vpara->cursor;

	cursor->tray_xpos = x;
	cursor->tray_ypos = y;
	cursor->tray_pos = y * BOX_MAX_COLUMN + x;
}
//------------------------------------------------------------------
/**
 * J[\̉ɂ|PP̂A͂ݒ|Pf[^ɂB
 * 񂾃|Pf[^̓NAB
 *
 * @param   vpara		
 */
//------------------------------------------------------------------
static void VParaSet_PokeCatch( BOXAPP_WORK* wk, BOXAPP_VPARAM* vpara )
{
	BOXAPP_CATCH_POKE* catchPoke = &vpara->catchPoke;
	BOXAPP_CURSOR* cursor = &vpara->cursor;

	MI_CpuCopy32( cursor->point_poke, catchPoke->ppp, PokemonPasoParamSizeGet() );
	if( BoxAppVPara_GetCursorArea( vpara ) == CURSOR_AREA_TRAY )
	{
		BOXDAT_ClearPokemon( wk->boxData, BOXDAT_TRAYNUM_CURRENT, cursor->tray_pos );
	}
	else
	{
		PokeParty_Delete( wk->partyData, cursor->partytray_pos );
	}
	VParaSet_StatusPokeData( vpara, catchPoke->ppp );

	catchPoke->areaStartX = catchPoke->areaEndX = cursor->tray_xpos;
	catchPoke->areaStartY = catchPoke->areaEndY = cursor->tray_ypos;

	vpara->cursor.poke_catch_flag = CURSOR_CATCH_SINGLE;
	vpara->cursor.poke_point_flag = FALSE;
}
//------------------------------------------------------------------
/**
 * ͈͑I𒆃|PA͂ݒ|Pf[^ɂB
 * 񂾃|Pf[^̓NAB
 *
 * @param   wk		
 * @param   vpara		
 *
 */
//------------------------------------------------------------------
static void VParaSet_AreaSelectPokeCatch( BOXAPP_WORK* wk, BOXAPP_VPARAM* vpara )
{
	u32  x, y, left, right, top, bottom, pos, cursor_pos, idx, ppp_size;
	POKEMON_PASO_PARAM* ppp;
	BOXAPP_CATCH_POKE* catchPoke;
	void* dstp;

	catchPoke = &vpara->catchPoke;

	catchPoke->areaSpaceCatchFlag = TRUE;
	cursor_pos = BoxAppVPara_GetCursorTrayPos(vpara);

	ppp_size = PokemonPasoParamSizeGet();
	idx = 0;
	dstp = (void*)(catchPoke->ppp);
	BoxAppVPara_GetAreaSelectParam( vpara, &left, &right, &top, &bottom );
	for(y=top; y<=bottom; y++)
	{
		pos = y*BOX_MAX_COLUMN + left;
		for(x=left; x<=right; x++)
		{
			ppp = BOXDAT_GetPokeDataAddress(wk->boxData, BOXDAT_TRAYNUM_CURRENT, pos);
			if( PokePasoParaGet( ppp, ID_PARA_poke_exist, NULL ) )
			{
				MI_CpuCopy32( ppp, dstp, ppp_size );
				BOXDAT_ClearPokemon( wk->boxData, BOXDAT_TRAYNUM_CURRENT, pos );
				(u8*)dstp += ppp_size;
				catchPoke->areaPokePos[idx++] = pos;
				if(pos == cursor_pos)
				{
					catchPoke->areaSpaceCatchFlag = FALSE;
				}
			}
			pos++;
		}
	}

	catchPoke->areaPokeCount = idx;
	catchPoke->areaTopPos = top*BOX_MAX_COLUMN+left;

//areaSpaceCatchFlag
	vpara->cursor.poke_catch_flag = (vpara->cursor.poke_point_flag)? CURSOR_CATCH_AREA_POINT : CURSOR_CATCH_AREA_FREE;
	vpara->cursor.poke_point_flag = FALSE;
}


//------------------------------------------------------------------
/**
 * ACR͈͑Ip[^Zbg
 *
 * @param   wk			
 * @param   vpara		
 *
 */
//------------------------------------------------------------------
static void VParaSet_StartAreaSelect( BOXAPP_WORK* wk, BOXAPP_VPARAM* vpara )
{
	BOXAPP_CATCH_POKE* catchPoke = &vpara->catchPoke;
	BOXAPP_CURSOR* cursor = &vpara->cursor;

	catchPoke->areaStartX = catchPoke->areaEndX = cursor->tray_xpos;
	catchPoke->areaStartY = catchPoke->areaEndY = cursor->tray_ypos;
}

//------------------------------------------------------------------
/**
 * ACR͈͑Ip[^XV
 *
 * @param   wk		
 * @param   vpara		
 *
 */
//------------------------------------------------------------------
static void VParaSet_UpdateAreaSelect( BOXAPP_WORK* wk, BOXAPP_VPARAM* vpara )
{
	BOXAPP_CATCH_POKE* catchPoke = &vpara->catchPoke;
	BOXAPP_CURSOR* cursor = &vpara->cursor;

	catchPoke->areaEndX = cursor->tray_xpos;
	catchPoke->areaEndY = cursor->tray_ypos;
}

//------------------------------------------------------------------
/**
 * ł|PP̂AJ[\ʒuɒuB
 * ł|Pf[^̓NAB
 *
 * @param   vpara		
 *
 */
//------------------------------------------------------------------
static void VParaSet_PokePut( BOXAPP_WORK* wk, BOXAPP_VPARAM* vpara )
{
	BOXAPP_CATCH_POKE* catchPoke = &vpara->catchPoke;
	BOXAPP_CURSOR* cursor = &vpara->cursor;
	POKEMON_PASO_PARAM* ppp;

	if( BoxAppVPara_GetCursorArea( vpara ) == CURSOR_AREA_TRAY )
	{
		BOXDAT_PutPokemonPos( wk->boxData, BOXDAT_TRAYNUM_CURRENT, cursor->tray_pos, catchPoke->ppp );
		ppp = BOXDAT_GetPokeDataAddress( wk->boxData, BOXDAT_TRAYNUM_CURRENT, cursor->tray_pos );
	}
	else
	{
		PokeReplace( catchPoke->ppp, wk->partyPokeWork );
		PokeParty_Add( wk->partyData, wk->partyPokeWork );
		ppp = catchPoke->ppp;
	}

	VParaSet_StatusPokeData( vpara, ppp );
	CursorPointPokeUpdate( wk );

	vpara->cursor.poke_catch_flag = CURSOR_CATCH_NONE;
	vpara->cursor.poke_point_flag = TRUE;
}
//------------------------------------------------------------------
/**
 * ͈͑Iłł|Pf[^AJ[\ʒuɒuB
 * ł|Pf[^̓NAB
 *
 * @param   vpara		
 *
 */
//------------------------------------------------------------------
static void VParaSet_AreaSelectPokePut( BOXAPP_WORK* wk, BOXAPP_VPARAM* vpara )
{
	POKEMON_PASO_PARAM* ppp;
	int i, catch_top_pos, put_top_pos, put_pos, ppp_size;
	BOXAPP_CURSOR* cursor = &vpara->cursor;
	BOXAPP_CATCH_POKE* catchPoke = &vpara->catchPoke;

	put_top_pos = BoxAppVPara_GetAreaSelectCursorTopPos(vpara);
	catch_top_pos = catchPoke->areaTopPos;

	ppp_size = PokemonPasoParamSizeGet();
	ppp = catchPoke->ppp;
	for(i=0; i<catchPoke->areaPokeCount; i++)
	{
		put_pos = put_top_pos + (catchPoke->areaPokePos[i]-catch_top_pos);

		BOXDAT_PutPokemonPos( wk->boxData, BOXDAT_TRAYNUM_CURRENT, put_pos, ppp );

		(u8*)ppp += ppp_size;
	}

	VParaSet_StatusPokeData(vpara,
		BOXDAT_GetPokeDataAddress(wk->boxData, BOXDAT_TRAYNUM_CURRENT, BoxAppVPara_GetCursorTrayPos(vpara)));
	CursorPointPokeUpdate( wk );

	catchPoke->areaPokeCount = 0;

//	vpara->cursor.poke_point_flag = PokePasoParaGet( cursor->point_poke, ID_PARA_poke_exist, NULL );
	vpara->cursor.poke_point_flag = (vpara->cursor.poke_catch_flag==CURSOR_CATCH_AREA_POINT);
	vpara->cursor.poke_catch_flag = CURSOR_CATCH_NONE;

}
//------------------------------------------------------------------
/**
 * ł|PƃJ[\ʒũ|P̃f[^ւ
 *
 * @param   vpara		
 *
 */
//------------------------------------------------------------------
static void VParaSet_PokeChange( BOXAPP_WORK* wk, BOXAPP_VPARAM* vpara)
{
	u32  pppsize;
	void* tmpbuf;
	BOXAPP_CATCH_POKE* catchPoke;
	BOXAPP_CURSOR* cursor;

	catchPoke = &vpara->catchPoke;
	pppsize = PokemonParamSizeGet();
	tmpbuf = (u8*)(catchPoke->ppp) + pppsize;
	cursor = &vpara->cursor;

	MI_CpuCopy32( catchPoke->ppp, tmpbuf, pppsize );
	MI_CpuCopy32( cursor->point_poke, catchPoke->ppp, pppsize );

	if( BoxAppVPara_GetCursorArea( vpara ) == CURSOR_AREA_TRAY )
	{
		BOXDAT_PutPokemonPos( wk->boxData, BOXDAT_TRAYNUM_CURRENT, cursor->tray_pos, tmpbuf );
	}
	else
	{
		PokeReplace( tmpbuf, wk->partyPokeWork );
		PokeParty_SetMemberData( wk->partyData, cursor->partytray_pos, wk->partyPokeWork );
	}

	VParaSet_StatusPoke( vpara, catchPoke->ppp, wk );
}
//------------------------------------------------------------------
/**
 * ł|P{bNXɗa
 *
 * @param   wk		[N|C^
 *
 * @retval  BOOL	TRUEŐ
 */
//------------------------------------------------------------------
static BOOL VParaSet_CatchPokeAzuke( BOXAPP_WORK* wk, u32 trayNum )
{
	BOXAPP_VPARAM* vpara;
	BOXAPP_CURSOR* cursor;
	BOXAPP_CATCH_POKE* catchPoke;

	vpara = &(wk->vpara);
	cursor = &vpara->cursor;
	catchPoke = &vpara->catchPoke;

	if( BOXDAT_PutPokemonBox( wk->boxData, trayNum, catchPoke->ppp ) )
	{
		vpara->cursor.poke_catch_flag = CURSOR_CATCH_NONE;
		CursorPointPokeUpdate( wk );
		return TRUE;
	}
	return FALSE;
}
//------------------------------------------------------------------
/**
 * wĂ|P{bNXɗa
 *
 * @param   wk		[N|C^
 *
 * @retval  BOOL	TRUEŐ
 */
//------------------------------------------------------------------
static BOOL VParaSet_PointPokeAzuke( BOXAPP_WORK* wk, u32 trayNum )
{
	BOXAPP_VPARAM* vpara;
	BOXAPP_CURSOR* cursor;

	vpara = &(wk->vpara);
	cursor = &vpara->cursor;

	if( BOXDAT_PutPokemonBox( wk->boxData, trayNum, cursor->point_poke ) )
	{
		PokeParty_Delete( wk->partyData, cursor->partytray_pos );
		CursorPointPokeUpdate( wk );
		return TRUE;
	}
	return FALSE;
}
//------------------------------------------------------------------
/**
 * ł|Pf[^폜ij
 *
 * @param   wk		[N|C^
 */
//------------------------------------------------------------------
static void VParaSet_CatchPokeNigasu( BOXAPP_WORK* wk )
{
	BOXAPP_VPARAM* vpara;
	BOXAPP_CURSOR* cursor;
	BOXAPP_CATCH_POKE* catchPoke;

	vpara = &(wk->vpara);
	cursor = &vpara->cursor;
	catchPoke = &vpara->catchPoke;

	PokePasoParaInit(catchPoke->ppp);
	cursor->poke_catch_flag = CURSOR_CATCH_NONE;

	CursorPointPokeUpdate( wk );
}
//------------------------------------------------------------------
/**
 * wĂ|Pf[^폜ij
 *
 * @param   wk		[N|C^
 */
//------------------------------------------------------------------
static void VParaSet_PointPokeNigasu( BOXAPP_WORK* wk )
{
	BOXAPP_VPARAM* vpara = &(wk->vpara);
	BOXAPP_CURSOR* cursor = &vpara->cursor;

	if( BoxAppVPara_GetCursorArea( vpara ) == CURSOR_AREA_TRAY )
	{
		BOXDAT_ClearPokemon( wk->boxData, BOXDAT_TRAYNUM_CURRENT, cursor->tray_pos );
	}
	else
	{
		PokeParty_Delete( wk->partyData, cursor->partytray_pos );
	}
	CursorPointPokeUpdate( wk );
}
//------------------------------------------------------------------
/**
 * Xe[^X\p|P̏ԍXV
 *
 * @param   vpara		
 * @param   ppp			
 * @param   wk			
 *
 */
//------------------------------------------------------------------
static void VParaSet_StatusPoke( BOXAPP_VPARAM* vpara, POKEMON_PASO_PARAM* ppp, BOXAPP_WORK* wk )
{
	extern PokePasoLevelCalc( POKEMON_PASO_PARAM* );

	BOXAPP_STATUS_POKE* stpoke = &(vpara->statusPoke);

	stpoke->poke_data = ppp;
	stpoke->monsno = PokePasoParaGet( ppp, ID_PARA_monsno, NULL );
	stpoke->itemno = PokePasoParaGet( ppp, ID_PARA_item, NULL );
	stpoke->level = PokePasoLevelCalc( ppp );
	stpoke->mark = PokePasoParaGet( ppp, ID_PARA_mark, NULL );
	stpoke->type1 = PokePersonalParaGet( stpoke->monsno, ID_PER_type1 );
	stpoke->type2 = PokePersonalParaGet( stpoke->monsno, ID_PER_type2 );
	stpoke->sex = PokePasoSexGet(ppp);

	PokePasoParaGet( ppp, ID_PARA_nickname_buf, stpoke->nickname );
	MSGMAN_GetString( wk->msgman_poke, stpoke->monsno, stpoke->monsname );

	if( stpoke->itemno != ITEM_DUMMY_ID )
	{
		GetItemName( stpoke->itemname, stpoke->itemno, HEAPID_BOX_SYSTEM );
	}
	else
	{
		MSGMAN_GetString( wk->msgman_box, msg_boxmes_01_21, stpoke->itemname );
	}

	{
		u32 num = PokePasoSeikakuGet( ppp );
		MSGMAN_GetString( wk->msgman_poke_character, num, stpoke->character );

		num = PokePasoParaGet( ppp, ID_PARA_speabino, NULL );
		MSGMAN_GetString( wk->msgman_speabi, num, stpoke->ability );
	}
}
//------------------------------------------------------------------
/**
 * Xe[^X\p|Pްڽ̂݃Zbg
 *
 * @param   vpara		
 * @param   ppp		
 *
 */
//------------------------------------------------------------------
static void VParaSet_StatusPokeData( BOXAPP_VPARAM* vpara, POKEMON_PASO_PARAM* ppp )
{
	vpara->statusPoke.poke_data = ppp;
}
//------------------------------------------------------------------
/**
 * Xe[^X\p|P̃}[LOԂ̂݃ZbgȂ
 * }[LOԂ̓j[p[NQ
 *
 * @param   vpara		
 *
 */
//------------------------------------------------------------------
static void VParaSet_StatusPokeMark( BOXAPP_VPARAM* vpara )
{
	BOXAPP_STATUS_POKE* stpoke;
	u8 mark;

	stpoke = &(vpara->statusPoke);
	mark= vpara->menu.mark;
	stpoke->mark = mark;

	// marku8ɓ
	PokePasoParaPut( stpoke->poke_data, ID_PARA_mark, &(mark) );
}
//------------------------------------------------------------------
/**
 * Xe[^X\p|P̃ACeio[Zbg
 *
 * @param   vpara		
 * @param   itemno		
 *
 */
//------------------------------------------------------------------
static void VParaSet_StatusPokeItemNumber( BOXAPP_VPARAM* vpara, u16 itemno, BOXAPP_WORK* wk )
{
	BOXAPP_STATUS_POKE* stpoke;

	stpoke = &(vpara->statusPoke);
	stpoke->itemno = itemno;

	if( stpoke->itemno != ITEM_DUMMY_ID )
	{
		GetItemName( stpoke->itemname, stpoke->itemno, HEAPID_BOX_SYSTEM );
	}
	else
	{
		MSGMAN_GetString( wk->msgman_box, msg_boxmes_01_21, stpoke->itemname );
	}

	PokePasoParaPut( stpoke->poke_data, ID_PARA_item, &(itemno) );
}
//------------------------------------------------------------------
/**
 * gCio[PRi߂
 *
 * @param   tray		
 *
 */
//------------------------------------------------------------------
static void VParaSet_CurrentTrayInc( BOXAPP_VPARAM* vpara )
{
	BOXAPP_TRAY*  tray = &(vpara->tray);
	if( ++(tray->number) >= BOX_MAX_TRAY )
	{
		tray->number = 0;
	}
	SetTrayStatus( vpara->boxData, tray );
}
//------------------------------------------------------------------
/**
 * gCio[PR߂
 *
 * @param   tray		
 *
 */
//------------------------------------------------------------------
static void VParaSet_CurrentTrayDec( BOXAPP_VPARAM* vpara )
{
	BOXAPP_TRAY*  tray = &(vpara->tray);
	if( tray->number )
	{
		tray->number--;
	}
	else
	{
		tray->number = BOX_MAX_TRAY - 1;
	}
	
	SetTrayStatus( vpara->boxData, tray );
}
//------------------------------------------------------------------
/**
 * gCio[ڃZbg
 *
 * @param   box		
 * @param   tray		
 *
 */
//------------------------------------------------------------------
static void VParaSet_CurrentTrayNumberSet( BOXAPP_VPARAM* vpara, u32 number )
{
	BOXAPP_TRAY*  tray = &(vpara->tray);
	tray->number = number;
	SetTrayStatus( vpara->boxData, tray );
}
//------------------------------------------------------------------
/**
 * {bNXIEBhEpp[^Zbg
 *
 * @param   vpara		
 *
 */
//------------------------------------------------------------------
static void VParaSet_JumpWin( BOXAPP_VPARAM* vpara, u32 center_trayno )
{
	BOXAPP_JUMPWIN* jwin = &(vpara->jumpWin);

	jwin->center_trayno = center_trayno;
}

//------------------------------------------------------------------
/**
 * 
 *
 * @param   vpara		
 * @param   state		
 *
 */
//------------------------------------------------------------------
static void VParaSet_SubLCDStae( BOXAPP_VPARAM* vpara, u32 state )
{
	vpara->subLCD.state = state;
}

//------------------------------------------------------------------
/**
 * 
 *
 * @param   vpara		
 * @param   pos		
 *
 */
//------------------------------------------------------------------
static void VParaSet_SubLCDPos( BOXAPP_VPARAM* vpara, u32 pos )
{
	vpara->subLCD.pos = pos;
}
static void VParaSet_SubLCDLimitPos( BOXAPP_VPARAM* vpara, u32 pos )
{
	vpara->subLCD.limit_pos = pos;
}
static void VParaSet_SubLCDMove( BOXAPP_VPARAM* vpara, int move )
{
	vpara->subLCD.move = move;
}

static void VParaSet_LimitModeBitFlag( BOXAPP_VPARAM* vpara, u32 iconID )
{
	if( iconID == LIMITMODE_ICON_ALLOFF ){
		vpara->system.limitModeBitFlag = 0;
	}else{
		vpara->system.limitModeBitFlag ^= ( 1 << (iconID-1) );
	}
}

static void VParaSet_ExpertModeChange( BOXAPP_VPARAM* vpara )
{
	vpara->system.expertModeFlag ^= 1;
}

/*====================================================================================*/
/*  `p[^擾                                                            */
/*====================================================================================*/
MSGDATA_MANAGER* BoxApp_GetMsgManager( const BOXAPP_WORK* wk )
{
	return wk->msgman_box;
}
//------------------------------------------------------------------
/**
 * bZ[W쐬pWORDSETn
 *
 * @param   wk		[N|C^
 *
 * @retval  const WORDSET*		
 */
//------------------------------------------------------------------
const WORDSET* BoxApp_GetWordSet( const BOXAPP_WORK* wk )
{
	return wk->wordset;
}


/*====================================================================================*/
/*  `p[^擾                                                            */
/*====================================================================================*/
u32 BoxAppVPara_GetBoxMode( const BOXAPP_VPARAM* vpara )
{
	return vpara->system.boxMode;
}
u32 BoxAppVPara_GetCursorArea( const BOXAPP_VPARAM* vpara )
{
	return vpara->cursor.area;
}
u32 BoxAppVPara_GetCursorTrayPosX( const BOXAPP_VPARAM* vpara )
{
	return vpara->cursor.tray_xpos;
}
u32 BoxAppVPara_GetCursorTrayPosY( const BOXAPP_VPARAM* vpara )
{
	return vpara->cursor.tray_ypos;
}
u32 BoxAppVPara_GetCursorTrayPos( const BOXAPP_VPARAM* vpara )
{
	return vpara->cursor.tray_pos;
}
u32 BoxAppVPara_GetCursorPartyPos( const BOXAPP_VPARAM* vpara )
{
	return vpara->cursor.partytray_pos;
}
BOOL BoxAppVPara_GetCursorPointPokeFlag( const BOXAPP_VPARAM* vpara )
{
	return vpara->cursor.poke_point_flag;
}
u32 BoxAppVPara_GetCursorCatchPokeFlag(const BOXAPP_VPARAM* vpara )
{
	return vpara->cursor.poke_catch_flag;
}
BOOL BoxAppVPara_GetCursorStatusEnableFlag(const BOXAPP_VPARAM* vpara )
{
	const BOXAPP_CATCH_POKE* catchPoke;
	const BOXAPP_CURSOR* cursor;

	catchPoke = &vpara->catchPoke;
	cursor = &vpara->cursor;

	if(	(cursor->poke_catch_flag == CURSOR_CATCH_SINGLE)
	||	(cursor->poke_catch_flag == CURSOR_CATCH_AREA_POINT)
	){
		return TRUE;
	}

	if( vpara->cursor.poke_point_flag )
	{
		return TRUE;
	}

	return FALSE;
}

u32 BoxAppVPara_GetTrayBoxNumber(const BOXAPP_VPARAM* vpara )
{
	return vpara->tray.number;
}
/** Xe[^X\p|Pf[^{ */
const BOXAPP_STATUS_POKE* BoxAppVpara_GetStatusPokeData( const BOXAPP_VPARAM* vpara )
{
	return &(vpara->statusPoke);
}
/* Xe[^X\|P̎ACeio[Ԃ */
u32 BoxAppVPara_GetStatusPokeItemNumber( const BOXAPP_VPARAM* vpara )
{
	return vpara->statusPoke.itemno;
}
/** Jg{bNXgCf[^{ */
const BOXAPP_TRAY* BoxAppVpara_GetTrayData( const BOXAPP_VPARAM* vpara )
{
	return &(vpara->tray);
}
/** {bNXf[^|C^ */
const BOX_DATA* BoxAppVPara_GetBoxData( const BOXAPP_VPARAM* vpara )
{
	return vpara->boxData;
}

u32 BoxAppVPara_GetMessageID( const BOXAPP_VPARAM* vpara )
{
	return vpara->message_id;
}
POKEMON_PASO_PARAM* BoxAppVPara_GetStatusPokePara( const BOXAPP_VPARAM* vpara )
{
	return vpara->statusPoke.poke_data;
}
u32 BoxAppVPara_GetStatusPokeMarkBit( const BOXAPP_VPARAM* vpara )
{
	return vpara->statusPoke.mark;
}
/** {bNXIEBhE̒SgCio[ */
u32 BoxAppVPara_GetJumpWinCenterTrayNumber( const BOXAPP_VPARAM* vpara )
{
	return vpara->jumpWin.center_trayno;
}
s32 BoxAppVPara_GetSubLCDMove( const BOXAPP_VPARAM* vpara )
{
	return vpara->subLCD.move;
}

u32 BoxAppVPara_GetSubLCDPos( const BOXAPP_VPARAM* vpara )
{
	return vpara->subLCD.pos;
}
u32 BoxAppVPara_GetSubLCDLimitPos( const BOXAPP_VPARAM* vpara )
{
	return vpara->subLCD.limit_pos;
}

u32 BoxAppVPara_GetLimitModeBitFlag( const BOXAPP_VPARAM* vpara )
{
	return vpara->system.limitModeBitFlag;
}

BOOL BoxAppVPara_GetExpertModeFlag( const  BOXAPP_VPARAM* vpara )
{
	return vpara->system.expertModeFlag;
}
/*  ͈͑Ĩp[^擾 */
void BoxAppVPara_GetAreaSelectParam( const BOXAPP_VPARAM* vpara, u32* left, u32* right, u32* top, u32* bottom )
{
	const BOXAPP_CATCH_POKE* catchPoke;

	catchPoke = &vpara->catchPoke;

	if( catchPoke->areaStartX <= catchPoke->areaEndX )
	{
		*left = catchPoke->areaStartX;
		*right = catchPoke->areaEndX;
	}
	else
	{
		*left = catchPoke->areaEndX;
		*right = catchPoke->areaStartX;
	}

	if( catchPoke->areaStartY <= catchPoke->areaEndY )
	{
		*top = catchPoke->areaStartY;
		*bottom = catchPoke->areaEndY;
	}
	else
	{
		*top = catchPoke->areaEndY;
		*bottom = catchPoke->areaStartY;
	}
}
/* ͈͑I𓮍쒆A͈͂PZɂȂĂ邩`FbN */
BOOL BoxAppVPara_CheckAreaSelectSinglePoke( const BOXAPP_VPARAM* vpara )
{
	const BOXAPP_CATCH_POKE* catchPoke;

	catchPoke = &vpara->catchPoke;

	if(	(catchPoke->areaStartX == catchPoke->areaEndX)
	&&	(catchPoke->areaStartY == catchPoke->areaEndY)
	){
		return TRUE;
	}
	return FALSE;
}
/* ͈͑I𓮍쒆͈̔̓gbvʒuԂ */
u32 BoxAppVPara_GetAreaSelectCursorTopPos( const BOXAPP_VPARAM* vpara )
{
	const BOXAPP_CATCH_POKE* catchPoke;
	int left, top;

	catchPoke = &vpara->catchPoke;

	left = vpara->cursor.tray_xpos;
	top = vpara->cursor.tray_ypos;

	if(catchPoke->areaEndX > catchPoke->areaStartX)
	{
		left -= (catchPoke->areaEndX - catchPoke->areaStartX);
	}
	if(catchPoke->areaEndY > catchPoke->areaStartY)
	{
		top -= (catchPoke->areaEndY - catchPoke->areaStartY);
	}

	return (top*BOX_MAX_COLUMN + left);
}
/* ͈͑I|P̓̂P̂A͂񂾎Ƀ{bNX̉Ԗڂɋ͈͒擪̃|P̃ItZbgŕԂ */
/* ₱ */
u32 BoxAppVPara_GetAreaSelectIconOfsPos( const BOXAPP_VPARAM* vpara, u32 idx )
{
	const BOXAPP_CATCH_POKE* catchPoke = &vpara->catchPoke;
	return catchPoke->areaPokePos[idx] - catchPoke->areaTopPos;
}

BOOL BoxAppVPara_GetAreaSelectCatchSpaceFlag( const BOXAPP_VPARAM* vpara )
{
	const BOXAPP_CATCH_POKE* catchPoke = &vpara->catchPoke;
	return catchPoke->areaSpaceCatchFlag;
}
