//============================================================================================
/**
 * @file	box_common.h
 * @brief	{bNXʋLwb_
 * @author	taya
 * @date	2005.09.05
 */
//============================================================================================
#ifndef __BOX_COMMON_H__
#define __BOX_COMMON_H__

#include "gflib\msg_print.h"	// STRCODÊ
#include "gflib\strbuf.h"
#include "system\wordset.h"
#include "system\msgdata.h"
#include "system\buflen.h"
#include "itemtool\item.h"
#include "msgdata\msg_boxmes.h"
#include "poketool\boxdata.h"
#include "poketool\pokeparty.h"

#include "application\box.h"

#include "box_sound_def.h"

//----------------------------------------------------------------------
/**
 *  `R}h
 */
//----------------------------------------------------------------------
enum {
	CMD_INIT,
	CMD_NORMAL_IN,			///< ʍ\z̃tF[hCGtFNgitB[hj
	CMD_FADEIN,				///< ʂ畜A鎞̃tF[hC
	CMD_FADEOUT,			///< ʈȍ~ÕtF[hAEg

	CMD_TRAY_CHANGE,		///< {bNXgC؂ւ
	CMD_CURSOR_MOVE,		///< J[\ړ
	CMD_STATUS_UPDATE,		///< Xe[^X\|P̐؂ւ
	CMD_STATUS_MARK_UPDATE,	///< Xe[^X\|P̃}[LO\̂ݍXV

	CMD_POKE_CATCH,			///< |P
	CMD_POKE_PUT,			///< |P
	CMD_POKE_CHANGE,		///< |Pꂩ
	CMD_AZUKERU_CATCHPOKE,	///< |Pił|Pj
	CMD_AZUKERU_POINTPOKE,	///< |PiwĂ|Pj
	CMD_NIGASU_CATCHPOKE,	///< |Pɂił|Pj
	CMD_NIGASU_TRAYPOKE,	///< |Pɂi{bNXgC̃|Pj
	CMD_NIGASU_PARTYPOKE,	///< |Pɂi莝̃|Pj

	CMD_MSG_DISP,			///< bZ[Ŵ
	CMD_MENU_DISP,			///< bZ[Wj[
	CMD_MSG_CLEAR,			///< bZ[Wj[NA

	CMD_MENUCURSOR_UPDATE,	///< j[J[\ʒuXV
	CMD_MENUMARK_UPDATE,	///< j[}[NԍXVi}[LOj[̂݁j
	CMD_JUMPWIN_DISP,
	CMD_JUMPWIN_UPDATE,
	CMD_JUMPWIN_CLEAR,

	CMD_WALLPAPER_CHANGE,	///< JgǎύX
	CMD_BUTTON_PUSH_ACTION,	///< wJ[\̃{^悤ȓ
	CMD_PARTYTRAY_OPEN,		///< 莝gCJ
	CMD_PARTYTRAY_CLOSE,	///< 莝gC

	CMD_PARTYICON_CLOSEUP,	///< 莝gC̃ACR󂫋l߁i͂񂾌Ej
	CMD_PARTYLASTICON_CLOSEUP,	///< 莝gC̃ACR󂫋l߁iuj
	CMD_ICON_LIMITMODE_UPDATE,	///< ACR̍i荞݃[h\XV

	CMD_SUBLCD_MODECHANGE,
	CMD_SUBLCD_MOVEICON,
	CMD_SUBLCD_MARKICON_UPDATE,	///< i荞݃ACR̕\XV

	CMD_CHANGE_EXPERTMODE,		///< Ăl[h̐؂ւ
	CMD_START_AREASELECT,		///< |PACR͈̔͑IJn
	CMD_END_AREASELECT,			///< |PACR͈̔͑II
	CMD_UPDATE_AREASELECT,		///< |PACR͈̔͑IXV
	CMD_CATCH_AREASELECT_POKE,	///< ͈͑I𒆂̃|PACR͂

	CMD_BOXCLOSE,
};

//----------------------------------------------------------------------
/**
 *  ^XNvCIeB
 */
//----------------------------------------------------------------------
enum BOXTASK{
	TASKPRI_VIEW_COMMAND_SUB,
	TASKPRI_VIEW_COMMAND,
	TASKPRI_VIEW_TRANS,
};

enum BOX_VTASK {
	TASKPRI_V_SUB,
	TASKPRI_V_MAIN,
};

//----------------------------------------------------------------------
/**
 *  j[hc
 */
//----------------------------------------------------------------------
typedef enum {
	BOXMENU_TRAY_JUMP,		///< {bNX̐؂ւ
	BOXMENU_TRAY_WALLPAPER,	///< ǎύX
	BOXMENU_TRAY_NAME,		///< {bNXύX
	BOXMENU_TRAYMENU_QUIT,	///< gCj[u߂v
	BOXMENU_WP_CATEGORY1,	///< ǎJeSP
	BOXMENU_WP_CATEGORY2,	///< ǎJeSQ
	BOXMENU_WP_CATEGORY3,	///< ǎJeSR
	BOXMENU_WP_CATEGORY4,	///< ǎJeSS
	BOXMENU_WP_CATEGORY_EX,	///< ǎJeSB
	BOXMENU_WP_NAME1_1,		///< ǎP-P
	BOXMENU_WP_NAME1_2,		///< ǎP-Q
	BOXMENU_WP_NAME1_3,		///< ǎP-R
	BOXMENU_WP_NAME1_4,		///< ǎP-S
	BOXMENU_WP_NAME2_1,		///< ǎQ-P
	BOXMENU_WP_NAME2_2,		///< ǎQ-Q
	BOXMENU_WP_NAME2_3,		///< ǎQ-R
	BOXMENU_WP_NAME2_4,		///< ǎQ-S
	BOXMENU_WP_NAME3_1,		///< ǎR-P
	BOXMENU_WP_NAME3_2,		///< ǎR-Q
	BOXMENU_WP_NAME3_3,		///< ǎR-R
	BOXMENU_WP_NAME3_4,		///< ǎR-S
	BOXMENU_WP_NAME4_1,		///< ǎS-P
	BOXMENU_WP_NAME4_2,		///< ǎS-Q
	BOXMENU_WP_NAME4_3,		///< ǎS-R
	BOXMENU_WP_NAME4_4,		///< ǎS-S
	BOXMENU_POKE_TUKAMU,	///< |Puށv
	BOXMENU_POKE_OKU,		///< |Puɂv
	BOXMENU_POKE_IREKAERU,	///< |Puꂩv
	BOXMENU_POKE_YOUSU,		///< |Pu悤݂v
	BOXMENU_POKE_TURETEIKU,	///< |PuĂv
	BOXMENU_POKE_AZUKERU,	///< |Puv
	BOXMENU_POKE_MOTIMONO,	///< |Púv
	BOXMENU_POKE_MARKING,	///< |Pu}[LOv
	BOXMENU_POKE_NIGASU,	///< |Puɂv
	BOXMENU_POKEMENU_QUIT,	///< |Pj[u߂v
	BOXMENU_MARKING_DECIDE,	///< }[LOuĂv
	BOXMENU_MARKING_CANCEL,	///< }[LOu߂viLZj
	BOXMENU_ITEM_SET,		///< ACe
	BOXMENU_ITEM_WITHDRAW,	///< ACe
	BOXMENU_ITEM_INFO,		///< ACe߂
	BOXMENU_ITEMMENU_QUIT,	///< ACej[u߂v
	BOXMENU_YES,			///< ͂
	BOXMENU_NO,				///< 

	BOXMENU_MARK1,
	BOXMENU_MARK2,
	BOXMENU_MARK3,
	BOXMENU_MARK4,
	BOXMENU_MARK5,
	BOXMENU_MARK6,
}BOX_MENU_ID;


enum {
	BOX_MARK_MAX = 6,	// BOXMENU_MARK1`6Ɛ킹
};

//----------------------------------------------------------------------
/**
 *  C[N^`
 */
//----------------------------------------------------------------------
typedef struct _BOXAPP_WORK  BOXAPP_WORK;

//----------------------------------------------------------------------
/**
 *  `惏[N^`
 */
//----------------------------------------------------------------------
typedef struct _BOXAPP_VIEW_WORK  BOXAPP_VIEW_WORK;

//----------------------------------------------------------------------
/**
 *  J[\ړGA
 */
//----------------------------------------------------------------------
enum CURSOR_AREA {
	CURSOR_AREA_TRAY,			///< gC
	CURSOR_AREA_PARTY,			///< 莝EBhE
	CURSOR_AREA_TRAY_TAB,		///< gC̃^u
	CURSOR_AREA_PARTY_BUTTON,	///< wĂ|Px̃{^
	CURSOR_AREA_EXIT_BUTTON,	///< wƂx{^
};

//----------------------------------------------------------------------
/**
 *  i荞݃[hACRID
 */
//----------------------------------------------------------------------
enum {
	LIMITMODE_ICON_ALLOFF,
	LIMITMODE_ICON_ITEM,
	LIMITMODE_ICON_MARK1,
	LIMITMODE_ICON_MARK2,
	LIMITMODE_ICON_MARK3,
	LIMITMODE_ICON_MARK4,
	LIMITMODE_ICON_MARK5,
	LIMITMODE_ICON_MARK6,

	LIMITMODE_ICON_MAX,
};

//----------------------------------------------------------------------
/**
 *  i荞݃[hrbgtO
 */
//----------------------------------------------------------------------
enum {
	LIMITMODE_BIT_OFF = 0x0000,
	LIMITMODE_BIT_ITEM = 0x0001,
	LIMITMODE_BIT_MARK1 = 0x0002,
	LIMITMODE_BIT_MARK2 = 0x0004,
	LIMITMODE_BIT_MARK3 = 0x0008,
	LIMITMODE_BIT_MARK4 = 0x0010,
	LIMITMODE_BIT_MARK5 = 0x0020,
	LIMITMODE_BIT_MARK6 = 0x0040,
};

//----------------------------------------------------------------------
/**
 *  |Pݏ
 */
//----------------------------------------------------------------------
enum {
	CURSOR_CATCH_NONE = 0x01,		///< łȂ
	CURSOR_CATCH_SINGLE = 0x02,		///< P̂łł
	CURSOR_CATCH_AREA_POINT = 0x04,	///< ͈͑IłłāA|PJ[\̒ɂ
	CURSOR_CATCH_AREA_FREE = 0x08,	///< ͈͑IłłāA|PJ[\̒ɂȂ

	CURSOR_CATCH_AREA_MASK = (CURSOR_CATCH_AREA_POINT | CURSOR_CATCH_AREA_FREE),
	CUROSR_CATCH_STATUS_HOLD_MASK = (CURSOR_CATCH_SINGLE | CURSOR_CATCH_AREA_POINT ),
	
	
};

//----------------------------------------------------------------------
/**
 *  TuLCD\
 */
//----------------------------------------------------------------------
typedef enum {
	SUBLCD_STATE_NORMAL,	// ʏ펞
	SUBLCD_STATE_TRAY,		// gCI
	SUBLCD_STATE_MARK,		// }[NI
}DISP_STATE;

//----------------------------------------------------------------------
/**
 *  ̂萔
 */
//----------------------------------------------------------------------
enum {
	TRAY_XPOS_MAX = BOX_MAX_COLUMN-1,
	TRAY_YPOS_MAX = BOX_MAX_RAW-1,

	CURSOR_PARTYTRAY_CLOSEBUTTON_POS = TEMOTI_POKEMAX,
};

//----------------------------------------------------------------------
/**
 *  Xe[^X\邽߂̃|Pf[^
 */
//----------------------------------------------------------------------
typedef struct {
	void*	poke_data;
	u16		monsno;
	u16		itemno;
	u8		level;
	u8		mark;
	u8		type1;	// ^CvĂ̂́u݂vƂu͂ˁvƂB
	u8		type2;	// ACR\̂ŕ͕svB
	u8		sex;
	u8		update_flag;

/*
	STRCODE	nickname[BUFLEN_POKEMON_NAME];
	STRCODE	monsname[BUFLEN_POKEMON_NAME];
	STRCODE	itemname[BUFLEN_ITEM_NAME];
	STRCODE	character[BUFLEN_POKEMON_CHARACTER_NAME];
	STRCODE	ability[BUFLEN_POKEMON_ABILITY_NAME];
*/
	STRBUF*	nickname;
	STRBUF*	monsname;
	STRBUF*	itemname;
	STRBUF*	character;
	STRBUF*	ability;

}BOXAPP_STATUS_POKE;

//----------------------------------------------------------------------
/**
 *  J[\ԃf[^
 */
//----------------------------------------------------------------------
typedef struct {
	void*	point_poke;			///< wĂ|P

	u8   area;					///< {bNXgCA莝gCAƂ{^
	s8   tray_xpos;				///< {bNXgCł̂wʒu
	s8   tray_ypos;				///< {bNXgCł̂xʒu
	s8   tray_pos;				///< {bNXgCł̃f[^ʒu

	s8   partytray_pos;			///< 莝gCł̃f[^ʒu
	s8   partytray_prev_pos;	///< 莝gCł̈ړOʒu
	s8   partytray_prev_area;	///< 莝gCֈȍ~܂ area 

	u8  poke_point_flag;		///< |PwĂtO
	u8  poke_catch_flag;		///< |P͂łtO

}BOXAPP_CURSOR;

//----------------------------------------------------------------------
/**
 *  ł|P̃f[^
 */
//----------------------------------------------------------------------
typedef struct {
	POKEMON_PASO_PARAM*		ppp;	///< ͂ݒ|Pf[^
	u8			areaStartX;			///< ͈͑IJnwWigCʒuj
	u8			areaStartY;			///< ͈͑IJnxWigCʒuj
	u8			areaEndX;			///< ͈͑IIwWigCʒuj
	u8			areaEndY;			///< ͈͑IIxWigCʒuj

	u8			areaPokeCount;
	u8			areaTopPos;
	u8			areaSpaceCatchFlag;			///< ͈͑IA󔒈ʒu͂
	s8			areaPokePos[BOX_MAX_POS];	///< gĈǂ̈ʒu擾|PĂ

}BOXAPP_CATCH_POKE;


//----------------------------------------------------------------------
/**
 *  \̃gCf[^
 */
//----------------------------------------------------------------------
typedef struct {
	u8			number;		///< \gCio[
	u8			wallPaper;	///< ̕ǎio[
	STRBUF*		name;
}BOXAPP_TRAY;

//----------------------------------------------------------------------
/**
 * j[f[^
 */
//----------------------------------------------------------------------
#define BOXAPP_MENU_ELEMS_MAX	(8)
typedef struct {
	BOX_MENU_ID	id[ BOXAPP_MENU_ELEMS_MAX ];
	u8			pos;		///< IĂ郁j[ʒu
	u8			cnt;		///< o^Ă郁j[
	u8			mark;		///< }[LO
	u8			type;		///< \^Cviݖgpj
}BOXAPP_MENU;

//----------------------------------------------------------------------
/**
 *  {bNXIEBhEf[^
 */
//----------------------------------------------------------------------
typedef struct {
	u32		center_trayno;		///< S̃gCio[
}BOXAPP_JUMPWIN;

//----------------------------------------------------------------------
/**
 *  TuLCD\f[^
 */
//----------------------------------------------------------------------
typedef struct {
	u8		state;				///< \
	u8      limit_pos;			///< i肱݃[hACRʒu
	u8		pos;				///< gC[hACRʒu
	s16		move;				///< ړ
}BOXAPP_SUBLCD;

//----------------------------------------------------------------------
/**
 *  {bNXVXef[^
 */
//----------------------------------------------------------------------
typedef struct {
	u8		boxMode;			///< {bNX샂[hiEĂEEǂj
	u8		expertModeFlag;		///< Ăl[htO
	u16		limitModeBitFlag;	///< i荞݃[hrbgtO
}BOXAPP_SYSTEM;



//----------------------------------------------------------------------
/**
 *  {bNX`pp[^
 *
 *   box.c 삵Aboxv.c ȉ̕`֐Q͎QƂ̂ݍsB
 */
//----------------------------------------------------------------------
typedef struct {
	const BOX_DATA*			boxData;
	const POKEPARTY*		partyData;
	BOXAPP_CURSOR			cursor;
	BOXAPP_CATCH_POKE		catchPoke;
	BOXAPP_TRAY				tray;
	BOXAPP_SYSTEM			system;
	BOXAPP_STATUS_POKE		statusPoke;
	BOXAPP_MENU				menu;
	BOXAPP_JUMPWIN			jumpWin;
	BOXAPP_SUBLCD			subLCD;
	u32						message_id;
	u32						azukeruTrayNumber;
}BOXAPP_VPARAM;



extern BOOL BoxAppView_Init( BOXAPP_VIEW_WORK** vwk, const BOXAPP_VPARAM* vpara, const BOXAPP_WORK* mainwk );
extern void BoxAppView_SetCommand( BOXAPP_VIEW_WORK* vwk,  u32 cmd );
extern BOOL BoxAppView_WaitCommand( BOXAPP_VIEW_WORK* vwk, u32 cmd );
extern BOOL BoxAppView_WaitCommandAll( BOXAPP_VIEW_WORK* vwk );
extern void BoxAppView_Main( BOXAPP_VIEW_WORK* wk );
extern void BoxAppView_End( BOXAPP_VIEW_WORK* wk );

/*===================================================================================*/
/*  `p[^֘A                                                               */
/*===================================================================================*/
extern MSGDATA_MANAGER* BoxApp_GetMsgManager( const BOXAPP_WORK* wk );
extern const WORDSET* BoxApp_GetWordSet( const BOXAPP_WORK* wk );
extern u32 BoxAppVPara_GetBoxMode( const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetCursorArea( const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetCursorTrayPosX( const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetCursorTrayPosY( const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetCursorTrayPos( const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetCursorPartyPos( const BOXAPP_VPARAM* vpara );
extern BOOL BoxAppVPara_GetCursorPointPokeFlag( const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetCursorCatchPokeFlag(const BOXAPP_VPARAM* vpara );
extern BOOL BoxAppVPara_GetCursorStatusEnableFlag(const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetTrayBoxNumber( const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetMessageID( const BOXAPP_VPARAM* vpara );
extern POKEMON_PASO_PARAM* BoxAppVPara_GetStatusPokePara( const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetStatusPokeItemNumber( const BOXAPP_VPARAM* vpara );
extern const BOXAPP_STATUS_POKE* BoxAppVpara_GetStatusPokeData( const BOXAPP_VPARAM* vpara );
extern const BOXAPP_TRAY* BoxAppVpara_GetTrayData( const BOXAPP_VPARAM* vpara );
extern const BOX_DATA* BoxAppVPara_GetBoxData( const BOXAPP_VPARAM* vpara );
extern s32 BoxAppVPara_GetSubLCDMove( const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetSubLCDPos( const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetSubLCDLimitPos( const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetJumpWinCenterTrayNumber( const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetLimitModeBitFlag( const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetStatusPokeMarkBit( const BOXAPP_VPARAM* vpara );
extern BOOL BoxAppVPara_GetExpertModeFlag( const  BOXAPP_VPARAM* vpara );
extern void BoxAppVPara_GetAreaSelectParam( const BOXAPP_VPARAM* vpara, u32* left, u32* right, u32* top, u32* bottom );
extern BOOL BoxAppVPara_CheckAreaSelectSinglePoke( const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetAreaSelectCursorTopPos( const BOXAPP_VPARAM* vpara );
extern u32 BoxAppVPara_GetAreaSelectIconOfsPos( const BOXAPP_VPARAM* vpara, u32 idx );
extern BOOL BoxAppVPara_GetAreaSelectCatchSpaceFlag( const BOXAPP_VPARAM* vpara );


#endif
