//============================================================================================
/**
 * @file	box_reel.c
 * @brief	{bNXʁ@Tuʃ[ZN^̓씻
 * @author	taya
 * @date	2005.11.16
 */
//============================================================================================
#include "common.h"
#include "gflib\touchpanel.h"

#include  "box_common.h"
#include  "box_reel.h"


#define MOVEVALUE_MAX	(4)		// őŉiK

#define REEL_ANGLE_MAX	(72)	// [ő剽xƂ݂ȂHi90x҂肾Ƒ傫j

#define FX16_PI		(0x3234)	// ~񂮂炢

#define REEL_ANGLE_UNIT		(((REEL_ANGLE_MAX*FX16_PI)/180)/MOVEVALUE_MAX)


#define REED_MARGIN_TIME	(10)	// ^b`ĂpxvZ܂ŁÃt[]T


//==============================================================
// Prototype
//==============================================================
static void change_ctrlfunc( BOX_REEL_CTRL* ctrl, int (*func)(BOX_REEL_CTRL*,BOOL,BOOL) );
static int ctrlfunc_free( BOX_REEL_CTRL* ctrl, BOOL hit_flag, BOOL trg_flag );
static int ctrlfunc_hit( BOX_REEL_CTRL* ctrl, BOOL hit_flag, BOOL trg_flag );
static int ctrlfunc_idle_hold( BOX_REEL_CTRL* ctrl, BOOL hit_flag, BOOL trg_flag );
static int ctrlfunc_idle_free( BOX_REEL_CTRL* ctrl, BOOL hit_flag, BOOL trg_flag );
static fx16 calc_angle( const BOX_REEL_CTRL* ctrl, u32 px, u32 py );
static int calc_slide_value( const BOX_REEL_CTRL* ctrl, fx16 start, fx16 end );



//------------------------------------------------------------------
/**
 * 
 *
 * @param   ctrl		
 *
 */
//------------------------------------------------------------------
void BoxApp_ReelCtrlInit( BOX_REEL_CTRL* ctrl, int cx, int cy, int r_in, int r_out )
{
	ctrl->func = ctrlfunc_free;

	ctrl->center_x = cx;
	ctrl->center_y = cy;
	ctrl->last_x = cx;
	ctrl->last_y = cy;
	ctrl->touch_x = cx;
	ctrl->touch_y = cy;

	ctrl->inside.circle.code = TP_USE_CIRCLE;
	ctrl->inside.circle.x = cx;
	ctrl->inside.circle.y = cy;
	ctrl->inside.circle.r = r_in;

	ctrl->outside.circle.code = TP_USE_CIRCLE;
	ctrl->outside.circle.x = cx;
	ctrl->outside.circle.y = cy;
	ctrl->outside.circle.r = r_out;

	if( cx < 128 ){
		ctrl->sign = 1;
	}else {
		ctrl->sign = -1;
	}
}

//------------------------------------------------------------------
/**
 * 
 *
 * @param   ctrl		Rg[[N|C^
 *
 * @retval  int			iKXCh邩
 */
//------------------------------------------------------------------
int BoxApp_ReelCtrlMain( BOX_REEL_CTRL* ctrl )
{
	BOOL hit_flag, trg_flag;

	// Ỏ~Ả~OȂ烊[ɐGĂƔ肷
	if( ( GF_TP_SingleHitCont( &ctrl->outside ) == TRUE )
	&&	( GF_TP_SingleHitCont( &ctrl->inside ) == FALSE )
	){
		u32 x, y;

		hit_flag = TRUE;
		trg_flag = GF_TP_GetTrg();

		if( GF_TP_GetPointCont( &x, &y ) )
		{
			ctrl->last_x = x;
			ctrl->last_y = y;
		}

	}
	else
	{
		hit_flag = FALSE;
		trg_flag = FALSE;
	}

	ctrl->hit_flag = hit_flag;
	return ctrl->func( ctrl, hit_flag, trg_flag );

}

static void change_ctrlfunc( BOX_REEL_CTRL* ctrl, int (*func)(BOX_REEL_CTRL*,BOOL,BOOL) )
{
	ctrl->seq = 0;
	ctrl->func = func;
}

static void change_ctrlfunc_keeptime( BOX_REEL_CTRL* ctrl, int (*func)(BOX_REEL_CTRL*,BOOL,BOOL) )
{
	ctrl->func = func;
}


//------------------------------------------------------------------
/**
 * Rg[֐F^b`plɐGĂȂ
 *
 * @param   ctrl			Rg[[N|C^
 * @param   hit_flag		͈͓ɐGĂ邩
 * @param   trg_flag		^b`plgK̓tO
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int ctrlfunc_free( BOX_REEL_CTRL* ctrl, BOOL hit_flag, BOOL trg_flag )
{
	if( hit_flag && trg_flag )
	{
		GF_TP_GetPointTrg( &(ctrl->touch_x), &(ctrl->touch_y) );
		ctrl->touch_angle = calc_angle( ctrl, ctrl->touch_x, ctrl->touch_y );
		change_ctrlfunc( ctrl, ctrlfunc_hit );
		return REEL_RESULT_START;
	}
	return REEL_RESULT_NULL;
}
//------------------------------------------------------------------
/**
 * 
 *
 * @param   ctrl		
 * @param   hit_flag		
 * @param   trg_flag		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int ctrlfunc_hit( BOX_REEL_CTRL* ctrl, BOOL hit_flag, BOOL trg_flag )
{
	if( hit_flag == FALSE)
	{
		change_ctrlfunc( ctrl, ctrlfunc_free );
		return REEL_RESULT_MOVE;
	}

	if( ctrl->seq < REED_MARGIN_TIME )
	{
		ctrl->seq++;
		return REEL_RESULT_NULL;
	}

	return REEL_RESULT_MOVE;
}
static int ctrlfunc_idle_hold( BOX_REEL_CTRL* ctrl, BOOL hit_flag, BOOL trg_flag )
{
	if( hit_flag == FALSE)
	{
		change_ctrlfunc( ctrl, ctrlfunc_idle_free );
	}
	return REEL_RESULT_NULL;
}
static int ctrlfunc_idle_free( BOX_REEL_CTRL* ctrl, BOOL hit_flag, BOOL trg_flag )
{
	return REEL_RESULT_NULL;
}

//------------------------------------------------------------------
/**
 * 
 *
 * @param   ctrl		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
int BoxApp_ReelCtrlGetMoveValue( const BOX_REEL_CTRL* ctrl )
{
	fx16 angle;

	angle = calc_angle( ctrl, ctrl->last_x, ctrl->last_y );

	return calc_slide_value( ctrl, ctrl->touch_angle, angle );
}

void BoxApp_ReelCtrlNotifyMoveStart( BOX_REEL_CTRL* ctrl )
{
	if( ctrl->func == ctrlfunc_hit )
	{
		change_ctrlfunc_keeptime( ctrl, ctrlfunc_idle_hold );
	}
	else
	{
		change_ctrlfunc( ctrl, ctrlfunc_idle_free );
	}
}

//------------------------------------------------------------------
/**
 * ACRړɌĂяoAԂZbg
 *
 * @param   ctrl		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
int BoxApp_ReelCtrlReset( BOX_REEL_CTRL* ctrl )
{
	if( ctrl->func == ctrlfunc_idle_hold )
	{
		change_ctrlfunc_keeptime( ctrl, ctrlfunc_hit );
		return TRUE;
	}
	else
	{
		/*
		if( ctrl->hit_flag )
		{
			GF_TP_GetPointTrg( &(ctrl->touch_x), &(ctrl->touch_y) );
			ctrl->touch_angle = calc_angle( ctrl, ctrl->touch_x, ctrl->touch_y );
			change_ctrlfunc( ctrl, ctrlfunc_hit );
			return TRUE;
		}
		else
		{
			change_ctrlfunc( ctrl, ctrlfunc_free );
		}
		*/
		change_ctrlfunc( ctrl, ctrlfunc_free );
		return FALSE;
	}
	return FALSE;
}

//------------------------------------------------------------------
/**
 * Cӓ_ƒS_Ƃ̊pxvZ
 *
 * @param   ctrl	Rg[[N|C^
 * @param   px		Cӓ_X
 * @param   py		Cӓ_Y
 *
 * @retval  fx16	pxiWAj
 */
//------------------------------------------------------------------
static fx16 calc_angle( const BOX_REEL_CTRL* ctrl, u32 px, u32 py )
{
	fx32  x, y;

	x = ((int)(px - ctrl->center_x)) * FX32_ONE;
	y = ((int)(py - ctrl->center_y)) * FX32_ONE;

	return FX_Atan2( y, x );
}
//------------------------------------------------------------------
/**
 * XChpxAiKXCh邩vZ
 *
 * @param   ctrl		Rg[[N|C^
 * @param   start		XChJnpxiWAj
 * @param   end			XChIpxiWAj
 *
 * @retval  int		iKXCh邩
 */
//------------------------------------------------------------------
static int calc_slide_value( const BOX_REEL_CTRL* ctrl, fx16 start, fx16 end )
{
	int diff, val;

	diff = end - start;
	val = diff / REEL_ANGLE_UNIT;

	if( val > MOVEVALUE_MAX ){
		val = MOVEVALUE_MAX;
	}else if( val < -MOVEVALUE_MAX ){
		val = -MOVEVALUE_MAX;
	}
	return val * ctrl->sign;
}
