//============================================================================================
/**
 * @file	boxv_exwin.c
 * @brief	{bNXʁ@`扺iEBhEj
 * @author	taya
 * @date	2005.10.04
 */
//============================================================================================
#include  "common.h"
#include  "system\arc_util.h"
#include  "system\numfont.h"
#include  "system\brightness.h"
#include  "system\fontproc.h"

#include  "box_arc.h"
#include  "box_view.h"
#include  "box_common.h"


enum {
	TRAYICON_WRITE_OX = 9,
	TRAYICON_WRITE_OY = 10,
	TRAYICON_WRITE_WIDTH = 14,
	TRAYICON_WRITE_HEIGHT = 12,
	TRAYICON_DOT_WRITE_OX = 10,
	TRAYICON_DOT_WRITE_OY = 12,
	TRAYICON_SIZE_X = 32,
	TRAYICON_SIZE_Y = 32,


	TRAYICON_DISP_X = 32,
	TRAYICON_DISP_XSPC = 32,
	TRAYICON_DISP_Y = 88,
	TRAYICON_DISP_COUNT = 7,

	// gCACR\̈ihbgPʁBEBhEɎgj
	TRAYICON_DISP_START_XPOS = TRAYICON_DISP_X - (TRAYICON_SIZE_X/2),
	TRAYICON_DISP_END_XPOS = TRAYICON_DISP_X + (TRAYICON_DISP_COUNT-1)*TRAYICON_DISP_XSPC + (TRAYICON_SIZE_X/2),
	TRAYICON_DISP_START_YPOS = TRAYICON_DISP_Y - (TRAYICON_SIZE_Y/2),
	TRAYICON_DISP_END_YPOS = TRAYICON_DISP_Y + (TRAYICON_SIZE_Y/2),
	TRAYICON_FADE_TIME = BOX_TIMER(4),



	JUMPWIN_WRITE_XPOS = 0,	// LPʕ\ʒu
	JUMPWIN_WRITE_YPOS = 5,	// LPʕ\ʒu
	JUMPWIN_WIDTH = 32,		// LPʃTCY
	JUMPWIN_HEIGHT = 10,	// LPʃTCY

	JUMPWIN_DISPEFFECT_SPEED = BOX_EFF_SPEED(1),


	// BitmapWindow ݒ
	WIN_TRAYNAME_X = 10,
	WIN_TRAYNAME_Y = JUMPWIN_WRITE_YPOS + 1,
	WIN_TRAYNAME_WIDTH = 12,
	WIN_TRAYNAME_HEIGHT = 2,
	WIN_TRAYNAME_CHARSIZE = WIN_TRAYNAME_WIDTH*WIN_TRAYNAME_HEIGHT,

	WIN_POKECNT_X = 3,
	WIN_POKECNT_Y = JUMPWIN_WRITE_YPOS + 8,
	WIN_POKECNT_WIDTH = 26,
	WIN_POKECNT_HEIGHT = 1,
	WIN_POKECNT_CHARSIZE = WIN_POKECNT_WIDTH*WIN_POKECNT_HEIGHT,

	// BitmapWindow LItZbg
	WIN_TRAYNAME_CHAROFS = 128,
	WIN_POKECNT_CHAROFS = WIN_TRAYNAME_CHAROFS + WIN_TRAYNAME_CHARSIZE,

	// BitmapWindow J[ݒ
	WIN_TRAYNAME_LETTER_COLOR = 0x02,
	WIN_TRAYNAME_SHADOW_COLOR = 0x08,
	WIN_TRAYNAME_GROUND_COLOR = 0x07,

	WIN_POKECNT_LETTER_COLOR = 0x02,
	WIN_POKECNT_SHADOW_COLOR = 0x0d,
	WIN_POKECNT_GROUND_COLOR = 0x04,

	WIN_TRAYNAME_CENTER_XPOS = ((WIN_TRAYNAME_WIDTH/2)*8),

	WIN_POKECNT_WRITE_XSPC = TRAYICON_DISP_XSPC,

};

/** EBhE^Cv */
enum {
	WIN_TRAYNAME = 0,
	WIN_POKECNT,
	WIN_MAX,
};

/** EBhEGtFNg^Cv*/
typedef enum {
	JUMPWIN_EFF_DISP,
	JUMPWIN_EFF_DELETE,
}JUMPWIN_EFFECT_TYPE;

//==============================================================
// Prototype
//==============================================================
static int DispFirstTrayNumber( EXWIN_VIEW_WORK* wk );
static void TrayIconCharStoreInit( EXWIN_VIEW_WORK* wk );
static void TrayIconCharStoreSet( EXWIN_VIEW_WORK* wk, u32 trayno );
static void TrayIconCharStoreTrans( EXWIN_VIEW_WORK* wk, u32 pos, u32 trayno );
static void TrayIconMainViewInit( EXWIN_VIEW_WORK* wk );
static void TrayIconMainViewDelete( EXWIN_VIEW_WORK* wk );
static void TrayIconMainViewFormat( EXWIN_VIEW_WORK* wk );
static void TrayNameWrite( EXWIN_VIEW_WORK* wk );
static void TrayNameClear( EXWIN_VIEW_WORK* wk );
static void PokeCntWrite( EXWIN_VIEW_WORK* wk );
static void PokeCntClear( EXWIN_VIEW_WORK* wk );
static void SetJumpWinEffectTask( EXWIN_VIEW_WORK* wk, JUMPWIN_EFFECT_TYPE type);
static void DeleteJumpWinEffectTask( TCB_PTR tcb, void* wk_adrs );
static BOOL WaitJumpWinEffectTask( EXWIN_VIEW_WORK* wk );
static void JumpWinDispEffectTask( TCB_PTR tcb, void* wk_adrs );
static void JumpWinDeleteEffectTask( TCB_PTR tcb, void* wk_adrs );



//------------------------------------------------------------------
/**
 * 
 *
 * @param   wk			[N|C^
 * @param   vwk			`惁C[N|C^
 * @param   vpara		`p[^|C^
 * @param   bgl			BGLVXe|C^
 * @param   actsys		AN^[VXe|C^
 *
 * @retval  BOOL		TRUEŐ
 */
//------------------------------------------------------------------
BOOL BoxAppView_ExWinInit( EXWIN_VIEW_WORK* wk, BOXAPP_VIEW_WORK* vwk, const BOXAPP_VPARAM* vpara, GF_BGL_INI* bgl, CLACT_SET_PTR actsys )
{
	int i;

	wk->vwk = vwk;
	wk->bgl = bgl;
	wk->vpara = vpara;
	wk->actsys = actsys;

	ArcUtil_BgCharSet( ARC_BOX_GRA, NARC_box_bg0_lz_ncgr, bgl, FRM_MAIN_MESSAGE, 0, 0, TRUE, HEAPID_BOX_VIEW );

	{
		NNSG2dPaletteData* palData;
		void* allocBuf;

		allocBuf = ArcUtil_PalDataGet(ARC_BOX_GRA, NARC_box_wp_image_nclr, &palData, HEAPID_BOX_VIEW);
		MI_CpuCopy16(palData->pRawData, &(wk->trayIconPalBuf[0][0]), 0x40);
		sys_FreeMemoryEz(allocBuf);

		allocBuf = ArcUtil_PalDataGet(ARC_BOX_GRA, NARC_box_tray_icon_nclr, &palData, HEAPID_BOX_VIEW);
		MI_CpuCopy16(palData->pRawData, &(wk->trayIconPalBuf[0][32]), 0x20);
		sys_FreeMemoryEz(allocBuf);


		{
			int i;
			fx32 step, sub;

			step = 16 << FX32_SHIFT;
			sub = step / (TRAYICON_FADE_MAX-1);

			for(i=TRAYICON_FADE_MAX-1; i>=1; i--)
			{
				BoxAppView_PalFade(wk->trayIconPalBuf[0], wk->trayIconPalBuf[i], TRAYICON_PAL_COLOR_NUM, 
					0x7fff, (step>>FX32_SHIFT));
				step -= sub;
			}
			DC_FlushRange( wk->trayIconPalBuf, TRAYICON_FADE_MAX*TRAYICON_PAL_SIZE );
		}

		GX_LoadOBJPltt( wk->trayIconPalBuf[TRAYICON_FADE_MAX-1], OBJPAL_TRAYICON_TOP*0x20, TRAYICON_PAL_SIZE );
		GXS_LoadOBJPltt( wk->trayIconPalBuf[0], OBJPAL_TRAYICON_TOP*0x20, TRAYICON_PAL_SIZE );
//		ArcUtil_PalSet( ARC_BOX_GRA, NARC_box_tray_icon_nclr, PALTYPE_MAIN_OBJ, OBJPAL_TRAYICON_BASE*0x20, 0x20, HEAPID_BOX_VIEW );
//		ArcUtil_PalSet( ARC_BOX_GRA, NARC_box_wp_image_nclr, PALTYPE_MAIN_OBJ, OBJPAL_TRAYICON_WP*0x20, 0x40, HEAPID_BOX_VIEW );
//		ArcUtil_PalSet( ARC_BOX_GRA, NARC_box_tray_icon_nclr, PALTYPE_SUB_OBJ, OBJPAL_TRAYICON_BASE*0x20, 0x20, HEAPID_BOX_VIEW );
//		ArcUtil_PalSet( ARC_BOX_GRA, NARC_box_wp_image_nclr, PALTYPE_SUB_OBJ, OBJPAL_TRAYICON_WP*0x20, 0x40, HEAPID_BOX_VIEW );
	}

	wk->iconCharBuf = ArcUtil_CharDataGet( ARC_BOX_GRA, NARC_box_tray_icon_lz_ncgr, TRUE, &(wk->iconCharData), HEAPID_BOX_VIEW );
	wk->iconCellBuf = ArcUtil_CellBankDataGet( ARC_BOX_GRA, NARC_box_tray_icon_lz_ncer, TRUE, &(wk->iconCellData), HEAPID_BOX_VIEW );
	wk->itemwinScrnBuf = ArcUtil_ScrnDataGet( ARC_BOX_GRA, NARC_box_bg0a_lz_nscr, TRUE, &(wk->itemwinScrnData), HEAPID_BOX_VIEW );
	wk->jumpwinScrnBuf = ArcUtil_ScrnDataGet( ARC_BOX_GRA, NARC_box_bg0b_lz_nscr, TRUE, &(wk->jumpwinScrnData), HEAPID_BOX_VIEW );

	wk->numfont = NUMFONT_Create( WIN_POKECNT_LETTER_COLOR, WIN_POKECNT_SHADOW_COLOR, WIN_POKECNT_GROUND_COLOR, HEAPID_BOX_VIEW );
	wk->traynameBuf = STRBUF_Create( BOX_TRAYNAME_BUFSIZE, HEAPID_BOX_VIEW );

	wk->bmpwin = NULL;

	wk->trayIconBmpHeader.adrs = wk->iconCharData->pRawData;
	wk->trayIconBmpHeader.size_x = TRAYICON_SIZE_X;
	wk->trayIconBmpHeader.size_y = TRAYICON_SIZE_Y;

	for(i = 0; i < BOX_MAX_TRAY; i++)
	{
		wk->trayIconAct[i] = NULL;
	}

	if(	(wk->iconCharBuf == NULL)
	||	(wk->iconCellBuf == NULL)
	||	(wk->jumpwinScrnBuf == NULL)
	||	(wk->itemwinScrnBuf == NULL)
	||	(wk->numfont == NULL)
	||	(wk->traynameBuf == NULL)
	){
		return FALSE;
	}


	return TRUE;
}
//------------------------------------------------------------------
/**
 * 
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
void BoxAppView_ExWinSetup( EXWIN_VIEW_WORK* wk )
{
	static const BMPWIN_DAT  windat[] = {
		{
			FRM_MAIN_MESSAGE,
			WIN_TRAYNAME_X, WIN_TRAYNAME_Y, WIN_TRAYNAME_WIDTH, WIN_TRAYNAME_HEIGHT,
			PAL_MAIN_STATUS3, WIN_TRAYNAME_CHAROFS
		},{
			FRM_MAIN_MESSAGE,
			WIN_POKECNT_X, WIN_POKECNT_Y, WIN_POKECNT_WIDTH, WIN_POKECNT_HEIGHT,
			PAL_MAIN_STATUS3, WIN_POKECNT_CHAROFS
		}
	};

	wk->bmpwin = GF_BGL_BmpWinAllocGet( HEAPID_BOX_VIEW, NELEMS(windat) );
	if( wk->bmpwin )
	{
		int i;

		for(i = 0; i < NELEMS(windat); i++)
		{
			GF_BGL_BmpWinAddEx( wk->bgl, &wk->bmpwin[i], &windat[i] );
		}
	}
}
//------------------------------------------------------------------
/**
 * I
 *
 * @param   wk		
 *
 */
//------------------------------------------------------------------
void BoxAppView_ExWinQuit( EXWIN_VIEW_WORK* wk )
{
	if( wk->iconCharBuf )
	{
		sys_FreeMemoryEz( wk->iconCharBuf );
	}

	if( wk->iconCellBuf )
	{
		sys_FreeMemoryEz( wk->iconCellBuf );
	}

	if( wk->jumpwinScrnBuf )
	{
		sys_FreeMemoryEz( wk->jumpwinScrnBuf );
	}

	if( wk->itemwinScrnBuf )
	{
		sys_FreeMemoryEz( wk->itemwinScrnBuf );
	}

	if( wk->numfont )
	{
		NUMFONT_Delete( wk->numfont );
	}

	if( wk->traynameBuf )
	{
		STRBUF_Delete( wk->traynameBuf );
	}

	if( wk->bmpwin )
	{
		int i;
		for(i = 0; i < WIN_MAX; i++)
		{
			GF_BGL_BmpWinDel( &(wk->bmpwin[i]) );
		}
		sys_FreeMemoryEz( wk->bmpwin );
	}
}
//------------------------------------------------------------------
/**
 * {bNXIEBhE\Jn
 *
 * @param   wk		
 *
 */
//------------------------------------------------------------------
void BoxAppView_ExWin_JumpWinDispStart( EXWIN_VIEW_WORK* wk )
{
	wk->center_trayno = BoxAppVPara_GetJumpWinCenterTrayNumber( wk->vpara );
	TrayIconMainViewInit( wk );
	SetJumpWinEffectTask( wk, JUMPWIN_EFF_DISP );
}
//------------------------------------------------------------------
/**
 * {bNXIEBhE\I҂
 *
 * @param   wk		[N|C^
 *
 * @retval  BOOL	TRUEŏI
 */
//------------------------------------------------------------------
BOOL BoxAppView_ExWin_JumpWinDispWait( EXWIN_VIEW_WORK* wk )
{
	return WaitJumpWinEffectTask( wk );
}
//------------------------------------------------------------------
/**
 * {bNXIEBhE\XV
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
void BoxAppView_ExWin_JumpWinUpdate( EXWIN_VIEW_WORK* wk )
{
	wk->center_trayno = BoxAppVPara_GetJumpWinCenterTrayNumber( wk->vpara );

	TrayIconMainViewFormat( wk );
	TrayNameWrite( wk );
	PokeCntWrite( wk );
}
//------------------------------------------------------------------
/**
 * {bNXIEBhEJn
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
void BoxAppView_ExWin_JumpWinDelStart( EXWIN_VIEW_WORK* wk )
{
	SetJumpWinEffectTask( wk, JUMPWIN_EFF_DELETE );
}
//------------------------------------------------------------------
/**
 * {bNXIEBhEI҂
 *
 * @param   wk		[N|C^
 *
 * @retval  BOOL	TRUEŏI
 */
//------------------------------------------------------------------
BOOL BoxAppView_ExWin_JumpWinDelWait( EXWIN_VIEW_WORK* wk )
{
	return WaitJumpWinEffectTask( wk );
}

//------------------------------------------------------------------
/**
 * gCACR̃Lf[^쐬E]EvLV쐬
 *
 * @param   wk			[N|C^
 * @param   trayno		gCio[
 * @param   charpos		]Lio[
 * @param   vramType	]VRAM
 * @param   proxy		vLV쐬ϐAhX
 *
 */
//------------------------------------------------------------------
void BoxAppView_ExWin_TransTrayIconCharData( EXWIN_VIEW_WORK* wk, u32 trayno, u32 charpos, NNS_G2D_VRAM_TYPE vramType, NNSG2dImageProxy* proxy )
{
	const BOX_DATA* boxData;
	POKEMON_PASO_PARAM* ppp;
	u8 colNo;
	u32 x, y, pos, monsno;

	boxData = BoxAppVPara_GetBoxData( wk->vpara );

// ǎC[WFœhԂ
	colNo = OBJPAL_TRAYICON_WP*0x10 + BOXDAT_GetWallPaperNumber( boxData, trayno );
	GF_BGL_BmpFill256( &(wk->trayIconBmpHeader), TRAYICON_WRITE_OX, TRAYICON_WRITE_OY, 
							TRAYICON_WRITE_WIDTH, TRAYICON_WRITE_HEIGHT, colNo );

	// |PC[WFhbgł
	for( y = 0, pos = 0; y < BOX_MAX_RAW; y++ )
	{
		for( x = 0; x < BOX_MAX_COLUMN; x++ )
		{
			ppp = BOXDAT_GetPokeDataAddress( boxData, trayno, pos++ );
			monsno = PokePasoParaGet( ppp, ID_PARA_monsno, NULL );
			if( monsno )
			{
				colNo = OBJPAL_TRAYICON_POKE*0x10 + PokePersonalParaGet( monsno, ID_PER_color );
				GF_BGL_BmpFill256( &(wk->trayIconBmpHeader), TRAYICON_DOT_WRITE_OX+x*2, TRAYICON_DOT_WRITE_OY+y*2, 
							2, 2, colNo );
			}
		}
	}

	switch( vramType ){
	case NNS_G2D_VRAM_TYPE_2DMAIN:
		wk->iconCharData->mapingType = GX_GetOBJVRamModeChar();
		break;
	case NNS_G2D_VRAM_TYPE_2DSUB:
		wk->iconCharData->mapingType = GXS_GetOBJVRamModeChar();
		break;
	}

	NNS_G2dLoadImage1DMapping( wk->iconCharData, charpos*0x20, vramType, proxy );
}

//------------------------------------------------------------------
/**
 * gCACR̃Zf[^AhXԂ
 *
 * @param   wk		[N|C^
 *
 * @retval  NNSG2dCellDataBank*		Zf[^AhX
 */
//------------------------------------------------------------------
NNSG2dCellDataBank* BoxAppView_ExWin_GetTrayIconCellDataAdrs( EXWIN_VIEW_WORK* wk )
{
	return wk->iconCellData;
}











//------------------------------------------------------------------
/**
 * \擪̃gCio[
 *
 * @param   wk		[N|C^
 *
 * @retval  int		gCio[
 */
//------------------------------------------------------------------
static int DispFirstTrayNumber( EXWIN_VIEW_WORK* wk )
{
	int trayno = wk->center_trayno - ( TRAYICON_DISP_COUNT / 2 );
	if( trayno < 0 ){
		trayno += BOX_MAX_TRAY;
	}
	return trayno;
}


static void TrayIconCharStoreInit( EXWIN_VIEW_WORK* wk )
{
	int i;
	for(i=0; i<BOX_MAX_TRAY; i++)
	{
		wk->trayIconCharCreateFlag[i] = FALSE;
	}
}
static void TrayIconCharStoreSet( EXWIN_VIEW_WORK* wk, u32 trayno )
{
	MI_CpuCopy32(wk->iconCharData->pRawData, wk->trayIconCharBuf[trayno], TRAYICON_CHAR_BYTESIZE );
	DC_FlushRange( wk->trayIconCharBuf, TRAYICON_CHAR_BYTESIZE );
	wk->trayIconCharCreateFlag[trayno] = TRUE;
}

static void TrayIconCharStoreTrans( EXWIN_VIEW_WORK* wk, u32 pos, u32 trayno )
{
	u32 charpos = OBJCHAR_TRAYICON_POS+OBJCHAR_TRAYICON_SIZE*pos;

	if( wk->trayIconCharCreateFlag[trayno] )
	{
		GX_LoadOBJ( wk->trayIconCharBuf[trayno], charpos*0x20, TRAYICON_CHAR_BYTESIZE );
	}
	else
	{
		NNSG2dImageProxy proxy;

		NNS_G2dInitImageProxy( &proxy );
		BoxAppView_ExWin_TransTrayIconCharData( wk, trayno, charpos, NNS_G2D_VRAM_TYPE_2DMAIN, &proxy );
		TrayIconCharStoreSet( wk, trayno );
	}
}

//------------------------------------------------------------------
/**
 * \gCACR쐬i\͂Ȃj
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void TrayIconMainViewInit( EXWIN_VIEW_WORK* wk )
{
	CLACT_HEADER  header;
	BOX_ICON_SYS*  iconSys;
	NNSG2dImageProxy  proxy;
	int i, trayno;

	TrayIconCharStoreInit( wk );

	iconSys = BoxAppView_GetIconSysWork( wk->vwk );

	BoxAppView_SetActHeader( &header, NULL, BoxAppView_GetObjPlttProxy( wk->vwk ),
			wk->iconCellData, iconSys->anmBank, 0 );

	trayno = DispFirstTrayNumber( wk );

	for(i=0; i<TRAYICON_DISP_COUNT; i++)
	{
		NNS_G2dInitImageProxy( &proxy );
		BoxAppView_ExWin_TransTrayIconCharData( wk, trayno,
			OBJCHAR_TRAYICON_POS+OBJCHAR_TRAYICON_SIZE*i, NNS_G2D_VRAM_TYPE_2DMAIN, &proxy );
		header.pImageProxy = &proxy;
		wk->trayIconAct[i] = BoxAppView_AddActor( wk->actsys, &header,
			TRAYICON_DISP_X+i*TRAYICON_DISP_XSPC, TRAYICON_DISP_Y,
			ACTPRI_TRAY_ICON_MIN, NNS_G2D_VRAM_TYPE_2DMAIN );

		GF_ASSERT(wk->trayIconAct[i]!=NULL);
		CLACT_SetDrawFlag( wk->trayIconAct[i], FALSE );

		TrayIconCharStoreSet( wk, trayno );
		if(++trayno >= BOX_MAX_TRAY){
			trayno = 0;
		}
	}

	for(i=0; i<BOX_MAX_TRAY; i++)
	{
		wk->pokeCount[i] = BOXDAT_GetPokeExistCount( BoxAppVPara_GetBoxData(wk->vpara), i );
	}
}
//------------------------------------------------------------------
/**
 * SgCACR폜
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void TrayIconMainViewDelete( EXWIN_VIEW_WORK* wk )
{
	int i;

	for(i=0; i<TRAYICON_DISP_COUNT; i++)
	{
		if( wk->trayIconAct[i] != NULL )
		{
			CLACT_Delete( wk->trayIconAct[i] );
			wk->trayIconAct[i] = NULL;
		}
	}
}
//------------------------------------------------------------------
/**
 * ݃Z^[̃gCio[ɃgCACRE\
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void TrayIconMainViewFormat( EXWIN_VIEW_WORK* wk )
{
	int trayno, i;

	trayno = DispFirstTrayNumber( wk );

	for(i=0; i<TRAYICON_DISP_COUNT; i++)
	{
//		CLACT_SetMatrix( wk->trayIconAct[p], &vec );
//		CLACT_SetDrawFlag( wk->trayIconAct[p], TRUE );
		TrayIconCharStoreTrans( wk, i, trayno );
		CLACT_SetDrawFlag( wk->trayIconAct[i], TRUE );
		if(++trayno >= BOX_MAX_TRAY){ trayno = 0; }
	}


//	for(i=0; i < (BOX_MAX_TRAY-TRAYICON_DISP_COUNT); i++)
//	{
//		CLACT_SetDrawFlag( wk->trayIconAct[p], FALSE );
//		if(++p >= BOX_MAX_TRAY){ p = 0; }
//	}
}
//------------------------------------------------------------------
/**
 * ݃Z^[̃gC`
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void TrayNameWrite( EXWIN_VIEW_WORK* wk )
{
	const BOX_DATA* boxData;
	GF_BGL_BMPWIN* win;
	u32 strwidth, xpos;

	boxData = BoxAppVPara_GetBoxData( wk->vpara );
	win = &wk->bmpwin[WIN_TRAYNAME];

	BOXDAT_GetBoxName( boxData, wk->center_trayno, wk->traynameBuf );
	strwidth = FontProc_GetPrintStrWidth( FONT_SYSTEM, wk->traynameBuf, 0 );
	xpos = WIN_TRAYNAME_CENTER_XPOS - ( strwidth / 2 );

	GF_BGL_BmpWinDataFill( win, WIN_TRAYNAME_GROUND_COLOR );
	GF_STR_PrintColor( win, FONT_SYSTEM, wk->traynameBuf, xpos, 0, MSG_NO_PUT, 
						GF_PRINTCOLOR_MAKE( WIN_TRAYNAME_LETTER_COLOR, WIN_TRAYNAME_SHADOW_COLOR, WIN_TRAYNAME_GROUND_COLOR ),
						NULL
					);
	GF_BGL_BmpWinCgxOn( win );
}
//------------------------------------------------------------------
/**
 * gCEBhE\NA
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void TrayNameClear( EXWIN_VIEW_WORK* wk )
{
	GF_BGL_BMPWIN* win = &wk->bmpwin[WIN_TRAYNAME];
	GF_BGL_BmpWinDataFill( win, WIN_TRAYNAME_GROUND_COLOR );
	GF_BGL_BmpWinCgxOn( win );
}
//------------------------------------------------------------------
/**
 * ݃Z^[̃gCɃ|P`
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void PokeCntWrite( EXWIN_VIEW_WORK* wk )
{
	s32 p, i;
	GF_BGL_BMPWIN* win;

	win = &wk->bmpwin[WIN_POKECNT];

	GF_BGL_BmpWinDataFill( win, WIN_POKECNT_GROUND_COLOR );
	p = DispFirstTrayNumber( wk );

	for(i = 0; i < TRAYICON_DISP_COUNT; i++)
	{
		NUMFONT_WriteNumber( wk->numfont, wk->pokeCount[p], 2, NUMFONT_MODE_ZERO, win, WIN_POKECNT_WRITE_XSPC*i, 0 );
		if(++p >= BOX_MAX_TRAY){ p = 0; }
	}

	GF_BGL_BmpWinCgxOn( win );
}
//------------------------------------------------------------------
/**
 * gCEBhE\NA
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void PokeCntClear( EXWIN_VIEW_WORK* wk )
{
	GF_BGL_BMPWIN* win = &wk->bmpwin[WIN_POKECNT];
	GF_BGL_BmpWinDataFill( win, WIN_POKECNT_GROUND_COLOR );
	GF_BGL_BmpWinCgxOn( win );
}


/*====================================================================================*/
/*  ȉAEBhE̕\EGtFNg                                        */
/*====================================================================================*/


//----------------------------------------------
/**
 *  {bNXIEBhEGtFNg[N
 */
//----------------------------------------------
typedef struct {
	EXWIN_VIEW_WORK*  parentWork;
	u8  seq;
	u8  workval;
	BOOL  brightCheckFlag;
}JUMPWIN_EFFECT_WORK;

//------------------------------------------------------------------
/**
 * IEBhE\GtFNg̃^XNo^
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void SetJumpWinEffectTask( EXWIN_VIEW_WORK* wk, JUMPWIN_EFFECT_TYPE type)
{
	static const TCB_FUNC functbl[] = {
		JumpWinDispEffectTask,
		JumpWinDeleteEffectTask,
	};

	JUMPWIN_EFFECT_WORK* taskwk = sys_AllocMemory( HEAPID_BOX_VIEW, sizeof(JUMPWIN_EFFECT_WORK) );

	if( taskwk )
	{
		taskwk->parentWork = wk;
		taskwk->seq = 0;
		taskwk->workval = 0;

		// pbgR{̓]̂ŁAÔVIntrgȂ
		wk->effectTask = TCB_Add( functbl[type], taskwk, TASKPRI_VIEW_COMMAND_SUB );

		if( wk->effectTask == NULL )
		{
			sys_FreeMemoryEz( taskwk );
		}
	}
}
//------------------------------------------------------------------
/**
 * IEBhEGtFNg̃^XN폜i^XN{̂Ă΂j
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void DeleteJumpWinEffectTask( TCB_PTR tcb, void* wk_adrs )
{
	JUMPWIN_EFFECT_WORK* taskwk = (JUMPWIN_EFFECT_WORK*)wk_adrs;

	taskwk->parentWork->effectTask = NULL;
	sys_FreeMemoryEz( taskwk );
	TCB_Delete( tcb );
}
//------------------------------------------------------------------
/**
 * {bNXIEBhE\GtFNg̃^XNI҂
 *
 * @param   wk			[N|C^
 *
 * @retval  BOOL		TRUEŏI
 */
//------------------------------------------------------------------
static BOOL WaitJumpWinEffectTask( EXWIN_VIEW_WORK* wk )
{
	return (wk->effectTask == NULL);
}

//------------------------------------------------------------------
/**
 * {bNXIEBhE\GtFNg̃^XN{
 *
 * @param   tcb		
 * @param   wk_adrs		
 *
 */
//------------------------------------------------------------------
static void JumpWinDispEffectTask( TCB_PTR tcb, void* wk_adrs )
{
	JUMPWIN_EFFECT_WORK* taskwk = (JUMPWIN_EFFECT_WORK*)wk_adrs;
	EXWIN_VIEW_WORK* wk = taskwk->parentWork;

	switch( taskwk->seq ){
	// EBhÊʂƏoĂ
	case 0:
		taskwk->workval += JUMPWIN_DISPEFFECT_SPEED;

		if( (taskwk->workval*2) < JUMPWIN_HEIGHT )
		{
			// XN[`xS
			u32 cy = JUMPWIN_WRITE_YPOS+(JUMPWIN_HEIGHT/2);
			GF_BGL_ScrWrite( wk->bgl, FRM_MAIN_MESSAGE, wk->jumpwinScrnData->rawData,
						JUMPWIN_WRITE_XPOS, cy-taskwk->workval, JUMPWIN_WIDTH, taskwk->workval );

			GF_BGL_ScrWriteExpand( wk->bgl, FRM_MAIN_MESSAGE, 
						JUMPWIN_WRITE_XPOS, cy, JUMPWIN_WIDTH, taskwk->workval,
						wk->jumpwinScrnData->rawData, 0, JUMPWIN_HEIGHT-taskwk->workval,
						JUMPWIN_WIDTH, JUMPWIN_HEIGHT );
		}
		else
		{
			GF_BGL_ScrWrite( wk->bgl, FRM_MAIN_MESSAGE, wk->jumpwinScrnData->rawData,
						JUMPWIN_WRITE_XPOS, JUMPWIN_WRITE_YPOS, JUMPWIN_WIDTH, JUMPWIN_HEIGHT );
			taskwk->seq++;
		}
		GF_BGL_LoadScreenReq( wk->bgl, FRM_MAIN_MESSAGE );
		taskwk->workval = TRAYICON_FADE_MAX-1;
		break;

	case 1:
		GX_LoadOBJPltt( wk->trayIconPalBuf[taskwk->workval], OBJPAL_TRAYICON_TOP*0x20, TRAYICON_PAL_SIZE );
		TrayIconMainViewFormat( wk );
		taskwk->seq++;
		break;

	case 2:
		if( taskwk->workval ){
			taskwk->workval--;
		}
		GX_LoadOBJPltt( wk->trayIconPalBuf[taskwk->workval], OBJPAL_TRAYICON_TOP*0x20, TRAYICON_PAL_SIZE );

		if(taskwk->workval == 0 )
		{
//			GX_SetVisibleWnd( GX_WNDMASK_NONE );
			GF_BGL_BmpWinMakeScrn( &wk->bmpwin[WIN_TRAYNAME] );
			GF_BGL_BmpWinMakeScrn( &wk->bmpwin[WIN_POKECNT] );
			TrayNameWrite( wk );
			PokeCntWrite( wk );
			GF_BGL_LoadScreenReq( wk->bgl, FRM_MAIN_MESSAGE );
			taskwk->seq++;
		}
		break;

	case 3:
		DeleteJumpWinEffectTask( tcb, taskwk );
		break;
	}
}
//------------------------------------------------------------------
/**
 * {bNXIEBhEGtFNg̃^XN{
 *
 * @param   tcb		
 * @param   wk_adrs		
 *
 */
//------------------------------------------------------------------
static void JumpWinDeleteEffectTask( TCB_PTR tcb, void* wk_adrs )
{
	JUMPWIN_EFFECT_WORK* taskwk = (JUMPWIN_EFFECT_WORK*)wk_adrs;
	EXWIN_VIEW_WORK* wk = taskwk->parentWork;

	switch( taskwk->seq ){
	case 0:
		TrayIconMainViewDelete( wk );
		TrayNameClear( wk );
		PokeCntClear( wk );
		taskwk->seq++;
		break;

	case 1:
		GF_BGL_ScrFill( wk->bgl, FRM_MAIN_MESSAGE, 0x0000, JUMPWIN_WRITE_XPOS, JUMPWIN_WRITE_YPOS,
				JUMPWIN_WIDTH, JUMPWIN_HEIGHT, GF_BGL_SCRWRT_PALIN );

		taskwk->workval += JUMPWIN_DISPEFFECT_SPEED;
		if( (taskwk->workval*2) < JUMPWIN_HEIGHT )
		{
			// XN[`xS
			u32 cy = JUMPWIN_WRITE_YPOS+(JUMPWIN_HEIGHT/2);
			GF_BGL_ScrWrite( wk->bgl, FRM_MAIN_MESSAGE, wk->jumpwinScrnData->rawData,
						JUMPWIN_WRITE_XPOS, JUMPWIN_WRITE_YPOS+taskwk->workval,
						JUMPWIN_WIDTH, (JUMPWIN_HEIGHT/2) - taskwk->workval );

			GF_BGL_ScrWriteExpand( wk->bgl, FRM_MAIN_MESSAGE, 
						JUMPWIN_WRITE_XPOS, cy, JUMPWIN_WIDTH, (JUMPWIN_HEIGHT/2) - taskwk->workval,
						wk->jumpwinScrnData->rawData, 0, JUMPWIN_HEIGHT-taskwk->workval,
						JUMPWIN_WIDTH, JUMPWIN_HEIGHT );
		}
		else
		{
			taskwk->seq++;
		}
		GF_BGL_LoadScreenReq( wk->bgl, FRM_MAIN_MESSAGE );
		break;

	case 2:
		DeleteJumpWinEffectTask( tcb, taskwk );
	}
}
