//============================================================================================
/**
 * @file	boxv_tray.c
 * @brief	{bNXʁ@`扺igC֘Aj
 * @author	taya
 * @date	2005.09.09
 */
//============================================================================================
#include  "common.h"
#include  "system\arc_util.h"
#include  "system\fontproc.h"
#include  "system\brightness.h"
#include  "poketool\pokeicon.h"

#include  "box_arc.h"
#include  "box_view.h"
#include  "box_common.h"

#define TRAY_CHAR_WIDTH		(21)		///< gCP̉L
#define TRAY_CHAR_HEIGHT	(20)		///< gCP̏cL
#define TRAY_WRITE_XPOS		(11)		///< gC`JnwWiʒuj
#define TRAY_WRITE_YPOS		(0)			///< gC`JnxWiʒuj
#define TRAY_WRITE_XMARGIN	(2)			///< gC`wԊuiLPʁj

#define TRAY_CHAR_SIZE		(TRAY_CHAR_WIDTH*TRAY_CHAR_HEIGHT)
#define TRAY_WRITE_DIFF		(TRAY_CHAR_WIDTH + TRAY_WRITE_XMARGIN)

#define TRAY_SCROLL_LEN		(TRAY_WRITE_DIFF*8)			///< XN[ʁihbgj
#define TRAY_SCROLL_WAIT	BOX_TIMER(15)				///< XN[ԁit[j
#define TRAY_FX_SHIFT		(8)
#define TRAY_FX_MASK		(0x1ff)

#define TRAY_NCG_WIDTH		(24)
#define TRAY_NCG_TAB_HEIGHT	(3)
#define TRAYNAME_WRITE_CENTER_X		(68)	// {bNXNCGf[^ɒڕ`
#define TRAYNAME_WRITE_YPOS			(5)		/// [[[COł͒̕Kv邩]]]
#define TRAYNAME_FONTTYPE	(FONT_SYSTEM)

#define ICON_VISIBLE_MIN	(72)
#define ICON_VISIBLE_MAX	(256+16)

#define TRAY_BG_HOFS_MASK	(REG_G2_BG3HOFS_OFFSET_MASK)	// 0x1ff ł

#define WPCHANGE_FADE_TIME	(15)	// PxύX30fpsŒɂĂ̂BOX_TIMER}NgȂ

#define TRAY_SPACE_CHARNO	(24)

//--------------------------------------------------------------
/**
 * ǎ摜̃A[JCuCfbNXe[u
 */
//--------------------------------------------------------------
static const struct {
	u8  nscr;
	u8  ncgr;
	u8  nclr;
}WallPaperArcID[] = {

	{ NARC_box_wp01_lz_nscr, NARC_box_wp01_lz_ncgr, NARC_box_wp01_nclr },
	{ NARC_box_wp02_lz_nscr, NARC_box_wp02_lz_ncgr, NARC_box_wp02_nclr },
	{ NARC_box_wp03_lz_nscr, NARC_box_wp03_lz_ncgr, NARC_box_wp03_nclr },
	{ NARC_box_wp04_lz_nscr, NARC_box_wp04_lz_ncgr, NARC_box_wp04_nclr },
	{ NARC_box_wp05_lz_nscr, NARC_box_wp05_lz_ncgr, NARC_box_wp05_nclr },
	{ NARC_box_wp06_lz_nscr, NARC_box_wp06_lz_ncgr, NARC_box_wp06_nclr },
	{ NARC_box_wp07_lz_nscr, NARC_box_wp07_lz_ncgr, NARC_box_wp07_nclr },
	{ NARC_box_wp08_lz_nscr, NARC_box_wp08_lz_ncgr, NARC_box_wp08_nclr },
	{ NARC_box_wp09_lz_nscr, NARC_box_wp09_lz_ncgr, NARC_box_wp09_nclr },
	{ NARC_box_wp10_lz_nscr, NARC_box_wp10_lz_ncgr, NARC_box_wp10_nclr },
	{ NARC_box_wp11_lz_nscr, NARC_box_wp11_lz_ncgr, NARC_box_wp11_nclr },
	{ NARC_box_wp12_lz_nscr, NARC_box_wp12_lz_ncgr, NARC_box_wp12_nclr },
	{ NARC_box_wp13_lz_nscr, NARC_box_wp13_lz_ncgr, NARC_box_wp13_nclr },
	{ NARC_box_wp14_lz_nscr, NARC_box_wp14_lz_ncgr, NARC_box_wp14_nclr },
	{ NARC_box_wp15_lz_nscr, NARC_box_wp15_lz_ncgr, NARC_box_wp15_nclr },
	{ NARC_box_wp16_lz_nscr, NARC_box_wp16_lz_ncgr, NARC_box_wp16_nclr },

};

//==============================================================
// Prototype
//==============================================================
static void TrayScrollTask( TCB_PTR tcb, void* wk_adrs );
static void TrayScrollVintrTask( TCB_PTR tcb, void* wk_adrs );
static void SetScrollIconPos( TRAY_VIEW_WORK* wk, fx32 scrollValue, s32 xofs );
static void AddScrollIconPos( TRAY_VIEW_WORK* wk, fx32 scrollValue );
static void AddScrollLineIcon( TRAY_VIEW_WORK* wk, BOX_ICON_WORK* iconwk, int xpos, int column );
static void DelScrollLineIcon( TRAY_VIEW_WORK* wk, BOX_ICON_WORK* iconwk, int column );
static void ReadIconCharData( TRAY_VIEW_WORK* wk, u32 trayno );
static u32 GetIconActorPri( u32 pos );
static void AddTrayIcon( TRAY_VIEW_WORK* wk, BOX_ICON_SYS* iconSys, u32 box, u32 vramPos, s32 xofs, BOX_ICON_WORK* icon );
static void IconScrollOut( TRAY_VIEW_WORK* wk, BOX_ICON_WORK* icon, u32 vcnt );
static void IconScrollIn( TRAY_VIEW_WORK* wk, BOX_ICON_WORK* icon, u32 vcnt );
static void IconScrollEnd( TRAY_VIEW_WORK* wk, BOX_ICON_WORK* icon );
static void TrayScrnWrite( u16* dst, const u16* src, u32 xpos, u32 charOfs, u32 palPos );


//==============================================================================================================
// CW[Ă΂鏉EI֘A
//==============================================================================================================

//------------------------------------------------------------------
/**
 * 
 *
 * @param   wk			
 * @param   vpara		
 * @param   bgl			
 * @param   actsys		
 *
 * @retval  BOOL		TRUEŐ
 */
//------------------------------------------------------------------
BOOL BoxAppView_TrayInit( TRAY_VIEW_WORK* wk, BOXAPP_VIEW_WORK* vwk, const BOXAPP_VPARAM* vpara, GF_BGL_INI* bgl, CLACT_SET_PTR actsys )
{
	extern void GF_BGL_GGFLG_Set(void);
	wk->trayNum = vpara->tray.number;
	wk->scrnPos = TRAY_WRITE_XPOS;
	wk->imgPos = 0;


	wk->scrollXofs = BoxAppView_GetTrayScrollOfs( vwk );
	wk->iconVisibleXmin = ICON_VISIBLE_MIN + wk->scrollXofs;
	wk->iconVisibleXmax = ICON_VISIBLE_MAX + wk->scrollXofs;

	wk->iconSys = BoxAppView_GetIconSysWork( vwk );
	BoxAppView_IconWorkInit( wk->iconSys, wk->icon[0], BOX_MAX_POS );
	BoxAppView_IconWorkInit( wk->iconSys, wk->icon[1], BOX_MAX_POS );

	wk->bgl = bgl;
	wk->vpara = vpara;
	wk->vwk = vwk;

	return TRUE;
}

//------------------------------------------------------------------
/**
 * I
 *
 * @param   wk		
 *
 */
//------------------------------------------------------------------
void BoxAppView_TrayQuit( TRAY_VIEW_WORK* wk )
{
	BoxAppView_IconWorkQuit( wk->iconSys, wk->icon[0], BOX_MAX_POS );
	BoxAppView_IconWorkQuit( wk->iconSys, wk->icon[1], BOX_MAX_POS );
}


//==============================================================================================================
// CW[Ă΂R}h֐Q
//==============================================================================================================

//------------------------------------------------------------------
/**
 * 
 *
 * @param   wk		
 *
 */
//------------------------------------------------------------------
void BoxAppView_TraySetScroll( TRAY_VIEW_WORK* wk )
{
	wk->scrollSetPos = GF_BGL_ScrollGetX(wk->bgl, FRM_MAIN_TRAY);
	wk->scrollSetPos -= wk->scrollXofs;
	wk->scrollSetPos &= TRAY_BG_HOFS_MASK;
	GF_BGL_ScrollSet( wk->bgl, FRM_MAIN_TRAY, GF_BGL_SCROLL_X_SET, wk->scrollSetPos );
}

//------------------------------------------------------------------------------
/**
 * gCǎOtBbNVRAM]
 *
 * @param   wk				gC`惏[N
 * @param   trayParam		ǎio[
 * @param   pos				]ʒui0:ݕ\ 1:E -1:ׁj
 * @param   iconWriteFlag	ACR`悷邩
 *
 */
//------------------------------------------------------------------------------
void BoxAppView_TrayWrite( TRAY_VIEW_WORK* wk, const BOXAPP_TRAY* trayParam, int pos, BOOL iconWriteFlag )
{
	static const u16 PalettePosTbl[] = {
		PAL_MAIN_WALLPAPER_A,
		PAL_MAIN_WALLPAPER_B,
	};

	u32 charOfs, palPos, scrnPos, iconPos;
	void* scrnSrc;
	void* charSrc;

	if( pos != 0 ){
		charOfs = (wk->imgPos^1) * TRAY_CHAR_SIZE;
		palPos = PalettePosTbl[ wk->imgPos^1 ];
		scrnPos = (wk->scrnPos + (pos * TRAY_WRITE_DIFF)) & 63;
		iconPos = wk->imgPos ^ 1;
	}else{
		charOfs = wk->imgPos * TRAY_CHAR_SIZE;
		palPos = PalettePosTbl[ wk->imgPos ];;
		scrnPos = wk->scrnPos;
		iconPos = wk->imgPos;
	}

	// pbgf[^͂Ȃ]
	ArcUtil_PalSet(ARC_BOX_GRA, WallPaperArcID[trayParam->wallPaper].nclr, PALTYPE_MAIN_BG, palPos*0x20, 0x20, HEAPID_BOX_VIEW);

	// Lf[^͓ǂݍ񂾂BitmapWin@\găgC`݁A]
	charSrc = ArcUtil_Load(ARC_BOX_GRA, WallPaperArcID[trayParam->wallPaper].ncgr, TRUE, HEAPID_BOX_VIEW, ALLOC_BOTTOM);
	if( charSrc != NULL ){
		NNSG2dCharacterData* charData;

		if( NNS_G2dGetUnpackedBGCharacterData( charSrc, &charData ) )
		{
			GF_BGL_BMPWIN* win;

			win = GF_BGL_BmpWinAllocGet(HEAPID_BOX_VIEW, 1);
			if( win )
			{
				u32 xpos, strwidth;

				win->ini = wk->bgl;
				win->sizx = TRAY_NCG_WIDTH;
				win->sizy = TRAY_NCG_TAB_HEIGHT;
				win->chrbuf = charData->pRawData;

				strwidth = FontProc_GetPrintStrWidth( TRAYNAME_FONTTYPE, trayParam->name, 0 );
				xpos = TRAYNAME_WRITE_CENTER_X - ( strwidth / 2 );

				GF_STR_PrintColor( win, FONT_SYSTEM, trayParam->name, xpos, TRAYNAME_WRITE_YPOS, MSG_NO_PUT,
						GF_PRINTCOLOR_MAKE(1,2,0), NULL );

				sys_FreeMemoryEz( win );
			}
			GF_BGL_LoadCharacter(wk->bgl, FRM_MAIN_TRAY, charData->pRawData, charData->szByte, charOfs);
		}
		sys_FreeMemoryEz( charSrc );
	}

	// XN[f[^͓ǂݍ񂾌ALpbgʒuɉďē]
	scrnSrc = ArcUtil_Load(ARC_BOX_GRA, WallPaperArcID[trayParam->wallPaper].nscr, TRUE, HEAPID_BOX_VIEW, ALLOC_BOTTOM);
	if( scrnSrc )
	{
		u16 *scrnDst;
		NNSG2dScreenData* scrnData;

		NNS_G2dGetUnpackedScreenData( scrnSrc, &scrnData );
		scrnDst = GF_BGL_ScreenAdrsGet( wk->bgl, FRM_MAIN_TRAY );

		if(scrnDst)
		{
			TrayScrnWrite( scrnDst, (const u16*)(scrnData->rawData), scrnPos, charOfs, palPos );
		}
		sys_FreeMemoryEz(scrnSrc);

		GF_BGL_LoadScreen( wk->bgl, FRM_MAIN_TRAY, scrnDst, 0x1000, 0 );
	}

	if( iconWriteFlag )
	{
		// \gCɂ͕ʂɑS`悷
		if( pos == 0 )
		{
			AddTrayIcon( wk, wk->iconSys, trayParam->number, iconPos, pos*TRAY_SCROLL_LEN, wk->icon[iconPos] );
		}
	}
}
//------------------------------------------------------------------------------
/**
 * gCXN[Jn
 *
 * @param   wk			gC`惏[N
 * @param   direction	i1:E -1:ցj
 *
 */
//------------------------------------------------------------------------------
void BoxAppView_TrayScrollSet( TRAY_VIEW_WORK* wk, const BOXAPP_TRAY* trayParam, int direction )
{
	wk->scrollPos = (GF_BGL_ScrollGetX(wk->bgl, FRM_MAIN_TRAY) & TRAY_BG_HOFS_MASK) << FX32_SHIFT;;
	wk->scrollEndPos = wk->scrollPos + ((TRAY_SCROLL_LEN * direction) << FX32_SHIFT);
	wk->scrollValue = (wk->scrollEndPos - wk->scrollPos) / TRAY_SCROLL_WAIT;
	wk->scrollEndPos >>= FX32_SHIFT;
	wk->scrollEndPos &= TRAY_BG_HOFS_MASK;
	wk->scrollWait = TRAY_SCROLL_WAIT;
	wk->scrollOutIcon = wk->imgPos;

	OS_TPrintf("[spos] = %d\n", wk->scrollSetPos);

	// XN[͉摜]ʒuς
	wk->scrnPos += (TRAY_WRITE_DIFF * direction);
	wk->scrnPos &= 63;
	wk->imgPos ^= 1;

	{
		ReadIconCharData( wk, trayParam->number );
		SetScrollIconPos( wk, wk->scrollValue, direction * TRAY_SCROLL_LEN );
		wk->scrollInTrayNumber = trayParam->number;
		wk->scrollInIconVramPos = wk->imgPos;
	}

	wk->scrollIconVcnt = 1;
	wk->scrollEndFlag = FALSE;


	TCB_Add( TrayScrollTask, wk, TASKPRI_VIEW_COMMAND_SUB );
	BoxAppView_VTaskAdd( TrayScrollVintrTask, wk, TASKPRI_V_MAIN );
}
//------------------------------------------------------------------------------
/**
 * gCXN[I҂
 *
 * @param   wk			gC`惏[N
 *
 * @retval  BOOL		TRUEŏI
 */
//------------------------------------------------------------------------------
BOOL BoxAppView_TrayScrollWait( TRAY_VIEW_WORK* wk )
{
	return wk->scrollEndFlag;
}

//------------------------------------------------------------------
/**
 * gCXN[C^XN
 *
 * @param   tcb			
 * @param   wk_adrs		
 *
 */
//------------------------------------------------------------------
static void TrayScrollTask( TCB_PTR tcb, void* wk_adrs )
{
	TRAY_VIEW_WORK* wk = (TRAY_VIEW_WORK*)wk_adrs;

	if( wk->scrollWait )
	{
		if( wk->scrollIconVcnt == 2 )
		{
			AddScrollIconPos( wk, wk->scrollValue );
			wk->scrollIconVcnt = 0;
		}
		return;
	}
	wk->scrollSetPos = wk->scrollEndPos;
	wk->trayNum = BoxAppVPara_GetTrayBoxNumber( wk->vpara );
	TCB_Delete( tcb );
	wk->scrollEndFlag = TRUE;

}

//------------------------------------------------------------------
/**
 * gCXN[VBlank^XN
 *
 * @param   tcb		
 * @param   wk_adrs		
 *
 */
//------------------------------------------------------------------
static void TrayScrollVintrTask( TCB_PTR tcb, void* wk_adrs )
{
	TRAY_VIEW_WORK* wk = (TRAY_VIEW_WORK*)wk_adrs;
	u32 out, in;

	out = wk->scrollOutIcon;
	in = out ^ 1;

	if( wk->scrollWait )
	{
		if( wk->scrollIconVcnt < 2 )
		{
			IconScrollOut( wk, wk->icon[out], wk->scrollIconVcnt );
			IconScrollIn( wk, wk->icon[in], wk->scrollIconVcnt );
			wk->scrollIconVcnt++;

			wk->scrollSetPos = (wk->scrollPos >> FX32_SHIFT) & TRAY_BG_HOFS_MASK;
			OS_TPrintf("pos = %d\n", wk->scrollSetPos);
			wk->scrollPos += wk->scrollValue;
			GF_BGL_ScrollSet( wk->bgl, FRM_MAIN_TRAY, GF_BGL_SCROLL_X_SET, wk->scrollSetPos );

			wk->scrollWait--;
		}
	}
	else
	{
		OS_TPrintf("[epos] = %d\n", wk->scrollEndPos);
		GF_BGL_ScrollSet( wk->bgl, FRM_MAIN_TRAY, GF_BGL_SCROLL_X_SET, wk->scrollEndPos );
		IconScrollEnd( wk, wk->icon[in] );
		TCB_Delete( tcb );
	}
}


//------------------------------------------------------------------
/**
 * XN[ACR̈ʒû݌vZă[Nɕۑ
 *
 * @param   wk			[N|C^
 * @param   xofs		`wWItZbg
 *
 */
//------------------------------------------------------------------
static void SetScrollIconPos( TRAY_VIEW_WORK* wk, fx32 scrollValue, s32 xofs )
{
	int x, intX;

	for( x = 0; x < BOX_MAX_COLUMN; x++ )
	{
		wk->scrollOutIconXpos[0][x] = (ICON_TRAY_XORG + wk->scrollXofs + ICON_TRAY_XSPC * x) * FX32_ONE;
		wk->scrollOutIconXpos[1][x] = wk->scrollOutIconXpos[0][x] - scrollValue;

		wk->scrollInIconXpos[0][x] = (ICON_TRAY_XORG + wk->scrollXofs + ICON_TRAY_XSPC * x + xofs) * FX32_ONE;
		wk->scrollInIconXpos[1][x] = wk->scrollInIconXpos[0][x] - scrollValue;

		intX = wk->scrollInIconXpos[1][x] >> FX32_SHIFT;
		if(intX > wk->iconVisibleXmin && intX < wk->iconVisibleXmax)
		{
			int in = wk->scrollOutIcon ^ 1;
			AddScrollLineIcon( wk, wk->icon[in], intX, x );
		}
	}
}

static void AddScrollIconPos( TRAY_VIEW_WORK* wk, fx32 scrollValue )
{
	int x, intX, in, out;

	out = wk->scrollOutIcon;
	in = out ^ 1;

	for( x = 0; x < BOX_MAX_COLUMN; x++ )
	{
		// Ot[ŕ\͈͊OɏĂACR͍폜
		intX = wk->scrollOutIconXpos[1][x] >> FX32_SHIFT;
		if(intX <= wk->iconVisibleXmin || intX >= wk->iconVisibleXmax)
		{
			DelScrollLineIcon( wk, wk->icon[out], x );
		}

		wk->scrollOutIconXpos[0][x] = wk->scrollOutIconXpos[1][x] - scrollValue;
		wk->scrollOutIconXpos[1][x] = wk->scrollOutIconXpos[0][x] - scrollValue;

		wk->scrollInIconXpos[0][x] = wk->scrollInIconXpos[1][x] - scrollValue;
		wk->scrollInIconXpos[1][x] = wk->scrollInIconXpos[0][x] - scrollValue;

		intX = wk->scrollInIconXpos[1][x] >> FX32_SHIFT;
		if(intX > wk->iconVisibleXmin && intX < wk->iconVisibleXmax)
		{
			AddScrollLineIcon( wk, wk->icon[in], intX, x );
		}
	}
}


static void AddScrollLineIcon( TRAY_VIEW_WORK* wk, BOX_ICON_WORK* iconwk, int xpos, int column )
{
	const BOX_DATA* boxData;
	POKEMON_PASO_PARAM* ppp;
	int y, pos;
	u32 charno;

	boxData = BoxAppVPara_GetBoxData( wk->vpara );
	charno = (OBJCHAR_TRAY_ICON_POS + (wk->scrollInIconVramPos * OBJCHAR_TRAY_ICON_HALF_SIZE)) + column * BOXICON_CHAR_SIZE;
	iconwk += column;
	pos = column;

	for( y = 0; y < BOX_MAX_RAW; y++)
	{
		if( iconwk->act == NULL )
		{
			ppp = BOXDAT_GetPokeDataAddress( boxData, wk->scrollInTrayNumber, pos );
			if( PokePasoParaGet(ppp, ID_PARA_poke_exist, NULL) )
			{
				BoxAppView_IconAddCharSet( wk->iconSys, ppp, wk->iconMonsNo[pos], wk->iconArcIdx[pos], wk->iconCharBuf[pos],
						xpos,
						ICON_TRAY_YORG + ICON_TRAY_YSPC * y,
						BGPRI_TRAY_ICON, GetIconActorPri(pos), charno, 
						iconwk
				);
			}
		}
		charno += (BOX_MAX_COLUMN*BOXICON_CHAR_SIZE);
		iconwk += BOX_MAX_COLUMN;
		pos += BOX_MAX_COLUMN;
	}
}

static void DelScrollLineIcon( TRAY_VIEW_WORK* wk, BOX_ICON_WORK* iconwk, int column )
{
	int y;

	iconwk += column;

	for( y = 0; y < BOX_MAX_RAW; y++)
	{
		if(iconwk->act != NULL)
		{
			CLACT_Delete( iconwk->act );
			iconwk->act = NULL;
		}
		iconwk += BOX_MAX_COLUMN;
	}

}

static void ReadIconCharData( TRAY_VIEW_WORK* wk, u32 trayno )
{
	const BOX_DATA* boxData;
	POKEMON_PASO_PARAM* ppp;
	u32 pos, monsno;

	boxData = BoxAppVPara_GetBoxData( wk->vpara );

	for( pos = 0; pos < BOX_MAX_POS; pos++ )
	{
		ppp = BOXDAT_GetPokeDataAddress( boxData, trayno, pos );
		monsno = PokePasoParaGet( ppp, ID_PARA_monsno, NULL );
		if( monsno )
		{
			wk->iconMonsNo[pos] = monsno;
			wk->iconArcIdx[pos] = PokeIconCgxArcIndexGet( ppp );
			BoxAppView_IconCharDataLoad( wk->iconSys, wk->iconCharBuf[pos], wk->iconArcIdx[pos], BOXICON_CHARBUF_SIZE );
//			ArchiveDataLoadOfs( wk->iconCharBuf[pos], ARC_POKEICON, wk->iconArcIdx[pos], 0, BOXICON_CHARBUF_SIZE );
		}
	} 
}


//------------------------------------------------------------------------------
/**
 * ǎύXJn
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------------------
void BoxAppView_TrayChangeWallPaperStart( TRAY_VIEW_WORK* wk )
{
	wk->wpseq = 0;

	BrightnessChgInit();

	ChangeBrightnessRequest( WPCHANGE_FADE_TIME, BRIGHTNESS_WHITE, BRIGHTNESS_NORMAL,
		PLANEMASK_BG3, MASK_MAIN_DISPLAY );
}
//------------------------------------------------------------------------------
/**
 * ǎύXI҂
 *
 * @param   wk			[N|C^
 *
 * @retval  BOOL		TRUEŏI
 */
//------------------------------------------------------------------------------
BOOL BoxAppView_TrayChangeWallPaperWait( TRAY_VIEW_WORK* wk )
{
	switch( wk->wpseq ){
	case 0:
		if( IsFinishedBrightnessChg(MASK_MAIN_DISPLAY) )
		{
			BoxAppView_TrayWrite( wk, BoxAppVpara_GetTrayData( wk->vpara ), 0, FALSE );
			wk->wpseq++;
		}
		break;
	case 1:
		BrightnessChgInit();
		ChangeBrightnessRequest( WPCHANGE_FADE_TIME, BRIGHTNESS_NORMAL, BRIGHTNESS_WHITE,
			PLANEMASK_BG3, MASK_MAIN_DISPLAY );
		wk->wpseq++;
		break;
	case 2:
		if( IsFinishedBrightnessChg(MASK_MAIN_DISPLAY) )
		{
			wk->wpseq++;
			return TRUE;
		}
		break;
	default:
		return TRUE;
	}
	return FALSE;
}

//------------------------------------------------------------------------------
/**
 * JgfBNg̎wʒuACRf[^obt@Ɉړ
 *
 * @param   wk		[N|C^
 * @param   pos		{bNẌʒu
 * @param   charpos	VLf[^]ï擪̃LPʃItZbgj^}CiXȂ炻̂܂܂ɂ
 * @param   dst		ACRf[^ړ
 *
 */
//------------------------------------------------------------------------------
void BoxAppView_TrayMoveIconData( TRAY_VIEW_WORK* wk, u32 pos, s32 charpos, BOX_ICON_WORK* dst )
{
	BoxAppView_IconWorkCopy( &wk->icon[wk->imgPos][pos], dst, 1 );
	BoxAppView_Icon_ResetImageBank( wk->iconSys, dst, charpos );
	BoxAppView_IconWorkInit( wk->iconSys, &wk->icon[wk->imgPos][pos], 1 );
}
//------------------------------------------------------------------------------
/**
 * ACRf[^Jg̎wʒuobt@Ɉړ
 *
 * @param   wk		
 * @param   pos		
 * @param   dst		
 *
 */
//------------------------------------------------------------------------------
void BoxAppView_TrayPutIconData( TRAY_VIEW_WORK* wk, u32 pos, const BOX_ICON_WORK* srcIcon )
{
	u32 charpos;
	BOX_ICON_WORK* dstIcon;

	charpos = OBJCHAR_TRAY_ICON_POS + (wk->imgPos * OBJCHAR_TRAY_ICON_HALF_SIZE) + (BOXICON_CHAR_SIZE * pos);
	dstIcon = &wk->icon[wk->imgPos][pos];
	BoxAppView_IconWorkCopy( srcIcon, dstIcon, 1 );
	BoxAppView_IconAreaSelectPalSet( wk->iconSys, dstIcon, FALSE );
	BoxAppView_Icon_ResetImageBank( wk->iconSys, dstIcon, charpos );
	CLACT_DrawPriorityChg( dstIcon->act, GetIconActorPri(pos) );
}
//------------------------------------------------------------------------------
/**
 * JgwʒũACRf[^|C^Ԃ
 *
 * @param   wk		
 * @param   pos		
 * @param   dst		
 *
 */
//------------------------------------------------------------------------------
BOX_ICON_WORK* BoxAppView_TrayGetIconData( TRAY_VIEW_WORK* wk, u32 pos )
{
	return &wk->icon[wk->imgPos][pos];
}

//------------------------------------------------------------------------------
/**
 * ݂̃Jg{bNXf[^ĐVǉꂽ|P̃ACR
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------------------
void BoxAppView_TrayUpdateIcon( TRAY_VIEW_WORK* wk )
{
	int i, current;
	POKEMON_PASO_PARAM* ppp;

	current = BOXDAT_GetCureentTrayNumber( wk->vpara->boxData );

	for(i=0; i<BOX_MAX_POS; i++)
	{
		ppp = BOXDAT_GetPokeDataAddress( wk->vpara->boxData, current, i );
		if( PokePasoParaGet( ppp, ID_PARA_poke_exist, NULL ) )
		{
			if(wk->icon[wk->imgPos][i].act == NULL)
			{
				int x, y, charpos;

				y = i / BOX_MAX_COLUMN;
				x = i % BOX_MAX_COLUMN;
				charpos = (OBJCHAR_TRAY_ICON_POS + (wk->imgPos * OBJCHAR_TRAY_ICON_HALF_SIZE))
						+ (BOXICON_CHAR_SIZE*i);

				BoxAppView_IconAdd( wk->iconSys, ppp,
						ICON_TRAY_XORG + wk->scrollXofs + ICON_TRAY_XSPC * x,
						ICON_TRAY_YORG + ICON_TRAY_YSPC * y,
						BGPRI_TRAY_ICON, GetIconActorPri(i), charpos, 
						&(wk->icon[wk->imgPos][i])
				);
			}
		}
	}
}

//------------------------------------------------------------------
/**
 * gC̈ʒuACRAN^[̃vCIeBԂ
 *
 * @param   pos		gCʒu
 *
 * @retval  u32		AN^[vCIeB
 */
//------------------------------------------------------------------
static u32 GetIconActorPri( u32 pos )
{
	static const u16 pri[BOX_MAX_POS] = {
		 5, 4, 3, 2, 1, 0,
		11,10, 9, 8, 7, 6,
		17,16,15,14,13,12,
		23,22,21,20,19,18,
		29,28,27,26,25,24,
	};

	return ACTPRI_TRAY_ICON_MIN + pri[pos];
}
//------------------------------------------------------------------------------
/**
 * w{bNXACRS`
 *
 * @param   wk			[N|C^
 * @param   iconSys		ACRVXe|C^
 * @param   box			{bNXio[
 * @param   vramPos		ncgf[^̓]VRAMi0 or 1j
 * @param   xofs		`wWItZbg
 * @param   icon		ACR쐬惏[N|C^iP{bNXȏ̔zIj
 *
 */
//------------------------------------------------------------------------------
static void AddTrayIcon( TRAY_VIEW_WORK* wk, BOX_ICON_SYS* iconSys, u32 box, u32 vramPos, s32 xofs, BOX_ICON_WORK* icon )
{
	POKEMON_PASO_PARAM* ppp;
	u32 monsno, x, y, pos, charpos;
	u64 timePara, timeIcon;

	charpos = (OBJCHAR_TRAY_ICON_POS + (vramPos * OBJCHAR_TRAY_ICON_HALF_SIZE));
	pos = 0;

	for( y = 0; y < BOX_MAX_RAW; y++ )
	{
		for( x = 0; x < BOX_MAX_COLUMN; x++ )
		{
			ppp = BOXDAT_GetPokeDataAddress( iconSys->vpara->boxData, box, pos );
			monsno = PokePasoParaGet( (POKEMON_PASO_PARAM*)ppp, ID_PARA_monsno, NULL );
			if( monsno != 0 )
			{
				BoxAppView_IconAdd( iconSys, ppp,
						ICON_TRAY_XORG + wk->scrollXofs + ICON_TRAY_XSPC * x + xofs,
						ICON_TRAY_YORG + ICON_TRAY_YSPC * y,
						BGPRI_TRAY_ICON, GetIconActorPri(pos), charpos, 
						icon
				);
			}
			icon++;
			pos++;
			charpos += BOXICON_CHAR_SIZE;
		}
	}
}


//------------------------------------------------------------------
/**
 * ACRXN[iʂočsj
 *
 * @param   val			XN[ړ
 * @param   icon		ACR[N
 *
 */
//------------------------------------------------------------------
static void IconScrollOut( TRAY_VIEW_WORK* wk, BOX_ICON_WORK* icon, u32 vcnt )
{
	VecFx32 vector;
	int x, y;

	for( y = 0; y < BOX_MAX_RAW; y++ )
	{
		for(x = 0; x < BOX_MAX_COLUMN; x++)
		{
			if( icon->act != NULL )
			{
				vector = *(CLACT_GetMatrix(icon->act));
				vector.x = wk->scrollOutIconXpos[vcnt][x];
				CLACT_SetMatrix(icon->act, &vector);
			}
			icon++;
		}
	}
}
//------------------------------------------------------------------
/**
 * ACRXN[iʂɓĂj
 *
 * @param   val			XN[ړ
 * @param   icon		ACR[N
 *
 */
//------------------------------------------------------------------
static void IconScrollIn( TRAY_VIEW_WORK* wk, BOX_ICON_WORK* icon, u32 vcnt )
{
	VecFx32 vector;
	int x, y;

	for( y = 0; y < BOX_MAX_RAW; y++ )
	{
		for(x = 0; x < BOX_MAX_COLUMN; x++)
		{
			if( icon->act != NULL )
			{
				vector = *(CLACT_GetMatrix(icon->act));
				vector.x = wk->scrollInIconXpos[vcnt][x];
				CLACT_SetMatrix(icon->act, &vector);
			}
			icon++;
		}
	}
}
//------------------------------------------------------------------
/**
 * ACRXN[̈ʒuɐ
 *
 * @param   icon		ACR[N
 *
 */
//------------------------------------------------------------------
static void IconScrollEnd( TRAY_VIEW_WORK* wk, BOX_ICON_WORK* icon )
{
	VecFx32 vector;
	int x, y, i;

	vector.z = 0;
	for(y = 0; y < BOX_MAX_RAW; y++)
	{
		vector.y = (ICON_TRAY_YORG + y * ICON_TRAY_YSPC) * FX32_ONE;

		for(x = 0; x < BOX_MAX_COLUMN; x++)
		{
			vector.x = (ICON_TRAY_XORG + wk->scrollXofs + x * ICON_TRAY_XSPC) * FX32_ONE;
			if( icon->act != NULL )
			{
				CLACT_SetMatrix(icon->act, &vector);
			}
			icon++;
		}
		
	}
}
//------------------------------------------------------------------
/**
 * wǎXN[`
 *
 * @param   dst			`XN[obt@
 * @param   src			`挳XN[f[^
 * @param   xpos		oJnw
 * @param   charOfs		Lio[擪
 * @param   palPos		pbgio[
 *
 */
//------------------------------------------------------------------
static void TrayScrnWrite( u16* dst, const u16* src, u32 xpos, u32 charOfs, u32 palPos )
{
	enum {
		SCRN_BANK_ELEMS = 1024,	// PoN1024LȂ̂
		SCRN_LINE_ELEMS = 32,
	};
	u32 x, y;
	u16* dst_row;
	u16 scrn;

	if( xpos >= 32 )
	{
		dst += SCRN_BANK_ELEMS;
	}

	for(x = 0; x < TRAY_CHAR_WIDTH; x++)
	{
		dst_row = dst + ((SCRN_LINE_ELEMS*TRAY_WRITE_YPOS) + (xpos&31));
		for(y = 0; y < TRAY_CHAR_HEIGHT; y++)
		{
			scrn = src[ y * TRAY_CHAR_WIDTH + x ];
			scrn =		( ( GX_SCRFMT_TEXT_CHARNAME_MASK & scrn) + charOfs )
					|	( GX_SCRFMT_TEXT_HF_MASK & scrn )
					|	( palPos << GX_SCRFMT_TEXT_COLORPLTT_SHIFT );
			*dst_row = scrn;
			dst_row += SCRN_LINE_ELEMS;
		}

		xpos = (xpos + 1) & 63;
		if( xpos == 0 ){ dst -= SCRN_BANK_ELEMS; }
		if( xpos == 32){ dst += SCRN_BANK_ELEMS; }
	}

	for(x = 0; x < TRAY_WRITE_XMARGIN; x++)
	{
		dst_row = dst + ((SCRN_LINE_ELEMS*TRAY_WRITE_YPOS) + (xpos&31));
		for(y = 0; y < TRAY_CHAR_WIDTH; y++)
		{
			*dst_row = ( palPos << GX_SCRFMT_TEXT_COLORPLTT_SHIFT ) | (charOfs + TRAY_SPACE_CHARNO);
			dst_row += SCRN_LINE_ELEMS;
		}
		xpos = (xpos + 1) & 63;
		if( xpos == 0 ){ dst -= SCRN_BANK_ELEMS; }
		if( xpos == 32){ dst += SCRN_BANK_ELEMS; }
	}
}


//------------------------------------------------------------------------------
/**
 * wʒũACRJn
 *
 * @param   wk			gC`惏[N
 * @param   pos			ACRʒu
 *
 */
//------------------------------------------------------------------------------
void BoxAppView_TrayIconReleaseStart( TRAY_VIEW_WORK* wk, u32 pos )
{
	wk->icon_release_pos = pos;

	BoxAppView_IconAnmStart( wk->iconSys, &(wk->icon[wk->imgPos][pos]), ICON_ANM_RELEASE );
}
//------------------------------------------------------------------------------
/**
 * wʒũACRI҂
 *
 * @param   wk		[N|C^
 *
 * @retval  BOOL	TRUEŏI
 */
//------------------------------------------------------------------------------
BOOL BoxAppView_TrayIconReleaseWait( TRAY_VIEW_WORK* wk )
{
	BOX_ICON_WORK*  icon = &(wk->icon[wk->imgPos][wk->icon_release_pos]);

	if( BoxAppView_IconAnmWait( wk->iconSys, icon ) )
	{
		BoxAppView_IconWorkQuit( wk->iconSys, icon, 1 );
		return TRUE;
	}
	return FALSE;
}


//------------------------------------------------------------------
/**
 * ACRi荞݃[h\ɑΉ
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
void BoxAppView_TrayIconLimitModeSet( TRAY_VIEW_WORK* wk )
{
	u32 limitBit;
	int i;

	limitBit = BoxAppVPara_GetLimitModeBitFlag( wk->vpara );

	for(i=0; i<BOX_MAX_POS; i++)
	{
		if( wk->icon[wk->imgPos][i].act != NULL )
		{
			BoxAppView_IconLimitModeSet( wk->iconSys, &(wk->icon[wk->imgPos][i]), limitBit );
		}
	}

}
//------------------------------------------------------------------
/**
 * |CgĂACR}[LOrbgtOiXe[^Xj
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
void BoxAppView_TrayIconMarkUpdate( TRAY_VIEW_WORK* wk )
{
	u32 pos, markBit;

	pos = BoxAppVPara_GetCursorTrayPos( wk->vpara );
	markBit = BoxAppVPara_GetStatusPokeMarkBit( wk->vpara );

	if( wk->icon[wk->imgPos][pos].act != NULL )
	{
		BoxAppView_IconMarkBitSet( wk->iconSys, &(wk->icon[wk->imgPos][pos]), markBit );
	}
}



//------------------------------------------------------------------
/**
 * ͈͑ȊΏۂɂȂĂACRJ[ύX
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
void BoxAppView_TrayIconAleaSelectUpdate( TRAY_VIEW_WORK* wk )
{
	u32 left, right, top, bottom, x, y, p;

	BoxAppVPara_GetAreaSelectParam(wk->vpara, &left, &right, &top, &bottom);

	p = 0;
	for(y=0; y<BOX_MAX_RAW; y++)
	{
		for(x=0; x<BOX_MAX_COLUMN; x++)
		{
			if( wk->icon[wk->imgPos][p].act != NULL )
			{
				if( ((u32)(x-left) <= (u32)(right - left))
				&	((u32)(y-top) <= (u32)(bottom - top))
				){
					BoxAppView_IconAreaSelectPalSet( wk->iconSys, &(wk->icon[wk->imgPos][p]), TRUE );
				}
				else
				{
					BoxAppView_IconAreaSelectPalSet( wk->iconSys, &(wk->icon[wk->imgPos][p]), FALSE );
				}
			}
			p++;
		}
	}
}
void BoxAppView_TrayIconAleaSelectQuit( TRAY_VIEW_WORK* wk )
{
	int i;

	for(i=0; i<BOX_MAX_POS; i++)
	{
		if( wk->icon[wk->imgPos][i].act != NULL )
		{
			BoxAppView_IconAreaSelectPalSet( wk->iconSys, &(wk->icon[wk->imgPos][i]), FALSE );
		}
	}
}

