//============================================================================================
/**
 * @file	fnote_bmp.c
 * @brief	`m[g@BMP
 * @author	Hiroyuki Nakamura
 * @date	2006.03.06
 */
//============================================================================================
#include "common.h"
#include "system/fontproc.h"
#include "system/msgdata.h"
#include "system/wordset.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_fantasy_note.h"

#define	FNOTE_BMP_H_GLOBAL
#include "fnote_main.h"
#include "fnote_bmp.h"


//============================================================================================
//============================================================================================
#define	WIN_TIME1_PX	( 2 )
#define	WIN_TIME1_PY	( 2 )
#define	WIN_TIME1_SX	( 24 )
#define	WIN_TIME1_SY	( 2 )
#define	WIN_TIME1_PAL	( 15 )
#define	WIN_TIME1_CGX	( 1 )

#define	WIN_STR1_PX		( 4 )
#define	WIN_STR1_PY		( 4 )
#define	WIN_STR1_SX		( 27 )
#define	WIN_STR1_SY		( 18 )
#define	WIN_STR1_PAL	( 15 )
#define	WIN_STR1_CGX	( WIN_TIME1_CGX + WIN_TIME1_SX * WIN_TIME1_SY )

#define	WIN_TIME2_PX	( 2 )
#define	WIN_TIME2_PY	( 2 )
#define	WIN_TIME2_SX	( 24 )
#define	WIN_TIME2_SY	( 2 )
#define	WIN_TIME2_PAL	( 15 )
#define	WIN_TIME2_CGX	( 1 )

#define	WIN_STR2_PX		( 4 )
#define	WIN_STR2_PY		( 4 )
#define	WIN_STR2_SX		( 27 )
#define	WIN_STR2_SY		( 18 )
#define	WIN_STR2_PAL	( 15 )
#define	WIN_STR2_CGX	( WIN_TIME2_CGX + WIN_TIME2_SX * WIN_TIME2_SY )

#define	COL_N_BLACK		( GF_PRINTCOLOR_MAKE( 1, 2, 0 ) )		// tHgJ[F


//============================================================================================
//============================================================================================


//============================================================================================
//============================================================================================
static const BMPWIN_DAT BmpData[] =
{
	{	// tP
		GF_BGL_FRAME0_M, WIN_TIME1_PX, WIN_TIME1_PY,
		WIN_TIME1_SX, WIN_TIME1_SY, WIN_TIME1_PAL, WIN_TIME1_CGX
	},
	{	// P
		GF_BGL_FRAME0_M, WIN_STR1_PX, WIN_STR1_PY,
		WIN_STR1_SX, WIN_STR1_SY, WIN_STR1_PAL, WIN_STR1_CGX
	},
	{	// tQ
		GF_BGL_FRAME1_M, WIN_TIME2_PX, WIN_TIME2_PY,
		WIN_TIME2_SX, WIN_TIME2_SY, WIN_TIME2_PAL, WIN_TIME2_CGX
	},
	{	// Q
		GF_BGL_FRAME1_M, WIN_STR2_PX, WIN_STR2_PY,
		WIN_STR2_SX, WIN_STR2_SY, WIN_STR2_PAL, WIN_STR2_CGX
	}
};





void FantasyNote_BmpAdd( FNOTE_WORK * wk )
{
	u32	i;

	for( i=0; i<WIN_MAX; i++ ){
		GF_BGL_BmpWinAddEx( wk->bgl, &wk->win[i], &BmpData[i] );
	}
}

void FantasyNote_BmpFree( FNOTE_WORK * wk )
{
	u32	i;

	for( i=0; i<WIN_MAX; i++ ){
		GF_BGL_BmpWinDel( &wk->win[i] );
	}
}



void Debug_FNOTE_BmpPut( FNOTE_WORK * wk, u32 flg )
{
	GF_BGL_BMPWIN * time;
	GF_BGL_BMPWIN * info;
	STRBUF * str;

	if( flg == 0 ){
		time = &wk->win[WIN_TIME1];
		info = &wk->win[WIN_STR1];

		GF_BGL_BmpWinDataFill( time, 0 );
		GF_BGL_BmpWinDataFill( info, 0 );

		// t
		str = MSGMAN_AllocString( wk->mman, msg_fnote_001 );
		WORDSET_RegisterNumber(
			wk->wset, 0, 7, 2, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
		WORDSET_RegisterNumber(
			wk->wset, 1, 18, 2, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		GF_STR_PrintColor( time, FONT_SYSTEM, wk->msg_buf, 0, 0, MSG_NO_PUT, COL_N_BLACK, NULL );
		// X^[gI
		str = MSGMAN_AllocString( wk->mman, msg_fnote_000 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );
		// sP
		str = MSGMAN_AllocString( wk->mman, msg_fnote_100 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 16, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );
		// sQ
		str = MSGMAN_AllocString( wk->mman, msg_fnote_121 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 32, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );
		// sR
		str = MSGMAN_AllocString( wk->mman, msg_fnote_144 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 48, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );
		// sS
		str = MSGMAN_AllocString( wk->mman, msg_fnote_171 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 64, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );
		// |P
		str = MSGMAN_AllocString( wk->mman, msg_fnote_200 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 80, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );
		// g[i[
		str = MSGMAN_AllocString( wk->mman, msg_fnote_300 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 96, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );
		// ʐM
		str = MSGMAN_AllocString( wk->mman, msg_fnote_460 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 112, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );

	}else{
		time = &wk->win[WIN_TIME2];
		info = &wk->win[WIN_STR2];

		GF_BGL_BmpWinDataFill( time, 0 );
		GF_BGL_BmpWinDataFill( info, 0 );

		// t
		str = MSGMAN_AllocString( wk->mman, msg_fnote_001 );
		WORDSET_RegisterNumber(
			wk->wset, 0, 11, 2, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
		WORDSET_RegisterNumber(
			wk->wset, 1, 3, 2, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
		WORDSET_ExpandStr( wk->wset, wk->msg_buf, str );
		STRBUF_Delete( str );
		GF_STR_PrintColor( time, FONT_SYSTEM, wk->msg_buf, 0, 0, MSG_NO_PUT, COL_N_BLACK, NULL );
		// X^[gI
		str = MSGMAN_AllocString( wk->mman, msg_fnote_000 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );
		// sP
		str = MSGMAN_AllocString( wk->mman, msg_fnote_101 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 16, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );
		// sQ
		str = MSGMAN_AllocString( wk->mman, msg_fnote_110 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 32, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );
		// sR
		str = MSGMAN_AllocString( wk->mman, msg_fnote_145 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 48, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );
		// sS
		str = MSGMAN_AllocString( wk->mman, msg_fnote_173 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 64, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );
		// |P
		str = MSGMAN_AllocString( wk->mman, msg_fnote_203 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 80, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );
		// g[i[
		str = MSGMAN_AllocString( wk->mman, msg_fnote_302 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 96, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );
		// ʐM
		str = MSGMAN_AllocString( wk->mman, msg_fnote_480 );
		GF_STR_PrintColor( info, FONT_SYSTEM, str, 0, 112, MSG_NO_PUT, COL_N_BLACK, NULL );
		STRBUF_Delete( str );
	}

	GF_BGL_BmpWinOnVReq( time );
	GF_BGL_BmpWinOnVReq( info );
}
