//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_bg.c
 *	@brief		BGIuWFNg
 *	@author		tomoya takahashi
 *	@data		2005.09.29
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <string.h>
#include "system.h"
#include "bg_system.h"
#include "include/system/arc_util.h"
#include "system/lib_pack.h"

#define	__IMC_BG_H_GLOBAL
#include "include/application/imageClip/imc_bg.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	BGXN[^XN
//	
//=====================================
typedef struct {
	IMC_BG* imc_bg;			// \ĂBG
	IMC_BG_ADD	new_bg;		// VBG̓o^f[^
	BOOL*	end_flg;		// ItO

	int count;
	int add_x;
	int add_y;

	int ret_scr_x;		// Scrollʒu
	int ret_scr_y;		// Scrollʒu
} IMC_BG_SCR_TASK;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void imc_bg_set_screen_charofs( const NNSG2dScreenData* scrn, int char_offs );

static void imc_bg_addCore( IMC_BG_ADD* add, int* scrn_width, int* scrn_height );

static void imc_bg_scrTsk( TCB_PTR tcb, void* work );

static void imc_bg_scrnChg( GF_BGL_INI* bg_ini, int frame, const NNSG2dScreenData* scrn, int width, int height, int x, int y, int char_offs, int pltt_offs );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGf[^̓o^ & VKύX
 *
 *	@param	obj		BGIuWF
 *	@param	add		o^f[^
 *	@param	heap	gpq[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_BG_MakaObj( IMC_BG* obj, IMC_BG_ADD* add )
{
	// f[^ݒ
	obj->bg_ini		= add->bg_ini;
	obj->x			= add->x / 8;	
	obj->y			= add->y / 8;	
	obj->frame		= add->frame;	
	obj->pltt_offs	= add->pltt_offs;
	obj->pltt_num	= add->pltt_num;
	obj->char_offs	= add->char_offs;
	obj->arc_file	= add->arc_file;
	obj->scrn_arc	= add->scrn_arc;
	
	
	// BGݒ
	imc_bg_addCore( add, &obj->width_char, &obj->height_char );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGf[^̔j
 *
 *	@param	obj		BGIuWF
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_BG_DeleteObj( IMC_BG* obj )
{
	GF_BGL_ScrClear( obj->bg_ini, obj->frame );	

	memset( obj, 0, sizeof( IMC_BG ) );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGAj[V
 *
 *	@param	anm		AjBGf[^i[
 *	@param	init	f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_BG_AnmInit( IMC_BG_ANM* anm, IMC_BG_ANM_INIT* init )
{
	anm->bg			= init->bg;
	anm->scrn_arc01	= init->scrn_arc;
	anm->timing		= init->timing;
	anm->count		= 0;
	anm->scrn_no	= 0;
	anm->heap		= init->heap;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Aj[VXV
 *
 *	@param	anm		Aj[VBG
 *	@param	frame	i߂t[l
 *	
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_BG_Anm( IMC_BG_ANM* anm, int frame )
{
	NNSG2dScreenData*	scrn;
	void*				scrn_buf;
	int					arc_id;
	
	anm->count += frame;

	if( anm->count > anm->timing ){
		anm->count = 0;

		// XN[t@CI
		if( anm->scrn_no == 0 ){
			arc_id = anm->scrn_arc01;
			anm->scrn_no = 1;
		}else{
			arc_id = anm->bg->scrn_arc;
			anm->scrn_no = 0;
		}
		
		// XN[f[^o
		scrn_buf = ArcUtil_ScrnDataGet(anm->bg->arc_file, arc_id,
				FALSE, &scrn, anm->heap);

		// XN[f[^]
		imc_bg_scrnChg( anm->bg->bg_ini, anm->bg->frame, scrn,
				anm->bg->width_char, anm->bg->height_char,
				anm->bg->x, anm->bg->y,
				anm->bg->char_offs, anm->bg->pltt_offs );

		sys_FreeMemoryEz( scrn_buf );	
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGAjI
 *
 *	@param	anm		Aj[VBG
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_BG_AnmDelete( IMC_BG_ANM* anm )
{
	NNSG2dScreenData*	scrn;
	void*				scrn_buf;

	// GftH̊GɂăN[
	// XN[f[^o
	scrn_buf = ArcUtil_ScrnDataGet(anm->bg->arc_file, anm->bg->scrn_arc,
			FALSE, &scrn, anm->heap);

	// XN[f[^]
	imc_bg_scrnChg( anm->bg->bg_ini, anm->bg->frame, scrn,
			anm->bg->width_char, anm->bg->height_char,
			anm->bg->x, anm->bg->y,
			anm->bg->char_offs, anm->bg->pltt_offs );

	sys_FreeMemoryEz( scrn_buf );	

	memset( anm, 0, sizeof(IMC_BG_ANM) );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGScroll܂B
 *
 *	@param	obj		\ĂBG
 *	@param	scr_bg	XN[BG
 *	@param	scr_dis	XN[l
 *	@param	scr_syncXN[ɎgVN
 *	@param	end_flg	ImtO
 *
 *	@return	none
 *
 * ŏIIɂscr_bg̕BGʂɏo悤ɂȂ܂
 *
 * ܂BGf[^zu
 * 256x256
 * 128~255̕ɃLN^悤ɂȂĂKv܂B
 *
 */
//-----------------------------------------------------------------------------
void IMC_BG_ScrollReq( IMC_BG* obj, IMC_BG_ADD* scr_bg, int scr_x, int scr_y, int scr_sync, BOOL* end_flg )
{
	IMC_BG_SCR_TASK* scr_tsk;
	TCB_PTR tcb;

	// ^XNo^
	tcb = PMDS_taskAdd( imc_bg_scrTsk, sizeof(IMC_BG_SCR_TASK), 0, HEAPID_IMAGECLIP_DATA );
	
	// [N擾
	scr_tsk = TCB_GetWork( tcb );

	// ef[^ݒ
	scr_tsk->imc_bg = obj;
	scr_tsk->new_bg = *scr_bg;
	scr_tsk->end_flg = end_flg;
	
	scr_tsk->count	= scr_sync;
	scr_tsk->add_x	= scr_x / scr_sync;
	scr_tsk->add_y	= scr_y / scr_sync;
	scr_tsk->ret_scr_x = GF_BGL_ScrollGetX( obj->bg_ini, obj->frame );
	scr_tsk->ret_scr_y = GF_BGL_ScrollGetY( obj->bg_ini, obj->frame );

	// XN[āAʂɏoGzu
	scr_bg->char_offs = IMC_BG_SCR_OFS;
	scr_bg->pltt_offs = IMC_BG_SCR_PLTT_OFS;
	scr_bg->x		  -= scr_x;
	scr_bg->y		  -= scr_y;
	scr_bg->heap	= HEAPID_IMAGECLIP_DRAW;
	imc_bg_addCore( scr_bg, NULL, NULL );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	XN[f[^̃LN^l[̒lItZbg炷
 *
 *	@param	scrn			XN[f[^
 *	@param	char_offs		LN^ItZbg	LN^P
 *
 *	@return	none
 *
 * LN^l[ől`FbNĂȂ̂ŒӂĂ
 *
 */
//-----------------------------------------------------------------------------
static void imc_bg_set_screen_charofs( const NNSG2dScreenData* scrn, int char_offs )
{
	int i;							// [vp
	u16* scrndata;					// XN[f[^
	int size = scrn->szByte / 2;	// [v	Q=2byte
	
	// XN[f[^
	scrndata = (u16*)scrn->rawData;

	for(i=0; i<size; i++){

		scrndata[ i ] += char_offs;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ʂɊGo܂ł̏܂Ƃ߂֐
 *
 *	@param	add				BGo^f[^
 *	@param	scrn_width		XN[f[^̕i[iLN^Pʁj
 *	@param	scrn_height		XN[f[^̍i[iLN^Pʁj
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void imc_bg_addCore( IMC_BG_ADD* add, int* scrn_width, int* scrn_height )
{
	int pltype;	// pbg]
	NNSG2dScreenData* scrn;
	void* scrn_buf;
	int height, width;
	int x, y;

	x = add->x / 8;
	y = add->y / 8;
	
	// LN^f[^]
	ArcUtil_BgCharSet( add->arc_file, add->char_arc,
			add->bg_ini, add->frame, add->char_offs, 0, FALSE, add->heap);

	// pbgf[^]
	if(add->frame < GF_BGL_FRAME0_S){	
		pltype = PALTYPE_MAIN_BG;
	}else{
		pltype = PALTYPE_SUB_BG;
	}
	ArcUtil_PalSet( add->arc_file, add->pltt_arc,
			pltype, add->pltt_offs*32, add->pltt_num*32,  add->heap );

	// XN[f[^o
	scrn_buf = ArcUtil_ScrnDataGet(add->arc_file, add->scrn_arc,
			FALSE, &scrn, add->heap);

	// @
	width = scrn->screenWidth/8;
	height = scrn->screenHeight/8;
	
	// XN[f[^]
	imc_bg_scrnChg( add->bg_ini, add->frame, scrn, width, height, x, y, add->char_offs, add->pltt_offs );

	sys_FreeMemoryEz( scrn_buf );	

	if(scrn_width){
		*scrn_width = width;
	}
	if(scrn_height){
		*scrn_height = height;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XN[^XN
 *
 *	@param	tcb			^XNIuWF
 *	@param	work		f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void imc_bg_scrTsk( TCB_PTR tcb, void* work )
{
	IMC_BG_SCR_TASK* task = work;

	task->count --;
	
	if( task->count >= 0 ){
		GF_BGL_ScrollReq( task->imc_bg->bg_ini, task->imc_bg->frame, GF_BGL_SCROLL_X_DEC, task->add_x );

		GF_BGL_ScrollReq( task->imc_bg->bg_ini, task->imc_bg->frame, GF_BGL_SCROLL_Y_DEC, task->add_y );
	}else{
		GF_BGL_ScrollReq( task->imc_bg->bg_ini, task->imc_bg->frame, GF_BGL_SCROLL_X_SET, task->ret_scr_x );

		GF_BGL_ScrollReq( task->imc_bg->bg_ini, task->imc_bg->frame, GF_BGL_SCROLL_Y_SET, task->ret_scr_y );

		IMC_BG_MakaObj( task->imc_bg, &task->new_bg );

		if( task->end_flg ){
			*task->end_flg = TRUE;
		}
		
		// I
		PMDS_taskDel( tcb );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XN[f[^ݒ֐
 *
 *	@param	bg_ini		BGVXef[^
 *	@param	frame		BGt[
 *	@param	scrn		XN[f[^
 *	@param	width		
 *	@param	height		
 *	@param	x			W
 *	@param	y			W
 *	@param	chr_offs	LN^ItZbg
 *	@param	pltt_offs	pbgItZbg
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void imc_bg_scrnChg( GF_BGL_INI* bg_ini, int frame, const NNSG2dScreenData* scrn, int width, int height, int x, int y, int char_offs, int pltt_offs )
{
	// LN^ItZbgݒ
	imc_bg_set_screen_charofs( scrn, char_offs );
	
	// 
	GF_BGL_ScrWriteExpand(
				bg_ini, frame,
				x, y,
				width, height,
				scrn->rawData,
				0, 0,
				width, height );
	
	GF_BGL_ScrPalChange( bg_ini, frame,
				x, y,
				width,height,
			pltt_offs);
	
	GF_BGL_LoadScreenV_Req(bg_ini, frame );
}
