//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_button.c
 *	@brief		ʉ̃{^VXe
 *	@author		tomoya takahashi 
 *	@data		2005.10.08
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "include/system/clact_util.h"
#include "include/application/imageClip/imc_drawdata_define.h"
#include "msg_print.h"
#include "include/system/msgdata.h"
#include "include/system/fontproc.h"
#include "assert.h"
#include "system.h"
#include "string.h"
#include "pltt_manager.h"
#include "include/application/imageClip/imc_snd_def.h"

#define __IMC_BUTTON_H_GLOBAL
#include "include/application/imageClip/imc_button.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define IMC_BTTN_PRI	(2)

//-------------------------------------
//	
//	GON	OFFt[
//	
//=====================================
#define	IMC_BTTN_DRAW_OFF	(0)
#define	IMC_BTTN_DRAW_ON	(1)

//-------------------------------------
//	
//	tHg{^̕ItZbgʒu
//	
//=====================================
#define IMC_FONTBTTN_DRAW_X		(18)
#define IMC_FONTBTTN_DRAW_Y_OFF	(9)
#define IMC_FONTBTTN_DRAW_Y_ON	(7)
#define IMC_FONTBTTN_PLTT_OFS_OFF	(2)
#define IMC_FONTBTTN_PLTT_OFS_ON	(3)

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------

static void imcBttnNoFunc( IMC_BUTTON* bttn, void* work );


//-----------------------------------------------------------------------------
/**
*		C[WNbvp
*/
//-----------------------------------------------------------------------------
static void makeBttn( IMC_BUTTON* bttn, int bttn_no, IMC_DRAW_DATA* drawData, int x, int y, int sx, int sy );
static void makeFontBttn( IMC_FONT_BUTTON* bttn, int bttn_no, IMC_DRAW_DATA* drawData, CONST_FONTOAM_SYS_PTR fnt_sys, const GF_BGL_BMPWIN* bmp, int x, int y, int sx, int sy );
static void makeHitTbl( TP_HIT_TBL* p_hit, int bttn_no, int x, int y, int sx, int sy );

static void loadBttnRes( IMC_DRAW_DATA* drawData );
static void loadBttnEndCkRes( IMC_DRAW_DATA* drawData );
static void deleteBttnCharPltt( IMC_DRAW_DATA* drawData );
static void deleteBttnEndCkCharPltt( IMC_DRAW_DATA* drawData );

static GF_BGL_BMPWIN* getBttnStr( IMC_DRAW_DATA* drawData, u32 arcID, u32 dataID, u32 msgID, int bmp_x, int bmp_y );
static void deleteBttnStr( GF_BGL_BMPWIN* win );

static void IMCBTTN_normalAnm( IMC_BUTTON* bttn, int state );
static void IMCBTTN_sndStart( IMC_BUTTON* bttn, int se, int timing, int state );
static void IMC_BTTN_FontAnm( IMC_FONT_BUTTON* bttn, int state );

static void IMC_BTTN_Move( IMC_BUTTON* bttn, int x, int y );
static void IMC_FONTBTTN_Move( IMC_FONT_BUTTON* bttn, int x, int y );

// R[obN֐
static void IMC_IMCBTTN_Call( u32 button, u32 event, void* work );
static void IMC_IMCBTTN_ENDCK_Call( u32 button, u32 event, void* work );

// static void IMCBTTN_ace_bg_snd_anm( IMC_BUTTON_DATA* data, int flg );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{^̏
 *
 *	@param	button		{^IuWF̃|C^ 
 *	@param	init		f[^\		 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_BTTN_Init( IMC_BUTTON* button, IMC_BUTTON_INIT* init )
{

	GF_ASSERT( button );
	GF_ASSERT( init );

	button->clact_w = CLACT_Add( init->clact );
	GF_ASSERT( button->clact_w );

	// f[^i[
	button->start_flg	= init->start_flg;
	button->work		= init->work;
	if(init->buttonFunc){
		button->func		= init->buttonFunc;
	}else{
		button->func		= imcBttnNoFunc;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\t{^쐬
 *
 *	@param	button	{^
 *	@param	init	f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_BTTN_FontBttnInit( IMC_FONT_BUTTON* button, IMC_FONT_BUTTON_INIT* init )
{
	FONTOAM_INIT fontoam_init;
	
	IMC_BTTN_Init( &button->button, &init->bttn_init );

	fontoam_init.fontoam_sys	= init->fntoam_sys;
	fontoam_init.bmp			= init->bmp;
	fontoam_init.clact_set		= init->bttn_init.clact->ClActSet;
	fontoam_init.pltt			= init->pltt;
	fontoam_init.parent			= button->button.clact_w;
	fontoam_init.char_ofs		= init->char_ofs;
	fontoam_init.x				= init->fnt_x;
	fontoam_init.y				= init->fnt_y;
	fontoam_init.bg_pri			= 0;
	fontoam_init.soft_pri		= 0;
	fontoam_init.draw_area		= init->bttn_init.clact->DrawArea;
	fontoam_init.heap			= init->bttn_init.clact->heap;

	button->font = FONTOAM_Init( &fontoam_init );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{^̔j
 *
 *	@param	button	{^IuWFNg
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_BTTN_Delete( IMC_BUTTON* button )
{
	// AN^[j
	CLACT_Delete( button->clact_w );

	// 
	memset( button, 0, sizeof(IMC_BUTTON) );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	tHgt{^j
 *
 *	@param	button	{^f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_BTTN_FontBttnDelete( IMC_FONT_BUTTON* button )
{
	IMC_BTTN_Delete( &button->button );

	FONTOAM_Delete( button->font );

	memset( button, 0, sizeof(IMC_FONT_BUTTON) );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{^VXeC֐
 *
 *	@param	button	{^\
 *	@param	state	̃{^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_BTTN_DoFunc( IMC_BUTTON* button, int state )
{
	// ֐s邩`FbN
	if( state == button->start_flg ){

		button->func( button, button->work );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT@BG@ύX{^Ԃɂ
 *
 *	@param	button			{^\
 *	@param	button_no		{^io[
 *
 *	@return	none
 *
 * button_no
	IMC_BTTN_ACE,		// ANZTύXɈڂ
	IMC_BTTN_BG,		// BGύXɈڂ
 *
 */
//-----------------------------------------------------------------------------
void IMC_IMCBTTN_OnAB( IMC_BUTTON_DATA* button, int button_no )
{
	int i;		// [vp
	IMC_BUTTON* bttn;	
	
	// flg̃IuWFNg͉ꂽG
	// ̑̃IuWFNg̃{^𗣂Ԃɂ
	for( i=IMC_BTTN_ACE; i<=IMC_BTTN_BG; i++ ){

		bttn = button->bttn + i;
		
		if( i != button_no ){
			// Gɂ
			IMC_BTTN_PopGra( bttn );
		}else{
			// Gɂ
			IMC_BTTN_PushGra( bttn );

			// {^
			Snd_SePlay( IMC_SE_BUTTON_ON );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	֐{^ɐݒ
 *
 *	@param	button		{^\
 *	@param	func		֐
 *	@param	work		[N
 *	@param	start_flg	֐s^C~O
 *
 *	@return	none
 *
 *	start_flg
		IMC_BTTN_NOPUSH,		// ĂȂ
		IMC_BTTN_PUSH,			// Ă
		IMC_BTTN_PUSH_F,		// ꂽu
		IMC_BTTN_POP,			// ꂽu
 *
 */
//-----------------------------------------------------------------------------
void IMC_BTTN_FuncSet( IMC_BUTTON* button, IMCBUTTON_FUNC func, void* work, int start_flg )
{
	GF_ASSERT( button );
	
	button->start_flg	= start_flg;
	button->work		= work;
	button->func		= func;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	Ȃ֐
 *
 *	@param	bttn
 *	@param	work 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void imcBttnNoFunc( IMC_BUTTON* bttn, void* work )
{
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ꂽƂ̃GtFNg
 *
 *	@param	bttn	{^\
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_BTTN_PushGra( IMC_BUTTON* bttn )
{
	// GԂɂ
	CLACT_AnmFrameSet( bttn->clact_w, IMC_BTTN_DRAW_ON );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ꂽƂ̃GtFNg
 *
 *	@param	bttn	{^\
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_BTTN_PopGra( IMC_BUTTON* bttn )
{
	// G𗣂Ԃɂ
	CLACT_AnmFrameSet( bttn->clact_w, IMC_BTTN_DRAW_OFF );
}



//-----------------------------------------------------------------------------
/**
*			C[WNbvp֐S
*	jump
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	
 *	@brief	C[WNbvp{^̍쐬
 *
 *	@param	button		{^\
 *	@param	drawData	`VXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_IMCBTTN_Init( IMC_BUTTON_DATA* button, IMC_DRAW_DATA* drawData )
{
	GF_BGL_BMPWIN* bmp;
	
	// OAMtHgVXe쐬
	button->fntoam_sys = FONTOAM_SysInit( 1, HEAPID_IMAGECLIP_DATA );

	// \[Xǂݍ
	loadBttnRes( drawData );

	
	// pbg߂{^
	// `f[^Ɠ蔻e[u̍쐬
	makeBttn( &button->bttn[ IMC_BTTN_RET ], IMC_BTTN_RET, drawData,
			IMC_BTTN_RET_X, IMC_BTTN_RET_Y,
			IMC_BTTN_RET_SIZE_X, IMC_BTTN_RET_SIZE_Y);
	makeHitTbl( button->hit, IMC_BTTN_RET,
			IMC_BTTN_RET_X, IMC_BTTN_RET_Y,
			IMC_BTTN_RET_SIZE_X, IMC_BTTN_RET_SIZE_Y);
	
	// pbg߂đOɖ߂{^
	// `f[^Ɠ蔻e[u̍쐬
	makeBttn( &button->bttn[ IMC_BTTN_RETB ], IMC_BTTN_RETB, drawData,
			IMC_BTTN_RETB_X, IMC_BTTN_RET_Y,
			IMC_BTTN_RET_SIZE_X, IMC_BTTN_RET_SIZE_Y);
	makeHitTbl( button->hit, IMC_BTTN_RETB,
			IMC_BTTN_RETB_X, IMC_BTTN_RET_Y,
			IMC_BTTN_RET_SIZE_X, IMC_BTTN_RET_SIZE_Y);
	
	// ANZTύXɈڂ{^
	// `f[^Ɠ蔻e[u̍쐬
	makeBttn( &button->bttn[ IMC_BTTN_ACE ], IMC_BTTN_ACE, drawData,
			IMC_BTTN_ACE_X, IMC_BTTN_Y,
			IMC_BTTN_NOR_SIZE_X, IMC_BTTN_NOR_SIZE_Y);
	makeHitTbl( button->hit, IMC_BTTN_ACE,
			IMC_BTTN_ACE_X, IMC_BTTN_Y,
			IMC_BTTN_NOR_SIZE_X, IMC_BTTN_NOR_SIZE_Y);
	
	// BGύXɈڂ{^
	// `f[^Ɠ蔻e[u̍쐬
	makeBttn( &button->bttn[ IMC_BTTN_BG ], IMC_BTTN_BG, drawData,
			IMC_BTTN_BG_X, IMC_BTTN_Y,
			IMC_BTTN_NOR_SIZE_X, IMC_BTTN_NOR_SIZE_Y);
	makeHitTbl( button->hit, IMC_BTTN_BG,
			IMC_BTTN_BG_X, IMC_BTTN_Y,
			IMC_BTTN_NOR_SIZE_X, IMC_BTTN_NOR_SIZE_Y);
	
	
	// ENDύXɈڂ{^
	// `f[^Ɠ蔻e[u̍쐬
	// tHgf[^ǂݍ
	FontProc_LoadFont( FONT_BUTTON, HEAPID_IMAGECLIP_DRAW );
	// 
	// rbg}bvEBhE쐬
	bmp = getBttnStr( drawData, ARC_MSG, NARC_msg_imageclip_dat,
			imgclip_end,
			IMC_BTTN_END_SIZE_X / 8,
			IMC_BTTN_END_SIZE_Y / 8);
	// {^쐬
	makeFontBttn( &button->bttn_end, IMC_BTTN_END, drawData, 
			button->fntoam_sys, bmp,
			IMC_BTTN_END_X, IMC_BTTN_Y,
			IMC_BTTN_END_SIZE_X, IMC_BTTN_END_SIZE_Y );
	makeHitTbl( button->hit, IMC_BTTN_END,
			IMC_BTTN_END_X, IMC_BTTN_Y,
			IMC_BTTN_END_SIZE_X, IMC_BTTN_END_SIZE_Y );
	// 
	// rbg}bvEBhEj
	deleteBttnStr( bmp );
	// tHgj
	FontProc_UnloadFont( FONT_BUTTON );
	
	// \[Xj
	deleteBttnCharPltt( drawData );


	// ftHgŃANZTύXɈڂ{^ύX
	IMC_BTTN_PushGra( &button->bttn[ IMC_BTTN_ACE ] );

	// {^}l[Wɓo^
	button->bttn_man = BMN_Create( button->hit, IMC_BTTN_MAX, IMC_IMCBTTN_Call, button, HEAPID_IMAGECLIP_DATA );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvp{^̔j
 *
 *	@param	button		{^\
 *	@param	drawData	`f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_IMCBTTN_Delete( IMC_BUTTON_DATA* button, IMC_DRAW_DATA* drawData )
{
	int i;

	// ZAZAjALN^VramGA@pbgVramGA
	for( i=0;i<IMC_BTTN_MAX;i++ ){
		IMC_DRAW_CLACT_DeleteCellRes( drawData, i );
		IMC_DRAW_CLACT_DeleteCellAnmRes( drawData, i );
		DelChar( i );
	}
	DelPltt( IMC_BTTN_RES_MAN_PLTT );
	DelPltt( IMC_BTTN_RES_MAN_PLTT_FONT );

	for( i=0; i<IMC_BTTN_NORM_MAX; i++ ){
		IMC_BTTN_Delete( &button->bttn[ i ] );
	}

	// tHgf[^gpĂLN^̈j
	CharVramAreaFree( &button->bttn_end.char_vram );
	
	IMC_BTTN_FontBttnDelete( &button->bttn_end );

	FONTOAM_SysDelete( button->fntoam_sys );

	// {^}l[Wj
	BMN_Delete( button->bttn_man );
	button->bttn_man = NULL;
}

//----------------------------------------------------------------------------
//
/**
 *
 *	@brief	C[WNbv{^C
 *
 *	@param	button	{^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_IMCBTTN_Main( IMC_BUTTON_DATA* button )
{
	GF_ASSERT( button->bttn_man );
	
	BMN_Main( button->bttn_man );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	S{^𑫂Zړ
 *
 *	@param	button		{^\
 *	@param	x			l
 *	@param	y			l
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_IMCBTTN_Move( IMC_BUTTON_DATA* button, int x, int y )
{
	int i;			// [vp

	for(i=0; i<IMC_BTTN_NORM_MAX; i++ ){
		IMC_BTTN_Move( button->bttn + i, x, y );
	}
	IMC_FONTBTTN_Move( &button->bttn_end, x, y );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	֐ݒ
 *
 *	@param	button		{^f[^
 *	@param	button_no	{^io[
 *	@param	func		֐
 *	@param	work		[N
 *	@param	start_flg	֐s^C~O
 *
 *	@return	none
 *
 *	start_flg
		IMC_BTTN_NOPUSH,		// ĂȂ
		IMC_BTTN_PUSH,			// Ă
		IMC_BTTN_PUSH_F,		// ꂽu
		IMC_BTTN_POP,			// ꂽu
 *
 */
//-----------------------------------------------------------------------------
void IMC_IMCBTTN_FuncSet( IMC_BUTTON_DATA* button, int button_no, IMCBUTTON_FUNC func, void* work, int start_flg )
{
	GF_ASSERT( button );

	if( button_no < IMC_BTTN_NORM_MAX ){
		IMC_BTTN_FuncSet( 
				&button->bttn[ button_no ],
				func, work, 
				start_flg);
	}else{
		IMC_BTTN_FuncSet( 
				&button->bttn_end.button,
				func, work, 
				start_flg);
	}
}

//-----------------------------------------------------------------------------
/**
*	I`FbNp
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	
 *	@brief	I`FbNp{^̍쐬
 *
 *	@param	button		{^\
 *	@param	drawData	`VXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_IMCBTTN_ENDCK_Init( IMC_BUTTON_ENDCK_DATA* button, IMC_DRAW_DATA* drawData )
{
	GF_BGL_BMPWIN* bmp;
	
	// OAMtHgVXe쐬
	button->fntoam_sys = FONTOAM_SysInit( 2, HEAPID_IMAGECLIP_DATA );

	// \[Xǂݍ
	// I`FbNpɍ쐬
	loadBttnEndCkRes( drawData );

	
	// ENDύXɈڂ{^
	// tHgf[^ǂݍ
	FontProc_LoadFont( FONT_BUTTON, HEAPID_IMAGECLIP_DRAW );

	{
		// CANCEL
		// 
		// rbg}bvEBhE쐬
		bmp = getBttnStr( drawData, ARC_MSG, NARC_msg_imageclip_dat,
				imgclip_ng,
				IMC_BTTN_ENDCK_SIZE_X / 8,
				IMC_BTTN_ENDCK_SIZE_Y / 8);
		// {^쐬
		makeFontBttn( &button->bttn[ IMC_BTTN_ENDCK_CANCEL ],
				IMC_BTTN_ENDCK_CANCEL, drawData,
				button->fntoam_sys, bmp,
				IMC_BTTN_ENDCK_CHANCEL_X, IMC_BTTN_ENDCK_Y,
				IMC_BTTN_ENDCK_SIZE_X, IMC_BTTN_ENDCK_SIZE_Y);
		makeHitTbl(button->hit,
				IMC_BTTN_ENDCK_CANCEL,
				IMC_BTTN_ENDCK_CHANCEL_X, IMC_BTTN_ENDCK_Y,
				IMC_BTTN_ENDCK_SIZE_X, IMC_BTTN_ENDCK_SIZE_Y);
		// 
		// rbg}bvEBhEj
		deleteBttnStr( bmp );
	}
	{
		// end
		// 
		// rbg}bvEBhE쐬
		bmp = getBttnStr( drawData, ARC_MSG, NARC_msg_imageclip_dat,
				imgclip_ok,
				IMC_BTTN_ENDCK_SIZE_X / 8,
				IMC_BTTN_ENDCK_SIZE_Y / 8);
		// {^쐬
		makeFontBttn( &button->bttn[ IMC_BTTN_ENDCK_END ],
				IMC_BTTN_ENDCK_END, drawData,
				button->fntoam_sys, bmp,
				IMC_BTTN_ENDCK_END_X, IMC_BTTN_ENDCK_Y,
				IMC_BTTN_ENDCK_SIZE_X, IMC_BTTN_ENDCK_SIZE_Y);
		makeHitTbl(button->hit,
				IMC_BTTN_ENDCK_END,
				IMC_BTTN_ENDCK_END_X, IMC_BTTN_ENDCK_Y,
				IMC_BTTN_ENDCK_SIZE_X, IMC_BTTN_ENDCK_SIZE_Y);

		// 
		// rbg}bvEBhEj
		deleteBttnStr( bmp );
	}


	// tHgj
	FontProc_UnloadFont( FONT_BUTTON );

	
	// \[Xj
	deleteBttnEndCkCharPltt( drawData );

	// {^}l[Wɓo^
	button->bttn_man = BMN_Create( button->hit, IMC_BTTN_ENDCK_MAX, IMC_IMCBTTN_ENDCK_Call, button, HEAPID_IMAGECLIP_DATA );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbNp{^̔j
 *
 *	@param	button		{^\
 *	@param	drawData	`f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_IMCBTTN_ENDCK_Delete( IMC_BUTTON_ENDCK_DATA* button, IMC_DRAW_DATA* drawData )
{
	int i;
	
	// ZAZAjALN^VramGA@pbgVramGA
	// 
	for( i=0;i<IMC_BTTN_ENDCK_MAX;i++ ){
		IMC_DRAW_CLACT_DeleteCellRes( drawData, i );
		IMC_DRAW_CLACT_DeleteCellAnmRes( drawData, i );
		DelChar( i );
	}
	DelPltt( IMC_BTTN_RES_MAN_PLTT );
	DelPltt( IMC_BTTN_RES_MAN_PLTT_FONT );

	for( i=0; i < IMC_BTTN_ENDCK_MAX; i++ ){

		// tHgf[^gpĂLN^̈j
		CharVramAreaFree( &button->bttn[ i ].char_vram );
	
		IMC_BTTN_FontBttnDelete( &button->bttn[ i ] );
	}
	FONTOAM_SysDelete( button->fntoam_sys );

	// {^}l[Wj
	BMN_Delete( button->bttn_man );
	button->bttn_man = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I{^C֐
 *
 *	@param	button	I{^f[^
 *		
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_IMCBTTN_ENDCK_Main( IMC_BUTTON_ENDCK_DATA* button )
{
	GF_ASSERT( button->bttn_man );
	
	BMN_Main( button->bttn_man );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbN{^𑫂Zړ
 *
 *	@param	button	{^\
 *	@param	x		W
 *	@param	y		W
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_IMCBTTN_ENDCK_Move( IMC_BUTTON_ENDCK_DATA* button, int x, int y )
{
	int i;

	// C
	for(i=0; i< IMC_BTTN_ENDCK_MAX; i++ ){
		IMC_FONTBTTN_Move( &button->bttn[ i ], x, y );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbN֐ݒ
 *
 *	@param	button		{^f[^
 *	@param	button_no	{^io[
 *	@param	func		֐
 *	@param	work		[N
 *	@param	start_flg	֐s^C~O
 *
 *	@return	none
 *
 *	start_flg
		IMC_BTTN_NOPUSH,		// ĂȂ
		IMC_BTTN_PUSH,			// Ă
		IMC_BTTN_PUSH_F,		// ꂽu
		IMC_BTTN_POP,			// ꂽu
 *
 */
//-----------------------------------------------------------------------------
void IMC_IMCBTTN_ENDCK_FuncSet( IMC_BUTTON_ENDCK_DATA* button, int button_no, IMCBUTTON_FUNC func, void* work, int start_flg )
{
	GF_ASSERT( button );

	IMC_BTTN_FuncSet( 
			&button->bttn[ button_no ].button,
			func, work, 
			start_flg);
}




//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvp{^R[obN֐
 *
 *	@param	button		{^ID
 *	@param	event		Cxg
 *	@param	work		[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void IMC_IMCBTTN_Call( u32 button, u32 event, void* work )
{
	IMC_BUTTON_DATA* data = work;
	
	switch( button ){
	case IMC_BTTN_RET:
		// Aj
		IMCBTTN_normalAnm( &data->bttn[ IMC_BTTN_RET ], event );
		// 炷
		IMCBTTN_sndStart( &data->bttn[ IMC_BTTN_RET ], IMC_SE_RET_BUTTON_ON, IMC_BTTN_PUSH_F, event );
		// 
		IMC_BTTN_DoFunc( &data->bttn[ IMC_BTTN_RET ], event );
		break;

	case IMC_BTTN_RETB:
		// Aj
		IMCBTTN_normalAnm( &data->bttn[ IMC_BTTN_RETB ], event );
		// 炷
		IMCBTTN_sndStart( &data->bttn[ IMC_BTTN_RETB ], IMC_SE_RET_BUTTON_ON, IMC_BTTN_PUSH_F, event );
		// 
		IMC_BTTN_DoFunc( &data->bttn[ IMC_BTTN_RETB ], event );
		break;
		
	case IMC_BTTN_ACE:
	case IMC_BTTN_BG:
		// 
		IMC_BTTN_DoFunc( &data->bttn[ button ], event );
		break;
		
	case IMC_BTTN_END:
		// Aj
		IMCBTTN_normalAnm( &data->bttn_end.button, event );
		// I{^̏ꍇ̓tHgf[^̍W
		IMC_BTTN_FontAnm( &data->bttn_end, event );
		// 炷
		IMCBTTN_sndStart( &data->bttn_end.button, IMC_SE_BUTTON_ON, IMC_BTTN_PUSH_F, event );
		// 
		IMC_BTTN_DoFunc( &data->bttn_end.button, event );
		break;

	default:
		GF_ASSERT_MSG( 0, "ɂ̂͂\n" );
		break;
	}
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbNp{^R[obN֐
 *
 *	@param	button		{^ID
 *	@param	event		Cxg
 *	@param	work		[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void IMC_IMCBTTN_ENDCK_Call( u32 button, u32 event, void* work )
{
	IMC_BUTTON_ENDCK_DATA* data = work;
	
	switch( button ){
	case IMC_BTTN_ENDCK_CANCEL:
		// Aj
		IMCBTTN_normalAnm( &data->bttn[ button ].button, event );
		IMC_BTTN_FontAnm( &data->bttn[ button ], event );
		// TEh
		IMCBTTN_sndStart( &data->bttn[ button ].button, IMC_SE_BUTTON_ON, IMC_BTTN_PUSH_F, event );
		// 
		IMC_BTTN_DoFunc( &data->bttn[ button ].button, event );
		break;

	case IMC_BTTN_ENDCK_END:
		// Aj
		IMCBTTN_normalAnm( &data->bttn[ button ].button, event );
		IMC_BTTN_FontAnm( &data->bttn[ button ], event );
		// TEh
		IMCBTTN_sndStart( &data->bttn[ button ].button, IMC_SE_RET_BUTTON_FINISH, IMC_BTTN_PUSH_F, event );
		// 
		IMC_BTTN_DoFunc( &data->bttn[ button ].button, event );
		break;
	
	default:
		GF_ASSERT_MSG( 0, "ɂ̂͂\n" );
		break;
	}
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	{^io[̃{^쐬
 *
 *	@param	bttn		{^f[^
 *	@param	bttn_no		{^io[
 *	@param	drawData	`VXef[^
 *	@param	x			W
 *	@param	y			W
 *	@param	sx			TCY
 *	@param	sy			TCY
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void makeBttn( IMC_BUTTON* bttn, int bttn_no, IMC_DRAW_DATA* drawData, int x, int y, int sx, int sy )
{
	IMC_BUTTON_INIT init;
	CLACT_HEADER head;
	CLACT_ADD	add;
	
	// wb_[쐬
	CLACT_U_MakeHeader( 
			&head, 
			bttn_no, IMC_BTTN_RES_MAN_PLTT, 
			bttn_no, bttn_no,
			CLACT_U_HEADER_DATA_NONE,CLACT_U_HEADER_DATA_NONE,
			0, 0,
			drawData->resMan[ CLACT_U_CHAR_RES ],
			drawData->resMan[ CLACT_U_PLTT_RES ],
			drawData->resMan[ CLACT_U_CELL_RES ],
			drawData->resMan[ CLACT_U_CELLANM_RES ],
			NULL, NULL );

	// o^f[^쐬
	add.ClActSet	= drawData->clactSet;
	add.ClActHeader = &head;
	add.mat.x		= x << FX32_SHIFT;
	add.mat.y		= y << FX32_SHIFT;
	add.mat.z		= 0;
	add.pri			= IMC_BTTN_PRI;
	add.DrawArea	= NNS_G2D_VRAM_TYPE_2DMAIN;
	add.heap		= HEAPID_IMAGECLIP_DRAW;

	init.clact	= &add;
	init.buttonFunc = NULL;
	init.work		= NULL;
	init.start_flg	= IMC_BTTN_POP;
	
	IMC_BTTN_Init( bttn, &init );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	tHg{^
 *
 *	@param	bttn		tHg{^f[^
 *	@param	bttn_no		{^io[	
 *	@param	drawData	`VXef[^
 *	@param	fnt_sys		tHgVXe
 *	@param	pltt		pbgvNV
 *	@param	bmp			rbg}bvEBhE
 *	@param	x			W
 *	@param	y			W
 *	@param	sx			TCY
 *	@param	sy			TCY
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void makeFontBttn( IMC_FONT_BUTTON* bttn, int bttn_no, IMC_DRAW_DATA* drawData, CONST_FONTOAM_SYS_PTR fnt_sys, const GF_BGL_BMPWIN* bmp, int x, int y, int sx, int sy )
{
	IMC_FONT_BUTTON_INIT init;
	CLACT_HEADER head;
	CLACT_ADD	add;
	CLACT_U_RES_OBJ_PTR pltt_obj;
	int char_size;
	BOOL check;

	
	// ZAN^[wb_[쐬
	CLACT_U_MakeHeader( 
			&head, 
			bttn_no, IMC_BTTN_RES_MAN_PLTT, 
			bttn_no, bttn_no,
			CLACT_U_HEADER_DATA_NONE,CLACT_U_HEADER_DATA_NONE,
			0, 0,
			drawData->resMan[ CLACT_U_CHAR_RES ],
			drawData->resMan[ CLACT_U_PLTT_RES ],
			drawData->resMan[ CLACT_U_CELL_RES ],
			drawData->resMan[ CLACT_U_CELLANM_RES ],
			NULL, NULL );


	// ZAN^[o^f[^쐬
	add.ClActSet	= drawData->clactSet;
	add.ClActHeader = &head;
	add.mat.x		= x << FX32_SHIFT;
	add.mat.y		= y << FX32_SHIFT;
	add.mat.z		= 0;
	add.pri			= IMC_BTTN_PRI;
	add.DrawArea	= NNS_G2D_VRAM_TYPE_2DMAIN;
	add.heap		= HEAPID_IMAGECLIP_DRAW;

	// {^쐬f[^
	init.bttn_init.clact	= &add;
	init.bttn_init.buttonFunc = NULL;
	init.bttn_init.work		= NULL;
	init.bttn_init.start_flg= IMC_BTTN_POP;
	init.fntoam_sys			= fnt_sys;
	init.bmp				= bmp;
	init.fnt_x				= IMC_FONTBTTN_DRAW_X;
	init.fnt_y				= IMC_FONTBTTN_DRAW_Y_OFF;

	// pbgvNV擾
	pltt_obj = CLACT_U_ResManagerGetIDResObjPtr( drawData->resMan[ CLACT_U_PLTT_RES ], IMC_BTTN_RES_MAN_PLTT_FONT );
	init.pltt				= CLACT_U_PlttManagerGetProxy( pltt_obj, NULL );

	// LN^ItZbg𒲂ׂ
	char_size = FONTOAM_NeedCharSize( bmp, NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_IMAGECLIP_DATA );

	// LN^f[^VRAM̈m
	check = CharVramAreaAlloc( char_size, CHARM_CONT_AREACONT, NNS_G2D_VRAM_TYPE_2DMAIN, &bttn->char_vram );
	GF_ASSERT_MSG( check, "{^pLN^f[^̈mێs" );
	init.char_ofs			= bttn->char_vram.alloc_ofs;
	
	// {^쐬
	IMC_BTTN_FontBttnInit( bttn, &init );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	蔻e[uɃf[^ݒ
 *
 *	@param	p_hit		蔻e[u
 *	@param	bttn_no		{^io[
 *	@param	x			゘W
 *	@param	y			゙W
 *	@param	sx			
 *	@param	sy			
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void makeHitTbl( TP_HIT_TBL* p_hit, int bttn_no, int x, int y, int sx, int sy )
{
	p_hit[ bttn_no ].rect.top		= y;
	p_hit[ bttn_no ].rect.left		= x;
	p_hit[ bttn_no ].rect.bottom	= y + sy;
	p_hit[ bttn_no ].rect.right		= x + sx;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbv{^f[^ǂݍ
 *
 *	@param	drawData	`VXef[^ 
 *
 *	@return	none
 *	
 *
 */
//-----------------------------------------------------------------------------
static void loadBttnRes( IMC_DRAW_DATA* drawData )
{
	int i;		// [vp
	
	for( i=0; i<IMC_BTTN_MAX; i++ ){
		// LN^
		IMC_DRAW_CLACT_LoadCharData( 
				drawData, ARC_IMAGECLIP_GRA,
				IMC_BTTN_ARC_CHAR_GET( i ),
				FALSE, NNS_G2D_VRAM_TYPE_2DMAIN, i);
		// Z
		IMC_DRAW_CLACT_LoadCellData( 
				drawData, ARC_IMAGECLIP_GRA,
				IMC_BTTN_ARC_CELL_GET( i ),
				FALSE, i);
		// ZAj
		IMC_DRAW_CLACT_LoadCellAnmData( 
				drawData, ARC_IMAGECLIP_GRA,
				IMC_BTTN_ARC_CANM_GET( i ),
				FALSE, i);
	}

	// pbg
	IMC_DRAW_CLACT_LoadPlttData( 
				drawData, ARC_IMAGECLIP_GRA,
				IMC_BTTN_ARC_FILE_PLTT,
				FALSE, NNS_G2D_VRAM_TYPE_2DMAIN, 
				IMC_BTTN_PLTT_LOAD_NUM, IMC_BTTN_RES_MAN_PLTT);

	// tHgppbg
	IMC_DRAW_CLACT_LoadPlttData( 
				drawData, ARC_IMAGECLIP_GRA,
				IMC_BTTN_ARC_FILE_PLTT_FONT,
				FALSE, NNS_G2D_VRAM_TYPE_2DMAIN, 
				IMC_BTTN_PLTT_LOAD_NUM_FONT, IMC_BTTN_RES_MAN_PLTT_FONT);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbN{^p
 *
 *	@param	drawData	`VXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadBttnEndCkRes( IMC_DRAW_DATA* drawData )
{
	int i;		// [vp
	
	for( i=0; i<IMC_BTTN_ENDCK_MAX; i++ ){
		// LN^
		IMC_DRAW_CLACT_LoadCharData( 
				drawData, ARC_IMAGECLIP_GRA,
				IMC_BTTN_ENDCK_ARC_CHAR,
				FALSE, NNS_G2D_VRAM_TYPE_2DMAIN, i);
		// Z
		IMC_DRAW_CLACT_LoadCellData( 
				drawData, ARC_IMAGECLIP_GRA,
				IMC_BTTN_ENDCK_ARC_CELL,
				FALSE, i);
		// ZAj
		IMC_DRAW_CLACT_LoadCellAnmData( 
				drawData, ARC_IMAGECLIP_GRA,
				IMC_BTTN_ENDCK_ARC_CANM,
				FALSE, i);
	}

	// pbg
	IMC_DRAW_CLACT_LoadPlttData( 
				drawData, ARC_IMAGECLIP_GRA,
				IMC_BTTN_ARC_FILE_PLTT,
				FALSE, NNS_G2D_VRAM_TYPE_2DMAIN, 
				IMC_BTTN_PLTT_LOAD_NUM, IMC_BTTN_RES_MAN_PLTT);

	// tHgppbg
	IMC_DRAW_CLACT_LoadPlttData( 
				drawData, ARC_IMAGECLIP_GRA,
				IMC_BTTN_ARC_FILE_PLTT_FONT,
				FALSE, NNS_G2D_VRAM_TYPE_2DMAIN, 
				IMC_BTTN_PLTT_LOAD_NUM_FONT, IMC_BTTN_RES_MAN_PLTT_FONT);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{^ƃLN^͔j
 *
 *	@param	drawData	`f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteBttnCharPltt( IMC_DRAW_DATA* drawData )
{
	int i;		//[vp

	for(i=0;i<IMC_BTTN_MAX;i++){
		IMC_DRAW_CLACT_DeleteCharRes( drawData, i );
	}

	IMC_DRAW_CLACT_DeletePlttRes( drawData, IMC_BTTN_RES_MAN_PLTT );
	IMC_DRAW_CLACT_DeletePlttRes( drawData, IMC_BTTN_RES_MAN_PLTT_FONT );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbN{^p{^ƃLN^͔j
 *
 *	@param	drawData	`f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteBttnEndCkCharPltt( IMC_DRAW_DATA* drawData )
{
	int i;		//[vp

	for(i=0;i<IMC_BTTN_ENDCK_MAX;i++){
		IMC_DRAW_CLACT_DeleteCharRes( drawData, i );
	}

	IMC_DRAW_CLACT_DeletePlttRes( drawData, IMC_BTTN_RES_MAN_PLTT );
	IMC_DRAW_CLACT_DeletePlttRes( drawData, IMC_BTTN_RES_MAN_PLTT_FONT );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ʂ̃Aj
 *
 *	@param	bttn	{^\
 *	@param	state	̏
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void IMCBTTN_normalAnm( IMC_BUTTON* bttn, int state )
{
	if( state == IMC_BTTN_PUSH_F ){

		// Gɂ
		IMC_BTTN_PushGra( bttn );

	}else{
		
		if( (state == IMC_BTTN_POP) ||
			(state == IMC_BTTN_AREA_OVER) ){

			// Gɂ
			IMC_BTTN_PopGra( bttn );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	tHg{^̃tHgf[^̃Aj[VǗ
 *
 *	@param	bttn	tHg{^\
 *	@param	state	̏
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void IMC_BTTN_FontAnm( IMC_FONT_BUTTON* bttn, int state )
{
	if( state == IMC_BTTN_PUSH_F ){

		// Gɂ
		FONTOAM_SetMat( bttn->font, IMC_FONTBTTN_DRAW_X, IMC_FONTBTTN_DRAW_Y_ON );

		// pbgItZbgύX
		FONTOAM_SetPaletteNo( bttn->font, IMC_FONTBTTN_PLTT_OFS_ON );
	}else{
		
		if( state == IMC_BTTN_POP ){

			// Gɂ
			FONTOAM_SetMat( bttn->font, IMC_FONTBTTN_DRAW_X, IMC_FONTBTTN_DRAW_Y_OFF );
		}
		
		if( state == IMC_BTTN_AREA_OVER ){
			// Gɂ
			FONTOAM_SetMat( bttn->font, IMC_FONTBTTN_DRAW_X, IMC_FONTBTTN_DRAW_Y_OFF );
			// pbgItZbgύX
			FONTOAM_SetPaletteNo( bttn->font, IMC_FONTBTTN_PLTT_OFS_OFF );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ʉJn
 *
 *	@param	bttn		{^IuWF
 *	@param	se			炷SE
 *	@param	state		̏
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void IMCBTTN_sndStart( IMC_BUTTON* bttn, int se, int timing, int state )
{
	if( state == timing ){

		// {^
		Snd_SePlay( se );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{^p쐬
 *
 *	@param	drawData	`VXef[^
 *	@param	arcID		A[JCuID
 *	@param	dataID		f[^ID
 *	@param	msgID		bZ[WID
 *	@param	bmp_x		쐬rbg}bv̑傫
 *	@param	bmp_y		쐬rbg}bv̑傫
 *
 *	@return	쐬rbg}bv
 *
 *
 */
//-----------------------------------------------------------------------------
static GF_BGL_BMPWIN* getBttnStr( IMC_DRAW_DATA* drawData, u32 arcID, u32 dataID, u32 msgID, int bmp_x, int bmp_y )
{
	MSGDATA_MANAGER* msg_data;
	STRBUF* str;
	GF_BGL_BMPWIN* bmp;

	msg_data = MSGMAN_Create( MSGMAN_TYPE_NORMAL, arcID, dataID, HEAPID_IMAGECLIP_DATA );
	GF_ASSERT( msg_data );
	str = MSGMAN_AllocString( msg_data, msgID );


	bmp = GF_BGL_BmpWinAllocGet( HEAPID_IMAGECLIP_DRAW, 1 );
	GF_BGL_BmpWinInit( bmp );
	GF_BGL_BmpWinObjAdd( drawData->BG_Ini, bmp, bmp_x, bmp_y, 0, 0 );

	// 񏑂
	GF_STR_PrintColor( bmp, FONT_BUTTON, str, 0, 0, MSG_NO_PUT, GF_PRINTCOLOR_MAKE(1,2,3), NULL );

	STRBUF_Delete( str );
	MSGMAN_Delete( msg_data );

	return bmp;
	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	j
 *
 *	@param	win 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteBttnStr( GF_BGL_BMPWIN* win )
{
	GF_BGL_BmpWinFree( win, 1 );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{^𓮂
 *
 *	@param	bttn		{^f[^
 *	@param	x			W
 *	@param	y			W
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void IMC_BTTN_Move( IMC_BUTTON* bttn, int x, int y )
{
	const VecFx32* get_mat;
	VecFx32	mat;	

	get_mat = CLACT_GetMatrix( bttn->clact_w );
	mat = *get_mat;
	mat.x += x << FX32_SHIFT;
	mat.y += y << FX32_SHIFT;
	CLACT_SetMatrix( bttn->clact_w, &mat );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	tHg{^𓮂
 *
 *	@param	bttn		tHg{^
 *	@param	x			l
 *	@param	y			l
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void IMC_FONTBTTN_Move( IMC_FONT_BUTTON* bttn, int x, int y )
{
	IMC_BTTN_Move( &bttn->button, x, y );
	FONTOAM_ReflectParentMat( bttn->font );
}

#if 0
// ANZT@BG@TEhύX{^̓GtFNgɂ͉Ȃ߁A
// ĂȂƂɂȂƂ̂ŁA
// {^VXeōsƂłȂB
//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT@BG@TEh	̃Aj[V
 *
 *	@param	data	C[WNbv{^f[^
 *	@param	flg		tO	
 *
 *	@return	none
 *
 * flg
	IMC_BTTN_ACE,		// ANZTύX
	IMC_BTTN_BG,		// BGύX
 *
 */
//-----------------------------------------------------------------------------
static void IMCBTTN_ace_bg_snd_anm( IMC_BUTTON_DATA* data, int flg )
{
	IMC_BUTTON* bttn;
	int state;
	int i;		// [vp
	
	bttn = &data->bttn[ flg ];

	state = IMC_BTTN_GetState( bttn );
	if( state == IMC_BTTN_PUSH_F ){

		// flg̃IuWFNg͉ꂽG
		// ̑̃IuWFNg̃{^𗣂Ԃɂ
		for( i=IMC_BTTN_ACE; i<=IMC_BTTN_SND; i++ ){

			bttn = data->bttn + i;
			
			if( i != flg ){
				// Gɂ
				IMC_BTTN_PopGra( bttn );
			}else{
				// Gɂ
				IMC_BTTN_PushGra( bttn );
			}
		}
	}
}
#endif

