//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_drawsys.c
 *	@brief		C[WNbv`VXef[^ǗVXe
 *				̃VXegp΁Aׂĕ`o悤ɂ܂B
 *	@author		tomoya takahashi
 *	@data		2005.09.21
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <string.h>
#include "system.h"
#include "assert.h"
#include "display.h"
#include "include/system/heapdefine.h"
#include "include/system/arc_util.h"
#include "include/system/arc_tool.dat"
#include "include/system/render_oam.h"
#include "char_manager.h"
#include "pltt_manager.h"
#include "include/gflib/gf_gx.h"


#define	__IMC_DRAWSYS_H_GLOBAL
#include "include/application/imageClip/imc_drawsys.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define IMC_DRAW_MAIN_PLANE	(GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_BG2 | GX_PLANEMASK_BG3 | GX_PLANEMASK_OBJ)
#define IMC_DRAW_SUB_PLANE	(GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1)


#define IMC_POKE_OBJ_TEX_SIZE	(0x2800)
#define IMC_POKE_OBJ_PLTT_SIZE	(0x20)


//-------------------------------------
//	
//	ZAN^[p
//	
//=====================================
#define	IMC_CHAR_NUM	(5)
#define IMC_PLTT_NUM	(2)
#define IMC_CELL_NUM	(16)

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
*		O[o
*/
//-----------------------------------------------------------------------------
/*
//	pbgItZbgΉ\
static u8 plttOfs[ IMC_ACCE_MAX ] = {
	0,0,1,1,0,0,0,0,0,0,		// 1~
	0,0,0,0,0,0,0,0,0,0,		// 11~
	0,0,0,0,0,0,0,0,0,0,		// 21~
	0,1,0,0,0,0,0,0,0,0,		// 31~
	0,0,0,0,0,0,0,0,0,0,		// 41~
	0,0,0,0,2,0,0,1,0,0,		// 51~
	0,0,0,0,0,0,0,0,0,0,		// 61~
	0,0,0,0,0,0,1,0,0,0,		// 71~
	0,0,0,0,0,0,0,0,0,0,		// 81~
	0,0,0,0,0,0,0,0,0,0,		// 91~
};
//*/

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void vram_bank_set( void );
static void setup_3d( void );
static void setup_2d_imgClip( void );

static void putback_3d( void );
static void putback_2d_imgClip( void );


static void initSWSP( IMC_DRAW_DATA* data, const SWSP_SYSDATA* cp_sys );
static void deleteSWSP( IMC_DRAW_DATA* data );
static void drawSWSP( IMC_DRAW_DATA* data );

static void initSoftSprite( IMC_DRAW_DATA* drawData, int heap, int tex_size, int pltt_size );
static void deleteSoftSprite( IMC_DRAW_DATA* drawData );

static void initAccePlttOfs( IMC_DRAW_DATA* data, int heap );
static void deleteAccePlttOfs( IMC_DRAW_DATA* data );

static void initCLACT( IMC_DRAW_DATA* data );
static void deleteCLACT( IMC_DRAW_DATA* data );
static void drawCLACT( IMC_DRAW_DATA* data );

static void initCharRes( IMC_DRAW_DATA* data );
static void deleteCharRes( IMC_DRAW_DATA* data );


static void loadSWSPChar( IMC_DRAW_DATA* data, SWSP_CHARDATA* char_data, int num );
static void loadSWSPPltt( IMC_DRAW_DATA* data, SWSP_PLTTDATA* pltt_data, int num );

static void setBg( IMC_DRAW_DATA* data );
static void delBg( IMC_DRAW_DATA* data );

static void getCharSize( NNSG2dCharacterData* char_data, int* x, int* y );

static void loadSWSPResDataAllocMemory( IMC_DRAW_LOADRES_DATA* loadData, int char_num, int pltt_num, int heap );
static void loadSWSPResDataDeleteMemory( IMC_DRAW_LOADRES_DATA* loadData );
static void loadAcceData( IMC_DRAW_DATA* drawData, IMC_DRAW_LOADRES_DATA* loadData );
static void loadBGThumData( IMC_DRAW_DATA* drawData, IMC_DRAW_LOADRES_DATA* loadData );

static void loadAcceDataPlayer( IMC_DRAW_DATA* drawData, IMC_DRAW_LOADRES_DATA* loadData, const void* data, int heap );

//----------------------------------------------------------------------------
//
/**
 *
 *	@brief	`VXe`o悤Ɋݒ肵܂
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_SetUp( void )
{
	// oNݒ
	vram_bank_set();
	
	// RDݒ
	setup_3d();
	
	// QDݒ
	setup_2d_imgClip();

	// `ύX
	sys.disp3DSW = DISP_3D_TO_SUB;
	GF_Disp_DispSelect();
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ݒ肵f[^j܂
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_PutBack( void )
{
	// `ύX
	sys.disp3DSW = DISP_3D_TO_MAIN;
	GF_Disp_DispSelect();
	
	// 2dݒj
	putback_2d_imgClip();

	// 3dݒj
	putback_3d();

	GX_ResetBankForTex();
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`pVXe̐ݒs܂B
 *
 *	@param	drawData	`f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_InitSys( IMC_DRAW_DATA* drawData )
{
	// XvCgf[^쐬
	SWSP_SYSDATA swsp = {
		IMC_SPRITE_OBJ_NUM,
		IMC_SPRITE_CHAR_NUM,
		IMC_SPRITE_PLTT_NUM,
		HEAPID_IMAGECLIP_DRAW
	};//*/
	initSWSP( drawData, &swsp );

	// |P`XvCgf[^쐬
	initSoftSprite( drawData, HEAPID_IMAGECLIP_DRAW, IMC_POKE_OBJ_TEX_SIZE, IMC_POKE_OBJ_PLTT_SIZE );

	// LN^\[X}l[W쐬	o^ő吔@=@IMC_SPRITE_OBJ_CHAR_NUM
	initCharRes( drawData );

	// ANZTppbgItZbge[u쐬
	initAccePlttOfs( drawData, HEAPID_IMAGECLIP_DATA );

	// ZAN^[쐬
	initCLACT( drawData );

	// BGVXef[^쐬
	drawData->BG_Ini = GF_BGL_BglIniAlloc( HEAPID_IMAGECLIP_DRAW );
	setBg( drawData );

}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXef[^j
 *
 *	@param	drawData	`f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_DeleteSys( IMC_DRAW_DATA* drawData )
{
	// pbgItZbge[uj
	deleteAccePlttOfs( drawData );
	
	// XvCgf[^j
	deleteSWSP( drawData );

	// BGVXef[^j
	delBg( drawData );
	sys_FreeMemoryEz( drawData->BG_Ini );
	
	// |P`VXej
	deleteSoftSprite( drawData );

	// ZAN^[j
	deleteCLACT( drawData );

	// LN^f[^j
	deleteCharRes( drawData );

	// LN^f[^ۑ̈j
	sys_FreeMemoryEz( drawData->SWSP_charData );
	drawData->SWSP_charData = NULL;
	
	// pbgf[^ۑ̈j
	sys_FreeMemoryEz( drawData->SWSP_plttData );
	drawData->SWSP_plttData = NULL;
	
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	`֐̂`VXe̕`
 *
 *	@param	drawData	`f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_DrawSys( IMC_DRAW_DATA* drawData )
{
	//Rc`Jn
	GF_G3X_Reset();

	NNS_G2dSetupSoftwareSpriteCamera();

	// XvCg`
	drawSWSP( drawData );	
	
	// |P`
	SoftSpriteMain( drawData->SSM_drawSys );
	
	/* WIg_OGW֘ÃXbv */
	GF_G3_RequestSwapBuffers(GX_SORTMODE_AUTO, GX_BUFFERMODE_Z);

	// QD`
	// ZAN^[`
	drawCLACT( drawData );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\[X̓ǂݍ݂s܂	XVramɓWJ܂
 *
 *	@param	drawData	`f[^i[̈
 *	@param	loadData	ǂݍރ\[Xf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_LoadResource( IMC_DRAW_DATA* drawData, IMC_DRAW_LOADRES_DATA* loadData )
{
	// LN^f[^ǂݍ
	loadSWSPChar( drawData, loadData->SWSP_charTbl, loadData->SWSP_charNum );
	
	// pbgf[^ǂݍ
	loadSWSPPltt( drawData, loadData->SWSP_plttTbl, loadData->SWSP_plttNum );


}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\[X̔js܂
 *
 *	@param	drawData	`f[^i[̈
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_DeleteResource( IMC_DRAW_DATA* drawData )
{
	// XvCgf[^Sj
	SWSP_CharDeleteAll( drawData->SWSP_drawSys );
	SWSP_PlttDeleteAll( drawData->SWSP_drawSys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^f[^ǂݍ
 *
 *	@param	drawData		`VXef[^
 *	@param	fileIdx			t@CCfbNX
 *	@param	dataIdx			f[^CfbNX
 *	@param	comp			ktO
 *	@param	vramType		Vram^Cv
 *	@param	id				ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_CLACT_LoadCharData( IMC_DRAW_DATA* drawData, int fileIdx, int dataIdx, BOOL comp, int vramType, int id )
{
	CLACT_U_RES_OBJ_PTR res;
	
	// f[^ǂݍ
	res = CLACT_U_ResManagerResAddArcChar( 
			drawData->resMan[ CLACT_U_CHAR_RES ],
			fileIdx, dataIdx, comp, id, vramType,
			HEAPID_IMAGECLIP_DRAW);

	// f[^]
	CLACT_U_CharManagerSetAreaCont( res );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgf[^ǂݍ
 *
 *	@param	drawData		`VXef[^
 *	@param	fileIdx			t@CCfbNX
 *	@param	dataIdx			f[^CfbNX
 *	@param	comp			ktO
 *	@param	vramType		Vram^Cv
 *	@param	load_num		pbgǂݍݐ
 *	@param	id				ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_CLACT_LoadPlttData( IMC_DRAW_DATA* drawData, int fileIdx, int dataIdx, BOOL comp, int vramType, int load_num, int id )
{
	CLACT_U_RES_OBJ_PTR	res;
	
	// f[^ǂݍ
	res = CLACT_U_ResManagerResAddArcPltt( 
			drawData->resMan[ CLACT_U_PLTT_RES ],
			fileIdx, dataIdx, comp, id, vramType,
			load_num, HEAPID_IMAGECLIP_DRAW);

	// f[^]
	CLACT_U_PlttManagerSetCleanArea( res );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Zf[^ǂݍ
 *
 *	@param	drawData		`VXef[^
 *	@param	fileIdx			t@CCfbNX
 *	@param	dataIdx			f[^CfbNX
 *	@param	comp			ktO
 *	@param	id				ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_CLACT_LoadCellData( IMC_DRAW_DATA* drawData, int fileIdx, int dataIdx, BOOL comp, int id )
{
	// f[^ǂݍ
	CLACT_U_ResManagerResAddArcKindCell( 
			drawData->resMan[ CLACT_U_CELL_RES ],
			fileIdx, dataIdx, comp, id, CLACT_U_CELL_RES,
			HEAPID_IMAGECLIP_DRAW);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAjf[^ǂݍ
 *
 *	@param	drawData		`VXef[^
 *	@param	fileIdx			t@CCfbNX
 *	@param	dataIdx			f[^CfbNX
 *	@param	comp			ktO
 *	@param	id				ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_CLACT_LoadCellAnmData( IMC_DRAW_DATA* drawData, int fileIdx, int dataIdx, BOOL comp, int id )
{
	// f[^ǂݍ
	CLACT_U_ResManagerResAddArcKindCell( 
			drawData->resMan[ CLACT_U_CELLANM_RES ],
			fileIdx, dataIdx, comp, id, CLACT_U_CELLANM_RES,
			HEAPID_IMAGECLIP_DRAW);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^\[Xf[^݂̂̔j
 *
 *	@param	drawData	`VXef[^
 *	@param	id			ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_CLACT_DeleteCharRes( IMC_DRAW_DATA* drawData, int id )
{
	CLACT_U_RES_OBJ_PTR	res;

	res = CLACT_U_ResManagerGetIDResObjPtr(
			drawData->resMan[ CLACT_U_CHAR_RES ], id);

	// \[Xj
	CLACT_U_ResManagerResDelete( 
			drawData->resMan[ CLACT_U_CHAR_RES ], res );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbg\[Xf[^݂̂̔j
 *
 *	@param	drawData	`VXef[^
 *	@param	id			ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_CLACT_DeletePlttRes( IMC_DRAW_DATA* drawData, int id )
{
	CLACT_U_RES_OBJ_PTR	res;

	res = CLACT_U_ResManagerGetIDResObjPtr(
			drawData->resMan[ CLACT_U_PLTT_RES ], id);

	CLACT_U_ResManagerResDelete( 
			drawData->resMan[ CLACT_U_PLTT_RES ], res );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Z\[Xf[^݂̂̔j
 *
 *	@param	drawData	`VXef[^
 *	@param	id			ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_CLACT_DeleteCellRes( IMC_DRAW_DATA* drawData, int id )
{
	CLACT_U_RES_OBJ_PTR	res;

	res = CLACT_U_ResManagerGetIDResObjPtr(
			drawData->resMan[ CLACT_U_CELL_RES ], id);

	// \[Xj
	CLACT_U_ResManagerResDelete( 
			drawData->resMan[ CLACT_U_CELL_RES ], res );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAjf[^݂̂̔j
 *
 *	@param	drawData	`VXef[^
 *	@param	id			ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_CLACT_DeleteCellAnmRes( IMC_DRAW_DATA* drawData, int id )
{
	CLACT_U_RES_OBJ_PTR	res;

	res = CLACT_U_ResManagerGetIDResObjPtr(
			drawData->resMan[ CLACT_U_CELLANM_RES ], id);

	CLACT_U_ResManagerResDelete( 
			drawData->resMan[ CLACT_U_CELLANM_RES ], res );
}



//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgp̓ǂݍރt@C쐬	
 *
 *	@param	loadData	쐬
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_MakeLoadSWSP_samp( IMC_DRAW_DATA* drawData, IMC_DRAW_LOADRES_DATA* loadData )
{
	// SWSP̃\[Xo^f[^m
	loadSWSPResDataAllocMemory( loadData, IMC_SPRITE_CHAR_NUM, IMC_SPRITE_PLTT_NUM, HEAPID_IMAGECLIP_DRAW );
	
	// ANZTp\[X
	loadAcceData( drawData, loadData );

	// BGTlCp\[X
	loadBGThumData( drawData, loadData );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgp̓ǂݍ݃t@Cj
 *
 *	@param	loadData	ǂݍ݃f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_DestLoadSWSP( IMC_DRAW_LOADRES_DATA* loadData )
{
	loadSWSPResDataDeleteMemory( loadData );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^f[^̓o^
 *
 *	@param	drawData	`f[^\
 *	@param	buff		LN^f[^obt@
 *	@param	char_no		o^LN^io[iANZTio[Linkj
 *
 *	@return	ApbÑLN^f[^
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dCharacterData* IMC_DRAW_SetCharData( IMC_DRAW_DATA* drawData, void* buff, int char_no )
{
	// \[X}l[Wɓo^
	RESM_AddResNormal( drawData->SWSP_charRes, buff, char_no );		
	NNS_G2dGetUnpackedCharacterData( buff, &drawData->SWSP_UPchar[ char_no ] );

	return drawData->SWSP_UPchar[ char_no ];
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ʏ펞̃EBhE}XNݒ
 *
 *	@param	none	
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_WndMaskNormalSet( void )
{
/*	GX_SetVisibleWnd(GX_WNDMASK_W0 | GX_WNDMASK_W1);

	G2_SetWnd0InsidePlane( GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG2, FALSE );
	G2_SetWnd1InsidePlane( GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG3, FALSE );
	G2_SetWndOutsidePlane( GX_WND_PLANEMASK_BG1, FALSE );
	
	G2_SetWnd0Position( IMC_LBOX_AREA_X,
						IMC_LBOX_AREA_Y,
						IMC_LBOX_AREA_X + IMC_LBOX_AREA_WIDTH,
						IMC_LBOX_AREA_Y + IMC_LBOX_AREA_HEIGHT);
	
	G2_SetWnd1Position( IMC_RBOX_AREA_X,
						IMC_RBOX_AREA_Y,
						IMC_RBOX_AREA_X + IMC_RBOX_AREA_WIDTH,
						IMC_RBOX_AREA_Y + IMC_RBOX_AREA_HEIGHT);//*/
	GX_SetVisibleWnd(GX_WNDMASK_NONE);
	// BGD揇ʂ̕ύX
	G2_SetBG0Priority( 1 );
	G2_SetBG1Priority( 0 );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	IuWFNg𓮂ĂƂ̃EBhE}XNݒ
 *
 *	@param	none	
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_WndMaskObjMoveSet( void )
{
	GX_SetVisibleWnd(GX_WNDMASK_W0);

	G2_SetWnd0InsidePlane( GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG1 | GX_WND_PLANEMASK_BG2 | GX_WND_PLANEMASK_BG3 | GX_WND_PLANEMASK_OBJ, FALSE );
	G2_SetWndOutsidePlane( GX_WND_PLANEMASK_BG1 | GX_WND_PLANEMASK_OBJ, FALSE );

	// |WVݒ
	// t[̕llݒ
	G2_SetWnd0Position( IMC_LBOX_AREA_X + IMC_BOX_AREA_FRAME_WIDHT,
						IMC_LBOX_AREA_Y + IMC_BOX_AREA_FRAME_HEIGHT,
						IMC_RBOX_AREA_X + IMC_RBOX_AREA_WIDTH - IMC_BOX_AREA_FRAME_WIDHT,
						IMC_RBOX_AREA_Y + IMC_RBOX_AREA_HEIGHT - IMC_BOX_AREA_FRAME_HEIGHT );
	// BGD揇ʂ̕ύX
	G2_SetBG0Priority( 0 );
	G2_SetBG1Priority( 1 );//*/
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbN̕\D揇ʐݒ
 *
 *	@param	none	
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_EndCheckBGPri( void )
{
	G2_SetBG1Priority( 3 );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXepVuN֐
 *
 *	@param	drawData	`VXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_VBlank( IMC_DRAW_DATA* drawData )
{
	// BGVXeVblank֐
	GF_BGL_VBlankFunc( drawData->BG_Ini );

	// \tgEFAXvCg
	SoftSpriteTextureTrans( drawData->SSM_drawSys );

	// _[LOAM}l[WOAM]
	REND_OAMTrans();
}


//-----------------------------------------------------------------------------
/**
*		LN^f[^āAقƂɂ̈ʒuɔFȊO̐FɂȂ
*		邩`FbN
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^f[^̎wʒuɐFparamŖ`FbN
 *
 *	@param	char_data		`FbNɎgLN^f[^
 *	@param	offs_x			xItZbg
 *	@param	offs_y			yItZbg
 *	@param	param			`FbNFio[
 *
 *	@retval	IMC_DRAW_CHAR_CHECK_TRUE	param̐F
 *	@retval	IMC_DRAW_CHAR_CHECK_FALSE	param̐FȂ
 *	@retval	IMC_DRAW_CHAR_CHECK_ERR		G[
 *
 * PUF
 *
 */
//-----------------------------------------------------------------------------
int IMC_DRAW_CharCheck( NNSG2dCharacterData* char_data, int offs_x, int offs_y, int param )
{
	u32* char_res;				// LN^f[^
	int char_x, char_y;			// LN^f[^TCY
	int char_px;				// `FbNf[^io[
	int char_px_offs;			// `FbNf[^ItZbg


		
	// LN^f[^TCYvZ
	char_x = char_data->W;
	char_y = char_data->H;
	char_x *= 8;		// sNZPʂɂ
	char_y *= 8;		// sNZPʂɂ

	// TCYover`FbN
	if( (offs_x < 0) || (offs_y < 0) ||
		(offs_x >= char_x) || (offs_y >= char_y) ){

		return IMC_DRAW_CHAR_CHECK_ERR;
	}

//	OS_Printf( "char_x %d, char_y %d\n", char_data->W, char_data->H );

	// LN^f[^擾
	char_res = char_data->pRawData;

	// ItZbgʒũLN^io[
	char_px = (offs_y * char_x) + offs_x;
	char_px_offs = (char_px % 8);	// u328sNZ邽
	char_px /= 8;

//	OS_Printf( "char_px %d char_px_offs %d \n",char_px, char_px_offs );

//	OS_Printf( "%x \n", char_res[ char_px ] );
	
//	OS_Printf( " %d \n", (char_res[ char_px ] & (0xf << (char_px_offs * 4))) );

//	OS_Printf( " %d \n", ((param << (char_px_offs * 4))) );
	
	// ̃LN^f[^`FbN
	if( (char_res[ char_px ] & (0xf << (char_px_offs * 4))) == (param << (char_px_offs * 4)) ){
		return IMC_DRAW_CHAR_CHECK_TRUE;
	}
	return IMC_DRAW_CHAR_CHECK_FALSE;
}


//-----------------------------------------------------------------------------
/**
 * 
 *	C[WNbvvC[VXep֐S
 * 
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXe	C[WNbvvC[pݒ
 *
 *	@param	drawData	`VXef[^i[
 *	@param	cp_swsp		\tgEFAVXef[^
 *	@param	BG_Ini		BGVXe
 *	@param	heap		gpq[vID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_InitSysPlayer( IMC_DRAW_DATA* drawData, const SWSP_SYSDATA* cp_swsp, GF_BGL_INI* BG_Ini, int heap )
{

	// XvCgf[^쐬
	initSWSP( drawData, cp_swsp );

	// |P`XvCgf[^쐬
	initSoftSprite( drawData, heap, IMC_POKE_OBJ_TEX_SIZE, IMC_POKE_OBJ_PLTT_SIZE );

	// ANZTppbgItZbge[u쐬
	initAccePlttOfs( drawData, heap );

	// BGIni͊O󂯎
	drawData->BG_Ini = BG_Ini;

	{	// Cʃt[2
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
			2, 0, 0, FALSE
		};
		GF_BGL_BGControlExit( drawData->BG_Ini, GF_BGL_FRAME2_M );
		GF_BGL_BGControlSet( drawData->BG_Ini, GF_BGL_FRAME2_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( GF_BGL_FRAME2_M, 32, 0, heap );
		GF_BGL_ScrClear( drawData->BG_Ini, GF_BGL_FRAME2_M );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXef[^j
 *
 *	@param	drawData	`f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_DeleteSysPlayer( IMC_DRAW_DATA* drawData )
{
	// pbgItZbge[uj
	deleteAccePlttOfs( drawData );
	
	// XvCgf[^j
	deleteSWSP( drawData );

	// |P`VXej
	deleteSoftSprite( drawData );

	// LN^f[^ۑ̈j
	sys_FreeMemoryEz( drawData->SWSP_charData );
	drawData->SWSP_charData = NULL;
	
	// pbgf[^ۑ̈j
	sys_FreeMemoryEz( drawData->SWSP_plttData );
	drawData->SWSP_plttData = NULL;

	//BGj
	GF_BGL_BGControlExit( drawData->BG_Ini, GF_BGL_FRAME2_M );
}

//----------------------------------------------------------------------------
/**
 *	@brief	XvCgp̓ǂݍރt@C쐬	C[WNbvvC[p
 *
 *	@param	drawData	`VXef[^
 *	@param	loadData	쐬
 *	@param	save_data	\zf[^
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_MakeLoadSWSP_player( IMC_DRAW_DATA* drawData, IMC_DRAW_LOADRES_DATA* loadData, const void* save_data, int heap )
{
	// SWSP̃\[Xo^f[^m
	loadSWSPResDataAllocMemory( loadData, IMC_SPRITE_CHAR_NUM, IMC_SPRITE_PLTT_NUM, heap );
	
	// ANZTp\[X
	loadAcceDataPlayer( drawData, loadData, save_data, heap );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXepVuN֐
 *
 *	@param	drawData	`VXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_VBlankPlayer( IMC_DRAW_DATA* drawData )
{
	// \tgEFAXvCg
	SoftSpriteTextureTrans( drawData->SSM_drawSys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`֐̂`VXe̕`
 *
 *	@param	drawData	`f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_DRAW_DrawSysPlayer( IMC_DRAW_DATA* drawData )
{
	//Rc`Jn
	GF_G3X_Reset();

	NNS_G2dSetupSoftwareSpriteCamera();

	// XvCg`
	drawSWSP( drawData );	
	
	// |P`
	SoftSpriteMain( drawData->SSM_drawSys );
	
	/* WIg_OGW֘ÃXbv */
	GF_G3_RequestSwapBuffers(GX_SORTMODE_AUTO, GX_BUFFERMODE_Z);
}




//-----------------------------------------------------------------------------
/**
*	vCx[g֐
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	oNݒ
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void vram_bank_set( void )
{
	GF_BGL_DISPVRAM vramSetTable = {
		GX_VRAM_BG_64_E,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_48_HI,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_16_G,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_NONE,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_012_ABC,			// eNX`C[WXbg
		GX_VRAM_TEXPLTT_0_F				// eNX`pbgXbg
	};
	GF_Disp_SetBank( &vramSetTable );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	3Dʐݒ
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setup_3d( void )
{
	// NitroSystem:RcGW̏
	NNS_G3dInit();
	// }gNXX^bN̏
    G3X_InitMtxStack();

	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
    G2_SetBG0Priority(1);

	// e`惂[h̐ݒ(VF[hA`GCAX)
    G3X_SetShading(GX_SHADING_TOON);
    G3X_AntiAlias(TRUE);
	G3X_AlphaTest(FALSE, 0);	// At@eXg@@It
	G3X_AlphaBlend(TRUE);		// At@uh@I

	// NAJ[̐ݒ
    G3X_SetClearColor(GX_RGB(0, 0, 0),	// clear color
                      0,				// clear alpha
                      0x7fff,			// clear depth
                      63,				// clear polygon ID
                      FALSE				// fog
                      );

	// WIgGWNKĂ΂Ȃ΂ȂȂ
    G3_SwapBuffers(GX_SORTMODE_AUTO, GX_BUFFERMODE_W);

	// r[|[g̐ݒ
    G3_ViewPort(0, 0, 255, 191);

	// }l[WeNX`C[WXbgwXbgǗł悤ɂ
	// ftHg}l[WɂB
	NNS_GfdInitFrmTexVramManager(3, TRUE);
		
	// }l[Wpbg16KBǗł悤ɂ
	// ftHg}l[WɂB
	NNS_GfdInitFrmPlttVramManager(0x4000, TRUE);
	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvʗp2Dʐݒ
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setup_2d_imgClip( void )
{
	// BGݒ
	{
		GF_BGL_SYS_HEADER bg_head = {
			GX_DISPMODE_GRAPHICS,
			GX_BGMODE_0,
			GX_BGMODE_0,
			GX_BG0_AS_3D
		};
		GF_BGL_InitBG( &bg_head );
	}
	
	// OBJݒ
	// }bsO[hUSK
	GX_SetOBJVRamModeChar( GX_OBJVRAMMODE_CHAR_1D_64K );
	// OAM}l[W
	NNS_G2dInitOamManagerModule();

	// `ʐݒ
	GF_Disp_GX_VisibleControlInit();
	GF_Disp_GXS_VisibleControlInit();
	GF_Disp_GX_VisibleControl( IMC_DRAW_MAIN_PLANE, VISIBLE_ON );
	GF_Disp_GXS_VisibleControl( IMC_DRAW_SUB_PLANE, VISIBLE_ON );

}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	RDݒŎgpj
 *
 *	@param	none 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void putback_3d( void )
{
	NNS_GfdResetFrmTexVramState();
	NNS_GfdResetFrmPlttVramState();
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	QݒŎgpj
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void putback_2d_imgClip( void )
{
	GF_Disp_GX_VisibleControlInit();
	GF_Disp_GXS_VisibleControlInit();
	// OAM}l[W
	NNS_G2dInitOamManagerModule();
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\tgEFAXvCg
 *
 *	@param	data	`f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initSWSP( IMC_DRAW_DATA* data, const SWSP_SYSDATA* cp_sys )
{
/*	SWSP_SYSDATA sys = {
		IMC_SPRITE_OBJ_NUM,
		IMC_SPRITE_CHAR_NUM,
		IMC_SPRITE_PLTT_NUM,
		HEAPID_IMAGECLIP_DRAW
	};//*/

	data->SWSP_drawSys = SWSP_SysInit( cp_sys );

	// LN^f[^i[p̈쐬
	data->SWSP_charData = sys_AllocMemory( cp_sys->heap, sizeof(SWSP_CHAR_PTR) * IMC_SPRITE_CHAR_NUM );
	
	data->SWSP_charNum = IMC_SPRITE_CHAR_NUM;
	data->SWSP_charNow = 0;

	// pbgf[^i[̈쐬
	data->SWSP_plttData = sys_AllocMemory( cp_sys->heap, sizeof(SWSP_PLTT_PTR) * IMC_SPRITE_PLTT_NUM );
	data->SWSP_plttNum = IMC_SPRITE_PLTT_NUM;
	data->SWSP_plttNow = 0;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\tgEFAXvCgj
 *
 *	@param	data	`f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteSWSP( IMC_DRAW_DATA* data )
{
	SWSP_SysDelete( data->SWSP_drawSys );
	data->SWSP_drawSys = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgVXe̕`
 *
 *	@param	data	`f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void drawSWSP( IMC_DRAW_DATA* data )
{
	SWSP_SysDraw( data->SWSP_drawSys );
	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^f[^]
 *
 *	@param	data		`VXef[^
 *	@param	char_data	LN^f[^
 *	@param	num			]LN^f[^
 *
 *	@return	none
 *
 * char_data̗vfLN^f[^ǗIDƂȂ܂
 *
 */
//-----------------------------------------------------------------------------
static void loadSWSPChar( IMC_DRAW_DATA* data, SWSP_CHARDATA* char_data, int num )
{
	int i;		// [vp

	for(i=0; i<num; i++){

		GF_ASSERT( data->SWSP_charNow < data->SWSP_charNum );

		// ANZT@TlC̑ΉʒuɓKv邽߁A
		// i[΂Ƃ
		if(char_data[i].res_file != NULL){
			data->SWSP_charData[ data->SWSP_charNow ] = SWSP_CharLoad( char_data + i );
		}else{
			data->SWSP_charData[ data->SWSP_charNow ] = NULL;
		}
		data->SWSP_charNow++;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgf[^]
 *
 *	@param	data			`VXef[^
 *	@param	pltt_data		pbg]f[^
 *	@param	num				pbg	
 *		
 *	@return	none
 *
 * pltt_data̗vfpbgǗIDƂȂ܂
 *
 */
//-----------------------------------------------------------------------------
static void loadSWSPPltt( IMC_DRAW_DATA* data, SWSP_PLTTDATA* pltt_data, int num )
{
	int i;		// [vp

	for(i=0; i<num; i++){

		GF_ASSERT( data->SWSP_plttNow < data->SWSP_plttNum );
		
		// ANZT@TlC̑ΉʒuɓKv邽߁A
		// i[΂Ƃ
		if(pltt_data[i].res_file != NULL){
			data->SWSP_plttData[ data->SWSP_plttNow ] = SWSP_PlttLoad( pltt_data + i );
		}else{
			data->SWSP_plttData[ data->SWSP_plttNow ] = NULL;
		}

		data->SWSP_plttNow++;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGʐݒs
 *
 *	@param	data	`VXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setBg( IMC_DRAW_DATA* data )
{
	
	{	// Cʃt[1
		GF_BGL_BGCNT_HEADER  TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( data->BG_Ini, GF_BGL_FRAME1_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( GF_BGL_FRAME1_M, 32, 0, HEAPID_IMAGECLIP_DRAW );
		GF_BGL_ScrClear( data->BG_Ini, GF_BGL_FRAME1_M );
	}
	
	{	// Cʃt[2
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
			2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( data->BG_Ini, GF_BGL_FRAME2_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( GF_BGL_FRAME2_M, 32, 0, HEAPID_IMAGECLIP_DRAW );
		GF_BGL_ScrClear( data->BG_Ini, GF_BGL_FRAME2_M );
	}

	{	// Cʃt[3
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, -(IMC_LBOX_AREA_Y + IMC_LBOX_AREA_HEIGHT), 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x08000, GX_BG_EXTPLTT_01,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( data->BG_Ini, GF_BGL_FRAME3_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( GF_BGL_FRAME3_M, 32, 0, HEAPID_IMAGECLIP_DRAW );
		GF_BGL_ScrClear( data->BG_Ini, GF_BGL_FRAME3_M );
	}

	// Tuʐݒ
	{	// Tuʃt[0
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x7800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( data->BG_Ini, GF_BGL_FRAME0_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( GF_BGL_FRAME0_S, 32, 0, HEAPID_IMAGECLIP_DRAW );
		GF_BGL_ScrClear( data->BG_Ini, GF_BGL_FRAME0_S );
	}

	{	// Cʃt[3
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x7000, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( data->BG_Ini, GF_BGL_FRAME1_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( GF_BGL_FRAME1_S, 32, 0, HEAPID_IMAGECLIP_DRAW );
		GF_BGL_ScrClear( data->BG_Ini, GF_BGL_FRAME1_S );
	}
	// EBhE}XNBG̐ݒ
//	IMC_DRAW_WndMaskNormalSet();
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGʐݒj
 *
 *	@param	data	`VXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void delBg( IMC_DRAW_DATA* data )
{
	GF_BGL_BGControlExit( data->BG_Ini, GF_BGL_FRAME1_M );
	GF_BGL_BGControlExit( data->BG_Ini, GF_BGL_FRAME2_M );
	GF_BGL_BGControlExit( data->BG_Ini, GF_BGL_FRAME3_M );
	GF_BGL_BGControlExit( data->BG_Ini, GF_BGL_FRAME0_S );
	GF_BGL_BGControlExit( data->BG_Ini, GF_BGL_FRAME1_S );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^\[Xf[^쐬
 *
 *	@param	data	`f[^\
 *
 *	@return	none
 *
 * ^b`pl蔻Ɏgp܂
 *
 */
//-----------------------------------------------------------------------------
static void initCharRes( IMC_DRAW_DATA* data )
{
	data->SWSP_charRes = RESM_Init( IMC_SPRITE_OBJ_CHAR_NUM, HEAPID_IMAGECLIP_DRAW );
	data->SWSP_UPchar = sys_AllocMemory( HEAPID_IMAGECLIP_DRAW,
			sizeof(NNSG2dCharacterData*) * IMC_SPRITE_OBJ_CHAR_NUM );

	memset( data->SWSP_UPchar, 0, sizeof(NNSG2dCharacterData*) * IMC_SPRITE_OBJ_CHAR_NUM );
	
	data->SWSP_UPcharNum = IMC_SPRITE_OBJ_CHAR_NUM;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^\[Xf[^j
 *
 *	@param	data 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteCharRes( IMC_DRAW_DATA* data )
{
	sys_FreeMemoryEz( data->SWSP_UPchar );
	RESM_Delete( data->SWSP_charRes );	
	data->SWSP_UPcharNum = 0;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAN^[
 *
 *	@param	data	`VXef[^ 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initCLACT( IMC_DRAW_DATA* data )
{
	// LN^}l[W
	{
		CHAR_MANAGER_MAKE init = {
			IMC_CHAR_NUM, 0x4000, 0, HEAPID_IMAGECLIP_DRAW
		};

		InitCharManagerReg(&init, 
				GX_OBJVRAMMODE_CHAR_1D_32K,
				GX_OBJVRAMMODE_CHAR_1D_32K);
	}

	// pbg}l[W
	InitPlttManager(IMC_PLTT_NUM, HEAPID_IMAGECLIP_DRAW);

	// LN^ǂݍ݊JnItZbgݒ
	CharLoadStartAll();

	// pbgǂݍ݊JnItZbgݒ
	PlttLoadStartAll();

	
	// OAM}l[W[̏
	NNS_G2dInitOamManagerModule();


	// _pOAM}l[W쐬
	REND_OAMInit( 
	0, 128,		// COAMǗ̈
	0, 32,		// CʃAtBǗ̈
	0, 128,		// TuOAMǗ̈
	0, 32,		// TuʃAtBǗ̈
	HEAPID_IMAGECLIP_DRAW);
	
	// ZAN^[Zbg쐬
	data->clactSet = CLACT_U_SetEasyInit( IMC_CELL_NUM, 
			&data->renddata,
			HEAPID_IMAGECLIP_DRAW );

	// \[X}l[W̍쐬
	// LN^
	data->resMan[ CLACT_U_CHAR_RES ] = CLACT_U_ResManagerInit( 
			IMC_CHAR_NUM,
			CLACT_U_CHAR_RES,
			HEAPID_IMAGECLIP_DRAW );
	// pbg
	data->resMan[ CLACT_U_PLTT_RES ] = CLACT_U_ResManagerInit( 
			IMC_PLTT_NUM,
			CLACT_U_PLTT_RES,
			HEAPID_IMAGECLIP_DRAW );
	// Z
	data->resMan[ CLACT_U_CELL_RES ] = CLACT_U_ResManagerInit( 
			IMC_CELL_NUM,
			CLACT_U_CELL_RES,
			HEAPID_IMAGECLIP_DRAW );
	// ZAj
	data->resMan[ CLACT_U_CELLANM_RES ] = CLACT_U_ResManagerInit( 
			IMC_CELL_NUM,
			CLACT_U_CELLANM_RES,
			HEAPID_IMAGECLIP_DRAW );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAN^[j
 *
 *	@param	data	`VXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteCLACT( IMC_DRAW_DATA* data )
{
	// AN^[Zbgj
	CLACT_DestSet(data->clactSet);

	// \[X}l[Wj
	{
		int i;
		for(i=0; i<IMC_DRAW_USE_RES_NUM; i++){
			CLACT_U_ResManagerDelete(data->resMan[i]);
		}
	}
	// LN^}l[Wj
	DeleteCharManager();

	// pbg}l[Wj
	DeletePlttManager();
	
	// _[LOAM}l[Wj
	REND_OAM_Delete();	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAN^[`
 *
 *	@param	data 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void drawCLACT( IMC_DRAW_DATA* data )
{
	// `
	CLACT_Draw(data->clactSet);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT\[Xt@Cǂݍ
 *
 *	@param	drawData	`VXef[^
 *	@param	loadData	ǂݍ݃f[^i[
 *
 *	@return	none
 *
 * pbg͌Œ̗vfʒuɓo^̂ňԍŏɕK
 * ANZT̃f[^ǂݍł
 * 
 *
 */
//-----------------------------------------------------------------------------
static void loadAcceData( IMC_DRAW_DATA* drawData, IMC_DRAW_LOADRES_DATA* loadData )
{
	int i;			// [vp
	int cont_id;	// f[^o^ID
	void* buff;

	// ANZTpf[^ǂݍ
	for(i=0; i<IMC_ACCE_MAX; i++ ){
		// LN^f[^擾
		buff = ArcUtil_Load(ARC_IMAGECLIP_GRA,
				IMC_ACCE_ARC_NO_GET( i ),
				FALSE, HEAPID_IMAGECLIP_DRAW, ALLOC_BOTTOM);

		// ǗID擾
		cont_id = IMC_ACCE_CHAR_CONT_ID(i);

		// \[X}l[Wɓo^
		// ApbÑf[^o^
		loadData->SWSP_charTbl[ cont_id ].res_file = IMC_DRAW_SetCharData( drawData, buff, i );
		
		// XvCg`VXe|C^ݒ
		loadData->SWSP_charTbl[ cont_id ].s_sys = drawData->SWSP_drawSys;
	}

	// pbgf[^o^
	buff = ArcUtil_Load(ARC_IMAGECLIP_GRA,
			IMC_DRAW_ACCESSORIE_PLTT_ARC, FALSE, HEAPID_IMAGECLIP_DRAW, ALLOC_BOTTOM);
	
	// \[X}l[Wɓo^
	RESM_AddResNormal( loadData->SWSP_plttRes, buff, IMC_DRAW_ACCESSORIE_PLTT_ID );		
	
	// ApbN
	NNS_G2dGetUnpackedPaletteData( buff,
			&loadData->SWSP_plttTbl[ IMC_DRAW_ACCESSORIE_PLTT_ID ].res_file );

	// `VXef[^
	loadData->SWSP_plttTbl[ IMC_DRAW_ACCESSORIE_PLTT_ID ].s_sys = drawData->SWSP_drawSys;

	// ǂݍ݂
	loadData->SWSP_plttTbl[ IMC_DRAW_ACCESSORIE_PLTT_ID ].load_num = IMC_DRAW_ACCESSORIE_PLTT_NUM;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTf[^̍쐬@vC[ȂǗp
 *
 *	@param	drawData		`VXef[^
 *	@param	loadData		ǂݍ݃f[^i[
 *	@param	data			쐬ANZT̃f[^
 *	@param	heap			gpq[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadAcceDataPlayer( IMC_DRAW_DATA* drawData, IMC_DRAW_LOADRES_DATA* loadData, const void* data, int heap )
{
	int i;			// [vp
	int cont_id;	// f[^o^ID
	void* buff;

	// ANZTpf[^ǂݍ
	for(i=0; i<IMC_ACCE_MAX; i++ ){
		// LN^f[^擾
		buff = ArcUtil_Load(ARC_IMAGECLIP_GRA,
				IMC_ACCE_ARC_NO_GET( i ),
				FALSE, heap, ALLOC_BOTTOM);

		// ǗID擾
		cont_id = IMC_ACCE_CHAR_CONT_ID(i);

		// \[X}l[Wɓo^
		RESM_AddResNormal( loadData->SWSP_charRes, buff, cont_id );		

		// ApbÑf[^o^
		NNS_G2dGetUnpackedCharacterData( buff, &loadData->SWSP_charTbl[ cont_id ].res_file );
		
		// XvCg`VXe|C^ݒ
		loadData->SWSP_charTbl[ cont_id ].s_sys = drawData->SWSP_drawSys;
	}

	// pbgf[^o^
	buff = ArcUtil_Load(ARC_IMAGECLIP_GRA,
			IMC_DRAW_ACCESSORIE_PLTT_ARC, FALSE, heap, ALLOC_BOTTOM);
	
	// \[X}l[Wɓo^
	RESM_AddResNormal( loadData->SWSP_plttRes, buff, IMC_DRAW_ACCESSORIE_PLTT_ID );		
	
	// ApbN
	NNS_G2dGetUnpackedPaletteData( buff,
			&loadData->SWSP_plttTbl[ IMC_DRAW_ACCESSORIE_PLTT_ID ].res_file );

	// `VXef[^
	loadData->SWSP_plttTbl[ IMC_DRAW_ACCESSORIE_PLTT_ID ].s_sys = drawData->SWSP_drawSys;

	// ǂݍ݂
	loadData->SWSP_plttTbl[ IMC_DRAW_ACCESSORIE_PLTT_ID ].load_num = IMC_DRAW_ACCESSORIE_PLTT_NUM;
	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGTlCp\[Xf[^ǂݍ
 *
 *	@param	drawData	`VXef[^
 *	@param	loadData	ǂݍ݃f[^i[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadBGThumData( IMC_DRAW_DATA* drawData, IMC_DRAW_LOADRES_DATA* loadData )
{
	int i;		// [vp
	void* buff;
	int num;		// o^

	// ANZTpf[^ǂݍ
	for(i=0; i<IMC_BG_RIGHT_MAX; i++ ){
		// LN^f[^擾
		buff = ArcUtil_Load(ARC_IMAGECLIP_GRA,
				IMC_BG_THUMB_CG_ARC_GET( i ),
				FALSE, HEAPID_IMAGECLIP_DRAW, ALLOC_BOTTOM);

		num = IMC_BG_THUMB_CHAR_CONT_ID(i);

		// ApbÑf[^o^
		loadData->SWSP_charTbl[ num ].res_file = IMC_DRAW_SetCharData( drawData, buff, num );
		
		// XvCg`VXe|C^ݒ
		loadData->SWSP_charTbl[ num ].s_sys = drawData->SWSP_drawSys;

		
		num = IMC_BG_THUMB_PLTT_CONT_ID(i);
		
		// pbgf[^o^
		buff = ArcUtil_Load(ARC_IMAGECLIP_GRA,
				IMC_BG_RIGHT_CL_ARC_GET(i), FALSE, HEAPID_IMAGECLIP_DRAW, ALLOC_BOTTOM);
		
		// \[X}l[Wɓo^
		RESM_AddResNormal( loadData->SWSP_plttRes, buff, num );				

		// ApbN
		NNS_G2dGetUnpackedPaletteData( buff,
				&loadData->SWSP_plttTbl[ num ].res_file );

		// `VXef[^
		loadData->SWSP_plttTbl[ num ].s_sys = drawData->SWSP_drawSys;

		// ǂݍ݂
		loadData->SWSP_plttTbl[ num ].load_num = IMC_BG_COLOR_NUM;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTpbgItZbge[u쐬
 *
 *	@param	data	`VXef[^
 *	@param	heap	q[vID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initAccePlttOfs( IMC_DRAW_DATA* data, int heap )
{
//	data->accePlttOfsTbl = plttOfs;
	data->accePlttOfsTbl = ArcUtil_Load( ARC_IMAGECLIP_GRA, IMC_ACCESSORIE_PLTT_LINK, FALSE, heap, ALLOC_TOP );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTpbgItZbgf[^j
 *
 *	@param	data	`VXef[^
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteAccePlttOfs( IMC_DRAW_DATA* data )
{
	sys_FreeMemoryEz( data->accePlttOfsTbl );
	data->accePlttOfsTbl = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|P`VXȅ
 *
 *	@param	drawData		i[
 *	@param	heap			q[vID
 *	@param	tex_size		eNX`TCY
 *	@param	pltt_size		pbgTCY
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initSoftSprite( IMC_DRAW_DATA* drawData, int heap, int tex_size, int pltt_size )
{
	NNSGfdTexKey	texKey;
	NNSGfdPlttKey	plttKey;

	// |Pf[^]̈Vrammہ]AhXƃTCYݒ
	drawData->SSM_drawSys = SoftSpriteInit( heap );	
	texKey = NNS_GfdAllocTexVram(tex_size, FALSE, 0);
	plttKey = NNS_GfdAllocPlttVram(pltt_size, FALSE, NNS_GFD_ALLOC_FROM_LOW);
	SoftSpriteTextureTransParamSet( 
			drawData->SSM_drawSys,
			NNS_GfdGetTexKeyAddr(texKey),
			NNS_GfdGetTexKeySize(texKey) );
	SoftSpritePaletteTransParamSet( 
			drawData->SSM_drawSys,
			NNS_GfdGetPlttKeyAddr(plttKey),
			NNS_GfdGetPlttKeySize(plttKey) );
/*
	OS_Printf( 
			" addr %x size %x \n",
			NNS_GfdGetTexKeyAddr(texKey),
			NNS_GfdGetTexKeySize(texKey) );
	OS_Printf( 
			" addr %x size %x \n ",
			NNS_GfdGetPlttKeyAddr(plttKey),
			NNS_GfdGetPlttKeySize(plttKey) );
//*/
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|P`VXe̔j
 *
 *	@param	drawData	
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteSoftSprite( IMC_DRAW_DATA* drawData )
{
	// |P`XvCgf[^j
	SoftSpriteEnd( drawData->SSM_drawSys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	SWSP̃\[Xo^f[^m
 *
 *	@param	loadData		o^f[^̃mې
 *	@param	char_num		LN^f[^
 *	@param	pltt_num		pbgf[^
 *	@param	heap			gpq[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadSWSPResDataAllocMemory( IMC_DRAW_LOADRES_DATA* loadData, int char_num, int pltt_num, int heap )
{
	// o^f[^̈쐬
	// LN^
	loadData->SWSP_charTbl = sys_AllocMemory( heap, sizeof(SWSP_CHARDATA) * char_num );
	memset( loadData->SWSP_charTbl, 0, sizeof(SWSP_CHARDATA) * char_num );
	loadData->SWSP_charRes = RESM_Init( char_num, heap );	// ApbNÕf[^i[
	loadData->SWSP_charNum = char_num;

	// pbg
	loadData->SWSP_plttTbl = sys_AllocMemory( heap, sizeof(SWSP_PLTTDATA) * pltt_num );
	memset( loadData->SWSP_plttTbl, 0, sizeof(SWSP_PLTTDATA) * pltt_num );
	loadData->SWSP_plttRes = RESM_Init( pltt_num, heap );	// ApbNÕf[^i[
	loadData->SWSP_plttNum = pltt_num;
	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	SWSP̃\[Xo^f[^j
 *
 *	@param	loadData		jf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadSWSPResDataDeleteMemory( IMC_DRAW_LOADRES_DATA* loadData )
{
	// 쐬f[^j
	// \[Xj
	if(loadData->SWSP_charRes){
		RESM_Delete( loadData->SWSP_charRes );
		loadData->SWSP_charRes = NULL;
	}
	if(loadData->SWSP_plttRes){
		RESM_Delete( loadData->SWSP_plttRes );
		loadData->SWSP_plttRes = NULL;
	}
	
	// o^f[^j
	sys_FreeMemoryEz( loadData->SWSP_charTbl );
	loadData->SWSP_charTbl = NULL;
	sys_FreeMemoryEz( loadData->SWSP_plttTbl );
	loadData->SWSP_plttTbl = NULL;
}
