//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_playsys.c
 *	@brief		C[WNbvvC[
 *	@author		tomoya takahashi 
 *	@data		2005.12.27
 *
 *
 * C[WNbvvbN쐬ĕ\ȊO̕@
 * \C[WNbvvC[
 * 
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <string.h>
#include "system.h"
#include "assert.h"
#include "calctool.h"
#include "calc2d.h"
#include "include/system/lib_pack.h"
#include "include/application/imageClip/imc_drawsys.h"
#include "include/application/imageClip/imc_accessorie.h"
#include "include/application/imageClip/imc_drawdata_define.h"
#include "include/application/imageClip/imc_right_box.h"
#include "include/application/imageClip/imc_obj_list.h"
#include "include/application/imageClip/imc_obj_list_func.h"
#include "include/application/imageClip/imc_rbox_player.h"

#define __IMC_PLAYSYS_H_GLOBAL
#include "include/application/imageClip/imc_playsys.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
typedef struct _IMC_PLAYERSYS{
	// `֌W
	IMC_DRAW_DATA drawSys;

	// IuWFNgXgf[^
	IMC_OBJLIST_TBL	objListTbl;

	// ANZTf[^
	IMC_ACCESSORIE_OBJ_TBL* acce;

	// Eʃf[^
	IMC_RIGHT_BOX rbox;
	IMC_RBOX_PLAYER rbox_player;		// E{bNXvC[

	// |Pf[^
	POKEMON_PARAM* poke_para;

	// q[vID
	int		heap_id;
} IMC_PLAYERSYS;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void initDrawSys( IMC_PLAYERSYS* p_sys, const IMC_PLAYERSYS_INIT* cp_init );
static void mainDrawSys( IMC_PLAYERSYS* p_sys );
static void deleteDrawSys( IMC_PLAYERSYS* p_sys );

static void initRightBox( IMC_PLAYERSYS* p_sys, const IMC_PLAYERSYS_INIT* cp_init );
static void deleteRightBox( IMC_PLAYERSYS* p_sys );


//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvC[
 *
 *	@param	cp_init		f[^
 *
 *	@return	ꂽf[^
 *
 */
//-----------------------------------------------------------------------------
IMC_PLAYERSYS_PTR IMC_PlayerInit( const IMC_PLAYERSYS_INIT* cp_init )
{
	IMC_PLAYERSYS* p_sys;		// C[WNbv[N
	BOOL	check;				// p


	// VXe[N
	p_sys = sys_AllocMemory( cp_init->heap_id, sizeof(IMC_PLAYERSYS) );
	memset( p_sys, 0, sizeof(IMC_PLAYERSYS) );

	// q[vID
	p_sys->heap_id	= cp_init->heap_id;
	p_sys->poke_para = PokemonParam_AllocWork( cp_init->heap_id );
	ImcSaveData_GetPokePara( cp_init->save_data, p_sys->poke_para );

	// `f[^ݒs܂B
	initDrawSys( p_sys, cp_init );

	// IuWFNgXge[u쐬
	IMC_OBJLIST_TblInit( &p_sys->objListTbl, IMC_OBJLIST_MAX, cp_init->heap_id );
	
	// ANZTi[f[^쐬
	p_sys->acce = IMC_ACCE_ObjTblInit( IMC_SYS_ACCESSORIE_MAX, cp_init->heap_id );

	// E{bNXf[^쐬
	initRightBox( p_sys, cp_init );

	// E{bNXvC[ɓo^
	IMC_RBOX_PLAYER_Init( &p_sys->rbox_player, &p_sys->rbox, cp_init->heap_id );

	return p_sys;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvC[C
 *
 *	@param	p_sys		C[WNbvvC[VXe
 *
 *	@retval	none
 *
 */
//-----------------------------------------------------------------------------
void IMC_PlayerMain( IMC_PLAYERSYS_PTR p_sys )
{
	// E{bNXvC[
	IMC_RBOX_PLAYER_Main( &p_sys->rbox_player );

	// `揈
	mainDrawSys( p_sys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvC[I
 *
 *	@param	p_sys		C[WNbvvC[VXe
 *
 *	@retval	none
 *
 */
//-----------------------------------------------------------------------------
void IMC_PlayerEnd( IMC_PLAYERSYS_PTR p_sys )
{
	// E{bNXj
	deleteRightBox( p_sys );

	// ANZTi[f[^j
	IMC_ACCE_ObjTblDelete( p_sys->acce );
	p_sys->acce = NULL;
	
	// IuWFNgXge[uj
	IMC_OBJLIST_TblDelete( &p_sys->objListTbl );
	
	// `VXej
	deleteDrawSys( p_sys );

	// |Pp[^j
	sys_FreeMemoryEz( p_sys->poke_para );

	sys_FreeMemoryEz( p_sys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VBlankԒɌĂԊ֐
 *
 *	@param	p_sys	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_PlayerVblank( IMC_PLAYERSYS_PTR p_sys )
{
	IMC_DRAW_VBlankPlayer( &p_sys->drawSys );
}






//-----------------------------------------------------------------------------
/**
 *
 *			vCx[g֐
 * 
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXef[^쐬
 *
 *	@param	p_sys			C[WNbvvC[VXe
 *	@param	cp_init			f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initDrawSys( IMC_PLAYERSYS* p_sys, const IMC_PLAYERSYS_INIT* cp_init )
{
	IMC_DRAW_LOADRES_DATA loadData;	// 摜f[^ǂݍ݃f[^

	// ʃf[^ݒ
//	IMC_DRAW_SetUp();

	// `VXe쐬
	// vC[p֐쐬Ă
	// ڍׁ@Kvȕ`VXe̍쐬
	//	\tgEFAXvCg
	//	ANZTpXvCg`VXe
	//	ANZTppbgItZbge[u
	SWSP_SYSDATA swsp;
	swsp.obj_num	= IMC_SPRITE_OBJ_NUM;
	swsp.char_num	= IMC_SPRITE_CHAR_NUM;
	swsp.pltt_num	= IMC_SPRITE_PLTT_NUM;
	swsp.heap		= cp_init->heap_id;
	IMC_DRAW_InitSysPlayer( &p_sys->drawSys, &swsp, cp_init->p_bg_ini, cp_init->heap_id );

	// `f[^쐬
	// vC[p֐쐬
	// ANZTf[^KvȃeNX`Apbg̃e[u
	// 쐬
	IMC_DRAW_MakeLoadSWSP_player( &p_sys->drawSys, &loadData, cp_init->save_data, cp_init->heap_id );

	// `f[^Vram]
	IMC_DRAW_LoadResource( &p_sys->drawSys, &loadData );

	// `f[^j
	IMC_DRAW_DestLoadSWSP( &loadData );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXeC֐
 *
 *	@param	p_sys	C[WNbvvC[VXe
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void mainDrawSys( IMC_PLAYERSYS* p_sys )
{
	IMC_DRAW_DrawSysPlayer( &p_sys->drawSys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXej֐
 *
 *	@param	p_sys	C[WNbvvC[VXe
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteDrawSys( IMC_PLAYERSYS* p_sys )
{
	// `f[^j
	IMC_DRAW_DeleteResource( &p_sys->drawSys );

	// `VXej
	IMC_DRAW_DeleteSysPlayer( &p_sys->drawSys );

	// `ʐݒj
//	IMC_DRAW_PutBack();
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNXf[^쐬
 *
 *	@param	p_sys		C[WNbvvC[VXe
 *	@param	cp_init		f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initRightBox( IMC_PLAYERSYS* p_sys, const IMC_PLAYERSYS_INIT* cp_init )
{
	IMC_RIGHT_BOX_INIT	rbox_init;	// E{bNXf[^
	int poke_x, poke_y, poke_pri;
	int bg_id;


	// E{bNXf[^쐬
	// `f[^
	rbox_init.SWSP_drawSys		= p_sys->drawSys.SWSP_drawSys;
	rbox_init.SWSP_charData		= p_sys->drawSys.SWSP_charData;
	rbox_init.SWSP_plttData		= p_sys->drawSys.SWSP_plttData;
	rbox_init.accePlttOfsTbl	= p_sys->drawSys.accePlttOfsTbl;
	rbox_init.SSM_drawSys		= p_sys->drawSys.SSM_drawSys;
	rbox_init.BG_Ini			= p_sys->drawSys.BG_Ini;

	rbox_init.acce		= p_sys->acce;			// ANZTf[^
	rbox_init.objListTbl= &p_sys->objListTbl;	// IuWFNgXge[u
	IMC_RBOX_InitSys( &p_sys->rbox, &rbox_init );
	
	// |Po^
	{
		SOFT_SPRITE_ARC	arc;
		poke_x = ImcSaveData_GetPokeX( cp_init->save_data );
		poke_y = ImcSaveData_GetPokeY( cp_init->save_data );
		poke_pri = ImcSaveData_GetPokePri( cp_init->save_data );
		IMC_RBOX_AddPokePlayer( &p_sys->rbox, p_sys->poke_para, &arc, poke_x, poke_y, poke_pri );
	}

	// E{bNXɔzuf[^쐬
	// f[^zus悤ɂ
	{
		int i;
		int x,y;
		int acce_no;
		s8 pri;
		for(i=0;i<IMC_RBOX_OBJ_MAX; i++){

			if( ImcSaveData_CheckAcceSet( cp_init->save_data, i ) ){
				acce_no = ImcSaveData_GetAcceNo( cp_init->save_data, i );
				x = ImcSaveData_GetAcceMatX( cp_init->save_data, i );
				y = ImcSaveData_GetAcceMatY( cp_init->save_data, i );
				pri = ImcSaveData_GetAccePri( cp_init->save_data, i );
				
				// ͉ɍ쐬
				IMC_RBOX_AddAccessorieEasy( &p_sys->rbox, acce_no, 
						x, y, pri );
			}
		}
	}//*/

	// BG\
	// f[^BG̃f[^NOݒ肷
	bg_id = ImcSaveData_GetBgId( cp_init->save_data );
	IMC_RBOX_BGSet( &p_sys->rbox, bg_id, cp_init->heap_id );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNXf[^j
 *
 *	@param	p_sys 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteRightBox( IMC_PLAYERSYS* p_sys )
{
	// BGN[
	IMC_RBOX_BGClean( &p_sys->rbox );
	
	// E{bNXzuf[^j
	IMC_RBOX_DeleteAccessorieAll( &p_sys->rbox );
	
	// E{bNXf[^j
	IMC_RBOX_DeleteSys( &p_sys->rbox );
}

