//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_poke_obj.c
 *	@brief		C[WNbv@|Pf[^	
 *	@author		tomoya takahashi 
 *	@data		2005.09.26
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>
#include "system/arc_util.h"
#include "include/poketool/monsno.h"

#define __IMC_POKE_OBJ_H_GLOBAL
#include "include/application/imageClip/imc_poke_obj.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define IMC_POKE_IN_SIZE_SML	(20)
#define IMC_POKE_IN_SIZE_MDL	(10)
#define IMC_POKE_IN_SIZE_BIG	(5)

#define IMC_POKE_IN_SML	(0)
#define IMC_POKE_IN_MDL	(1)
#define IMC_POKE_IN_BIG	(2)

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static int GetInSize( int no );

//-----------------------------------------------------------------------------
/**
*	O[oϐ
*/
//-----------------------------------------------------------------------------

// HŗǂTCYXg
IMC_POKE_INS_DAT poke_ins[ MONSNO_END ] = {
	{0,0},
};


//----------------------------------------------------------------------------
/**
 *
 *	@brief	|P̃LN^f[^`VXeɓo^
 *
 *	@param	drawData		`VXef[^
 *	@param	arc_data		A[JCuf[^
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_POKE_CharSet( IMC_DRAW_DATA* drawData, SOFT_SPRITE_ARC* arc_data )
{
	// LN^f[^o^
	void* buff;
	
	buff = ArcUtil_Load( arc_data->arc_no, arc_data->index_chr, FALSE, HEAPID_IMAGECLIP_DRAW, ALLOC_TOP );
	IMC_DRAW_SetCharData( drawData, buff, IMC_DRAW_POKE_CHAR_ID );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbv@|Pf[^쐬
 *
 *	@param	poke			C[WNbv@|Pf[^
 *	@param	sprite_man		\tgEFAXvCg}l[W
 *	@param	poke_para		|Pp[^\
 *	@param	arc_data		A[JCut@Cf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_POKE_Init( IMC_POKE* poke,  SOFT_SPRITE_MANAGER* sprite_man, POKEMON_PARAM* poke_para, SOFT_SPRITE_ARC* arc_data )
{
	int monsno = PokeParaGet( poke_para, ID_PARA_monsno, NULL );

	// |POtBbN擾
	PokeGraArcDataGetPP(arc_data, poke_para, PARA_FRONT);
	
	// \ݒ
	poke->sprite = SoftSpriteAdd( 
			sprite_man,
			arc_data,
			IMC_POKE_INIT_X,IMC_POKE_INIT_Y, 
			IMC_POKE_DEFAULT_PRI, 0, NULL, NULL);


	// f[^쐬
	{
		int x, y;
		IMC_POKE_SizeGet( poke, &x, &y );
		x /= 2;
		y /= 2;
		poke->hit_tbl.rect.top		= IMC_POKE_INIT_Y - y;
		poke->hit_tbl.rect.bottom	= IMC_POKE_INIT_Y + y;
		poke->hit_tbl.rect.left		= IMC_POKE_INIT_X - x;
		poke->hit_tbl.rect.right	= IMC_POKE_INIT_X + x;
	}

	// HŗǂTCYݒ
	{
		poke->ins_x = GetInSize(poke_ins[ monsno ].x_no);
		poke->ins_y = GetInSize(poke_ins[ monsno ].y_no);
	}

	// |Pf[^ێ
	poke->poke_para = poke_para;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbv@|Pf[^j
 *
 *	@param	poke			C[WNbv@|Pf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_POKE_Delete( IMC_POKE* poke )
{
	SoftSpriteDel( poke->sprite );
	memset( poke, 0, sizeof( IMC_POKE ) );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\D揇ʂݒ
 *
 *	@param	poke		|Pf[^
 *	@param	priority	D揇
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_POKE_DrawPrioritySet( IMC_POKE* poke, int priority )
{
	SoftSpriteParaSet( poke->sprite, SS_PARA_POS_Z, priority );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\D揇ʂ擾
 *
 *	@param	poke		|Pf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
int IMC_POKE_DrawPriorityGet( IMC_POKE* poke )
{
	return SoftSpriteParaGet( poke->sprite, SS_PARA_POS_Z );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Wݒ
 *
 *	@param	poke		|Pf[^
 *	@param	x			W
 *	@param	y			W
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_POKE_MatrixSet( IMC_POKE* poke, int x, int y )
{
	int size_x, size_y;
	IMC_POKE_SizeGet( poke, &size_x, &size_y );
	SoftSpriteParaSet( poke->sprite, SS_PARA_POS_X, x );
	SoftSpriteParaSet( poke->sprite, SS_PARA_POS_Y, y );

	size_y /= 2;
	size_x /= 2;
	
	poke->hit_tbl.rect.top		= y - size_y;
	poke->hit_tbl.rect.bottom	= y + size_y;
	poke->hit_tbl.rect.left		= x - size_x;
	poke->hit_tbl.rect.right	= x + size_x;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|Pƃ^b`pl̓蔻
 *
 *	@param	poke	|Pf[^
 *
 *	@retval	TRUE	
 *	@retval	FALSE	Ȃ
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_POKE_TPHit( IMC_POKE* poke )
{
	return GF_TP_SingleHitCont( &poke->hit_tbl );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PƎwW̓蔻
 *
 *	@param	poke	|Pf[^
 *	@param	x		W
 *	@param	y		W
 *
 *	@retval	TRUE	
 *	@retval	FALSE	Ȃ
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_POKE_TPHitSelf( IMC_POKE* poke, int x, int y )
{
	
	return GF_TP_SingleHitSelf( &poke->hit_tbl, x, y );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PW擾
 *
 *	@param	poke		|Pf[^
 *	@param	x			W
 *	@param	y			W
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_POKE_MatrixGet( IMC_POKE* poke, int* x, int* y )
{
	*x = SoftSpriteParaGet( poke->sprite, SS_PARA_POS_X );
	*y = SoftSpriteParaGet( poke->sprite, SS_PARA_POS_Y );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PTCY擾
 *
 *	@param	poke		|Pf[^
 *	@param	x			W
 *	@param	y			W
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_POKE_SizeGet( IMC_POKE* poke, int* x, int* y )
{
	*x = SOFT_SPRITE_SIZE_X;
	*y = SOFT_SPRITE_SIZE_Y;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	^b`plƂ̓蔻ׂs
 *
 *	@param	poke		IuWFNgf[^
 *	@param	offs_x		ォ̃ItZbgW
 *	@param	offs_y		ォ̃ItZbgW
 *	@param	char_data	LN^f[^	
 *
 *	@retval	TRUE	
 *	@retval	FALSE	Ȃ	iItZbgWsj
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_POKE_TPHitEx( IMC_POKE* poke, int* offs_x, int* offs_y, NNSG2dCharacterData* char_data )
{
	int check;		// `FbNp
	int size_x, size_y;	// TCY	
	int x, y;		// ݂̒SW
	
	// ܂蔻𕁒ʂɍs
	check = IMC_POKE_TPHit( poke );
	if( check == FALSE ){
		return FALSE;
	}

	// W擾
	IMC_POKE_MatrixGet( poke, &x, &y );
	IMC_POKE_SizeGet( poke, &size_x, &size_y );
	x -= (size_x / 2);
	y -= (size_y / 2);

	// ItZbgl擾
	*offs_x = sys.tp_x - x;
	*offs_y = sys.tp_y - y;


	// ̈ʒũLN^f[^`FbN
	// FłȂ`FbN
	check = IMC_DRAW_CharCheck( char_data, *offs_x, *offs_y, 0 );

	// colorio[OȂԂ
	if(check == IMC_DRAW_CHAR_CHECK_FALSE){
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	^b`plƂ̓蔻ׂs	Ww
 *
 *	@param	poke		IuWFNgf[^
 *	@param	x			ォ̃ItZbgW
 *	@param	y			ォ̃ItZbgW
 *	@param	char_data	LN^f[^	
 *
 *	@retval	TRUE	
 *	@retval	FALSE	Ȃ	iItZbgWsj
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_POKE_TPHitExSelf( IMC_POKE* poke, int x, int y, NNSG2dCharacterData* char_data )
{
	int check;		// `FbNp
	int size_x, size_y;	// TCY	
	int cx, cy;		// ݂̒SW
	
	// ܂蔻𕁒ʂɍs
	check = IMC_POKE_TPHitSelf( poke, x, y );
	if( check == FALSE ){
		return FALSE;
	}

	// W擾
	IMC_POKE_MatrixGet( poke, &cx, &cy );
	IMC_POKE_SizeGet( poke, &size_x, &size_y );
	cx -= (size_x / 2);
	cy -= (size_y / 2);

	// ItZbgl擾
	x -= cx;
	y -= cy;

	// ̈ʒũLN^f[^`FbN
	// FłȂ`FbN
	check = IMC_DRAW_CharCheck( char_data, x, y, 0 );

	// colorio[OȂԂ
	if(check == IMC_DRAW_CHAR_CHECK_FALSE){
		return TRUE;
	}

	return FALSE;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	|P̐Hł悢TCY擾
 *
 *	@param	poke		IuWFNgf[^
 *	@param	ins_x		Hł悢TCY擾̈
 *	@param	ins_y		Hł悢TCY擾̈
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_POKE_InSizeGet( IMC_POKE* poke, int* ins_x, int* ins_y )
{
	*ins_x = poke->ins_x;
	*ins_y = poke->ins_y;
}




//-----------------------------------------------------------------------------
/**
*	vCx[g֐
*/
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *
 *	@brief	HŗǂTCY擾
 *
 *	@param	int no 
 *
 *	@return	HŗǂTCY
 *
 *
 */
//-----------------------------------------------------------------------------
static int GetInSize( int no )
{
	int ret;
	
	switch(no){
	case IMC_POKE_IN_SML:
		ret = IMC_POKE_IN_SIZE_SML;
		break;
	case IMC_POKE_IN_MDL:
		ret = IMC_POKE_IN_SIZE_MDL;
		break;
	case IMC_POKE_IN_BIG:
		ret = IMC_POKE_IN_SIZE_BIG;
		break;
	}

	return ret;
}

