//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_right_box.c
 *	@brief		E̔
 *	@author		tomoya takahashi
 *	@data		2005.09.22
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include "system.h"
#include "assert.h"
#include <string.h>
#include "include/application/imageClip/imc_drawdata_define.h"
#include "include/application/imageClip/imc_obj_list_func.h"

#define	__IMC_RIGHT_BOX_H_GLOBAL
#include "include/application/imageClip/imc_right_box.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define IMC_RIGHT_BOX_ACCE_MAX	(10)

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void ImcRightSetAcceList( IMC_RIGHT_BOX* p_data, IMC_OBJLIST* objList, BOOL top_bottom, NNSG2dCharacterData** SWSP_UPchar );


//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNXp̈쐬
 *
 *	@param	rbox		E{bNXpf[^
 *	@param	init		E{bNXf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_InitSys( IMC_RIGHT_BOX* rbox, IMC_RIGHT_BOX_INIT* init )
{
	// `f[^쐬
	rbox->boxDraw.SWSP_drawSys	= init->SWSP_drawSys;
	rbox->boxDraw.SWSP_charData	= init->SWSP_charData;
	rbox->boxDraw.SWSP_plttData	= init->SWSP_plttData;
	rbox->boxDraw.accePlttOfsTbl= init->accePlttOfsTbl;
	rbox->boxDraw.SSM_drawSys	= init->SSM_drawSys;
	rbox->boxDraw.BG_Ini		= init->BG_Ini;
	rbox->boxDraw.acce			= init->acce;
	rbox->boxDraw.bg_no			= 0;

	// VXef[^
	rbox->boxData.objListTbl = init->objListTbl;

	rbox->boxData.dummy.next = &rbox->boxData.dummy;
	rbox->boxData.dummy.prev = &rbox->boxData.dummy;
	rbox->boxData.dummy_poke.next = &rbox->boxData.dummy_poke;
	rbox->boxData.dummy_poke.prev = &rbox->boxData.dummy_poke;
	rbox->boxData.obj_count = 0;


	// |PIuWF쐬
	{
		IMC_OBJLIST* objList;
		objList = IMC_OBJLIST_MakeObjList( rbox->boxData.objListTbl, &rbox->boxDraw.poke, IMC_OBJLIST_POKE );

		// 擪ɃXgo^
		IMC_OBJLIST_Set( objList, &rbox->boxData.dummy_poke );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNp̈j
 *
 *	@param	rbox		jE{bNXf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_DeleteSys( IMC_RIGHT_BOX* rbox )
{
	// |Pj
	IMC_RBOX_DeletePoke( rbox );

	// Xgj
	IMC_RBOX_DeleteAccessorieAll( rbox );
	
	memset( rbox, 0, sizeof(IMC_RIGHT_BOX) );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	|Pf[^vC[p쐬
 *
 *	@param	rbox			E{bNXf[^
 *	@param	poke_para		쐬|P̃|Pp[^
 *	@param	arc_data		A[JCut@Cf[^i[̈
 *	@param	x				xW
 *	@param	y				yW
 *	@param	pri				\D揇
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_AddPokePlayer( IMC_RIGHT_BOX* rbox, POKEMON_PARAM* poke_para, SOFT_SPRITE_ARC* arc_data, int x, int y, int pri )
{
	// |Pf[^쐬
	IMC_POKE_Init( &rbox->boxDraw.poke, rbox->boxDraw.SSM_drawSys, poke_para, arc_data );

	// \D揇
	IMC_POKE_DrawPrioritySet( &rbox->boxDraw.poke, pri );

	// W
	IMC_POKE_MatrixSet( &rbox->boxDraw.poke, x, y );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	|Pf[^쐬
 *
 *	@param	rbox			E{bNXf[^
 *	@param	poke_para		쐬|P̃|Pp[^
 *	@param	arc_data		A[JCut@Cf[^i[̈
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_AddPoke( IMC_RIGHT_BOX* rbox, POKEMON_PARAM* poke_para, SOFT_SPRITE_ARC* arc_data )
{
	// |Pf[^쐬
	IMC_POKE_Init( &rbox->boxDraw.poke, rbox->boxDraw.SSM_drawSys, poke_para, arc_data );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|Pړǉ
 *
 *	@param	rbox	E{bNX
 *	@param	poke	|PIuWF
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_MoveAddPoke( IMC_RIGHT_BOX* rbox, IMC_OBJLIST* poke )
{
	// |PナXg̍Ōɓo^
	IMC_OBJLIST_Set(  poke, rbox->boxData.dummy_poke.prev);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ړ邽߃Xg폜
 *	
 *	@param	poke		|PIuWF
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_MoveDeletePoke( IMC_OBJLIST* poke )
{
	// Xgj
	IMC_OBJLIST_Delete( poke );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PIuWFNgj
 *
 *	@param	rbox	E{bNXf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_DeletePoke( IMC_RIGHT_BOX* rbox )
{
	// |Pf[^j
	IMC_POKE_Delete( &rbox->boxDraw.poke );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT̐VKǉ
 *
 *	@param	rbox				E{bNXpf[^
 *	@param	accessorie_no		ǉANZTio[
 *	@param	x					XW
 *	@param	y					YW
 *	@param	pri					\D揇
 *
 *	@retval	TRUE	
 *	@retval	FALSE	s	io^ő吔ȏo^悤Ƃj
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_RBOX_AddAccessorieEasy( IMC_RIGHT_BOX* rbox, int accessorie_no, int x, int y, int pri )
{
	IMC_ACCE_ADD acce_add;
	IMC_ACCESSORIE_OBJ* acce_obj;
	
	// őo^`FbN
	if( rbox->boxData.obj_count < IMC_RIGHT_BOX_ACCE_MAX ){

		// ANZTo^AXgɓo^
		// ANZTo^f[^쐬
		acce_add.objTbl		= rbox->boxDraw.acce;
		acce_add.SWSPsys	= rbox->boxDraw.SWSP_drawSys;
		acce_add.SWSPchar	= rbox->boxDraw.SWSP_charData[ accessorie_no ];
		acce_add.SWSPpltt	= rbox->boxDraw.SWSP_plttData[ IMC_DRAW_ACCESSORIE_PLTT_ID ];
		acce_add.m_x		= x;
		acce_add.m_y		= y;
		acce_add.accessorie_no = accessorie_no;
		acce_add.pltt_offs	= rbox->boxDraw.accePlttOfsTbl[ accessorie_no ];

		// o^
		acce_obj = IMC_ACCE_ObjAdd( &acce_add );

		// \D揇ʐݒ
		IMC_ACCE_ObjDrawPrioritySet( acce_obj, pri );

		// XgIuWF쐬
		{
			IMC_OBJLIST* objList;

			objList = IMC_OBJLIST_MakeObjList( rbox->boxData.objListTbl, acce_obj, IMC_OBJLIST_ACCE );
			
			
			// Xg̐擪ɓo^
			IMC_OBJLIST_Set( objList, &rbox->boxData.dummy );
		}

		//	IuWFNgǉ
		rbox->boxData.obj_count ++;

		return TRUE;
	}

	return FALSE;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT̈ړǉ
 *
 *	@param	rbox		E{bNXpf[^
 *	@param	acce_obj	ANZTf[^
 *
 *	@retval	TRUE	
 *	@retval	FALSE	s	io^ő吔ȏo^悤Ƃj
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_RBOX_AddAccessorieMoveEasy( IMC_RIGHT_BOX* rbox, IMC_OBJLIST* acce_obj )
{
	if( rbox->boxData.obj_count < IMC_RIGHT_BOX_ACCE_MAX ){

		// Xg̐擪ɓo^
		IMC_OBJLIST_Set( acce_obj, &rbox->boxData.dummy );

		//	IuWFNgǉ
		rbox->boxData.obj_count ++;

		return TRUE;
	}

	return FALSE;
}




//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT̐VKǉ
 *
 *	@param	rbox				E{bNXpf[^
 *	@param	accessorie_no		ǉANZTio[
 *	@param	x					XW
 *	@param	y					YW
 *
 *	@retval	TRUE	
 *	@retval FALSE	s
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_RBOX_AddAccessorie( IMC_RIGHT_BOX* rbox, int accessorie_no, int x, int y, NNSG2dCharacterData** SWSP_UPchar )
{
	IMC_ACCE_ADD acce_add;
	IMC_ACCESSORIE_OBJ* acce_obj;
	
	// őo^`FbN
	if( rbox->boxData.obj_count < IMC_RIGHT_BOX_ACCE_MAX ){

		// ANZTo^AXgɓo^
		// ANZTo^f[^쐬
		acce_add.objTbl		= rbox->boxDraw.acce;
		acce_add.SWSPsys	= rbox->boxDraw.SWSP_drawSys;
		acce_add.SWSPchar	= rbox->boxDraw.SWSP_charData[ accessorie_no ];
		acce_add.SWSPpltt	= rbox->boxDraw.SWSP_plttData[ IMC_DRAW_ACCESSORIE_PLTT_ID ];
		acce_add.m_x		= x;
		acce_add.m_y		= y;
		acce_add.accessorie_no = accessorie_no;
		acce_add.pltt_offs	= rbox->boxDraw.accePlttOfsTbl[ accessorie_no ];

		// o^
		acce_obj = IMC_ACCE_ObjAdd( &acce_add );

		// XgIuWF쐬
		{
			IMC_OBJLIST* objList;

			objList = IMC_OBJLIST_MakeObjList( rbox->boxData.objListTbl, acce_obj, IMC_OBJLIST_ACCE );
			
			
			// Xg̐擪ɓo^
			ImcRightSetAcceList( rbox, objList, TRUE, SWSP_UPchar );
		}

		//	IuWFNgǉ
		rbox->boxData.obj_count ++;

		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	[ׂ@C[WNbv쐬VXeł͂Ă]
 *	@brief	ANZT̈ړǉ
 *
 *	@param	rbox		E{bNXpf[^
 *	@param	acce_obj	ANZTf[^
 *	@param	SWSP_UPchar			pLN^f[^
 *
 *	@retval	TRUE	
 *	@retval	FALSE	s	io^ő吔ȏo^悤Ƃj
 */
//-----------------------------------------------------------------------------
BOOL IMC_RBOX_AddAccessorieMove( IMC_RIGHT_BOX* rbox, IMC_OBJLIST* acce_obj, NNSG2dCharacterData** SWSP_UPchar )
{
	if( rbox->boxData.obj_count < IMC_RIGHT_BOX_ACCE_MAX ){

		// Xg̐擪ɓo^
		ImcRightSetAcceList( rbox, acce_obj, TRUE, SWSP_UPchar );

		//	IuWFNgǉ
		rbox->boxData.obj_count ++;

		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTIuWFj
 *
 *	@param	rbox	E{bNX
 *	@param	acce_obj	jANZT
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_DeleteAccessorie( IMC_RIGHT_BOX* rbox, IMC_OBJLIST* acce_obj )
{
	// Xgj
	IMC_OBJLIST_Delete( acce_obj );
	
	// ANZTj
	IMC_ACCE_ObjDelete( (IMC_ACCESSORIE_OBJ*)acce_obj->obj_data );

	// Xgj
	IMC_OBJLIST_DeleteObjList( acce_obj );
	
	//	IuWFNg폜
	rbox->boxData.obj_count--;

	// }CiX̒lɂȂ炨
	GF_ASSERT( rbox->boxData.obj_count >= 0 );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ړ邽߂̃Xg̍폜
 *
 *	@param	rbox	E{bNX
 *	@param	acce_obj	ړ邽߂ɃXg폜ANZTf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_DeleteAccessorieMove( IMC_RIGHT_BOX* rbox, IMC_OBJLIST* acce_obj )
{
	// Xgj
	IMC_OBJLIST_Delete( acce_obj );

	//	IuWFNg폜
	rbox->boxData.obj_count--;
	// }CiX̒lɂȂ炨
	GF_ASSERT( rbox->boxData.obj_count >= 0 );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	o^ĂANZTSĂ͂
 *
 *	@param	rbox	E{bNX
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_DeleteAccessorieAll( IMC_RIGHT_BOX* rbox )
{
	IMC_OBJLIST_DeleteAll( &rbox->boxData.dummy );
	IMC_OBJLIST_DeleteAll( &rbox->boxData.dummy_poke );

	//	IuWFNg폜
	rbox->boxData.obj_count = 0;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNX̃XvCgŕ\ĂIuWFNg𓮂
 *
 *	@param	rbox	E{bNX
 *	@param	x		l
 *	@param	y		l
 *	
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_ListMove( IMC_RIGHT_BOX* rbox, int x, int y )
{
	IMC_OBJLIST_ACCEPOKE_ListMove( &rbox->boxData.dummy, x, y );
	IMC_OBJLIST_ACCEPOKE_ListMove( &rbox->boxData.dummy_poke, x, y );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P̏̃ANZT𓮂
 *
 *	@param	rbox	E{bNX
 *	@param	x		W
 *	@param	y		W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_PokeUpListMove( IMC_RIGHT_BOX* rbox, int x, int y )
{
	IMC_OBJLIST_ACCEPOKE_ListMove( &rbox->boxData.dummy_poke, x, y );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNX̃ANZT\vCIeBݒ
 *
 *	@param	rbox		E{bNX 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_SetObjPriority( IMC_RIGHT_BOX* rbox )
{
	IMC_OBJLIST* work;
	int	priority = IMC_RBOX_ACCE_PRIORITY_START;

	// 擪|P܂
	work = rbox->boxData.dummy_poke.next;
	while( work != &rbox->boxData.dummy_poke ){

		if( work->flag == IMC_OBJLIST_ACCE ){
			IMC_ACCE_ObjDrawPrioritySet( work->obj_data, priority );	
		}else{
			
			IMC_POKE_DrawPrioritySet( work->obj_data, priority );	
		}

		priority --;
			
		work = work->next;
	}

	priority -= 8;	// Ԋu@`h~̂

	// |P牺
	work = rbox->boxData.dummy.next;
	while( work != &rbox->boxData.dummy ){

		if( work->flag == IMC_OBJLIST_ACCE ){
			IMC_ACCE_ObjDrawPrioritySet( work->obj_data, priority );	
		}else{
			
			IMC_POKE_DrawPrioritySet( work->obj_data, priority );	
		}

		priority --;
		work = work->next;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	^b`plE{bNXɓĂ邩`FbN
 *
 *	@param	rbox		E{bNXf[^
 *
 *	@retval	TRUE		qbg
 *	@retval	FALSE		qbg
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_RBOX_TPHit( IMC_RIGHT_BOX* rbox )
{
	TP_HIT_TBL	tp_hit;

	tp_hit.rect.top		= IMC_RBOX_AREA_Y;
	tp_hit.rect.bottom	= IMC_RBOX_AREA_Y + IMC_RBOX_AREA_HEIGHT;
	tp_hit.rect.left	= IMC_RBOX_AREA_X;
	tp_hit.rect.right	= IMC_RBOX_AREA_X + IMC_RBOX_AREA_WIDTH;

	return GF_TP_SingleHitCont( &tp_hit );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	wWE{bNXɓĂ邩`FbN
 *
 *	@param	rbox		E{bNXf[^
 *	@param	x			肘W
 *	@param	y			肙W
 *
 *	@retval	TRUE		qbg
 *	@retval	FALSE		qbg
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_RBOX_TPHitSelf( IMC_RIGHT_BOX* rbox, int x, int y )
{
	TP_HIT_TBL	tp_hit;

	tp_hit.rect.top		= IMC_RBOX_AREA_Y;
	tp_hit.rect.bottom	= IMC_RBOX_AREA_Y + IMC_RBOX_AREA_HEIGHT;
	tp_hit.rect.left	= IMC_RBOX_AREA_X;
	tp_hit.rect.right	= IMC_RBOX_AREA_X + IMC_RBOX_AREA_WIDTH;

	return GF_TP_SingleHitSelf( &tp_hit, x, y );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	IuWFNgƂ̓蔻s
 *
 *	@param	rbox	E{bNX
 *
 *	@retval	NULL	ANZT
 *	@retval	NULL	Ȃ
 *
 *
 */
//-----------------------------------------------------------------------------
IMC_OBJLIST* IMC_RBOX_TPHitObj( IMC_RIGHT_BOX* rbox )
{
	IMC_OBJLIST* work;
	BOOL	ret;

	// 擪̃ANZT
	work = rbox->boxData.dummy_poke.next;
	while( work != &rbox->boxData.dummy_poke ){

		ret = IMC_OBJLIST_ACCEPOKE_Hit( work, IMC_OBJ_LIST_FUNC_TP_NOW, 0 );
		
		if(ret == TRUE){

			return work;
		}
		
		work = work->next;
	}


	// |P̉̃ANZT
	work = rbox->boxData.dummy.next;
	while( work != &rbox->boxData.dummy ){

		ret = IMC_OBJLIST_ACCEPOKE_Hit( work, IMC_OBJ_LIST_FUNC_TP_NOW, 0 );
		
		if(ret == TRUE){

			return work;
		}
		
		work = work->next;
	}


	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTƂ̓蔻ׂs
 *
 *	@param	rbox		E{bNX
 *	@param	offset_x	ItZbgW
 *	@param	offset_y	ItZbgW
 *	@param	SWSP_UPchar	LN^f[^e[u
 *
 *	@return	none
 *
 * LN^f[^QƂĔFł͂Ȃ`FbN
 *
 */
//-----------------------------------------------------------------------------
IMC_OBJLIST* IMC_RBOX_TPHitObjEx( IMC_RIGHT_BOX* rbox, int* offset_x, int* offset_y, NNSG2dCharacterData** SWSP_UPchar )
{
	IMC_OBJLIST* work;
	BOOL	ret;

	// |P̏̃ANZT
	work = rbox->boxData.dummy_poke.next;
	while( work != &rbox->boxData.dummy_poke ){

		ret = IMC_OBJLIST_ACCEPOKE_HitEx( work, offset_x, offset_y, SWSP_UPchar );
		
		if(ret == TRUE){

			return work;
		}
		
		work = work->next;
	}


	// |P̉̃ANZT
	work = rbox->boxData.dummy.next;
	while( work != &rbox->boxData.dummy ){

		ret = IMC_OBJLIST_ACCEPOKE_HitEx( work, offset_x, offset_y, SWSP_UPchar );
		
		if(ret == TRUE){

			return work;
		}
		
		work = work->next;
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BG\
 *
 *	@param	rbox		E{bNX
 *	@param	bg_num		E{bNXBGio[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_BGSet( IMC_RIGHT_BOX* rbox, int bg_num, int heap )
{
	IMC_BG_ADD add;
	
	// o^f[^ݒ
	add.bg_ini		= rbox->boxDraw.BG_Ini;
	add.arc_file	= ARC_IMAGECLIP_GRA;
	add.char_arc	= IMC_BG_RIGHT_CG_ARC_GET(bg_num);
	add.pltt_arc	= IMC_BG_RIGHT_CL_ARC_GET(bg_num);
	add.scrn_arc	= IMC_BG_RIGHT_SC_ARC_GET(bg_num);
	add.x			= IMC_RBOX_AREA_X;
	add.y			= IMC_RBOX_AREA_Y;
	add.frame		= GF_BGL_FRAME2_M;
	add.pltt_num	= IMC_RBOX_BG_PLTT_NUM;
	add.pltt_offs	= IMC_RBOX_BG_PLTT_OFFS;
	add.char_offs	= 0;
	add.heap		= heap;

	IMC_BG_MakaObj( &rbox->boxDraw.bg, &add );

	rbox->boxDraw.bg_no = bg_num;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGN[
 *
 *	@param	rbox		E{bNX
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_BGClean( IMC_RIGHT_BOX* rbox )
{
	IMC_BG_DeleteObj( &rbox->boxDraw.bg );
}







//----------------------------------------------------------------------------
/**
 *	@brief	ォɃANZTݒ肷
 *
 *	@param	p_data			{bNXf[^
 *	@param	objList			ANZTf[^
 *	@param	top_bottom		TRUE@擪@BOTTOM@Ō
 *	@param	SWSP_UPchar			pLN^f[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ImcRightSetAcceList( IMC_RIGHT_BOX* p_data, IMC_OBJLIST* objList, BOOL top_bottom, NNSG2dCharacterData** SWSP_UPchar  )
{
	int x;
	int y;
	int size_x;
	int size_y;
	int in_size_x;
	int in_size_y;
	int top;
	int bottom;
	int left;
	int right;
	BOOL check;
	NNSG2dCharacterData* char_data;
	
	// W擾
	IMC_OBJLIST_ACCEPOKE_MatGet( objList, &x, &y );

	// TCY擾
	IMC_OBJLIST_ACCEPOKE_SizeGet( objList, &size_x, &size_y );

	// Hł悢TCY擾
	IMC_OBJLIST_ACCEPOKE_InSizeGet( objList, &in_size_x, &in_size_y );

	top = y + in_size_y;
	bottom = y + size_y - in_size_y;
	left = x + in_size_x;
	right = x + size_x - in_size_x;

	
	// LN^f[^擾
	char_data = SWSP_UPchar[ IMC_DRAW_POKE_CHAR_ID ];
	
	// |PGAɈ邩`FbN
	// 4_`FbN
	check  = IMC_POKE_TPHitExSelf( &p_data->boxDraw.poke, left, top, char_data );
	check |= IMC_POKE_TPHitExSelf( &p_data->boxDraw.poke, left, bottom, char_data );
	check |= IMC_POKE_TPHitExSelf( &p_data->boxDraw.poke, right, top, char_data );
	check |= IMC_POKE_TPHitExSelf( &p_data->boxDraw.poke, right, bottom, char_data );
	
	// |P̏Ȃ|P̏ナXg
	if( check ){
		
		if( top_bottom ){
			// 擪ɓo^
			IMC_OBJLIST_Set( objList, &p_data->boxData.dummy_poke );
		}else{
			// Ōɓo^
			IMC_OBJLIST_Set( objList, p_data->boxData.dummy_poke.prev );
		}
	}else{

		if( top_bottom ){
			// 擪ɓo^
			IMC_OBJLIST_Set( objList, &p_data->boxData.dummy );
		}else{
			// Ōɓo^
			IMC_OBJLIST_Set( objList, p_data->boxData.dummy.prev );
		}
	}
}

