//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_subwin.c
 *	@brief		Tuʂ̕\f[^
 *	@author		
 *	@data		2005.10.24
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include "system.h"
#include "assert.h"
#include "string.h"
#include "include/application/imageClip/imc_drawdata_define.h"
#include "msg_print.h"
#include "include/system/msgdata.h"
#include "include/system/fontproc.h"

#define	__IMC_SUBWIN_H_GLOBAL
#include "include/application/imageClip/imc_subwin.h"

#include "include/system/window.h"


//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void initBG( IMC_BG* bg, GF_BGL_INI* ini );
static void initBmp( GF_BGL_BMPWIN** bmp, GF_BGL_INI* ini );
static void deleteBG( IMC_BG* bg );
static void deleteBmp( GF_BGL_BMPWIN* bmp );


//----------------------------------------------------------------------------
/**
 *
 *	@brief	TuEBhȄ
 *
 *	@param	subwin		TuEBhE\
 *	@param	init		f[^
 *	@param	init_mask	}XN
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_SUBWIN_Init( IMC_SUBWIN* subwin, IMC_SUBWIN_INIT* init, int init_mask )
{
	if( init_mask & IMC_SUBWIN_INITMASK_CLEAN ){

		memset( subwin, 0, sizeof(IMC_SUBWIN) );
	}
	
	if( init_mask & IMC_SUBWIN_INITMASK_BG ){
		
		initBG( &subwin->bg, init->bg_ini );
	}

	if( init_mask & IMC_SUBWIN_INITMASK_BMP ){

		initBmp( &subwin->bmp, init->bg_ini );
	}

	subwin->init_flg |= init_mask;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	TuEBhEj
 *
 *	@param	subwin	TuEBhE
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_SUBWIN_Delete( IMC_SUBWIN* subwin )
{
	if( subwin->init_flg & IMC_SUBWIN_INITMASK_BG ){
		
		deleteBG( &subwin->bg );
		subwin->init_flg |= ~IMC_SUBWIN_INITMASK_BG;
	}

	if( subwin->init_flg & IMC_SUBWIN_INITMASK_BMP ){

		deleteBmp( subwin->bmp );
		subwin->init_flg |= ~IMC_SUBWIN_INITMASK_BMP;
	}

	memset( subwin, 0, sizeof(IMC_SUBWIN) );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C֐
 *
 *	@param	subwin	TuEBhE
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_SUBWIN_Main( IMC_SUBWIN* subwin )
{
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	rbg}bvɕ\
 *
 *	@param	subwin	TuEBhEIuWF
 *	@param	arcID	A[JCuID
 *	@param	dataID	f[^ID
 *	@param	msgID	\郁bZ[WID
 *	
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_SUBWIN_SetBmpWin( IMC_SUBWIN* subwin, int arcID, int dataID, int msgID )
{
	MSGDATA_MANAGER* msg_data;
	STRBUF* str;

	GF_ASSERT_MSG( (subwin->init_flg & IMC_SUBWIN_INITMASK_BMP), "ovEBhEĂ܂" )

	// 擾
	msg_data = MSGMAN_Create( MSGMAN_TYPE_NORMAL, arcID, dataID, HEAPID_IMAGECLIP_DATA );
	GF_ASSERT( msg_data );
	str = MSGMAN_AllocString( msg_data, msgID );

	// rbg}bv
	GF_BGL_BmpWinDataFill( subwin->bmp, 1 );

	// 񏑂
	GF_STR_PrintColor( subwin->bmp, FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, GF_PRINTCOLOR_MAKE(2,3,1), NULL );
												// `ʒu
	
	BmpMenuWinWrite( subwin->bmp, WINDOW_TRANS_ON, IMC_SUBWIN_BMP_FRAME_CHAR_OFS, IMC_SUBWIN_BMP_PLTT_NO );

	STRBUF_Delete( str );

	MSGMAN_Delete( msg_data );
}

//-----------------------------------------------------------------------------
/**
*		vCx[g֐
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGʂ̏
 *
 *	@param	bg	BGIuWF
 *	@param	ini	BGVXe[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initBG( IMC_BG* bg, GF_BGL_INI* ini )
{
	IMC_BG_ADD add;

	add.bg_ini		= ini;
	add.arc_file	= ARC_IMAGECLIP_GRA;
	add.char_arc	= IMC_SUBWIN_CG_ARC;
	add.pltt_arc	= IMC_SUBWIN_PL_ARC;
	add.scrn_arc	= IMC_SUBWIN_SC_ARC;
	add.x			= 0;
	add.y			= 0;
	add.frame		= GF_BGL_FRAME0_S;
	add.pltt_num	= IMC_SUBWIN_PL_NUM;
	add.pltt_offs	= 0;
	add.char_offs	= 0;
	add.heap		= HEAPID_IMAGECLIP_DRAW;

	IMC_BG_MakaObj( bg, &add );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	rbg}bvEBhEʂ̏
 *
 *	@param	bmp		rbg}bvEBhE
 *	@param	ini	BGVXe[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initBmp( GF_BGL_BMPWIN** bmp, GF_BGL_INI* ini )
{
	*bmp = GF_BGL_BmpWinAllocGet( HEAPID_IMAGECLIP_DRAW, 1 );
	GF_BGL_BmpWinInit( *bmp );

	GF_BGL_BmpWinAdd(
			ini,
			*bmp,
			GF_BGL_FRAME1_S,
			IMC_SUBWIN_BMP_X,
			IMC_SUBWIN_BMP_Y,
			IMC_SUBWIN_BMP_SIZE_X,
			IMC_SUBWIN_BMP_SIZE_Y,
			IMC_SUBWIN_BMP_PLTT_NO,
			MENU_WIN_CGX_SIZ + IMC_SUBWIN_BMP_FRAME_CHAR_OFS );
	
	GF_BGL_BmpWinDataFill( *bmp, 1 );

	// g`
	MenuWinGraphicSet( ini, GF_BGL_FRAME1_S, IMC_SUBWIN_BMP_FRAME_CHAR_OFS, IMC_SUBWIN_BMP_PLTT_NO, IMC_SUBWIN_WIN_NO, HEAPID_IMAGECLIP_DRAW );
	
	// J̃rbg}bv
	BmpMenuWinWrite( *bmp, WINDOW_TRANS_ON, IMC_SUBWIN_BMP_FRAME_CHAR_OFS, IMC_SUBWIN_BMP_PLTT_NO );


	GF_BGL_BmpWinOn( *bmp );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGʂ̔j
 *
 *	@param	bg		BGIuWF
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteBG( IMC_BG* bg )
{
	IMC_BG_DeleteObj( bg );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	rbg}bvʂ̔j
 *
 *	@param	bmp		rbg}bvEBhE
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteBmp( GF_BGL_BMPWIN* bmp )
{
	// rbg}bvEBhEj
	GF_BGL_BmpWinFree( bmp, 1 );
}

