//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_sys.c
 *	@brief		C[WNbvCVXe
 *	@author		tomoya takahashi
 *	@data		2005.09.21
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <string.h>
#include "system.h"
#include "assert.h"
#include "calctool.h"
#include "calc2d.h"
#include "touchpanel_system.h"
#include "include/system/lib_pack.h"
#include "include/system/brightness.h"
#include "include/system/heapdefine.h"
#include "include/application/imageClip/imc_drawsys.h"
#include "include/application/imageClip/imc_accessorie.h"
#include "include/application/imageClip/imc_drawdata_define.h"
#include "include/application/imageClip/imc_right_box.h"
#include "include/application/imageClip/imc_left_box.h"
#include "include/application/imageClip/imc_hand.h"
#include "include/application/imageClip/imc_acce_hand.h"
#include "include/application/imageClip/imc_obj_list.h"
#include "include/application/imageClip/imc_obj_list_func.h"
#include "include/application/imageClip/imc_button.h"
#include "include/system/wipe.h"
#include "include/application/imageClip/imc_subwin.h"
#include "include/application/imageClip/imc_rbox_player.h"
#include "include/application/imageClip/imc_snd_def.h"


#define __IMC_SYS_H_GLOBAL
#include "include/application/imageClip/imc_sys.h"



//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	CvbN
//	V[PXݒ
//	
//=====================================
enum{
	IMC_SYS_SEQ_FADE_IN,
	IMC_SYS_SEQ_FADE_IN_WAIT,
	IMC_SYS_SEQ_MAIN,			// C[WNbv쐬C
	IMC_SYS_SEQ_END_CHECK_WAIT,
	IMC_SYS_SEQ_END_CHECK,		// I`FbN
	IMC_SYS_SEQ_MAIN_WAIT,
	IMC_SYS_SEQ_FADE_OUT,
	IMC_SYS_SEQ_FADE_OUT_WAIT,
};

//-------------------------------------
//	
//	s
//	
//=====================================
enum{
	IMC_SYS_ACCE,		// ANZTύX
	IMC_SYS_BG,			// BGύX
	IMC_SYS_SND,		// TEhύX
	IMC_SYS_END_CHECK_REQ,// I`FbNNGXg
	IMC_SYS_END_CHECK,	// I`FbN
	IMC_SYS_END_REQ,	// INGXg
	IMC_SYS_END_CANCEL_REQ,	// ILZNGXg
	IMC_SYS_END,		// I
};

//-------------------------------------
//	
//	ImFʂւ̃tF[h
//	
//=====================================
enum
{
	IMC_SEENFADEIN_ACCE_FADEOUT,
	IMC_SEENFADEIN_ACCE_FADEWAIT,
	IMC_SEENFADEIN_BRIGHTNESS_OUT,
	IMC_SEENFADEIN_BRIGHTNESS_WAIT,
	IMC_SEENFADEIN_BUTTON_OLDOUT,
	IMC_SEENFADEIN_BUTTON_CHG,
	IMC_SEENFADEIN_MOVE_BGINIT,
	IMC_SEENFADEIN_MOVE_BG,
	IMC_SEENFADEIN_BUTTON_NEWIN,
	IMC_SEENFADEIN_BRIGHTNESS_IN,
	IMC_SEENFADEIN_BRIGHTNESS_INWAIT,
	IMC_SEENFADEIN_END
};
enum
{
	IMC_SEENFADEOUT_BRIGHTNESS_OUT,
	IMC_SEENFADEOUT_BRIGHTNESS_OUTWAIT,
	IMC_SEENFADEOUT_BUTTON_OLDOUT,
	IMC_SEENFADEOUT_BUTTON_CHG,
	IMC_SEENFADEOUT_MOVE_BG,
	IMC_SEENFADEOUT_BUTTON_NEWIN,
	IMC_SEENFADEOUT_BRIGHTNESS_IN,
	IMC_SEENFADEOUT_BRIGHTNESS_WAIT,
	IMC_SEENFADEOUT_ACCE_FADEIN,
	IMC_SEENFADEOUT_ACCE_FADEWAIT,
	IMC_SEENFADEOUT_END
};
#define IMC_SEENFADE_BRIGHTNESS_FADE_SYNC	(8)
#define IMC_SEENFADE_MOVE_ADD_X				(8)
#define IMC_SEENFADE_MOVE_COUNT				(8)
#define IMC_SEENFADE_BTTNMOVE_DIS			(64)
#define IMC_SEENFADE_BTTNMOVE_ADD_Y			(8)
#define IMC_SEENFADE_BTTNMOVE_COUNT			(8)

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	C[WNbvf[^\
//	
//=====================================
typedef struct {
	// `֌W
	IMC_DRAW_DATA drawSys;

	// IuWFNgXgf[^
	IMC_OBJLIST_TBL	objListTbl;

	// ANZTf[^
	IMC_ACCESSORIE_OBJ_TBL* acce;

	// ʃf[^
	IMC_LEFT_BOX lbox;
	
	// Eʃf[^
	IMC_RIGHT_BOX rbox;
	IMC_RBOX_PLAYER rbox_player;		// E{bNXvC[
	
	// nhf[^
	IMC_HAND hand;

	// t[BG
	IMC_BG	frame_bg;
	
	// {^f[^
	IMC_BUTTON_DATA bttn;				// 쐬
	IMC_BUTTON_ENDCK_DATA bttn_endck;	// I`FbN
		
	// TuEBhE
	IMC_SUBWIN	subwin;

	int state;		// ̎s

	int effect;		// GtFNgp
	
} IMC_SYS_WORK;

//-------------------------------------
//	
//	tF[hp[N
//	
//=====================================
typedef struct {
	IMC_SYS_WORK* sys_w;	// VXe[N
	BOOL*	end;			// ImtO
	int		work;			// [NtO
	int		seq;			// V[PX
} IMC_SYS_FADE_WORK;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void imageClipVBlankFunc( void* work );

static void initDrawSys( IMC_SYS_WORK* imc_w );
static void mainDrawSys( IMC_SYS_WORK* imc_w );
static void deleteDrawSys( IMC_SYS_WORK* imc_w );

static void initRightBox( IMC_SYS_WORK* imc_w, IMC_PROC_WORK* p_pr_w );
static void deleteRightBox( IMC_SYS_WORK* imc_w );

static void initLeftBox( IMC_SYS_WORK* imc_w, IMC_PROC_WORK* p_pr_w );
static void deleteLeftBox( IMC_SYS_WORK* imc_w );

static void setFrameBG( IMC_SYS_WORK* imc_w, int no );
static void delFrameBG( IMC_SYS_WORK* imc_w );

static void initBttn( IMC_SYS_WORK* imc_w );
static void deleteBttn( IMC_SYS_WORK* imc_w );
static void mainBttn( IMC_SYS_WORK* imc_w );

static void initBttnEndCk( IMC_SYS_WORK* imc_w );
static void deleteBttnEndCk( IMC_SYS_WORK* imc_w );
static void mainBttnEndCk( IMC_SYS_WORK* imc_w );

static void endBttn( IMC_BUTTON* bttn, void* work );
static void retBttn( IMC_BUTTON* bttn, void* work );
static void retbBttn( IMC_BUTTON* bttn, void* work );
static void	acceBttn( IMC_BUTTON* bttn, void* work );
static void	bgBttn( IMC_BUTTON* bttn, void* work );

static void endCkEndBttn( IMC_BUTTON* bttn, void* work );
static void endCkCancelBttn( IMC_BUTTON* bttn, void* work );

static void initSubWin( IMC_SYS_WORK* imc_w );
static void deleteSubWin( IMC_SYS_WORK* imc_w );

static void endSeenFadeIn( IMC_SYS_WORK* imc_w, BOOL* end );
static void endSeenFadeInTask( TCB_PTR tcb, void* work );
static void endSeenFadeOut( IMC_SYS_WORK* imc_w, BOOL* end );
static void endSeenFadeOutTask( TCB_PTR tcb, void* work );

static void dataSave( IMC_ONE_SAVEDATA* save_data, IMC_RIGHT_BOX* rbox );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvbN
 *
 *	@param	proc		vbNf[^	
 *	@param	seq			V[PX
 *
 *	@return	
 *
 *	typedef enum {
 *		PROC_RES_CONTINUE = 0,		///<p
 *		PROC_RES_FINISH,			///<I
 *	}PROC_RESULT;
 *
 *
 */
//-----------------------------------------------------------------------------
PROC_RESULT IMC_ProcInit( PROC* proc, int* seq )
{
	IMC_SYS_WORK*	imc_w;			// C[WNbv[N
	u32				check;			// p
	IMC_PROC_WORK*  p_imc_pr_w;		// O󂯎f[^


	// q[v쐬
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_IMAGECLIP_DATA, 0x20000 );
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_IMAGECLIP_DRAW, 0x30000 );

	// C[WNbv[N쐬
	imc_w = PROC_AllocWork( proc, sizeof( IMC_SYS_WORK ), HEAPID_IMAGECLIP_DATA );
	memset( imc_w, 0, sizeof( IMC_SYS_WORK ) );

	// VuNHuN֐ݒ
	sys_VBlankFuncChange( imageClipVBlankFunc, imc_w );	// VBlankZbg
	sys_HBlankIntrStop();	//HBlank荞ݒ~


	// Õf[^擾
	p_imc_pr_w = PROC_GetParentWork( proc );

	// ^b`plI[gTvOJn
	InitTPSystem();
	check = InitTPNoBuff( 4 );
//	GF_ASSERT( check == TP_OK );
	if( check != TP_OK ){
		OS_Printf( "check != TP_OK\n" );
	}
//	while( InitTPNoBuff( 4 ) != TP_OK ){};
	
	// \ݒ
	initDrawSys( imc_w );

	// IuWFNgXge[u쐬
	IMC_OBJLIST_TblInit( &imc_w->objListTbl, IMC_OBJLIST_MAX, HEAPID_IMAGECLIP_DATA );
	
	// ANZTi[f[^쐬
	imc_w->acce = IMC_ACCE_ObjTblInit( IMC_SYS_ACCESSORIE_MAX, HEAPID_IMAGECLIP_DATA );

	// E{bNXf[^쐬
	initRightBox( imc_w, p_imc_pr_w );
	
	// {bNXf[^쐬
	initLeftBox( imc_w, p_imc_pr_w );

	// t[BG\
	setFrameBG( imc_w, IMC_BG_FRAME_00 );
	
	// {^f[^쐬
	initBttn( imc_w );

	// TuEBhE
	initSubWin( imc_w );

	// nhf[^
	IMC_ACCE_HAND_Init( &imc_w->hand, &imc_w->rbox, &imc_w->lbox, &imc_w->drawSys, &imc_w->subwin );


	// Ԑݒ
	// 	
	imc_w->state = IMC_SYS_ACCE;

	// TEhf[^[h(C[WNbv)(BGMp)
	Snd_DataSetByScene( SND_SCENE_SUB_IMAGE, 0, 0 );
	
	return PROC_RES_FINISH;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvbNC
 *
 *	@param	proc		vbNf[^	
 *	@param	seq			V[PX
 *
 *	@return	
 *
 *	typedef enum {
 *		PROC_RES_CONTINUE = 0,		///<p
 *		PROC_RES_FINISH,			///<I
 *	}PROC_RESULT;
 *
 *
 */
//-----------------------------------------------------------------------------
PROC_RESULT IMC_ProcMain( PROC* proc, int* seq )
{
	IMC_SYS_WORK* imc_w = PROC_GetWork( proc );
	PROC_RESULT	ret = PROC_RES_CONTINUE;

	switch( (*seq) ){
	
	case IMC_SYS_SEQ_FADE_IN:
		WIPE_Start( 
				WIPE_PATTERN_FMAS,
				WIPE_TYPE_SHUTTERIN_UP,
				WIPE_TYPE_SHUTTERIN_UP,
				0,
				8,1,
				HEAPID_IMAGECLIP_DATA,
				&imc_w->effect);
		WIPE_ResetBrightness( WIPE_DISP_MAIN );
		WIPE_ResetBrightness( WIPE_DISP_SUB );
		(*seq) ++;
		break;
		
	case IMC_SYS_SEQ_FADE_IN_WAIT:
		if( imc_w->effect ){
			imc_w->effect = 0;
			(*seq) ++;
		}
		break;

	//-------------------------------------
	//	
	//	C
	//	
	//=====================================
	case IMC_SYS_SEQ_MAIN:

		if(imc_w->state == IMC_SYS_END_CHECK_REQ){
			// tF[hJn
			endSeenFadeIn( imc_w, &imc_w->effect );
			// tF[hAEg
			(*seq) = IMC_SYS_SEQ_END_CHECK_WAIT;
		}

		// nh
		IMC_HAND_Main( &imc_w->hand );

		// {^
		mainBttn( imc_w );
		break;

	case IMC_SYS_SEQ_END_CHECK_WAIT:	// I`FbNtF[h҂
		if( imc_w->effect ){
			imc_w->effect = FALSE;
			(*seq) = IMC_SYS_SEQ_END_CHECK;
			imc_w->state = IMC_SYS_END_CHECK;

			// E{bNXvC[쐬
			IMC_RBOX_PLAYER_Init( &imc_w->rbox_player, &imc_w->rbox, HEAPID_IMAGECLIP_DRAW );
		}
		break;

	case IMC_SYS_SEQ_END_CHECK:			// I`FbN
		
		// LZ`FbN
		if( imc_w->state == IMC_SYS_END_CANCEL_REQ ){
			// tF[hJn
			endSeenFadeOut( imc_w, &imc_w->effect );
			(*seq) = IMC_SYS_SEQ_MAIN_WAIT;
		}

		// I`FbN
		if( imc_w->state == IMC_SYS_END_REQ ){
			(*seq) = IMC_SYS_SEQ_FADE_OUT;
		}
		
		// {^
		mainBttnEndCk( imc_w );

		// E{bNXvC[
		IMC_RBOX_PLAYER_Main( &imc_w->rbox_player );
		break;

	case IMC_SYS_SEQ_MAIN_WAIT:			// CʃtF[h҂
		if( imc_w->effect ){
			imc_w->effect = FALSE;
			(*seq) = IMC_SYS_SEQ_MAIN;
			imc_w->state = IMC_SYS_ACCE;		// ANZTύXł͂߂

			// E{bNXvC[I
			IMC_RBOX_PLAYER_Delete( &imc_w->rbox_player );
		}
		break;
		
	case IMC_SYS_SEQ_FADE_OUT:
		WIPE_Start( 
				WIPE_PATTERN_FMAS,
				WIPE_TYPE_FADEOUT,
				WIPE_TYPE_FADEOUT,
				0,
				8,2,
				HEAPID_IMAGECLIP_DATA,
				&imc_w->effect);
		(*seq) ++;
		break;

	case IMC_SYS_SEQ_FADE_OUT_WAIT:
		if( imc_w->effect ){
			imc_w->effect = 0;
			(*seq) = 0;
			imc_w->state = IMC_SYS_END;
			ret = PROC_RES_FINISH;

			// E{bNXvC[I
			IMC_RBOX_PLAYER_Delete( &imc_w->rbox_player );
		}
		break;
	}

	///////////////////////////////////////////////
	//
	//	͋ʏ
	//
	//////////////////////////////////////////////
	// `揈
	mainDrawSys( imc_w );
	

	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvbNI
 *
 *	@param	proc		vbNf[^	
 *	@param	seq			V[PX
 *
 *	@return	
 *
 *	typedef enum {
 *		PROC_RES_CONTINUE = 0,		///<p
 *		PROC_RES_FINISH,			///<I
 *	}PROC_RESULT;
 *
 *
 */
//-----------------------------------------------------------------------------
PROC_RESULT IMC_ProcEnd( PROC* proc, int* seq )
{
	IMC_SYS_WORK* imc_w = PROC_GetWork( proc );
	u32	check;	// p
	IMC_PROC_WORK* p_pr_w = PROC_GetParentWork( proc );	// f[^Z[u

	// f[^Z[u
	dataSave( p_pr_w->p_imc_one_data, &imc_w->rbox );	
	
	// TuEBhEj
	deleteSubWin( imc_w );
	
	// nhj
	IMC_ACCE_HAND_Delete( &imc_w->hand );
	
	// {^j
	deleteBttnEndCk( imc_w );

	// t[BGj
	delFrameBG( imc_w );
	
	// E{bNXj
	deleteRightBox( imc_w );
	
	// {bNXj
	deleteLeftBox( imc_w );
	
	// ANZTi[f[^j
	IMC_ACCE_ObjTblDelete( imc_w->acce );
	imc_w->acce = NULL;
	
	// IuWFNgXge[uj
	IMC_OBJLIST_TblDelete( &imc_w->objListTbl );
	
	deleteDrawSys( imc_w );
	
	sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
	sys_HBlankIntrStop();	//HBlank荞ݒ~

	// ^b`plTvOI
	check = StopTP();
	GF_ASSERT( check == TP_OK );

	// [Nj
	PROC_FreeWork( proc );

	// q[vj
	sys_DeleteHeap( HEAPID_IMAGECLIP_DATA );
	sys_DeleteHeap( HEAPID_IMAGECLIP_DRAW );
	
	return PROC_RES_FINISH;
}




//-----------------------------------------------------------------------------
/**
*		vCx[g֐
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXe
 *
 *	@param	imc_w	VXe[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initDrawSys( IMC_SYS_WORK* imc_w )
{
	IMC_DRAW_LOADRES_DATA loadData;	// 摜f[^ǂݍ݃f[^

	// ʃf[^ݒ
	IMC_DRAW_SetUp();

	// `VXe쐬
	IMC_DRAW_InitSys( &imc_w->drawSys );
	
	// `f[^쐬
	IMC_DRAW_MakeLoadSWSP_samp( &imc_w->drawSys, &loadData );

	// `f[^Vram]
	IMC_DRAW_LoadResource( &imc_w->drawSys, &loadData );

	// `f[^j
	IMC_DRAW_DestLoadSWSP( &loadData );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXeC
 *
 *	@param	imc_w	VXe[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void mainDrawSys( IMC_SYS_WORK* imc_w )
{
	IMC_DRAW_DrawSys( &imc_w->drawSys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXej
 *
 *	@param	imc_w	VXe[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteDrawSys( IMC_SYS_WORK* imc_w )
{
	// `f[^j
	IMC_DRAW_DeleteResource( &imc_w->drawSys );

	// `VXej
	IMC_DRAW_DeleteSys( &imc_w->drawSys );

	// `ʐݒj
	IMC_DRAW_PutBack();
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNXf[^쐬
 *
 *	@param	imc_w	C[WNbvVXef[^
 *	@param	p_pr_w	ʃVXẽf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initRightBox( IMC_SYS_WORK* imc_w, IMC_PROC_WORK* p_pr_w )
{
	IMC_RIGHT_BOX_INIT	rbox_init;	// E{bNXf[^

	// E{bNXf[^쐬
	// `f[^
	rbox_init.SWSP_drawSys		= imc_w->drawSys.SWSP_drawSys;
	rbox_init.SWSP_charData		= imc_w->drawSys.SWSP_charData;
	rbox_init.SWSP_plttData		= imc_w->drawSys.SWSP_plttData;
	rbox_init.accePlttOfsTbl	= imc_w->drawSys.accePlttOfsTbl;
	rbox_init.SSM_drawSys		= imc_w->drawSys.SSM_drawSys;
	rbox_init.BG_Ini			= imc_w->drawSys.BG_Ini;

	rbox_init.acce		= imc_w->acce;			// ANZTf[^
	rbox_init.objListTbl= &imc_w->objListTbl;	// IuWFNgXge[u
	IMC_RBOX_InitSys( &imc_w->rbox, &rbox_init );
	
	// |Po^
	{
		SOFT_SPRITE_ARC	arc;
		IMC_RBOX_AddPoke( &imc_w->rbox, p_pr_w->p_poke_para, &arc );
		
		// |PLN^f[^o^
		IMC_POKE_CharSet( &imc_w->drawSys, &arc );
	}
/*
	// E{bNXɔzuf[^쐬
	{
		int i;
		for(i=0;i<IMC_ACCE_MAX; i++){
			int x,y;
			x = IMC_RBOX_AREA_X;
			y = IMC_RBOX_AREA_Y;
			
			// ͉ɍ쐬
			IMC_RBOX_AddAccessorie( &imc_w->rbox, i, 
					x + (gf_mtRand() % (IMC_RBOX_AREA_WIDTH / 2)),
					y + (gf_mtRand() % (IMC_RBOX_AREA_HEIGHT / 2)) );
		}
	}//*/
	IMC_RBOX_SetObjPriority( &imc_w->rbox );

	// BG\
	IMC_RBOX_BGSet( &imc_w->rbox, IMC_BG_RIGHT_00, HEAPID_IMAGECLIP_DRAW );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNXf[^j
 *
 *	@param	imc_w	C[WNbvVXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteRightBox( IMC_SYS_WORK* imc_w )
{
	// BGN[
	IMC_RBOX_BGClean( &imc_w->rbox );
	
	// E{bNXzuf[^j
	IMC_RBOX_DeleteAccessorieAll( &imc_w->rbox );
	
	// E{bNXf[^j
	IMC_RBOX_DeleteSys( &imc_w->rbox );
	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{bNXf[^쐬
 *
 *	@param	imc_w	C[WNbvVXef[^
 *	@param	p_pr_w	ʂ󂯎f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initLeftBox( IMC_SYS_WORK* imc_w, IMC_PROC_WORK* p_pr_w )
{
	IMC_LEFT_BOX_INIT	lbox_init;	// E{bNXf[^

	// {bNXf[^쐬
	// `f[^
	lbox_init.SWSP_drawSys		= imc_w->drawSys.SWSP_drawSys;
	lbox_init.SWSP_charData		= imc_w->drawSys.SWSP_charData;
	lbox_init.SWSP_plttData		= imc_w->drawSys.SWSP_plttData;
	lbox_init.accePlttOfsTbl	= imc_w->drawSys.accePlttOfsTbl;
	lbox_init.BG_Ini			= imc_w->drawSys.BG_Ini;
	lbox_init.acce			= imc_w->acce;			// ANZTf[^
	lbox_init.objListTbl	= &imc_w->objListTbl;	// IuWFNgXge[u
	lbox_init.accelist_num	= IMC_LBOX_ACCE_NEAD_LIST_NUM;	// Xg
	lbox_init.bglist_num	= IMC_LBOX_BG_NEAD_LIST_NUM;	// Xg
	lbox_init.sndlist_num	= IMC_LBOX_SND_NEAD_LIST_NUM;	// Xg
	IMC_LBOX_InitSys( &imc_w->lbox, &lbox_init );

	// Jg擪_~[f[^쐬
	IMC_LBOX_SetCurrentAccessorie( 
			&imc_w->lbox, 
			IMC_OBJLIST_ACCE,
			0 );


	// {bNXɔzuf[^쐬
	{
		int i;
		int x,y;

		x = IMC_LBOX_AREA_X;
		y = IMC_LBOX_AREA_Y;

		for(i=0;i<IMC_ACCE_MAX; i++){

			// ͉ɍ쐬
			IMC_LBOX_AddAccessorie( &imc_w->lbox, IMC_OBJLIST_ACCE, i );
		}
/*		
		for(i=0;i<IMC_ACCE_MAX; i++){
			
			// ͉ɍ쐬
			IMC_LBOX_AddAccessorie( &imc_w->lbox, IMC_OBJLIST_ACCE, i );
		}
//*/
		// BGTlC쐬
		for( i=0; i<IMC_BG_RIGHT_MAX; i++ ){
			
			// ͉ɍ쐬
			IMC_LBOX_AddAccessorie( &imc_w->lbox, IMC_OBJLIST_BG, i );
		}

		// \D揇ʐݒ
		IMC_LBOX_SetAccessoriePriority( &imc_w->lbox );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{bNXf[^쐬
 *
 *	@param	imc_w	C[WNbvVXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteLeftBox( IMC_SYS_WORK* imc_w )
{
	// BGN[
	IMC_LBOX_BGClean( &imc_w->lbox );
	
	// E{bNXzuf[^j
	IMC_LBOX_DeleteAccessorieAll( &imc_w->lbox );
	
	// E{bNXf[^j
	IMC_LBOX_DeleteSys( &imc_w->lbox );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	VuN֐
 *
 *	@param	void* work 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void imageClipVBlankFunc( void* work )
{
	IMC_SYS_WORK* sys = work;

	// `֌WVuN֐
	IMC_DRAW_VBlank( &sys->drawSys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	t[BG\
 *
 *	@param	imc_w	C[WNbv[N
 *	@param	no		BGno
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setFrameBG( IMC_SYS_WORK* imc_w, int no )
{
	IMC_BG_ADD add;
	
	// o^f[^ݒ
	add.bg_ini		= imc_w->drawSys.BG_Ini;
	add.arc_file	= ARC_IMAGECLIP_GRA;
	add.char_arc	= IMC_BG_FRAME_CG_ARC_GET(no);
	add.pltt_arc	= IMC_BG_LEFT_FRAME_CL;
	add.scrn_arc	= IMC_BG_FRAME_SC_ARC_GET(no);
	add.x			= 0;
	add.y			= 0;
	add.frame		= GF_BGL_FRAME1_M;
	add.pltt_num	= 1;
	add.pltt_offs	= 2;
	add.char_offs	= 0;
	add.heap		= HEAPID_IMAGECLIP_DRAW;

	IMC_BG_MakaObj( &imc_w->frame_bg, &add );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	t[BG\
 *
 *	@param	imc_w	C[WNbv[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void delFrameBG( IMC_SYS_WORK* imc_w )
{
	IMC_BG_DeleteObj( &imc_w->frame_bg );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{^f[^쐬
 *
 *	@param	imc_w	C[WNbv[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initBttn( IMC_SYS_WORK* imc_w )
{
	IMC_IMCBTTN_Init( &imc_w->bttn, &imc_w->drawSys );

	// pbgύX֐ݒ
	IMC_IMCBTTN_FuncSet( &imc_w->bttn, IMC_BTTN_RET, retBttn, imc_w, IMC_BTTN_POP );

	// pbgύX߂֐ݒ
	IMC_IMCBTTN_FuncSet( &imc_w->bttn, IMC_BTTN_RETB, retbBttn, imc_w, IMC_BTTN_POP );
	
	// ANZTpbgύX֐ݒ
	IMC_IMCBTTN_FuncSet( &imc_w->bttn, IMC_BTTN_ACE, acceBttn, imc_w, IMC_BTTN_PUSH_F );
	// ANZTpbgύX{^IԂɂ
	
	
	// BGpbgύX֐ݒ
	IMC_IMCBTTN_FuncSet( &imc_w->bttn, IMC_BTTN_BG, bgBttn, imc_w, IMC_BTTN_PUSH_F );
	
	// I{^֐ݒ
	IMC_IMCBTTN_FuncSet( &imc_w->bttn, IMC_BTTN_END, endBttn, imc_w, IMC_BTTN_POP );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{^f[^j
 *
 *	@param	imc_w	C[WNbv[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteBttn( IMC_SYS_WORK* imc_w )
{
	IMC_IMCBTTN_Delete( &imc_w->bttn, &imc_w->drawSys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{^C֐
 *
 *	@param	imc_w	C[WNbv[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void mainBttn( IMC_SYS_WORK* imc_w )
{
	IMC_IMCBTTN_Main( &imc_w->bttn );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbN{^̍쐬
 *
 *	@param	imc_w	C[WNbv[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initBttnEndCk( IMC_SYS_WORK* imc_w )
{
	IMC_IMCBTTN_ENDCK_Init( &imc_w->bttn_endck, &imc_w->drawSys );

	// pbgύX֐ݒ
	IMC_IMCBTTN_ENDCK_FuncSet( &imc_w->bttn_endck, IMC_BTTN_ENDCK_CANCEL, endCkCancelBttn, imc_w, IMC_BTTN_POP );
	
	// ANZTpbgύX֐ݒ
	IMC_IMCBTTN_ENDCK_FuncSet( &imc_w->bttn_endck, IMC_BTTN_ENDCK_END, endCkEndBttn, imc_w, IMC_BTTN_POP );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbN{^̔j
 *
 *	@param	imc_w	C[WNbv[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteBttnEndCk( IMC_SYS_WORK* imc_w )
{
	IMC_IMCBTTN_ENDCK_Delete( &imc_w->bttn_endck, &imc_w->drawSys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbN{^C
 *
 *	@param	imc_w	C[WNbv[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void mainBttnEndCk( IMC_SYS_WORK* imc_w )
{
	IMC_IMCBTTN_ENDCK_Main( &imc_w->bttn_endck );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvI֐
 *
 *	@param	bttn	{^\
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void endBttn( IMC_BUTTON* bttn, void* work )
{
	IMC_SYS_WORK* imc_w = work;

	// Iėǂԉ`FbN
	if( IMC_LBOX_ENDCheck( &imc_w->lbox ) == FALSE ){
		return ;
	}
	
	// Ԑݒ
	// 	INGXg
	imc_w->state = IMC_SYS_END_CHECK_REQ;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgύX
 *
 *	@param	bttn	{^\
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void retBttn( IMC_BUTTON* bttn, void* work )
{
	IMC_SYS_WORK* imc_w = work;
	int mode;
	int list_num;
	int list_max;

	mode		= IMC_LBOX_GetMode( &imc_w->lbox );
	list_num	= IMC_LBOX_GetCurrentNo( &imc_w->lbox, mode );
	list_max	= IMC_LBOX_GetDummyTblNum( &imc_w->lbox, mode );
	
	list_num = (list_num + 1) % list_max;

	// pbg̒gύX
	IMC_LBOX_ChangeCurrentAccessorie( 
			&imc_w->lbox, mode, list_num );
	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbg߂
 *
 *	@param	bttn	{^\
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void retbBttn( IMC_BUTTON* bttn, void* work )
{
	IMC_SYS_WORK* imc_w = work;
	int mode;
	int list_num;
	int list_max;

	mode		= IMC_LBOX_GetMode( &imc_w->lbox );
	list_num	= IMC_LBOX_GetCurrentNo( &imc_w->lbox, mode );
	list_max	= IMC_LBOX_GetDummyTblNum( &imc_w->lbox, mode );
	
	list_num--;
	if( list_num < 0 ){
		list_num += list_max;
	}

	// pbg̒gύX
	IMC_LBOX_ChangeCurrentAccessorie( 
			&imc_w->lbox, mode, list_num );
	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTpbgɕύX
 *
 *	@param	bttn	{^\
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void	acceBttn( IMC_BUTTON* bttn, void* work )
{
	IMC_SYS_WORK* imc_w = work;
	int list_num;
	int mode;

	if( imc_w->state != IMC_SYS_ACCE ){
		list_num	= IMC_LBOX_GetCurrentNo( &imc_w->lbox, IMC_OBJLIST_ACCE );
		

		// pbg̒gύX
		IMC_LBOX_SetCurrentAccessorie( 
				&imc_w->lbox, IMC_OBJLIST_ACCE, list_num );

		// Ԑݒ
		imc_w->state = IMC_SYS_ACCE;
		// {^Ԑݒ
		IMC_IMCBTTN_OnAB( &imc_w->bttn, IMC_BTTN_ACE );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGpbgɕύX
 *
 *	@param	bttn	{^\
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void	bgBttn( IMC_BUTTON* bttn, void* work )
{
	IMC_SYS_WORK* imc_w = work;
	int list_num;
	int mode;

	if( imc_w->state != IMC_SYS_BG ){

		list_num	= IMC_LBOX_GetCurrentNo( &imc_w->lbox, IMC_OBJLIST_BG );
		
		// pbg̒gύX
		IMC_LBOX_SetCurrentAccessorie( 
				&imc_w->lbox, IMC_OBJLIST_BG, list_num );

		// Ԑݒ
		imc_w->state = IMC_SYS_BG;

		// {^Ԑݒ
		IMC_IMCBTTN_OnAB( &imc_w->bttn, IMC_BTTN_BG );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	TuEBhE
 *
 *	@param	imc_w	TuEBhE
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initSubWin( IMC_SYS_WORK* imc_w )
{
	IMC_SUBWIN_INIT	init;
	init.bg_ini = imc_w->drawSys.BG_Ini;
	
	IMC_SUBWIN_Init( &imc_w->subwin, &init, IMC_SUBWIN_DEFAULT_INIT );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	TuEBhEj
 *
 *	@param	imc_w	TuEBhE
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteSubWin( IMC_SYS_WORK* imc_w )
{
	IMC_SUBWIN_Delete( &imc_w->subwin );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	IʂփtF[hCJn
 *
 *	@param	imc_w	VXe[N	
 *	@param	end		ImtO
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void endSeenFadeIn( IMC_SYS_WORK* imc_w, BOOL* end )
{
	TCB_PTR tcb;
	IMC_SYS_FADE_WORK* fade_w;

	// ^XNo^
	tcb = PMDS_taskAdd( endSeenFadeInTask, sizeof( IMC_SYS_FADE_WORK ), 10, HEAPID_IMAGECLIP_DATA );

	// [NɃf[^ݒ
	fade_w = TCB_GetWork( tcb );
	fade_w->sys_w	= imc_w;
	fade_w->end		= end;
	fade_w->work	= 0;
	fade_w->seq		= 0;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	IʃtF[h^XN
 *
 *	@param	tcb		^XNIuWF
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void endSeenFadeInTask( TCB_PTR tcb, void* work )
{
	IMC_SYS_FADE_WORK* fade_w = work;
	BOOL	check;
	
	switch( fade_w->seq ){
	case IMC_SEENFADEIN_ACCE_FADEOUT:
		check = IMC_LBOX_ChangeCurrentAccessorie( 
				&fade_w->sys_w->lbox,
				IMC_LBOX_FADELIST_MODE,
				0);
		GF_ASSERT( check );	// 

		
		fade_w->seq++;
		break;
		
	case IMC_SEENFADEIN_ACCE_FADEWAIT:
		check = IMC_LBOX_ENDCheck( &fade_w->sys_w->lbox );
		if( check ){

			fade_w->seq++;
		}
		break;

	case IMC_SEENFADEIN_BRIGHTNESS_OUT:
		ChangeBrightnessRequest(
				IMC_SEENFADE_BRIGHTNESS_FADE_SYNC,
				BRIGHTNESS_BLACK,
				BRIGHTNESS_NORMAL,
//				PLANEMASK_BG1 | PLANEMASK_BG3 | PLANEMASK_OBJ,
				PLANEMASK_BG1 | PLANEMASK_BG3,
				MASK_MAIN_DISPLAY );
		fade_w->seq++;
		break;


	case IMC_SEENFADEIN_BRIGHTNESS_WAIT:
		check = IsFinishedBrightnessChg( MASK_MAIN_DISPLAY );
		if( check ){
			fade_w->seq++;
		}
		break;

	case IMC_SEENFADEIN_BUTTON_OLDOUT:
		IMC_IMCBTTN_Move( &fade_w->sys_w->bttn, 0, IMC_SEENFADE_BTTNMOVE_ADD_Y );
		fade_w->work ++;
		if( fade_w->work >= IMC_SEENFADE_BTTNMOVE_COUNT ){
			fade_w->work = 0;
			fade_w->seq ++;
		}
		break;

	case IMC_SEENFADEIN_BUTTON_CHG:
		deleteBttn( fade_w->sys_w );
		initBttnEndCk( fade_w->sys_w );

		// tF[hCɂ
		IMC_IMCBTTN_ENDCK_Move( &fade_w->sys_w->bttn_endck, 0, IMC_SEENFADE_BTTNMOVE_DIS );

		fade_w->seq++;
		break;

	
	case IMC_SEENFADEIN_MOVE_BGINIT:
		// BG 1ʂBGύX
		setFrameBG( fade_w->sys_w, IMC_BG_FRAME_01 );
		fade_w->seq++;
		break;

	case IMC_SEENFADEIN_MOVE_BG:
		GF_BGL_ScrollReq( fade_w->sys_w->drawSys.BG_Ini, GF_BGL_FRAME2_M, GF_BGL_SCROLL_X_INC, IMC_SEENFADE_MOVE_ADD_X );
		GF_BGL_ScrollReq( fade_w->sys_w->drawSys.BG_Ini, GF_BGL_FRAME1_M, GF_BGL_SCROLL_X_INC, IMC_SEENFADE_MOVE_ADD_X );
		IMC_RBOX_ListMove( &fade_w->sys_w->rbox, -IMC_SEENFADE_MOVE_ADD_X, 0 );
		
		fade_w->work++;
		if( fade_w->work >= IMC_SEENFADE_MOVE_COUNT ){
			fade_w->work = 0;
			fade_w->seq++;
		}
		break;
		
	case IMC_SEENFADEIN_BUTTON_NEWIN:
		IMC_IMCBTTN_ENDCK_Move( &fade_w->sys_w->bttn_endck, 0, -IMC_SEENFADE_BTTNMOVE_ADD_Y );
		fade_w->work ++;
		if( fade_w->work >= IMC_SEENFADE_BTTNMOVE_COUNT ){
			fade_w->work = 0;
			fade_w->seq ++;
		}
		break;
	
	case IMC_SEENFADEIN_BRIGHTNESS_IN:
		ChangeBrightnessRequest(
				IMC_SEENFADE_BRIGHTNESS_FADE_SYNC,
				BRIGHTNESS_NORMAL,
				BRIGHTNESS_BLACK,
//				PLANEMASK_BG1 | PLANEMASK_BG3 | PLANEMASK_OBJ,
				PLANEMASK_BG1 | PLANEMASK_BG3,
				MASK_MAIN_DISPLAY );
		fade_w->seq++;
		break;


	case IMC_SEENFADEIN_BRIGHTNESS_INWAIT:
		check = IsFinishedBrightnessChg( MASK_MAIN_DISPLAY );
		if( check ){
			fade_w->seq++;
		}
		break;
		
	case IMC_SEENFADEIN_END:
		*fade_w->end = TRUE;
		PMDS_taskDel( tcb );
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbv쐬ʃtF[hJn
 *
 *	@param	imc_w	VXe[N
 *	@param	end		ImtO
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void endSeenFadeOut( IMC_SYS_WORK* imc_w, BOOL* end )
{
	TCB_PTR tcb;
	IMC_SYS_FADE_WORK* fade_w;

	// ^XNo^
	tcb = PMDS_taskAdd( endSeenFadeOutTask, sizeof( IMC_SYS_FADE_WORK ), 10, HEAPID_IMAGECLIP_DATA );

	// [NɃf[^ݒ
	fade_w = TCB_GetWork( tcb );
	fade_w->sys_w	= imc_w;
	fade_w->end		= end;
	fade_w->work	= 0;
	fade_w->seq		= 0;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbv쐬ʃtF[h^XN
 *
 *	@param	tcb		^XNIuWF
 *	@param	work	[N
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void endSeenFadeOutTask( TCB_PTR tcb, void* work )
{
	IMC_SYS_FADE_WORK* fade_w = work;
	BOOL	check;
	
	switch( fade_w->seq ){

	case IMC_SEENFADEOUT_BRIGHTNESS_OUT:
		ChangeBrightnessRequest(
				IMC_SEENFADE_BRIGHTNESS_FADE_SYNC,
				BRIGHTNESS_BLACK,
				BRIGHTNESS_NORMAL,
//				PLANEMASK_BG1 | PLANEMASK_BG3 | PLANEMASK_OBJ,
				PLANEMASK_BG1 | PLANEMASK_BG3,
				MASK_MAIN_DISPLAY );
		fade_w->seq++;
		break;
			
	case IMC_SEENFADEOUT_BRIGHTNESS_OUTWAIT:
		check = IsFinishedBrightnessChg( MASK_MAIN_DISPLAY );
		if( check ){
			fade_w->seq++;
		}
		break;

	case IMC_SEENFADEOUT_BUTTON_OLDOUT:
		IMC_IMCBTTN_ENDCK_Move( &fade_w->sys_w->bttn_endck, 0, IMC_SEENFADE_BTTNMOVE_ADD_Y );
		fade_w->work ++;
		if( fade_w->work >= IMC_SEENFADE_BTTNMOVE_COUNT ){
			fade_w->work = 0;
			fade_w->seq ++;
		}
		break;

	case IMC_SEENFADEOUT_BUTTON_CHG:
		deleteBttnEndCk( fade_w->sys_w );
		initBttn( fade_w->sys_w );

		// tF[hCɂ
		IMC_IMCBTTN_Move( &fade_w->sys_w->bttn, 0, IMC_SEENFADE_BTTNMOVE_DIS );

		fade_w->seq++;
		break;


	case IMC_SEENFADEOUT_MOVE_BG:
		GF_BGL_ScrollReq( fade_w->sys_w->drawSys.BG_Ini, GF_BGL_FRAME2_M, GF_BGL_SCROLL_X_DEC, IMC_SEENFADE_MOVE_ADD_X );
		GF_BGL_ScrollReq( fade_w->sys_w->drawSys.BG_Ini, GF_BGL_FRAME1_M, GF_BGL_SCROLL_X_DEC, IMC_SEENFADE_MOVE_ADD_X );
		IMC_RBOX_ListMove( &fade_w->sys_w->rbox, IMC_SEENFADE_MOVE_ADD_X, 0 );

		fade_w->work++;
		if( fade_w->work >= IMC_SEENFADE_MOVE_COUNT ){
			fade_w->work = 0;
			setFrameBG( fade_w->sys_w, IMC_BG_FRAME_00 );
			fade_w->seq++;
		}
		break;


	case IMC_SEENFADEOUT_BUTTON_NEWIN:
		IMC_IMCBTTN_Move( &fade_w->sys_w->bttn, 0, -IMC_SEENFADE_BTTNMOVE_ADD_Y );
		fade_w->work ++;
		if( fade_w->work >= IMC_SEENFADE_BTTNMOVE_COUNT ){
			fade_w->work = 0;
			fade_w->seq ++;
		}
		break;



	case IMC_SEENFADEOUT_BRIGHTNESS_IN:
		ChangeBrightnessRequest(
				IMC_SEENFADE_BRIGHTNESS_FADE_SYNC,
				BRIGHTNESS_NORMAL,
				BRIGHTNESS_BLACK,
//				PLANEMASK_BG1 | PLANEMASK_BG3 | PLANEMASK_OBJ,
				PLANEMASK_BG1 | PLANEMASK_BG3,
				MASK_MAIN_DISPLAY );
		fade_w->seq++;
		break;

	case IMC_SEENFADEOUT_BRIGHTNESS_WAIT:
		check = IsFinishedBrightnessChg( MASK_MAIN_DISPLAY );
		if( check ){
			fade_w->seq++;
		}
		break;
		
	case IMC_SEENFADEOUT_ACCE_FADEIN:
		check = IMC_LBOX_ChangeCurrentAccessorie( 
				&fade_w->sys_w->lbox,
				IMC_OBJLIST_ACCE,
				0);
		GF_ASSERT( check );	// 

		fade_w->seq++;
		break;
		
	case IMC_SEENFADEOUT_ACCE_FADEWAIT:
		check = IMC_LBOX_ENDCheck( &fade_w->sys_w->lbox );
		if( check ){

			fade_w->seq++;
		}
		break;

	case IMC_SEENFADEOUT_END:
		*fade_w->end = TRUE;
		PMDS_taskDel( tcb );
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbNV[PX@I{^
 *
 *	@param	bttn		{^\
 *	@param	work		[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void endCkEndBttn( IMC_BUTTON* bttn, void* work )
{
	IMC_SYS_WORK* imc_w = work;

	// Ԑݒ
	// 	INGXg
	imc_w->state = IMC_SYS_END_REQ;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbNV[PX@CANCEL{^
 *
 *	@param	bttn		{^\
 *	@param	work		[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void endCkCancelBttn( IMC_BUTTON* bttn, void* work )
{
	IMC_SYS_WORK* imc_w = work;

	// Ԑݒ
	// 	INGXg
	imc_w->state = IMC_SYS_END_CANCEL_REQ;
}

//----------------------------------------------------------------------------
/**
 *	@brief	f[^Z[u
 *
 *	@param	save_data	Z[uf[^
 *	@param	rbox		E{bNXf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void dataSave( IMC_ONE_SAVEDATA* save_data, IMC_RIGHT_BOX* rbox )
{
	IMC_OBJLIST* p_work;
	int count;
	
	// |Pf[^ۑ
	ImcSaveData_SetPokeData( save_data, 
			rbox->boxDraw.poke.poke_para,
			&rbox->boxDraw.poke );

	// ANZTf[^ۑ
	count = 0;
	p_work = rbox->boxData.dummy_poke.next;
	while( p_work != &rbox->boxData.dummy_poke ){
		// ANZTf[^Ȃۑ	
		if( p_work->flag == IMC_OBJLIST_ACCE ){
			ImcSaveData_SetAcceData( save_data, p_work->obj_data, count );
			count ++;
		}
		p_work = p_work->next;
	}
	p_work = rbox->boxData.dummy.next;
	while( p_work != &rbox->boxData.dummy ){
		// ANZTf[^Ȃۑ	
		if( p_work->flag == IMC_OBJLIST_ACCE ){
			ImcSaveData_SetAcceData( save_data, p_work->obj_data, count );
			count ++;
		}
		p_work = p_work->next;
	}

	// BGID
	ImcSaveData_SetBgId( save_data, rbox->boxDraw.bg_no );	
}
