//============================================================================================
/**
 * @file	namein.c
 * @bfief	O͉ʏ
 * @author	Akito Mori
 * @date	05.10.05
 */
//============================================================================================
#define USE_PARAM_STR	// NAMEIN_PARAM u16 str[20]KvȊԗLɂiŏj


#include "common.h"
#include "system/procsys.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/pm_str.h"
#include "system/clact_tool.h"
#include "system/msgdata_util.h"
#include "system/wordset.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_namein.h"
#include "system/wipe.h"
#include "system/brightness.h"
#include "system/fontproc.h"
#include "system/lib_pack.h"
#include "system/fontoam.h"
#include "gflib/msg_print.h"
#include "gflib/touchpanel.h"
#include "poketool/monsno.h"
#include "poketool/pokeicon.h"
#include "application/namein.h"
#include "system/bmp_menu.h"
#include "system/bmp_tool.h"
#include "system/snd_tool.h"
#include "gflib/strbuf_family.h"
#include "msgdata/msg_opening_name.h"
#include "namein_snd_def.h"


#define POKEICON_VRAM_OFFSET (20*32+15)
#define POKEICON_PAL_OFFSET	 ( 6 )

// CLACTŒ`ĂZ傫ăTuʂɉełĂ܂̂ŗĂ݂
#define NAMEIN_SUB_ACTOR_DISTANCE 	(256*FX32_ONE)


#include "namein.naix"			// OtBbNA[JCu`
//============================================================================================
//	萔`
//============================================================================================
enum {
	SEQ_IN = 0,
	SEQ_MAIN,
	SEQ_OUT,
};


typedef struct {
	int x;			// ݈ʒu
	int y;			//
	int oldx;		// 1STEPÖʒu
	int oldy;		//
	int lastxarrow;	// Ō̈ړ

	int on;			// \ONEOFF
}NAMEIN_CURSOR;

#define INPUT_SCREEN_MAX	( 5)	
#define INPUT_WORD_W		(17)
#define INPUT_WORD_H		( 5)
#define INPUT_WORD_WH		(INPUT_WORD_W*INPUT_WORD_H)
#define INPUT_WORD_MAX		(32)	//͖

// CellActorɏ郊\[X}l[W̎ނ̐i}`ZE}`ZAj͎gpȂj
#define CLACT_RESOURCE_NUM		(  4 )
#define NAMEIN_OAM_NUM			( 14 )
#define NAMELINE_OAM_NUM		( 10 )

// J[\CLACT_WORKio[
#define CLACT_CURSOR_NUM		(  8 )

// pl̓]
#define WORDPANEL_TRANS_SIZE	( 32*13*2 )

// pl̈ʒu`
#define WORDPANEL_POS_REGX		(  -11 )
#define WORDPANEL_POS_REGY		(  -80 )
#define HIDDENPANEL_POS_REGX	(  234 )
#define DOWNPANEL_POS_REGY		( -196 )

#define WORDPANEL_IN_SPEED		( 24 )
#define WORDPANEL_OUT_SPEED		( 10 )

// ͍ςݕ̉OBJ
#define NAMELINE_POS_X			( 10*8   )
#define NAMELINE_POS_Y			(  6*8+5 )

// p\RE@E|PACROBJʒu
#define NAMEIN_MYICON_X			( 24 )
#define NAMEIN_MYICON_Y			( 16 )

// |P̐ʃACR̈ʒu
#define NAMEIN_SEXICON_Y		( NAMELINE_POS_Y - 12)

// O͏ʒu`iȂ̂Ȃ܂́Hj
#define NAME_INFO_POSX			(  8 )
#define NAME_INFO_POSY			(  2 )
#define NAME_INFO_POSW			( 18 )
#define NAME_INFO_POSH			(  2 )
#define NAMEINFO_WIN_SIZE		( NAME_INFO_POSW*NAME_INFO_POSH )


// O͌ʕ\ʒu`
#define NAME_RESULT_POSX		( 10   )
#define NAME_RESULT_POSY		(  5   )
#define NAME_RESULT_POSW		( 9*2  )
#define NAME_RESULT_POSH		(  2   )



// pl̑Jڗp
enum{
	NAMEIN_MODE_REQ  = 0, 
	NAMEIN_MODE_SET,
	NAMEIN_MODE_ANIM,
	NAMEIN_MODE_ANIM_WAIT,
	NAMEIN_MODE,
};

// @\{^`
enum{
	NAMEIN_MODE_HIRA = 0,
	NAMEIN_MODE_KANA,
	NAMEIN_MODE_ALPHA,
	NAMEIN_MODE_KIGOU,
};

// ㉺ʎw`
#define BOTH_LCD	( 2 )
#define MAIN_LCD	( GF_BGL_MAIN_DISP )	// v͂O
#define SUB_LCD		( GF_BGL_SUB_DISP )		// PȂłB

// BMPWINw
enum{
	BMP_WORDPANEL_BG0=0,
	BMP_WORDPANEL_BG1,
	BMP_TITLE_MES,
	BMP_RESULT_NAME,
	BMP_SUB_BUTTON1,
	BMP_SUB_BUTTON2,
	BMP_SUB_BUTTON3,
	BMP_SUB_STRING,
	BMP_NAMEIN_MAX,
};

// @\{^p`
#define FUNCBUTTON_NUM	( 7 ) 		// @\{^̐
#define START_WORDPANEL ( 0 )		// ŏ̓̕pl̔ԍiOЂ炪ȁj
// ef[^`

#include "namein.dat"

//============================================================================================
//	\̒`
//============================================================================================

struct NAMEIN_WORK{
	int inputmode;												// ̓[hi0:l,1:|P,2:{bNX
	int inputinfo;												// ͏ijA|PNOȂ
	int inputmax;												// ͕ő吔

	NAMEIN_CURSOR 	Cursor;										// J[\@XEYEߋXE\ON
	u16				CursorPal;
	u16 			wordmap[INPUT_WORD_H][INPUT_WORD_W];	// Ճ}bv
	u16 			nowmap;									// ݂̕}bv
	u16 			inputword[INPUT_WORD_MAX];				// ͂
	u16 			paramstr[INPUT_WORD_MAX];				// (ĂяoɊi[ĂirɎgpjj
	u16				nowinput;								// ݂̃J[\ʒu
	u16				subtouchword[3];						// R̉{^ɔzuĂ镶R[h
	GF_BGL_INI		*bgl;
	BOOL			wipe_end;								// CvIotO

	WORDSET			*WordSet;								// bZ[WWJp[N}l[W[
	MSGDATA_MANAGER *MsgManager;							// O̓bZ[Wf[^}l[W[
	MSGDATA_MANAGER *MsgDefaultName;						// ̖O⃁bZ[Wf[^
	STRBUF			*TitleStr;								// O̓^Cg
	STRBUF			*ChangeWordStr;							// u v


	CLACT_SET_PTR 			clactSet;								// ZAN^[Zbg
	CLACT_U_EASYRENDER_DATA	renddata;								// ȈՃ_[f[^
	CLACT_U_RES_MANAGER_PTR	resMan[CLACT_RESOURCE_NUM];				// \[X}l[W
	CLACT_U_RES_OBJ_PTR 	resObjTbl[BOTH_LCD][CLACT_RESOURCE_NUM];// \[XIuWFe[u
	CLACT_HEADER			clActHeader_m;							// ZAN^[wb_[
	CLACT_HEADER			clActHeader_s;							// ZAN^[wb_[
	CLACT_WORK_PTR			clActWork[NAMEIN_OAM_NUM];				// ZAN^[[N|C^z
	CLACT_WORK_PTR			NameLineActWork[NAMELINE_OAM_NUM];		// ͌ʕ\̉A_[C
	CLACT_WORK_PTR			NameIconActWork[2];						// ͉ʐACRi@Ep\R^ʁEj
	TCB_PTR					FuncButtonTask[FUNCBUTTON_NUM];

	GF_BGL_BMPWIN 			NameInWin[BMP_NAMEIN_MAX];				// O͗pBMPEChE


	int						seq;									// ݂̕͏ԁiOK/AjjȂ
	int						mode;									// ݍőOʂ̕pl

	int						front;									// OɗĂBG
	VecFx32					panelpos[2];							// ړ2BGʗpW[N(Œ菭ł͎gĂȂj

	int						word;									

	int						old_subbutton;							// Ỏʃ{^
	int						subbutton_mode;
	int						subbutton_work;

	int						funcbutton[FUNCBUTTON_NUM];				// {^ԃtO

	void*					BgCharaBuf;
	NNSG2dCharacterData*	BgCharaDat;

	void*					PokeIconBuf;							// |PACRf[^
	NNSG2dCharacterData*	PokeIconCharaDat;						

	void*					PokeIconPalBuf;
	NNSG2dPaletteData*		PokeIconPalDat;
	
	u8						ObjTransWork[32*4*2];					//

#ifdef PM_DEBUG
	int 					frame;									//
	int						framenum[9][2];							//
#endif
};


//============================================================================================
//	vg^Cv錾
//============================================================================================
static PROC_RESULT NameInProc_Init( PROC * proc, int * seq );
static PROC_RESULT NameInProc_Main( PROC * proc, int * seq );
static PROC_RESULT NameInProc_End( PROC * proc, int * seq );

static void VBlankFunc( void * work );
static void VramBankSet(void);
static void BgInit( GF_BGL_INI * ini );
static void BgExit( GF_BGL_INI * ini, GF_BGL_BMPWIN *win );
static void BgGraphicSet( NAMEIN_WORK * wk );
static void PanelFunc(GF_BGL_INI *bgl, GF_BGL_BMPWIN *win, int *seq, int mode, int *front, VecFx32 panelpos[], CLACT_WORK_PTR *clActWork, void *dakuten_Character);
static void InitWork(NAMEIN_WORK *wk, PROC * proc);
static void FrontBackBG_RegSet(GF_BGL_INI *bgl, int front, VecFx32 panelpos[]);
static void SetPanelFirstPos(VecFx32 panelpos[], int front);
static void InitCellActor(NAMEIN_WORK *wk);
static void SetCellActor(NAMEIN_WORK *wk);
static void char_pltt_manager_init(void);
static void BmpMessageSet(NAMEIN_WORK *wk, PROC* proc);
static void DebugOBJPOSGet(NAMEIN_WORK *wk);
static void ControlCursor(NAMEIN_WORK *wk);
static void CursorColTrans(u16 *CursorCol);
static void TouchFunc(NAMEIN_WORK *wk);
static void NameinWordPanelPrint(GF_BGL_BMPWIN *win, const u16 *str, int x,int y, int sw, GF_PRINTCOLOR color, u8 *datkuten_Character);
static void ChangeSubPanelButtonWord(GF_BGL_BMPWIN *win, const u16 *tbl, u8 *TransWork, STRBUF *ChangeWordStr);
static void MakeWordMap(u16 map[][INPUT_WORD_W], const int no);
static void SubPanelButton_CharaChange(GF_BGL_BMPWIN *win, u16 code, u16 *words, u8 *TransWork, STRBUF *ChangeWordStr);
static int  DecideMainButton(NAMEIN_WORK *wk,u16 code);
static int  ConvertWord(int start, int num, int flag, int target, u16*str, int pos);
static int  RotateConvertWord(int start, int num, u16 *str, int pos);
static void InputResultUnderLineMove(CLACT_WORK_PTR *lineact,int pos, int max);
static void SetNameInWorkParameter(NAMEIN_WORK *wk, NAMEIN_PARAM *param);
static void WordPanelSetUp(GF_BGL_BMPWIN *win,u16 bgchara, int frame, GF_PRINTCOLOR color, u8 *dakuten_Character);
static void CursorAppearUpDate(NAMEIN_WORK *wk, int arrow);
static void FuncButtonAnimation(int funcbutton[], CLACT_WORK_PTR *ButtonAct, int frame);
static void FuncButtonTaskFunc( TCB_PTR tcb, void *work );
static void QuakeFrameTaskFunc( TCB_PTR tcb, void *work );
static void TransPokeIconCharaPal( NNSG2dCharacterData *chara, NNSG2dPaletteData *pal, int pokeno );
static void Namein_LCDOnOff( int flag);


static void *GF_STR_PrintCGXOnly(GF_BGL_BMPWIN * win, STRBUF *msg,u8 fnt_index, GF_PRINTCOLOR col);


//============================================================================================
//	O[oϐ
//============================================================================================
// vZX`f[^
const PROC_DATA NameInProcData = {
	NameInProc_Init,
	NameInProc_Main,
	NameInProc_End,
	NO_OVERLAY_ID,
};



//============================================================================================
//	vZX֐
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * vZX֐F
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT NameInProc_Init( PROC * proc, int * seq )
{
	NAMEIN_WORK * wk;

	switch(*seq){
	case 0:
		sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
		sys_HBlankIntrStop();	//HBlank荞ݒ~

		GF_Disp_GX_VisibleControlInit();
		GF_Disp_GXS_VisibleControlInit();
		GX_SetVisiblePlane( 0 );
		GXS_SetVisiblePlane( 0 );

		sys_CreateHeap( HEAPID_BASE_APP, HEAPID_NAMEIN, 0x20000+0x8000 );

		wk = PROC_AllocWork( proc, sizeof(NAMEIN_WORK), HEAPID_NAMEIN );
		memset( wk, 0, sizeof(NAMEIN_WORK) );
		wk->bgl = GF_BGL_BglIniAlloc( HEAPID_NAMEIN );
		
		// }l[W[
		wk->WordSet    = WORDSET_Create( HEAPID_NAMEIN );
		wk->MsgManager = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_namein_dat, HEAPID_NAMEIN );
		wk->MsgDefaultName  = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_opening_name_dat, HEAPID_NAMEIN );

		sys_KeyRepeatSpeedSet( 4, 8 );

		VramBankSet();
		
		// BGLWX^ݒ
		BgInit( wk->bgl );					

		// PxύXZbg

//		ChangeBrightnessRequest(
//			8, 0, -16, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );

		//BGOtBbNZbg
		BgGraphicSet( wk );

//		InitTPSystem();						// ^b`plVXe
//		InitTPNoBuff(4);
  
		// {^ptHgǂݍ
		FontProc_LoadFont( FONT_BUTTON, HEAPID_NAMEIN );
  	
		// ۑ
		SetNameInWorkParameter(wk, (NAMEIN_PARAM*)PROC_GetParentWork(proc));
  
		// VBlank֐Zbg
		sys_VBlankFuncChange( VBlankFunc, NULL );	
  

		// [N
		InitWork(wk,proc);

		// VXetHg풓
		FontProc_LoadBitData(FONT_SYSTEM,HEAPID_NAMEIN);

		// OBJLApbg}l[W[
		char_pltt_manager_init();

		// CellActorVXe
		InitCellActor(wk);
		
		// CellActro\o^
		SetCellActor(wk);

		// BMPWINo^E`
		BmpMessageSet(wk,proc);

		// plEo^
		MakeWordMap(wk->wordmap,0);			// Ђ炪ȕ}bvWJ

		// {^OBJtHg]
		SubPanelButton_CharaChange(&wk->NameInWin[BMP_SUB_BUTTON1],
									wk->inputword[wk->nowinput-1],
									wk->subtouchword,
									wk->ObjTransWork,
									wk->ChangeWordStr);

		// TEhf[^[h(O)(BGMp)
		Snd_DataSetByScene( SND_SCENE_SUB_NAMEIN, 0, 0 );

		WIPE_Start(WIPE_PATTERN_WMS, WIPE_TYPE_FADEIN, WIPE_TYPE_FADEIN, WIPE_FADE_BLACK, 
				16, 1, HEAPID_NAMEIN, &wk->wipe_end);
		Namein_LCDOnOff( VISIBLE_ON );

		(*seq)++;
		break;
	case 1:
		wk = PROC_GetWork( proc );
		if(wk->inputmode==NAMEIN_POKEMON){
			// |PACRf[^VRAMɓ]
			TransPokeIconCharaPal(wk->PokeIconCharaDat, wk->PokeIconPalDat, wk->inputinfo);
		}
		(*seq) = 0;
		return PROC_RES_FINISH;
		break;
	}
	return PROC_RES_CONTINUE;
}


//------------------------------------------------------------------
/**
 * |PACR]i|P̖O̎j
 *
 * @param   chara	LN^[t@CAhX
 * @param   pal		pbgt@CAhX
 * @param   pokeno	|P̊JNO
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void TransPokeIconCharaPal( NNSG2dCharacterData *chara, NNSG2dPaletteData* pal, int pokeno )
{
	u8 *pokepal;

	// LN^[]
	GX_LoadOBJ(chara->pRawData, POKEICON_VRAM_OFFSET*0x20, 0x20*4*4);

	// pbg]
	pokepal = (u8*)pal->pRawData;
	GX_LoadOBJPltt((void*)(pokepal + PokeIconPaletteIDGet(pokeno)*0x20), POKEICON_PAL_OFFSET*0x20, 0x20);


}


//--------------------------------------------------------------------------------------------
/**
 * vZX֐FC
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------

static PROC_RESULT NameInProc_Main( PROC * proc, int * seq )
{
	NAMEIN_WORK * wk  = PROC_GetWork( proc );

	switch( *seq ){
	case SEQ_IN:
//		if( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) ){
		if( wk->wipe_end ){
			*seq = SEQ_MAIN;
		}
		break;

	case SEQ_MAIN:
		// J[\ړ
		if(wk->seq == NAMEIN_MODE){
			ControlCursor(wk);		//		DebugOBJPOSGet(wk);
			TouchFunc(wk);
			if( sys.trg & PAD_BUTTON_SELECT){
				// pl؂ւ
				wk->seq = NAMEIN_MODE_REQ;
				wk->mode++;
				if(wk->mode>NAMEIN_MODE_KIGOU){
					wk->mode=NAMEIN_MODE_HIRA;
				}
				wk->funcbutton[wk->mode]++;
				MakeWordMap(wk->wordmap, wk->mode);		// ̓}bvւ
				Snd_SePlay( NAMEIN_SE_CHANGEPANEL );
			}
			if( sys.trg & PAD_BUTTON_A){
				// 
				*seq = DecideMainButton(wk,wk->wordmap[wk->Cursor.y][wk->Cursor.x]);
			}else if( sys.trg & PAD_BUTTON_B ){
				// 
				*seq = DecideMainButton(wk,NAMEIN_MODORU);

			}
		}

		// NGXgɕplւ
		PanelFunc(wk->bgl, &wk->NameInWin[BMP_WORDPANEL_BG0], &wk->seq, wk->mode, &wk->front, wk->panelpos, wk->clActWork, wk->BgCharaDat->pRawData);

		// @\{^̃Aj
		FuncButtonAnimation(wk->funcbutton, wk->clActWork, wk->mode);

		CursorColTrans(&wk->CursorPal);

		break;

	case SEQ_OUT:
//		if( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) ){
		if( wk->wipe_end ){
			return PROC_RES_FINISH;
		}
		break;
	}
	CLACT_Draw( wk->clactSet );									// ZAN^[풓֐

	return PROC_RES_CONTINUE;
}

#define DEFAULT_NAME_MAX		18

// _CEp[ŕς񂾂낤
#define MALE_NAME_START			0
#define FEMALE_NAME_START		18

//--------------------------------------------------------------------------------------------
/**
 * vZX֐FI
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT NameInProc_End( PROC * proc, int * seq )
{
	NAMEIN_WORK  *wk    = PROC_GetWork( proc );
	NAMEIN_PARAM *param = (NAMEIN_PARAM*)PROC_GetParentWork(proc);
	int i;

	// LZȂH
	if(wk->nowinput==0 || (PM_strcmp( wk->inputword, wk->paramstr)==0)){

		// ̖O͂̎̓LZ͖
		if(wk->inputmode==NAMEIN_MYNAME){
			STRBUF *DefaultName;
			if(wk->inputinfo==PM_MALE){
				DefaultName = MSGMAN_AllocString( wk->MsgDefaultName, MALE_NAME_START+gf_rand()%DEFAULT_NAME_MAX );
			}else if(wk->inputinfo==PM_FEMALE){
				DefaultName = MSGMAN_AllocString( wk->MsgDefaultName, FEMALE_NAME_START+gf_rand()%DEFAULT_NAME_MAX );
			}
			STRBUF_Copy(param->strbuf, DefaultName);
			STRBUF_Delete(DefaultName);
#ifdef USE_PARAM_STR
			STRBUF_GetStringCode( param->strbuf, param->str, 10 );
#endif
		}else{
			// LZ
			param->cancel = 1;
		}

	}else{
		// ͕[Nɔf
		wk->inputword[wk->nowinput] = EOM_;
		PM_strcpy(wk->paramstr,wk->inputword);
#ifdef USE_PARAM_STR
		PM_strcpy(param->str,wk->inputword);
#endif

		STRBUF_SetStringCode(param->strbuf,wk->inputword);
	}

	// @\{^ʒu^XN
	for(i=0;i<FUNCBUTTON_NUM;i++){
		PMDS_taskDel(wk->FuncButtonTask[i]);
	}
	// ZAN^[\[X

	// L]}l[W[j
	CLACT_U_CharManagerDelete(wk->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES]);
	CLACT_U_CharManagerDelete(wk->resObjTbl[SUB_LCD][CLACT_U_CHAR_RES]);

	// pbg]}l[W[j
	CLACT_U_PlttManagerDelete(wk->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES]);
	CLACT_U_PlttManagerDelete(wk->resObjTbl[SUB_LCD][CLACT_U_PLTT_RES]);
		
	// LEpbgEZEZAj̃\[X}l[W[j
	for(i=0;i<CLACT_RESOURCE_NUM;i++){
		CLACT_U_ResManagerDelete(wk->resMan[i]);
	}
	// ZAN^[Zbgj
	CLACT_DestSet(wk->clactSet);

	//OAM_[j
	REND_OAM_Delete();

	// BMPWINpLf[^
	sys_FreeMemory( HEAPID_NAMEIN, wk->BgCharaBuf );

	// |PACR
	if(wk->inputmode==NAMEIN_POKEMON){
		sys_FreeMemory( HEAPID_NAMEIN,wk->PokeIconBuf );
		sys_FreeMemory( HEAPID_NAMEIN,wk->PokeIconPalBuf );	
	}

	//bEChEpobt@
	GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME3_S);

	DeleteCharManager();
	DeletePlttManager();

	// BMPEBhEJ
	BgExit(wk->bgl,wk->NameInWin);
	// BGL폜

	// 풓VXetHg
	FontProc_UnloadBitData(FONT_SYSTEM);


	GX_SetVisibleWnd( GX_WNDMASK_NONE );	//n[hEFAEChE

	// {^ptHg
	FontProc_UnloadFont( FONT_BUTTON );

//	StopTP();							// ^b`plI

	// u`̂Ȃ܂́Hv
	STRBUF_Delete(wk->TitleStr);
	//uv
	STRBUF_Delete(wk->ChangeWordStr);

	// bZ[W}l[W[E[hZbg}l[W[
	MSGMAN_Delete( wk->MsgDefaultName );
	MSGMAN_Delete( wk->MsgManager );
	WORDSET_Delete( wk->WordSet );

	PROC_FreeWork( proc );				// [NJ

	sys_VBlankFuncChange( NULL, NULL );		// VBlankZbg

	sys_DeleteHeap( HEAPID_NAMEIN );

	return PROC_RES_FINISH;
}

//==============================================================================
/**
 * O͂ɓnp[^mۂiO͂̌ʂ̂ŁAĂяoHEAPIDKvj
 *
 * @param   HeapId		ĂяoHEAPID
 * @param   mode		O̓[h(NAMEIN_MYNAME,NAMEIN_BOX,NAMEIN_POKEMON)
 * @param   info		NAMEIN_MYNAME̎0=j1=, NAMEIN_POKEMON̎͊JNO
 * @param   wordmax		͕ő吔̎w
 *
 * @retval  NAMEIN_PARAM *		mۂꂽO̓p[^̃|C^
 */
//==============================================================================
NAMEIN_PARAM *NameIn_ParamAllocMake(int HeapId, int mode, int info, int wordmax)
{
	NAMEIN_PARAM *param;
	
	
	param = (NAMEIN_PARAM*)sys_AllocMemory(HeapId, sizeof(NAMEIN_PARAM));

	param->mode    = mode;		// ̓[hi̖OA|PA{bNXj
	param->info    = info;		// ijEA|P̊JNO)
	param->wordmax = wordmax;	// ͕ő吔
	param->cancel  = 0;			// LZtO
#ifdef USE_PARAM_STR
	param->str[0]  = EOM_;
#endif

	// ő咷{EOMŕobt@쐬
	param->strbuf = STRBUF_Create( wordmax+1, HeapId );

	return param;
}

//==============================================================================
/**
 * O̓p[^̉iO͌Ƀ[U[O擾Ă炤j
 *
 * @param   param		
 *
 * @retval  none		
 */
//==============================================================================
void NameIn_ParamDelete(NAMEIN_PARAM *param)
{
	GF_ASSERT((param->strbuf)!=NULL);
	GF_ASSERT((param)!=NULL);
	
	sys_FreeMemoryEz(param->strbuf);
	sys_FreeMemoryEz(param);
}

//--------------------------------------------------------------------------------------------
/**
 * VBlank֐
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void VBlankFunc( void * work )
{
	// ZAN^[
	// Vram]}l[W[s
	DoVramTransferManager();

	// _LOAM}l[WVram]
	REND_OAMTrans();	
	
	OS_SetIrqCheckFlag( OS_IE_V_BLANK );
}

//==============================================================================
/**
 * O疼O͏p[^[炤
 *
 * @param   wk			O̓[Ñ|C^
 * @param   mode		̓[hinamein.henumQ
 * @param   info		͏ijE|PmnȂ
 * @param   wordmax		͕ő吔
 *
 * @retval  none		
 */
//==============================================================================
static void SetNameInWorkParameter(NAMEIN_WORK *wk, NAMEIN_PARAM *param)
{
	wk->inputmode = param->mode;
	wk->inputinfo = param->info;
	wk->inputmax  = param->wordmax;
}

//--------------------------------------------------------------------------------------------
/**
 * VRAMݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void VramBankSet(void)
{
	GF_BGL_DISPVRAM tbl = {
		GX_VRAM_BG_128_A,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg

		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg

		GX_VRAM_OBJ_128_B,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg

		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg

		GX_VRAM_TEX_NONE,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_NONE			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &tbl );
}

//--------------------------------------------------------------------------------------------
/**
 * BGݒ
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgInit( GF_BGL_INI * ini )
{
	// BG SYSTEM
	{	
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	// ʕ0
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x1000, 0, GF_BGL_SCRSIZ_512x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_M );


	}

	// ʕ1
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x1000, 0, GF_BGL_SCRSIZ_512x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe000, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME1_M );
	}

	// wi
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xd000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME2_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME2_M );
	}

	// wi (CHAR)
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xd800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME3_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}




	// BUTTON (CHAR)
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_S );
	}

	// BG (CHAR)
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}

	Namein_LCDOnOff( VISIBLE_OFF );

	GF_BGL_ClearCharSet( GF_BGL_FRAME0_M, 32, 0, HEAPID_NAMEIN );
	GF_BGL_ClearCharSet( GF_BGL_FRAME0_S, 32, 0, HEAPID_NAMEIN );

	// ʂ̃n[hEFAEChE0nm
	GX_SetVisibleWnd( GX_WNDMASK_W0 );
	G2_SetWnd0InsidePlane( GX_WND_PLANEMASK_BG2 | GX_WND_PLANEMASK_OBJ,1);
	G2_SetWndOutsidePlane( GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG1 |GX_WND_PLANEMASK_BG2 | GX_WND_PLANEMASK_OBJ,1);
	G2_SetWnd0Position(0, 0, 255, 64);


}


//------------------------------------------------------------------
/**
 * $brief   O͉ʂ̕\nmEnee
 *
 * @param   flag		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void Namein_LCDOnOff( int flag)
{
	GF_Disp_GX_VisibleControl( GX_BLEND_PLANEMASK_BG0, flag);
	GF_Disp_GX_VisibleControl( GX_BLEND_PLANEMASK_BG1, flag);
	GF_Disp_GX_VisibleControl( GX_BLEND_PLANEMASK_BG2, flag);
	GF_Disp_GX_VisibleControl( GX_BLEND_PLANEMASK_BG3, flag);
	GF_Disp_GX_VisibleControl( GX_BLEND_PLANEMASK_OBJ, flag);


    GF_Disp_GXS_VisibleControl( GX_BLEND_PLANEMASK_BG0,flag);
    GF_Disp_GXS_VisibleControl( GX_BLEND_PLANEMASK_BG1,flag);
    GF_Disp_GXS_VisibleControl( GX_BLEND_PLANEMASK_OBJ,flag);
	
}

//------------------------------------------------------------------
/**
 * O̓[N
 *
 * @param   wk		NAMEIN_WORK*
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void InitWork(NAMEIN_WORK *wk, PROC * proc)
{
	NAMEIN_PARAM *param = (NAMEIN_PARAM*)PROC_GetParentWork(proc);
	wk->seq = NAMEIN_MODE;

	SetPanelFirstPos(wk->panelpos, 0);

	GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME0_M+wk->front,       GF_BGL_SCROLL_X_SET, wk->panelpos[wk->front].x );
	GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME0_M+wk->front,       GF_BGL_SCROLL_Y_SET, wk->panelpos[wk->front].y );
	GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME0_M+((wk->front)^1), GF_BGL_SCROLL_X_SET, wk->panelpos[((wk->front)^1)].x );
	GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME0_M+((wk->front)^1), GF_BGL_SCROLL_Y_SET, wk->panelpos[((wk->front)^1)].y );

#ifdef PM_DEBUG
	{
		int i;
		for(i=0;i<9;i++){
			wk->framenum[i][0] = main_button_info[i][0];
			wk->framenum[i][1] = main_button_info[i][1];
		}
	
	}
#endif

	wk->paramstr[0] = EOM_;
	// p[^[ŖĂSTRBUF̓WJ
	if(param->strbuf){
		STRBUF_GetStringCode(param->strbuf, wk->paramstr, INPUT_WORD_MAX);
	}

	MI_CpuFill16( wk->inputword, spc_,  INPUT_WORD_MAX*2 );


	// u`̂Ȃ܂́HvWJ
	if(wk->inputmode==NAMEIN_POKEMON){
		POKEMON_PARAM *pp;

		pp = PokemonParam_AllocWork(HEAPID_NAMEIN);
		PokeParaSet(pp,wk->inputinfo,5,10,10,10,10,10);
		WORDSET_RegisterPokeMonsName( wk->WordSet, 0, PPPPointerGet(pp) );
		sys_FreeMemoryEz(pp);
	}

	// u`̂Ȃ܂́Hv擾(|P̖OœWJ)
	wk->TitleStr      = MSGDAT_UTIL_AllocExpandString( wk->WordSet, wk->MsgManager, NAMEIN_MSG_TITLEINFO0+wk->inputmode, HEAPID_NAMEIN );
	wk->ChangeWordStr = MSGDAT_UTIL_AllocExpandString( wk->WordSet, wk->MsgManager, NAMEIN_MSG_CHANGEWORD, HEAPID_NAMEIN );

	// NAMEIN_PARAM.strɃftHgĂ΃J[\̈ʒu0ł͂ȂȂ
	wk->nowinput       = PM_strlen( wk->paramstr ); 
	wk->Cursor.x       = 0;	// ʒuuv̈ʒu
	wk->Cursor.y       = 1;	
	wk->old_subbutton  = RECT_HIT_NONE;							// Ỏʃ{^
	wk->subbutton_mode = 0;
	wk->subbutton_work = 0;
	wk->inputword[wk->inputmax] = EOM_;


	// @\{^ԃ[N
	{
		int i;
		for(i=0;i<FUNCBUTTON_NUM;i++){
			wk->funcbutton[i]	= 0;
		}
		wk->funcbutton[START_WORDPANEL] = 1;
	}
	
	wk->wipe_end = 0;
}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgExit( GF_BGL_INI * ini, GF_BGL_BMPWIN *win )
{
	int i;
//	GF_Disp_GX_VisibleControl(
//		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_BG2 |
//		GX_PLANEMASK_BG3 | GX_PLANEMASK_OBJ, VISIBLE_OFF );
//	GF_Disp_GXS_VisibleControl(
//		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_OBJ, VISIBLE_OFF );

	for(i=0;i<BMP_NAMEIN_MAX;i++){
		GF_BGL_BmpWinDel( &win[i] );
	}

	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME3_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_M );

	sys_FreeMemory( HEAPID_NAMEIN, ini );
}


//--------------------------------------------------------------------------------------------
/**
 * OtBbNf[^Zbg
 *
 * @param	wk		|PXgʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgGraphicSet( NAMEIN_WORK * wk )
{
	GF_BGL_INI *bgl = wk->bgl;

	// ㉺ʂafpbg]
	ArcUtil_PalSet(    ARC_NAMEIN_GRA, NARC_namein_name_bg_NCLR, PALTYPE_SUB_BG,  0, 16*3*2,  HEAPID_NAMEIN);
	ArcUtil_PalSet(    ARC_NAMEIN_GRA, NARC_namein_name_bg_NCLR, PALTYPE_MAIN_BG, 0, 16*3*2,  HEAPID_NAMEIN);

	// BGL]
	ArcUtil_BgCharSet( ARC_NAMEIN_GRA, NARC_namein_name_bg_m_lz_NCGR, bgl, GF_BGL_FRAME2_M, 0, 32*8*0x20, 1, HEAPID_NAMEIN);

	// BG2XN[]
	ArcUtil_ScrnSet(   ARC_NAMEIN_GRA, NARC_namein_name_bg_m_lz_NSCR, bgl, GF_BGL_FRAME2_M, 0, 32*24*2, 1, HEAPID_NAMEIN);


	// BG1L]
	ArcUtil_BgCharSet( ARC_NAMEIN_GRA, NARC_namein_name_bg_m_lz_NCGR, bgl, GF_BGL_FRAME1_M, 0, 32*8*0x20, 1, HEAPID_NAMEIN);
	// BG1XN[]
	ArcUtil_ScrnSet(   ARC_NAMEIN_GRA, NARC_namein_name_screen1_lz_NSCR, bgl, GF_BGL_FRAME1_M, 0, WORDPANEL_TRANS_SIZE, 1, HEAPID_NAMEIN);
	// BG0XN[]
	ArcUtil_ScrnSet(   ARC_NAMEIN_GRA, NARC_namein_name_screen2_lz_NSCR, bgl, GF_BGL_FRAME0_M, 0, WORDPANEL_TRANS_SIZE, 1, HEAPID_NAMEIN);
	
	

	// BG0L]
	ArcUtil_BgCharSet( ARC_NAMEIN_GRA, NARC_namein_name_bg_s_lz_NCGR, bgl, GF_BGL_FRAME0_S, 0, 32*2*0x20, 1, HEAPID_NAMEIN);

	// BG0XN[]
	ArcUtil_ScrnSet(   ARC_NAMEIN_GRA, NARC_namein_name_bg_s_lz_NSCR, bgl, GF_BGL_FRAME0_S, 0, 32*24*2, 1, HEAPID_NAMEIN);


	// BMPWIN]pLp(BgCharaBuf͖O͏IɉKvj
	wk->BgCharaBuf = ArcUtil_CharDataGet( ARC_NAMEIN_GRA, NARC_namein_name_bg_prog_lz_NCGR, 1, &wk->BgCharaDat, HEAPID_NAMEIN );

}


//** CharManager PlttManagerp **//
#define NAMEIN_CHAR_CONT_NUM				(20)
#define NAMEIN_CHAR_VRAMTRANS_MAIN_SIZE		(2048)
#define NAMEIN_CHAR_VRAMTRANS_SUB_SIZE		(2048)
#define NAMEIN_PLTT_CONT_NUM				(20)

//-------------------------------------
//
//	LN^}l[W[
//	pbg}l[W[̏
//
//=====================================
void char_pltt_manager_init(void)
{
	// LN^}l[W[
	{
		CHAR_MANAGER_MAKE cm = {
			NAMEIN_CHAR_CONT_NUM,
			NAMEIN_CHAR_VRAMTRANS_MAIN_SIZE,
			NAMEIN_CHAR_VRAMTRANS_SUB_SIZE,
			HEAPID_NAMEIN
		};
		InitCharManager(&cm);
	}
	// pbg}l[W[
	InitPlttManager(NAMEIN_PLTT_CONT_NUM, HEAPID_NAMEIN);

	// ǂݍ݊Jnʒu
	CharLoadStartAll();
	PlttLoadStartAll();
}


//------------------------------------------------------------------
/**
 * [_[ʗpZAN^[
 *
 * @param   wk		[_[\̂̃|C^
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void InitCellActor(NAMEIN_WORK *wk)
{
	int i;
	
	
	// OAM}l[W[̏
	NNS_G2dInitOamManagerModule();

	// LOAM}l[W쐬
	// _pOAM}l[W쐬
	// ō쐬OAM}l[W݂ȂŋL
	REND_OAMInit( 
			0, 128,		// COAMǗ̈
			0, 32,		// CʃAtBǗ̈
			0, 128,		// TuOAMǗ̈
			0, 32,		// TuʃAtBǗ̈
			HEAPID_NAMEIN);
	
	
	
	// ZAN^[
	wk->clactSet = CLACT_U_SetEasyInit( 26, &wk->renddata, HEAPID_NAMEIN );
	
	CLACT_U_SetSubSurfaceMatrix( &wk->renddata, 0, NAMEIN_SUB_ACTOR_DISTANCE );

	
	//\[X}l[W[
	for(i=0;i<CLACT_RESOURCE_NUM;i++){		//\[X}l[W[쐬
		wk->resMan[i] = CLACT_U_ResManagerInit(2, i, HEAPID_NAMEIN);
	}


	//---------ʗp-------------------

	//charaǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] = CLACT_U_ResManagerResAddArcChar(wk->resMan[CLACT_U_CHAR_RES], 
							ARC_NAMEIN_GRA, NARC_namein_name_obj_m_lz_NCGR, 1, 0, NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_NAMEIN);

	//palǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] = CLACT_U_ResManagerResAddArcPltt(wk->resMan[CLACT_U_PLTT_RES],
							ARC_NAMEIN_GRA, NARC_namein_name_obj_NCLR, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN, 7, HEAPID_NAMEIN);

	//cellǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_CELL_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELL_RES],
							ARC_NAMEIN_GRA, NARC_namein_name_obj_m_lz_NCER, 1, 0, CLACT_U_CELL_RES,HEAPID_NAMEIN);

	//֐animǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_CELLANM_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELLANM_RES],
							ARC_NAMEIN_GRA, NARC_namein_name_obj_m_lz_NANR, 1, 0, CLACT_U_CELLANM_RES,HEAPID_NAMEIN);

	// |P̖O͂̏ꍇ̓ACRf[^ǂݍ
	if(wk->inputmode==NAMEIN_POKEMON){
		wk->PokeIconBuf    = ArcUtil_CharDataGet( ARC_POKEICON, PokeIconCgxArcIndexGetByMonsNo( wk->inputinfo, 0 ), 0, &wk->PokeIconCharaDat, HEAPID_NAMEIN );
		DC_FlushRange(wk->PokeIconCharaDat,0x20*4*4);

		wk->PokeIconPalBuf = ArcUtil_PalDataGet( ARC_POKEICON, PokeIconPalArcIndexGet(), &wk->PokeIconPalDat, HEAPID_NAMEIN );
		DC_FlushRange(wk->PokeIconPalDat,0x20*4);	
	}
//	ArcUtil_PalDataGet( u32 fileIdx, u32 dataIdx, NNSG2dPaletteData** palData, u32 heapID );

	//---------ʗp-------------------



	//charaǂݍ
	wk->resObjTbl[SUB_LCD][CLACT_U_CHAR_RES] = CLACT_U_ResManagerResAddArcChar(wk->resMan[CLACT_U_CHAR_RES], 
							ARC_NAMEIN_GRA, NARC_namein_name_obj_s_lz_NCGR, 1, 1, NNS_G2D_VRAM_TYPE_2DSUB, HEAPID_NAMEIN);

	//palǂݍ
	wk->resObjTbl[SUB_LCD][CLACT_U_PLTT_RES] = CLACT_U_ResManagerResAddArcPltt(wk->resMan[CLACT_U_PLTT_RES],
							ARC_NAMEIN_GRA, NARC_namein_name_obj_NCLR, 0, 1, NNS_G2D_VRAM_TYPE_2DSUB, 3, HEAPID_NAMEIN);

	//cellǂݍ
	wk->resObjTbl[SUB_LCD][CLACT_U_CELL_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELL_RES],
							ARC_NAMEIN_GRA, NARC_namein_name_obj_s_lz_NCER, 1, 1, CLACT_U_CELL_RES,HEAPID_NAMEIN);

	//֐animǂݍ
	wk->resObjTbl[SUB_LCD][CLACT_U_CELLANM_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELLANM_RES],
							ARC_NAMEIN_GRA, NARC_namein_name_obj_s_lz_NANR, 1, 1, CLACT_U_CELLANM_RES,HEAPID_NAMEIN);

	// \[X}l[W[]

	// Chara]
	CLACT_U_CharManagerSet( wk->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] );
	CLACT_U_CharManagerSet( wk->resObjTbl[SUB_LCD][CLACT_U_CHAR_RES] );

	// pbg]
	CLACT_U_PlttManagerSet( wk->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] );
	CLACT_U_PlttManagerSet( wk->resObjTbl[SUB_LCD][CLACT_U_PLTT_RES] );

}

typedef struct{
	CLACT_WORK_PTR parent;
	CLACT_WORK_PTR child;
	int dx;
	int id;
}FUNC_BUTTON_TASK_WORK;


//------------------------------------------------------------------
/**
 * @\{^plt[Ɠ悤ɂ鏈
 *
 * @param   tcb		
 * @param   work	
 *
 * @retval  none	
 */
//------------------------------------------------------------------
static void FuncButtonTaskFunc( TCB_PTR tcb, void *work )
{
	const VecFx32 *pVex;
	VecFx32 cVex;
	FUNC_BUTTON_TASK_WORK *wk = (FUNC_BUTTON_TASK_WORK*)work;

	pVex   = CLACT_GetMatrix(wk->parent);
	cVex.x = pVex->x + wk->dx;
	cVex.y = FX32_ONE*main_button_info[wk->id][1];
	cVex.z = 0;
	CLACT_SetMatrix(wk->child, &cVex);
}

//------------------------------------------------------------------
/**
 * ZAN^[o^
 *
 * @param   wk			NAMEIN_WORK*
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SetCellActor(NAMEIN_WORK *wk)
{
	int i;
	// ZAN^[wb_쐬
	CLACT_U_MakeHeader(&wk->clActHeader_m, 0, 0, 0, 0, CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
	0, 0,
	wk->resMan[CLACT_U_CHAR_RES],
	wk->resMan[CLACT_U_PLTT_RES],
	wk->resMan[CLACT_U_CELL_RES],
	wk->resMan[CLACT_U_CELLANM_RES],
	NULL,NULL);

	CLACT_U_MakeHeader(&wk->clActHeader_s, 1, 1, 1, 1, CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
	0, 0,
	wk->resMan[CLACT_U_CHAR_RES],
	wk->resMan[CLACT_U_PLTT_RES],
	wk->resMan[CLACT_U_CELL_RES],
	wk->resMan[CLACT_U_CELLANM_RES],
	NULL,NULL);

	{
		//o^i[
		CLACT_ADD add;

		add.ClActSet	= wk->clactSet;
		add.ClActHeader	= &wk->clActHeader_m;

		add.mat.x		= FX32_CONST(32) ;
		add.mat.y		= FX32_CONST(96) ;		//ʂ͏㉺AĂiMAINASUBj
		add.mat.z		= 0;
		add.sca.x		= FX32_ONE;
		add.sca.y		= FX32_ONE;
		add.sca.z		= FX32_ONE;
		add.rot			= 0;
		add.pri			= 0;
		add.DrawArea	= NNS_G2D_VRAM_TYPE_2DMAIN;
		add.heap		= HEAPID_NAMEIN;

		//ZAN^[\Jn

		// ʗp
		for(i=0;i<9;i++){
			add.mat.x = FX32_ONE*main_button_info[i][0];
			add.mat.y = FX32_ONE*main_button_info[i][1];
			wk->clActWork[i] = CLACT_Add(&add);
			CLACT_SetAnmFlag(wk->clActWork[i],1);
			CLACT_AnmChg( wk->clActWork[i], main_button_info[i][2] );
			CLACT_DrawPriorityChg(wk->clActWork[i], main_button_info[i][3]);	// ꂼ̃AN^[̃vCIeBݒ
			
		}
		// @\{^plo[ɓēo^
		for(i=0;i<7;i++){
			FUNC_BUTTON_TASK_WORK *twk;
			wk->FuncButtonTask[i] = PMDS_taskAdd(FuncButtonTaskFunc, 16, 5, HEAPID_NAMEIN);
			twk         = TCB_GetWork(wk->FuncButtonTask[i]);
			twk->parent = wk->clActWork[FUNCBUTTON_FRAME_ACTNO];
			twk->child  = wk->clActWork[i];
			twk->dx     = FX32_ONE*main_button_info[i][0];
			twk->id     = i;
		}

		//O͌ʃA_[C
		for(i=0;i<wk->inputmax;i++){
			add.mat.x = FX32_ONE*(NAMELINE_POS_X+i*12);
			add.mat.y = FX32_ONE*NAMELINE_POS_Y;
			wk->NameLineActWork[i] = CLACT_Add(&add);
			CLACT_SetAnmFlag(wk->NameLineActWork[i],1);
			CLACT_AnmChg( wk->NameLineActWork[i], 43 );
		}
		// Pڂ̃A_[C㉺ɓ
		InputResultUnderLineMove(wk->NameLineActWork, wk->nowinput, wk->inputmax);


		// ͐pACRi@AʁAp\RA|PȂǁj
		add.mat.x = FX32_ONE*(NAMEIN_MYICON_X);
		add.mat.y = FX32_ONE*NAMEIN_MYICON_Y;
		switch(wk->inputmode){
		case NAMEIN_MYNAME:
			wk->NameIconActWork[0] = CLACT_Add(&add);
			CLACT_SetAnmFlag(wk->NameIconActWork[0],1);
			if(wk->inputinfo==PM_MALE){
				CLACT_AnmChg( wk->NameIconActWork[0], 48 );	//j
			}else{
				CLACT_AnmChg( wk->NameIconActWork[0], 49 );	//j
			}
			break;
		case NAMEIN_BOX:
			wk->NameIconActWork[0] = CLACT_Add(&add);
			CLACT_SetAnmFlag(wk->NameIconActWork[0],1);
			CLACT_AnmChg( wk->NameIconActWork[0], 47 );
			break;
		case NAMEIN_POKEMON:
			// |PACR
			wk->NameIconActWork[0] = CLACT_Add(&add);
			CLACT_SetAnmFlag(wk->NameIconActWork[0],1);
			CLACT_AnmChg( wk->NameIconActWork[0], 50 );

			// ʃACR
			add.mat.x = FX32_ONE*(NAMELINE_POS_X + wk->inputmax * 13);
			add.mat.y = FX32_ONE*NAMEIN_SEXICON_Y;
			wk->NameIconActWork[1] = CLACT_Add(&add);
			CLACT_AnmChg( wk->NameIconActWork[1], 45 );	// 
//			CLACT_AnmChg( wk->NameIconActWork[1], 45 + wk->inputinfo );	// 
			break;
		}

		// ʗp
		for(i=0;i<2;i++){
			add.ClActHeader	= &wk->clActHeader_s;
			add.mat.x = FX32_ONE*sub_button_info[i][0];
			add.mat.y = FX32_ONE*(sub_button_info[i][1]) + NAMEIN_SUB_ACTOR_DISTANCE;
			add.DrawArea	= NNS_G2D_VRAM_TYPE_2DSUB;
			wk->clActWork[10+i] = CLACT_Add(&add);
			CLACT_SetAnmFlag(wk->clActWork[10+i],1);
			CLACT_AnmChg( wk->clActWork[10+i], sub_button_info[i][2] );
		}
		
	}	
	GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);	//OBJʂnm
	GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);	//OBJʂnm
	
}

typedef struct{
	CLACT_WORK_PTR	frame;
	int				seq;
	int				dx;
	int				dy;
}QUAKE_FRAME_TASK_WORK;

static void QuakeFrameTaskFunc( TCB_PTR tcb, void *work )
{
	QUAKE_FRAME_TASK_WORK *wk = (QUAKE_FRAME_TASK_WORK *)work;
	VecFx32 tmp;
	tmp.y = wk->dy;
	tmp.z = 0;


	switch(wk->seq){
	case 0:
		tmp.x = wk->dx + 4*FX32_ONE;
		CLACT_SetMatrix(wk->frame, &tmp);
		
		break;
	case 2:
		tmp.x = wk->dx - 3*FX32_ONE;
		CLACT_SetMatrix(wk->frame, &tmp);
		break;
	case 4:
		tmp.x = wk->dx + 2*FX32_ONE;
		CLACT_SetMatrix(wk->frame, &tmp);
		break;
	case 6:
		tmp.x = wk->dx;
		CLACT_SetMatrix(wk->frame, &tmp);
		PMDS_taskDel(tcb);
		break;
	}
	wk->seq++;
}

//------------------------------------------------------------------
/**
 * plNGXgւ
 *
 * @param   seq			Jڏ
 * @param   mode		̓[hiȁEJiE`abELj
 * @param   front		OɗĂafʂۑĂ郏[N
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void PanelFunc(GF_BGL_INI *bgl,GF_BGL_BMPWIN *win, int *seq, int mode, int *frontBG, VecFx32 panelpos[], CLACT_WORK_PTR *clActWork,void *dakuten)
{
	int front = *frontBG;
	int back  = front^1;
	int i;
	switch(*seq){

	case NAMEIN_MODE_REQ:
		{
			u16 bgcol = wordpanel_bg_col[mode]|(wordpanel_bg_col[mode]<<4);
			// VĂ镶plʂ]
			ArcUtil_ScrnSet( ARC_NAMEIN_GRA, NARC_namein_name_screen1_lz_NSCR+mode, bgl, GF_BGL_FRAME0_M+front, 0, WORDPANEL_TRANS_SIZE, 1, HEAPID_NAMEIN);
			SetPanelFirstPos(panelpos, front);

			WordPanelSetUp(&win[front],bgcol, mode, GF_PRINTCOLOR_MAKE(0xe,0xc,wordpanel_bg_col[mode]),dakuten);

			(*seq)++;
		}
		break;
    	
	case NAMEIN_MODE_SET:
		// QBGʂ̏WZbg
		GF_BGL_ScrollSet( bgl, GF_BGL_FRAME0_M+front, GF_BGL_SCROLL_X_SET, HIDDENPANEL_POS_REGX );
		GF_BGL_ScrollSet( bgl, GF_BGL_FRAME0_M+front, GF_BGL_SCROLL_Y_SET, WORDPANEL_POS_REGY   );
		(*seq)++;
		break;
    	
	case NAMEIN_MODE_ANIM:
		// BGʂړB
		// ʒu܂łXgbviVpl̓t[hj
		
		
		panelpos[front].x-=WORDPANEL_IN_SPEED;
		if(panelpos[front].x < WORDPANEL_POS_REGX+10){		// t[h炷
			QUAKE_FRAME_TASK_WORK *qtfw;
			TCB_PTR qt;
			
//			CLACT_AnmChg( clActWork[7], main_button_info[7][2]+1 );
			qt          = PMDS_taskAdd(QuakeFrameTaskFunc, 16, 0, HEAPID_NAMEIN);
			qtfw        = TCB_GetWork(qt);
			qtfw->frame = clActWork[7];
			qtfw->seq   = 0;
			qtfw->dx    = CLACT_GetMatrix(clActWork[7])->x;
			qtfw->dy    = CLACT_GetMatrix(clActWork[7])->y;

			panelpos[front].x=WORDPANEL_POS_REGX;
			(*seq)++;
		}
		// ʒu܂ŗXgbv
		panelpos[back].y-=WORDPANEL_OUT_SPEED;
		if(panelpos[back].y < DOWNPANEL_POS_REGY){
			panelpos[back].y=DOWNPANEL_POS_REGY;
		}


		GF_BGL_ScrollSet( bgl, GF_BGL_FRAME0_M+front, GF_BGL_SCROLL_X_SET, panelpos[front].x );
		GF_BGL_ScrollSet( bgl, GF_BGL_FRAME0_M+back,  GF_BGL_SCROLL_Y_SET, panelpos[back].y );

		break;
    	
    case NAMEIN_MODE_ANIM_WAIT:
		// ʒu܂ŗXgbv
		panelpos[back].y-=WORDPANEL_OUT_SPEED;
		if(panelpos[back].y < DOWNPANEL_POS_REGY){
			panelpos[back].y=DOWNPANEL_POS_REGY;
		}


		GF_BGL_ScrollSet( bgl, GF_BGL_FRAME0_M+front, GF_BGL_SCROLL_X_SET, panelpos[front].x );
		GF_BGL_ScrollSet( bgl, GF_BGL_FRAME0_M+back,  GF_BGL_SCROLL_Y_SET, panelpos[back].y );
		// BGʂړIV[PXI
		if(panelpos[front].x==WORDPANEL_POS_REGX && panelpos[back].y==DOWNPANEL_POS_REGY){
			(*seq)++;
			(*frontBG) ^=1;			//afʂ̏㉺ւ
			FrontBackBG_RegSet(bgl, *frontBG, panelpos);
			Snd_SePlay( SEQ_SE_DP_NAMEIN_01 );
		}
    	break;
	case NAMEIN_MODE:
		break;
    	

	}
}

//------------------------------------------------------------------
/**
 * u`̂Ȃ܂́Hv`悷
 *
 * @param   bmp			`pBMPWIN\
 * @param   inputmode	̓[hiMYNAME,POKEMON,BOX)
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void PrintTitleInfoStr(GF_BGL_BMPWIN *bmp, int inputmode, STRBUF *Title)
{
	GF_BGL_BmpWinDataFill( bmp, 0x0101 );

	GF_STR_PrintColor(	bmp, FONT_SYSTEM, Title, 0, 0, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(0xe,0xf,1),NULL);

	GF_BGL_BmpWinOn( bmp );

}

//------------------------------------------------------------------
/**
 * BMPWINiplɃtHg`j
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void BmpMessageSet(NAMEIN_WORK *wk, PROC* proc)
{
	// BG0ʗpipl1pjBMPEChEm
	GF_BGL_BmpWinAdd(wk->bgl, &wk->NameInWin[BMP_WORDPANEL_BG0], GF_BGL_FRAME0_M,
						WORDPANEL_WIN_POSX, WORDPANEL_WIN_POSY, WORDPANEL_WIN_W, WORDPANEL_WIN_H, 1,  WORDPANEL0_WIN_OFFSET);

	// BG1ʗpipl2pjBMPEChEm
	GF_BGL_BmpWinAdd(wk->bgl, &wk->NameInWin[BMP_WORDPANEL_BG1], GF_BGL_FRAME1_M,
						WORDPANEL_WIN_POSX, WORDPANEL_WIN_POSY, WORDPANEL_WIN_W, WORDPANEL_WIN_H, 1,  WORDPANEL1_WIN_OFFSET);

	//ŏɌĂʂȂ̂ŕpl`Ɠ]s
	WordPanelSetUp( &wk->NameInWin[BMP_WORDPANEL_BG1],0x0404, 0, GF_PRINTCOLOR_MAKE(0xe,0xc,wordpanel_bg_col[0]),wk->BgCharaDat->pRawData);

	// ʏ㕔bZ[WpBMPWINm
	GF_BGL_BmpWinAdd(wk->bgl, &wk->NameInWin[BMP_TITLE_MES], GF_BGL_FRAME2_M,
						NAME_INFO_POSX, NAME_INFO_POSY, NAME_INFO_POSW, NAME_INFO_POSH, 0,  NAMEINFO_WIN_OFFSET);

	// u`̂Ȃ܂́Hv\
	PrintTitleInfoStr(&wk->NameInWin[BMP_TITLE_MES], wk->inputmode, wk->TitleStr);


	// O\pBMPWINm
	GF_BGL_BmpWinAdd(wk->bgl, &wk->NameInWin[BMP_RESULT_NAME], GF_BGL_FRAME2_M,
						NAME_RESULT_POSX, NAME_RESULT_POSY, NAME_RESULT_POSW, NAME_RESULT_POSH, 0,  NAMERESULT_WIN_OFFSET);
	GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_RESULT_NAME], 0x0101 );


	// NAMEIN_PARAMɃftHg񂪓Ă甽f
	{
		NAMEIN_PARAM* param = (NAMEIN_PARAM*)PROC_GetParentWork(proc);

		if(wk->paramstr[0]!= EOM_)
		{
			PM_strcpy(wk->inputword,wk->paramstr);
			NameinWordPanelPrint(&wk->NameInWin[BMP_RESULT_NAME], wk->inputword, 0,0, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(0xe,0xf,1),NULL);		
		}
	}
	
	// ʃ{^pBMPm
	{
		int i;
		for(i=0;i<3;i++){
			GF_BGL_BmpWinAdd(wk->bgl, &wk->NameInWin[BMP_SUB_BUTTON1+i], GF_BGL_FRAME2_M,	0, 0, 2, 2, 0,  SUB_BUTTON_WORD_OFFSET);
			GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_SUB_BUTTON1+i], 0 );
		}
		GF_BGL_BmpWinAdd(wk->bgl, &wk->NameInWin[BMP_SUB_STRING], GF_BGL_FRAME2_M,	0, 0, 16, 2, 0,  SUB_BUTTON_STRING_OFFSET);
		GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_SUB_STRING], 0 );


	}
}	

//------------------------------------------------------------------
/**
 * Bg0ʂBG1ʂ̃vCIeBRRς̂Ŋ֐
 *
 * @param   front	ǂ̖ʂɗ邩(0 or 1)
 *
 * @retval  none	
 */
//------------------------------------------------------------------
static void FrontBackBG_RegSet(GF_BGL_INI *bgl, int front, VecFx32 panelpos[])
{
	GF_BGL_PrioritySet( GF_BGL_FRAME0_M+front, 0 );
	GF_BGL_PrioritySet( GF_BGL_FRAME0_M+front^1, 1 );

}

//------------------------------------------------------------------
/**
 * pl̏Wۑ
 *
 * @param   panelpos[]		pl̈ʒu
 * @param   front				BG0ʂBG1ʂ̂ǂ炪ォ(0BG0)
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SetPanelFirstPos(VecFx32 panelpos[], int front)
{
	panelpos[front].x   = HIDDENPANEL_POS_REGX;
    panelpos[front].y   = WORDPANEL_POS_REGY;
    panelpos[front^1].x = WORDPANEL_POS_REGX;
    panelpos[front^1].y = WORDPANEL_POS_REGY;
	
}

#ifdef PM_DEBUG
//------------------------------------------------------------------
/**
 * fobO\pOBJBG𓮂
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void DebugOBJPOSGet(NAMEIN_WORK *wk)
{
		if( sys.cont & PAD_KEY_UP){
			VecFx32 tmpVex;
			wk->framenum[wk->frame][1]--;
			tmpVex.x = FX32_ONE*wk->framenum[wk->frame][0];
			tmpVex.y = FX32_ONE*wk->framenum[wk->frame][1];
			CLACT_SetMatrix(wk->clActWork[wk->frame], &tmpVex);
			OS_Printf("frame %d x=%d, y=%d\n",wk->frame, wk->framenum[wk->frame][0],wk->framenum[wk->frame][1]);
		}
		if( sys.cont & PAD_KEY_DOWN){
			VecFx32 tmpVex;
			wk->framenum[wk->frame][1]++;
			tmpVex.x = FX32_ONE*wk->framenum[wk->frame][0];
			tmpVex.y = FX32_ONE*wk->framenum[wk->frame][1];
			CLACT_SetMatrix(wk->clActWork[wk->frame], &tmpVex);
			OS_Printf("frame %d x=%d, y=%d\n",wk->frame, wk->framenum[wk->frame][0],wk->framenum[wk->frame][1]);
			
		}
		if( sys.cont & PAD_KEY_LEFT){
			VecFx32 tmpVex;
			wk->framenum[wk->frame][0]--;
			tmpVex.x = FX32_ONE*wk->framenum[wk->frame][0];
			tmpVex.y = FX32_ONE*wk->framenum[wk->frame][1];
			CLACT_SetMatrix(wk->clActWork[wk->frame], &tmpVex);
			OS_Printf("frame %d x=%d, y=%d\n",wk->frame, wk->framenum[wk->frame][0],wk->framenum[wk->frame][1]);
			
		}
		if( sys.cont & PAD_KEY_RIGHT){
			VecFx32 tmpVex;
			wk->framenum[wk->frame][0]++;
			tmpVex.x = FX32_ONE*wk->framenum[wk->frame][0];
			tmpVex.y = FX32_ONE*wk->framenum[wk->frame][1];
			CLACT_SetMatrix(wk->clActWork[wk->frame], &tmpVex);
			OS_Printf("frame %d x=%d, y=%d\n",wk->frame, wk->framenum[wk->frame][0],wk->framenum[wk->frame][1]);
		}

}

#endif



#define MOVE_UP 	1
#define MOVE_DOWN 	2
#define MOVE_LEFT 	3
#define MOVE_RIGHT 	4

static const arrowtbl[][2]={{0,0},{0,-1},{0,1},{-1,0},{1,0}};

static int AroundWork(int w, int min, int max)
{
	if(w>=max){
		w = min;
	}
	if(w<min){
		w = max-1;
	}
	return w;
}

//------------------------------------------------------------------
/**
 * J[\ړ
 *
 * @param   wk		NAMEIN_WORK*
 * @param   arrow	ړtO
 *
 * @retval  none	
 */
//------------------------------------------------------------------
static void CursorMove(NAMEIN_WORK *wk, int arrow)
{
	int x,y;
	u16 old;
	
	if(arrow==0){
		return;
	}
	
	// cSKIP̗񂾂ƁA[vɓ̂ŗvCiƂȂ̗Ȃǁj
	old  = wk->wordmap[wk->Cursor.y][wk->Cursor.x];
	x    = AroundWork((wk->Cursor.x + arrowtbl[arrow][0]), 0, INPUT_WORD_W);
	y    = AroundWork((wk->Cursor.y + arrowtbl[arrow][1]), 0, INPUT_WORD_H);

	// Ẍړi@\{^EXLbv񏈗݁j
	while(wk->wordmap[y][x]==SKIP_ || (wk->wordmap[y][x]==old && wk->wordmap[y][x]>NAMEIN_BUTTON)){
		if(wk->Cursor.oldy==0 && wk->wordmap[y][x]==SKIP_ && arrowtbl[arrow][1]!=0){	// {^̏ɂāA̍sSKIP
			x += wk->Cursor.lastxarrow;													// ꍇ̏iŌ̉ړ
			x = AroundWork(x, 0, INPUT_WORD_W);											// ƂĂĂ̕ɂ炷j
		}else{
			x += arrowtbl[arrow][0];													// ړ悪SKIP_ꍇ
			x = AroundWork(x, 0, INPUT_WORD_W);											// SKIP_ȂȂ܂ňړJԂ
			y += arrowtbl[arrow][1];
			y = AroundWork(y, 0, INPUT_WORD_H);
		}
	}
	
	// ŏIړi[
	wk->Cursor.x = x;	
	wk->Cursor.y = y;
}

//------------------------------------------------------------------
/**
 * J[\ړ
 *
 * @param   wk		NAMEIN_WORK*
 *
 * @retval  none	
 */
//------------------------------------------------------------------
static void ControlCursor(NAMEIN_WORK *wk)
{
	int move  = 0;
	int arrow = 0;

	// L[͂ɑ΂ĈړŜ̈
	if( sys.repeat & PAD_KEY_UP){
		Snd_SePlay(NAMEIN_SE_MOVE);
		arrow = MOVE_UP;
		move++;
	}
	if( sys.repeat & PAD_KEY_DOWN){
		Snd_SePlay(NAMEIN_SE_MOVE);
		arrow = MOVE_DOWN;
		move++;
	}
	if( sys.repeat & PAD_KEY_LEFT){
		Snd_SePlay(NAMEIN_SE_MOVE);
		arrow = MOVE_LEFT;
		move++;
	}
	if( sys.repeat & PAD_KEY_RIGHT){
		Snd_SePlay(NAMEIN_SE_MOVE);
		arrow = MOVE_RIGHT;
		move++;
	}
	
	// I{^ʒu
	if( sys.trg & PAD_BUTTON_START){
		Snd_SePlay(NAMEIN_SE_MOVE);
		wk->Cursor.x = 14;
		wk->Cursor.y = 0;
		move++;
	}

	// ړύX
	if(move){
		CursorMove(wk,arrow);				// J[\̈ړ肷
		CursorAppearUpDate(wk,arrow);		// ړ̌ʃJ[\̌`󂪂ǂ̂悤ɕς邩肷
	}

}


//------------------------------------------------------------------
/**
 * ړ̌ʃJ[\̌`󂪂ǂ̂悤ɕς邩肷
 * ̏ł΁A`̃J[\A{^̏łΒ`̃J[\
 * ̍XVs邱ƂŁATuʂ̒̃tHg̍XVs
 *
 * @param   wk			NAMEIN_WORK*
 * @param   arrow		ړ
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void CursorAppearUpDate(NAMEIN_WORK *wk, int arrow)
{
	// J[\̗ɂ邩H
	if(wk->Cursor.y!=0){
		VecFx32 tmpVex;

		// ̗ɂ
		if(wk->Cursor.oldy==0 && wk->Cursor.oldy != wk->Cursor.y){		// OɃt@NV{^̏ɂ
			CLACT_AnmChg( wk->clActWork[8], NAMEIN_CURSOR_ANM_START );	// ʏJ[\ɃAN^[ύX
		}
		tmpVex.x = FX32_ONE*(MAIN_CURSOR_POSX+wk->Cursor.x*12);
		tmpVex.y = FX32_ONE*(MAIN_CURSOR_POSY+(wk->Cursor.y-1)*16);
		CLACT_SetMatrix(wk->clActWork[CLACT_CURSOR_NUM], &tmpVex);
	}else{
		VecFx32 tmpVex;

		// {^̗ɂ
		int func_type = wk->wordmap[wk->Cursor.y][wk->Cursor.x]-NAMEIN_HIRA;
		tmpVex.x = FX32_ONE*func_button_pos_tbl[func_type];
		tmpVex.y = FX32_ONE*FUNC_BUTTON_POS_Y;
		CLACT_AnmChg( wk->clActWork[8], func_button_appear[func_type] );// {^ɑΉJ[\ɕύX
		CLACT_SetMatrix(wk->clActWork[CLACT_CURSOR_NUM], &tmpVex);
	}
	wk->CursorPal = 180;							// ړJ[\̃pbg͐ԂԂɖ߂
	CLACT_AnmFrameSet( wk->clActWork[8], 0 );		// ړJ[\̃Aj͍ŏ̃t[ɖ߂


	wk->Cursor.oldx       = wk->Cursor.x;
	wk->Cursor.oldy       = wk->Cursor.y;
	if(arrowtbl[arrow][0]!=0){
		wk->Cursor.lastxarrow = arrowtbl[arrow][0];
	}

}

//------------------------------------------------------------------
/**
 * Aj[Vɂ킹ĉʂ̃{^BG̃XN[
 *
 * @param   mode		
 * @param   work		
 * @param   bgl		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SubButtonBGFunc(int *mode, int *work, GF_BGL_INI *bgl)
{

	switch(*work){
	case 1:	case 5:
	// BG0XN[]
		ArcUtil_ScrnSet(   ARC_NAMEIN_GRA, NARC_namein_name_bg_s2_lz_NSCR, bgl, GF_BGL_FRAME0_S, 0, 32*24*2, 1, HEAPID_NAMEIN);
		break;
	case 3:	
	// BG0XN[]
		ArcUtil_ScrnSet(   ARC_NAMEIN_GRA, NARC_namein_name_bg_s3_lz_NSCR, bgl, GF_BGL_FRAME0_S, 0, 32*24*2, 1, HEAPID_NAMEIN);
		break;
	case 7:	
	// BG0XN[]
		ArcUtil_ScrnSet(   ARC_NAMEIN_GRA, NARC_namein_name_bg_s_lz_NSCR, bgl, GF_BGL_FRAME0_S, 0, 32*24*2, 1, HEAPID_NAMEIN);
		break;
	}


	// uvuv̍ۂɂworkグ
	if(mode!=0){		// 
		if(*work > 9 ){	// 6ȏɂ͂ȂȂ悤
			*work = 0;
			*mode  = 0;
		}
		*work += *mode;
	}
//	OS_Printf("mode = %d, work = %d\n",mode, *work);
}

//------------------------------------------------------------------
/**
 * ^b`plŉ{^ւ
 *
 * @param   wk		NAMEIN_WORK̃|C^
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void TouchFunc(NAMEIN_WORK *wk)
{
	int button=-1,i;

	// ͏
	button=GF_TP_RectHitTrg( sub_button_hittbl );
	if(button != RECT_HIT_NONE && wk->subtouchword[button] != spc_){
//		DecideMainButton(wk,wk->subtouchword[button]);
		DecideMainButton(wk,NAMEIN_KOMOJI);				// ϊ{^ON
		CLACT_AnmChg( wk->clActWork[10], sub_button_info[0][2] );	// ʂ̕BGɍ킹ď㉺ɓ
		CLACT_AnmChg( wk->clActWork[11], sub_button_info[1][2]+1 );	// ʂ̕BGɍ킹ď㉺ɓ
		wk->subbutton_mode=1;
	}

	// ڂ̏
//	button=GF_TP_RectHitCont( sub_button_hittbl );

	SubButtonBGFunc(&wk->subbutton_mode, &wk->subbutton_work, wk->bgl);

}


//------------------------------------------------------------------
/**
 * J[\̃pbgύXi_Łj
 *
 * @param   CursorCol	sinɓnp[^i360܂Łj
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void CursorColTrans(u16 *CursorCol)
{
	fx32  sin;
	GXRgb tmp;
	int   r,g,b;

	*CursorCol+=20;
	if(*CursorCol>360){
		*CursorCol = 0;
	}

	sin = Sin360R(*CursorCol);
	g   = 15 +( sin * 10 ) / FX32_ONE;
	tmp = GX_RGB(29,g,0);


	GX_LoadOBJPltt((u16*)&tmp, (16+13)*2, 2);
}

#define WORDPANEL_WORD_SPACE (12)

//------------------------------------------------------------------
/**
 * plɋϓȊԊuɕzu
 * v|[VitHgȂ̂ŉmFȂꕶzu
 *
 * uhvuKvu[s]vɑΉ(CODEDAKUTEN_,HANDAKUTEN_,SPACE_j
 * 12hbgzu鎖ɂB
 *
 * @param   win		bmp
 * @param   str		
 * @param   x		JnXij
 * @param   y		JnYij
 * @param   sw		MSG_ALLPUTMSG_NO_PUT
 * @param   color	5bitx3̃J[w
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void NameinWordPanelPrint(GF_BGL_BMPWIN *win, const u16 *str, int x,int y, int sw, GF_PRINTCOLOR color, u8 *dakuten_Character)
{
	int i=0,w,dx;
	u16 word[2];
	STRBUF *strbuf_word;
	
	strbuf_word = STRBUF_Create( 2, HEAPID_NAMEIN );
	// ꕶo
	while(str[i]!=EOM_){
		// ꕶꍇ̏
		if(str[i]==DAKU_ || str[i]==HANDAKU_ || str[i]==SPACE_){
			u16 tmp = str[i] - NAMEIN_CODE;


			//12x12̓ꕶ`
			GF_BGL_BmpWinPrint(	win, (void*)&dakuten_Character[tmp*8*8*4/2],
				0, 0, 12, 12,
				x+i*WORDPANEL_WORD_SPACE, y+2, 12, 12 );

		}else{
		// ʏ핶

			if(str[i]==SKIP_){		//XLbvL͕`悵Ȃ
				i++;
				continue;
			}
			word[0] = str[i];
			word[1] = EOM_;

			//tHg̉擾A12hbgzuƂ̍Zoĕ`
			w=FontProc_GetStrWidth( FONT_SYSTEM, word, 0 );
			dx = x+i*WORDPANEL_WORD_SPACE+((WORDPANEL_WORD_SPACE-w)/2);
			STRBUF_SetStringCode( strbuf_word, word );
			GF_STR_PrintColor(	win, FONT_SYSTEM, strbuf_word, dx, y, sw, color,NULL);

		}
		i++;
	}	
	STRBUF_Delete( strbuf_word );
}


static const u8 StringCharacterOffsetTable[]={
	96,104,80,88
};


static void *GF_STR_PrintCGXOnly(GF_BGL_BMPWIN * win, STRBUF *msg, u8 fnt_index,const   GF_PRINTCOLOR col)
{

	GF_STR_PrintColor(	win, fnt_index, msg, 0, 0, MSG_NO_PUT, col,NULL);

	return win->chrbuf;
}

//------------------------------------------------------------------
/**
 * ʂ̃{^ɏĂ镶LN^[]
 *
 * @param   win		WJBMPWIN\̂̃|C^
 * @param   tbl		u͂΂ρvȂǂ̕ϊe[ũ|C^BNULL
 * @param   code	ῗ̖ɓBtblƂ0
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void ChangeSubPanelButtonWord(GF_BGL_BMPWIN *win, const u16 *tbl, u8 *TransWork, STRBUF *ChangeWordStr)
{
	u16  word[SUB_BUTTON_STRING_MAX+1],i,n;
	void *objcharaadr;
	STRBUF *strbuf_word;

	GF_BGL_BmpWinDataFill( &win[3], 0 );
	
	// uv`
	objcharaadr=GF_STR_PrintCGXOnly(&win[3], ChangeWordStr, FONT_BUTTON, GF_PRINTCOLOR_MAKE(0xd,0x0e,0xf));

	// BMPŕ`悵obt@OBJɓ]Ĕf
	DC_FlushRange(objcharaadr,0x20*4*16);	
	for(i=0;i<4;i++){						
		FONTOAM_BmpCutOamSize( &win[3], 4, 2, 4*i, 0,  (char*)TransWork);
		DC_FlushRange(TransWork,0x20*4*2);	
		GXS_LoadOBJ(TransWork, StringCharacterOffsetTable[i]*0x20, 0x20*4*2);
	}


	// STRBUF쐬
	strbuf_word = STRBUF_Create(SUB_BUTTON_STRING_MAX+1, HEAPID_NAMEIN);
	
	// BMPWINŕLN^쐬AOBJVRAMɓ]鏈RJԂ
	for(i=0;i<3;i++){
		word[0] = tbl[i];
		word[1] = EOM_;
		GF_BGL_BmpWinDataFill( &win[i], 0 );

		// STRBUFɕϊABMPŃLN^[`
		STRBUF_SetStringCode( strbuf_word, word );
		objcharaadr=GF_STR_PrintCGXOnly(&win[i], strbuf_word, FONT_BUTTON, GF_PRINTCOLOR_MAKE(0xd,0x0e,0xf));

		// BMPŕ`悵obt@OBJɓ]Ĕf
		DC_FlushRange(objcharaadr,0x20*4);	
		GXS_LoadOBJ(objcharaadr, obj_word_offset[i]*0x20, 0x20*4);

	}

	STRBUF_Delete(strbuf_word);
}

//------------------------------------------------------------------
/**
 * J[\ړɁAʃ{^̒̕
 *
 * @param   win		GF_BGL_BMPWIN*
 * @param   code	R[h
 * @param   words	NAMEIN_WORK.subtouchword
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SubPanelButton_CharaChange(GF_BGL_BMPWIN *win, u16 code, u16 *words, u8 *TransWork, STRBUF *ChangeWordStr)
{
	int i,r;
	const u16 *tbl = NULL;

	// ꕶE{^̃R[h͑Sċ󔒕Ƃĕ\
	switch(code){
	case DAKU_			:	case HANDAKU_		:	case SPACE_			:	case SKIP_			:
	case NAMEIN_HIRA	:	case NAMEIN_KANA	:	case NAMEIN_ALPHA	:	case NAMEIN_KIGOU	:
	case NAMEIN_KOMOJI	:	case NAMEIN_MODORU	:	case NAMEIN_OWARI	:
		code = spc_;
	break;
	}
	
	for(i=0;i<3;i++){		// U
		words[i] = spc_;
	}
	words[0] = code;		// R[h
	
	// ϊe[uđEET
	for(i=0;i<sizeof(convert_tbl)/(3*2);i++){
		// ϊO̕
		if(convert_tbl[i][0]==code){
			for(r=0;r<3;r++){
				words[r] =  convert_tbl[i][r];	// e[uRs[
			}
			break;
		}
		// ϊ̏iړ͂ł悤ɂȂ̂Łj
		if(convert_tbl[i][2]==code){
			for(r=0;r<3;r++){
				words[r] =  convert_tbl[i][r];	// e[uRs[
			}
			break;
		}
	}

	// WINBMPŏAOBJVRAMɓ]
	ChangeSubPanelButtonWord(win, words, TransWork, ChangeWordStr);
}



//------------------------------------------------------------------
/**
 * ݓ͕pl}bv쐬
 *
 * @param   map[][INPUT_WORD_W]		ޕ}bv[N
 * @param   no						plԍ(0-3)
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void MakeWordMap(u16 map[][INPUT_WORD_W], const int no)
{
	int i,j;
	
	//ʍŏĩ{^zuݒ
	for(i=0;i<INPUT_WORD_W;i++){
		map[0][i] = str_func_b[no][i];
	}
	
	for(j=0;j<INPUT_WORD_H-1;j++){
		for(i=0;i<INPUT_WORD_W;i++){
			map[1+j][i] = str_nametbl[no][j][i];
		}
	}
}

//------------------------------------------------------------------
/**
 * ͌
 *
 * @param   wk		NAMEIN_WORK*
 * @param   code	R[h({^Eꕶ܂)
 *
 * @retval  int		ʏSEQ_MAINBISEQ_OUT
 */
//------------------------------------------------------------------
static int DecideMainButton(NAMEIN_WORK *wk,u16 code)
{
	// ꕶE{^̃R[h͑Sċ󔒕Ƃĕ\
	if(code==SPACE_ || code == SKIP_){
		code = spc_;
	}

	switch(code){
	//  
	case DAKU_			:	
		if(ConvertWord(DAKU_WORD_START,DAKU_WORD_NUM,1,DAKU_,wk->inputword,wk->nowinput)){
			GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_RESULT_NAME], 0x0101 );
			NameinWordPanelPrint(&wk->NameInWin[BMP_RESULT_NAME], wk->inputword, 0,0, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(0xe,0xf,1),NULL);
			Snd_SePlay(NAMEIN_SE_DECIDE);
		}
		break;
	// 
	case HANDAKU_		:	
		if(ConvertWord(HANDAKU_WORD_START,HANDAKU_WORD_NUM,2,HANDAKU_,wk->inputword,wk->nowinput)){
			GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_RESULT_NAME], 0x0101 );
			NameinWordPanelPrint(&wk->NameInWin[BMP_RESULT_NAME], wk->inputword, 0,0, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(0xe,0xf,1),NULL);
			Snd_SePlay(NAMEIN_SE_DECIDE);
		}
		break;
	// 
	case NAMEIN_KOMOJI	:
		if(RotateConvertWord(BIGSMALL_WORD_START,HANDAKU_WORD_NUM,wk->inputword,wk->nowinput)){
			GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_RESULT_NAME], 0x0101 );
			NameinWordPanelPrint(&wk->NameInWin[BMP_RESULT_NAME], wk->inputword, 0,0, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(0xe,0xf,1),NULL);
			wk->funcbutton[4]++;
			Snd_SePlay(NAMEIN_SE_DECIDE);
		}
		break;

	// pl؂ւ{^
	case NAMEIN_HIRA	:	case NAMEIN_KANA	:	case NAMEIN_ALPHA	:	case NAMEIN_KIGOU	:
		// pl؂ւ
		if(wk->mode!=code-NAMEIN_HIRA){
			wk->seq  = NAMEIN_MODE_REQ;
			wk->mode = code-NAMEIN_HIRA;
			MakeWordMap(wk->wordmap, wk->mode);		// ̓}bvւ
			wk->funcbutton[code-NAMEIN_HIRA]++;
			Snd_SePlay( NAMEIN_SE_CHANGEPANEL );
		}
		break;

	// 1߂
	case NAMEIN_MODORU	:
		if(wk->nowinput!=0){
			wk->inputword[wk->nowinput-1] = EOM_;
			wk->nowinput--;
			GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_RESULT_NAME], 0x0101 );
			if(wk->nowinput==0){
				// 0ƕvgȂ̂
				GF_BGL_BmpWinOn( &wk->NameInWin[BMP_RESULT_NAME] );
			}else{
				NameinWordPanelPrint(&wk->NameInWin[BMP_RESULT_NAME], wk->inputword, 0,0, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(0xe,0xf,1),NULL);
			}
			SubPanelButton_CharaChange(&wk->NameInWin[BMP_SUB_BUTTON1],
										wk->inputword[wk->nowinput-1],
										wk->subtouchword,
										wk->ObjTransWork,
										wk->ChangeWordStr);
			InputResultUnderLineMove(wk->NameLineActWork,wk->nowinput, wk->inputmax);
			wk->funcbutton[5]++;
			Snd_SePlay(NAMEIN_SE_BS);
		}
		break;
	// O͏I
	case NAMEIN_OWARI	:		
		Snd_SePlay( NAMEIN_SE_END );
		wk->funcbutton[6]++;
		WIPE_Start(WIPE_PATTERN_FSAM, WIPE_TYPE_FADEOUT, WIPE_TYPE_FADEOUT, WIPE_FADE_BLACK, 
				16, 1, HEAPID_NAMEIN, &wk->wipe_end);
		wk->wipe_end = 0;
		return SEQ_OUT;
	break;

	// ʏ̕
	default:
		if(wk->nowinput!=wk->inputmax){				//Max܂ōsĂȂ
			wk->inputword[wk->nowinput] = code;
			GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_RESULT_NAME], 0x0101 );
			NameinWordPanelPrint(&wk->NameInWin[BMP_RESULT_NAME], wk->inputword, 0,0, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(0xe,0xf,1),NULL);
			wk->nowinput++;
			InputResultUnderLineMove(wk->NameLineActWork,wk->nowinput, wk->inputmax);
			Snd_SePlay(NAMEIN_SE_DECIDE);
			if(wk->nowinput==wk->inputmax){			// ̓}bNX܂łuIv{^
				wk->Cursor.x = 14;
				wk->Cursor.y = 0;
				CursorAppearUpDate(wk,0);		// ړ̌ʃJ[\̌`󂪂ǂ̂悤ɕς邩肷
			
			}
			SubPanelButton_CharaChange(&wk->NameInWin[BMP_SUB_BUTTON1],
										wk->inputword[wk->nowinput-1],
										wk->subtouchword,
										wk->ObjTransWork,
										wk->ChangeWordStr);


		}
	}	
	
	return SEQ_MAIN;
}

//------------------------------------------------------------------
/**
 * E_E_łe[uɏւԂ
 * uvȂuvAúvȂu΁ρ́v
 * @param   tbl		
 * @param   pos		
 *
 * @retval  u16		
 */
//------------------------------------------------------------------
static u16 GetConvertWord(const u16 *tbl, int pos)
{

	do{
		pos = AroundWork(++pos,0,3);
//		OS_Printf("pos = %d, code = %d",pos,tbl[pos]);
	}while(tbl[pos]==spc_);
	
//	OS_Printf("last --- pos = %d, code = %d",pos,tbl[pos]);
	return tbl[pos];
}

//------------------------------------------------------------------
/**
 * uv{^
 *
 * @param   start	convert_tblJnʒu
 * @param   num		convert_tblIʒu
 * @param   str		obt@
 * @param   pos		݂̃J[\
 *
 * @retval  int		0Ȃ玸s	1Ȃ琬istr͏Ă)
 */
//------------------------------------------------------------------
static int RotateConvertWord(int start, int num, u16 *str, int pos)
{
	int i,r;
	u16 code,w;
	if(pos==0){
		return 0;
	}

	code = str[pos-1];

	for(i=start;i<num;i++){
		for(r=0;r<3;r++){
			if(convert_tbl[i][r]==code && code!=spc_){
				str[pos-1] = GetConvertWord(convert_tbl[i],r);
				return 1;
			}
		}
	}
	return 0;
}

//------------------------------------------------------------------
/**
 * ͍ςݕϊ
 *
 * @param   start	convert_tbľJnʒu
 * @param   num		convert_tbľIʒu
 * @param   target	convert_tbl̂OڂƔr̂͂PԖڂQԖڂi1or2)
 * @param   flag	DAKU_,HANDAKU_,NAMEIN_KOMOJÎǂꂩ
 * @param   str		͍ςݕ
 * @param   pos		ݓ͑҂̏ꏊ
 *
 * @retval  int		0=ϊ	1=ϊ
 */
//------------------------------------------------------------------
static int ConvertWord(int start, int num, int target, int flag, u16 *str, int pos)
{
	int i;
	u16 code;

	// 1͂ĂȂꍇ͕ϊ͔Ȃ
	if(pos==0){
		return 0;
	}	

	// ̕ϊ
	code=str[pos-1];
	for(i=start;i<num;i++){
		if(convert_tbl[i][0]==code){
			str[pos-1]=convert_tbl[i][target];
			return 1;
		}
	}

	// ϊς݂̕ɖ߂
	for(i=start;i<num;i++){
		if(convert_tbl[i][target]==code){
			str[pos-1]=convert_tbl[i][0];
			return 1;
		}
	}

	//ꏈu΁ρvuÁvȂ

	switch(flag){
	case DAKU_:
		for(i=0;i<sizeof(extra_daku_tbl)/2*2;i++){
			if(extra_daku_tbl[i][0]==code){
				str[pos-1] = extra_daku_tbl[i][1];
				return 1;
			}
		}
		break;
	case HANDAKU_:
		for(i=0;i<sizeof(extra_handaku_tbl)/2*2;i++){
			if(extra_handaku_tbl[i][0]==code){
				str[pos-1] = extra_handaku_tbl[i][1];
				return 1;
			}
		}
		break;
	case NAMEIN_KOMOJI:
		if(code==du_){
			str[pos-1] = ttu_;
			return 1;
		}
		if(code==DU_){
			str[pos-1] = TTU_;
			return 1;
		}
		break;
	}	

	// ϊł͂Ȃ
	return 0;
}


//------------------------------------------------------------------
/**
 * ͍ςݕ̉̃A_[C𓮂ws
 *
 * @param   lineact		A_[C̃ZAN^[̃|C^
 * @param   pos			ʒu
 * @param   max			ő吔
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void InputResultUnderLineMove(CLACT_WORK_PTR *lineact,int pos, int max)
{
	int i;
	for(i=0;i<max;i++){
		CLACT_AnmChg( lineact[i], 43 );		// SăA_[CȂԂɃNA
	}
	if(pos!=max){
		CLACT_AnmChg( lineact[pos], 44 );	// w̕㉺ɓ
	}
}


#define PLATE_CHARA_OFFSET1	( 12 )
#define PLATE_CHARA_OFFSET2	( 16 )
#define PLATE_H_CHARASIZE	(  8 )	// plBMPݕLc

static const u8 plate_num[4]={2,2,3,2};
static const u8 plate_table[4][3]={
	{8*8,17*8,0,},
	{8*8,17*8,0,},
	{5*8,12*8,18*8,},
	{8*8,17*8,0,},

};
static const u8 plate_chara_no[][5]={
	{PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,},
	{PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,},
	{PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,},
	{PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,},
};

//------------------------------------------------------------------
/**
 * pl̕zuEg`Ȃǂs
 *
 * @param   win			GF_BGL_WINBMP*
 * @param   bgchara		pl̔wiL
 * @param   frame		O`R̕plԍ
 * @param   color		GF_PRINTCOLOR
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void WordPanelSetUp(GF_BGL_BMPWIN *win,u16 bgchara, int frame, GF_PRINTCOLOR color, u8* dakuten_Character )
{
	int i,r,h;

	// ꂼ̕pl̔wiFŃNA
	GF_BGL_BmpWinDataFill( win, bgchara );

	// pl̎d؂`
	for(r=0;r<plate_num[frame];r++){
		for(i=0;i<PLATE_H_CHARASIZE;i++){
			GF_BGL_BmpWinPrint(	win, (void*)&dakuten_Character[(plate_chara_no[frame][r]+frame)*8*8/2],
				0, 0, 8, 8,
				plate_table[frame][r], 8*i, 8, 8 );
		}
	}

	// `
	for(i=0;i<4;i++){
		NameinWordPanelPrint(win,str_nametbl[frame][i],0,i*16,MSG_NO_PUT,color,dakuten_Character);
	}
	// ]
	GF_BGL_BmpWinOn( win );

}

//------------------------------------------------------------------
/**
 * @\{^iȁEJiEABCE^^ǂ邨j̃Aj
 *
 * @param   funcbutton[]	{^ԃtO
 * @param   ButtonAct		CLACT_WORK_PTR
 * @param   frame			݂̕plԍ
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void FuncButtonAnimation(int funcbutton[], CLACT_WORK_PTR *ButtonAct, int frame)
{
	int i,r;
	//  Ji ABC  {^
	for(i=0;i<4;i++){
		if(funcbutton[i]){
			for(r=0;r<4;r++){
				CLACT_AnmChg( ButtonAct[r], main_button_info[r][2] );
			}
			CLACT_AnmChg( ButtonAct[i], main_button_info[i][2]-3 );
			break;
		}
	}

	// {^i Ji ABCɂăZAjႤj
//	if(funcbutton[4]){
//		CLACT_AnmChg( ButtonAct[4], main_button_info[4][2] + frame);	// uLv̏{^݂͑Ȃ
//	}

	// ǂ {^
	for(i=5;i<7;i++){
		if(funcbutton[i]){
			CLACT_AnmChg( ButtonAct[i], main_button_info[i][2]+1);
		}
	}
	
	// AjfꂽNA
	for(i=0;i<7;i++){
		funcbutton[i] = 0;
	}

}



