//============================================================================================
/**
 * @file	nuts_tag.c
 * @bfief	؂̎^Oʏ
 * @author	Hiroyuki Nakamura
 * @date	06.01.25
 */
//============================================================================================
#include "common.h"
#include "system/procsys.h"
#include "system/brightness.h"
#include "system/fontproc.h"
#include "system/msgdata.h"
#include "system/wordset.h"
#include "system/numfont.h"
#include "system/arc_util.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_kinomi_tag.h"
#include "itemtool/itemsym.h"
#include "itemtool/nuts.h"
#include "application/app_tool.h"

#define	NUTS_TAG_H_GLOBAL
#include "application/nuts_tag.h"
#include "ntag_gra.naix"


//============================================================================================
//	萔`
//============================================================================================
#define	NUTS_TAG_MAX		( 63 )					// ^OiOIWj

enum {
	WIN_NUTS_TITLE = 0,		// û݃^Ov
	WIN_NUTS_NAME,			// ؂̎
	WIN_KARAI,				// F炢
	WIN_SIBUI,				// FԂ
	WIN_AMAI,				// F܂
	WIN_NIGAI,				// Fɂ
	WIN_SUPPAI,				// Fς
	WIN_SIZE,				// uv
	WIN_SIZE_NUM,			// 傫l
	WIN_HARD,				// uv
	WIN_HARD_NUM,			// dl
	WIN_INFO,				// 
	WIN_MAX
};

struct _NTAG_DATA {
	u32	tag_flg[2];	// \ł^O
	u32 now_tag;	// ݂̃^Oԍ
};

typedef struct {
	VecFx16	lt;		// 
	VecFx16	rt;		// E
	VecFx16	lu;		// 
	VecFx16	ru;		// E
}NTAG_CONDISION_VTX;

typedef struct {
	GF_BGL_INI * bgl;						// BGLf[^

	GF_BGL_BMPWIN	win[WIN_MAX];			// BMPEBhEf[^iʏj

	MSGDATA_MANAGER * mman;		// bZ[Wf[^}l[W
	WORDSET * wset;				// PZbg
	NUMFONT * nfnt;				// 8x8tHg

	GF_CAMERA_PTR	camera;		// J

	NTAG_CONDISION_VTX	cvtx[4];	// \W
	NTAG_CONDISION_VTX	pvtx[4];	// vXl
	NTAG_CONDISION_VTX	mvtx[4];	// ől
	u32	con_mv_cnt;

	NTAG_DATA * dat;

	NUTSDATA * nuts;

	BOOL	wipe_flg;

	u8	blend_flg;
	u8	blend_cnt;

}NTAG_WORK;

enum {
	SEQ_IN = 0,
	SEQ_MAIN,
	SEQ_CHANGE,
	SEQ_OUT
};

// pbg`
#define	NTAG_TITLE_PAL		( 2 )		// û݃^Ovpbg
#define	NTAG_NUTS_PAL		( 3 )		// ؂̎OtBbNpbg
#define	NTAG_SYSFONT_PAL	( 15 )		// VXetHgpbg

#define	TITLE_BACK_COL		( 4 )		// û݃^Ov̔wiJ[
// tHgJ[
#define	PCOL_TITLE	(GF_PRINTCOLOR_MAKE(1,2,TITLE_BACK_COL))	// tHgJ[Fû݃^Ovp
#define	PCOL_N_BLACK	( GF_PRINTCOLOR_MAKE( 1, 2, 0 ) )		// tHgJ[F
#define	PCOL_N_WHITE	( GF_PRINTCOLOR_MAKE( 15, 2, 0 ) )		// tHgJ[F
#define	PCOL_N_BLUE		( GF_PRINTCOLOR_MAKE( 7, 8, 0 ) )		// tHgJ[F
#define	PCOL_N_RED		( GF_PRINTCOLOR_MAKE( 3, 4, 0 ) )		// tHgJ[F

#define	HEADER_STR_FRM		( GF_BGL_FRAME3_M )

// BMP֘A
// ؂̎̊GiۂBMPł͂Ȃj
#define	NUTS_GRA_FRM		( GF_BGL_FRAME1_M )
#define	NUTS_GRA_PX			( 2 )
#define	NUTS_GRA_PY			( 5 )
#define	NUTS_GRA_SX			( 8 )
#define	NUTS_GRA_SY			( 8 )
#define	NUTS_GRA_PAL		( NTAG_NUTS_PAL )
#define	NUTS_GRA_CGX		( 1 )
// û݃^Ov
#define	BMP_NUTS_TITLE_FRM	( GF_BGL_FRAME3_M )
#define	BMP_NUTS_TITLE_PX	( 1 )
#define	BMP_NUTS_TITLE_PY	( 0 )
#define	BMP_NUTS_TITLE_SX	( 12 )
#define	BMP_NUTS_TITLE_SY	( 2 )
#define	BMP_NUTS_TITLE_PAL	( NTAG_TITLE_PAL )
#define	BMP_NUTS_TITLE_CGX	( 1024 - BMP_NUTS_TITLE_SX * BMP_NUTS_TITLE_SY )
// ؂̎
#define	BMP_NUTS_NAME_FRM	( GF_BGL_FRAME1_M )
#define	BMP_NUTS_NAME_PX	( 1 )
#define	BMP_NUTS_NAME_PY	( 3 )
#define	BMP_NUTS_NAME_SX	( 10 )
#define	BMP_NUTS_NAME_SY	( 2 )
#define	BMP_NUTS_NAME_PAL	( NTAG_SYSFONT_PAL )
#define	BMP_NUTS_NAME_CGX	( NUTS_GRA_CGX + NUTS_GRA_SX * NUTS_GRA_SY )
// 傫l
#define	BMP_SIZ_NUM_FRM	( GF_BGL_FRAME1_M )
#define	BMP_SIZ_NUM_PX	( 8 )
#define	BMP_SIZ_NUM_PY	( 13 )
#define	BMP_SIZ_NUM_SX	( 6 )
#define	BMP_SIZ_NUM_SY	( 2 )
#define	BMP_SIZ_NUM_PAL	( NTAG_SYSFONT_PAL )
#define	BMP_SIZ_NUM_CGX	( BMP_NUTS_NAME_CGX + BMP_NUTS_NAME_SX * BMP_NUTS_NAME_SY )
// dl
#define	BMP_HARD_NUM_FRM	( GF_BGL_FRAME1_M )
#define	BMP_HARD_NUM_PX		( 8 )
#define	BMP_HARD_NUM_PY		( 15 )
#define	BMP_HARD_NUM_SX		( 15 )
#define	BMP_HARD_NUM_SY		( 2 )
#define	BMP_HARD_NUM_PAL	( NTAG_SYSFONT_PAL )
#define	BMP_HARD_NUM_CGX	( BMP_SIZ_NUM_CGX + BMP_SIZ_NUM_SX * BMP_SIZ_NUM_SY )
// 
#define	BMP_INFO_FRM	( GF_BGL_FRAME1_M )
#define	BMP_INFO_PX		( 2 )
#define	BMP_INFO_PY		( 17 )
#define	BMP_INFO_SX		( 28 )
#define	BMP_INFO_SY		( 6 )
#define	BMP_INFO_PAL	( NTAG_SYSFONT_PAL )
#define	BMP_INFO_CGX	( BMP_HARD_NUM_CGX + BMP_HARD_NUM_SX * BMP_HARD_NUM_SY )

// F炢
#define	BMP_KARAI_FRM	( HEADER_STR_FRM )
#define	BMP_KARAI_PX	( 20 )
#define	BMP_KARAI_PY	( 1 )
#define	BMP_KARAI_SX	( 5 )
#define	BMP_KARAI_SY	( 2 )
#define	BMP_KARAI_PAL	( NTAG_SYSFONT_PAL )
#define	BMP_KARAI_CGX	( 512 )
// FԂ
#define	BMP_SIBUI_FRM	( HEADER_STR_FRM )
#define	BMP_SIBUI_PX	( 27 )
#define	BMP_SIBUI_PY	( 6 )
#define	BMP_SIBUI_SX	( 5 )
#define	BMP_SIBUI_SY	( 2 )
#define	BMP_SIBUI_PAL	( NTAG_SYSFONT_PAL )
#define	BMP_SIBUI_CGX	( BMP_KARAI_CGX + BMP_KARAI_SX * BMP_KARAI_SY )
// F܂
#define	BMP_AMAI_FRM	( HEADER_STR_FRM )
#define	BMP_AMAI_PX		( 24 )
#define	BMP_AMAI_PY		( 12 )
#define	BMP_AMAI_SX		( 5 )
#define	BMP_AMAI_SY		( 2 )
#define	BMP_AMAI_PAL	( NTAG_SYSFONT_PAL )
#define	BMP_AMAI_CGX	( BMP_SIBUI_CGX + BMP_SIBUI_SX * BMP_SIBUI_SY )
// Fɂ
#define	BMP_NIGAI_FRM	( HEADER_STR_FRM )
#define	BMP_NIGAI_PX	( 16 )
#define	BMP_NIGAI_PY	( 12 )
#define	BMP_NIGAI_SX	( 5 )
#define	BMP_NIGAI_SY	( 2 )
#define	BMP_NIGAI_PAL	( NTAG_SYSFONT_PAL )
#define	BMP_NIGAI_CGX	( BMP_AMAI_CGX + BMP_AMAI_SX * BMP_AMAI_SY )
// Fς
#define	BMP_SUPPAI_FRM	( HEADER_STR_FRM )
#define	BMP_SUPPAI_PX	( 12 )
#define	BMP_SUPPAI_PY	( 6 )
#define	BMP_SUPPAI_SX	( 6 )
#define	BMP_SUPPAI_SY	( 2 )
#define	BMP_SUPPAI_PAL	( NTAG_SYSFONT_PAL )
#define	BMP_SUPPAI_CGX	( BMP_NIGAI_CGX + BMP_NIGAI_SX * BMP_NIGAI_SY )
// uv
#define	BMP_SIZE_FRM	( HEADER_STR_FRM )
#define	BMP_SIZE_PX		( 2 )
#define	BMP_SIZE_PY		( 13 )
#define	BMP_SIZE_SX		( 6 )
#define	BMP_SIZE_SY		( 2 )
#define	BMP_SIZE_PAL	( NTAG_SYSFONT_PAL )
#define	BMP_SIZE_CGX	( BMP_SUPPAI_CGX + BMP_SUPPAI_SX * BMP_SUPPAI_SY )
// uv
#define	BMP_HARD_FRM	( HEADER_STR_FRM )
#define	BMP_HARD_PX		( 2 )
#define	BMP_HARD_PY		( 15 )
#define	BMP_HARD_SX		( 6 )
#define	BMP_HARD_SY		( 2 )
#define	BMP_HARD_PAL	( NTAG_SYSFONT_PAL )
#define	BMP_HARD_CGX	( BMP_SIZE_CGX + BMP_SIZE_SX * BMP_SIZE_SY )


#define	BMP_PUT_SEQ_MAX	( 8 )	// BMP\V[PXől

#define	NUTS_NAME_PX	( 40 )	// ؂̎\Xʒu
#define	NAME_NO_PY		( 5 )	// uNo.v\Yʒu
#define	HARD_PX			( 0 )	// dl\Xʒu
#define	SIZE_PX			( 0 )	// 傫l\Xʒu


/*
	RfBVijQ[W͂S̎lp|Sŕ\ĂB
	lp|S̕т
			Q@P
			R@S
	ƂȂĂB
	_̂hc͍PƂĎvB
*/

// Q[WP
// _̍őW
#define	COND_P1_X1_MAX	( 1670 )
#define	COND_P1_Y1_MAX	( 2960 )
#define	COND_P1_X2_MAX	( 2800 )
#define	COND_P1_Y2_MAX	( 1850 )
#define	COND_P1_X3_MAX	( 2360 )
#define	COND_P1_Y3_MAX	( 140 )
#define	COND_P1_X4_MAX	( 1670 )
#define	COND_P1_Y4_MAX	( 1460 )
// _̍ŏW
#define	COND_P1_X1_MIN	( COND_P1_X1_MAX )
#define	COND_P1_Y1_MIN	( COND_P1_Y4_MAX+(COND_P1_Y1_MAX-COND_P1_Y4_MAX)/8 )
#define	COND_P1_X2_MIN	( COND_P1_X4_MAX+(COND_P1_X2_MAX-COND_P1_X4_MAX)/8 )
#define	COND_P1_Y2_MIN	( COND_P1_Y4_MAX+(COND_P1_Y2_MAX-COND_P1_Y4_MAX)/8 )
#define	COND_P1_X3_MIN	( COND_P1_X4_MAX+(COND_P1_X3_MAX-COND_P1_X4_MAX)/8 )
#define	COND_P1_Y3_MIN	( COND_P1_Y4_MAX+(COND_P1_Y3_MAX-COND_P1_Y4_MAX)/8 )
#define	COND_P1_X4_MIN	( COND_P1_X4_MAX )
#define	COND_P1_Y4_MIN	( COND_P1_Y4_MAX )

// Q[WQ
// _̍őW
#define	COND_P2_X1_MAX	( 550 )
#define	COND_P2_Y1_MAX	( 1850 )
#define	COND_P2_X2_MAX	( 1670 )
#define	COND_P2_Y2_MAX	( 2960 )
#define	COND_P2_X3_MAX	( 1670 )
#define	COND_P2_Y3_MAX	( 1460 )
#define	COND_P2_X4_MAX	( 1000 )
#define	COND_P2_Y4_MAX	( 140 )
// _̍ŏW
#define	COND_P2_X1_MIN	( COND_P2_X3_MAX+(COND_P2_X1_MAX-COND_P2_X3_MAX)/8 )
#define	COND_P2_Y1_MIN	( COND_P2_Y3_MAX+(COND_P2_Y1_MAX-COND_P2_Y3_MAX)/8 )
#define	COND_P2_X2_MIN	( COND_P2_X2_MAX )
#define	COND_P2_Y2_MIN	( COND_P2_Y3_MAX+(COND_P2_Y2_MAX-COND_P2_Y3_MAX)/8 )
#define	COND_P2_X3_MIN	( COND_P2_X3_MAX )
#define	COND_P2_Y3_MIN	( COND_P2_Y3_MAX )
#define	COND_P2_X4_MIN	( COND_P2_X3_MAX+(COND_P2_X4_MAX-COND_P2_X3_MAX)/8 )
#define	COND_P2_Y4_MIN	( COND_P2_Y3_MAX+(COND_P2_Y4_MAX-COND_P2_Y3_MAX)/8 )

// Q[WR
// _̍őW
#define	COND_P3_X1_MAX	( COND_P2_X1_MAX )
#define	COND_P3_Y1_MAX	( COND_P2_Y1_MAX )
#define	COND_P3_X2_MAX	( COND_P2_X3_MAX )
#define	COND_P3_Y2_MAX	( COND_P2_Y3_MAX )
#define	COND_P3_X3_MAX	( COND_P1_X3_MAX )
#define	COND_P3_Y3_MAX	( COND_P1_Y3_MAX )
#define	COND_P3_X4_MAX	( COND_P2_X4_MAX )
#define	COND_P3_Y4_MAX	( COND_P2_Y4_MAX )
// _̍ŏW
#define	COND_P3_X1_MIN	( COND_P3_X2_MAX+(COND_P3_X1_MAX-COND_P3_X2_MAX)/8 )
#define	COND_P3_Y1_MIN	( COND_P3_Y2_MAX+(COND_P3_Y1_MAX-COND_P3_Y2_MAX)/8 )
#define	COND_P3_X2_MIN	( COND_P3_X2_MAX )
#define	COND_P3_Y2_MIN	( COND_P3_Y2_MAX )
#define	COND_P3_X3_MIN	( COND_P3_X2_MAX+(COND_P3_X3_MAX-COND_P3_X2_MAX)/8 )
#define	COND_P3_Y3_MIN	( COND_P3_Y2_MAX+(COND_P3_Y3_MAX-COND_P3_Y2_MAX)/8 )
#define	COND_P3_X4_MIN	( COND_P3_X2_MAX+(COND_P3_X4_MAX-COND_P3_X2_MAX)/8 )
#define	COND_P3_Y4_MIN	( COND_P3_Y2_MAX+(COND_P3_Y4_MAX-COND_P3_Y2_MAX)/8 )

// Q[WS
// _̍őW
#define	COND_P4_X1_MAX	( COND_P1_X4_MAX )
#define	COND_P4_Y1_MAX	( COND_P1_Y4_MAX )
#define	COND_P4_X2_MAX	( COND_P1_X2_MAX )
#define	COND_P4_Y2_MAX	( COND_P1_Y2_MAX )
#define	COND_P4_X3_MAX	( COND_P1_X3_MAX )
#define	COND_P4_Y3_MAX	( COND_P1_Y3_MAX )
#define	COND_P4_X4_MAX	( COND_P2_X4_MAX )
#define	COND_P4_Y4_MAX	( COND_P2_Y4_MAX )
// _̍ŏW
#define	COND_P4_X1_MIN	( COND_P4_X1_MAX )
#define	COND_P4_Y1_MIN	( COND_P4_Y1_MAX )
#define	COND_P4_X2_MIN	( COND_P4_X1_MAX+(COND_P4_X2_MAX-COND_P4_X1_MAX)/8 )
#define	COND_P4_Y2_MIN	( COND_P4_Y1_MAX+(COND_P4_Y2_MAX-COND_P4_Y1_MAX)/8 )
#define	COND_P4_X3_MIN	( COND_P4_X1_MAX+(COND_P4_X3_MAX-COND_P4_X1_MAX)/8 )
#define	COND_P4_Y3_MIN	( COND_P4_Y1_MAX+(COND_P4_Y3_MAX-COND_P4_Y1_MAX)/8 )
#define	COND_P4_X4_MIN	( COND_P4_X1_MAX+(COND_P4_X4_MAX-COND_P4_X1_MAX)/8 )
#define	COND_P4_Y4_MIN	( COND_P4_Y1_MAX+(COND_P4_Y4_MAX-COND_P4_Y1_MAX)/8 )

#define	COND_PRM_MAX	( 50 )	// p[^ől

// Pp[^̃TCYvZ}N
#define	PRM_SIZ(max,min)	( FX_F32_TO_FX16( FX_FX16_TO_F32(max-min)/COND_PRM_MAX ) )

// \WvZpp[^
typedef struct {
	VecFx16	max;	// őW
	VecFx16	min;	// ŏW
	VecFx16	siz;	// P̃TCY
}CONDITION_VTX_CALC;


//============================================================================================
//	vg^Cv錾
//============================================================================================
static void TagPutFlagSet( u32 * flg, u16 id );
static u8 TagPutFlagGet( u32 * flg, u16 id );

static PROC_RESULT NutsTagProc_Init( PROC * proc, int * seq );
static PROC_RESULT NutsTagProc_Main( PROC * proc, int * seq );
static PROC_RESULT NutsTagProc_End( PROC * proc, int * seq );

static void NutsTagVBlank( void * work );

static void NutsTagVramBankSet(void);
static void NutsTagBgSet( GF_BGL_INI * ini );
static void NutsTagBgExit( GF_BGL_INI * ini );
static void NutsTagBgGraphicSet( NTAG_WORK * wk );
static void NutsTagMsgManCreate( NTAG_WORK * wk );
static void NutsTagMsgManDelete( NTAG_WORK * wk );
static void NutsTagBmpWinSet( NTAG_WORK * wk );
static void NutsTagBmpWinExit( GF_BGL_BMPWIN * win );
static void NutsGraphicSet( NTAG_WORK * wk );
static void NTAG_BmpPut( NTAG_WORK * wk, u8 seq );
static void NTAG_BmpPutAll( NTAG_WORK * wk );

static int SeqInFunc( NTAG_WORK * wk );
static int SeqMainFunc( NTAG_WORK * wk );
static int SeqChangeFunc( NTAG_WORK * wk );
static u8 SeqOutFunc( NTAG_WORK * wk );

static u32 NextTagGet( u32 * tbl, u32 now, s32 mv );
static void TagChange( NTAG_WORK * wk );

static void NTAG_3DInit(void);
static void NTAG_3DMain( NTAG_WORK * wk );
static void NTAG_3DRelease( NTAG_WORK * wk );
static void NTAG_CameraInit( NTAG_WORK * wk );
static void NTAG_ConditionParamInit( NTAG_WORK * wk );
static void NTAG_ConditionParamMake( NTAG_WORK * wk );
static void NTAG_ConditionPlus( NTAG_WORK * wk );
static void ConditionGagePut( NTAG_CONDISION_VTX * vtx );
static void ConditionParamPlus( VecFx16 * p, VecFx16 * m );
static void ConditionMoveMake( VecFx16 * now, VecFx16 * max, VecFx16 * move );
static void ConditionMaxMake( const CONDITION_VTX_CALC * cnst, VecFx16 * make, u8 prm );


//============================================================================================
//	O[oϐ
//============================================================================================
// vZX`f[^
const PROC_DATA NutsTagProcData = {
	NutsTagProc_Init,
	NutsTagProc_Main,
	NutsTagProc_End,
	NO_OVERLAY_ID,
};

// BMPf[^
static const BMPWIN_DAT NutsTagBmpData[] =
{
	{	// û݃^Ov
		BMP_NUTS_TITLE_FRM, BMP_NUTS_TITLE_PX, BMP_NUTS_TITLE_PY,
		BMP_NUTS_TITLE_SX, BMP_NUTS_TITLE_SY, BMP_NUTS_TITLE_PAL, BMP_NUTS_TITLE_CGX
	},
	{	// ؂̎
		BMP_NUTS_NAME_FRM, BMP_NUTS_NAME_PX, BMP_NUTS_NAME_PY,
		BMP_NUTS_NAME_SX, BMP_NUTS_NAME_SY, BMP_NUTS_NAME_PAL, BMP_NUTS_NAME_CGX
	},
	{	// F炢
		BMP_KARAI_FRM, BMP_KARAI_PX, BMP_KARAI_PY,
		BMP_KARAI_SX, BMP_KARAI_SY, BMP_KARAI_PAL, BMP_KARAI_CGX
	},
	{	// FԂ
		BMP_SIBUI_FRM, BMP_SIBUI_PX, BMP_SIBUI_PY,
		BMP_SIBUI_SX, BMP_SIBUI_SY, BMP_SIBUI_PAL, BMP_SIBUI_CGX
	},
	{	// F܂
		BMP_AMAI_FRM, BMP_AMAI_PX, BMP_AMAI_PY,
		BMP_AMAI_SX, BMP_AMAI_SY, BMP_AMAI_PAL, BMP_AMAI_CGX
	},
	{	// Fɂ
		BMP_NIGAI_FRM, BMP_NIGAI_PX, BMP_NIGAI_PY,
		BMP_NIGAI_SX, BMP_NIGAI_SY, BMP_NIGAI_PAL, BMP_NIGAI_CGX
	},
	{	// Fς
		BMP_SUPPAI_FRM, BMP_SUPPAI_PX, BMP_SUPPAI_PY,
		BMP_SUPPAI_SX, BMP_SUPPAI_SY, BMP_SUPPAI_PAL, BMP_SUPPAI_CGX
	},
	{	// uv
		BMP_SIZE_FRM, BMP_SIZE_PX, BMP_SIZE_PY,
		BMP_SIZE_SX, BMP_SIZE_SY, BMP_SIZE_PAL, BMP_SIZE_CGX
	},
	{	// 傫l
		BMP_SIZ_NUM_FRM, BMP_SIZ_NUM_PX, BMP_SIZ_NUM_PY,
		BMP_SIZ_NUM_SX, BMP_SIZ_NUM_SY, BMP_SIZ_NUM_PAL, BMP_SIZ_NUM_CGX
	},
	{	// uv
		BMP_HARD_FRM, BMP_HARD_PX, BMP_HARD_PY,
		BMP_HARD_SX, BMP_HARD_SY, BMP_HARD_PAL, BMP_HARD_CGX
	},
	{	// dl
		BMP_HARD_NUM_FRM, BMP_HARD_NUM_PX, BMP_HARD_NUM_PY,
		BMP_HARD_NUM_SX, BMP_HARD_NUM_SY, BMP_HARD_NUM_PAL, BMP_HARD_NUM_CGX
	},
	{	// 
		BMP_INFO_FRM, BMP_INFO_PX, BMP_INFO_PY,
		BMP_INFO_SX, BMP_INFO_SY, BMP_INFO_PAL, BMP_INFO_CGX
	}
};

// RfBVijQ[Wf[^
static const CONDITION_VTX_CALC	ConPrm[][4] =
{
	{	// Q[WP
		{	// 
			{ COND_P1_X1_MAX, COND_P1_Y1_MAX, 0 },
			{ COND_P1_X1_MIN, COND_P1_Y1_MIN, 0 },
			{ PRM_SIZ(COND_P1_X1_MAX,COND_P1_X1_MIN),PRM_SIZ(COND_P1_Y1_MAX,COND_P1_Y1_MIN),0 }
		},
		{	// E
			{ COND_P1_X2_MAX, COND_P1_Y2_MAX, 0 },
			{ COND_P1_X2_MIN, COND_P1_Y2_MIN, 0 },
			{ PRM_SIZ(COND_P1_X2_MAX,COND_P1_X2_MIN),PRM_SIZ(COND_P1_Y2_MAX,COND_P1_Y2_MIN),0 }
		},
		{	// E
			{ COND_P1_X3_MAX, COND_P1_Y3_MAX, 0 },
			{ COND_P1_X3_MIN, COND_P1_Y3_MIN, 0 },
			{ PRM_SIZ(COND_P1_X3_MAX,COND_P1_X3_MIN),PRM_SIZ(COND_P1_Y3_MAX,COND_P1_Y3_MIN),0 }
		},
		{	// 
			{ COND_P1_X4_MAX, COND_P1_Y4_MAX, 0 },
			{ COND_P1_X4_MIN, COND_P1_Y4_MIN, 0 },
			{ PRM_SIZ(COND_P1_X4_MAX,COND_P1_X4_MIN),PRM_SIZ(COND_P1_Y4_MAX,COND_P1_Y4_MIN),0 }
		}
	},
	{	// Q[WQ
		{	// 
			{ COND_P2_X1_MAX, COND_P2_Y1_MAX, 0 },
			{ COND_P2_X1_MIN, COND_P2_Y1_MIN, 0 },
			{ PRM_SIZ(COND_P2_X1_MAX,COND_P2_X1_MIN),PRM_SIZ(COND_P2_Y1_MAX,COND_P2_Y1_MIN),0 }
		},
		{	// E
			{ COND_P2_X2_MAX, COND_P2_Y2_MAX, 0 },
			{ COND_P2_X2_MIN, COND_P2_Y2_MIN, 0 },
			{ PRM_SIZ(COND_P2_X2_MAX,COND_P2_X2_MIN),PRM_SIZ(COND_P2_Y2_MAX,COND_P2_Y2_MIN),0 }
		},
		{	// E
			{ COND_P2_X3_MAX, COND_P2_Y3_MAX, 0 },
			{ COND_P2_X3_MIN, COND_P2_Y3_MIN, 0 },
			{ PRM_SIZ(COND_P2_X3_MAX,COND_P2_X3_MIN),PRM_SIZ(COND_P2_Y3_MAX,COND_P2_Y3_MIN),0 }
		},
		{	// 
			{ COND_P2_X4_MAX, COND_P2_Y4_MAX, 0 },
			{ COND_P2_X4_MIN, COND_P2_Y4_MIN, 0 },
			{ PRM_SIZ(COND_P2_X4_MAX,COND_P2_X4_MIN),PRM_SIZ(COND_P2_Y4_MAX,COND_P2_Y4_MIN),0 }
		}
	},
	{	// Q[WR
		{	// 
			{ COND_P3_X1_MAX, COND_P3_Y1_MAX, 0 },
			{ COND_P3_X1_MIN, COND_P3_Y1_MIN, 0 },
			{ PRM_SIZ(COND_P3_X1_MAX,COND_P3_X1_MIN),PRM_SIZ(COND_P3_Y1_MAX,COND_P3_Y1_MIN),0 }
		},
		{	// E
			{ COND_P3_X2_MAX, COND_P3_Y2_MAX, 0 },
			{ COND_P3_X2_MIN, COND_P3_Y2_MIN, 0 },
			{ PRM_SIZ(COND_P3_X2_MAX,COND_P3_X2_MIN),PRM_SIZ(COND_P3_Y2_MAX,COND_P3_Y2_MIN),0 }
		},
		{	// E
			{ COND_P3_X3_MAX, COND_P3_Y3_MAX, 0 },
			{ COND_P3_X3_MIN, COND_P3_Y3_MIN, 0 },
			{ PRM_SIZ(COND_P3_X3_MAX,COND_P3_X3_MIN),PRM_SIZ(COND_P3_Y3_MAX,COND_P3_Y3_MIN),0 }
		},
		{	// 
			{ COND_P3_X4_MAX, COND_P3_Y4_MAX, 0 },
			{ COND_P3_X4_MIN, COND_P3_Y4_MIN, 0 },
			{ PRM_SIZ(COND_P3_X4_MAX,COND_P3_X4_MIN),PRM_SIZ(COND_P3_Y4_MAX,COND_P3_Y4_MIN),0 }
		}
	},
	{	// Q[WS
		{	// 
			{ COND_P4_X1_MAX, COND_P4_Y1_MAX, 0 },
			{ COND_P4_X1_MIN, COND_P4_Y1_MIN, 0 },
			{ PRM_SIZ(COND_P4_X1_MAX,COND_P4_X1_MIN),PRM_SIZ(COND_P4_Y1_MAX,COND_P4_Y1_MIN),0 }
		},
		{	// E
			{ COND_P4_X2_MAX, COND_P4_Y2_MAX, 0 },
			{ COND_P4_X2_MIN, COND_P4_Y2_MIN, 0 },
			{ PRM_SIZ(COND_P4_X2_MAX,COND_P4_X2_MIN),PRM_SIZ(COND_P4_Y2_MAX,COND_P4_Y2_MIN),0 }
		},
		{	// E
			{ COND_P4_X3_MAX, COND_P4_Y3_MAX, 0 },
			{ COND_P4_X3_MIN, COND_P4_Y3_MIN, 0 },
			{ PRM_SIZ(COND_P4_X3_MAX,COND_P4_X3_MIN),PRM_SIZ(COND_P4_Y3_MAX,COND_P4_Y3_MIN),0 }
		},
		{	// 
			{ COND_P4_X4_MAX, COND_P4_Y4_MAX, 0 },
			{ COND_P4_X4_MIN, COND_P4_Y4_MIN, 0 },
			{ PRM_SIZ(COND_P4_X4_MAX,COND_P4_X4_MIN),PRM_SIZ(COND_P4_Y4_MAX,COND_P4_Y4_MIN),0 }
		}
	}
};


//============================================================================================
//	f[^ݒ
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ؂̎^Oʂ̃f[^̈m
 *
 * @param	heap	q[vhc
 *
 * @return	mۂ̈̃AhX
 */
//--------------------------------------------------------------------------------------------
NTAG_DATA * NutsTagSystemDataAlloc( u8 heap )
{
	NTAG_DATA * wk = (NTAG_DATA *)sys_AllocMemory( heap, sizeof(NTAG_DATA) );
	memset( wk, 0, sizeof(NTAG_DATA) );
	return wk;
}

u32 NutsTagSystemDataSizeGet(void)
{
	return sizeof(NTAG_DATA);
}

//--------------------------------------------------------------------------------------------
/**
 * ؂̎^Oʂ̕\^Oݒ
 *
 * @param	dat		f[^ݒꏊ
 * @param	item	ACeԍ
 * @param	flg		^OݒtO
 *
 * @return	none
 *
 * @li	flg = TAG_ON : ŏɕ\^Oɐݒ
 */
//--------------------------------------------------------------------------------------------
void NutsTagPutDataSet( NTAG_DATA * dat, u16 item, u16 flg )
{
	u16	num = item - NUTS_START_ITEMNUM;

	TagPutFlagSet( dat->tag_flg, num );
	if( flg == TAG_ON ){
		dat->now_tag = num;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * \\^OZbg
 *
 * @param	flg		tOݒꏊ
 * @param	id		^OID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void TagPutFlagSet( u32 * flg, u16 id )
{
	flg[id/32] |= (1<<(id%32));
}

//--------------------------------------------------------------------------------------------
/**
 * \\^O`FbN
 *
 * @param	flg		tOݒꏊ
 * @param	id		^OID
 *
 * @retval	"TRUE = "
 * @retval	"FALSE = s"
 */
//--------------------------------------------------------------------------------------------
static u8 TagPutFlagGet( u32 * flg, u16 id )
{
	if( ( flg[id/32] & (1<<(id%32)) ) != 0 ){
		return TRUE;
	}
	return FALSE;
}


//============================================================================================
//	vZX֐
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * vZX֐F
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT NutsTagProc_Init( PROC * proc, int * seq )
{
	NTAG_WORK * wk;

	sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
	sys_HBlankIntrStop();				// HBlank~

	GF_Disp_GX_VisibleControlInit();
	GF_Disp_GXS_VisibleControlInit();
	GX_SetVisiblePlane( 0 );
	GXS_SetVisiblePlane( 0 );

	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_NUTSTAG, 0x20000 );

	wk = PROC_AllocWork( proc, sizeof(NTAG_WORK), HEAPID_NUTSTAG );
	memset( wk, 0, sizeof(NTAG_WORK) );
	wk->dat  = PROC_GetParentWork( proc );
	wk->bgl  = GF_BGL_BglIniAlloc( HEAPID_NUTSTAG );
	wk->nuts = Nuts_DataLoad( wk->dat->now_tag, HEAPID_NUTSTAG );

	APP_WipeStart( APP_WIPE_IN, HEAPID_NUTSTAG, &wk->wipe_flg );

	NutsTagVramBankSet();				// VRAMݒ
	NutsTagBgSet( wk->bgl );			// BGݒ
	NutsTagBgGraphicSet( wk );			// BGOtBbNZbg

	NutsTagMsgManCreate( wk );
	sys_KeyRepeatSpeedSet( 4, 8 );

//	InitTPSystem();						// ^b`plVXe
//	InitTPNoBuff(4);

	NutsGraphicSet( wk );

	NutsTagBmpWinSet( wk );				// BMPEBhEݒ
	NTAG_BmpPutAll( wk );

	NTAG_CameraInit( wk );
	NTAG_ConditionParamInit( wk );

	sys_VBlankFuncChange( NutsTagVBlank, wk );	// VBlankZbg

//	Snd_DataSetByScene( SND_SCENE_SUB_BAG, 0, 0 );	// TEhf[^[h(obO)(BGMp)

	return PROC_RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * vZX֐FC
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT NutsTagProc_Main( PROC * proc, int * seq )
{
	NTAG_WORK * wk  = PROC_GetWork( proc );

	switch( *seq ){
	case SEQ_IN:
		*seq = SeqInFunc( wk );
		break;

	case SEQ_MAIN:
		*seq = SeqMainFunc( wk );
		break;

	case SEQ_CHANGE:
		*seq = SeqChangeFunc( wk );
		break;

	case SEQ_OUT:
		if( SeqOutFunc( wk ) == TRUE ){
			return PROC_RES_FINISH;
		}
		break;
	}

//	GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME1_M, GF_BGL_SCROLL_Y_INC, 1 );
//	GF_BGL_ScrollReq( wk->bgl, GF_BGL_FRAME2_M, GF_BGL_SCROLL_Y_INC, 1 );

	NTAG_3DMain( wk );

	return PROC_RES_CONTINUE;
}

//--------------------------------------------------------------------------------------------
/**
 * vZX֐FI
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT NutsTagProc_End( PROC * proc, int * seq )
{
	NTAG_WORK * wk  = PROC_GetWork( proc );

	NutsTagBmpWinExit( wk->win );	// BMPEBhEJ
	NutsTagBgExit( wk->bgl );		// BGL폜
//	StopTP();						// ^b`plI

	NutsTagMsgManDelete( wk );

	NTAG_3DRelease( wk );

	PROC_FreeWork( proc );					// [NJ

	sys_VBlankFuncChange( NULL, NULL );		// VBlankZbg

	sys_FreeMemoryEz( wk->nuts );

	sys_DeleteHeap( HEAPID_NUTSTAG );

	return PROC_RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * VBlank
 *
 * @param	work	[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NutsTagVBlank( void * work )
{
	NTAG_WORK * wk = work;

	GF_BGL_VBlankFunc( wk->bgl );

	OS_SetIrqCheckFlag( OS_IE_V_BLANK );
}


//--------------------------------------------------------------------------------------------
/**
 * VRAMݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NutsTagVramBankSet(void)
{
	GF_BGL_DISPVRAM tbl = {
		GX_VRAM_BG_128_A,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg

		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg

		GX_VRAM_OBJ_64_E,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg

		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg

		GX_VRAM_TEX_NONE,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_NONE			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &tbl );
}

//--------------------------------------------------------------------------------------------
/**
 * BGݒ
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NutsTagBgSet( GF_BGL_INI * ini )
{
	{	// BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_3D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	NTAG_3DInit();

	{	// NUTS & INFO (BMP)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME1_M );
	}

	{	// FRAME (CHAR)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME2_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}

	{	// TITLE (CHAR&BMP)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME3_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}

	GF_BGL_ClearCharSet( GF_BGL_FRAME1_M, 32, 0, HEAPID_NUTSTAG );
}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NutsTagBgExit( GF_BGL_INI * ini )
{
	GF_Disp_GX_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_BG2 | GX_PLANEMASK_BG3, VISIBLE_OFF );

	GF_BGL_BGControlExit( ini, GF_BGL_FRAME3_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_M );

	sys_FreeMemory( HEAPID_NUTSTAG, ini );
}


//--------------------------------------------------------------------------------------------
/**
 * OtBbNf[^Zbg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NutsTagBgGraphicSet( NTAG_WORK * wk )
{
	ArcUtil_BgCharSet(
		ARC_NTAG_GRA, NARC_ntag_gra_kinomi_bg_NCGR,
		wk->bgl, GF_BGL_FRAME2_M, 0, 0, 0, HEAPID_NUTSTAG );
	ArcUtil_ScrnSet(
		ARC_NTAG_GRA, NARC_ntag_gra_kinomi_bg_NSCR,
		wk->bgl, GF_BGL_FRAME2_M, 0, 0, 0, HEAPID_NUTSTAG );
	ArcUtil_ScrnSet(
		ARC_NTAG_GRA, NARC_ntag_gra_kinomi_bg02_NSCR,
		wk->bgl, GF_BGL_FRAME3_M, 0, 0, 0, HEAPID_NUTSTAG );
	ArcUtil_PalSet(
		ARC_NTAG_GRA, NARC_ntag_gra_kinomi_bg_NCLR, PALTYPE_MAIN_BG, 0, 0, HEAPID_NUTSTAG );

	{	// ؂̎̊GXN[ɓWJ
		u16	* buf;
		u32	i;

		buf = (u16 *)sys_AllocMemory( HEAPID_NUTSTAG, 8*8*2 );

		for( i=0; i<8*8; i++ ){
			buf[i] = (NUTS_GRA_PAL<<12) + NUTS_GRA_CGX + i;
		}
		GF_BGL_ScrWrite(
			wk->bgl, NUTS_GRA_FRM, buf, NUTS_GRA_PX, NUTS_GRA_PY, NUTS_GRA_SX, NUTS_GRA_SY );

		sys_FreeMemoryEz( buf );
		GF_BGL_LoadScreenReq( wk->bgl, NUTS_GRA_FRM );
	}

	SystemFontPaletteLoad( PALTYPE_MAIN_BG, NTAG_SYSFONT_PAL*0x20, HEAPID_NUTSTAG );
}

//--------------------------------------------------------------------------------------------
/**
 * bZ[W֘A쐬
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NutsTagMsgManCreate( NTAG_WORK * wk )
{
	wk->mman = MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,NARC_msg_kinomi_tag_dat,HEAPID_NUTSTAG );
	wk->nfnt = NUMFONT_Create( 15, 2, FBMP_COL_NULL, HEAPID_NUTSTAG );
	wk->wset = WORDSET_Create( HEAPID_NUTSTAG );
}

//--------------------------------------------------------------------------------------------
/**
 * bZ[W֘A폜
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NutsTagMsgManDelete( NTAG_WORK * wk )
{
	MSGMAN_Delete( wk->mman );
	NUMFONT_Delete( wk->nfnt );
	WORDSET_Delete( wk->wset );
}

//--------------------------------------------------------------------------------------------
/**
 * BMP쐬
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NutsTagBmpWinSet( NTAG_WORK * wk )
{
	u32	i;

	for( i=0; i<WIN_MAX; i++ ){
		GF_BGL_BmpWinAddEx( wk->bgl, &wk->win[i], &NutsTagBmpData[i] );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * BMP폜
 *
 * @param	win		BMPEBhEf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NutsTagBmpWinExit( GF_BGL_BMPWIN * win )
{
	u32	i;

	for( i=0; i<WIN_MAX; i++ ){
		GF_BGL_BmpWinDel( &win[i] );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * Œ蕶𒆉ɕ\
 *
 * @param	wk		[N
 * @param	widx	EBhECfbNX
 * @param	midx	bZ[WCfbNX
 * @param	col		J[
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_BmpStrPut( NTAG_WORK * wk, u32 widx, u32 midx, u32 col )
{
	GF_BGL_BMPWIN * win;
	STRBUF * str;
	u32	siz;

	win = &wk->win[widx];
	str = MSGMAN_AllocString( wk->mman, midx );
	siz = FontProc_GetPrintStrWidth( FONT_SYSTEM, str, 0 );
	GF_STR_PrintColor(
		win, FONT_SYSTEM, str,
		(GF_BGL_BmpWinGet_SizeX(win)*8-siz)/2, 0, MSG_NO_PUT, col, NULL );
	STRBUF_Delete( str );
	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * û݃^Ov\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_BmpTitlePut( NTAG_WORK * wk )
{
	GF_BGL_BmpWinDataFill( &wk->win[WIN_NUTS_TITLE], TITLE_BACK_COL );
	NTAG_BmpStrPut( wk, WIN_NUTS_TITLE, mes_kinomi_tag_01_01, PCOL_TITLE );
}

//--------------------------------------------------------------------------------------------
/**
 * u炢v\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_BmpKaraiPut( NTAG_WORK * wk )
{
	GF_BGL_BmpWinDataFill( &wk->win[WIN_KARAI], 0 );
	NTAG_BmpStrPut( wk, WIN_KARAI, mes_kinomi_tag_02_01, PCOL_N_WHITE );
}

//--------------------------------------------------------------------------------------------
/**
 * uԂv\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_BmpSibuiPut( NTAG_WORK * wk )
{
	GF_BGL_BmpWinDataFill( &wk->win[WIN_SIBUI], 0 );
	NTAG_BmpStrPut( wk, WIN_SIBUI, mes_kinomi_tag_02_02, PCOL_N_WHITE );
}

//--------------------------------------------------------------------------------------------
/**
 * u܂v\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_BmpAmaiPut( NTAG_WORK * wk )
{
	GF_BGL_BmpWinDataFill( &wk->win[WIN_AMAI], 0 );
	NTAG_BmpStrPut( wk, WIN_AMAI, mes_kinomi_tag_02_03, PCOL_N_WHITE );
}

//--------------------------------------------------------------------------------------------
/**
 * uɂv\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_BmpNigaiPut( NTAG_WORK * wk )
{
	GF_BGL_BmpWinDataFill( &wk->win[WIN_NIGAI], 0 );
	NTAG_BmpStrPut( wk, WIN_NIGAI, mes_kinomi_tag_02_04, PCOL_N_WHITE );
}

//--------------------------------------------------------------------------------------------
/**
 * uςv\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_BmpSuppaiPut( NTAG_WORK * wk )
{
	GF_BGL_BmpWinDataFill( &wk->win[WIN_SUPPAI], 0 );
	NTAG_BmpStrPut( wk, WIN_SUPPAI, mes_kinomi_tag_02_05, PCOL_N_WHITE );
}

//--------------------------------------------------------------------------------------------
/**
 * ؂̎\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_BmpNutsNamePut( NTAG_WORK * wk )
{
	GF_BGL_BMPWIN * win;
	STRBUF * str;
	STRBUF * exp;

	win = &wk->win[WIN_NUTS_NAME];

	GF_BGL_BmpWinDataFill( win, 0 );

	NUMFONT_WriteMark( wk->nfnt, NUMFONT_MARK_NO, win, 0, NAME_NO_PY );

	str = MSGMAN_AllocString( wk->mman, mes_kinomi_tag_03_01 );
	exp = STRBUF_Create( (2+1)*2, HEAPID_NUTSTAG );	// (2+EOM_)x2([JCYpɈꉞ)
	WORDSET_RegisterNumber(
		wk->wset, 0, wk->dat->now_tag+1, 2, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, exp, str );
	GF_STR_PrintColor(
		win, FONT_SYSTEM, exp, NUMFONT_MARK_WIDTH, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	STRBUF_Delete( exp );

	str = NutsNameGetAlloc( wk->dat->now_tag, HEAPID_NUTSTAG );
	GF_STR_PrintColor(
		win, FONT_SYSTEM, str, NUTS_NAME_PX, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );

	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * \
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_BmpNutsInfoPut( NTAG_WORK * wk )
{
	GF_BGL_BMPWIN * win;
	STRBUF * str;

	win = &wk->win[WIN_INFO];

	GF_BGL_BmpWinDataFill( win, 0 );

	str = NutsInfoGetAlloc( wk->dat->now_tag, HEAPID_NUTSTAG );
	GF_STR_PrintColor(
		win, FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_BLACK, NULL );
	STRBUF_Delete( str );

	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * uv\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_BmpNutsHardPut( NTAG_WORK * wk )
{
	GF_BGL_BMPWIN * win;
	STRBUF * str;

	win  = &wk->win[WIN_HARD];

	GF_BGL_BmpWinDataFill( win, 0 );

	str = MSGMAN_AllocString( wk->mman, mes_kinomi_tag_05_01 );
	GF_STR_PrintColor( win, FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );

	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * dl\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_BmpNutsHardNumPut( NTAG_WORK * wk )
{
	GF_BGL_BMPWIN * win;
	STRBUF * str;
	u32	hard;

	win  = &wk->win[WIN_HARD_NUM];

	GF_BGL_BmpWinDataFill( win, 0 );

	hard = Nuts_ParamGet( wk->nuts, NUTS_PRM_HARDNESS );
	if( hard != 0 ){ hard--; }
	str  = MSGMAN_AllocString( wk->mman, mes_kinomi_tag_05_02+hard );
	GF_STR_PrintColor( win, FONT_SYSTEM, str, HARD_PX, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );

	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * uv\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_BmpNutsSizePut( NTAG_WORK * wk )
{
	GF_BGL_BMPWIN * win;
	STRBUF * str;

	win  = &wk->win[WIN_SIZE];

	GF_BGL_BmpWinDataFill( win, 0 );

	str = MSGMAN_AllocString( wk->mman, mes_kinomi_tag_04_01 );
	GF_STR_PrintColor( win, FONT_SYSTEM, str, 0, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );

	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * 傫l\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_BmpNutsSizeNumPut( NTAG_WORK * wk )
{
	GF_BGL_BMPWIN * win;
	STRBUF * str;
	STRBUF * exp;
	u32	size;

	win  = &wk->win[WIN_SIZE_NUM];

	GF_BGL_BmpWinDataFill( win, 0 );

	size = Nuts_ParamGet( wk->nuts, NUTS_PRM_SIZE );
	str  = MSGMAN_AllocString( wk->mman, mes_kinomi_tag_04_02 );
	exp  = STRBUF_Create( 32, HEAPID_NUTSTAG );
	WORDSET_RegisterNumber(
		wk->wset, 0, size/10, 2, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	WORDSET_RegisterNumber(
		wk->wset, 1, size%10, 1, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, exp, str );
	GF_STR_PrintColor(
		win, FONT_SYSTEM, exp, SIZE_PX, 0, MSG_NO_PUT, PCOL_N_WHITE, NULL );
	STRBUF_Delete( str );
	STRBUF_Delete( exp );

	GF_BGL_BmpWinOnVReq( win );
}

//--------------------------------------------------------------------------------------------
/**
 * BMP\
 *
 * @param	wk		[N
 * @param	seq		V[PX
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_BmpPut( NTAG_WORK * wk, u8 seq )
{
	switch( seq ){
	case 0:
		NTAG_BmpTitlePut( wk );
		break;
	case 1:
		NTAG_BmpKaraiPut( wk );
		break;
	case 2:
		NTAG_BmpNutsNamePut( wk );
		break;
	case 3:
		NTAG_BmpSuppaiPut( wk );
		NTAG_BmpSibuiPut( wk );
		break;
	case 4:
		NTAG_BmpAmaiPut( wk );
		NTAG_BmpNigaiPut( wk );
		break;
	case 5:
		NTAG_BmpNutsSizePut( wk );
		NTAG_BmpNutsSizeNumPut( wk );
		break;
	case 6:
		NTAG_BmpNutsHardPut( wk );
		NTAG_BmpNutsHardNumPut( wk );
		break;
	case 7:
		NTAG_BmpNutsInfoPut( wk );
		break;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * BMP\iSāj
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_BmpPutAll( NTAG_WORK * wk )
{
	u32	i;

	for( i=0; i<BMP_PUT_SEQ_MAX; i++ ){
		NTAG_BmpPut( wk, (u8)i );
	}
}


//--------------------------------------------------------------------------------------------
/**
 * CV[PXF
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static int SeqInFunc( NTAG_WORK * wk )
{
	if( wk->wipe_flg == TRUE ){
		G2_SetBlendAlpha( GX_BLEND_PLANEMASK_BG1, GX_BLEND_PLANEMASK_BG2, 16, 0 );
		return SEQ_MAIN;
	}
	return SEQ_IN;
}

//--------------------------------------------------------------------------------------------
/**
 * CV[PXFRg[
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static int SeqMainFunc( NTAG_WORK * wk )
{
	u32	next;

	if( sys.cont & PAD_KEY_UP ){
		next = NextTagGet( wk->dat->tag_flg, wk->dat->now_tag, -1 );
		if( wk->dat->now_tag != next ){
			wk->dat->now_tag = next;
			wk->blend_cnt = 0;
			wk->blend_flg = 0;
			return SEQ_CHANGE;
		}
		return SEQ_MAIN;
	}
	if( sys.cont & PAD_KEY_DOWN ){
		next = NextTagGet( wk->dat->tag_flg, wk->dat->now_tag, 1 );
		if( wk->dat->now_tag != next ){
			wk->dat->now_tag = next;
			wk->blend_cnt = 0;
			wk->blend_flg = 0;
			return SEQ_CHANGE;
		}
		return SEQ_MAIN;
	}

	if( sys.trg & PAD_BUTTON_CANCEL ){
		APP_WipeStart( APP_WIPE_OUT, HEAPID_NUTSTAG, &wk->wipe_flg );
		return SEQ_OUT;
	}
	return SEQ_MAIN;
}

//--------------------------------------------------------------------------------------------
/**
 * CV[PXFI
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 SeqOutFunc( NTAG_WORK * wk )
{
	return wk->wipe_flg;
}

//--------------------------------------------------------------------------------------------
/**
 * CV[PXF^O؂ւ
 *
 * @param	wk		[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static int SeqChangeFunc( NTAG_WORK * wk )
{
	int	seq = SEQ_CHANGE;

	if( wk->blend_flg == 0 ){
		wk->blend_cnt += 4;
		if( wk->blend_cnt == 16 ){
			wk->blend_flg = 1;
		}
	}else if( wk->blend_flg == 1 ){
		TagChange( wk );
		wk->blend_flg = 2;
	}else{
		wk->blend_cnt -= 4;
		if( wk->blend_cnt == 0 ){
			wk->blend_flg = 0;
			seq = SEQ_MAIN;
		}
	}
	G2_ChangeBlendAlpha( 16-wk->blend_cnt, wk->blend_cnt );

	return seq;
}


//--------------------------------------------------------------------------------------------
/**
 * ؂̎OtBbN]
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NutsGraphicSet( NTAG_WORK * wk )
{
	ArcUtil_BgCharSet(
		ARC_NTAG_GRA, NutsCgxArcGet(wk->dat->now_tag),
		wk->bgl, NUTS_GRA_FRM, NUTS_GRA_CGX, 0, 0, HEAPID_NUTSTAG );
	ArcUtil_PalSet(
		ARC_NTAG_GRA, NutsPalArcGet(wk->dat->now_tag),
		PALTYPE_MAIN_BG, NUTS_GRA_PAL*0x20, 0x20, HEAPID_NUTSTAG );
}

//--------------------------------------------------------------------------------------------
/**
 * ؂̎̊G̃L̃A[JCuCfbNX擾
 *
 * @param	id		؂̎ԍ
 *
 * @return	L̃A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u32	NutsCgxArcGet( u32 id )
{
	return NARC_ntag_gra_kinomi_001_NCGR + id;
}

//--------------------------------------------------------------------------------------------
/**
 * ؂̎̊G̃L̃A[JCuCfbNX擾iACeԍj
 *
 * @param	item	ACeԍ
 *
 * @return	L̃A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u32 NutsCgxArcGet_Item( u32 item )
{
	return NutsCgxArcGet( item - NUTS_START_ITEMNUM );
}


//--------------------------------------------------------------------------------------------
/**
 * ؂̎̊G̃pbg̃A[JCuCfbNX擾
 *
 * @param	id		؂̎ԍ
 *
 * @return	pbg̃A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u32	NutsPalArcGet( u32 id )
{
	return NARC_ntag_gra_kinomi_001_NCLR + id;
}

//--------------------------------------------------------------------------------------------
/**
 * ؂̎̊G̃pbg̃A[JCuCfbNX擾iACeԍj
 *
 * @param	item	ACeԍ
 *
 * @return	pbg̃A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u32 NutsPalArcGet_Item( u32 item )
{
	return NutsPalArcGet( item - NUTS_START_ITEMNUM );
}


//--------------------------------------------------------------------------------------------
/**
 * ̃^O擾
 *
 * @param	tbl		\e[u
 * @param	now		\̃^OID
 * @param	mv		؂ւ
 *
 * @return	̃^OID
 */
//--------------------------------------------------------------------------------------------
static u32 NextTagGet( u32 * tbl, u32 now, s32 mv )
{
	s32	i = (s32)now;

	if( mv < 0 ){
		if( now != 0 ){
			while(1){
				i -= 1;
				if( TagPutFlagGet( tbl, (u16)i ) == TRUE ){
					now = (u32)i;
					mv++;
					if( mv == 0 ){ break; }
				}
				if( i == 0 ){ break; }
			}
		}
	}else{
		if( now != NUTS_TAG_MAX ){
			while(1){
				i += 1;
				if( TagPutFlagGet( tbl, (u16)i ) == TRUE ){
					now = (u16)i;
					mv--;
					if( mv == 0 ){ break; }
				}
				if( i == NUTS_TAG_MAX ){ break; }
			}
		}
	}

	return now;
}

//--------------------------------------------------------------------------------------------
/**
 * ^O؂ւ
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void TagChange( NTAG_WORK * wk )
{
	sys_FreeMemoryEz( wk->nuts );
	wk->nuts = Nuts_DataLoad( wk->dat->now_tag, HEAPID_NUTSTAG );
	NTAG_BmpPutAll( wk );

	NutsGraphicSet( wk );

	NTAG_ConditionParamMake( wk );

	GF_BGL_LoadScreenReq( wk->bgl, NUTS_GRA_FRM );
}


//============================================================================================
//	3D֘A
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * 3D֘A
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_3DInit(void)
{
	// iNITRO-SDK̃Tvj
	G3X_Init();
	G3X_InitMtxStack();
	G3X_SetShading( GX_SHADING_TOON );
	G3X_AlphaTest( FALSE, 0 );
	G3X_AlphaBlend( TRUE );
	G3X_AntiAlias( TRUE );
	G3X_EdgeMarking( FALSE );
	G3X_SetFog( FALSE, 0, 0, 0 );
	G3X_SetClearColor( 0, 0, 0x7fff, 63, FALSE );
    G3_SwapBuffers( GX_SORTMODE_AUTO, GX_BUFFERMODE_Z );
	G3_ViewPort( 0, 0, 255, 191 );

	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
    G2_SetBG0Priority( 0 );
}

//--------------------------------------------------------------------------------------------
/**
 * 3D֘AC
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_3DMain( NTAG_WORK * wk )
{
	GF_G3X_Reset();
	GFC_CameraLookAt();

	G3_MtxMode( GX_MTXMODE_PROJECTION );
	G3_Identity();
	G3_MtxMode( GX_MTXMODE_POSITION_VECTOR );
	G3_Identity();

	ConditionGagePut( wk->cvtx );

	NTAG_ConditionPlus( wk );

	G3_SwapBuffers( GX_SORTMODE_MANUAL, GX_BUFFERMODE_Z );
}

//--------------------------------------------------------------------------------------------
/**
 * 3D֘A폜
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_3DRelease( NTAG_WORK * wk )
{
	GFC_FreeCamera( wk->camera );	// J폜
}

//--------------------------------------------------------------------------------------------
/**
 * Jݒ
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_CameraInit( NTAG_WORK * wk )
{
	VecFx32	camera_pos = {0,0,0x10000};
	CAMERA_ANGLE angle = {0,0,0};
	fx32	distance   = 0x10000;
	u16		perspway   = 0x05c1;

	wk->camera = GFC_AllocCamera( HEAPID_NUTSTAG );

	GFC_InitCameraCDA( &camera_pos, distance, &angle, perspway, GF_CAMERA_ORTHO, wk->camera );
	GFC_SetCameraClip( 0, FX32_ONE*100, wk->camera );	// Nbvݒ(near-far)
	GFC_PurgeCameraTarget( wk->camera );
	GFC_AttachCamera( wk->camera );
}

//--------------------------------------------------------------------------------------------
/**
 * RfBVQ[W\
 *
 * @param	vtx		|S\W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void ConditionGagePut( NTAG_CONDISION_VTX * vtx )
{
	G3_PolygonAttr(
		GX_LIGHTMASK_NONE,			// no lights
		GX_POLYGONMODE_MODULATE,	// modulation mode
		GX_CULL_NONE,				// cull none
		18,							// polygon ID(0 - 63)
		24,							// alpha(0 - 31)
		0 );						// OR of GXPolygonAttrMisc's value

    G3_Begin( GX_BEGIN_QUADS );
    {
		u32	i;

		for( i=0; i<4; i++ ){
			G3_Color( GX_RGB(8,31,15) );
			G3_Vtx( vtx[i].lt.x, vtx[i].lt.y, vtx[i].lt.z );
			G3_Color( GX_RGB(8,31,15) );
			G3_Vtx( vtx[i].rt.x, vtx[i].rt.y, vtx[i].rt.z );
			G3_Color( GX_RGB(8,31,15) );
			G3_Vtx( vtx[i].ru.x, vtx[i].ru.y, vtx[i].ru.z );
			G3_Color( GX_RGB(8,31,15) );
			G3_Vtx( vtx[i].lu.x, vtx[i].lu.y, vtx[i].lu.z );
		}
	}
    G3_End();
}

//--------------------------------------------------------------------------------------------
/**
 * \WύX
 *
 * @param	p		\W
 * @param	m		ύXl
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void ConditionParamPlus( VecFx16 * p, VecFx16 * m )
{
	p->x += m->x;
	p->y += m->y;
	p->z += m->z;
}

//--------------------------------------------------------------------------------------------
/**
 * RfBVQ[W
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_ConditionPlus( NTAG_WORK * wk )
{
	u32	i;

	if( wk->con_mv_cnt == 4 ){ return; }

	if( wk->con_mv_cnt == 3 ){
		for( i=0; i<4; i++ ){
			wk->cvtx[i] = wk->mvtx[i];
		}
	}else{
		for( i=0; i<4; i++ ){
			ConditionParamPlus( &wk->cvtx[i].lt, &wk->pvtx[i].lt );
			ConditionParamPlus( &wk->cvtx[i].rt, &wk->pvtx[i].rt );
			ConditionParamPlus( &wk->cvtx[i].lu, &wk->pvtx[i].lu );
			ConditionParamPlus( &wk->cvtx[i].ru, &wk->pvtx[i].ru );
		}
	}

	wk->con_mv_cnt++;
}

//--------------------------------------------------------------------------------------------
/**
 * RfBVQ[W
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_ConditionParamInit( NTAG_WORK * wk )
{
	u32	i;

	wk->cvtx[0].lt = ConPrm[0][3].min;
	wk->cvtx[0].rt = ConPrm[0][3].min;
	wk->cvtx[0].lu = ConPrm[0][3].min;
	wk->cvtx[0].ru = ConPrm[0][3].min;

	wk->cvtx[1].lt = ConPrm[1][2].min;
	wk->cvtx[1].rt = ConPrm[1][2].min;
	wk->cvtx[1].lu = ConPrm[1][2].min;
	wk->cvtx[1].ru = ConPrm[1][2].min;

	wk->cvtx[2].lt = ConPrm[2][1].min;
	wk->cvtx[2].rt = ConPrm[2][1].min;
	wk->cvtx[2].lu = ConPrm[2][1].min;
	wk->cvtx[2].ru = ConPrm[2][1].min;

	wk->cvtx[3].lt = ConPrm[3][0].min;
	wk->cvtx[3].rt = ConPrm[3][0].min;
	wk->cvtx[3].lu = ConPrm[3][0].min;
	wk->cvtx[3].ru = ConPrm[3][0].min;

	NTAG_ConditionParamMake( wk );
}

//--------------------------------------------------------------------------------------------
/**
 * RfBVQ[WőlZbg
 *
 * @param	cnst	Wf[^
 * @param	make	쐬ꏊ
 * @param	prm		p[
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void ConditionMaxMake( const CONDITION_VTX_CALC * cnst, VecFx16 * make, u8 prm )
{
	if( prm == 0xff ){
		*make = cnst->max;
	}else if( prm == 0 ){
		*make = cnst->min;
	}else{
		make->x = cnst->min.x + cnst->siz.x * prm;
		make->y = cnst->min.y + cnst->siz.y * prm;
		make->z = cnst->min.z + cnst->siz.z * prm;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * RfBVQ[WlZbg
 *
 * @param	now		݂̍W
 * @param	max		őW
 * @param	move	P̓l
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void ConditionMoveMake( VecFx16 * now, VecFx16 * max, VecFx16 * move )
{
	move->x = FX_F32_TO_FX16( FX_FX16_TO_F32(max->x-now->x)/4 );
	move->y = FX_F32_TO_FX16( FX_FX16_TO_F32(max->y-now->y)/4 );
	move->z = FX_F32_TO_FX16( FX_FX16_TO_F32(max->z-now->z)/4 );
}

//--------------------------------------------------------------------------------------------
/**
 * RfBVQ[Wp[^쐬
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NTAG_ConditionParamMake( NTAG_WORK * wk )
{
	u32	i;

	// őlZbg
	ConditionMaxMake( &ConPrm[0][0], &wk->mvtx[0].lt, Nuts_ParamGet(wk->nuts,NUTS_PRM_KARAI) );
	ConditionMaxMake( &ConPrm[0][1], &wk->mvtx[0].rt, Nuts_ParamGet(wk->nuts,NUTS_PRM_SIBUI) );
	ConditionMaxMake( &ConPrm[0][2], &wk->mvtx[0].ru, Nuts_ParamGet(wk->nuts,NUTS_PRM_AMAI) );
	ConditionMaxMake( &ConPrm[0][3], &wk->mvtx[0].lu, 0 );

	ConditionMaxMake( &ConPrm[1][0], &wk->mvtx[1].lt, Nuts_ParamGet(wk->nuts,NUTS_PRM_SUPPAI) );
	ConditionMaxMake( &ConPrm[1][1], &wk->mvtx[1].rt, Nuts_ParamGet(wk->nuts,NUTS_PRM_KARAI) );
	ConditionMaxMake( &ConPrm[1][2], &wk->mvtx[1].ru, 0 );
	ConditionMaxMake( &ConPrm[1][3], &wk->mvtx[1].lu, Nuts_ParamGet(wk->nuts,NUTS_PRM_NIGAI) );

	ConditionMaxMake( &ConPrm[2][0], &wk->mvtx[2].lt, Nuts_ParamGet(wk->nuts,NUTS_PRM_SUPPAI) );
	ConditionMaxMake( &ConPrm[2][1], &wk->mvtx[2].rt, 0 );
	ConditionMaxMake( &ConPrm[2][2], &wk->mvtx[2].ru, Nuts_ParamGet(wk->nuts,NUTS_PRM_AMAI) );
	ConditionMaxMake( &ConPrm[2][3], &wk->mvtx[2].lu, Nuts_ParamGet(wk->nuts,NUTS_PRM_NIGAI) );

	ConditionMaxMake( &ConPrm[3][0], &wk->mvtx[3].lt, 0 );
	ConditionMaxMake( &ConPrm[3][1], &wk->mvtx[3].rt, Nuts_ParamGet(wk->nuts,NUTS_PRM_SIBUI) );
	ConditionMaxMake( &ConPrm[3][2], &wk->mvtx[3].ru, Nuts_ParamGet(wk->nuts,NUTS_PRM_AMAI) );
	ConditionMaxMake( &ConPrm[3][3], &wk->mvtx[3].lu, Nuts_ParamGet(wk->nuts,NUTS_PRM_NIGAI) );

	// vXlvZ
	for( i=0; i<4; i++ ){
		ConditionMoveMake( &wk->cvtx[i].lt, &wk->mvtx[i].lt, &wk->pvtx[i].lt );
		ConditionMoveMake( &wk->cvtx[i].rt, &wk->mvtx[i].rt, &wk->pvtx[i].rt );
		ConditionMoveMake( &wk->cvtx[i].lu, &wk->mvtx[i].lu, &wk->pvtx[i].lu );
		ConditionMoveMake( &wk->cvtx[i].ru, &wk->mvtx[i].ru, &wk->pvtx[i].ru );
	}

	wk->con_mv_cnt = 0;
}
