//=============================================================================
/**
 * @file	comm_command_oekaki.c
 * @brief	f[^𑗂邽߂̃R}he[uĂ܂
 *          G{[hpł
 * @author	Akito Mori
 * @date    2005.02.14
 */
//=============================================================================

#include "common.h"
#include "communication/communication.h"
#include "system/clact_tool.h"
#include "system/msgdata_util.h"
#include "system/wordset.h"

typedef struct OEKAKI_WORK OEKAKI_WORK;

#include "oekaki_local.h"


#include "comm_command_oekaki.h"



static int _getZero(void);
static int _getOne(void);
static int _getPictureSize(void);
static int _getLinePosSize(void);
static int _getLinePosServerSize(void);

static void Oekaki_GraphicDataSend( OEKAKI_WORK *wk, int no);


// CommCommandOekaki.c`R}hőΉR[obN֐
static const CommPacketTbl _CommPacketTbl[] = {
	
	{CommOekakiBoardPicture, 		_getPictureSize}, 		// CO_OEKAKI_GRAPHICDATA  ݂Ȃŕ`Ă摜f[^
	{CommOekakiBoardLinePos,   		_getLinePosSize},    	// CO_OEKAKI_LINEPOS,	  ^b`plŎ擾|WVf[^
	{CommOekakiBoardLinePosServer, _getLinePosServerSize}, 	// CO_OEKAKI_LINEPOS,	  ^b`plŎ擾|WVf[^
	{CommOekakiBoardYes,   			_getOne},              	// CO_OEKAKI_YES,		  ͂
	{CommOekakiBoardNo,   	   	 	_getOne},             	// CO_OEKAKI_NO,		  
    {CommOekakiBoardStop,			_getOne},             	// CO_OEKAKI_STOP,		  ҂̂ňUXgbv
    {CommOekakiBoardReStart,		_getZero},             	// CO_OEKAKI_RESTART,	  ҏÎōĉ
    {CommOekakiBoardEndQuestion,	_getZero},          	// CO_OEKAKI_END_QUESTION I
    {CommOekakiBoardEndChild,		_getOne},            	// CO_OEKAKI_END_CHILD,	  q@E
    {CommOekakiBoardEnd,			_getZero},              // CO_OEKAKI_END,		  I
	{CommOekakiBoardChildJoin,		_getZero},				// CO_OEKAKI_CHILD_JOIN	  q@錾
};


//==============================================================================
/**
 * G{[hpʐMR}ho^
 *
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommCommandOekakiBoardInitialize(void* pWork)
{
    int length = sizeof(_CommPacketTbl)/sizeof(CommPacketTbl);
    CommCommandInitialize(_CommPacketTbl, length, pWork);
}


//==============================================================================
/**
 * |Pf[^Mi[B̃f[^MĂяo(eq݂̑MɂȂj
 * qɂPQ̕𑗐M邱ƂɂȂ͂
 * 
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommOekakiBoardPicture(int netID, int size, void* pBuff, void* pWork)
{
	OEKAKI_WORK *wk = (OEKAKI_WORK *)pWork;

	// q@̏ꍇ͐e@摜f[^荞
	if(CommGetCurrentID()!=0){
		OEKAKIG_SPLIT_DATA *osd = (OEKAKIG_SPLIT_DATA *)pBuff;;
		OS_Printf("摜擾 no=%d, xor=%08x\n",osd->no, osd->_xor);
		if(osd->no*1000 > OEKAKI_GRAPHI_SIZE){
			MI_CpuCopyFast( osd->chara, &wk->canvas_buf[osd->no*1000], OEKAKI_GRAPHI_SIZE%1000);
		}else{
			MI_CpuCopyFast( osd->chara, &wk->canvas_buf[osd->no*1000],  1000);
		}
		// BMPWIÑobt@ɃRs[
		MI_CpuCopyFast( wk->canvas_buf, wk->OekakiBoard.chrbuf, OEKAKI_GRAPHI_SIZE);

		// ʂɔf
		GF_BGL_BmpWinOn( &wk->OekakiBoard );

	// e@͎̃f[^𑗐M
	}else{
		OEKAKIG_SPLIT_DATA *osd = (OEKAKIG_SPLIT_DATA *)pBuff;;
		OS_Printf("摜擾 no=%d, xor=%08x",osd->no, osd->_xor);
	
		if(wk->send_num*1000 < OEKAKI_GRAPHI_SIZE){
			wk->send_num++;
			Oekaki_GraphicDataSend(wk, wk->send_num);
		}else{
			CommSendData_ServerSide( CO_OEKAKI_RESTART, NULL, 0);
		}
	}

}


//==============================================================================
/**
 * Xg̃J[\ʒuMƂ̃R[obN
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommOekakiBoardLinePos(int netID, int size, void* pBuff, void* pWork)
{
	OEKAKI_WORK *wk     = (OEKAKI_WORK*)pWork;
	TOUCH_INFO  *result = (TOUCH_INFO*)pBuff;

	// q@f[^i[
	if(netID!=0){
		wk->ParentTouchResult[netID] = *result;
	}

}



//==============================================================================
/**
 * $brief   Cf[^e@MiS`)
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommOekakiBoardLinePosServer( int netID, int size, void* pBuff, void* pWork )
{
	OEKAKI_WORK *wk     = (OEKAKI_WORK*)pWork;
	TOUCH_INFO  *result = (TOUCH_INFO*)pBuff;

    if(wk==NULL){  // ̂Ƃ͂GłĂȂ̂Ŗ
        return;
    }

    
	if(netID==0){	// ΂ɐe炵Ȃ͂
		int i;
		for(i=0;i<OEKAKI_MEMBER_MAX;i++){
			wk->AllTouchResult[i] = result[i];
		}
	}
}
//==============================================================================
/**
 * ʐMʂJn
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommOekakiBoardReStart(int netID, int size, void* pBuff, void* pWork)
{
	OEKAKI_WORK *wk = (OEKAKI_WORK*)pWork;

	OS_Printf("e@炨GĊJʒm\n");
	OekakiBoard_MainSeqForceChange( wk, OEKAKI_MODE_NEWMEMBER_END, 0 );
	
}
//==============================================================================
/**
 * $brief   q@E
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		OEKAKI_WORK*
 *
 * @retval  none		
 */
//==============================================================================
void CommOekakiBoardEndChild(int netID, int size, void* pBuff, void* pWork)
{
	OEKAKI_WORK *wk = (OEKAKI_WORK*)pWork;
	u8 id;

	// e@炫ꍇ݂͂ȂŁuȂȂ܂vƂ
	if(netID!=0){
		if(CommGetCurrentID()==0){
			// q@(e@󂯎)
			// q@ȂȂSɒʒm
			id  = netID;

			CommSendData_ServerSide( CO_OEKAKI_END_CHILD, &id, 1 );
			OS_Printf("q@%d痣E󂯎M\n",netID);
		}
	
	}else{
	// e@q@E̒ʒm
		id = *(u8*)pBuff;
		OS_Printf("e@q@%d̗Eʒm\n",id);
		OekakiBoard_MainSeqCheckChange( wk, OEKAKI_MODE_LOGOUT_CHILD, id );
	}
}
void CommOekakiBoardEndQuestion(int netID, int size, void* pBuff, void* pWork)
{

}

//==============================================================================
/**
 * $brief   uq@Ă̂ňUG𑗂~܂Ăˁv
 *			Ɛe@MẴR[obN
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommOekakiBoardStop(int netID, int size, void* pBuff, void* pWork)
{

	OEKAKI_WORK *wk = (OEKAKI_WORK*)pWork;
	u8 id;

	id = *(u8*)pBuff;
	// CV[PXύX
	OekakiBoard_MainSeqCheckChange( wk, OEKAKI_MODE_NEWMEMBER, id );

	// e@摜f[^MJn
	if(CommGetCurrentID()==0){
		wk->send_num = 0;

		//OtBbNM
		Oekaki_GraphicDataSend(wk, wk->send_num);
	}


	OS_Printf("e@́uq@%dɊG𑗂邩~܂Ăˁvʒm\n",id);

}

void CommOekakiBoardYes(int netID, int size, void* pBuff, void* pWork)
{
	
}
void CommOekakiBoardNo(int netID, int size, void* pBuff, void* pWork)
{
	
}

//==============================================================================
/**
 * $brief   e@߂̂ŋI
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommOekakiBoardEnd(int netID, int size, void* pBuff, void* pWork)
{
	OEKAKI_WORK *wk = (OEKAKI_WORK*)pWork;
	OS_Printf("e@̏Iʒm̂ł߂\n");

	// e@ȊO͂̃R}hŋイ傤
	if(CommGetCurrentID() != 0){
		OekakiBoard_MainSeqForceChange( wk, OEKAKI_MODE_FORCE_END, 0  );
	}
}

//==============================================================================
/**
 * $brief   RځESځETڂ̎q@uG[vƌ
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommOekakiBoardChildJoin(int netID, int size, void* pBuff, void* pWork)
{
	u8 id;
	GF_ASSERT(CommGetCurrentID()==0 && "q@Ƃ");

	// e@󂯎(Ƃe󂯎Ȃǁj
	if(CommGetCurrentID()==0){
		id  = netID;
		
		// SɁuꂩG𑗂̂Ŏ~܂ĂvƑM
		CommSendData_ServerSide( CO_OEKAKI_STOP, &id, 1 );
		OS_Printf("q@(%d = %d)̗^Ĝʒm\n",id,netID);
	}
	
}





//------------------------------------------------------------------
/**
 * $brief   OtBbNf[^𕪊M
 *
 * @param   wk		
 * @param   no		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void Oekaki_GraphicDataSend( OEKAKI_WORK *wk, int no)
{
	// Mobt@ɃRs[
	u8 *p = (u8*)wk->OekakiBoard.chrbuf;
	MI_CpuCopyFast( &p[no*1000], wk->send_buf.chara, 1000 ); 

	// xor擾Ei[
	{
		int i;
		u32 *p,result;
		p = (u32*)wk->send_buf.chara;
		for(result=0,i=0;i<1000/4;i++){
			result ^= p[i];
		}
		wk->send_buf._xor        = result;
	}

	// ԍ
	wk->send_buf.no = no;
	
	// MJn
	CommSendHugeData_ServerSide( CO_OEKAKI_GRAPHICDATA, &wk->send_buf, sizeof(OEKAKIG_SPLIT_DATA));
//	CommSendHugeData(CO_OEKAKI_GRAPHICDATA, &wk->send_buf, 1004);

	OS_Printf("Mf[^ no=%d, xor = %08x\n",  wk->send_buf.no,  wk->send_buf._xor);
}


//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
// pbgTCYʒm֐Q
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
// Tlڑ̎ɁAq@MłőpPbgTCY
//--------------------------------------------------------------------------------
static int _getLinePosSize(void)
{
	return COMM_SEND_5TH_PACKET_MAX;
}

static int _getLinePosServerSize(void)
{
	return COMM_SEND_5TH_PACKET_MAX*OEKAKI_MEMBER_MAX;
}

//--------------------------------------------------------------------------------
// 0oCg\֐
//--------------------------------------------------------------------------------
static int _getZero(void)
{
    return 0;
}

//--------------------------------------------------------------------------------
// 1oCg\֐
//--------------------------------------------------------------------------------
static int _getOne(void)
{
    return 1;
}

//--------------------------------------------------------------------------------
// `ς݉摜̃TCY\iMʃMM`j
//--------------------------------------------------------------------------------
static int _getPictureSize(void)
{
	return sizeof(OEKAKIG_SPLIT_DATA);
}