//============================================================================================
/**
 * @file	pst_3d.h
 * @brief	|PXe[^X3D
 * @author	Hiroyuki Nakamura
 * @date	2006.01.24
 */
//============================================================================================
#ifndef PST_3D_H
#define PST_3D_H
#undef GLOBAL
#ifdef PST_3D_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * 3D֘A
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void PokeStatus_3DInit( PST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * 3D֘AC
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void PokeStatus_3DMain( PST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * 3D֘A폜
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void PokeStatus_3DRelease( PST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * Jݒ
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void PokeStatus_CameraInit( PST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * RfBVQ[W
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void PokeStatus_ConditionParamInit( PST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * RfBVQ[Wp[^쐬
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void PokeStatus_ConditionParamMake( PST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * \tgEFAXvCgZbg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void PokeStatus_SoftSpriteSet( PST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * \tgEFAXvCgăZbg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void PokeStatus_SoftSpriteReset( PST_WORK * wk );


#undef GLOBAL
#endif	/* PST_3D_H */
