//============================================================================================
/**
 * @file	pst_obj.c
 * @brief	|PXe[^XOBJ
 * @author	Hiroyuki Nakamura
 * @date	2005.10.27
 */
//============================================================================================
#include "common.h"
#include "system/procsys.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/clact_tool.h"
#include "system/window.h"
#include "system/msgdata.h"
#include "system/numfont.h"
#include "system/wordset.h"
#include "system/bmp_menu.h"
#include "system/buflen.h"
#include "battle/battle_common.h"
#include "poketool/monsno.h"
#include "poketool/pokeicon.h"
#include "poketool/pokeparty.h"
#include "poketool/waza_tool.h"
#include "application/app_tool.h"
#include "battle/wazatype_icon.h"

#define	PST_OBJ_H_GLOBAL
#include "application/p_status.h"
#include "pst_sys.h"
#include "pst_obj.h"
#include "pst_sub.h"
#include "pst_snd_def.h"
#include "pst_gra.naix"


//============================================================================================
//	萔`
//============================================================================================
enum {
	PST_CHR_ID_BALL = 0,
	PST_CHR_ID_TAB,
	PST_CHR_ID_WAZACURSOR,

	PST_CHR_ID_POKETYPE1,
	PST_CHR_ID_POKETYPE2,
	PST_CHR_ID_WAZATYPE1,
	PST_CHR_ID_WAZATYPE2,
	PST_CHR_ID_WAZATYPE3,
	PST_CHR_ID_WAZATYPE4,
	PST_CHR_ID_WAZATYPE5,
	PST_CHR_ID_WAZAKIND,

	PST_CHR_ID_POKEICON,

	PST_CHR_ID_STIZYO,
	PST_CHR_ID_FLASH,
	PST_CHR_ID_ARROW,
	PST_CHR_ID_MARK,

	PST_CHR_ID_BUTTON_EF,

	PST_CHR_ID_CNDITION_UP,
};

/*
enum {
	PST_PLTT_ID_OBJ = 0,
	PST_PLTT_ID_TYPEICON,
	PST_PLTT_ID_POKEICON,
	PST_PLTT_ID_STIZYO,
};

enum {
	PST_CLAN_ID_BALL = 0,
	PST_CLAN_ID_TAB,
	PST_CLAN_ID_WAZACURSOR,

	PST_CLAN_ID_TYPE,
	PST_CLAN_ID_POKEICON,

	PST_CLAN_ID_STIZYO,
	PST_CLAN_ID_FLASH,
	PST_CLAN_ID_ARROW,
	PST_CLAN_ID_MARK,
};
*/

#define	PT_ICON_P1_PX	( 199 )
#define	PT_ICON_P1_PY	( 80 )
#define	PT_ICON_P4_PX	( 63 )
#define	PT_ICON_P4_PY	( 44 )
#define	WT_ICON_P4_PX	( 153 )
#define	WT_ICON_P4_PY	( 43 )
#define	KT_ICON_P4_PX	( 92+16 )
#define	KT_ICON_P4_PY	( 64 )
#define	POKE_ICON_PX	( 24 )
#define	POKE_ICON_PY	( 40 )


//============================================================================================
//============================================================================================
static void AddCellActMake( PST_WORK * wk );
static void PokeStatus_TypeIconChange( PST_WORK * wk, u8 act_num, u8 res_id, u8 type );
static void InitObjCharPalChg( PST_WORK * wk );


//============================================================================================
//============================================================================================



//---------------------------------------------------------------------------------------------
/**
 * ZAN^[
 *
 * @param	wk		[N
 *
 * @return	none
 */
//---------------------------------------------------------------------------------------------
void PokeStatusCellActInit( PST_WORK * wk )
{
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );		// MAIN DISP OBJ ON
	GF_Disp_GXS_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );		// SUB DISP OBJ ON

	initVramTransferManagerHeap( 32, HEAPID_POKESTATUS );

	wk->csp = CATS_AllocMemory( HEAPID_POKESTATUS );
	wk->crp = CATS_ResourceCreate( wk->csp );

	{
		TCATS_OAM_INIT	coi = {
			0, 128,
			0, 32,
			0, 128,
			0, 32,
		};
		TCATS_CHAR_MANAGER_MAKE ccmm = {
			PST_OBJ_MAX,
			1024,
			1024,
			GX_OBJVRAMMODE_CHAR_1D_32K,
			GX_OBJVRAMMODE_CHAR_1D_32K
		};
		CATS_SystemInit( wk->csp, &coi, &ccmm, 32 );
		CATS_ClactSetInit( wk->csp, wk->crp, PST_OBJ_MAX );
	}

	{
		TCATS_RESOURCE_FILE_LIST list = {
			"data/pst_chr.resdat",		// LN^
			"data/pst_pal.resdat",		// pbg
			"data/pst_cell.resdat",		// Z
			"data/pst_canm.resdat",		// ZAj
			NULL,						// }`Z
			NULL,						// }`ZAj
			"data/pst_h.cldat"			// wb_[
		};
		CATS_ResourceLoadBinary( wk->csp, wk->crp, &list );
	}
}

//---------------------------------------------------------------------------------------------
/**
 * ZAN^[폜
 *
 * @param	wk		[N
 *
 * @return	none
 */
//---------------------------------------------------------------------------------------------
void PokeStatusCellActRerease( PST_WORK * wk )
{
	CATS_ResourceDestructor( wk->csp, wk->crp );
	CATS_FreeMemory( wk->csp );
}


void PokeStatus_CellActAnm( PST_WORK * wk )
{
	CLACT_AnmFrameChg( wk->awp[PST_OBJ_ARROW_L], FX32_ONE );
	CLACT_AnmFrameChg( wk->awp[PST_OBJ_ARROW_R], FX32_ONE );
	CLACT_AnmFrameChg( wk->awp[PST_OBJ_BUTTON_EF], FX32_ONE );
}



#define	TAB_PX	( 128 )
#define	TAB_PY	( 24 )

#define	BALL_PX	( 16 )
#define	BALL_PY	( 24 )

#define	WAZACURSOR_PX	( 195 )
#define	WAZACURSOR_PY	( 48 )

#define	ST_ICON_PX	( 80 )
#define	ST_ICON_PY	( 44 )

#define	TAB_ARROW_PY	( 24 )

#define	BOX_MARK_PX	( 48 )
#define	BOX_MARK_PY	( 152 )

#define	FLASH_PX	( 152 )
#define	FLASH_PY	( 168 )

static const TCATS_OBJECT_ADD_PARAM	ActAddParam[] =
{
	{
		PST_CHR_ID_TAB,
		TAB_PX, TAB_PY, 0,
		0, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{
		PST_CHR_ID_TAB,
		TAB_PX+16, TAB_PY, 0,
		1, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{
		PST_CHR_ID_TAB,
		TAB_PX+32, TAB_PY, 0,
		2, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{
		PST_CHR_ID_TAB,
		TAB_PX+48, TAB_PY, 0,
		3, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{
		PST_CHR_ID_TAB,
		TAB_PX+64, TAB_PY, 0,
		4, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{
		PST_CHR_ID_TAB,
		TAB_PX+80, TAB_PY, 0,
		5, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{
		PST_CHR_ID_TAB,
		TAB_PX+96, TAB_PY, 0,
		6, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},

	{
		PST_CHR_ID_BALL,
		BALL_PX, BALL_PY, 0,
		0, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},

	{
		PST_CHR_ID_WAZACURSOR,
		WAZACURSOR_PX, WAZACURSOR_PY, 0,
		0, 1, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},

	{
		PST_CHR_ID_WAZACURSOR,
		WAZACURSOR_PX, WAZACURSOR_PY, 0,
		1, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// |P^CvP
		PST_CHR_ID_POKETYPE1,
		0, 0, 0,
		0, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// |P^CvQ
		PST_CHR_ID_POKETYPE2,
		0, 0, 0,
		0, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// Z^CvP
		PST_CHR_ID_WAZATYPE1,
		0, 0, 0,
		0, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// Z^CvQ
		PST_CHR_ID_WAZATYPE2,
		0, 0, 0,
		0, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// Z^CvR
		PST_CHR_ID_WAZATYPE3,
		0, 0, 0,
		0, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// Z^CvS
		PST_CHR_ID_WAZATYPE4,
		0, 0, 0,
		0, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// Z^CvT
		PST_CHR_ID_WAZATYPE5,
		0, 0, 0,
		0, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// Z
		PST_CHR_ID_WAZAKIND,
		0, 0, 0,
		0, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},

	{	// |PACR
		PST_CHR_ID_POKEICON,
		POKE_ICON_PX, POKE_ICON_PY, 0,
		0, 0, 4, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},

	{	// ԈُACR
		PST_CHR_ID_STIZYO,
		ST_ICON_PX, ST_ICON_PY, 0,
		0, 0, 11, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ^u؂ւE
		PST_CHR_ID_ARROW,
		0, TAB_ARROW_PY, 0,
		0, 0, 3, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ^u؂ւEE
		PST_CHR_ID_ARROW,
		0, TAB_ARROW_PY, 0,
		1, 0, 3, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// {bNX}[NP
		PST_CHR_ID_MARK,
		BOX_MARK_PX, BOX_MARK_PY, 0,
		0, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// {bNX}[NQ
		PST_CHR_ID_MARK,
		BOX_MARK_PX+8, BOX_MARK_PY, 0,
		4, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// {bNX}[NR
		PST_CHR_ID_MARK,
		BOX_MARK_PX+16, BOX_MARK_PY, 0,
		3, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// {bNX}[NS
		PST_CHR_ID_MARK,
		BOX_MARK_PX+24, BOX_MARK_PY, 0,
		5, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// {bNX}[NT
		PST_CHR_ID_MARK,
		BOX_MARK_PX+32, BOX_MARK_PY, 0,
		1, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// {bNX}[NU
		PST_CHR_ID_MARK,
		BOX_MARK_PX+40, BOX_MARK_PY, 0,
		2, 0, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ÂP
		PST_CHR_ID_FLASH,
		FLASH_PX, FLASH_PY, 0,
		0, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ÂQ
		PST_CHR_ID_FLASH,
		FLASH_PX+8, FLASH_PY, 0,
		0, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ÂR
		PST_CHR_ID_FLASH,
		FLASH_PX+16, FLASH_PY, 0,
		0, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ÂS
		PST_CHR_ID_FLASH,
		FLASH_PX+24, FLASH_PY, 0,
		0, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ÂT
		PST_CHR_ID_FLASH,
		FLASH_PX+32, FLASH_PY, 0,
		0, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ÂU
		PST_CHR_ID_FLASH,
		FLASH_PX+40, FLASH_PY, 0,
		0, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ÂV
		PST_CHR_ID_FLASH,
		FLASH_PX+48, FLASH_PY, 0,
		0, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ÂW
		PST_CHR_ID_FLASH,
		FLASH_PX+56, FLASH_PY, 0,
		0, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ÂX
		PST_CHR_ID_FLASH,
		FLASH_PX+64, FLASH_PY, 0,
		0, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ÂPO
		PST_CHR_ID_FLASH,
		FLASH_PX+72, FLASH_PY, 0,
		0, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ÂPP
		PST_CHR_ID_FLASH,
		FLASH_PX+80, FLASH_PY, 0,
		0, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ÂPQ
		PST_CHR_ID_FLASH,
		FLASH_PX+88, FLASH_PY, 0,
		0, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// {^GtFNg
		PST_CHR_ID_BUTTON_EF,
		0, 0, 0, 
		0, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// uUPvP
		PST_CHR_ID_CNDITION_UP,
		26*8, 6*8, 0,
		0, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// uUPvQ
		PST_CHR_ID_CNDITION_UP,
		28*8, 11*8, 0,
		0, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// uUPvR
		PST_CHR_ID_CNDITION_UP,
		27*8, 15*8, 0,
		0, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// uUPvS
		PST_CHR_ID_CNDITION_UP,
		18*8, 15*8, 0,
		0, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// uUPvT
		PST_CHR_ID_CNDITION_UP,
		17*8, 11*8, 0,
		0, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
};



void PokeStatusCellActSet( PST_WORK * wk )
{
	u16	i;

	for( i=0; i<PST_OBJ_MAX; i++ ){
		wk->awp[i] = CATS_ObjectAdd( wk->csp, wk->crp, &ActAddParam[i] );
	}

	InitObjCharPalChg( wk );

	CLACT_SetDrawFlag( wk->awp[PST_OBJ_WAZACURSOR1], 0 );
	CLACT_SetDrawFlag( wk->awp[PST_OBJ_WAZACURSOR2], 0 );
	CLACT_SetDrawFlag( wk->awp[PST_OBJ_BUTTON_EF], 0 );

	CLACT_SetDrawFlag( wk->awp[PST_OBJ_UP1], 0 );
	CLACT_SetDrawFlag( wk->awp[PST_OBJ_UP2], 0 );
	CLACT_SetDrawFlag( wk->awp[PST_OBJ_UP3], 0 );
	CLACT_SetDrawFlag( wk->awp[PST_OBJ_UP4], 0 );
	CLACT_SetDrawFlag( wk->awp[PST_OBJ_UP5], 0 );
}



#define	TAB_CENTER_PX	( 23 * 8 + 4 )
#define	TAB_SEL_SX		( 24 )
#define	TAB_NOSEL_SX	( 16 )

static u8 PST_TabPosXGet( PST_WORK * wk )
{
	u8	i, num=0;

	//	^u`FbN
	for( i=0; i<PST_PAGE_MAX; i++ ){
		if( PokeStatus_PageCheck( wk, i ) != 0 ){
			num++;
		}
	}
	return ( TAB_CENTER_PX - ( TAB_SEL_SX + (num-1)*TAB_NOSEL_SX ) / 2 );
}


void PokeStatusTabPosChg( PST_WORK * wk )
{
	CLACT_WORK_PTR * awp;
	s16	x, y;
	s16	px;
	u16	anm;
	u8	i;
	u8	num=0;

	px = PST_TabPosXGet( wk );

	awp = &wk->awp[PST_OBJ_TAB_INFO];
	num = 0;
	for( i=0; i<PST_PAGE_MAX; i++ ){
		if( PokeStatus_PageCheck( wk, i ) == 0 ){
			CLACT_SetDrawFlag( awp[i], 0 );
			continue;
		}

		anm = CLACT_AnmGet( awp[i] );
		if( wk->page == i ){
			CLACT_AnmChg( awp[i], anm + 7 );
		}else{
			if( anm >= 7 ){
				CLACT_AnmChg( awp[i], anm-7 );
			}
		}

		CATS_ObjectPosGet( awp[i], &x, &y );
		if( wk->page >= i ){
			x = px + num * TAB_NOSEL_SX;
		}else{
			x = px + TAB_SEL_SX + (num-1)*TAB_NOSEL_SX;
		}
		CATS_ObjectPosSet( wk->awp[i], x, y );
		num++;
	}
}


void PokeStatus_TabArrowPut( PST_WORK * wk )
{
	u8	px;

	px = PST_TabPosXGet( wk );

	CATS_ObjectPosSet( wk->awp[PST_OBJ_ARROW_L], px-16, TAB_ARROW_PY );
	CATS_ObjectPosSet(
		wk->awp[PST_OBJ_ARROW_R], TAB_CENTER_PX + (TAB_CENTER_PX-px), TAB_ARROW_PY );
}

void PokeStatus_TabArrowVanish( PST_WORK * wk, u8 flg )
{
	CLACT_SetDrawFlag( wk->awp[PST_OBJ_ARROW_L], flg );
	CLACT_SetDrawFlag( wk->awp[PST_OBJ_ARROW_R], flg );
}


void PokeStatusBallAnmChg( PST_WORK * wk )
{
	CLACT_AnmChg( wk->awp[PST_OBJ_BALL], wk->pp.ball );
}

void PokeStatus_StIconChg( PST_WORK * wk )
{
	u32	anm = PokeStatus_BadStatusIconAnmGet( wk );

	if( anm == ST_ICON_NONE ){
		CLACT_SetDrawFlag( wk->awp[PST_OBJ_STIZYO], 0 );
		return;
	}
	CLACT_SetDrawFlag( wk->awp[PST_OBJ_STIZYO], 1 );
	CLACT_AnmChg( wk->awp[PST_OBJ_STIZYO], anm );
}





//--------------------------------------------------------------------------------------------
/**
 * ZACROBJZbg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------

static void InitObjCharPalChg( PST_WORK * wk )
{
	u16	i;

	// |P̑ACR
	PokeStatus_PokeTypeChange( wk );
	// Z
	for( i=0; i<4; i++ ){
		if( wk->pp.waza[i] == 0 ){ continue; }
		PokeStatus_TypeIconChange(
			wk, PST_OBJ_TYPE_WAZA1+i, PST_CHR_ID_WAZATYPE1+i,
			WT_WazaDataParaGet(wk->pp.waza[i],ID_WTD_wazatype) );
	}
	// |PACR
	PokeStasus_PokeIconChange( wk );
}



void PokeStatus_PageTypeIconDrow( PST_WORK * wk )
{
	u16	i;

	for( i=PST_OBJ_TYPE_POKE1; i<=PST_OBJ_POKEICON; i++ ){
		CATS_ObjectEnable( wk->awp[i], 0 );
	}

	switch( wk->page ){
	case PST_PAGE_INFO:
		CATS_ObjectEnable( wk->awp[PST_OBJ_TYPE_POKE1], 1 );
		CATS_ObjectPosSet( wk->awp[PST_OBJ_TYPE_POKE1], PT_ICON_P1_PX, PT_ICON_P1_PY );
		if( wk->pp.type1 != wk->pp.type2 ){
			CATS_ObjectEnable( wk->awp[PST_OBJ_TYPE_POKE2], 1 );
			CATS_ObjectPosSet(
				wk->awp[PST_OBJ_TYPE_POKE2], PT_ICON_P1_PX+34, PT_ICON_P1_PY );
		}
		break;

	case PST_PAGE_B_SKILL:
		for( i=0; i<4; i++ ){
			if( wk->pp.waza[i] == 0 ){ continue; }
			PokeStatus_TypeIconChange(
				wk, PST_OBJ_TYPE_WAZA1+i, PST_CHR_ID_WAZATYPE1+i,
				WT_WazaDataParaGet(wk->pp.waza[i],ID_WTD_wazatype) );
			CATS_ObjectEnable( wk->awp[PST_OBJ_TYPE_WAZA1+i], 1 );
			CATS_ObjectPosSet(
				wk->awp[PST_OBJ_TYPE_WAZA1+i], WT_ICON_P4_PX, WT_ICON_P4_PY+i*32 );
		}
		if( wk->dat->waza != 0 ){
			PokeStatus_TypeIconChange(
				wk, PST_OBJ_TYPE_WAZA1+4, PST_CHR_ID_WAZATYPE1+4,
				WT_WazaDataParaGet(wk->dat->waza,ID_WTD_wazatype) );
			CATS_ObjectEnable( wk->awp[PST_OBJ_TYPE_WAZA1+4], 1 );
			CATS_ObjectPosSet(
				wk->awp[PST_OBJ_TYPE_WAZA1+4], WT_ICON_P4_PX, WT_ICON_P4_PY+4*32 );
		}
		CATS_ObjectPosSet( wk->awp[PST_OBJ_TYPE_POKE1], PT_ICON_P4_PX, PT_ICON_P4_PY );
		CATS_ObjectPosSet( wk->awp[PST_OBJ_TYPE_POKE2], PT_ICON_P4_PX+34, PT_ICON_P4_PY );
		CATS_ObjectPosSet( wk->awp[PST_OBJ_TYPE_KIND], KT_ICON_P4_PX, KT_ICON_P4_PY );
		break;

	case PST_PAGE_C_SKILL:
		for( i=0; i<4; i++ ){
			if( wk->pp.waza[i] == 0 ){ continue; }
			PokeStatus_TypeIconChange(
				wk, PST_OBJ_TYPE_WAZA1+i, PST_CHR_ID_WAZATYPE1+i,
				WT_WazaDataParaGet(wk->pp.waza[i],ID_WTD_contype)+ICONTYPE_STYLE );
			CATS_ObjectEnable( wk->awp[PST_OBJ_TYPE_WAZA1+i], 1 );
			CATS_ObjectPosSet(
				wk->awp[PST_OBJ_TYPE_WAZA1+i], WT_ICON_P4_PX, WT_ICON_P4_PY+i*32 );
		}
		if( wk->dat->waza != 0 ){
			PokeStatus_TypeIconChange(
				wk, PST_OBJ_TYPE_WAZA1+4, PST_CHR_ID_WAZATYPE1+4,
				WT_WazaDataParaGet(wk->dat->waza,ID_WTD_contype)+ICONTYPE_STYLE );
			CATS_ObjectEnable( wk->awp[PST_OBJ_TYPE_WAZA1+4], 1 );
			CATS_ObjectPosSet(
				wk->awp[PST_OBJ_TYPE_WAZA1+4], WT_ICON_P4_PX, WT_ICON_P4_PY+4*32 );
		}
		CATS_ObjectPosSet( wk->awp[PST_OBJ_TYPE_POKE1], PT_ICON_P4_PX, PT_ICON_P4_PY );
		CATS_ObjectPosSet( wk->awp[PST_OBJ_TYPE_POKE2], PT_ICON_P4_PX+34, PT_ICON_P4_PY );
		CATS_ObjectPosSet( wk->awp[PST_OBJ_TYPE_KIND], KT_ICON_P4_PX, KT_ICON_P4_PY );
		break;
	}
}

void PokeStatus_PokeTypeChange( PST_WORK * wk )
{
	PokeStatus_TypeIconChange( wk, PST_OBJ_TYPE_POKE1, PST_CHR_ID_POKETYPE1, wk->pp.type1 );
	PokeStatus_TypeIconChange( wk, PST_OBJ_TYPE_POKE2, PST_CHR_ID_POKETYPE2, wk->pp.type2 );
}

static void PokeStatus_TypeIconChange( PST_WORK * wk, u8 act_num, u8 res_id, u8 type )
{
	CATS_ChangeResourceCharArc(
		wk->csp, wk->crp, WazaTypeIcon_ArcIDGet(),
		WazaTypeIcon_CgrIDGet(type), WAZATYPEICON_COMP_CHAR, res_id );

	CATS_ObjectPaletteSet( wk->awp[act_num], WazaTypeIcon_PlttOffsetGet(type)+5 );

}


static void WazaTypeChgPosGet( PST_WORK * wk, u8 * pos, s16 * x, s16 * y )
{
	s16	i, py;

	py = WT_ICON_P4_PY+*pos*32;

	for( i=0; i<4; i++ ){
		CATS_ObjectPosGet( wk->awp[PST_OBJ_TYPE_WAZA1+i], x, y );
		if( py == *y ){
			*pos = (u8)i;
			break;
		}
	}
}

void PokeStatus_WazaTypePosChange( PST_WORK * wk, u8 pos1, u8 pos2 )
{
	s16	x1, y1, x2, y2;

	WazaTypeChgPosGet( wk, &pos1, &x1, &y1 );
	WazaTypeChgPosGet( wk, &pos2, &x2, &y2 );

	CATS_ObjectPosSet( wk->awp[PST_OBJ_TYPE_WAZA1+pos1], x2, y2 );
	CATS_ObjectPosSet( wk->awp[PST_OBJ_TYPE_WAZA1+pos2], x1, y1 );
}

void PokeStatus_KindIconChange( PST_WORK * wk, u32 waza )
{
	u32	kind = WT_WazaDataParaGet( waza, ID_WTD_kind );

	CATS_ChangeResourceCharArc(
		wk->csp, wk->crp, WazaKindIcon_ArcIDGet(),
		WazaKindIcon_CgrIDGet(kind), WAZAKINDICON_COMP_CHAR, PST_CHR_ID_WAZAKIND );

	CATS_ObjectPaletteSet( wk->awp[PST_OBJ_TYPE_KIND], WazaKindIcon_PlttOffsetGet(kind)+5 );
}

void PokeStasus_PokeIconChange( PST_WORK * wk )
{
	void * pp = PokeStatusPokeParamGet( wk );
	u32	cgx_arc;

	if( wk->dat->ppt == PST_PP_TYPE_POKEPASO ){
		cgx_arc = PokeIconCgxArcIndexGet( pp );
	}else{
		cgx_arc = PokeIconCgxArcIndexGetByPP( pp );
	}

	CATS_ChangeResourceCharArc(
		wk->csp, wk->crp, ARC_POKEICON, cgx_arc, 0, PST_CHR_ID_POKEICON );

	CATS_ObjectPaletteSet( wk->awp[PST_OBJ_POKEICON], PokeIconPaletteIDGet(wk->pp.mons)+8 );

	CLACT_SetFlip(
		wk->awp[PST_OBJ_POKEICON],
		(PokePersonalParaGet( wk->pp.mons, ID_PER_reverse )^1) );
}


//--------------------------------------------------------------------------------------------
/**
 * ZJ[\ړ
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PokeStatus_WazaCursorMove( PST_WORK * wk )
{
	CATS_ObjectPosSet(
		wk->awp[PST_OBJ_WAZACURSOR1], WAZACURSOR_PX, WAZACURSOR_PY + wk->cur_pos*32 );
}

void PokeStatus_SubWazaCursorSet( PST_WORK * wk )
{
	s16	x, y;

	CATS_ObjectPosGet( wk->awp[PST_OBJ_WAZACURSOR1], &x, &y );
	CATS_ObjectPosSet( wk->awp[PST_OBJ_WAZACURSOR2], x, y );
	CLACT_SetDrawFlag( wk->awp[PST_OBJ_WAZACURSOR2], 1 );
}




void PokeStatus_KezuyaInit( PST_WORK * wk )
{
	u32	i;

	wk->flash_seq = 0;
	wk->flash_cnt = 0;
	wk->flash_pos = 0;
/*
	if( wk->pp.fur == 0 ){
		wk->flash_max = 0;
	}else if( wk->pp.fur == 255 ){
		wk->flash_max = 12;
	}else{
		wk->flash_max = wk->pp.fur/(((255<<8)/12)>>8);
	}
*/
	wk->flash_max = 12;

	for( i=PST_OBJ_FLASH1; i<=PST_OBJ_FLASH12; i++ ){
		CLACT_SetDrawFlag( wk->awp[i], 0 );
		CLACT_AnmFrameSet( wk->awp[i], 0 );
	}
}

void PokeStatus_KezuyaAnm( PST_WORK * wk )
{
	u32	i;

	if( wk->page != PST_PAGE_CONDITION ){
		return;
	}

	if( wk->flash_max == 0 ){ return; }

	switch( wk->flash_seq ){
	case 0:
		wk->flash_cnt++;
		if( wk->flash_cnt == 8 ){
			wk->flash_seq = 1;
			wk->flash_cnt = 0;
			wk->flash_pos = 0;
		}
		break;

	case 1:
		if( wk->flash_cnt == 0 ){
			CLACT_SetDrawFlag( wk->awp[PST_OBJ_FLASH1+wk->flash_pos], 1 );
			CLACT_AnmFrameSet( wk->awp[PST_OBJ_FLASH1+wk->flash_pos], 0 );
			wk->flash_pos++;
			if( wk->flash_pos == wk->flash_max ){
				wk->flash_seq = 2;
				break;
			}
		}
//		wk->flash_cnt = (wk->flash_cnt+1) & 7;
		wk->flash_cnt = (wk->flash_cnt+1) % 10;
		break;

	case 2:
		if( CLACT_GetDrawFlag( wk->awp[wk->flash_max-1] ) == 0 ){
//		if( CLACT_AnmFrameGet( wk->awp[wk->flash_max-1] ) == 5 ){
			wk->flash_seq = 3;
			break;
		}
		break;

	case 3:
		wk->flash_cnt++;
		if( wk->flash_cnt == 32 ){
			for( i=PST_OBJ_FLASH1; i<PST_OBJ_FLASH1+wk->flash_max; i++ ){
				CLACT_SetDrawFlag( wk->awp[i], 1 );
				CLACT_AnmFrameSet( wk->awp[i], 0 );
			}
			wk->flash_seq = 4;
			wk->flash_cnt = 0;
		}
		break;

	case 4:
		wk->flash_cnt++;
		if( wk->flash_cnt == 32 ){
			wk->flash_seq = 0;
			wk->flash_cnt = 0;
			wk->flash_pos = 0;
		}
		break;
	}

	for( i=PST_OBJ_FLASH1; i<PST_OBJ_FLASH1+wk->flash_max; i++ ){
		if( CLACT_GetDrawFlag( wk->awp[i] ) == 0 ){ continue; }
		CLACT_AnmFrameChg( wk->awp[i], FX32_ONE );

		if( CLACT_AnmFrameGet( wk->awp[i] ) == 6 ){
			CLACT_SetDrawFlag( wk->awp[i], 0 );
		}

	}
}


void PokeStatus_MarkChg( PST_WORK * wk )
{
	u32	i;

	for( i=0; i<6; i++ ){
		if( wk->pp.mark & (1<<i) ){
			CATS_ObjectPaletteSet( wk->awp[PST_OBJ_MARK1+i], 2 );
		}else{
			CATS_ObjectPaletteSet( wk->awp[PST_OBJ_MARK1+i], 1 );
		}
	}
}



void PokeStatus_ButtonEffInit( PST_WORK * wk )
{
	s16	x, y;

	CLACT_SetDrawFlag( wk->awp[PST_OBJ_BUTTON_EF], 1 );
	CLACT_AnmFrameSet( wk->awp[PST_OBJ_BUTTON_EF], 0 );
	CLACT_AnmChg( wk->awp[PST_OBJ_BUTTON_EF], 0 );

	PokeStatus_ButtonPosGet( wk, &x, &y );
	CATS_ObjectPosSet( wk->awp[PST_OBJ_BUTTON_EF], x, y+192 );
}

void PokeStatus_ButtonEffEnd( PST_WORK * wk )
{
	CLACT_SetDrawFlag( wk->awp[PST_OBJ_BUTTON_EF], 0 );
}



void PokeStatus_CondUpObjPut( PST_WORK * wk )
{
	u8	i;

	for( i=0; i<5; i++ ){
		if( ( wk->sub_seq & (1<<i) ) ){
			CLACT_SetDrawFlag( wk->awp[PST_OBJ_UP1+i], 1 );
		}
	}
}
