//============================================================================================
/**
 * @file	pms_input_data.c
 * @bfief	ȈՉb͉ʁiJeSECjṼf[^Ǘj
 * @author	taya
 * @date	06.01.28
 */
//============================================================================================
#include "common.h"
#include "gflib\heapsys.h"
#include "system\pms_word.h"
#include "savedata\zukanwork.h"


#include "pms_input_prv.h"


#define __PMS_INPUT_RES__
#include "pms_input.res"


#define  WORD_ENABLE_FLAG_SIZE		((PMS_WORDNUM_MAX>>3)+1)	// PP =1bitZ

#define  INITIAL_MAX	(NELEMS(PMS_InitialTable))


//--------------------------------------------------------------
/**
 *	f[^ǗIuWFNg
 */
//--------------------------------------------------------------
struct _PMS_INPUT_DATA {
	const PMSI_PARAM*	input_param;
	PMSW_MAN*			word_man;

	u32  GroupEnableWordCnt[ CATEGORY_GROUP_MAX ];

	PMS_WORD*	GroupEnableWord[ CATEGORY_GROUP_MAX ];
	PMS_WORD	GroupEnableWordPokemon1[ PMS_Category_pokemon1_MaxNum ];
	PMS_WORD	GroupEnableWordPokemon2[ PMS_Category_pokemon2_MaxNum ];
	PMS_WORD	GroupEnableWordSkill1[ PMS_Category_skill1_MaxNum ];
	PMS_WORD	GroupEnableWordSkill2[ PMS_Category_skill2_MaxNum ];
	PMS_WORD	GroupEnableWordBattle[ PMS_Category_battle_MaxNum ];
	PMS_WORD	GroupEnableWordStatus[ PMS_Category_status_MaxNum ];

	PMS_WORD	GroupEnableWordVoice [ PMS_Category_voice_MaxNum ];
	PMS_WORD	GroupEnableWordLife  [ PMS_Category_life_MaxNum ];
	PMS_WORD	GroupEnableWordHobby [ PMS_Category_hobby_MaxNum ];
	PMS_WORD	GroupEnableWordRepeat[ PMS_Category_repeat_MaxNum ];



	u32  InitialEnableWordCnt[ INITIAL_MAX ];
	u32  InitialEnableWordPos[ INITIAL_MAX ];

	PMS_WORD  InitialEnableWord[ PMS_WORDNUM_MAX ];

	u8  word_enable_flag[ WORD_ENABLE_FLAG_SIZE ];

};

//==============================================================
// Prototype
//==============================================================
static void SetupGroupEnableFlag( PMS_INPUT_DATA* pmsi );
static inline void SetWordEnableFlag( PMS_INPUT_DATA* data, u32 pos );
static inline BOOL GetWordEnableFlag( const PMS_INPUT_DATA* data, u32 pos );
static u32 CountupGruopPokemon( PMS_INPUT_DATA* pmsi, const PMS_WORD* src_tbl, u32 tbl_elems, PMS_WORD* dst_tbl );
static u32 CountupGruopPokemon2( PMS_INPUT_DATA* pmsi,  const PMS_WORD* src_tbl, u32 tbl_elems, PMS_WORD* dst_tbl );
static u32 CountupGruopSkill( PMS_INPUT_DATA* pmsi,  const PMS_WORD* src_tbl, u32 tbl_elems, PMS_WORD* dst_tbl );
static u32 CountupGruopDefault( PMS_INPUT_DATA* pmsi,  const PMS_WORD* src_tbl, u32 tbl_elems, PMS_WORD* dst_tbl );
static u32 CountCategoryZero( PMS_INPUT_DATA* pmsi,  const PMS_WORD* src_tbl, u32 tbl_elems, PMS_WORD* dst_tbl );
static void SetupInitialEnableFlag( PMS_INPUT_DATA* pmsi );
static u32 CountupInitialWord( PMS_INPUT_DATA* pmsi, const PMS_WORD* src_tbl, PMS_WORD* dst_tbl, u32 dst_pos );


/*====================================================================================================*/
/*                                                                                                    */
/*  IuWFNg̍\zEj                                                                          */
/*                                                                                                    */
/*====================================================================================================*/
//------------------------------------------------------------------
/**
 * f[^ǗIuWFNg\z
 *
 * @param   heapID		
 * @param   savedata		
 *
 * @retval  PMS_INPUT_DATA*		
 */
//------------------------------------------------------------------
PMS_INPUT_DATA* PMSI_DATA_Create( u32 heapID, const PMSI_PARAM* input_param )
{
	PMS_INPUT_DATA*  pmsi;
	int i;

	pmsi = sys_AllocMemory( heapID, sizeof(PMS_INPUT_DATA) );

	pmsi->input_param = input_param;
	pmsi->word_man = PMSW_MAN_Create( heapID );
	for(i=0; i<WORD_ENABLE_FLAG_SIZE; i++)
	{
		pmsi->word_enable_flag[i] = 0;
	}

	SetupGroupEnableFlag( pmsi );
	SetupInitialEnableFlag( pmsi );

	return pmsi;
}
//------------------------------------------------------------------
/**
 * f[^ǗIuWFNgj
 *
 * @param   heapID		
 *
 * @retval  PMS_INPUT_DATA*		
 */
//------------------------------------------------------------------
void PMSI_DATA_Delete( PMS_INPUT_DATA* pmsi )
{
	if( pmsi )
	{
		PMSW_MAN_Delete( pmsi->word_man );
		sys_FreeMemoryEz( pmsi );
	}
}


/*====================================================================================================*/
/*                                                                                                    */
/*  JeSƂ̗LPꐔJEgPIDe[u                                                */
/*                                                                                                    */
/*====================================================================================================*/
//------------------------------------------------------------------
/**
 * 
 *
 * @param   pmsi		
 *
 */
//------------------------------------------------------------------
static void SetupGroupEnableFlag( PMS_INPUT_DATA* pmsi )
{
	typedef u32 (*CountupFunc)( PMS_INPUT_DATA*, const PMS_WORD*, u32, PMS_WORD* );

	static const struct {
		CountupFunc      func;
		const PMS_WORD*  src_tbl;
		u32              tbl_elems;
	}CountupParam[] = {
		{ CountupGruopPokemon,  PMS_CategoryTable_pokemon1, PMS_Category_pokemon1_MaxNum },	// |P
		{ CountupGruopPokemon2, PMS_CategoryTable_pokemon2, PMS_Category_pokemon2_MaxNum },	// |PQ
		{ CountupGruopSkill,    PMS_CategoryTable_skill1,   PMS_Category_skill1_MaxNum },	// 킴
		{ CountupGruopSkill,    PMS_CategoryTable_skill2,   PMS_Category_skill2_MaxNum },	// 킴Q
		{ CountupGruopDefault,  PMS_CategoryTable_battle,   PMS_Category_battle_MaxNum },	// og
		{ CountupGruopDefault,  PMS_CategoryTable_status,   PMS_Category_status_MaxNum },	// Xe[^X
		{ CountupGruopDefault,  PMS_CategoryTable_voice,    PMS_Category_voice_MaxNum },	// 
		{ CountupGruopDefault,  PMS_CategoryTable_life,     PMS_Category_life_MaxNum },		// 
		{ CountupGruopDefault,  PMS_CategoryTable_hobby,    PMS_Category_hobby_MaxNum },	// 
		{ CountupGruopDefault,  PMS_CategoryTable_repeat,   PMS_Category_repeat_MaxNum },	// 肩

		// 牺͂Ƃ肠[ɂĂ
		{ CountCategoryZero,    PMS_CategoryTable_status,   PMS_Category_status_MaxNum },	// 
		{ CountCategoryZero,    PMS_CategoryTable_status,   PMS_Category_status_MaxNum },	// Ƃ

	};
	int i;

	for(i=0; i<CATEGORY_GROUP_MAX; i++)
	{
		switch(i){
		case CATEGORY_GROUP_POKEMON:	pmsi->GroupEnableWord[i] = pmsi->GroupEnableWordPokemon1; break;
		case CATEGORY_GROUP_POKEMON2:	pmsi->GroupEnableWord[i] = pmsi->GroupEnableWordPokemon2; break;
		case CATEGORY_GROUP_SKILL:	pmsi->GroupEnableWord[i] = pmsi->GroupEnableWordSkill1; break;
		case CATEGORY_GROUP_SKILL2:	pmsi->GroupEnableWord[i] = pmsi->GroupEnableWordSkill2; break;
		case CATEGORY_GROUP_BATTLE:	pmsi->GroupEnableWord[i] = pmsi->GroupEnableWordBattle; break;
		case CATEGORY_GROUP_STATUS:	pmsi->GroupEnableWord[i] = pmsi->GroupEnableWordStatus; break;

		case CATEGORY_GROUP_VOICE:	pmsi->GroupEnableWord[i] = pmsi->GroupEnableWordVoice; break;
		case CATEGORY_GROUP_HOBBY:	pmsi->GroupEnableWord[i] = pmsi->GroupEnableWordHobby; break;
		case CATEGORY_GROUP_LIFE:	pmsi->GroupEnableWord[i] = pmsi->GroupEnableWordLife; break;
		case CATEGORY_GROUP_REPEAT:	pmsi->GroupEnableWord[i] = pmsi->GroupEnableWordRepeat; break;

		}

		pmsi->GroupEnableWordCnt[i] = CountupParam[i].func( pmsi, CountupParam[i].src_tbl, CountupParam[i].tbl_elems,
											pmsi->GroupEnableWord[i] );
	}

}

static inline void SetWordEnableFlag( PMS_INPUT_DATA* data, u32 pos )
{
	data->word_enable_flag[ (pos >> 3) ] |= (1 << (pos & 7));
}

static inline BOOL GetWordEnableFlag( const PMS_INPUT_DATA* data, u32 pos )
{
	return (data->word_enable_flag[ (pos >> 3) ] & (1 << (pos & 7))) != 0;
}

static u32 CountupGruopPokemon( PMS_INPUT_DATA* pmsi, const PMS_WORD* src_tbl, u32 tbl_elems, PMS_WORD* dst_tbl )
{
	const ZUKAN_WORK* zw;
	u32 i, cnt;

	cnt = 0;
	zw = PMSI_PARAM_GetZukanSaveData( pmsi->input_param );
	for(i=0; i<tbl_elems; i++)
	{
		if( ZukanWork_GetPokeSeeFlag( zw, src_tbl[i] ) )
		{
			SetWordEnableFlag( pmsi, src_tbl[i] );
			*dst_tbl++ = src_tbl[i];
			cnt++;
		}
	}

	return cnt;
}

static u32 CountupGruopPokemon2( PMS_INPUT_DATA* pmsi,  const PMS_WORD* src_tbl, u32 tbl_elems, PMS_WORD* dst_tbl )
{
	const ZUKAN_WORK* zw;
	u32 i, cnt;

	cnt = 0;
	zw = PMSI_PARAM_GetZukanSaveData( pmsi->input_param );

	if( ZukanWork_GetZenkokuZukanFlag(zw) )
	{
		for(i=0; i<tbl_elems; i++)
		{
			SetWordEnableFlag( pmsi, *src_tbl );
			*dst_tbl++ = *src_tbl++;
		}
		return tbl_elems;
	}
	else
	{
		return 0;
	}

}
static u32 CountupGruopSkill( PMS_INPUT_DATA* pmsi,  const PMS_WORD* src_tbl, u32 tbl_elems, PMS_WORD* dst_tbl )
{
	u32 i;

	// NAĂSOK
	if( PMSI_PARAM_GetGameClearFlag(pmsi->input_param) )
	{
		for(i=0; i<tbl_elems; i++)
		{
			SetWordEnableFlag( pmsi, *src_tbl );
			*dst_tbl++ = *src_tbl++;
		}
		return tbl_elems;
	}
	else
	{
		return 0;
	}
}
static u32 CountupGruopDefault( PMS_INPUT_DATA* pmsi,  const PMS_WORD* src_tbl, u32 tbl_elems, PMS_WORD* dst_tbl )
{
	u32 i;

	for(i=0; i<tbl_elems; i++)
	{
		if( *src_tbl == PMS_WORDID_DUP )
		{
			u32 dup;

			src_tbl++;
			dup = *src_tbl++;
			*dst_tbl = *src_tbl;
			while( dup )
			{
				SetWordEnableFlag( pmsi, *src_tbl++ );
				dup--;
			}
		}
		else
		{
			SetWordEnableFlag( pmsi, *src_tbl );
			*dst_tbl++ = *src_tbl++;
		}
	}

	return tbl_elems;
}
#ifdef PM_DEBUG
static u32 CountCategoryZero( PMS_INPUT_DATA* pmsi,  const PMS_WORD* src_tbl, u32 tbl_elems, PMS_WORD* dst_tbl )
{
	return 0;
}
#endif

/*====================================================================================================*/
/*                                                                                                    */
/*  Ƃ̗LPꐔJEgPIDe[u                                                  */
/*  iJeSe[u쐬ɍPLtOQƂj                                        */
/*                                                                                                    */
/*====================================================================================================*/
static void SetupInitialEnableFlag( PMS_INPUT_DATA* pmsi )
{
	int i, pos = 0;

	for(i=0; i<NELEMS(PMS_InitialTable); i++)
	{
		pmsi->InitialEnableWordPos[i] = pos;
		pmsi->InitialEnableWordCnt[i] = CountupInitialWord(pmsi, PMS_InitialTable[i], pmsi->InitialEnableWord, pos);
		pos += pmsi->InitialEnableWordCnt[i];
	}
}

static u32 CountupInitialWord( PMS_INPUT_DATA* pmsi, const PMS_WORD* src_tbl, PMS_WORD* dst_tbl, u32 dst_pos )
{
	u32 cnt = 0;

	while( *src_tbl != PMS_WORDID_END )
	{
		if( *src_tbl == PMS_WORDID_DUP )
		{
			u32  dup, i;

			src_tbl++;
			dup = *src_tbl++;
			for(i=0; i<dup; i++)
			{
				if( GetWordEnableFlag(pmsi, src_tbl[i]) )
				{
					dst_tbl[dst_pos++] = src_tbl[i];
					cnt++;
					break;
				}
			}
			src_tbl += dup;
		}
		else
		{
			if( GetWordEnableFlag(pmsi, *src_tbl) )
			{
				dst_tbl[dst_pos++] = *src_tbl;
				cnt++;
			}

			src_tbl++;
		}
	}

	return cnt;
}

/*====================================================================================================*/
/*                                                                                                    */
/*  AvP[Vւ̏                                                                      */
/*                                                                                                    */
/*====================================================================================================*/

//------------------------------------------------------------------
/**
 * JeSO[vɊ܂܂LPꐔ
 *
 * @param   pmsi		f[^ǗIuWFNg
 * @param   group		O[vio[
 *
 * @retval  u32			LPꐔiO炻̃JeŜj
 */
//------------------------------------------------------------------
u32 PMSI_DATA_GetGroupEnableWordCount( const PMS_INPUT_DATA* pmsi, u32 group )
{
	return pmsi->GroupEnableWordCnt[group];
}
//------------------------------------------------------------------
/**
 * JeSO[v̗LP𕶎񉻂ăobt@ɃRs[
 *
 * @param   pmsi			f[^ǗIuWFNg
 * @param   group			O[vio[
 * @param   word_idx		PCfbNXi0`j
 *
 */
//------------------------------------------------------------------
void PMSI_DATA_GetGroupEnableWord( const PMS_INPUT_DATA* pmsi, u32 group, u32 word_idx, STRBUF* buf )
{
	PMSW_MAN_CopyStr( pmsi->word_man, pmsi->GroupEnableWord[group][word_idx], buf );
}

//------------------------------------------------------------------
/**
 * JeSO[v̗LP̓AwԂ̒PR[hԂ
 *
 * @param   pmsi			f[^ǗIuWFNg
 * @param   group			O[vio[
 * @param   word_idx		PCfbNX
 *
 * @retval  PMS_WORD		PR[h
 */
//------------------------------------------------------------------
PMS_WORD  PMSI_DATA_GetGroupEnableWordCode( const PMS_INPUT_DATA* pmsi, u32 group, u32 word_idx )
{
	return pmsi->GroupEnableWord[group][word_idx];
}

//------------------------------------------------------------------
/**
 * CjVO[vɊ܂܂LPꐔ
 *
 * @param   pmsi			f[^ǗIuWFNg
 * @param   initial			CjVio[
 *
 * @retval  u32			LPꐔiO炻̃CjV̂j
 */
//------------------------------------------------------------------
u32 PMSI_DATA_GetInitialEnableWordCount( const PMS_INPUT_DATA* pmsi, u32 initial )
{
	return pmsi->InitialEnableWordCnt[initial];
}

//------------------------------------------------------------------
/**
 * CjVO[v̗LP𕶎񉻂ăobt@ɃRs[
 *
 * @param   pmsi			f[^ǗIuWFNg
 * @param   initial			CjVio[
 * @param   word_idx		PCfbNXi0`j
 *
 */
//------------------------------------------------------------------
void PMSI_DATA_GetInitialEnableWord( const PMS_INPUT_DATA* pmsi, u32 initial, u32 word_idx, STRBUF* buf )
{
	if( pmsi->InitialEnableWordCnt[initial] )
	{
		PMS_WORD  word_code = PMSI_DATA_GetInitialEnableWordCode(pmsi, initial, word_idx);
		PMSW_MAN_CopyStr( pmsi->word_man, word_code, buf );
	}
}

//------------------------------------------------------------------
/**
 * CjVO[v̗LP̓AwԂ̒PR[hԂ
 *
 * @param   pmsi			f[^ǗIuWFNg
 * @param   initial			CjVio[
 * @param   word_idx		PCfbNXi0`j
 *
 */
//------------------------------------------------------------------
PMS_WORD PMSI_DATA_GetInitialEnableWordCode( const PMS_INPUT_DATA* pmsi, u32 initial, u32 word_idx )
{
	if( pmsi->InitialEnableWordCnt[initial] )
	{
		u32 pos = pmsi->InitialEnableWordPos[initial] + word_idx;
		return pmsi->InitialEnableWord[pos];
	}
	else
	{
		return PMS_WORD_NULL;
	}
}

