//============================================================================================
/**
 * @file	pmsi_initial_data.c
 * @bfief	ȈՉb͉ʁiJeSCjV[hp̃f[^e[uj
 * @author	taya
 * @date	06.02.14
 */
//============================================================================================
#include "common.h"
#include "gflib\heapsys.h"
#include "gflib\strbuf_family.h"
#include "system\arc_util.h"
#include "system\window.h"
#include "system\buflen.h"
#include "system\pms_word.h"
#include "system\winframe.naix"
#include "system\msgdata.h"
#include "msgdata\msg_pms_category.h"
#include "msgdata\msg.naix"


#include "pms_input_prv.h"
#include "pms_input_data.h"
#include "pmsi_initial_data.h"

//======================================================================
// CjV[h̑I𕶎e[uiꂲƂɐݒj
//======================================================================

//-------------------------------------------------------------
/**
 *  e̕`敝
 */
//-------------------------------------------------------------
enum {
	INITIAL_WRITE_X_MARGIN = 13,		// PƂ̕`敝
	INITIAL_WRITE_Y_MARGIN = 16,		// PƂ̕`捂
};

#define INITIAL_XPOS(n)	((n)*INITIAL_WRITE_X_MARGIN)
#define INITIAL_YPOS(n)	((n)*INITIAL_WRITE_Y_MARGIN)

//-------------------------------------------------------------
/**
 *  ẽCfbNX
 */
//-------------------------------------------------------------
enum {
	INI_A = 0,
	INI_I,
	INI_U,
	INI_E,
	INI_O,
	INI_KA,
	INI_KI,
	INI_KU,
	INI_KE,
	INI_KO,
	INI_SA,
	INI_SI,
	INI_SU,
	INI_SE,
	INI_SO,
	INI_TA,
	INI_TI,
	INI_TU,
	INI_TE,
	INI_TO,
	INI_NA,
	INI_NI,
	INI_NU,
	INI_NE,
	INI_NO,
	INI_HA,
	INI_HI,
	INI_HU,
	INI_HE,
	INI_HO,
	INI_MA,
	INI_MI,
	INI_MU,
	INI_ME,
	INI_MO,
	INI_YA,
	INI_YU,
	INI_YO,
	INI_RA,
	INI_RI,
	INI_RU,
	INI_RE,
	INI_RO,
	INI_WA,
	INI_OTHER,

	INI_BACK = CATEGORY_POS_BACK,
	INI_DIS  = CATEGORY_POS_DISABLE,
};

static const struct {
	STRCODE		code;
	u8			xpos;
	u8			ypos;
	u8			up;
	u8			down;
	u8			left;
	u8			right;
}InitialParamTbl[] = {

	{  a_,  INITIAL_XPOS(0),  INITIAL_YPOS(0), INI_DIS,     INI_KA,      INI_YO,    INI_I       },
	{  i_,  INITIAL_XPOS(1),  INITIAL_YPOS(0), INI_DIS,     INI_KI,      INI_A,     INI_U       },
	{  u_,  INITIAL_XPOS(2),  INITIAL_YPOS(0), INI_DIS,     INI_KU,      INI_I,     INI_E       },
	{  e_,  INITIAL_XPOS(3),  INITIAL_YPOS(0), INI_DIS,     INI_KE,      INI_U,     INI_O       },
	{  o_,  INITIAL_XPOS(4),  INITIAL_YPOS(0), INI_DIS,     INI_KO,      INI_E,     INI_NA      },
	{ ka_,  INITIAL_XPOS(0),  INITIAL_YPOS(1), INI_A,       INI_SA,      INI_OTHER, INI_KI      },
	{ ki_,  INITIAL_XPOS(1),  INITIAL_YPOS(1), INI_I,       INI_SI,      INI_KA,    INI_KU      },
	{ ku_,  INITIAL_XPOS(2),  INITIAL_YPOS(1), INI_U,       INI_SU,      INI_KI,    INI_KE,     },
	{ ke_,  INITIAL_XPOS(3),  INITIAL_YPOS(1), INI_E,       INI_SE,      INI_KU,    INI_KO,     },
	{ ko_,  INITIAL_XPOS(4),  INITIAL_YPOS(1), INI_O,       INI_SO,      INI_KE,    INI_HA,     },
	{ sa_,  INITIAL_XPOS(0),  INITIAL_YPOS(2), INI_KA,      INI_TA,      INI_MO,    INI_SI,     },
	{ si_,  INITIAL_XPOS(1),  INITIAL_YPOS(2), INI_KI,      INI_TI,      INI_SA,    INI_SU,     },
	{ su_,  INITIAL_XPOS(2),  INITIAL_YPOS(2), INI_KU,      INI_TU,      INI_SI,    INI_SE,     },
	{ se_,  INITIAL_XPOS(3),  INITIAL_YPOS(2), INI_KE,      INI_TE,      INI_SU,    INI_SO,     },
	{ so_,  INITIAL_XPOS(4),  INITIAL_YPOS(2), INI_KO,      INI_TO,      INI_SE,    INI_MA,     },
	{ ta_,  INITIAL_XPOS(0),  INITIAL_YPOS(3), INI_SA,      INI_BACK,    INI_RO,    INI_TI,     },
	{ ti_,  INITIAL_XPOS(1),  INITIAL_YPOS(3), INI_SI,      INI_BACK,    INI_TA,    INI_TU,     },
	{ tu_,  INITIAL_XPOS(2),  INITIAL_YPOS(3), INI_SU,      INI_BACK,    INI_TI,    INI_TE,     },
	{ te_,  INITIAL_XPOS(3),  INITIAL_YPOS(3), INI_SE,      INI_BACK,    INI_TU,    INI_TO,     },
	{ to_,  INITIAL_XPOS(4),  INITIAL_YPOS(3), INI_SO,      INI_BACK,    INI_TE,    INI_RA,     },
	{ na_,  INITIAL_XPOS(6),  INITIAL_YPOS(0), INI_DIS,     INI_HA,      INI_O,     INI_NI,     },
	{ ni_,  INITIAL_XPOS(7),  INITIAL_YPOS(0), INI_DIS,     INI_HI,      INI_NA,    INI_NU,     },
	{ nu_,  INITIAL_XPOS(8),  INITIAL_YPOS(0), INI_DIS,     INI_HU,      INI_NI,    INI_NE,     },
	{ ne_,  INITIAL_XPOS(9),  INITIAL_YPOS(0), INI_DIS,     INI_HE,      INI_NU,    INI_NO,     },
	{ no_,  INITIAL_XPOS(10), INITIAL_YPOS(0), INI_DIS,     INI_HO,      INI_NE,    INI_YA,     },
	{ ha_,  INITIAL_XPOS(6),  INITIAL_YPOS(1), INI_NA,      INI_MA,      INI_KO,    INI_HI,     },
	{ hi_,  INITIAL_XPOS(7),  INITIAL_YPOS(1), INI_NI,      INI_MI,      INI_HA,    INI_HU,     },
	{ hu_,  INITIAL_XPOS(8),  INITIAL_YPOS(1), INI_NU,      INI_MU,      INI_HI,    INI_HE,     },
	{ he_,  INITIAL_XPOS(9),  INITIAL_YPOS(1), INI_NE,      INI_ME,      INI_HU,    INI_HO,     },
	{ ho_,  INITIAL_XPOS(10), INITIAL_YPOS(1), INI_NO,      INI_MO,      INI_HE,    INI_WA,     },
	{ ma_,  INITIAL_XPOS(6),  INITIAL_YPOS(2), INI_HA,      INI_RA,      INI_SO,    INI_MI,     },
	{ mi_,  INITIAL_XPOS(7),  INITIAL_YPOS(2), INI_HI,      INI_RI,      INI_MA,    INI_MU,     },
	{ mu_,  INITIAL_XPOS(8),  INITIAL_YPOS(2), INI_HU,      INI_RU,      INI_MI,    INI_ME,     },
	{ me_,  INITIAL_XPOS(9),  INITIAL_YPOS(2), INI_HE,      INI_RE,      INI_MU,    INI_MO,     },
	{ mo_,  INITIAL_XPOS(10), INITIAL_YPOS(2), INI_HO,      INI_RO,      INI_ME,    INI_SA,     },
	{ ya_,  INITIAL_XPOS(12), INITIAL_YPOS(0), INI_DIS,     INI_WA,      INI_NO,    INI_YU,     },
	{ yu_,  INITIAL_XPOS(13), INITIAL_YPOS(0), INI_DIS,     INI_OTHER,   INI_YA,    INI_YO,     },
	{ yo_,  INITIAL_XPOS(14), INITIAL_YPOS(0), INI_DIS,     INI_OTHER,   INI_YU,    INI_A,      },
	{ ra_,  INITIAL_XPOS(6),  INITIAL_YPOS(3), INI_MA,      INI_BACK,    INI_TO,    INI_RI,     },
	{ ri_,  INITIAL_XPOS(7),  INITIAL_YPOS(3), INI_MI,      INI_BACK,    INI_RA,    INI_RU,     },
	{ ru_,  INITIAL_XPOS(8),  INITIAL_YPOS(3), INI_MU,      INI_BACK,    INI_RI,    INI_RE,     },
	{ re_,  INITIAL_XPOS(9),  INITIAL_YPOS(3), INI_ME,      INI_BACK,    INI_RU,    INI_RO,     },
	{ ro_,  INITIAL_XPOS(10), INITIAL_YPOS(3), INI_MO,      INI_BACK,    INI_RE,    INI_TA,     },
	{ wa_,  INITIAL_XPOS(12), INITIAL_YPOS(1), INI_YA,      INI_BACK,    INI_HO,    INI_OTHER,  },
	{ gyoe_,INITIAL_XPOS(13), INITIAL_YPOS(1), INI_YU,      INI_BACK,    INI_WA,    INI_KA,     },


};




//------------------------------------------------------------------
/**
 * CjVio[őԂ
 *
 * @retval  u32		
 */
//------------------------------------------------------------------
u32 PMSI_INITIAL_DAT_GetInitialMax( void )
{
	return NELEMS(InitialParamTbl);
}

//------------------------------------------------------------------
/**
 * P̕R[hobt@ɃRs[
 *
 * @param   initial		CjVio[
 * @param   buf			Rs[obt@
 *
 */
//------------------------------------------------------------------
void PMSI_INITIAL_DAT_GetStr( u32 initial, STRBUF* buf )
{
	GF_ASSERT(initial < NELEMS(InitialParamTbl));

	STRBUF_SetStringCodeOrderLength( buf, &(InitialParamTbl[initial].code), 2);
}

//------------------------------------------------------------------
/**
 * `pʒuihbgPʁj擾
 *
 * @param   initial		CjVio[
 * @param   x			`ʒuw
 * @param   y			`ʒux
 *
 */
//------------------------------------------------------------------
void PMSI_INITIAL_DAT_GetPrintPos( u32 initial, u32* x, u32* y )
{
	GF_ASSERT_MSG((initial < NELEMS(InitialParamTbl)), "pos=%d", initial);

	*x = InitialParamTbl[initial].xpos;
	*y = InitialParamTbl[initial].ypos;
}

//------------------------------------------------------------------
/**
 * L[̈ړCjVio[Ԃ
 *
 * @param   initial		CjVio[
 *
 * @retval  int		ړCjVio[
 */
//------------------------------------------------------------------
int PMSI_INITIAL_DAT_GetUpCode( u32 initial )
{
	GF_ASSERT(initial < NELEMS(InitialParamTbl));
	return InitialParamTbl[initial].up;
}

//------------------------------------------------------------------
/**
 * L[̈ړCjVio[Ԃ
 *
 * @param   initial		CjVio[
 *
 * @retval  int		ړCjVio[
 */
//------------------------------------------------------------------
int PMSI_INITIAL_DAT_GetDownCode( u32 initial )
{
	GF_ASSERT(initial < NELEMS(InitialParamTbl));
	return InitialParamTbl[initial].down;
}

//------------------------------------------------------------------
/**
 * L[̈ړCjVio[Ԃ
 *
 * @param   initial		CjVio[
 *
 * @retval  int		ړCjVio[
 */
//------------------------------------------------------------------
int PMSI_INITIAL_DAT_GetLeftCode( u32 initial )
{
	GF_ASSERT(initial < NELEMS(InitialParamTbl));
	return InitialParamTbl[initial].left;
}

//------------------------------------------------------------------
/**
 * EL[̈ړCjVio[Ԃ
 *
 * @param   initial		CjVio[
 *
 * @retval  int		ړCjVio[
 */
//------------------------------------------------------------------
int PMSI_INITIAL_DAT_GetRightCode( u32 initial )
{
	GF_ASSERT(initial < NELEMS(InitialParamTbl));
	return InitialParamTbl[initial].right;
}
