

#include "common.h"
#include "system\pms_data.h"
#include "savedata\zukanwork.h"

#include "pms_input_prv.h"

//==================================================================================
//==================================================================================
enum {
	PMS_TYPE_DEFAULT = PMS_TYPE_MAIL,
};

//==================================================================================
//==================================================================================

struct _PMSI_PARAM {
	u8   input_mode;
	u8   guidance_type;			///< ^Cvienum PMS_INPUT_GUIDANCEj

	// [out]
	u8  cancel_flag;			///< u߂vŃLZꂽtO
	u8  modified_flag;			///< LZꂸAeXVꂽtO


	u8  game_clear_flag;

	const ZUKAN_WORK*  zukan_savedata;

	PMS_DATA   pms;		// ̓[hp
	PMS_WORD   word[PMS_INPUT_WORD_MAX];	// Pꃂ[hp
};


//==============================================================
// Prototype
//==============================================================








//==============================================================================================
//	͉ʂĂяõp[^
//==============================================================================================

//------------------------------------------------------------------
/**
 * ȈՉb͉ʃp[^쐬
 *
 * @param   input_mode			̓[hienum PMSI_MODEj
 * @param   guidance_type		^Cvienum PMSI_GUIDANCEj
 * @param   savedata			Z[uf[^|C^
 * @param   heapID				쐬pq[vID
 *
 * @retval  PMSI_PARAM*			쐬ꂽp[^IuWFNgւ̃|C^
 */
//------------------------------------------------------------------
PMSI_PARAM*  PMSI_PARAM_Create( u32 input_mode, u32 guidance_type, SAVEDATA* savedata, u32 heapID )
{
	PMSI_PARAM* p = sys_AllocMemory( heapID, sizeof(PMSI_PARAM));

	p->input_mode = input_mode;
	p->guidance_type = guidance_type;
	p->zukan_savedata = SaveData_GetZukanWork(savedata);
	p->game_clear_flag = FALSE;


	p->cancel_flag = TRUE;
	p->modified_flag = FALSE;
	

	if(input_mode == PMSI_MODE_SENTENCE)
	{
		PMSDAT_Init( &p->pms, PMS_TYPE_DEFAULT );
	}
	else
	{
		int i;
		for(i=0; i<PMS_INPUT_WORD_MAX; i++)
		{
			p->word[i] = PMS_WORD_NULL;
		}
	}

	return p;
}
//------------------------------------------------------------------
/**
 * ȈՉb͉ʃp[^j
 *
 * @param   p		p[^IuWFNgւ̃|C^
 *
 */
//------------------------------------------------------------------
void PMSI_PARAM_Delete( PMSI_PARAM* p )
{
	sys_FreeMemoryEz(p);
}



//------------------------------------------------------------------
/**
 * ȈՉb͉ʂ̏ԂɎgpp[^ZbgiPP[hpj
 *
 * @param   p			p[^IuWFNg
 * @param   word		ZbgȈՉbPR[h
 *
 */
//------------------------------------------------------------------
void PMSI_PARAM_SetInitializeDataSingle( PMSI_PARAM* p, PMS_WORD word )
{
	p->word[0] = word;
}
//------------------------------------------------------------------
/**
 * ȈՉb͉ʂ̏ԂɎgpp[^ZbgiPQ[hpj
 *
 * @param   p			p[^IuWFNg
 * @param   word0		ZbgȈՉbPR[hP
 * @param   word1		ZbgȈՉbPR[hQ
 *
 */
//------------------------------------------------------------------
void PMSI_PARAM_SetInitializeDataDouble( PMSI_PARAM* p, PMS_WORD word0, PMS_WORD word1 )
{
	p->word[0] = word0;
	p->word[1] = word1;
}
//------------------------------------------------------------------
/**
 * ȈՉb͉ʂ̏ԂɎgpp[^Zbgi̓[hpj
 *
 * @param   p		p[^IuWFNg
 * @param   pms		ZbgȈՉbf[^|C^
 *
 */
//------------------------------------------------------------------
void PMSI_PARAM_SetInitializeDataSentence( PMSI_PARAM* p, const PMS_DATA* pms )
{
	p->pms = *pms;
}

//------------------------------------------------------------------
/**
 * ȈՉb͉ʂŁA͂LZꂽǂ
 *
 * @param   p			p[^IuWFNg
 *
 * @retval  BOOL		TRUEŃLZꂽ
 */
//------------------------------------------------------------------
BOOL PMSI_PARAM_CheckCanceled( const PMSI_PARAM* p )
{
	return p->cancel_flag;
}
//------------------------------------------------------------------
/**
 * ȈՉb͉ʂ̏IAԂύXȂꂽ`FbN
 *
 * @param   p			p[^IuWFNg
 *
 * @retval  BOOL		TRUEŕύXꂽ
 */
//------------------------------------------------------------------
BOOL PMSI_PARAM_CheckModified( const PMSI_PARAM* p )
{
	return p->modified_flag;
}


//------------------------------------------------------------------
/**
 * ͉ʂœ͂ꂽf[^擾iPP[hj
 *
 * @param   p			p[^IuWFNg
 *
 * @retval  PMS_WORD		̓f[^iPR[hj
 */
//------------------------------------------------------------------
PMS_WORD  PMSI_PARAM_GetInputDataSingle( const PMSI_PARAM* p )
{
	return p->word[0];
}

//------------------------------------------------------------------
/**
 * ͉ʂœ͂ꂽf[^擾iPQ[hj
 *
 * @param   p		p[^IuWFNg
 * @param   dst		͂ꂽf[^󂯎obt@
 *
 */
//------------------------------------------------------------------
void PMSI_PARAM_GetInputDataDouble( const PMSI_PARAM* p,  PMS_WORD* dst )
{
	dst[0] = p->word[0];
	dst[1] = p->word[1];
}

//------------------------------------------------------------------
/**
 * ͉ʂœ͂ꂽf[^擾i̓[hj
 *
 * @param   p		p[^IuWFNg
 * @param   pms		͂ꂽf[^󂯎\̃AhX
 *
 */
//------------------------------------------------------------------
void PMSI_PARAM_GetInputDataSentence( const PMSI_PARAM* p, PMS_DATA* pms )
{
	PMSDAT_Copy( pms, &(p->pms) );
}







//==============================================================================================
//	͉ʓ̃p[^
//==============================================================================================

u32 PMSI_PARAM_GetInputMode( const PMSI_PARAM* p )
{
	return p->input_mode;
}
u32 PMSI_PARAM_GetGuidanceType( const PMSI_PARAM* p )
{
	return p->guidance_type;
}

const ZUKAN_WORK*  PMSI_PARAM_GetZukanSaveData( const PMSI_PARAM* p )
{
	return p->zukan_savedata;
}

BOOL PMSI_PARAM_GetGameClearFlag( const PMSI_PARAM* p )
{
	return p->game_clear_flag;
}

void PMSI_PARAM_GetInitializeData( const PMSI_PARAM* p, PMS_WORD* word, PMS_DATA* pms )
{
	switch( p->input_mode ){
	case PMSI_MODE_SINGLE:
		word[0] = p->word[0];
		break;
	case PMSI_MODE_DOUBLE:
		word[0] = p->word[0];
		word[1] = p->word[1];
		break;
	case PMSI_MODE_SENTENCE:
		*pms = p->pms;
		break;
	}
}

BOOL PMSI_PARAM_CheckModifiedByEditDatas( const PMSI_PARAM* p, const PMS_WORD* word, const PMS_DATA* pms )
{
	switch( p->input_mode ){
	case PMSI_MODE_SINGLE:
		return word[0] == p->word[0];

	case PMSI_MODE_DOUBLE:
		return ((word[0] == p->word[0]) && (word[1] == p->word[1]));

	case PMSI_MODE_SENTENCE:
	default:
		return PMSDAT_Compare( &p->pms, pms );
	}

}

void PMSI_PARAM_WriteBackData( PMSI_PARAM* p, const PMS_WORD* word, const PMS_DATA* pms )
{
	int i;

	p->modified_flag = PMSI_PARAM_CheckModifiedByEditDatas(p, word, pms);
	p->cancel_flag = FALSE;

	for(i=0; i<PMS_INPUT_WORD_MAX; i++)
	{
		p->word[i] = word[i];
	}
	p->pms = *pms;
}
